/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.lucene.internal.builder;

import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import org.apache.lucene.search.Query;
import org.hibernate.hql.internal.util.Strings;
import org.hibernate.hql.lucene.internal.builder.PropertyHelper;
import org.hibernate.hql.lucene.internal.builder.predicate.ConjunctionPredicate;
import org.hibernate.hql.lucene.internal.builder.predicate.DisjunctionPredicate;
import org.hibernate.hql.lucene.internal.builder.predicate.EqualsPredicate;
import org.hibernate.hql.lucene.internal.builder.predicate.NegationPredicate;
import org.hibernate.hql.lucene.internal.builder.predicate.ParentPredicate;
import org.hibernate.hql.lucene.internal.builder.predicate.Predicate;
import org.hibernate.hql.lucene.internal.builder.predicate.RangePredicate;
import org.hibernate.hql.lucene.internal.builder.predicate.RootPredicate;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.QueryContextBuilder;

public class LuceneQueryBuilder {
    private final QueryContextBuilder queryContextBuilder;
    private final PropertyHelper propertyHelper;
    private QueryBuilder queryBuilder;
    private Class<?> entityType;
    private RootPredicate rootPredicate;
    private final Stack<ParentPredicate> predicates = new Stack();

    public LuceneQueryBuilder(QueryContextBuilder queryContextBuilder, PropertyHelper propertyHelper) {
        this.queryContextBuilder = queryContextBuilder;
        this.propertyHelper = propertyHelper;
    }

    public LuceneQueryBuilder setEntityType(Class<?> entityType) {
        this.queryBuilder = this.queryContextBuilder.forEntity(entityType).get();
        this.entityType = entityType;
        this.rootPredicate = new RootPredicate(this.queryBuilder);
        this.predicates.push(this.rootPredicate);
        return this;
    }

    public LuceneQueryBuilder addEqualsPredicate(String property, Object value) {
        return this.addEqualsPredicate(Arrays.asList(property), value);
    }

    public LuceneQueryBuilder addEqualsPredicate(List<String> propertyPath, Object value) {
        Object typedValue = this.propertyHelper.convertToPropertyType(value, this.entityType, propertyPath);
        this.pushPredicate(new EqualsPredicate(this.queryBuilder, Strings.join(propertyPath, (String)"."), typedValue));
        return this;
    }

    public LuceneQueryBuilder addRangePredicate(String property, Object lower, Object upper) {
        return this.addRangePredicate(Arrays.asList(property), lower, upper);
    }

    public LuceneQueryBuilder addRangePredicate(List<String> propertyPath, Object lower, Object upper) {
        Object lowerValue = this.propertyHelper.convertToPropertyType(lower, this.entityType, propertyPath);
        Object upperValue = this.propertyHelper.convertToPropertyType(upper, this.entityType, propertyPath);
        this.pushPredicate(new RangePredicate(this.queryBuilder, Strings.join(propertyPath, (String)"."), lowerValue, upperValue));
        return this;
    }

    public LuceneQueryBuilder pushAndPredicate() {
        this.pushPredicate(new ConjunctionPredicate(this.queryBuilder));
        return this;
    }

    public LuceneQueryBuilder pushOrPredicate() {
        this.pushPredicate(new DisjunctionPredicate(this.queryBuilder));
        return this;
    }

    public LuceneQueryBuilder pushNotPredicate() {
        this.pushPredicate(new NegationPredicate(this.queryBuilder));
        return this;
    }

    private void pushPredicate(Predicate predicate) {
        this.predicates.peek().add(predicate);
        if (predicate.getType().isParent()) {
            this.predicates.push(predicate.as(ParentPredicate.class));
        }
    }

    public LuceneQueryBuilder popBooleanPredicate() {
        this.predicates.pop();
        return this;
    }

    public Query build() {
        return this.rootPredicate.getQuery();
    }

    public String toString() {
        return "LuceneQueryBuilder [entityType=" + this.entityType + ", rootPredicate=" + this.rootPredicate + "]";
    }
}

