/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.lucene.internal.builder;

import java.util.EnumSet;
import java.util.List;
import org.apache.lucene.document.Field;
import org.hibernate.hql.internal.util.Strings;
import org.hibernate.hql.lucene.internal.logging.Log;
import org.hibernate.hql.lucene.internal.logging.LoggerFactory;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.builtin.DoubleNumericFieldBridge;
import org.hibernate.search.bridge.builtin.FloatNumericFieldBridge;
import org.hibernate.search.bridge.builtin.IntegerNumericFieldBridge;
import org.hibernate.search.bridge.builtin.LongNumericFieldBridge;
import org.hibernate.search.bridge.builtin.impl.TwoWayString2FieldBridgeAdaptor;
import org.hibernate.search.engine.spi.AbstractDocumentBuilder;
import org.hibernate.search.engine.spi.EntityIndexBinder;
import org.hibernate.search.spi.SearchFactoryIntegrator;

public class PropertyHelper {
    private static final Log log = LoggerFactory.make();
    private final SearchFactoryIntegrator searchFactory;

    public PropertyHelper(SearchFactoryIntegrator searchFactory) {
        this.searchFactory = searchFactory;
    }

    public Object convertToPropertyType(Object value, Class<?> entityType, List<String> propertyPath) {
        return this.convertToPropertyType(value, entityType, propertyPath.toArray(new String[propertyPath.size()]));
    }

    public Object convertToPropertyType(Object value, Class<?> entityType, String ... propertyPath) {
        FieldBridge bridge = this.getFieldBridge(entityType, propertyPath);
        if (!(value instanceof String)) {
            return value;
        }
        String stringValue = (String)value;
        if (bridge instanceof TwoWayString2FieldBridgeAdaptor) {
            return ((TwoWayString2FieldBridgeAdaptor)bridge).unwrap().stringToObject(stringValue);
        }
        if (bridge instanceof IntegerNumericFieldBridge) {
            return Integer.parseInt(stringValue);
        }
        if (bridge instanceof LongNumericFieldBridge) {
            return Long.parseLong(stringValue);
        }
        if (bridge instanceof FloatNumericFieldBridge) {
            return Float.valueOf(Float.parseFloat(stringValue));
        }
        if (bridge instanceof DoubleNumericFieldBridge) {
            return Double.parseDouble(stringValue);
        }
        return value;
    }

    private FieldBridge getFieldBridge(Class<?> type, String ... propertyPath) {
        EntityIndexBinder entityIndexBinding = this.getIndexBinding(type);
        if (this.isIdentifierProperty(entityIndexBinding, propertyPath)) {
            return entityIndexBinding.getDocumentBuilder().getIdBridge();
        }
        AbstractDocumentBuilder.PropertiesMetadata metadata = this.getPropertyMetadata(entityIndexBinding, propertyPath);
        String fullPropertyName = Strings.join((String[])propertyPath, (String)".");
        return (FieldBridge)metadata.fieldBridges.get(metadata.fieldNames.indexOf(fullPropertyName));
    }

    public boolean exists(Class<?> type, List<String> propertyPath) {
        return this.exists(type, propertyPath.toArray(new String[propertyPath.size()]));
    }

    public boolean exists(Class<?> type, String ... propertyPath) {
        EntityIndexBinder entityIndexBinding = this.getIndexBinding(type);
        if (this.isIdentifierProperty(entityIndexBinding, propertyPath)) {
            return true;
        }
        AbstractDocumentBuilder.PropertiesMetadata metadata = entityIndexBinding.getDocumentBuilder().getMetadata();
        String fullPropertyName = Strings.join((String[])propertyPath, (String)".");
        for (String property : propertyPath) {
            boolean isField;
            int embeddedPropertyIndex = metadata.embeddedFieldNames.indexOf(property);
            boolean isEmbedded = embeddedPropertyIndex != -1;
            boolean bl = isField = metadata.fieldNames.indexOf(fullPropertyName) != -1;
            if (!isEmbedded && !isField) {
                return false;
            }
            if (!isEmbedded) continue;
            metadata = (AbstractDocumentBuilder.PropertiesMetadata)metadata.embeddedPropertiesMetadata.get(embeddedPropertyIndex);
        }
        return true;
    }

    public boolean isAnalyzed(Class<?> type, List<String> propertyPath) {
        return this.isAnalyzed(type, propertyPath.toArray(new String[propertyPath.size()]));
    }

    public boolean isAnalyzed(Class<?> type, String ... propertyPath) {
        EntityIndexBinder entityIndexBinding = this.getIndexBinding(type);
        if (this.isIdentifierProperty(entityIndexBinding, propertyPath)) {
            return false;
        }
        AbstractDocumentBuilder.PropertiesMetadata metadata = this.getPropertyMetadata(entityIndexBinding, propertyPath);
        String fullPropertyName = Strings.join((String[])propertyPath, (String)".");
        Field.Index index = (Field.Index)metadata.fieldIndex.get(metadata.fieldNames.indexOf(fullPropertyName));
        return EnumSet.of(Field.Index.ANALYZED, Field.Index.ANALYZED_NO_NORMS).contains(index);
    }

    public boolean isEmbedded(Class<?> type, List<String> propertyPath) {
        return this.isEmbedded(type, propertyPath.toArray(new String[propertyPath.size()]));
    }

    public boolean isEmbedded(Class<?> type, String ... propertyPath) {
        EntityIndexBinder entityIndexBinding = this.getIndexBinding(type);
        if (this.isIdentifierProperty(entityIndexBinding, propertyPath)) {
            return false;
        }
        String fullPropertyName = Strings.join((String[])propertyPath, (String)".");
        AbstractDocumentBuilder.PropertiesMetadata metadata = entityIndexBinding.getDocumentBuilder().getMetadata();
        for (String property : propertyPath) {
            if (metadata.embeddedFieldNames.contains(fullPropertyName)) {
                return true;
            }
            int embeddedPropertyIndex = metadata.embeddedFieldNames.indexOf(property);
            if (embeddedPropertyIndex == -1) break;
            metadata = (AbstractDocumentBuilder.PropertiesMetadata)metadata.embeddedPropertiesMetadata.get(embeddedPropertyIndex);
        }
        return false;
    }

    private AbstractDocumentBuilder.PropertiesMetadata getPropertyMetadata(EntityIndexBinder entityIndexBinding, String ... propertyPath) {
        String property;
        int embeddedPropertyIndex;
        AbstractDocumentBuilder.PropertiesMetadata metadata = entityIndexBinding.getDocumentBuilder().getMetadata();
        String[] arr$ = propertyPath;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (embeddedPropertyIndex = metadata.embeddedFieldNames.indexOf(property = arr$[i$])) != -1; ++i$) {
            metadata = (AbstractDocumentBuilder.PropertiesMetadata)metadata.embeddedPropertiesMetadata.get(embeddedPropertyIndex);
        }
        return metadata;
    }

    private boolean isIdentifierProperty(EntityIndexBinder entityIndexBinding, String ... propertyPath) {
        return propertyPath.length == 1 && propertyPath[0].equals(entityIndexBinding.getDocumentBuilder().getIdentifierName());
    }

    private EntityIndexBinder getIndexBinding(Class<?> type) {
        EntityIndexBinder entityIndexBinding = this.searchFactory.getIndexBindingForEntity(type);
        if (entityIndexBinding == null) {
            throw log.getNoIndexedEntityException(type.getCanonicalName());
        }
        return entityIndexBinding;
    }
}

