/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.lucene.internal.builder.predicate;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.Query;
import org.hibernate.hql.lucene.internal.builder.predicate.AbstractPredicate;
import org.hibernate.hql.lucene.internal.builder.predicate.NegationPredicate;
import org.hibernate.hql.lucene.internal.builder.predicate.ParentPredicate;
import org.hibernate.hql.lucene.internal.builder.predicate.Predicate;
import org.hibernate.search.query.dsl.BooleanJunction;
import org.hibernate.search.query.dsl.QueryBuilder;

public class ConjunctionPredicate
extends AbstractPredicate
implements ParentPredicate {
    private final QueryBuilder builder;
    private final List<Predicate> children = new ArrayList<Predicate>();

    public ConjunctionPredicate(QueryBuilder builder) {
        super(Predicate.Type.CONJUNCTION);
        this.builder = builder;
    }

    @Override
    public Query getQuery() {
        BooleanJunction booleanJunction = this.builder.bool();
        for (Predicate predicate : this.children) {
            if (predicate.getType() == Predicate.Type.NEGATION) {
                booleanJunction.must(predicate.as(NegationPredicate.class).getChild().getQuery()).not();
                continue;
            }
            booleanJunction.must(predicate.getQuery());
        }
        return booleanJunction.createQuery();
    }

    @Override
    public void add(Predicate predicate) {
        this.children.add(predicate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("( AND ");
        for (Predicate child : this.children) {
            sb.append(child.toString()).append(" ");
        }
        sb.append(" )");
        return sb.toString();
    }
}

