/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.lucene.internal.builder.predicate;

import org.apache.lucene.search.Query;
import org.hibernate.hql.lucene.internal.builder.predicate.AbstractPredicate;
import org.hibernate.hql.lucene.internal.builder.predicate.Predicate;
import org.hibernate.search.query.dsl.QueryBuilder;

public class EqualsPredicate
extends AbstractPredicate {
    private final QueryBuilder builder;
    private final String propertyName;
    private final Object value;

    public EqualsPredicate(QueryBuilder builder, String propertyName, Object value) {
        super(Predicate.Type.EQUALS);
        this.builder = builder;
        this.propertyName = propertyName;
        this.value = value;
    }

    @Override
    public Query getQuery() {
        return this.builder.keyword().onField(this.propertyName).matching(this.value).createQuery();
    }

    public String toString() {
        return "( EQUALS " + this.propertyName + " " + this.value + " )";
    }
}

