/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.lucene.internal.builder.predicate;

import org.apache.lucene.search.Query;
import org.hibernate.hql.lucene.internal.builder.predicate.AbstractPredicate;
import org.hibernate.hql.lucene.internal.builder.predicate.ParentPredicate;
import org.hibernate.hql.lucene.internal.builder.predicate.Predicate;
import org.hibernate.hql.lucene.internal.logging.Log;
import org.hibernate.hql.lucene.internal.logging.LoggerFactory;
import org.hibernate.search.query.dsl.QueryBuilder;

public class NegationPredicate
extends AbstractPredicate
implements ParentPredicate {
    private static final Log log = LoggerFactory.make();
    private final QueryBuilder builder;
    private Predicate child;

    public NegationPredicate(QueryBuilder builder) {
        super(Predicate.Type.NEGATION);
        this.builder = builder;
    }

    @Override
    public Query getQuery() {
        return this.builder.bool().must(this.getChild().getQuery()).not().createQuery();
    }

    @Override
    public void add(Predicate predicate) {
        if (this.child != null) {
            throw log.getNotMoreThanOnePredicateInNegationAllowedException(predicate);
        }
        this.child = predicate;
    }

    public Predicate getChild() {
        return this.child;
    }

    public String toString() {
        return "( NOT " + this.getChild() + " )";
    }
}

