/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.lucene.internal.builder.predicate;

import org.apache.lucene.search.Query;
import org.hibernate.hql.lucene.internal.builder.predicate.AbstractPredicate;
import org.hibernate.hql.lucene.internal.builder.predicate.Predicate;
import org.hibernate.search.query.dsl.QueryBuilder;

public class RangePredicate
extends AbstractPredicate {
    private final QueryBuilder builder;
    private final String propertyName;
    private final Object lower;
    private final Object upper;

    public RangePredicate(QueryBuilder builder, String propertyName, Object lower, Object upper) {
        super(Predicate.Type.RANGE);
        this.builder = builder;
        this.propertyName = propertyName;
        this.lower = lower;
        this.upper = upper;
    }

    @Override
    public Query getQuery() {
        return this.builder.range().onField(this.propertyName).from(this.lower).to(this.upper).createQuery();
    }

    public String toString() {
        return "( BETWEEN " + this.propertyName + " " + this.lower + " " + this.upper + " )";
    }
}

