/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.lucene.internal.builder.predicate;

import org.apache.lucene.search.Query;
import org.hibernate.hql.lucene.internal.builder.predicate.AbstractPredicate;
import org.hibernate.hql.lucene.internal.builder.predicate.ParentPredicate;
import org.hibernate.hql.lucene.internal.builder.predicate.Predicate;
import org.hibernate.hql.lucene.internal.logging.Log;
import org.hibernate.hql.lucene.internal.logging.LoggerFactory;
import org.hibernate.search.query.dsl.QueryBuilder;

public class RootPredicate
extends AbstractPredicate
implements ParentPredicate {
    private static final Log log = LoggerFactory.make();
    private final QueryBuilder builder;
    private Predicate child;

    public RootPredicate(QueryBuilder builder) {
        super(Predicate.Type.ROOT);
        this.builder = builder;
    }

    @Override
    public void add(Predicate predicate) {
        if (this.child != null) {
            throw log.getNotMoreThanOnePredicateInRootOfWhereClauseAllowedException(predicate);
        }
        this.child = predicate;
    }

    @Override
    public Query getQuery() {
        return this.child == null ? this.builder.all().createQuery() : this.child.getQuery();
    }

    public String toString() {
        return this.child == null ? "( * )" : this.child.toString();
    }
}

