// $ANTLR 3.4 org/hibernate/hql/ast/origin/hql/parse/HQLParser.g 2014-11-21 16:04:24

/*
 * Hibernate, Relational Persistence for Idiomatic Java
 *
 * Copyright (c) 2008-2012, Red Hat Inc. or third-party contributors as
 * indicated by the @author tags or express copyright attribution
 * statements applied by the authors.  All third-party contributions are
 * distributed under license by Red Hat Inc.
 *
 * This copyrighted material is made available to anyone wishing to use, modify,
 * copy, or redistribute it subject to the terms and conditions of the GNU
 * Lesser General Public License, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this distribution; if not, write to:
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301  USA
 *
 * Portions of SQL grammar parsing copyright (C) 2003 by Lubos Vnuk.  All rights
 * reserved.  These portions are distributed under license by Red Hat Inc. and
 * are covered by the above LGPL notice.  If you redistribute this material,
 * with or without modification, you must preserve this copyright notice in its
 * entirety.
 */
package org.hibernate.hql.ast.origin.hql.parse;

import java.util.LinkedList;
import java.util.Iterator;
import org.hibernate.hql.ast.common.ParserContext;
import org.hibernate.hql.ast.tree.EntityNameTree;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;

import org.antlr.runtime.tree.*;


@SuppressWarnings({"all", "warnings", "unchecked"})
public class HQLParser extends Parser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "ABS", "ALIAS_NAME", "ALIAS_REF", "ALL", "AMPERSAND", "AND", "ANY", "ARROW", "AS", "ASTERISK", "AVG", "BETWEEN", "BETWEEN_LIST", "BIT_LENGTH", "BOTH", "CAST", "CHARACTER_LENGTH", "CHARACTER_LITERAL", "CLASS", "COALESCE", "COLLATE", "COLLECTION_EXPRESSION", "COLON", "COLUMN", "COLUMN_LIST", "COMMA", "CONCAT", "CONST_STRING_VALUE", "COUNT", "CROSS", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "DAY", "DECIMAL_LITERAL", "DELETE", "DISTINCT", "DOT", "DOT_CLASS", "DOUBLE_PIPE", "DYNAMIC_INSTANTIATION", "DYNAMIC_INSTANTIATION_ARG", "ELEMENTS", "ELSE", "END", "ENTITY_NAME", "ENTITY_PERSISTER_REF", "EOL", "EQUALS", "ESCAPE", "ESCAPE_SEQUENCE", "EXCEPT", "EXISTS", "EXPONENT", "EXTRACT", "FALSE", "FETCH", "FILTER", "FLOATING_POINT_LITERAL", "FLOAT_TYPE_SUFFIX", "FROM", "FULL", "FUNCTION", "GREATER", "GREATER_EQUAL", "GROUPING_VALUE", "GROUP_BY", "HAVING", "HEX_DIGIT", "HEX_LITERAL", "HOUR", "IDENTIFIER", "IN", "INDEX", "INDICES", "INNER", "INSERT", "INSERTABILITY_SPEC", "INTEGER_LITERAL", "INTEGER_TYPE_SUFFIX", "INTERSECT", "INTO", "IN_LIST", "IS", "IS_EMPTY", "IS_NOT_EMPTY", "IS_NOT_NULL", "IS_NULL", "JAVA_CONSTANT", "JOIN", "JPA_PARAM", "LEADING", "LEFT", "LEFT_PAREN", "LEFT_SQUARE", "LENGTH", "LESS", "LESS_EQUAL", "LIKE", "LOCATE", "LOWER", "MAX", "MAXELEMENT", "MAXINDEX", "MEMBER_OF", "MIN", "MINELEMENT", "MININDEX", "MINUS", "MINUTE", "MOD", "MONTH", "NAMED_PARAM", "NEW", "NOT", "NOT_BETWEEN", "NOT_EQUAL", "NOT_IN", "NOT_LIKE", "NOT_MEMBER_OF", "NULL", "NULLIF", "OCTAL_ESCAPE", "OCTAL_LITERAL", "OCTET_LENGTH", "ON", "OR", "ORDER_BY", "ORDER_SPEC", "OUTER", "PARAM", "PATH", "PERCENT", "PERSISTER_JOIN", "PERSISTER_SPACE", "PIPE", "PLUS", "POSITION", "PROPERTIES", "PROPERTY_JOIN", "PROPERTY_REFERENCE", "PROP_FETCH", "QUALIFIED_JOIN", "QUERY", "QUERY_SPEC", "QUOTED_IDENTIFIER", "RIGHT", "RIGHT_PAREN", "RIGHT_SQUARE", "SEARCHED_CASE", "SECOND", "SELECT", "SELECT_FROM", "SELECT_ITEM", "SELECT_LIST", "SEMICOLON", "SET", "SIMPLE_CASE", "SIZE", "SOLIDUS", "SOME", "SORT_SPEC", "SQRT", "STRING_LITERAL", "SUBSTRING", "SUB_QUERY", "SUM", "TABLE", "THEN", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TRAILING", "TRIM", "TRUE", "UNARY_MINUS", "UNARY_PLUS", "UNICODE_ESCAPE", "UNION", "UPDATE", "UPPER", "VECTOR_EXPR", "VERSIONED", "VERSIONED_VALUE", "WHEN", "WHERE", "WITH", "WS", "YEAR"
    };

    public static final int EOF=-1;
    public static final int ABS=4;
    public static final int ALIAS_NAME=5;
    public static final int ALIAS_REF=6;
    public static final int ALL=7;
    public static final int AMPERSAND=8;
    public static final int AND=9;
    public static final int ANY=10;
    public static final int ARROW=11;
    public static final int AS=12;
    public static final int ASTERISK=13;
    public static final int AVG=14;
    public static final int BETWEEN=15;
    public static final int BETWEEN_LIST=16;
    public static final int BIT_LENGTH=17;
    public static final int BOTH=18;
    public static final int CAST=19;
    public static final int CHARACTER_LENGTH=20;
    public static final int CHARACTER_LITERAL=21;
    public static final int CLASS=22;
    public static final int COALESCE=23;
    public static final int COLLATE=24;
    public static final int COLLECTION_EXPRESSION=25;
    public static final int COLON=26;
    public static final int COLUMN=27;
    public static final int COLUMN_LIST=28;
    public static final int COMMA=29;
    public static final int CONCAT=30;
    public static final int CONST_STRING_VALUE=31;
    public static final int COUNT=32;
    public static final int CROSS=33;
    public static final int CURRENT_DATE=34;
    public static final int CURRENT_TIME=35;
    public static final int CURRENT_TIMESTAMP=36;
    public static final int DAY=37;
    public static final int DECIMAL_LITERAL=38;
    public static final int DELETE=39;
    public static final int DISTINCT=40;
    public static final int DOT=41;
    public static final int DOT_CLASS=42;
    public static final int DOUBLE_PIPE=43;
    public static final int DYNAMIC_INSTANTIATION=44;
    public static final int DYNAMIC_INSTANTIATION_ARG=45;
    public static final int ELEMENTS=46;
    public static final int ELSE=47;
    public static final int END=48;
    public static final int ENTITY_NAME=49;
    public static final int ENTITY_PERSISTER_REF=50;
    public static final int EOL=51;
    public static final int EQUALS=52;
    public static final int ESCAPE=53;
    public static final int ESCAPE_SEQUENCE=54;
    public static final int EXCEPT=55;
    public static final int EXISTS=56;
    public static final int EXPONENT=57;
    public static final int EXTRACT=58;
    public static final int FALSE=59;
    public static final int FETCH=60;
    public static final int FILTER=61;
    public static final int FLOATING_POINT_LITERAL=62;
    public static final int FLOAT_TYPE_SUFFIX=63;
    public static final int FROM=64;
    public static final int FULL=65;
    public static final int FUNCTION=66;
    public static final int GREATER=67;
    public static final int GREATER_EQUAL=68;
    public static final int GROUPING_VALUE=69;
    public static final int GROUP_BY=70;
    public static final int HAVING=71;
    public static final int HEX_DIGIT=72;
    public static final int HEX_LITERAL=73;
    public static final int HOUR=74;
    public static final int IDENTIFIER=75;
    public static final int IN=76;
    public static final int INDEX=77;
    public static final int INDICES=78;
    public static final int INNER=79;
    public static final int INSERT=80;
    public static final int INSERTABILITY_SPEC=81;
    public static final int INTEGER_LITERAL=82;
    public static final int INTEGER_TYPE_SUFFIX=83;
    public static final int INTERSECT=84;
    public static final int INTO=85;
    public static final int IN_LIST=86;
    public static final int IS=87;
    public static final int IS_EMPTY=88;
    public static final int IS_NOT_EMPTY=89;
    public static final int IS_NOT_NULL=90;
    public static final int IS_NULL=91;
    public static final int JAVA_CONSTANT=92;
    public static final int JOIN=93;
    public static final int JPA_PARAM=94;
    public static final int LEADING=95;
    public static final int LEFT=96;
    public static final int LEFT_PAREN=97;
    public static final int LEFT_SQUARE=98;
    public static final int LENGTH=99;
    public static final int LESS=100;
    public static final int LESS_EQUAL=101;
    public static final int LIKE=102;
    public static final int LOCATE=103;
    public static final int LOWER=104;
    public static final int MAX=105;
    public static final int MAXELEMENT=106;
    public static final int MAXINDEX=107;
    public static final int MEMBER_OF=108;
    public static final int MIN=109;
    public static final int MINELEMENT=110;
    public static final int MININDEX=111;
    public static final int MINUS=112;
    public static final int MINUTE=113;
    public static final int MOD=114;
    public static final int MONTH=115;
    public static final int NAMED_PARAM=116;
    public static final int NEW=117;
    public static final int NOT=118;
    public static final int NOT_BETWEEN=119;
    public static final int NOT_EQUAL=120;
    public static final int NOT_IN=121;
    public static final int NOT_LIKE=122;
    public static final int NOT_MEMBER_OF=123;
    public static final int NULL=124;
    public static final int NULLIF=125;
    public static final int OCTAL_ESCAPE=126;
    public static final int OCTAL_LITERAL=127;
    public static final int OCTET_LENGTH=128;
    public static final int ON=129;
    public static final int OR=130;
    public static final int ORDER_BY=131;
    public static final int ORDER_SPEC=132;
    public static final int OUTER=133;
    public static final int PARAM=134;
    public static final int PATH=135;
    public static final int PERCENT=136;
    public static final int PERSISTER_JOIN=137;
    public static final int PERSISTER_SPACE=138;
    public static final int PIPE=139;
    public static final int PLUS=140;
    public static final int POSITION=141;
    public static final int PROPERTIES=142;
    public static final int PROPERTY_JOIN=143;
    public static final int PROPERTY_REFERENCE=144;
    public static final int PROP_FETCH=145;
    public static final int QUALIFIED_JOIN=146;
    public static final int QUERY=147;
    public static final int QUERY_SPEC=148;
    public static final int QUOTED_IDENTIFIER=149;
    public static final int RIGHT=150;
    public static final int RIGHT_PAREN=151;
    public static final int RIGHT_SQUARE=152;
    public static final int SEARCHED_CASE=153;
    public static final int SECOND=154;
    public static final int SELECT=155;
    public static final int SELECT_FROM=156;
    public static final int SELECT_ITEM=157;
    public static final int SELECT_LIST=158;
    public static final int SEMICOLON=159;
    public static final int SET=160;
    public static final int SIMPLE_CASE=161;
    public static final int SIZE=162;
    public static final int SOLIDUS=163;
    public static final int SOME=164;
    public static final int SORT_SPEC=165;
    public static final int SQRT=166;
    public static final int STRING_LITERAL=167;
    public static final int SUBSTRING=168;
    public static final int SUB_QUERY=169;
    public static final int SUM=170;
    public static final int TABLE=171;
    public static final int THEN=172;
    public static final int TIMEZONE_HOUR=173;
    public static final int TIMEZONE_MINUTE=174;
    public static final int TRAILING=175;
    public static final int TRIM=176;
    public static final int TRUE=177;
    public static final int UNARY_MINUS=178;
    public static final int UNARY_PLUS=179;
    public static final int UNICODE_ESCAPE=180;
    public static final int UNION=181;
    public static final int UPDATE=182;
    public static final int UPPER=183;
    public static final int VECTOR_EXPR=184;
    public static final int VERSIONED=185;
    public static final int VERSIONED_VALUE=186;
    public static final int WHEN=187;
    public static final int WHERE=188;
    public static final int WITH=189;
    public static final int WS=190;
    public static final int YEAR=191;

    // delegates
    public Parser[] getDelegates() {
        return new Parser[] {};
    }

    // delegators


    public HQLParser(TokenStream input) {
        this(input, new RecognizerSharedState());
    }
    public HQLParser(TokenStream input, RecognizerSharedState state) {
        super(input, state);
    }

protected TreeAdaptor adaptor = new CommonTreeAdaptor();

public void setTreeAdaptor(TreeAdaptor adaptor) {
    this.adaptor = adaptor;
}
public TreeAdaptor getTreeAdaptor() {
    return adaptor;
}
    public String[] getTokenNames() { return HQLParser.tokenNames; }
    public String getGrammarFileName() { return "org/hibernate/hql/ast/origin/hql/parse/HQLParser.g"; }


    	private Stack enableParameterUsage = new Stack();
    	private ParserContext context = new org.hibernate.hql.ast.DefaultParsingContext();
    	private List errorMessages = new LinkedList();

    	public void setParserContext(ParserContext context){
    		this.context = context;
    	}

    	private boolean validateSoftKeyword(String text) {
    		return validateLT( 1, text );
    	}

    	private boolean validateLT(int offset, String text) {
    		String text2Validate = retrieveLT( offset );
    		return text2Validate == null ? false : text2Validate.equalsIgnoreCase( text );
    	}

    	private String retrieveLT(int offset) {
    		if ( null == input ) {
    			return null;
    		}
    		Token token = input.LT( offset );
    		return token == null ? null : token.getText();
    	}

    	public boolean hasErrors() {
    		return errorMessages.size() > 0;
    	}

    	public List getErrorMessages() {
    		return errorMessages;
    	}

    	public void reportError(RecognitionException e) {
    		errorMessages.add(
    			generateError(
    				getRuleInvocationStack( e, this.getClass().getName() ),
    					this.getTokenNames(),
    					e
    				)
    		);
    		super.reportError( e );
    	}

    	private String generateError( List invocationStack, String[] tokenNames, RecognitionException e) {
    			String localization = invocationStack + ": line " + e.line + ":" + e.charPositionInLine + " ";
    			return generateError( localization, tokenNames, e );
    	}

    	private String generateError( String localization, String[] tokenNames, RecognitionException e) {
    		String message = "";
    		if ( e instanceof MismatchedTokenException ) {
    			MismatchedTokenException mte = (MismatchedTokenException) e;
    			String tokenName = "<unknown>";
    			if ( mte.expecting == Token.EOF ) {
    				tokenName = "EOF";
    			}
    			else {
    				if ( tokenNames != null ) {
    					tokenName = tokenNames[mte.expecting];
    				}
    			}
    			message = localization + "mismatched token: " + e.token + "; expecting type " + tokenName;
    		}
    		else if (e instanceof MismatchedTreeNodeException) {
    			MismatchedTreeNodeException mtne = (MismatchedTreeNodeException) e;
    			String tokenName = "<unknown>";
    			if ( mtne.expecting == Token.EOF ) {
    				tokenName = "EOF";
    			}
    			else {
    				tokenName = tokenNames[mtne.expecting];
    			}
    			message = localization + "mismatched tree node: " + mtne.node + "; expecting type " + tokenName;
    		}
    		else if (e instanceof NoViableAltException) {
    			NoViableAltException nvae = (NoViableAltException) e;
    			message = localization + "state " + nvae.stateNumber + " (decision=" + nvae.decisionNumber + ") no viable alt; token=" + e.token;
    		}
    		else if (e instanceof EarlyExitException) {
    			EarlyExitException eee = (EarlyExitException) e;
    			message = localization + "required (...)+ loop (decision=" + eee.decisionNumber + ") did not match anything; token=" + e.token;
    		}
    		else if (e instanceof MismatchedSetException) {
    			MismatchedSetException mse = (MismatchedSetException) e;
    			message = localization + "mismatched token: " + e.token + "; expecting set " + mse.expecting;
    		}
    		else if (e instanceof MismatchedNotSetException) {
    			MismatchedNotSetException mse = (MismatchedNotSetException) e;
    			message = localization + "mismatched token: " + e.token + "; expecting set " + mse.expecting;
    		}
    		else if (e instanceof FailedPredicateException) {
    			FailedPredicateException fpe = (FailedPredicateException) e;
    			message = localization + "rule " + fpe.ruleName + " failed predicate: {" + fpe.predicateText + "}?";
    		}
    		return message;
    	}

    	private List extractEntityNames(String entityName) throws RecognitionException {
    		List implementors = context.getEntityImplementors( entityName );
    		if ( implementors == null ) {
    			throw new RecognitionException();
    		}
    		return implementors;
    	}

    	private Tree generatePersisterSpacesTree(List persistenceSpaces) {
    		List persisterSpaceList = new ArrayList();
    		for ( Iterator iterator = persistenceSpaces.iterator(); iterator.hasNext(); ) {
    			Tree persistenceSpaceData = (Tree) iterator.next();
    			if ( persistenceSpaceData.getType() == PERSISTER_JOIN || persistenceSpaceData.getType() == PROPERTY_JOIN ) {
    				adaptor.addChild( persisterSpaceList.get( persisterSpaceList.size() - 1), persistenceSpaceData );
    			}
    			else {
    				Object persistenceSpaceTree = (Object) adaptor.nil();
    				persistenceSpaceTree = adaptor.becomeRoot( (Object) adaptor.create( PERSISTER_SPACE, "PERSISTER_SPACE" ), persistenceSpaceTree );
    				adaptor.addChild( persistenceSpaceTree, persistenceSpaceData );
    				persisterSpaceList.add( persistenceSpaceTree );
    			}
    		}
    		Tree resultTree = (Tree) adaptor.nil();
    		for ( Iterator iterator = persisterSpaceList.iterator(); iterator.hasNext(); ) {
    			Object persistenceElement = (Object) iterator.next();
    			adaptor.addChild( resultTree, persistenceElement );
    		}
    		return resultTree;
    	}

    	private Tree generateUpdateStatementTree(Object updateKey, Object entityName, Object aliasClause, Object setClause, Object whereClause) {
    		Tree result = new CommonTree();
    		EntityNameTree entityNameTree = (EntityNameTree) entityName;
    		for ( int i = 0; i < entityNameTree.getEntityCount(); i++ ) {
    			Tree updateRoot = new CommonTree( (CommonTree) updateKey );
    			updateRoot.addChild( new EntityNameTree( entityNameTree, entityNameTree.getEntityName( i ) ) );
    			if ( aliasClause != null ) {
    				updateRoot.addChild( (Tree) aliasClause );
    			}
    			updateRoot.addChild( (Tree) setClause );

    			if ( whereClause != null ) {
    				updateRoot.addChild( (Tree) whereClause );
    			}
    			result.addChild( updateRoot );
    		}
    		return result;
    	}

    	private Tree generateDeleteStatementTree(Object deleteKey, Object entityName, Object aliasClause, Object whereClause) {
    		Tree result = new CommonTree();
    		EntityNameTree entityNameTree = (EntityNameTree) entityName;
    		for ( int i = 0; i < entityNameTree.getEntityCount(); i++ ) {
    			Tree deleteRoot = new CommonTree( (CommonTree) deleteKey );
    			deleteRoot.addChild( new EntityNameTree( entityNameTree, entityNameTree.getEntityName( i ) ) );
    			if ( aliasClause != null ) {
    				deleteRoot.addChild( (Tree) aliasClause );
    			}
    			if ( whereClause != null ) {
    				deleteRoot.addChild( (Tree) whereClause );
    			}
    			result.addChild( deleteRoot );
    		}
    		return result;
    	}

    	/**
    	 * Provides a tree representing the SELECT clause. Will be the given SELECT clause if it is not {@code null},
    	 * otherwise a clause will be derived from the given FROM clause and aliases.
    	 */
    	private Tree generateSelectFromTree(Object selectClause, Object fromClause, List aliasList){
    		Tree result = new CommonTree( new CommonToken( SELECT_FROM, "SELECT_FROM" ) );
    		Tree selectTree = null;
    		result.addChild( (Tree) fromClause );
    		if (selectClause == null && aliasList != null && aliasList.size() > 0) {
    			selectTree = new CommonTree( new CommonToken( SELECT, "SELECT") );
    			Tree selectList = new CommonTree( new CommonToken( SELECT_LIST, "SELECT_LIST" ) );
    			for ( Iterator iterator = aliasList.iterator(); iterator.hasNext(); ) {
    				String aliasName = (String) iterator.next();
    				Tree selectElement = new CommonTree( new CommonToken( SELECT_ITEM, "SELECT_ITEM" ) );
    				Tree aliasElement = new CommonTree( new CommonToken( ALIAS_REF, aliasName ) );
    				selectElement.addChild( aliasElement );
    				selectList.addChild( selectElement );
    			}
    			selectTree.addChild( selectList );
    		}
    		else {
    			selectTree = (Tree) selectClause;
    		}
    		result.addChild( selectTree );
    		return result;
    	}


    public static class filterStatement_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "filterStatement"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:239:1: filterStatement[String collectionRole] : ( selectClause )? ( from_key )? ( whereClause )? ( groupByClause ( havingClause )? )? ( orderByClause )? -> ^( QUERY ^( QUERY_SPEC[\"filter-query-spec\"] FILTER[$collectionRole] ( selectClause )? ( from_key )? ( whereClause )? ( groupByClause ( havingClause )? )? ( orderByClause )? ) ) ;
    public final HQLParser.filterStatement_return filterStatement(String collectionRole) throws RecognitionException {
        HQLParser.filterStatement_return retval = new HQLParser.filterStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.selectClause_return selectClause1 =null;

        HQLParser.from_key_return from_key2 =null;

        HQLParser.whereClause_return whereClause3 =null;

        HQLParser.groupByClause_return groupByClause4 =null;

        HQLParser.havingClause_return havingClause5 =null;

        HQLParser.orderByClause_return orderByClause6 =null;


        RewriteRuleSubtreeStream stream_whereClause=new RewriteRuleSubtreeStream(adaptor,"rule whereClause");
        RewriteRuleSubtreeStream stream_orderByClause=new RewriteRuleSubtreeStream(adaptor,"rule orderByClause");
        RewriteRuleSubtreeStream stream_groupByClause=new RewriteRuleSubtreeStream(adaptor,"rule groupByClause");
        RewriteRuleSubtreeStream stream_havingClause=new RewriteRuleSubtreeStream(adaptor,"rule havingClause");
        RewriteRuleSubtreeStream stream_selectClause=new RewriteRuleSubtreeStream(adaptor,"rule selectClause");
        RewriteRuleSubtreeStream stream_from_key=new RewriteRuleSubtreeStream(adaptor,"rule from_key");
         if (state.backtracking == 0) enableParameterUsage.push(Boolean.TRUE); 
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:242:2: ( ( selectClause )? ( from_key )? ( whereClause )? ( groupByClause ( havingClause )? )? ( orderByClause )? -> ^( QUERY ^( QUERY_SPEC[\"filter-query-spec\"] FILTER[$collectionRole] ( selectClause )? ( from_key )? ( whereClause )? ( groupByClause ( havingClause )? )? ( orderByClause )? ) ) )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:242:4: ( selectClause )? ( from_key )? ( whereClause )? ( groupByClause ( havingClause )? )? ( orderByClause )?
            {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:242:4: ( selectClause )?
            int alt1=2;
            int LA1_0 = input.LA(1);

            if ( (LA1_0==IDENTIFIER) && ((((validateSoftKeyword("select")))||((validateSoftKeyword("where")))||((validateSoftKeyword("group") && validateLT(2, "by")))||((validateSoftKeyword("from")))||((validateSoftKeyword("order") && validateLT(2, "by")))))) {
                int LA1_1 = input.LA(2);

                if ( (((validateSoftKeyword("select")))) ) {
                    alt1=1;
                }
            }
            switch (alt1) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:242:4: selectClause
                    {
                    pushFollow(FOLLOW_selectClause_in_filterStatement59);
                    selectClause1=selectClause();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_selectClause.add(selectClause1.getTree());

                    }
                    break;

            }


            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:242:18: ( from_key )?
            int alt2=2;
            int LA2_0 = input.LA(1);

            if ( (LA2_0==IDENTIFIER) && ((((validateSoftKeyword("where")))||((validateSoftKeyword("group") && validateLT(2, "by")))||((validateSoftKeyword("from")))||((validateSoftKeyword("order") && validateLT(2, "by")))))) {
                int LA2_1 = input.LA(2);

                if ( (((validateSoftKeyword("from")))) ) {
                    alt2=1;
                }
            }
            switch (alt2) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:242:18: from_key
                    {
                    pushFollow(FOLLOW_from_key_in_filterStatement62);
                    from_key2=from_key();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_from_key.add(from_key2.getTree());

                    }
                    break;

            }


            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:242:28: ( whereClause )?
            int alt3=2;
            int LA3_0 = input.LA(1);

            if ( (LA3_0==IDENTIFIER) && ((((validateSoftKeyword("where")))||((validateSoftKeyword("group") && validateLT(2, "by")))||((validateSoftKeyword("order") && validateLT(2, "by")))))) {
                int LA3_1 = input.LA(2);

                if ( (((validateSoftKeyword("where")))) ) {
                    alt3=1;
                }
            }
            switch (alt3) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:242:28: whereClause
                    {
                    pushFollow(FOLLOW_whereClause_in_filterStatement65);
                    whereClause3=whereClause();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_whereClause.add(whereClause3.getTree());

                    }
                    break;

            }


            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:242:41: ( groupByClause ( havingClause )? )?
            int alt5=2;
            int LA5_0 = input.LA(1);

            if ( (LA5_0==IDENTIFIER) && ((((validateSoftKeyword("group") && validateLT(2, "by")))||((validateSoftKeyword("order") && validateLT(2, "by")))))) {
                int LA5_1 = input.LA(2);

                if ( (((validateSoftKeyword("group") && validateLT(2, "by")))) ) {
                    alt5=1;
                }
            }
            switch (alt5) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:242:43: groupByClause ( havingClause )?
                    {
                    pushFollow(FOLLOW_groupByClause_in_filterStatement70);
                    groupByClause4=groupByClause();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_groupByClause.add(groupByClause4.getTree());

                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:242:57: ( havingClause )?
                    int alt4=2;
                    int LA4_0 = input.LA(1);

                    if ( (LA4_0==IDENTIFIER) && ((((validateSoftKeyword("having")))||((validateSoftKeyword("order") && validateLT(2, "by")))))) {
                        int LA4_1 = input.LA(2);

                        if ( (((validateSoftKeyword("having")))) ) {
                            alt4=1;
                        }
                    }
                    switch (alt4) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:242:57: havingClause
                            {
                            pushFollow(FOLLOW_havingClause_in_filterStatement72);
                            havingClause5=havingClause();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_havingClause.add(havingClause5.getTree());

                            }
                            break;

                    }


                    }
                    break;

            }


            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:242:73: ( orderByClause )?
            int alt6=2;
            int LA6_0 = input.LA(1);

            if ( (LA6_0==IDENTIFIER) && (((validateSoftKeyword("order") && validateLT(2, "by"))))) {
                alt6=1;
            }
            switch (alt6) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:242:73: orderByClause
                    {
                    pushFollow(FOLLOW_orderByClause_in_filterStatement77);
                    orderByClause6=orderByClause();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_orderByClause.add(orderByClause6.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: whereClause, from_key, selectClause, havingClause, orderByClause, groupByClause
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 243:3: -> ^( QUERY ^( QUERY_SPEC[\"filter-query-spec\"] FILTER[$collectionRole] ( selectClause )? ( from_key )? ( whereClause )? ( groupByClause ( havingClause )? )? ( orderByClause )? ) )
            {
                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:243:6: ^( QUERY ^( QUERY_SPEC[\"filter-query-spec\"] FILTER[$collectionRole] ( selectClause )? ( from_key )? ( whereClause )? ( groupByClause ( havingClause )? )? ( orderByClause )? ) )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(QUERY, "QUERY")
                , root_1);

                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:243:14: ^( QUERY_SPEC[\"filter-query-spec\"] FILTER[$collectionRole] ( selectClause )? ( from_key )? ( whereClause )? ( groupByClause ( havingClause )? )? ( orderByClause )? )
                {
                Object root_2 = (Object)adaptor.nil();
                root_2 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(QUERY_SPEC, "filter-query-spec")
                , root_2);

                adaptor.addChild(root_2, 
                (Object)adaptor.create(FILTER, collectionRole)
                );

                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:244:5: ( selectClause )?
                if ( stream_selectClause.hasNext() ) {
                    adaptor.addChild(root_2, stream_selectClause.nextTree());

                }
                stream_selectClause.reset();

                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:244:19: ( from_key )?
                if ( stream_from_key.hasNext() ) {
                    adaptor.addChild(root_2, stream_from_key.nextTree());

                }
                stream_from_key.reset();

                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:244:29: ( whereClause )?
                if ( stream_whereClause.hasNext() ) {
                    adaptor.addChild(root_2, stream_whereClause.nextTree());

                }
                stream_whereClause.reset();

                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:244:42: ( groupByClause ( havingClause )? )?
                if ( stream_havingClause.hasNext()||stream_groupByClause.hasNext() ) {
                    adaptor.addChild(root_2, stream_groupByClause.nextTree());

                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:244:58: ( havingClause )?
                    if ( stream_havingClause.hasNext() ) {
                        adaptor.addChild(root_2, stream_havingClause.nextTree());

                    }
                    stream_havingClause.reset();

                }
                stream_havingClause.reset();
                stream_groupByClause.reset();

                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:244:74: ( orderByClause )?
                if ( stream_orderByClause.hasNext() ) {
                    adaptor.addChild(root_2, stream_orderByClause.nextTree());

                }
                stream_orderByClause.reset();

                adaptor.addChild(root_1, root_2);
                }

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { enableParameterUsage.pop(); }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "filterStatement"


    public static class statement_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "statement"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:248:1: statement : statementElement ;
    public final HQLParser.statement_return statement() throws RecognitionException {
        HQLParser.statement_return retval = new HQLParser.statement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.statementElement_return statementElement7 =null;



         if (state.backtracking == 0) enableParameterUsage.push(Boolean.TRUE); 
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:251:2: ( statementElement )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:251:4: statementElement
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_statementElement_in_statement142);
            statementElement7=statementElement();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, statementElement7.getTree());

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { enableParameterUsage.pop(); }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "statement"


    public static class statementElement_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "statementElement"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:254:1: statementElement : ( updateStatement | deleteStatement | insertStatement | selectStatement );
    public final HQLParser.statementElement_return statementElement() throws RecognitionException {
        HQLParser.statementElement_return retval = new HQLParser.statementElement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.updateStatement_return updateStatement8 =null;

        HQLParser.deleteStatement_return deleteStatement9 =null;

        HQLParser.insertStatement_return insertStatement10 =null;

        HQLParser.selectStatement_return selectStatement11 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:255:2: ( updateStatement | deleteStatement | insertStatement | selectStatement )
            int alt7=4;
            alt7 = dfa7.predict(input);
            switch (alt7) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:255:4: updateStatement
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_updateStatement_in_statementElement153);
                    updateStatement8=updateStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, updateStatement8.getTree());

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:256:4: deleteStatement
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_deleteStatement_in_statementElement158);
                    deleteStatement9=deleteStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, deleteStatement9.getTree());

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:257:4: insertStatement
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_insertStatement_in_statementElement163);
                    insertStatement10=insertStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, insertStatement10.getTree());

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:258:4: selectStatement
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_selectStatement_in_statementElement168);
                    selectStatement11=selectStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, selectStatement11.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "statementElement"


    protected static class updateStatement_scope {
        boolean generateVersionedField;
    }
    protected Stack updateStatement_stack = new Stack();


    public static class updateStatement_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "updateStatement"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:261:1: updateStatement : update_key ( versioned_key )? ( from_key )? entityName aliasClause[true] setClause ( whereClause )? ->;
    public final HQLParser.updateStatement_return updateStatement() throws RecognitionException {
        updateStatement_stack.push(new updateStatement_scope());
        HQLParser.updateStatement_return retval = new HQLParser.updateStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.update_key_return update_key12 =null;

        HQLParser.versioned_key_return versioned_key13 =null;

        HQLParser.from_key_return from_key14 =null;

        HQLParser.entityName_return entityName15 =null;

        HQLParser.aliasClause_return aliasClause16 =null;

        HQLParser.setClause_return setClause17 =null;

        HQLParser.whereClause_return whereClause18 =null;


        RewriteRuleSubtreeStream stream_whereClause=new RewriteRuleSubtreeStream(adaptor,"rule whereClause");
        RewriteRuleSubtreeStream stream_aliasClause=new RewriteRuleSubtreeStream(adaptor,"rule aliasClause");
        RewriteRuleSubtreeStream stream_setClause=new RewriteRuleSubtreeStream(adaptor,"rule setClause");
        RewriteRuleSubtreeStream stream_versioned_key=new RewriteRuleSubtreeStream(adaptor,"rule versioned_key");
        RewriteRuleSubtreeStream stream_update_key=new RewriteRuleSubtreeStream(adaptor,"rule update_key");
        RewriteRuleSubtreeStream stream_from_key=new RewriteRuleSubtreeStream(adaptor,"rule from_key");
        RewriteRuleSubtreeStream stream_entityName=new RewriteRuleSubtreeStream(adaptor,"rule entityName");
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:264:3: ( update_key ( versioned_key )? ( from_key )? entityName aliasClause[true] setClause ( whereClause )? ->)
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:264:5: update_key ( versioned_key )? ( from_key )? entityName aliasClause[true] setClause ( whereClause )?
            {
            pushFollow(FOLLOW_update_key_in_updateStatement181);
            update_key12=update_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_update_key.add(update_key12.getTree());

            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:265:3: ( versioned_key )?
            int alt8=2;
            int LA8_0 = input.LA(1);

            if ( (LA8_0==IDENTIFIER) ) {
                int LA8_1 = input.LA(2);

                if ( (((validateSoftKeyword("versioned")))) ) {
                    alt8=1;
                }
            }
            switch (alt8) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:265:4: versioned_key
                    {
                    pushFollow(FOLLOW_versioned_key_in_updateStatement186);
                    versioned_key13=versioned_key();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_versioned_key.add(versioned_key13.getTree());

                    if ( state.backtracking==0 ) {((updateStatement_scope)updateStatement_stack.peek()).generateVersionedField = true;}

                    }
                    break;

            }


            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:266:4: ( from_key )?
            int alt9=2;
            int LA9_0 = input.LA(1);

            if ( (LA9_0==IDENTIFIER) ) {
                int LA9_1 = input.LA(2);

                if ( (LA9_1==IDENTIFIER) ) {
                    int LA9_2 = input.LA(3);

                    if ( (((validateSoftKeyword("from")))) ) {
                        alt9=1;
                    }
                }
            }
            switch (alt9) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:266:4: from_key
                    {
                    pushFollow(FOLLOW_from_key_in_updateStatement195);
                    from_key14=from_key();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_from_key.add(from_key14.getTree());

                    }
                    break;

            }


            pushFollow(FOLLOW_entityName_in_updateStatement198);
            entityName15=entityName();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_entityName.add(entityName15.getTree());

            pushFollow(FOLLOW_aliasClause_in_updateStatement200);
            aliasClause16=aliasClause(true);

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_aliasClause.add(aliasClause16.getTree());

            pushFollow(FOLLOW_setClause_in_updateStatement203);
            setClause17=setClause();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_setClause.add(setClause17.getTree());

            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:266:53: ( whereClause )?
            int alt10=2;
            int LA10_0 = input.LA(1);

            if ( (LA10_0==IDENTIFIER) && (((validateSoftKeyword("where"))))) {
                alt10=1;
            }
            switch (alt10) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:266:53: whereClause
                    {
                    pushFollow(FOLLOW_whereClause_in_updateStatement205);
                    whereClause18=whereClause();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_whereClause.add(whereClause18.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 267:3: ->
            {
                adaptor.addChild(root_0, 	generateUpdateStatementTree((update_key12!=null?((Object)update_key12.tree):null), (entityName15!=null?((Object)entityName15.tree):null), (aliasClause16!=null?((Object)aliasClause16.tree):null), (setClause17!=null?((Object)setClause17.tree):null), (whereClause18!=null?((Object)whereClause18.tree):null) )	);

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
            updateStatement_stack.pop();
        }
        return retval;
    }
    // $ANTLR end "updateStatement"


    public static class setClause_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "setClause"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:271:1: setClause : set_key assignment ( COMMA assignment )* -> {$updateStatement::generateVersionedField}? ^( set_key ( assignment )+ ^( EQUALS VERSIONED_VALUE STRING_LITERAL ) ) -> ^( set_key ( assignment )+ ) ;
    public final HQLParser.setClause_return setClause() throws RecognitionException {
        HQLParser.setClause_return retval = new HQLParser.setClause_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token COMMA21=null;
        HQLParser.set_key_return set_key19 =null;

        HQLParser.assignment_return assignment20 =null;

        HQLParser.assignment_return assignment22 =null;


        Object COMMA21_tree=null;
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleSubtreeStream stream_assignment=new RewriteRuleSubtreeStream(adaptor,"rule assignment");
        RewriteRuleSubtreeStream stream_set_key=new RewriteRuleSubtreeStream(adaptor,"rule set_key");
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:272:2: ( set_key assignment ( COMMA assignment )* -> {$updateStatement::generateVersionedField}? ^( set_key ( assignment )+ ^( EQUALS VERSIONED_VALUE STRING_LITERAL ) ) -> ^( set_key ( assignment )+ ) )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:272:4: set_key assignment ( COMMA assignment )*
            {
            pushFollow(FOLLOW_set_key_in_setClause224);
            set_key19=set_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_set_key.add(set_key19.getTree());

            pushFollow(FOLLOW_assignment_in_setClause226);
            assignment20=assignment();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_assignment.add(assignment20.getTree());

            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:272:23: ( COMMA assignment )*
            loop11:
            do {
                int alt11=2;
                int LA11_0 = input.LA(1);

                if ( (LA11_0==COMMA) ) {
                    alt11=1;
                }


                switch (alt11) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:272:24: COMMA assignment
            	    {
            	    COMMA21=(Token)match(input,COMMA,FOLLOW_COMMA_in_setClause229); if (state.failed) return retval; 
            	    if ( state.backtracking==0 ) stream_COMMA.add(COMMA21);


            	    pushFollow(FOLLOW_assignment_in_setClause231);
            	    assignment22=assignment();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) stream_assignment.add(assignment22.getTree());

            	    }
            	    break;

            	default :
            	    break loop11;
                }
            } while (true);


            // AST REWRITE
            // elements: assignment, set_key, assignment, set_key
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 273:3: -> {$updateStatement::generateVersionedField}? ^( set_key ( assignment )+ ^( EQUALS VERSIONED_VALUE STRING_LITERAL ) )
            if (((updateStatement_scope)updateStatement_stack.peek()).generateVersionedField) {
                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:273:50: ^( set_key ( assignment )+ ^( EQUALS VERSIONED_VALUE STRING_LITERAL ) )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(stream_set_key.nextNode(), root_1);

                if ( !(stream_assignment.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_assignment.hasNext() ) {
                    adaptor.addChild(root_1, stream_assignment.nextTree());

                }
                stream_assignment.reset();

                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:273:72: ^( EQUALS VERSIONED_VALUE STRING_LITERAL )
                {
                Object root_2 = (Object)adaptor.nil();
                root_2 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(EQUALS, "EQUALS")
                , root_2);

                adaptor.addChild(root_2, 
                (Object)adaptor.create(VERSIONED_VALUE, "VERSIONED_VALUE")
                );

                adaptor.addChild(root_2, 
                (Object)adaptor.create(STRING_LITERAL, "STRING_LITERAL")
                );

                adaptor.addChild(root_1, root_2);
                }

                adaptor.addChild(root_0, root_1);
                }

            }

            else // 274:3: -> ^( set_key ( assignment )+ )
            {
                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:274:6: ^( set_key ( assignment )+ )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(stream_set_key.nextNode(), root_1);

                if ( !(stream_assignment.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_assignment.hasNext() ) {
                    adaptor.addChild(root_1, stream_assignment.nextTree());

                }
                stream_assignment.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "setClause"


    public static class assignment_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "assignment"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:277:1: assignment : assignmentField EQUALS ^ concatenation ;
    public final HQLParser.assignment_return assignment() throws RecognitionException {
        HQLParser.assignment_return retval = new HQLParser.assignment_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token EQUALS24=null;
        HQLParser.assignmentField_return assignmentField23 =null;

        HQLParser.concatenation_return concatenation25 =null;


        Object EQUALS24_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:278:2: ( assignmentField EQUALS ^ concatenation )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:278:4: assignmentField EQUALS ^ concatenation
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_assignmentField_in_assignment276);
            assignmentField23=assignmentField();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, assignmentField23.getTree());

            EQUALS24=(Token)match(input,EQUALS,FOLLOW_EQUALS_in_assignment278); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            EQUALS24_tree = 
            (Object)adaptor.create(EQUALS24)
            ;
            root_0 = (Object)adaptor.becomeRoot(EQUALS24_tree, root_0);
            }

            pushFollow(FOLLOW_concatenation_in_assignment281);
            concatenation25=concatenation();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, concatenation25.getTree());

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "assignment"


    public static class assignmentField_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "assignmentField"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:281:1: assignmentField : dotIdentifierPath -> ^( PROPERTY_REFERENCE dotIdentifierPath ) ;
    public final HQLParser.assignmentField_return assignmentField() throws RecognitionException {
        HQLParser.assignmentField_return retval = new HQLParser.assignmentField_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.dotIdentifierPath_return dotIdentifierPath26 =null;


        RewriteRuleSubtreeStream stream_dotIdentifierPath=new RewriteRuleSubtreeStream(adaptor,"rule dotIdentifierPath");
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:282:2: ( dotIdentifierPath -> ^( PROPERTY_REFERENCE dotIdentifierPath ) )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:282:4: dotIdentifierPath
            {
            pushFollow(FOLLOW_dotIdentifierPath_in_assignmentField292);
            dotIdentifierPath26=dotIdentifierPath();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_dotIdentifierPath.add(dotIdentifierPath26.getTree());

            // AST REWRITE
            // elements: dotIdentifierPath
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 282:22: -> ^( PROPERTY_REFERENCE dotIdentifierPath )
            {
                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:282:25: ^( PROPERTY_REFERENCE dotIdentifierPath )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(PROPERTY_REFERENCE, "PROPERTY_REFERENCE")
                , root_1);

                adaptor.addChild(root_1, stream_dotIdentifierPath.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "assignmentField"


    public static class deleteStatement_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "deleteStatement"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:285:1: deleteStatement : delete_key ( from_key )? entityName aliasClause[true] ( whereClause )? ->;
    public final HQLParser.deleteStatement_return deleteStatement() throws RecognitionException {
        HQLParser.deleteStatement_return retval = new HQLParser.deleteStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.delete_key_return delete_key27 =null;

        HQLParser.from_key_return from_key28 =null;

        HQLParser.entityName_return entityName29 =null;

        HQLParser.aliasClause_return aliasClause30 =null;

        HQLParser.whereClause_return whereClause31 =null;


        RewriteRuleSubtreeStream stream_whereClause=new RewriteRuleSubtreeStream(adaptor,"rule whereClause");
        RewriteRuleSubtreeStream stream_aliasClause=new RewriteRuleSubtreeStream(adaptor,"rule aliasClause");
        RewriteRuleSubtreeStream stream_delete_key=new RewriteRuleSubtreeStream(adaptor,"rule delete_key");
        RewriteRuleSubtreeStream stream_from_key=new RewriteRuleSubtreeStream(adaptor,"rule from_key");
        RewriteRuleSubtreeStream stream_entityName=new RewriteRuleSubtreeStream(adaptor,"rule entityName");
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:286:2: ( delete_key ( from_key )? entityName aliasClause[true] ( whereClause )? ->)
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:286:4: delete_key ( from_key )? entityName aliasClause[true] ( whereClause )?
            {
            pushFollow(FOLLOW_delete_key_in_deleteStatement311);
            delete_key27=delete_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_delete_key.add(delete_key27.getTree());

            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:286:15: ( from_key )?
            int alt12=2;
            int LA12_0 = input.LA(1);

            if ( (LA12_0==IDENTIFIER) ) {
                int LA12_1 = input.LA(2);

                if ( (LA12_1==IDENTIFIER) ) {
                    int LA12_2 = input.LA(3);

                    if ( (((validateSoftKeyword("from")))) ) {
                        alt12=1;
                    }
                }
            }
            switch (alt12) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:286:15: from_key
                    {
                    pushFollow(FOLLOW_from_key_in_deleteStatement313);
                    from_key28=from_key();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_from_key.add(from_key28.getTree());

                    }
                    break;

            }


            pushFollow(FOLLOW_entityName_in_deleteStatement316);
            entityName29=entityName();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_entityName.add(entityName29.getTree());

            pushFollow(FOLLOW_aliasClause_in_deleteStatement318);
            aliasClause30=aliasClause(true);

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_aliasClause.add(aliasClause30.getTree());

            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:286:54: ( whereClause )?
            int alt13=2;
            int LA13_0 = input.LA(1);

            if ( (LA13_0==IDENTIFIER) && (((validateSoftKeyword("where"))))) {
                alt13=1;
            }
            switch (alt13) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:286:54: whereClause
                    {
                    pushFollow(FOLLOW_whereClause_in_deleteStatement321);
                    whereClause31=whereClause();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_whereClause.add(whereClause31.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 287:3: ->
            {
                adaptor.addChild(root_0, 	generateDeleteStatementTree((delete_key27!=null?((Object)delete_key27.tree):null), (entityName29!=null?((Object)entityName29.tree):null), (aliasClause30!=null?((Object)aliasClause30.tree):null), (whereClause31!=null?((Object)whereClause31.tree):null) )	);

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "deleteStatement"


    public static class insertStatement_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "insertStatement"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:290:1: insertStatement : insert_key ^ intoClause selectStatement ;
    public final HQLParser.insertStatement_return insertStatement() throws RecognitionException {
        HQLParser.insertStatement_return retval = new HQLParser.insertStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.insert_key_return insert_key32 =null;

        HQLParser.intoClause_return intoClause33 =null;

        HQLParser.selectStatement_return selectStatement34 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:291:2: ( insert_key ^ intoClause selectStatement )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:291:4: insert_key ^ intoClause selectStatement
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_insert_key_in_insertStatement339);
            insert_key32=insert_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(insert_key32.getTree(), root_0);

            pushFollow(FOLLOW_intoClause_in_insertStatement344);
            intoClause33=intoClause();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, intoClause33.getTree());

            pushFollow(FOLLOW_selectStatement_in_insertStatement346);
            selectStatement34=selectStatement();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, selectStatement34.getTree());

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "insertStatement"


    public static class intoClause_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "intoClause"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:296:1: intoClause : into_key entityName insertabilitySpecification -> ^( into_key entityName ALIAS_NAME[context.buildUniqueImplicitAlias()] insertabilitySpecification ) ;
    public final HQLParser.intoClause_return intoClause() throws RecognitionException {
        HQLParser.intoClause_return retval = new HQLParser.intoClause_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.into_key_return into_key35 =null;

        HQLParser.entityName_return entityName36 =null;

        HQLParser.insertabilitySpecification_return insertabilitySpecification37 =null;


        RewriteRuleSubtreeStream stream_into_key=new RewriteRuleSubtreeStream(adaptor,"rule into_key");
        RewriteRuleSubtreeStream stream_insertabilitySpecification=new RewriteRuleSubtreeStream(adaptor,"rule insertabilitySpecification");
        RewriteRuleSubtreeStream stream_entityName=new RewriteRuleSubtreeStream(adaptor,"rule entityName");
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:297:2: ( into_key entityName insertabilitySpecification -> ^( into_key entityName ALIAS_NAME[context.buildUniqueImplicitAlias()] insertabilitySpecification ) )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:297:4: into_key entityName insertabilitySpecification
            {
            pushFollow(FOLLOW_into_key_in_intoClause358);
            into_key35=into_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_into_key.add(into_key35.getTree());

            pushFollow(FOLLOW_entityName_in_intoClause360);
            entityName36=entityName();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_entityName.add(entityName36.getTree());

            pushFollow(FOLLOW_insertabilitySpecification_in_intoClause362);
            insertabilitySpecification37=insertabilitySpecification();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_insertabilitySpecification.add(insertabilitySpecification37.getTree());

            // AST REWRITE
            // elements: insertabilitySpecification, entityName, into_key
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 298:3: -> ^( into_key entityName ALIAS_NAME[context.buildUniqueImplicitAlias()] insertabilitySpecification )
            {
                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:298:6: ^( into_key entityName ALIAS_NAME[context.buildUniqueImplicitAlias()] insertabilitySpecification )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(stream_into_key.nextNode(), root_1);

                adaptor.addChild(root_1, stream_entityName.nextTree());

                adaptor.addChild(root_1, 
                (Object)adaptor.create(ALIAS_NAME, context.buildUniqueImplicitAlias())
                );

                adaptor.addChild(root_1, stream_insertabilitySpecification.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "intoClause"


    public static class insertabilitySpecification_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "insertabilitySpecification"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:301:1: insertabilitySpecification : LEFT_PAREN insertablePropertySpecification ( COMMA insertablePropertySpecification )* RIGHT_PAREN -> ^( INSERTABILITY_SPEC ( insertablePropertySpecification )+ ) ;
    public final HQLParser.insertabilitySpecification_return insertabilitySpecification() throws RecognitionException {
        HQLParser.insertabilitySpecification_return retval = new HQLParser.insertabilitySpecification_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token LEFT_PAREN38=null;
        Token COMMA40=null;
        Token RIGHT_PAREN42=null;
        HQLParser.insertablePropertySpecification_return insertablePropertySpecification39 =null;

        HQLParser.insertablePropertySpecification_return insertablePropertySpecification41 =null;


        Object LEFT_PAREN38_tree=null;
        Object COMMA40_tree=null;
        Object RIGHT_PAREN42_tree=null;
        RewriteRuleTokenStream stream_LEFT_PAREN=new RewriteRuleTokenStream(adaptor,"token LEFT_PAREN");
        RewriteRuleTokenStream stream_RIGHT_PAREN=new RewriteRuleTokenStream(adaptor,"token RIGHT_PAREN");
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleSubtreeStream stream_insertablePropertySpecification=new RewriteRuleSubtreeStream(adaptor,"rule insertablePropertySpecification");
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:302:2: ( LEFT_PAREN insertablePropertySpecification ( COMMA insertablePropertySpecification )* RIGHT_PAREN -> ^( INSERTABILITY_SPEC ( insertablePropertySpecification )+ ) )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:302:4: LEFT_PAREN insertablePropertySpecification ( COMMA insertablePropertySpecification )* RIGHT_PAREN
            {
            LEFT_PAREN38=(Token)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_insertabilitySpecification388); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_LEFT_PAREN.add(LEFT_PAREN38);


            pushFollow(FOLLOW_insertablePropertySpecification_in_insertabilitySpecification390);
            insertablePropertySpecification39=insertablePropertySpecification();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_insertablePropertySpecification.add(insertablePropertySpecification39.getTree());

            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:302:47: ( COMMA insertablePropertySpecification )*
            loop14:
            do {
                int alt14=2;
                int LA14_0 = input.LA(1);

                if ( (LA14_0==COMMA) ) {
                    alt14=1;
                }


                switch (alt14) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:302:49: COMMA insertablePropertySpecification
            	    {
            	    COMMA40=(Token)match(input,COMMA,FOLLOW_COMMA_in_insertabilitySpecification394); if (state.failed) return retval; 
            	    if ( state.backtracking==0 ) stream_COMMA.add(COMMA40);


            	    pushFollow(FOLLOW_insertablePropertySpecification_in_insertabilitySpecification396);
            	    insertablePropertySpecification41=insertablePropertySpecification();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) stream_insertablePropertySpecification.add(insertablePropertySpecification41.getTree());

            	    }
            	    break;

            	default :
            	    break loop14;
                }
            } while (true);


            RIGHT_PAREN42=(Token)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_insertabilitySpecification401); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_RIGHT_PAREN.add(RIGHT_PAREN42);


            // AST REWRITE
            // elements: insertablePropertySpecification
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 303:3: -> ^( INSERTABILITY_SPEC ( insertablePropertySpecification )+ )
            {
                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:303:6: ^( INSERTABILITY_SPEC ( insertablePropertySpecification )+ )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(INSERTABILITY_SPEC, "INSERTABILITY_SPEC")
                , root_1);

                if ( !(stream_insertablePropertySpecification.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_insertablePropertySpecification.hasNext() ) {
                    adaptor.addChild(root_1, stream_insertablePropertySpecification.nextTree());

                }
                stream_insertablePropertySpecification.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "insertabilitySpecification"


    public static class insertablePropertySpecification_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "insertablePropertySpecification"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:306:1: insertablePropertySpecification : dotIdentifierPath -> ^( PROPERTY_REFERENCE dotIdentifierPath ) ;
    public final HQLParser.insertablePropertySpecification_return insertablePropertySpecification() throws RecognitionException {
        HQLParser.insertablePropertySpecification_return retval = new HQLParser.insertablePropertySpecification_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.dotIdentifierPath_return dotIdentifierPath43 =null;


        RewriteRuleSubtreeStream stream_dotIdentifierPath=new RewriteRuleSubtreeStream(adaptor,"rule dotIdentifierPath");
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:307:2: ( dotIdentifierPath -> ^( PROPERTY_REFERENCE dotIdentifierPath ) )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:307:4: dotIdentifierPath
            {
            pushFollow(FOLLOW_dotIdentifierPath_in_insertablePropertySpecification424);
            dotIdentifierPath43=dotIdentifierPath();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_dotIdentifierPath.add(dotIdentifierPath43.getTree());

            // AST REWRITE
            // elements: dotIdentifierPath
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 307:22: -> ^( PROPERTY_REFERENCE dotIdentifierPath )
            {
                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:307:25: ^( PROPERTY_REFERENCE dotIdentifierPath )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(PROPERTY_REFERENCE, "PROPERTY_REFERENCE")
                , root_1);

                adaptor.addChild(root_1, stream_dotIdentifierPath.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "insertablePropertySpecification"


    public static class selectStatement_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "selectStatement"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:310:1: selectStatement : queryExpression ( orderByClause )? -> ^( QUERY queryExpression ( orderByClause )? ) ;
    public final HQLParser.selectStatement_return selectStatement() throws RecognitionException {
        HQLParser.selectStatement_return retval = new HQLParser.selectStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.queryExpression_return queryExpression44 =null;

        HQLParser.orderByClause_return orderByClause45 =null;


        RewriteRuleSubtreeStream stream_queryExpression=new RewriteRuleSubtreeStream(adaptor,"rule queryExpression");
        RewriteRuleSubtreeStream stream_orderByClause=new RewriteRuleSubtreeStream(adaptor,"rule orderByClause");
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:311:2: ( queryExpression ( orderByClause )? -> ^( QUERY queryExpression ( orderByClause )? ) )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:311:4: queryExpression ( orderByClause )?
            {
            pushFollow(FOLLOW_queryExpression_in_selectStatement443);
            queryExpression44=queryExpression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_queryExpression.add(queryExpression44.getTree());

            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:311:20: ( orderByClause )?
            int alt15=2;
            int LA15_0 = input.LA(1);

            if ( (LA15_0==IDENTIFIER) && (((validateSoftKeyword("order") && validateLT(2, "by"))))) {
                alt15=1;
            }
            switch (alt15) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:311:20: orderByClause
                    {
                    pushFollow(FOLLOW_orderByClause_in_selectStatement445);
                    orderByClause45=orderByClause();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_orderByClause.add(orderByClause45.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: orderByClause, queryExpression
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 312:3: -> ^( QUERY queryExpression ( orderByClause )? )
            {
                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:312:6: ^( QUERY queryExpression ( orderByClause )? )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(QUERY, "QUERY")
                , root_1);

                adaptor.addChild(root_1, stream_queryExpression.nextTree());

                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:312:30: ( orderByClause )?
                if ( stream_orderByClause.hasNext() ) {
                    adaptor.addChild(root_1, stream_orderByClause.nextTree());

                }
                stream_orderByClause.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "selectStatement"


    public static class queryExpression_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "queryExpression"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:316:1: queryExpression : querySpec ( ( union_key ^| intersect_key ^| except_key ^) ( all_key )? querySpec )* ;
    public final HQLParser.queryExpression_return queryExpression() throws RecognitionException {
        HQLParser.queryExpression_return retval = new HQLParser.queryExpression_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.querySpec_return querySpec46 =null;

        HQLParser.union_key_return union_key47 =null;

        HQLParser.intersect_key_return intersect_key48 =null;

        HQLParser.except_key_return except_key49 =null;

        HQLParser.all_key_return all_key50 =null;

        HQLParser.querySpec_return querySpec51 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:317:2: ( querySpec ( ( union_key ^| intersect_key ^| except_key ^) ( all_key )? querySpec )* )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:317:4: querySpec ( ( union_key ^| intersect_key ^| except_key ^) ( all_key )? querySpec )*
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_querySpec_in_queryExpression471);
            querySpec46=querySpec();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, querySpec46.getTree());

            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:317:14: ( ( union_key ^| intersect_key ^| except_key ^) ( all_key )? querySpec )*
            loop18:
            do {
                int alt18=2;
                int LA18_0 = input.LA(1);

                if ( (LA18_0==IDENTIFIER) && ((((validateSoftKeyword("intersect")))||((validateSoftKeyword("union")))||((validateSoftKeyword("except")))||((validateSoftKeyword("order") && validateLT(2, "by")))))) {
                    int LA18_1 = input.LA(2);

                    if ( ((((validateSoftKeyword("intersect")))||((validateSoftKeyword("union")))||((validateSoftKeyword("except"))))) ) {
                        alt18=1;
                    }


                }


                switch (alt18) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:317:16: ( union_key ^| intersect_key ^| except_key ^) ( all_key )? querySpec
            	    {
            	    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:317:16: ( union_key ^| intersect_key ^| except_key ^)
            	    int alt16=3;
            	    int LA16_0 = input.LA(1);

            	    if ( (LA16_0==IDENTIFIER) && ((((validateSoftKeyword("intersect")))||((validateSoftKeyword("union")))||((validateSoftKeyword("except")))))) {
            	        int LA16_1 = input.LA(2);

            	        if ( (((validateSoftKeyword("union")))) ) {
            	            alt16=1;
            	        }
            	        else if ( (((validateSoftKeyword("intersect")))) ) {
            	            alt16=2;
            	        }
            	        else if ( (((validateSoftKeyword("except")))) ) {
            	            alt16=3;
            	        }
            	        else {
            	            if (state.backtracking>0) {state.failed=true; return retval;}
            	            NoViableAltException nvae =
            	                new NoViableAltException("", 16, 1, input);

            	            throw nvae;

            	        }
            	    }
            	    else {
            	        if (state.backtracking>0) {state.failed=true; return retval;}
            	        NoViableAltException nvae =
            	            new NoViableAltException("", 16, 0, input);

            	        throw nvae;

            	    }
            	    switch (alt16) {
            	        case 1 :
            	            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:317:18: union_key ^
            	            {
            	            pushFollow(FOLLOW_union_key_in_queryExpression477);
            	            union_key47=union_key();

            	            state._fsp--;
            	            if (state.failed) return retval;
            	            if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(union_key47.getTree(), root_0);

            	            }
            	            break;
            	        case 2 :
            	            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:317:31: intersect_key ^
            	            {
            	            pushFollow(FOLLOW_intersect_key_in_queryExpression482);
            	            intersect_key48=intersect_key();

            	            state._fsp--;
            	            if (state.failed) return retval;
            	            if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(intersect_key48.getTree(), root_0);

            	            }
            	            break;
            	        case 3 :
            	            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:317:48: except_key ^
            	            {
            	            pushFollow(FOLLOW_except_key_in_queryExpression487);
            	            except_key49=except_key();

            	            state._fsp--;
            	            if (state.failed) return retval;
            	            if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(except_key49.getTree(), root_0);

            	            }
            	            break;

            	    }


            	    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:317:62: ( all_key )?
            	    int alt17=2;
            	    int LA17_0 = input.LA(1);

            	    if ( (LA17_0==IDENTIFIER) && ((((validateSoftKeyword("select")))||((validateSoftKeyword("all")))||((validateSoftKeyword("from")))))) {
            	        int LA17_1 = input.LA(2);

            	        if ( (LA17_1==IDENTIFIER) && ((((validateSoftKeyword("select")))||((validateSoftKeyword("all")))||((validateSoftKeyword("from")))))) {
            	            int LA17_2 = input.LA(3);

            	            if ( (((validateSoftKeyword("all")))) ) {
            	                alt17=1;
            	            }
            	        }
            	    }
            	    switch (alt17) {
            	        case 1 :
            	            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:317:62: all_key
            	            {
            	            pushFollow(FOLLOW_all_key_in_queryExpression492);
            	            all_key50=all_key();

            	            state._fsp--;
            	            if (state.failed) return retval;
            	            if ( state.backtracking==0 ) adaptor.addChild(root_0, all_key50.getTree());

            	            }
            	            break;

            	    }


            	    pushFollow(FOLLOW_querySpec_in_queryExpression495);
            	    querySpec51=querySpec();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) adaptor.addChild(root_0, querySpec51.getTree());

            	    }
            	    break;

            	default :
            	    break loop18;
                }
            } while (true);


            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "queryExpression"


    public static class querySpec_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "querySpec"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:320:1: querySpec : selectFrom ( whereClause )? ( groupByClause ( havingClause )? )? -> ^( QUERY_SPEC selectFrom ( whereClause )? ( groupByClause )? ( havingClause )? ) ;
    public final HQLParser.querySpec_return querySpec() throws RecognitionException {
        HQLParser.querySpec_return retval = new HQLParser.querySpec_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.selectFrom_return selectFrom52 =null;

        HQLParser.whereClause_return whereClause53 =null;

        HQLParser.groupByClause_return groupByClause54 =null;

        HQLParser.havingClause_return havingClause55 =null;


        RewriteRuleSubtreeStream stream_whereClause=new RewriteRuleSubtreeStream(adaptor,"rule whereClause");
        RewriteRuleSubtreeStream stream_selectFrom=new RewriteRuleSubtreeStream(adaptor,"rule selectFrom");
        RewriteRuleSubtreeStream stream_groupByClause=new RewriteRuleSubtreeStream(adaptor,"rule groupByClause");
        RewriteRuleSubtreeStream stream_havingClause=new RewriteRuleSubtreeStream(adaptor,"rule havingClause");
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:321:2: ( selectFrom ( whereClause )? ( groupByClause ( havingClause )? )? -> ^( QUERY_SPEC selectFrom ( whereClause )? ( groupByClause )? ( havingClause )? ) )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:321:4: selectFrom ( whereClause )? ( groupByClause ( havingClause )? )?
            {
            pushFollow(FOLLOW_selectFrom_in_querySpec509);
            selectFrom52=selectFrom();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_selectFrom.add(selectFrom52.getTree());

            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:321:15: ( whereClause )?
            int alt19=2;
            int LA19_0 = input.LA(1);

            if ( (LA19_0==IDENTIFIER) && ((((validateSoftKeyword("intersect")))||((validateSoftKeyword("union")))||((validateSoftKeyword("where")))||((validateSoftKeyword("except")))||((validateSoftKeyword("group") && validateLT(2, "by")))||((validateSoftKeyword("order") && validateLT(2, "by")))))) {
                int LA19_1 = input.LA(2);

                if ( (((validateSoftKeyword("where")))) ) {
                    alt19=1;
                }
            }
            switch (alt19) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:321:15: whereClause
                    {
                    pushFollow(FOLLOW_whereClause_in_querySpec511);
                    whereClause53=whereClause();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_whereClause.add(whereClause53.getTree());

                    }
                    break;

            }


            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:321:28: ( groupByClause ( havingClause )? )?
            int alt21=2;
            int LA21_0 = input.LA(1);

            if ( (LA21_0==IDENTIFIER) && ((((validateSoftKeyword("intersect")))||((validateSoftKeyword("union")))||((validateSoftKeyword("except")))||((validateSoftKeyword("group") && validateLT(2, "by")))||((validateSoftKeyword("order") && validateLT(2, "by")))))) {
                int LA21_1 = input.LA(2);

                if ( (((validateSoftKeyword("group") && validateLT(2, "by")))) ) {
                    alt21=1;
                }
            }
            switch (alt21) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:321:30: groupByClause ( havingClause )?
                    {
                    pushFollow(FOLLOW_groupByClause_in_querySpec516);
                    groupByClause54=groupByClause();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_groupByClause.add(groupByClause54.getTree());

                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:321:44: ( havingClause )?
                    int alt20=2;
                    int LA20_0 = input.LA(1);

                    if ( (LA20_0==IDENTIFIER) && ((((validateSoftKeyword("intersect")))||((validateSoftKeyword("union")))||((validateSoftKeyword("having")))||((validateSoftKeyword("except")))||((validateSoftKeyword("order") && validateLT(2, "by")))))) {
                        int LA20_1 = input.LA(2);

                        if ( (((validateSoftKeyword("having")))) ) {
                            alt20=1;
                        }
                    }
                    switch (alt20) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:321:44: havingClause
                            {
                            pushFollow(FOLLOW_havingClause_in_querySpec518);
                            havingClause55=havingClause();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_havingClause.add(havingClause55.getTree());

                            }
                            break;

                    }


                    }
                    break;

            }


            // AST REWRITE
            // elements: whereClause, havingClause, groupByClause, selectFrom
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 322:3: -> ^( QUERY_SPEC selectFrom ( whereClause )? ( groupByClause )? ( havingClause )? )
            {
                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:322:6: ^( QUERY_SPEC selectFrom ( whereClause )? ( groupByClause )? ( havingClause )? )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(QUERY_SPEC, "QUERY_SPEC")
                , root_1);

                adaptor.addChild(root_1, stream_selectFrom.nextTree());

                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:322:30: ( whereClause )?
                if ( stream_whereClause.hasNext() ) {
                    adaptor.addChild(root_1, stream_whereClause.nextTree());

                }
                stream_whereClause.reset();

                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:322:43: ( groupByClause )?
                if ( stream_groupByClause.hasNext() ) {
                    adaptor.addChild(root_1, stream_groupByClause.nextTree());

                }
                stream_groupByClause.reset();

                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:322:58: ( havingClause )?
                if ( stream_havingClause.hasNext() ) {
                    adaptor.addChild(root_1, stream_havingClause.nextTree());

                }
                stream_havingClause.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "querySpec"


    public static class groupByClause_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "groupByClause"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:325:1: groupByClause : group_by_key ^ groupingSpecification ;
    public final HQLParser.groupByClause_return groupByClause() throws RecognitionException {
        HQLParser.groupByClause_return retval = new HQLParser.groupByClause_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.group_by_key_return group_by_key56 =null;

        HQLParser.groupingSpecification_return groupingSpecification57 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:326:2: ( group_by_key ^ groupingSpecification )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:326:4: group_by_key ^ groupingSpecification
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_group_by_key_in_groupByClause552);
            group_by_key56=group_by_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(group_by_key56.getTree(), root_0);

            pushFollow(FOLLOW_groupingSpecification_in_groupByClause555);
            groupingSpecification57=groupingSpecification();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, groupingSpecification57.getTree());

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "groupByClause"


    public static class havingClause_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "havingClause"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:329:1: havingClause : having_key ^ logicalExpression ;
    public final HQLParser.havingClause_return havingClause() throws RecognitionException {
        HQLParser.havingClause_return retval = new HQLParser.havingClause_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.having_key_return having_key58 =null;

        HQLParser.logicalExpression_return logicalExpression59 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:330:2: ( having_key ^ logicalExpression )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:330:4: having_key ^ logicalExpression
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_having_key_in_havingClause566);
            having_key58=having_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(having_key58.getTree(), root_0);

            pushFollow(FOLLOW_logicalExpression_in_havingClause569);
            logicalExpression59=logicalExpression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, logicalExpression59.getTree());

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "havingClause"


    public static class groupingSpecification_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "groupingSpecification"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:333:1: groupingSpecification : groupingValue ( COMMA ! groupingValue )* ;
    public final HQLParser.groupingSpecification_return groupingSpecification() throws RecognitionException {
        HQLParser.groupingSpecification_return retval = new HQLParser.groupingSpecification_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token COMMA61=null;
        HQLParser.groupingValue_return groupingValue60 =null;

        HQLParser.groupingValue_return groupingValue62 =null;


        Object COMMA61_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:334:2: ( groupingValue ( COMMA ! groupingValue )* )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:334:4: groupingValue ( COMMA ! groupingValue )*
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_groupingValue_in_groupingSpecification580);
            groupingValue60=groupingValue();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, groupingValue60.getTree());

            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:334:18: ( COMMA ! groupingValue )*
            loop22:
            do {
                int alt22=2;
                int LA22_0 = input.LA(1);

                if ( (LA22_0==COMMA) ) {
                    alt22=1;
                }


                switch (alt22) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:334:20: COMMA ! groupingValue
            	    {
            	    COMMA61=(Token)match(input,COMMA,FOLLOW_COMMA_in_groupingSpecification584); if (state.failed) return retval;

            	    pushFollow(FOLLOW_groupingValue_in_groupingSpecification587);
            	    groupingValue62=groupingValue();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) adaptor.addChild(root_0, groupingValue62.getTree());

            	    }
            	    break;

            	default :
            	    break loop22;
                }
            } while (true);


            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "groupingSpecification"


    public static class groupingValue_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "groupingValue"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:337:1: groupingValue : concatenation ( collationSpecification )? -> ^( GROUPING_VALUE concatenation ( collationSpecification )? ) ;
    public final HQLParser.groupingValue_return groupingValue() throws RecognitionException {
        HQLParser.groupingValue_return retval = new HQLParser.groupingValue_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.concatenation_return concatenation63 =null;

        HQLParser.collationSpecification_return collationSpecification64 =null;


        RewriteRuleSubtreeStream stream_concatenation=new RewriteRuleSubtreeStream(adaptor,"rule concatenation");
        RewriteRuleSubtreeStream stream_collationSpecification=new RewriteRuleSubtreeStream(adaptor,"rule collationSpecification");
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:338:2: ( concatenation ( collationSpecification )? -> ^( GROUPING_VALUE concatenation ( collationSpecification )? ) )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:338:4: concatenation ( collationSpecification )?
            {
            pushFollow(FOLLOW_concatenation_in_groupingValue601);
            concatenation63=concatenation();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_concatenation.add(concatenation63.getTree());

            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:338:18: ( collationSpecification )?
            int alt23=2;
            int LA23_0 = input.LA(1);

            if ( (LA23_0==IDENTIFIER) && ((((validateSoftKeyword("collate")))||((validateSoftKeyword("intersect")))||((validateSoftKeyword("union")))||((validateSoftKeyword("having")))||((validateSoftKeyword("except")))||((validateSoftKeyword("order") && validateLT(2, "by")))))) {
                int LA23_1 = input.LA(2);

                if ( (LA23_1==IDENTIFIER) && ((((validateSoftKeyword("collate")))||((validateSoftKeyword("intersect")))||((validateSoftKeyword("union")))||((validateSoftKeyword("having")))||((validateSoftKeyword("except")))||((validateSoftKeyword("order") && validateLT(2, "by")))))) {
                    int LA23_3 = input.LA(3);

                    if ( (((validateSoftKeyword("collate")))) ) {
                        alt23=1;
                    }
                }
            }
            switch (alt23) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:338:18: collationSpecification
                    {
                    pushFollow(FOLLOW_collationSpecification_in_groupingValue603);
                    collationSpecification64=collationSpecification();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_collationSpecification.add(collationSpecification64.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: concatenation, collationSpecification
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 339:3: -> ^( GROUPING_VALUE concatenation ( collationSpecification )? )
            {
                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:339:6: ^( GROUPING_VALUE concatenation ( collationSpecification )? )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(GROUPING_VALUE, "GROUPING_VALUE")
                , root_1);

                adaptor.addChild(root_1, stream_concatenation.nextTree());

                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:339:37: ( collationSpecification )?
                if ( stream_collationSpecification.hasNext() ) {
                    adaptor.addChild(root_1, stream_collationSpecification.nextTree());

                }
                stream_collationSpecification.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "groupingValue"


    public static class whereClause_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "whereClause"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:342:1: whereClause : where_key ^ logicalExpression ;
    public final HQLParser.whereClause_return whereClause() throws RecognitionException {
        HQLParser.whereClause_return retval = new HQLParser.whereClause_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.where_key_return where_key65 =null;

        HQLParser.logicalExpression_return logicalExpression66 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:343:2: ( where_key ^ logicalExpression )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:343:4: where_key ^ logicalExpression
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_where_key_in_whereClause628);
            where_key65=where_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(where_key65.getTree(), root_0);

            pushFollow(FOLLOW_logicalExpression_in_whereClause631);
            logicalExpression66=logicalExpression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, logicalExpression66.getTree());

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "whereClause"


    public static class selectFrom_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "selectFrom"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:346:1: selectFrom : (sc= selectClause )? fc= fromClause ->;
    public final HQLParser.selectFrom_return selectFrom() throws RecognitionException {
        HQLParser.selectFrom_return retval = new HQLParser.selectFrom_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.selectClause_return sc =null;

        HQLParser.fromClause_return fc =null;


        RewriteRuleSubtreeStream stream_selectClause=new RewriteRuleSubtreeStream(adaptor,"rule selectClause");
        RewriteRuleSubtreeStream stream_fromClause=new RewriteRuleSubtreeStream(adaptor,"rule fromClause");
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:347:2: ( (sc= selectClause )? fc= fromClause ->)
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:347:4: (sc= selectClause )? fc= fromClause
            {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:347:6: (sc= selectClause )?
            int alt24=2;
            int LA24_0 = input.LA(1);

            if ( (LA24_0==IDENTIFIER) && ((((validateSoftKeyword("select")))||((validateSoftKeyword("from")))))) {
                int LA24_1 = input.LA(2);

                if ( (((validateSoftKeyword("select")))) ) {
                    alt24=1;
                }
            }
            switch (alt24) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:347:6: sc= selectClause
                    {
                    pushFollow(FOLLOW_selectClause_in_selectFrom644);
                    sc=selectClause();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_selectClause.add(sc.getTree());

                    }
                    break;

            }


            pushFollow(FOLLOW_fromClause_in_selectFrom649);
            fc=fromClause();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_fromClause.add(fc.getTree());

            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 348:3: ->
            {
                adaptor.addChild(root_0,  generateSelectFromTree((sc!=null?((Object)sc.tree):null), (fc!=null?((Object)fc.tree):null), (fc!=null?fc.aliasList:null)));

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "selectFrom"


    public static class subQuery_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "subQuery"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:351:1: subQuery : queryExpression -> ^( SUB_QUERY ^( QUERY queryExpression ) ) ;
    public final HQLParser.subQuery_return subQuery() throws RecognitionException {
        HQLParser.subQuery_return retval = new HQLParser.subQuery_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.queryExpression_return queryExpression67 =null;


        RewriteRuleSubtreeStream stream_queryExpression=new RewriteRuleSubtreeStream(adaptor,"rule queryExpression");
         if (state.backtracking == 0) enableParameterUsage.push(Boolean.TRUE); 
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:354:2: ( queryExpression -> ^( SUB_QUERY ^( QUERY queryExpression ) ) )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:354:4: queryExpression
            {
            pushFollow(FOLLOW_queryExpression_in_subQuery676);
            queryExpression67=queryExpression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_queryExpression.add(queryExpression67.getTree());

            // AST REWRITE
            // elements: queryExpression
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 355:3: -> ^( SUB_QUERY ^( QUERY queryExpression ) )
            {
                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:355:6: ^( SUB_QUERY ^( QUERY queryExpression ) )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(SUB_QUERY, "SUB_QUERY")
                , root_1);

                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:355:18: ^( QUERY queryExpression )
                {
                Object root_2 = (Object)adaptor.nil();
                root_2 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(QUERY, "QUERY")
                , root_2);

                adaptor.addChild(root_2, stream_queryExpression.nextTree());

                adaptor.addChild(root_1, root_2);
                }

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { enableParameterUsage.pop(); }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "subQuery"


    protected static class fromClause_scope {
        List aliases;
    }
    protected Stack fromClause_stack = new Stack();


    public static class fromClause_return extends ParserRuleReturnScope {
        public List aliasList;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "fromClause"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:358:1: fromClause returns [List aliasList] : from_key ^ persisterSpaces ;
    public final HQLParser.fromClause_return fromClause() throws RecognitionException {
        fromClause_stack.push(new fromClause_scope());
        HQLParser.fromClause_return retval = new HQLParser.fromClause_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.from_key_return from_key68 =null;

        HQLParser.persisterSpaces_return persisterSpaces69 =null;



        	((fromClause_scope)fromClause_stack.peek()).aliases = new ArrayList();	
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:364:2: ( from_key ^ persisterSpaces )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:364:4: from_key ^ persisterSpaces
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_from_key_in_fromClause718);
            from_key68=from_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(from_key68.getTree(), root_0);

            pushFollow(FOLLOW_persisterSpaces_in_fromClause724);
            persisterSpaces69=persisterSpaces();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, persisterSpaces69.getTree());

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) {	retval.aliasList = ((fromClause_scope)fromClause_stack.peek()).aliases;	}
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
            fromClause_stack.pop();
        }
        return retval;
    }
    // $ANTLR end "fromClause"


    public static class persisterSpaces_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "persisterSpaces"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:368:1: persisterSpaces :ps+= persisterSpace ( COMMA ps+= persisterSpace )* ->;
    public final HQLParser.persisterSpaces_return persisterSpaces() throws RecognitionException {
        HQLParser.persisterSpaces_return retval = new HQLParser.persisterSpaces_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token COMMA70=null;
        List list_ps=null;
        RuleReturnScope ps = null;
        Object COMMA70_tree=null;
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleSubtreeStream stream_persisterSpace=new RewriteRuleSubtreeStream(adaptor,"rule persisterSpace");
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:369:2: (ps+= persisterSpace ( COMMA ps+= persisterSpace )* ->)
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:369:4: ps+= persisterSpace ( COMMA ps+= persisterSpace )*
            {
            pushFollow(FOLLOW_persisterSpace_in_persisterSpaces737);
            ps=persisterSpace();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_persisterSpace.add(ps.getTree());
            if (list_ps==null) list_ps=new ArrayList();
            list_ps.add(ps.getTree());


            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:369:23: ( COMMA ps+= persisterSpace )*
            loop25:
            do {
                int alt25=2;
                int LA25_0 = input.LA(1);

                if ( (LA25_0==COMMA) ) {
                    alt25=1;
                }


                switch (alt25) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:369:25: COMMA ps+= persisterSpace
            	    {
            	    COMMA70=(Token)match(input,COMMA,FOLLOW_COMMA_in_persisterSpaces741); if (state.failed) return retval; 
            	    if ( state.backtracking==0 ) stream_COMMA.add(COMMA70);


            	    pushFollow(FOLLOW_persisterSpace_in_persisterSpaces745);
            	    ps=persisterSpace();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) stream_persisterSpace.add(ps.getTree());
            	    if (list_ps==null) list_ps=new ArrayList();
            	    list_ps.add(ps.getTree());


            	    }
            	    break;

            	default :
            	    break loop25;
                }
            } while (true);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 370:3: ->
            {
                adaptor.addChild(root_0, generatePersisterSpacesTree(list_ps));

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "persisterSpaces"


    public static class persisterSpace_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "persisterSpace"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:373:1: persisterSpace : persisterSpaceRoot ( qualifiedJoin | crossJoin )* ;
    public final HQLParser.persisterSpace_return persisterSpace() throws RecognitionException {
        HQLParser.persisterSpace_return retval = new HQLParser.persisterSpace_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.persisterSpaceRoot_return persisterSpaceRoot71 =null;

        HQLParser.qualifiedJoin_return qualifiedJoin72 =null;

        HQLParser.crossJoin_return crossJoin73 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:374:2: ( persisterSpaceRoot ( qualifiedJoin | crossJoin )* )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:374:4: persisterSpaceRoot ( qualifiedJoin | crossJoin )*
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_persisterSpaceRoot_in_persisterSpace765);
            persisterSpaceRoot71=persisterSpaceRoot();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, persisterSpaceRoot71.getTree());

            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:374:23: ( qualifiedJoin | crossJoin )*
            loop26:
            do {
                int alt26=3;
                int LA26_0 = input.LA(1);

                if ( (LA26_0==IDENTIFIER) && ((((validateSoftKeyword("intersect")))||((validateSoftKeyword("right")))||((validateSoftKeyword("union")))||((validateSoftKeyword("where")))||((validateSoftKeyword("except")))||((validateSoftKeyword("cross")))||((validateSoftKeyword("inner")))||((validateSoftKeyword("group") && validateLT(2, "by")))||((validateSoftKeyword("left")))||((validateSoftKeyword("full")))||((validateSoftKeyword("join")))||((validateSoftKeyword("order") && validateLT(2, "by")))))) {
                    int LA26_2 = input.LA(2);

                    if ( (LA26_2==IDENTIFIER) && ((((validateSoftKeyword("intersect")))||((validateSoftKeyword("union")))||((validateSoftKeyword("right")))||((validateSoftKeyword("where")))||((validateSoftKeyword("cross")))||((validateSoftKeyword("except")))||((validateSoftKeyword("inner")))||((validateSoftKeyword("group") && validateLT(2, "by")))||((validateSoftKeyword("left")))||((validateSoftKeyword("full")))||((validateSoftKeyword("join")))||((validateSoftKeyword("order") && validateLT(2, "by")))))) {
                        int LA26_3 = input.LA(3);

                        if ( (LA26_3==IDENTIFIER) && (((validateSoftKeyword("cross"))))) {
                            alt26=2;
                        }
                        else if ( ((((validateSoftKeyword("right")))||((validateSoftKeyword("inner")))||((validateSoftKeyword("left")))||((validateSoftKeyword("full")))||((validateSoftKeyword("join"))))) ) {
                            alt26=1;
                        }


                    }


                }


                switch (alt26) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:374:25: qualifiedJoin
            	    {
            	    pushFollow(FOLLOW_qualifiedJoin_in_persisterSpace769);
            	    qualifiedJoin72=qualifiedJoin();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) adaptor.addChild(root_0, qualifiedJoin72.getTree());

            	    }
            	    break;
            	case 2 :
            	    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:374:41: crossJoin
            	    {
            	    pushFollow(FOLLOW_crossJoin_in_persisterSpace773);
            	    crossJoin73=crossJoin();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) adaptor.addChild(root_0, crossJoin73.getTree());

            	    }
            	    break;

            	default :
            	    break loop26;
                }
            } while (true);


            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "persisterSpace"


    public static class crossJoin_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "crossJoin"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:377:1: crossJoin : cross_key join_key mainEntityPersisterReference -> ^( PERSISTER_JOIN[$join_key.start,\"persister-join\"] cross_key mainEntityPersisterReference ) ;
    public final HQLParser.crossJoin_return crossJoin() throws RecognitionException {
        HQLParser.crossJoin_return retval = new HQLParser.crossJoin_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.cross_key_return cross_key74 =null;

        HQLParser.join_key_return join_key75 =null;

        HQLParser.mainEntityPersisterReference_return mainEntityPersisterReference76 =null;


        RewriteRuleSubtreeStream stream_join_key=new RewriteRuleSubtreeStream(adaptor,"rule join_key");
        RewriteRuleSubtreeStream stream_mainEntityPersisterReference=new RewriteRuleSubtreeStream(adaptor,"rule mainEntityPersisterReference");
        RewriteRuleSubtreeStream stream_cross_key=new RewriteRuleSubtreeStream(adaptor,"rule cross_key");
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:378:2: ( cross_key join_key mainEntityPersisterReference -> ^( PERSISTER_JOIN[$join_key.start,\"persister-join\"] cross_key mainEntityPersisterReference ) )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:378:4: cross_key join_key mainEntityPersisterReference
            {
            pushFollow(FOLLOW_cross_key_in_crossJoin787);
            cross_key74=cross_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_cross_key.add(cross_key74.getTree());

            pushFollow(FOLLOW_join_key_in_crossJoin789);
            join_key75=join_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_join_key.add(join_key75.getTree());

            pushFollow(FOLLOW_mainEntityPersisterReference_in_crossJoin791);
            mainEntityPersisterReference76=mainEntityPersisterReference();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_mainEntityPersisterReference.add(mainEntityPersisterReference76.getTree());

            // AST REWRITE
            // elements: cross_key, mainEntityPersisterReference
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 379:3: -> ^( PERSISTER_JOIN[$join_key.start,\"persister-join\"] cross_key mainEntityPersisterReference )
            {
                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:379:6: ^( PERSISTER_JOIN[$join_key.start,\"persister-join\"] cross_key mainEntityPersisterReference )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(PERSISTER_JOIN, (join_key75!=null?((Token)join_key75.start):null), "persister-join")
                , root_1);

                adaptor.addChild(root_1, stream_cross_key.nextTree());

                adaptor.addChild(root_1, stream_mainEntityPersisterReference.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "crossJoin"


    public static class qualifiedJoin_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "qualifiedJoin"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:382:1: qualifiedJoin : nonCrossJoinType join_key ( fetch_key )? path ac= aliasClause[true] ( on_key logicalExpression | ( propertyFetch )? ( withClause )? ) -> {isEntityReference}? ^( PERSISTER_JOIN[$join_key.start,\"persister-join\"] nonCrossJoinType ^( ENTITY_PERSISTER_REF ENTITY_NAME[$path.start, $path.text, entityNames] ( aliasClause )? ) ^( on_key logicalExpression ) ) -> ^( PROPERTY_JOIN[$join_key.start, \"property-join\"] nonCrossJoinType ( fetch_key )? ( aliasClause )? ( propertyFetch )? ^( PROPERTY_REFERENCE path ) ( withClause )? ) ;
    public final HQLParser.qualifiedJoin_return qualifiedJoin() throws RecognitionException {
        HQLParser.qualifiedJoin_return retval = new HQLParser.qualifiedJoin_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.aliasClause_return ac =null;

        HQLParser.nonCrossJoinType_return nonCrossJoinType77 =null;

        HQLParser.join_key_return join_key78 =null;

        HQLParser.fetch_key_return fetch_key79 =null;

        HQLParser.path_return path80 =null;

        HQLParser.on_key_return on_key81 =null;

        HQLParser.logicalExpression_return logicalExpression82 =null;

        HQLParser.propertyFetch_return propertyFetch83 =null;

        HQLParser.withClause_return withClause84 =null;


        RewriteRuleSubtreeStream stream_fetch_key=new RewriteRuleSubtreeStream(adaptor,"rule fetch_key");
        RewriteRuleSubtreeStream stream_propertyFetch=new RewriteRuleSubtreeStream(adaptor,"rule propertyFetch");
        RewriteRuleSubtreeStream stream_aliasClause=new RewriteRuleSubtreeStream(adaptor,"rule aliasClause");
        RewriteRuleSubtreeStream stream_join_key=new RewriteRuleSubtreeStream(adaptor,"rule join_key");
        RewriteRuleSubtreeStream stream_nonCrossJoinType=new RewriteRuleSubtreeStream(adaptor,"rule nonCrossJoinType");
        RewriteRuleSubtreeStream stream_path=new RewriteRuleSubtreeStream(adaptor,"rule path");
        RewriteRuleSubtreeStream stream_on_key=new RewriteRuleSubtreeStream(adaptor,"rule on_key");
        RewriteRuleSubtreeStream stream_withClause=new RewriteRuleSubtreeStream(adaptor,"rule withClause");
        RewriteRuleSubtreeStream stream_logicalExpression=new RewriteRuleSubtreeStream(adaptor,"rule logicalExpression");
         boolean isEntityReference = false; boolean hasFetch = false; List entityNames = null; 
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:385:2: ( nonCrossJoinType join_key ( fetch_key )? path ac= aliasClause[true] ( on_key logicalExpression | ( propertyFetch )? ( withClause )? ) -> {isEntityReference}? ^( PERSISTER_JOIN[$join_key.start,\"persister-join\"] nonCrossJoinType ^( ENTITY_PERSISTER_REF ENTITY_NAME[$path.start, $path.text, entityNames] ( aliasClause )? ) ^( on_key logicalExpression ) ) -> ^( PROPERTY_JOIN[$join_key.start, \"property-join\"] nonCrossJoinType ( fetch_key )? ( aliasClause )? ( propertyFetch )? ^( PROPERTY_REFERENCE path ) ( withClause )? ) )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:385:4: nonCrossJoinType join_key ( fetch_key )? path ac= aliasClause[true] ( on_key logicalExpression | ( propertyFetch )? ( withClause )? )
            {
            pushFollow(FOLLOW_nonCrossJoinType_in_qualifiedJoin825);
            nonCrossJoinType77=nonCrossJoinType();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_nonCrossJoinType.add(nonCrossJoinType77.getTree());

            pushFollow(FOLLOW_join_key_in_qualifiedJoin827);
            join_key78=join_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_join_key.add(join_key78.getTree());

            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:385:30: ( fetch_key )?
            int alt27=2;
            int LA27_0 = input.LA(1);

            if ( (LA27_0==IDENTIFIER) ) {
                int LA27_1 = input.LA(2);

                if ( (LA27_1==IDENTIFIER) ) {
                    int LA27_2 = input.LA(3);

                    if ( (((validateSoftKeyword("fetch")))) ) {
                        alt27=1;
                    }
                }
            }
            switch (alt27) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:385:31: fetch_key
                    {
                    pushFollow(FOLLOW_fetch_key_in_qualifiedJoin830);
                    fetch_key79=fetch_key();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_fetch_key.add(fetch_key79.getTree());

                    if ( state.backtracking==0 ) {hasFetch = true;}

                    }
                    break;

            }


            pushFollow(FOLLOW_path_in_qualifiedJoin836);
            path80=path();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_path.add(path80.getTree());

            pushFollow(FOLLOW_aliasClause_in_qualifiedJoin840);
            ac=aliasClause(true);

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_aliasClause.add(ac.getTree());

            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:386:2: ( on_key logicalExpression | ( propertyFetch )? ( withClause )? )
            int alt30=2;
            int LA30_0 = input.LA(1);

            if ( (LA30_0==IDENTIFIER) && ((((validateSoftKeyword("on")))||((validateSoftKeyword("union")))||((validateSoftKeyword("right")))||((validateSoftKeyword("where")))||((validateSoftKeyword("join")))||((validateSoftKeyword("intersect")))||((validateSoftKeyword("fetch")))||((validateSoftKeyword("cross")))||((validateSoftKeyword("except")))||((validateSoftKeyword("inner")))||((validateSoftKeyword("group") && validateLT(2, "by")))||((validateSoftKeyword("with")))||((validateSoftKeyword("left")))||((validateSoftKeyword("full")))||((validateSoftKeyword("order") && validateLT(2, "by")))))) {
                int LA30_1 = input.LA(2);

                if ( (((validateSoftKeyword("on")))) ) {
                    alt30=1;
                }
                else if ( ((((validateSoftKeyword("right")))||((validateSoftKeyword("union")))||((validateSoftKeyword("where")))||((validateSoftKeyword("join")))||((validateSoftKeyword("intersect")))||((validateSoftKeyword("cross")))||((validateSoftKeyword("except")))||((validateSoftKeyword("fetch")))||((validateSoftKeyword("inner")))||((validateSoftKeyword("group") && validateLT(2, "by")))||((validateSoftKeyword("with")))||((validateSoftKeyword("left")))||((validateSoftKeyword("full")))||((validateSoftKeyword("order") && validateLT(2, "by"))))) ) {
                    alt30=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 30, 1, input);

                    throw nvae;

                }
            }
            else if ( (LA30_0==EOF||LA30_0==COMMA||LA30_0==RIGHT_PAREN) ) {
                alt30=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 30, 0, input);

                throw nvae;

            }
            switch (alt30) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:386:4: on_key logicalExpression
                    {
                    pushFollow(FOLLOW_on_key_in_qualifiedJoin846);
                    on_key81=on_key();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_on_key.add(on_key81.getTree());

                    if ( state.backtracking==0 ) {	isEntityReference = true;
                    		entityNames = extractEntityNames((path80!=null?input.toString(path80.start,path80.stop):null));	}

                    pushFollow(FOLLOW_logicalExpression_in_qualifiedJoin853);
                    logicalExpression82=logicalExpression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_logicalExpression.add(logicalExpression82.getTree());

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:390:4: ( propertyFetch )? ( withClause )?
                    {
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:390:4: ( propertyFetch )?
                    int alt28=2;
                    int LA28_0 = input.LA(1);

                    if ( (LA28_0==IDENTIFIER) && ((((validateSoftKeyword("right")))||((validateSoftKeyword("union")))||((validateSoftKeyword("where")))||((validateSoftKeyword("join")))||((validateSoftKeyword("intersect")))||((validateSoftKeyword("cross")))||((validateSoftKeyword("except")))||((validateSoftKeyword("fetch")))||((validateSoftKeyword("inner")))||((validateSoftKeyword("group") && validateLT(2, "by")))||((validateSoftKeyword("with")))||((validateSoftKeyword("left")))||((validateSoftKeyword("full")))||((validateSoftKeyword("order") && validateLT(2, "by")))))) {
                        int LA28_1 = input.LA(2);

                        if ( (LA28_1==IDENTIFIER) && ((((validateSoftKeyword("union")))||((validateSoftKeyword("right")))||((validateSoftKeyword("where")))||((validateSoftKeyword("join")))||((validateSoftKeyword("intersect")))||((validateSoftKeyword("cross")))||((validateSoftKeyword("fetch")))||((validateSoftKeyword("except")))||((validateSoftKeyword("inner")))||((validateSoftKeyword("group") && validateLT(2, "by")))||((validateSoftKeyword("with")))||((validateSoftKeyword("full")))||((validateSoftKeyword("left")))||((validateSoftKeyword("order") && validateLT(2, "by")))))) {
                            int LA28_3 = input.LA(3);

                            if ( (LA28_3==IDENTIFIER) && ((((validateSoftKeyword("union")))||((validateSoftKeyword("right")))||((validateSoftKeyword("where")))||((validateSoftKeyword("join")))||((validateSoftKeyword("intersect")))||((validateSoftKeyword("fetch")))||((validateSoftKeyword("cross")))||((validateSoftKeyword("except")))||((validateSoftKeyword("inner")))||((validateSoftKeyword("group") && validateLT(2, "by")))||((validateSoftKeyword("with")))||((validateSoftKeyword("full")))||((validateSoftKeyword("left")))||((validateSoftKeyword("order") && validateLT(2, "by")))))) {
                                int LA28_6 = input.LA(4);

                                if ( (((validateSoftKeyword("fetch")))) ) {
                                    alt28=1;
                                }
                            }
                        }
                    }
                    switch (alt28) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:390:4: propertyFetch
                            {
                            pushFollow(FOLLOW_propertyFetch_in_qualifiedJoin858);
                            propertyFetch83=propertyFetch();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_propertyFetch.add(propertyFetch83.getTree());

                            }
                            break;

                    }


                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:390:19: ( withClause )?
                    int alt29=2;
                    int LA29_0 = input.LA(1);

                    if ( (LA29_0==IDENTIFIER) && ((((validateSoftKeyword("intersect")))||((validateSoftKeyword("union")))||((validateSoftKeyword("right")))||((validateSoftKeyword("where")))||((validateSoftKeyword("except")))||((validateSoftKeyword("cross")))||((validateSoftKeyword("inner")))||((validateSoftKeyword("group") && validateLT(2, "by")))||((validateSoftKeyword("with")))||((validateSoftKeyword("left")))||((validateSoftKeyword("full")))||((validateSoftKeyword("join")))||((validateSoftKeyword("order") && validateLT(2, "by")))))) {
                        int LA29_1 = input.LA(2);

                        if ( (((validateSoftKeyword("with")))) ) {
                            alt29=1;
                        }
                    }
                    switch (alt29) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:390:19: withClause
                            {
                            pushFollow(FOLLOW_withClause_in_qualifiedJoin861);
                            withClause84=withClause();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_withClause.add(withClause84.getTree());

                            }
                            break;

                    }


                    }
                    break;

            }


            // AST REWRITE
            // elements: aliasClause, nonCrossJoinType, withClause, path, aliasClause, logicalExpression, nonCrossJoinType, fetch_key, propertyFetch, on_key
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 392:2: -> {isEntityReference}? ^( PERSISTER_JOIN[$join_key.start,\"persister-join\"] nonCrossJoinType ^( ENTITY_PERSISTER_REF ENTITY_NAME[$path.start, $path.text, entityNames] ( aliasClause )? ) ^( on_key logicalExpression ) )
            if (isEntityReference) {
                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:392:26: ^( PERSISTER_JOIN[$join_key.start,\"persister-join\"] nonCrossJoinType ^( ENTITY_PERSISTER_REF ENTITY_NAME[$path.start, $path.text, entityNames] ( aliasClause )? ) ^( on_key logicalExpression ) )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(PERSISTER_JOIN, (join_key78!=null?((Token)join_key78.start):null), "persister-join")
                , root_1);

                adaptor.addChild(root_1, stream_nonCrossJoinType.nextTree());

                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:392:94: ^( ENTITY_PERSISTER_REF ENTITY_NAME[$path.start, $path.text, entityNames] ( aliasClause )? )
                {
                Object root_2 = (Object)adaptor.nil();
                root_2 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(ENTITY_PERSISTER_REF, "ENTITY_PERSISTER_REF")
                , root_2);

                adaptor.addChild(root_2, 
                new EntityNameTree(ENTITY_NAME, (path80!=null?((Token)path80.start):null), (path80!=null?input.toString(path80.start,path80.stop):null), entityNames)
                );

                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:392:183: ( aliasClause )?
                if ( stream_aliasClause.hasNext() ) {
                    adaptor.addChild(root_2, stream_aliasClause.nextTree());

                }
                stream_aliasClause.reset();

                adaptor.addChild(root_1, root_2);
                }

                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:392:197: ^( on_key logicalExpression )
                {
                Object root_2 = (Object)adaptor.nil();
                root_2 = (Object)adaptor.becomeRoot(stream_on_key.nextNode(), root_2);

                adaptor.addChild(root_2, stream_logicalExpression.nextTree());

                adaptor.addChild(root_1, root_2);
                }

                adaptor.addChild(root_0, root_1);
                }

            }

            else // 393:2: -> ^( PROPERTY_JOIN[$join_key.start, \"property-join\"] nonCrossJoinType ( fetch_key )? ( aliasClause )? ( propertyFetch )? ^( PROPERTY_REFERENCE path ) ( withClause )? )
            {
                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:393:5: ^( PROPERTY_JOIN[$join_key.start, \"property-join\"] nonCrossJoinType ( fetch_key )? ( aliasClause )? ( propertyFetch )? ^( PROPERTY_REFERENCE path ) ( withClause )? )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(PROPERTY_JOIN, (join_key78!=null?((Token)join_key78.start):null), "property-join")
                , root_1);

                adaptor.addChild(root_1, stream_nonCrossJoinType.nextTree());

                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:393:72: ( fetch_key )?
                if ( stream_fetch_key.hasNext() ) {
                    adaptor.addChild(root_1, stream_fetch_key.nextTree());

                }
                stream_fetch_key.reset();

                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:393:83: ( aliasClause )?
                if ( stream_aliasClause.hasNext() ) {
                    adaptor.addChild(root_1, stream_aliasClause.nextTree());

                }
                stream_aliasClause.reset();

                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:393:96: ( propertyFetch )?
                if ( stream_propertyFetch.hasNext() ) {
                    adaptor.addChild(root_1, stream_propertyFetch.nextTree());

                }
                stream_propertyFetch.reset();

                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:393:111: ^( PROPERTY_REFERENCE path )
                {
                Object root_2 = (Object)adaptor.nil();
                root_2 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(PROPERTY_REFERENCE, "PROPERTY_REFERENCE")
                , root_2);

                adaptor.addChild(root_2, stream_path.nextTree());

                adaptor.addChild(root_1, root_2);
                }

                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:393:138: ( withClause )?
                if ( stream_withClause.hasNext() ) {
                    adaptor.addChild(root_1, stream_withClause.nextTree());

                }
                stream_withClause.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { if (!hasFetch) ((fromClause_scope)fromClause_stack.peek()).aliases.add(((Tree)(ac!=null?((Object)ac.tree):null)).getText()); }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "qualifiedJoin"


    public static class withClause_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "withClause"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:396:1: withClause : with_key ^ logicalExpression ;
    public final HQLParser.withClause_return withClause() throws RecognitionException {
        HQLParser.withClause_return retval = new HQLParser.withClause_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.with_key_return with_key85 =null;

        HQLParser.logicalExpression_return logicalExpression86 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:397:2: ( with_key ^ logicalExpression )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:397:4: with_key ^ logicalExpression
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_with_key_in_withClause935);
            with_key85=with_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(with_key85.getTree(), root_0);

            pushFollow(FOLLOW_logicalExpression_in_withClause938);
            logicalExpression86=logicalExpression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, logicalExpression86.getTree());

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "withClause"


    public static class nonCrossJoinType_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "nonCrossJoinType"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:400:1: nonCrossJoinType : ( inner_key | outerJoinType ( outer_key )? | -> INNER );
    public final HQLParser.nonCrossJoinType_return nonCrossJoinType() throws RecognitionException {
        HQLParser.nonCrossJoinType_return retval = new HQLParser.nonCrossJoinType_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.inner_key_return inner_key87 =null;

        HQLParser.outerJoinType_return outerJoinType88 =null;

        HQLParser.outer_key_return outer_key89 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:401:2: ( inner_key | outerJoinType ( outer_key )? | -> INNER )
            int alt32=3;
            int LA32_0 = input.LA(1);

            if ( (LA32_0==IDENTIFIER) && ((((validateSoftKeyword("right")))||((validateSoftKeyword("inner")))||((validateSoftKeyword("left")))||((validateSoftKeyword("full")))||((validateSoftKeyword("join")))))) {
                int LA32_1 = input.LA(2);

                if ( (LA32_1==IDENTIFIER) && (((validateSoftKeyword("join"))))) {
                    alt32=3;
                }
                else if ( (((validateSoftKeyword("inner")))) ) {
                    alt32=1;
                }
                else if ( ((((validateSoftKeyword("right")))||((validateSoftKeyword("full")))||((validateSoftKeyword("left"))))) ) {
                    alt32=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 32, 1, input);

                    throw nvae;

                }
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 32, 0, input);

                throw nvae;

            }
            switch (alt32) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:401:4: inner_key
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_inner_key_in_nonCrossJoinType949);
                    inner_key87=inner_key();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, inner_key87.getTree());

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:402:4: outerJoinType ( outer_key )?
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_outerJoinType_in_nonCrossJoinType954);
                    outerJoinType88=outerJoinType();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, outerJoinType88.getTree());

                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:402:18: ( outer_key )?
                    int alt31=2;
                    int LA31_0 = input.LA(1);

                    if ( (LA31_0==IDENTIFIER) && ((((validateSoftKeyword("outer")))||((validateSoftKeyword("join")))))) {
                        int LA31_1 = input.LA(2);

                        if ( (LA31_1==IDENTIFIER) && ((((validateSoftKeyword("outer")))||((validateSoftKeyword("join")))))) {
                            int LA31_2 = input.LA(3);

                            if ( (((validateSoftKeyword("outer")))) ) {
                                alt31=1;
                            }
                        }
                    }
                    switch (alt31) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:402:18: outer_key
                            {
                            pushFollow(FOLLOW_outer_key_in_nonCrossJoinType956);
                            outer_key89=outer_key();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) adaptor.addChild(root_0, outer_key89.getTree());

                            }
                            break;

                    }


                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:403:4: 
                    {
                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (Object)adaptor.nil();
                    // 403:4: -> INNER
                    {
                        adaptor.addChild(root_0, 
                        (Object)adaptor.create(INNER, "INNER")
                        );

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "nonCrossJoinType"


    public static class outerJoinType_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "outerJoinType"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:406:1: outerJoinType : ( left_key | right_key | full_key );
    public final HQLParser.outerJoinType_return outerJoinType() throws RecognitionException {
        HQLParser.outerJoinType_return retval = new HQLParser.outerJoinType_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.left_key_return left_key90 =null;

        HQLParser.right_key_return right_key91 =null;

        HQLParser.full_key_return full_key92 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:407:2: ( left_key | right_key | full_key )
            int alt33=3;
            int LA33_0 = input.LA(1);

            if ( (LA33_0==IDENTIFIER) && ((((validateSoftKeyword("right")))||((validateSoftKeyword("full")))||((validateSoftKeyword("left")))))) {
                int LA33_1 = input.LA(2);

                if ( (((validateSoftKeyword("left")))) ) {
                    alt33=1;
                }
                else if ( (((validateSoftKeyword("right")))) ) {
                    alt33=2;
                }
                else if ( (((validateSoftKeyword("full")))) ) {
                    alt33=3;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 33, 1, input);

                    throw nvae;

                }
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 33, 0, input);

                throw nvae;

            }
            switch (alt33) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:407:4: left_key
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_left_key_in_outerJoinType975);
                    left_key90=left_key();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, left_key90.getTree());

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:408:4: right_key
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_right_key_in_outerJoinType980);
                    right_key91=right_key();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, right_key91.getTree());

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:409:4: full_key
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_full_key_in_outerJoinType985);
                    full_key92=full_key();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, full_key92.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "outerJoinType"


    public static class persisterSpaceRoot_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "persisterSpaceRoot"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:412:1: persisterSpaceRoot options {backtrack=true; } : ( hibernateLegacySyntax | jpaCollectionReference | mainEntityPersisterReference );
    public final HQLParser.persisterSpaceRoot_return persisterSpaceRoot() throws RecognitionException {
        HQLParser.persisterSpaceRoot_return retval = new HQLParser.persisterSpaceRoot_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.hibernateLegacySyntax_return hibernateLegacySyntax93 =null;

        HQLParser.jpaCollectionReference_return jpaCollectionReference94 =null;

        HQLParser.mainEntityPersisterReference_return mainEntityPersisterReference95 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:415:3: ( hibernateLegacySyntax | jpaCollectionReference | mainEntityPersisterReference )
            int alt34=3;
            int LA34_0 = input.LA(1);

            if ( (LA34_0==IDENTIFIER) ) {
                int LA34_1 = input.LA(2);

                if ( (synpred1_HQLParser()) ) {
                    alt34=1;
                }
                else if ( (((synpred2_HQLParser()&&synpred2_HQLParser())&&((validateSoftKeyword("in"))))) ) {
                    alt34=2;
                }
                else if ( (true) ) {
                    alt34=3;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 34, 1, input);

                    throw nvae;

                }
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 34, 0, input);

                throw nvae;

            }
            switch (alt34) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:415:5: hibernateLegacySyntax
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_hibernateLegacySyntax_in_persisterSpaceRoot1004);
                    hibernateLegacySyntax93=hibernateLegacySyntax();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, hibernateLegacySyntax93.getTree());

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:416:4: jpaCollectionReference
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_jpaCollectionReference_in_persisterSpaceRoot1009);
                    jpaCollectionReference94=jpaCollectionReference();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, jpaCollectionReference94.getTree());

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:417:4: mainEntityPersisterReference
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_mainEntityPersisterReference_in_persisterSpaceRoot1014);
                    mainEntityPersisterReference95=mainEntityPersisterReference();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, mainEntityPersisterReference95.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "persisterSpaceRoot"


    public static class mainEntityPersisterReference_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "mainEntityPersisterReference"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:420:1: mainEntityPersisterReference : entityName ac= aliasClause[true] ( propertyFetch )? -> ^( ENTITY_PERSISTER_REF entityName ( aliasClause )? ( propertyFetch )? ) ;
    public final HQLParser.mainEntityPersisterReference_return mainEntityPersisterReference() throws RecognitionException {
        HQLParser.mainEntityPersisterReference_return retval = new HQLParser.mainEntityPersisterReference_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.aliasClause_return ac =null;

        HQLParser.entityName_return entityName96 =null;

        HQLParser.propertyFetch_return propertyFetch97 =null;


        RewriteRuleSubtreeStream stream_propertyFetch=new RewriteRuleSubtreeStream(adaptor,"rule propertyFetch");
        RewriteRuleSubtreeStream stream_aliasClause=new RewriteRuleSubtreeStream(adaptor,"rule aliasClause");
        RewriteRuleSubtreeStream stream_entityName=new RewriteRuleSubtreeStream(adaptor,"rule entityName");
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:422:2: ( entityName ac= aliasClause[true] ( propertyFetch )? -> ^( ENTITY_PERSISTER_REF entityName ( aliasClause )? ( propertyFetch )? ) )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:422:4: entityName ac= aliasClause[true] ( propertyFetch )?
            {
            pushFollow(FOLLOW_entityName_in_mainEntityPersisterReference1030);
            entityName96=entityName();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_entityName.add(entityName96.getTree());

            pushFollow(FOLLOW_aliasClause_in_mainEntityPersisterReference1034);
            ac=aliasClause(true);

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_aliasClause.add(ac.getTree());

            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:422:36: ( propertyFetch )?
            int alt35=2;
            int LA35_0 = input.LA(1);

            if ( (LA35_0==IDENTIFIER) && ((((validateSoftKeyword("intersect")))||((validateSoftKeyword("union")))||((validateSoftKeyword("right")))||((validateSoftKeyword("where")))||((validateSoftKeyword("fetch")))||((validateSoftKeyword("except")))||((validateSoftKeyword("cross")))||((validateSoftKeyword("inner")))||((validateSoftKeyword("group") && validateLT(2, "by")))||((validateSoftKeyword("full")))||((validateSoftKeyword("left")))||((validateSoftKeyword("join")))||((validateSoftKeyword("order") && validateLT(2, "by")))))) {
                int LA35_1 = input.LA(2);

                if ( (LA35_1==IDENTIFIER) && ((((validateSoftKeyword("intersect")))||((validateSoftKeyword("union")))||((validateSoftKeyword("right")))||((validateSoftKeyword("where")))||((validateSoftKeyword("cross")))||((validateSoftKeyword("fetch")))||((validateSoftKeyword("except")))||((validateSoftKeyword("inner")))||((validateSoftKeyword("group") && validateLT(2, "by")))||((validateSoftKeyword("left")))||((validateSoftKeyword("full")))||((validateSoftKeyword("join")))||((validateSoftKeyword("order") && validateLT(2, "by")))))) {
                    int LA35_3 = input.LA(3);

                    if ( (LA35_3==IDENTIFIER) && ((((validateSoftKeyword("intersect")))||((validateSoftKeyword("right")))||((validateSoftKeyword("union")))||((validateSoftKeyword("where")))||((validateSoftKeyword("fetch")))||((validateSoftKeyword("cross")))||((validateSoftKeyword("except")))||((validateSoftKeyword("inner")))||((validateSoftKeyword("group") && validateLT(2, "by")))||((validateSoftKeyword("full")))||((validateSoftKeyword("left")))||((validateSoftKeyword("join")))||((validateSoftKeyword("order") && validateLT(2, "by")))))) {
                        int LA35_6 = input.LA(4);

                        if ( (((validateSoftKeyword("fetch")))) ) {
                            alt35=1;
                        }
                    }
                }
            }
            switch (alt35) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:422:36: propertyFetch
                    {
                    pushFollow(FOLLOW_propertyFetch_in_mainEntityPersisterReference1037);
                    propertyFetch97=propertyFetch();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_propertyFetch.add(propertyFetch97.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: propertyFetch, aliasClause, entityName
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 423:3: -> ^( ENTITY_PERSISTER_REF entityName ( aliasClause )? ( propertyFetch )? )
            {
                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:423:6: ^( ENTITY_PERSISTER_REF entityName ( aliasClause )? ( propertyFetch )? )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(ENTITY_PERSISTER_REF, "ENTITY_PERSISTER_REF")
                , root_1);

                adaptor.addChild(root_1, stream_entityName.nextTree());

                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:423:40: ( aliasClause )?
                if ( stream_aliasClause.hasNext() ) {
                    adaptor.addChild(root_1, stream_aliasClause.nextTree());

                }
                stream_aliasClause.reset();

                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:423:53: ( propertyFetch )?
                if ( stream_propertyFetch.hasNext() ) {
                    adaptor.addChild(root_1, stream_propertyFetch.nextTree());

                }
                stream_propertyFetch.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { ((fromClause_scope)fromClause_stack.peek()).aliases.add(((Tree)(ac!=null?((Object)ac.tree):null)).getText()); }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "mainEntityPersisterReference"


    public static class propertyFetch_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "propertyFetch"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:426:1: propertyFetch : fetch_key all_key properties_key -> PROP_FETCH[$fetch_key.start, \"property-fetch\"] ;
    public final HQLParser.propertyFetch_return propertyFetch() throws RecognitionException {
        HQLParser.propertyFetch_return retval = new HQLParser.propertyFetch_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.fetch_key_return fetch_key98 =null;

        HQLParser.all_key_return all_key99 =null;

        HQLParser.properties_key_return properties_key100 =null;


        RewriteRuleSubtreeStream stream_fetch_key=new RewriteRuleSubtreeStream(adaptor,"rule fetch_key");
        RewriteRuleSubtreeStream stream_all_key=new RewriteRuleSubtreeStream(adaptor,"rule all_key");
        RewriteRuleSubtreeStream stream_properties_key=new RewriteRuleSubtreeStream(adaptor,"rule properties_key");
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:427:2: ( fetch_key all_key properties_key -> PROP_FETCH[$fetch_key.start, \"property-fetch\"] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:427:4: fetch_key all_key properties_key
            {
            pushFollow(FOLLOW_fetch_key_in_propertyFetch1065);
            fetch_key98=fetch_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_fetch_key.add(fetch_key98.getTree());

            pushFollow(FOLLOW_all_key_in_propertyFetch1067);
            all_key99=all_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_all_key.add(all_key99.getTree());

            pushFollow(FOLLOW_properties_key_in_propertyFetch1069);
            properties_key100=properties_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_properties_key.add(properties_key100.getTree());

            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 428:3: -> PROP_FETCH[$fetch_key.start, \"property-fetch\"]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(PROP_FETCH, (fetch_key98!=null?((Token)fetch_key98.start):null), "property-fetch")
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "propertyFetch"


    public static class hibernateLegacySyntax_return extends ParserRuleReturnScope {
        public boolean isPropertyJoin;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "hibernateLegacySyntax"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:431:1: hibernateLegacySyntax returns [boolean isPropertyJoin] : ad= aliasDeclaration in_key ( class_key entityName -> ^( ENTITY_PERSISTER_REF entityName aliasDeclaration ) | collectionExpression -> ^( PROPERTY_JOIN INNER[$in_key.start, \"inner legacy\"] aliasDeclaration collectionExpression ) ) ;
    public final HQLParser.hibernateLegacySyntax_return hibernateLegacySyntax() throws RecognitionException {
        HQLParser.hibernateLegacySyntax_return retval = new HQLParser.hibernateLegacySyntax_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.aliasDeclaration_return ad =null;

        HQLParser.in_key_return in_key101 =null;

        HQLParser.class_key_return class_key102 =null;

        HQLParser.entityName_return entityName103 =null;

        HQLParser.collectionExpression_return collectionExpression104 =null;


        RewriteRuleSubtreeStream stream_collectionExpression=new RewriteRuleSubtreeStream(adaptor,"rule collectionExpression");
        RewriteRuleSubtreeStream stream_aliasDeclaration=new RewriteRuleSubtreeStream(adaptor,"rule aliasDeclaration");
        RewriteRuleSubtreeStream stream_class_key=new RewriteRuleSubtreeStream(adaptor,"rule class_key");
        RewriteRuleSubtreeStream stream_in_key=new RewriteRuleSubtreeStream(adaptor,"rule in_key");
        RewriteRuleSubtreeStream stream_entityName=new RewriteRuleSubtreeStream(adaptor,"rule entityName");
        retval.isPropertyJoin = false;
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:434:2: (ad= aliasDeclaration in_key ( class_key entityName -> ^( ENTITY_PERSISTER_REF entityName aliasDeclaration ) | collectionExpression -> ^( PROPERTY_JOIN INNER[$in_key.start, \"inner legacy\"] aliasDeclaration collectionExpression ) ) )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:434:4: ad= aliasDeclaration in_key ( class_key entityName -> ^( ENTITY_PERSISTER_REF entityName aliasDeclaration ) | collectionExpression -> ^( PROPERTY_JOIN INNER[$in_key.start, \"inner legacy\"] aliasDeclaration collectionExpression ) )
            {
            pushFollow(FOLLOW_aliasDeclaration_in_hibernateLegacySyntax1103);
            ad=aliasDeclaration();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_aliasDeclaration.add(ad.getTree());

            pushFollow(FOLLOW_in_key_in_hibernateLegacySyntax1105);
            in_key101=in_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_in_key.add(in_key101.getTree());

            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:435:2: ( class_key entityName -> ^( ENTITY_PERSISTER_REF entityName aliasDeclaration ) | collectionExpression -> ^( PROPERTY_JOIN INNER[$in_key.start, \"inner legacy\"] aliasDeclaration collectionExpression ) )
            int alt36=2;
            int LA36_0 = input.LA(1);

            if ( (LA36_0==IDENTIFIER) && ((((validateSoftKeyword("elements")))||((validateSoftKeyword("indices")))||((validateSoftKeyword("class")))))) {
                int LA36_1 = input.LA(2);

                if ( (LA36_1==IDENTIFIER) && (((validateSoftKeyword("class"))))) {
                    alt36=1;
                }
                else if ( (LA36_1==LEFT_PAREN) && ((((validateSoftKeyword("elements")))||((validateSoftKeyword("indices")))))) {
                    alt36=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 36, 1, input);

                    throw nvae;

                }
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 36, 0, input);

                throw nvae;

            }
            switch (alt36) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:435:4: class_key entityName
                    {
                    pushFollow(FOLLOW_class_key_in_hibernateLegacySyntax1110);
                    class_key102=class_key();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_class_key.add(class_key102.getTree());

                    pushFollow(FOLLOW_entityName_in_hibernateLegacySyntax1112);
                    entityName103=entityName();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_entityName.add(entityName103.getTree());

                    // AST REWRITE
                    // elements: entityName, aliasDeclaration
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (Object)adaptor.nil();
                    // 435:25: -> ^( ENTITY_PERSISTER_REF entityName aliasDeclaration )
                    {
                        // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:435:28: ^( ENTITY_PERSISTER_REF entityName aliasDeclaration )
                        {
                        Object root_1 = (Object)adaptor.nil();
                        root_1 = (Object)adaptor.becomeRoot(
                        (Object)adaptor.create(ENTITY_PERSISTER_REF, "ENTITY_PERSISTER_REF")
                        , root_1);

                        adaptor.addChild(root_1, stream_entityName.nextTree());

                        adaptor.addChild(root_1, stream_aliasDeclaration.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:436:4: collectionExpression
                    {
                    pushFollow(FOLLOW_collectionExpression_in_hibernateLegacySyntax1127);
                    collectionExpression104=collectionExpression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_collectionExpression.add(collectionExpression104.getTree());

                    if ( state.backtracking==0 ) {retval.isPropertyJoin = true;}

                    // AST REWRITE
                    // elements: aliasDeclaration, collectionExpression
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (Object)adaptor.nil();
                    // 436:51: -> ^( PROPERTY_JOIN INNER[$in_key.start, \"inner legacy\"] aliasDeclaration collectionExpression )
                    {
                        // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:436:54: ^( PROPERTY_JOIN INNER[$in_key.start, \"inner legacy\"] aliasDeclaration collectionExpression )
                        {
                        Object root_1 = (Object)adaptor.nil();
                        root_1 = (Object)adaptor.becomeRoot(
                        (Object)adaptor.create(PROPERTY_JOIN, "PROPERTY_JOIN")
                        , root_1);

                        adaptor.addChild(root_1, 
                        (Object)adaptor.create(INNER, (in_key101!=null?((Token)in_key101.start):null), "inner legacy")
                        );

                        adaptor.addChild(root_1, stream_aliasDeclaration.nextTree());

                        adaptor.addChild(root_1, stream_collectionExpression.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { ((fromClause_scope)fromClause_stack.peek()).aliases.add(((Tree)(ad!=null?((Object)ad.tree):null)).getText()); }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "hibernateLegacySyntax"


    public static class jpaCollectionReference_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "jpaCollectionReference"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:440:1: jpaCollectionReference : in_key LEFT_PAREN propertyReference RIGHT_PAREN ac= aliasClause[true] -> ^( PROPERTY_JOIN INNER[$in_key.start, \"inner\"] ( aliasClause )? propertyReference ) ;
    public final HQLParser.jpaCollectionReference_return jpaCollectionReference() throws RecognitionException {
        HQLParser.jpaCollectionReference_return retval = new HQLParser.jpaCollectionReference_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token LEFT_PAREN106=null;
        Token RIGHT_PAREN108=null;
        HQLParser.aliasClause_return ac =null;

        HQLParser.in_key_return in_key105 =null;

        HQLParser.propertyReference_return propertyReference107 =null;


        Object LEFT_PAREN106_tree=null;
        Object RIGHT_PAREN108_tree=null;
        RewriteRuleTokenStream stream_LEFT_PAREN=new RewriteRuleTokenStream(adaptor,"token LEFT_PAREN");
        RewriteRuleTokenStream stream_RIGHT_PAREN=new RewriteRuleTokenStream(adaptor,"token RIGHT_PAREN");
        RewriteRuleSubtreeStream stream_aliasClause=new RewriteRuleSubtreeStream(adaptor,"rule aliasClause");
        RewriteRuleSubtreeStream stream_propertyReference=new RewriteRuleSubtreeStream(adaptor,"rule propertyReference");
        RewriteRuleSubtreeStream stream_in_key=new RewriteRuleSubtreeStream(adaptor,"rule in_key");
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:442:2: ( in_key LEFT_PAREN propertyReference RIGHT_PAREN ac= aliasClause[true] -> ^( PROPERTY_JOIN INNER[$in_key.start, \"inner\"] ( aliasClause )? propertyReference ) )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:442:4: in_key LEFT_PAREN propertyReference RIGHT_PAREN ac= aliasClause[true]
            {
            pushFollow(FOLLOW_in_key_in_jpaCollectionReference1161);
            in_key105=in_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_in_key.add(in_key105.getTree());

            LEFT_PAREN106=(Token)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_jpaCollectionReference1163); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_LEFT_PAREN.add(LEFT_PAREN106);


            pushFollow(FOLLOW_propertyReference_in_jpaCollectionReference1165);
            propertyReference107=propertyReference();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_propertyReference.add(propertyReference107.getTree());

            RIGHT_PAREN108=(Token)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_jpaCollectionReference1167); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_RIGHT_PAREN.add(RIGHT_PAREN108);


            pushFollow(FOLLOW_aliasClause_in_jpaCollectionReference1171);
            ac=aliasClause(true);

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_aliasClause.add(ac.getTree());

            // AST REWRITE
            // elements: aliasClause, propertyReference
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 443:3: -> ^( PROPERTY_JOIN INNER[$in_key.start, \"inner\"] ( aliasClause )? propertyReference )
            {
                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:443:6: ^( PROPERTY_JOIN INNER[$in_key.start, \"inner\"] ( aliasClause )? propertyReference )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(PROPERTY_JOIN, "PROPERTY_JOIN")
                , root_1);

                adaptor.addChild(root_1, 
                (Object)adaptor.create(INNER, (in_key105!=null?((Token)in_key105.start):null), "inner")
                );

                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:443:52: ( aliasClause )?
                if ( stream_aliasClause.hasNext() ) {
                    adaptor.addChild(root_1, stream_aliasClause.nextTree());

                }
                stream_aliasClause.reset();

                adaptor.addChild(root_1, stream_propertyReference.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { ((fromClause_scope)fromClause_stack.peek()).aliases.add(((Tree)(ac!=null?((Object)ac.tree):null)).getText()); }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "jpaCollectionReference"


    public static class selectClause_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "selectClause"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:446:1: selectClause : select_key ^ ( distinct_key )? rootSelectExpression ;
    public final HQLParser.selectClause_return selectClause() throws RecognitionException {
        HQLParser.selectClause_return retval = new HQLParser.selectClause_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.select_key_return select_key109 =null;

        HQLParser.distinct_key_return distinct_key110 =null;

        HQLParser.rootSelectExpression_return rootSelectExpression111 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:447:2: ( select_key ^ ( distinct_key )? rootSelectExpression )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:447:4: select_key ^ ( distinct_key )? rootSelectExpression
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_select_key_in_selectClause1199);
            select_key109=select_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(select_key109.getTree(), root_0);

            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:447:16: ( distinct_key )?
            int alt37=2;
            int LA37_0 = input.LA(1);

            if ( (LA37_0==IDENTIFIER) ) {
                int LA37_1 = input.LA(2);

                if ( (((validateSoftKeyword("distinct")))) ) {
                    alt37=1;
                }
            }
            switch (alt37) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:447:16: distinct_key
                    {
                    pushFollow(FOLLOW_distinct_key_in_selectClause1202);
                    distinct_key110=distinct_key();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, distinct_key110.getTree());

                    }
                    break;

            }


            pushFollow(FOLLOW_rootSelectExpression_in_selectClause1205);
            rootSelectExpression111=rootSelectExpression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, rootSelectExpression111.getTree());

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "selectClause"


    public static class rootSelectExpression_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "rootSelectExpression"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:450:1: rootSelectExpression : ( rootDynamicInstantiation | jpaSelectObjectSyntax | explicitSelectList );
    public final HQLParser.rootSelectExpression_return rootSelectExpression() throws RecognitionException {
        HQLParser.rootSelectExpression_return retval = new HQLParser.rootSelectExpression_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.rootDynamicInstantiation_return rootDynamicInstantiation112 =null;

        HQLParser.jpaSelectObjectSyntax_return jpaSelectObjectSyntax113 =null;

        HQLParser.explicitSelectList_return explicitSelectList114 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:451:2: ( rootDynamicInstantiation | jpaSelectObjectSyntax | explicitSelectList )
            int alt38=3;
            int LA38_0 = input.LA(1);

            if ( (LA38_0==IDENTIFIER) ) {
                int LA38_1 = input.LA(2);

                if ( (((validateSoftKeyword("new")))) ) {
                    alt38=1;
                }
                else if ( (((validateSoftKeyword("object")))) ) {
                    alt38=2;
                }
                else if ( (true) ) {
                    alt38=3;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 38, 1, input);

                    throw nvae;

                }
            }
            else if ( (LA38_0==CHARACTER_LITERAL||LA38_0==COLON||LA38_0==DECIMAL_LITERAL||LA38_0==FALSE||LA38_0==FLOATING_POINT_LITERAL||LA38_0==HEX_LITERAL||LA38_0==INTEGER_LITERAL||LA38_0==LEFT_PAREN||LA38_0==MINUS||LA38_0==NULL||LA38_0==OCTAL_LITERAL||LA38_0==PARAM||LA38_0==PLUS||LA38_0==STRING_LITERAL||LA38_0==TRUE) ) {
                alt38=3;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 38, 0, input);

                throw nvae;

            }
            switch (alt38) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:451:4: rootDynamicInstantiation
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_rootDynamicInstantiation_in_rootSelectExpression1216);
                    rootDynamicInstantiation112=rootDynamicInstantiation();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, rootDynamicInstantiation112.getTree());

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:452:4: jpaSelectObjectSyntax
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_jpaSelectObjectSyntax_in_rootSelectExpression1221);
                    jpaSelectObjectSyntax113=jpaSelectObjectSyntax();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, jpaSelectObjectSyntax113.getTree());

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:453:4: explicitSelectList
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_explicitSelectList_in_rootSelectExpression1226);
                    explicitSelectList114=explicitSelectList();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, explicitSelectList114.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "rootSelectExpression"


    public static class explicitSelectList_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "explicitSelectList"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:456:1: explicitSelectList : explicitSelectItem ( COMMA explicitSelectItem )* -> ^( SELECT_LIST ( explicitSelectItem )+ ) ;
    public final HQLParser.explicitSelectList_return explicitSelectList() throws RecognitionException {
        HQLParser.explicitSelectList_return retval = new HQLParser.explicitSelectList_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token COMMA116=null;
        HQLParser.explicitSelectItem_return explicitSelectItem115 =null;

        HQLParser.explicitSelectItem_return explicitSelectItem117 =null;


        Object COMMA116_tree=null;
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleSubtreeStream stream_explicitSelectItem=new RewriteRuleSubtreeStream(adaptor,"rule explicitSelectItem");
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:457:2: ( explicitSelectItem ( COMMA explicitSelectItem )* -> ^( SELECT_LIST ( explicitSelectItem )+ ) )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:457:4: explicitSelectItem ( COMMA explicitSelectItem )*
            {
            pushFollow(FOLLOW_explicitSelectItem_in_explicitSelectList1237);
            explicitSelectItem115=explicitSelectItem();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_explicitSelectItem.add(explicitSelectItem115.getTree());

            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:457:23: ( COMMA explicitSelectItem )*
            loop39:
            do {
                int alt39=2;
                int LA39_0 = input.LA(1);

                if ( (LA39_0==COMMA) ) {
                    alt39=1;
                }


                switch (alt39) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:457:25: COMMA explicitSelectItem
            	    {
            	    COMMA116=(Token)match(input,COMMA,FOLLOW_COMMA_in_explicitSelectList1241); if (state.failed) return retval; 
            	    if ( state.backtracking==0 ) stream_COMMA.add(COMMA116);


            	    pushFollow(FOLLOW_explicitSelectItem_in_explicitSelectList1243);
            	    explicitSelectItem117=explicitSelectItem();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) stream_explicitSelectItem.add(explicitSelectItem117.getTree());

            	    }
            	    break;

            	default :
            	    break loop39;
                }
            } while (true);


            // AST REWRITE
            // elements: explicitSelectItem
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 458:3: -> ^( SELECT_LIST ( explicitSelectItem )+ )
            {
                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:458:6: ^( SELECT_LIST ( explicitSelectItem )+ )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(SELECT_LIST, "SELECT_LIST")
                , root_1);

                if ( !(stream_explicitSelectItem.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_explicitSelectItem.hasNext() ) {
                    adaptor.addChild(root_1, stream_explicitSelectItem.nextTree());

                }
                stream_explicitSelectItem.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "explicitSelectList"


    public static class explicitSelectItem_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "explicitSelectItem"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:461:1: explicitSelectItem : selectExpression ;
    public final HQLParser.explicitSelectItem_return explicitSelectItem() throws RecognitionException {
        HQLParser.explicitSelectItem_return retval = new HQLParser.explicitSelectItem_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.selectExpression_return selectExpression118 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:462:2: ( selectExpression )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:462:4: selectExpression
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_selectExpression_in_explicitSelectItem1268);
            selectExpression118=selectExpression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, selectExpression118.getTree());

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "explicitSelectItem"


    public static class selectExpression_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "selectExpression"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:465:1: selectExpression : expression aliasClause[false] -> ^( SELECT_ITEM expression ( aliasClause )? ) ;
    public final HQLParser.selectExpression_return selectExpression() throws RecognitionException {
        HQLParser.selectExpression_return retval = new HQLParser.selectExpression_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.expression_return expression119 =null;

        HQLParser.aliasClause_return aliasClause120 =null;


        RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");
        RewriteRuleSubtreeStream stream_aliasClause=new RewriteRuleSubtreeStream(adaptor,"rule aliasClause");
         if (state.backtracking == 0) enableParameterUsage.push(Boolean.FALSE); 
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:469:2: ( expression aliasClause[false] -> ^( SELECT_ITEM expression ( aliasClause )? ) )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:469:4: expression aliasClause[false]
            {
            pushFollow(FOLLOW_expression_in_selectExpression1290);
            expression119=expression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_expression.add(expression119.getTree());

            pushFollow(FOLLOW_aliasClause_in_selectExpression1292);
            aliasClause120=aliasClause(false);

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_aliasClause.add(aliasClause120.getTree());

            // AST REWRITE
            // elements: expression, aliasClause
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 470:3: -> ^( SELECT_ITEM expression ( aliasClause )? )
            {
                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:470:6: ^( SELECT_ITEM expression ( aliasClause )? )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(SELECT_ITEM, "SELECT_ITEM")
                , root_1);

                adaptor.addChild(root_1, stream_expression.nextTree());

                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:470:31: ( aliasClause )?
                if ( stream_aliasClause.hasNext() ) {
                    adaptor.addChild(root_1, stream_aliasClause.nextTree());

                }
                stream_aliasClause.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { enableParameterUsage.pop(); }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "selectExpression"


    public static class aliasClause_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "aliasClause"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:473:1: aliasClause[boolean generateAlias] options {k=2; } : ( -> {$generateAlias}? ALIAS_NAME[context.buildUniqueImplicitAlias()] ->| aliasDeclaration | as_key ! aliasDeclaration );
    public final HQLParser.aliasClause_return aliasClause(boolean generateAlias) throws RecognitionException {
        HQLParser.aliasClause_return retval = new HQLParser.aliasClause_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.aliasDeclaration_return aliasDeclaration121 =null;

        HQLParser.as_key_return as_key122 =null;

        HQLParser.aliasDeclaration_return aliasDeclaration123 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:476:3: ( -> {$generateAlias}? ALIAS_NAME[context.buildUniqueImplicitAlias()] ->| aliasDeclaration | as_key ! aliasDeclaration )
            int alt40=3;
            int LA40_0 = input.LA(1);

            if ( (LA40_0==IDENTIFIER) ) {
                int LA40_1 = input.LA(2);

                if ( (LA40_1==IDENTIFIER) && (((validateSoftKeyword("as"))))) {
                    alt40=3;
                }
                else if ( ((((validateSoftKeyword("right")))||((validateSoftKeyword("on")))||((validateSoftKeyword("union")))||((validateSoftKeyword("where")))||((validateSoftKeyword("from")))||((validateSoftKeyword("join")))||((validateSoftKeyword("intersect")))||((validateSoftKeyword("cross")))||((validateSoftKeyword("fetch")))||((validateSoftKeyword("except")))||((validateSoftKeyword("inner")))||((validateSoftKeyword("group") && validateLT(2, "by")))||((validateSoftKeyword("with")))||((validateSoftKeyword("full")))||((validateSoftKeyword("left")))||((validateSoftKeyword("order") && validateLT(2, "by")))||((validateSoftKeyword("set"))))) ) {
                    alt40=1;
                }
                else if ( (true) ) {
                    alt40=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 40, 1, input);

                    throw nvae;

                }
            }
            else if ( (LA40_0==EOF||LA40_0==COMMA||LA40_0==RIGHT_PAREN) ) {
                alt40=1;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 40, 0, input);

                throw nvae;

            }
            switch (alt40) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:476:5: 
                    {
                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (Object)adaptor.nil();
                    // 476:5: -> {$generateAlias}? ALIAS_NAME[context.buildUniqueImplicitAlias()]
                    if (generateAlias) {
                        adaptor.addChild(root_0, 
                        (Object)adaptor.create(ALIAS_NAME, context.buildUniqueImplicitAlias())
                        );

                    }

                    else // 477:3: ->
                    {
                        root_0 = null;
                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:478:4: aliasDeclaration
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_aliasDeclaration_in_aliasClause1344);
                    aliasDeclaration121=aliasDeclaration();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, aliasDeclaration121.getTree());

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:479:4: as_key ! aliasDeclaration
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_as_key_in_aliasClause1349);
                    as_key122=as_key();

                    state._fsp--;
                    if (state.failed) return retval;

                    pushFollow(FOLLOW_aliasDeclaration_in_aliasClause1352);
                    aliasDeclaration123=aliasDeclaration();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, aliasDeclaration123.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "aliasClause"


    public static class aliasDeclaration_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "aliasDeclaration"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:482:1: aliasDeclaration : IDENTIFIER -> ALIAS_NAME[$IDENTIFIER] ;
    public final HQLParser.aliasDeclaration_return aliasDeclaration() throws RecognitionException {
        HQLParser.aliasDeclaration_return retval = new HQLParser.aliasDeclaration_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token IDENTIFIER124=null;

        Object IDENTIFIER124_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:483:2: ( IDENTIFIER -> ALIAS_NAME[$IDENTIFIER] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:483:4: IDENTIFIER
            {
            IDENTIFIER124=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_aliasDeclaration1363); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(IDENTIFIER124);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 483:15: -> ALIAS_NAME[$IDENTIFIER]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(ALIAS_NAME, IDENTIFIER124)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "aliasDeclaration"


    public static class aliasReference_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "aliasReference"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:486:1: aliasReference : IDENTIFIER -> ALIAS_REF[$IDENTIFIER] ;
    public final HQLParser.aliasReference_return aliasReference() throws RecognitionException {
        HQLParser.aliasReference_return retval = new HQLParser.aliasReference_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token IDENTIFIER125=null;

        Object IDENTIFIER125_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:487:2: ( IDENTIFIER -> ALIAS_REF[$IDENTIFIER] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:487:4: IDENTIFIER
            {
            IDENTIFIER125=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_aliasReference1379); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(IDENTIFIER125);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 487:15: -> ALIAS_REF[$IDENTIFIER]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(ALIAS_REF, IDENTIFIER125)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "aliasReference"


    public static class rootDynamicInstantiation_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "rootDynamicInstantiation"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:490:1: rootDynamicInstantiation : new_key dynamicInstantiationTarget LEFT_PAREN dynamicInstantiationArgs RIGHT_PAREN -> ^( SELECT_ITEM ^( DYNAMIC_INSTANTIATION[$dynamicInstantiationTarget.start, $dynamicInstantiationTarget.text] dynamicInstantiationArgs ) ) ;
    public final HQLParser.rootDynamicInstantiation_return rootDynamicInstantiation() throws RecognitionException {
        HQLParser.rootDynamicInstantiation_return retval = new HQLParser.rootDynamicInstantiation_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token LEFT_PAREN128=null;
        Token RIGHT_PAREN130=null;
        HQLParser.new_key_return new_key126 =null;

        HQLParser.dynamicInstantiationTarget_return dynamicInstantiationTarget127 =null;

        HQLParser.dynamicInstantiationArgs_return dynamicInstantiationArgs129 =null;


        Object LEFT_PAREN128_tree=null;
        Object RIGHT_PAREN130_tree=null;
        RewriteRuleTokenStream stream_LEFT_PAREN=new RewriteRuleTokenStream(adaptor,"token LEFT_PAREN");
        RewriteRuleTokenStream stream_RIGHT_PAREN=new RewriteRuleTokenStream(adaptor,"token RIGHT_PAREN");
        RewriteRuleSubtreeStream stream_new_key=new RewriteRuleSubtreeStream(adaptor,"rule new_key");
        RewriteRuleSubtreeStream stream_dynamicInstantiationArgs=new RewriteRuleSubtreeStream(adaptor,"rule dynamicInstantiationArgs");
        RewriteRuleSubtreeStream stream_dynamicInstantiationTarget=new RewriteRuleSubtreeStream(adaptor,"rule dynamicInstantiationTarget");
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:491:2: ( new_key dynamicInstantiationTarget LEFT_PAREN dynamicInstantiationArgs RIGHT_PAREN -> ^( SELECT_ITEM ^( DYNAMIC_INSTANTIATION[$dynamicInstantiationTarget.start, $dynamicInstantiationTarget.text] dynamicInstantiationArgs ) ) )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:491:4: new_key dynamicInstantiationTarget LEFT_PAREN dynamicInstantiationArgs RIGHT_PAREN
            {
            pushFollow(FOLLOW_new_key_in_rootDynamicInstantiation1395);
            new_key126=new_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_new_key.add(new_key126.getTree());

            pushFollow(FOLLOW_dynamicInstantiationTarget_in_rootDynamicInstantiation1397);
            dynamicInstantiationTarget127=dynamicInstantiationTarget();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_dynamicInstantiationTarget.add(dynamicInstantiationTarget127.getTree());

            LEFT_PAREN128=(Token)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_rootDynamicInstantiation1399); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_LEFT_PAREN.add(LEFT_PAREN128);


            pushFollow(FOLLOW_dynamicInstantiationArgs_in_rootDynamicInstantiation1401);
            dynamicInstantiationArgs129=dynamicInstantiationArgs();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_dynamicInstantiationArgs.add(dynamicInstantiationArgs129.getTree());

            RIGHT_PAREN130=(Token)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_rootDynamicInstantiation1403); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_RIGHT_PAREN.add(RIGHT_PAREN130);


            // AST REWRITE
            // elements: dynamicInstantiationArgs
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 492:3: -> ^( SELECT_ITEM ^( DYNAMIC_INSTANTIATION[$dynamicInstantiationTarget.start, $dynamicInstantiationTarget.text] dynamicInstantiationArgs ) )
            {
                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:492:6: ^( SELECT_ITEM ^( DYNAMIC_INSTANTIATION[$dynamicInstantiationTarget.start, $dynamicInstantiationTarget.text] dynamicInstantiationArgs ) )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(SELECT_ITEM, "SELECT_ITEM")
                , root_1);

                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:492:20: ^( DYNAMIC_INSTANTIATION[$dynamicInstantiationTarget.start, $dynamicInstantiationTarget.text] dynamicInstantiationArgs )
                {
                Object root_2 = (Object)adaptor.nil();
                root_2 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(DYNAMIC_INSTANTIATION, (dynamicInstantiationTarget127!=null?((Token)dynamicInstantiationTarget127.start):null), (dynamicInstantiationTarget127!=null?input.toString(dynamicInstantiationTarget127.start,dynamicInstantiationTarget127.stop):null))
                , root_2);

                adaptor.addChild(root_2, stream_dynamicInstantiationArgs.nextTree());

                adaptor.addChild(root_1, root_2);
                }

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "rootDynamicInstantiation"


    public static class dynamicInstantiationTarget_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "dynamicInstantiationTarget"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:495:1: dynamicInstantiationTarget : dotIdentifierPath ;
    public final HQLParser.dynamicInstantiationTarget_return dynamicInstantiationTarget() throws RecognitionException {
        HQLParser.dynamicInstantiationTarget_return retval = new HQLParser.dynamicInstantiationTarget_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.dotIdentifierPath_return dotIdentifierPath131 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:496:2: ( dotIdentifierPath )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:496:4: dotIdentifierPath
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_dotIdentifierPath_in_dynamicInstantiationTarget1429);
            dotIdentifierPath131=dotIdentifierPath();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, dotIdentifierPath131.getTree());

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "dynamicInstantiationTarget"


    public static class dynamicInstantiationArgs_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "dynamicInstantiationArgs"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:499:1: dynamicInstantiationArgs : dynamicInstantiationArg ( COMMA ! dynamicInstantiationArg )* ;
    public final HQLParser.dynamicInstantiationArgs_return dynamicInstantiationArgs() throws RecognitionException {
        HQLParser.dynamicInstantiationArgs_return retval = new HQLParser.dynamicInstantiationArgs_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token COMMA133=null;
        HQLParser.dynamicInstantiationArg_return dynamicInstantiationArg132 =null;

        HQLParser.dynamicInstantiationArg_return dynamicInstantiationArg134 =null;


        Object COMMA133_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:500:2: ( dynamicInstantiationArg ( COMMA ! dynamicInstantiationArg )* )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:500:4: dynamicInstantiationArg ( COMMA ! dynamicInstantiationArg )*
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_dynamicInstantiationArg_in_dynamicInstantiationArgs1440);
            dynamicInstantiationArg132=dynamicInstantiationArg();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, dynamicInstantiationArg132.getTree());

            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:500:28: ( COMMA ! dynamicInstantiationArg )*
            loop41:
            do {
                int alt41=2;
                int LA41_0 = input.LA(1);

                if ( (LA41_0==COMMA) ) {
                    alt41=1;
                }


                switch (alt41) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:500:30: COMMA ! dynamicInstantiationArg
            	    {
            	    COMMA133=(Token)match(input,COMMA,FOLLOW_COMMA_in_dynamicInstantiationArgs1444); if (state.failed) return retval;

            	    pushFollow(FOLLOW_dynamicInstantiationArg_in_dynamicInstantiationArgs1447);
            	    dynamicInstantiationArg134=dynamicInstantiationArg();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) adaptor.addChild(root_0, dynamicInstantiationArg134.getTree());

            	    }
            	    break;

            	default :
            	    break loop41;
                }
            } while (true);


            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "dynamicInstantiationArgs"


    public static class dynamicInstantiationArg_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "dynamicInstantiationArg"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:503:1: dynamicInstantiationArg : ( selectExpression -> ^( DYNAMIC_INSTANTIATION_ARG selectExpression ) | rootDynamicInstantiation -> ^( DYNAMIC_INSTANTIATION_ARG rootDynamicInstantiation ) );
    public final HQLParser.dynamicInstantiationArg_return dynamicInstantiationArg() throws RecognitionException {
        HQLParser.dynamicInstantiationArg_return retval = new HQLParser.dynamicInstantiationArg_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.selectExpression_return selectExpression135 =null;

        HQLParser.rootDynamicInstantiation_return rootDynamicInstantiation136 =null;


        RewriteRuleSubtreeStream stream_rootDynamicInstantiation=new RewriteRuleSubtreeStream(adaptor,"rule rootDynamicInstantiation");
        RewriteRuleSubtreeStream stream_selectExpression=new RewriteRuleSubtreeStream(adaptor,"rule selectExpression");
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:504:2: ( selectExpression -> ^( DYNAMIC_INSTANTIATION_ARG selectExpression ) | rootDynamicInstantiation -> ^( DYNAMIC_INSTANTIATION_ARG rootDynamicInstantiation ) )
            int alt42=2;
            int LA42_0 = input.LA(1);

            if ( (LA42_0==IDENTIFIER) ) {
                int LA42_1 = input.LA(2);

                if ( (!((((validateSoftKeyword("new")))))) ) {
                    alt42=1;
                }
                else if ( (((validateSoftKeyword("new")))) ) {
                    alt42=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 42, 1, input);

                    throw nvae;

                }
            }
            else if ( (LA42_0==CHARACTER_LITERAL||LA42_0==COLON||LA42_0==DECIMAL_LITERAL||LA42_0==FALSE||LA42_0==FLOATING_POINT_LITERAL||LA42_0==HEX_LITERAL||LA42_0==INTEGER_LITERAL||LA42_0==LEFT_PAREN||LA42_0==MINUS||LA42_0==NULL||LA42_0==OCTAL_LITERAL||LA42_0==PARAM||LA42_0==PLUS||LA42_0==STRING_LITERAL||LA42_0==TRUE) ) {
                alt42=1;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 42, 0, input);

                throw nvae;

            }
            switch (alt42) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:504:4: selectExpression
                    {
                    pushFollow(FOLLOW_selectExpression_in_dynamicInstantiationArg1461);
                    selectExpression135=selectExpression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_selectExpression.add(selectExpression135.getTree());

                    // AST REWRITE
                    // elements: selectExpression
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (Object)adaptor.nil();
                    // 504:21: -> ^( DYNAMIC_INSTANTIATION_ARG selectExpression )
                    {
                        // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:504:24: ^( DYNAMIC_INSTANTIATION_ARG selectExpression )
                        {
                        Object root_1 = (Object)adaptor.nil();
                        root_1 = (Object)adaptor.becomeRoot(
                        (Object)adaptor.create(DYNAMIC_INSTANTIATION_ARG, "DYNAMIC_INSTANTIATION_ARG")
                        , root_1);

                        adaptor.addChild(root_1, stream_selectExpression.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:505:4: rootDynamicInstantiation
                    {
                    pushFollow(FOLLOW_rootDynamicInstantiation_in_dynamicInstantiationArg1474);
                    rootDynamicInstantiation136=rootDynamicInstantiation();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_rootDynamicInstantiation.add(rootDynamicInstantiation136.getTree());

                    // AST REWRITE
                    // elements: rootDynamicInstantiation
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (Object)adaptor.nil();
                    // 505:29: -> ^( DYNAMIC_INSTANTIATION_ARG rootDynamicInstantiation )
                    {
                        // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:505:32: ^( DYNAMIC_INSTANTIATION_ARG rootDynamicInstantiation )
                        {
                        Object root_1 = (Object)adaptor.nil();
                        root_1 = (Object)adaptor.becomeRoot(
                        (Object)adaptor.create(DYNAMIC_INSTANTIATION_ARG, "DYNAMIC_INSTANTIATION_ARG")
                        , root_1);

                        adaptor.addChild(root_1, stream_rootDynamicInstantiation.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "dynamicInstantiationArg"


    public static class jpaSelectObjectSyntax_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "jpaSelectObjectSyntax"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:508:1: jpaSelectObjectSyntax : object_key LEFT_PAREN aliasReference RIGHT_PAREN -> ^( SELECT_ITEM aliasReference ) ;
    public final HQLParser.jpaSelectObjectSyntax_return jpaSelectObjectSyntax() throws RecognitionException {
        HQLParser.jpaSelectObjectSyntax_return retval = new HQLParser.jpaSelectObjectSyntax_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token LEFT_PAREN138=null;
        Token RIGHT_PAREN140=null;
        HQLParser.object_key_return object_key137 =null;

        HQLParser.aliasReference_return aliasReference139 =null;


        Object LEFT_PAREN138_tree=null;
        Object RIGHT_PAREN140_tree=null;
        RewriteRuleTokenStream stream_LEFT_PAREN=new RewriteRuleTokenStream(adaptor,"token LEFT_PAREN");
        RewriteRuleTokenStream stream_RIGHT_PAREN=new RewriteRuleTokenStream(adaptor,"token RIGHT_PAREN");
        RewriteRuleSubtreeStream stream_object_key=new RewriteRuleSubtreeStream(adaptor,"rule object_key");
        RewriteRuleSubtreeStream stream_aliasReference=new RewriteRuleSubtreeStream(adaptor,"rule aliasReference");
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:509:2: ( object_key LEFT_PAREN aliasReference RIGHT_PAREN -> ^( SELECT_ITEM aliasReference ) )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:509:4: object_key LEFT_PAREN aliasReference RIGHT_PAREN
            {
            pushFollow(FOLLOW_object_key_in_jpaSelectObjectSyntax1493);
            object_key137=object_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_object_key.add(object_key137.getTree());

            LEFT_PAREN138=(Token)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_jpaSelectObjectSyntax1495); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_LEFT_PAREN.add(LEFT_PAREN138);


            pushFollow(FOLLOW_aliasReference_in_jpaSelectObjectSyntax1497);
            aliasReference139=aliasReference();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_aliasReference.add(aliasReference139.getTree());

            RIGHT_PAREN140=(Token)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_jpaSelectObjectSyntax1499); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_RIGHT_PAREN.add(RIGHT_PAREN140);


            // AST REWRITE
            // elements: aliasReference
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 510:3: -> ^( SELECT_ITEM aliasReference )
            {
                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:510:6: ^( SELECT_ITEM aliasReference )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(SELECT_ITEM, "SELECT_ITEM")
                , root_1);

                adaptor.addChild(root_1, stream_aliasReference.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "jpaSelectObjectSyntax"


    public static class orderByClause_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "orderByClause"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:513:1: orderByClause : order_by_key ^ sortSpecification ( COMMA ! sortSpecification )* ;
    public final HQLParser.orderByClause_return orderByClause() throws RecognitionException {
        HQLParser.orderByClause_return retval = new HQLParser.orderByClause_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token COMMA143=null;
        HQLParser.order_by_key_return order_by_key141 =null;

        HQLParser.sortSpecification_return sortSpecification142 =null;

        HQLParser.sortSpecification_return sortSpecification144 =null;


        Object COMMA143_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:514:2: ( order_by_key ^ sortSpecification ( COMMA ! sortSpecification )* )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:514:4: order_by_key ^ sortSpecification ( COMMA ! sortSpecification )*
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_order_by_key_in_orderByClause1520);
            order_by_key141=order_by_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(order_by_key141.getTree(), root_0);

            pushFollow(FOLLOW_sortSpecification_in_orderByClause1523);
            sortSpecification142=sortSpecification();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, sortSpecification142.getTree());

            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:514:36: ( COMMA ! sortSpecification )*
            loop43:
            do {
                int alt43=2;
                int LA43_0 = input.LA(1);

                if ( (LA43_0==COMMA) ) {
                    alt43=1;
                }


                switch (alt43) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:514:38: COMMA ! sortSpecification
            	    {
            	    COMMA143=(Token)match(input,COMMA,FOLLOW_COMMA_in_orderByClause1527); if (state.failed) return retval;

            	    pushFollow(FOLLOW_sortSpecification_in_orderByClause1530);
            	    sortSpecification144=sortSpecification();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) adaptor.addChild(root_0, sortSpecification144.getTree());

            	    }
            	    break;

            	default :
            	    break loop43;
                }
            } while (true);


            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "orderByClause"


    public static class sortSpecification_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "sortSpecification"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:517:1: sortSpecification : sortKey ( collationSpecification )? ( orderingSpecification )? -> {generateOmmitedElement}? ^( SORT_SPEC sortKey ( collationSpecification )? ORDER_SPEC[\"asc\"] ) -> ^( SORT_SPEC sortKey ( collationSpecification )? ( orderingSpecification )? ) ;
    public final HQLParser.sortSpecification_return sortSpecification() throws RecognitionException {
        HQLParser.sortSpecification_return retval = new HQLParser.sortSpecification_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.sortKey_return sortKey145 =null;

        HQLParser.collationSpecification_return collationSpecification146 =null;

        HQLParser.orderingSpecification_return orderingSpecification147 =null;


        RewriteRuleSubtreeStream stream_orderingSpecification=new RewriteRuleSubtreeStream(adaptor,"rule orderingSpecification");
        RewriteRuleSubtreeStream stream_sortKey=new RewriteRuleSubtreeStream(adaptor,"rule sortKey");
        RewriteRuleSubtreeStream stream_collationSpecification=new RewriteRuleSubtreeStream(adaptor,"rule collationSpecification");
        boolean generateOmmitedElement = true;
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:519:2: ( sortKey ( collationSpecification )? ( orderingSpecification )? -> {generateOmmitedElement}? ^( SORT_SPEC sortKey ( collationSpecification )? ORDER_SPEC[\"asc\"] ) -> ^( SORT_SPEC sortKey ( collationSpecification )? ( orderingSpecification )? ) )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:519:4: sortKey ( collationSpecification )? ( orderingSpecification )?
            {
            pushFollow(FOLLOW_sortKey_in_sortSpecification1548);
            sortKey145=sortKey();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_sortKey.add(sortKey145.getTree());

            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:519:12: ( collationSpecification )?
            int alt44=2;
            int LA44_0 = input.LA(1);

            if ( (LA44_0==IDENTIFIER) && ((((validateSoftKeyword("collate")))||((validateSoftKeyword("ascending") || validateSoftKeyword("asc")))||((validateSoftKeyword("descending") || validateSoftKeyword("desc")))))) {
                int LA44_1 = input.LA(2);

                if ( (LA44_1==IDENTIFIER) && (((validateSoftKeyword("collate"))))) {
                    alt44=1;
                }
            }
            switch (alt44) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:519:12: collationSpecification
                    {
                    pushFollow(FOLLOW_collationSpecification_in_sortSpecification1550);
                    collationSpecification146=collationSpecification();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_collationSpecification.add(collationSpecification146.getTree());

                    }
                    break;

            }


            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:519:36: ( orderingSpecification )?
            int alt45=2;
            int LA45_0 = input.LA(1);

            if ( (LA45_0==IDENTIFIER) && ((((validateSoftKeyword("ascending") || validateSoftKeyword("asc")))||((validateSoftKeyword("descending") || validateSoftKeyword("desc")))))) {
                alt45=1;
            }
            switch (alt45) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:519:37: orderingSpecification
                    {
                    pushFollow(FOLLOW_orderingSpecification_in_sortSpecification1554);
                    orderingSpecification147=orderingSpecification();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_orderingSpecification.add(orderingSpecification147.getTree());

                    if ( state.backtracking==0 ) {generateOmmitedElement = false;}

                    }
                    break;

            }


            // AST REWRITE
            // elements: collationSpecification, orderingSpecification, sortKey, collationSpecification, sortKey
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 520:3: -> {generateOmmitedElement}? ^( SORT_SPEC sortKey ( collationSpecification )? ORDER_SPEC[\"asc\"] )
            if (generateOmmitedElement) {
                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:520:32: ^( SORT_SPEC sortKey ( collationSpecification )? ORDER_SPEC[\"asc\"] )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(SORT_SPEC, "SORT_SPEC")
                , root_1);

                adaptor.addChild(root_1, stream_sortKey.nextTree());

                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:520:52: ( collationSpecification )?
                if ( stream_collationSpecification.hasNext() ) {
                    adaptor.addChild(root_1, stream_collationSpecification.nextTree());

                }
                stream_collationSpecification.reset();

                adaptor.addChild(root_1, 
                (Object)adaptor.create(ORDER_SPEC, "asc")
                );

                adaptor.addChild(root_0, root_1);
                }

            }

            else // 521:3: -> ^( SORT_SPEC sortKey ( collationSpecification )? ( orderingSpecification )? )
            {
                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:521:6: ^( SORT_SPEC sortKey ( collationSpecification )? ( orderingSpecification )? )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(SORT_SPEC, "SORT_SPEC")
                , root_1);

                adaptor.addChild(root_1, stream_sortKey.nextTree());

                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:521:26: ( collationSpecification )?
                if ( stream_collationSpecification.hasNext() ) {
                    adaptor.addChild(root_1, stream_collationSpecification.nextTree());

                }
                stream_collationSpecification.reset();

                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:521:50: ( orderingSpecification )?
                if ( stream_orderingSpecification.hasNext() ) {
                    adaptor.addChild(root_1, stream_orderingSpecification.nextTree());

                }
                stream_orderingSpecification.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "sortSpecification"


    public static class sortKey_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "sortKey"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:524:1: sortKey : concatenation ;
    public final HQLParser.sortKey_return sortKey() throws RecognitionException {
        HQLParser.sortKey_return retval = new HQLParser.sortKey_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.concatenation_return concatenation148 =null;



         if (state.backtracking == 0) enableParameterUsage.push(Boolean.FALSE); 
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:528:2: ( concatenation )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:528:4: concatenation
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_concatenation_in_sortKey1614);
            concatenation148=concatenation();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, concatenation148.getTree());

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { enableParameterUsage.pop(); }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "sortKey"


    public static class collationSpecification_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "collationSpecification"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:531:1: collationSpecification : collate_key collateName -> COLLATE[$collateName.start, $collateName.text] ;
    public final HQLParser.collationSpecification_return collationSpecification() throws RecognitionException {
        HQLParser.collationSpecification_return retval = new HQLParser.collationSpecification_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.collate_key_return collate_key149 =null;

        HQLParser.collateName_return collateName150 =null;


        RewriteRuleSubtreeStream stream_collateName=new RewriteRuleSubtreeStream(adaptor,"rule collateName");
        RewriteRuleSubtreeStream stream_collate_key=new RewriteRuleSubtreeStream(adaptor,"rule collate_key");
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:532:2: ( collate_key collateName -> COLLATE[$collateName.start, $collateName.text] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:532:4: collate_key collateName
            {
            pushFollow(FOLLOW_collate_key_in_collationSpecification1625);
            collate_key149=collate_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_collate_key.add(collate_key149.getTree());

            pushFollow(FOLLOW_collateName_in_collationSpecification1627);
            collateName150=collateName();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_collateName.add(collateName150.getTree());

            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 533:2: -> COLLATE[$collateName.start, $collateName.text]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(COLLATE, (collateName150!=null?((Token)collateName150.start):null), (collateName150!=null?input.toString(collateName150.start,collateName150.stop):null))
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "collationSpecification"


    public static class collateName_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "collateName"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:536:1: collateName : dotIdentifierPath ;
    public final HQLParser.collateName_return collateName() throws RecognitionException {
        HQLParser.collateName_return retval = new HQLParser.collateName_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.dotIdentifierPath_return dotIdentifierPath151 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:537:2: ( dotIdentifierPath )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:537:4: dotIdentifierPath
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_dotIdentifierPath_in_collateName1644);
            dotIdentifierPath151=dotIdentifierPath();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, dotIdentifierPath151.getTree());

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "collateName"


    public static class orderingSpecification_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "orderingSpecification"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:540:1: orderingSpecification : ( ascending_key -> ORDER_SPEC[$ascending_key.start, \"asc\"] | descending_key -> ORDER_SPEC[$descending_key.start, \"desc\"] );
    public final HQLParser.orderingSpecification_return orderingSpecification() throws RecognitionException {
        HQLParser.orderingSpecification_return retval = new HQLParser.orderingSpecification_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.ascending_key_return ascending_key152 =null;

        HQLParser.descending_key_return descending_key153 =null;


        RewriteRuleSubtreeStream stream_descending_key=new RewriteRuleSubtreeStream(adaptor,"rule descending_key");
        RewriteRuleSubtreeStream stream_ascending_key=new RewriteRuleSubtreeStream(adaptor,"rule ascending_key");
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:541:2: ( ascending_key -> ORDER_SPEC[$ascending_key.start, \"asc\"] | descending_key -> ORDER_SPEC[$descending_key.start, \"desc\"] )
            int alt46=2;
            int LA46_0 = input.LA(1);

            if ( (LA46_0==IDENTIFIER) && ((((validateSoftKeyword("ascending") || validateSoftKeyword("asc")))||((validateSoftKeyword("descending") || validateSoftKeyword("desc")))))) {
                int LA46_1 = input.LA(2);

                if ( (((validateSoftKeyword("ascending") || validateSoftKeyword("asc")))) ) {
                    alt46=1;
                }
                else if ( (((validateSoftKeyword("descending") || validateSoftKeyword("desc")))) ) {
                    alt46=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 46, 1, input);

                    throw nvae;

                }
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 46, 0, input);

                throw nvae;

            }
            switch (alt46) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:541:4: ascending_key
                    {
                    pushFollow(FOLLOW_ascending_key_in_orderingSpecification1655);
                    ascending_key152=ascending_key();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_ascending_key.add(ascending_key152.getTree());

                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (Object)adaptor.nil();
                    // 541:18: -> ORDER_SPEC[$ascending_key.start, \"asc\"]
                    {
                        adaptor.addChild(root_0, 
                        (Object)adaptor.create(ORDER_SPEC, (ascending_key152!=null?((Token)ascending_key152.start):null), "asc")
                        );

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:542:4: descending_key
                    {
                    pushFollow(FOLLOW_descending_key_in_orderingSpecification1665);
                    descending_key153=descending_key();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_descending_key.add(descending_key153.getTree());

                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (Object)adaptor.nil();
                    // 542:19: -> ORDER_SPEC[$descending_key.start, \"desc\"]
                    {
                        adaptor.addChild(root_0, 
                        (Object)adaptor.create(ORDER_SPEC, (descending_key153!=null?((Token)descending_key153.start):null), "desc")
                        );

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "orderingSpecification"


    public static class logicalExpression_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "logicalExpression"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:545:1: logicalExpression : expression ;
    public final HQLParser.logicalExpression_return logicalExpression() throws RecognitionException {
        HQLParser.logicalExpression_return retval = new HQLParser.logicalExpression_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.expression_return expression154 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:546:2: ( expression )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:546:4: expression
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_expression_in_logicalExpression1681);
            expression154=expression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, expression154.getTree());

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "logicalExpression"


    public static class expression_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "expression"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:549:1: expression : logicalOrExpression ;
    public final HQLParser.expression_return expression() throws RecognitionException {
        HQLParser.expression_return retval = new HQLParser.expression_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.logicalOrExpression_return logicalOrExpression155 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:550:2: ( logicalOrExpression )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:550:4: logicalOrExpression
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_logicalOrExpression_in_expression1692);
            logicalOrExpression155=logicalOrExpression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, logicalOrExpression155.getTree());

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "expression"


    public static class logicalOrExpression_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "logicalOrExpression"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:553:1: logicalOrExpression : logicalAndExpression ( or_key ^ logicalAndExpression )* ;
    public final HQLParser.logicalOrExpression_return logicalOrExpression() throws RecognitionException {
        HQLParser.logicalOrExpression_return retval = new HQLParser.logicalOrExpression_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.logicalAndExpression_return logicalAndExpression156 =null;

        HQLParser.or_key_return or_key157 =null;

        HQLParser.logicalAndExpression_return logicalAndExpression158 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:554:2: ( logicalAndExpression ( or_key ^ logicalAndExpression )* )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:554:4: logicalAndExpression ( or_key ^ logicalAndExpression )*
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_logicalAndExpression_in_logicalOrExpression1703);
            logicalAndExpression156=logicalAndExpression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, logicalAndExpression156.getTree());

            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:554:25: ( or_key ^ logicalAndExpression )*
            loop47:
            do {
                int alt47=2;
                int LA47_0 = input.LA(1);

                if ( (LA47_0==IDENTIFIER) ) {
                    int LA47_2 = input.LA(2);

                    if ( (((validateSoftKeyword("or")))) ) {
                        alt47=1;
                    }


                }


                switch (alt47) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:554:27: or_key ^ logicalAndExpression
            	    {
            	    pushFollow(FOLLOW_or_key_in_logicalOrExpression1707);
            	    or_key157=or_key();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(or_key157.getTree(), root_0);

            	    pushFollow(FOLLOW_logicalAndExpression_in_logicalOrExpression1710);
            	    logicalAndExpression158=logicalAndExpression();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) adaptor.addChild(root_0, logicalAndExpression158.getTree());

            	    }
            	    break;

            	default :
            	    break loop47;
                }
            } while (true);


            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "logicalOrExpression"


    public static class logicalAndExpression_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "logicalAndExpression"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:557:1: logicalAndExpression : negatedExpression ( and_key ^ negatedExpression )* ;
    public final HQLParser.logicalAndExpression_return logicalAndExpression() throws RecognitionException {
        HQLParser.logicalAndExpression_return retval = new HQLParser.logicalAndExpression_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.negatedExpression_return negatedExpression159 =null;

        HQLParser.and_key_return and_key160 =null;

        HQLParser.negatedExpression_return negatedExpression161 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:558:2: ( negatedExpression ( and_key ^ negatedExpression )* )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:558:4: negatedExpression ( and_key ^ negatedExpression )*
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_negatedExpression_in_logicalAndExpression1724);
            negatedExpression159=negatedExpression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, negatedExpression159.getTree());

            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:558:22: ( and_key ^ negatedExpression )*
            loop48:
            do {
                int alt48=2;
                int LA48_0 = input.LA(1);

                if ( (LA48_0==IDENTIFIER) ) {
                    int LA48_1 = input.LA(2);

                    if ( (((validateSoftKeyword("and")))) ) {
                        alt48=1;
                    }


                }


                switch (alt48) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:558:24: and_key ^ negatedExpression
            	    {
            	    pushFollow(FOLLOW_and_key_in_logicalAndExpression1728);
            	    and_key160=and_key();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(and_key160.getTree(), root_0);

            	    pushFollow(FOLLOW_negatedExpression_in_logicalAndExpression1731);
            	    negatedExpression161=negatedExpression();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) adaptor.addChild(root_0, negatedExpression161.getTree());

            	    }
            	    break;

            	default :
            	    break loop48;
                }
            } while (true);


            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "logicalAndExpression"


    public static class negatedExpression_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "negatedExpression"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:561:1: negatedExpression : ( not_key ^ negatedExpression | equalityExpression );
    public final HQLParser.negatedExpression_return negatedExpression() throws RecognitionException {
        HQLParser.negatedExpression_return retval = new HQLParser.negatedExpression_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.not_key_return not_key162 =null;

        HQLParser.negatedExpression_return negatedExpression163 =null;

        HQLParser.equalityExpression_return equalityExpression164 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:562:2: ( not_key ^ negatedExpression | equalityExpression )
            int alt49=2;
            int LA49_0 = input.LA(1);

            if ( (LA49_0==IDENTIFIER) ) {
                int LA49_1 = input.LA(2);

                if ( (((validateSoftKeyword("not")))) ) {
                    alt49=1;
                }
                else if ( (true) ) {
                    alt49=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 49, 1, input);

                    throw nvae;

                }
            }
            else if ( (LA49_0==CHARACTER_LITERAL||LA49_0==COLON||LA49_0==DECIMAL_LITERAL||LA49_0==FALSE||LA49_0==FLOATING_POINT_LITERAL||LA49_0==HEX_LITERAL||LA49_0==INTEGER_LITERAL||LA49_0==LEFT_PAREN||LA49_0==MINUS||LA49_0==NULL||LA49_0==OCTAL_LITERAL||LA49_0==PARAM||LA49_0==PLUS||LA49_0==STRING_LITERAL||LA49_0==TRUE) ) {
                alt49=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 49, 0, input);

                throw nvae;

            }
            switch (alt49) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:562:4: not_key ^ negatedExpression
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_not_key_in_negatedExpression1745);
                    not_key162=not_key();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(not_key162.getTree(), root_0);

                    pushFollow(FOLLOW_negatedExpression_in_negatedExpression1748);
                    negatedExpression163=negatedExpression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, negatedExpression163.getTree());

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:563:4: equalityExpression
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_equalityExpression_in_negatedExpression1753);
                    equalityExpression164=equalityExpression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, equalityExpression164.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "negatedExpression"


    public static class equalityExpression_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "equalityExpression"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:566:1: equalityExpression : ( relationalExpression -> relationalExpression ) ( is_key ( not_key )? ( NULL | empty_key ) -> {isNull && isNegated}? ^( IS_NOT_NULL[$not_key.start, \"is not null\"] $equalityExpression) -> {isNull && !isNegated}? ^( IS_NULL[$NULL, \"is null\"] $equalityExpression) -> {!isNull && isNegated}? ^( IS_NOT_EMPTY $equalityExpression) -> ^( IS_EMPTY $equalityExpression) | (op= EQUALS |op= NOT_EQUAL ) relationalExpression -> ^( $op $equalityExpression relationalExpression ) )* ;
    public final HQLParser.equalityExpression_return equalityExpression() throws RecognitionException {
        HQLParser.equalityExpression_return retval = new HQLParser.equalityExpression_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token op=null;
        Token NULL168=null;
        HQLParser.relationalExpression_return relationalExpression165 =null;

        HQLParser.is_key_return is_key166 =null;

        HQLParser.not_key_return not_key167 =null;

        HQLParser.empty_key_return empty_key169 =null;

        HQLParser.relationalExpression_return relationalExpression170 =null;


        Object op_tree=null;
        Object NULL168_tree=null;
        RewriteRuleTokenStream stream_EQUALS=new RewriteRuleTokenStream(adaptor,"token EQUALS");
        RewriteRuleTokenStream stream_NOT_EQUAL=new RewriteRuleTokenStream(adaptor,"token NOT_EQUAL");
        RewriteRuleTokenStream stream_NULL=new RewriteRuleTokenStream(adaptor,"token NULL");
        RewriteRuleSubtreeStream stream_is_key=new RewriteRuleSubtreeStream(adaptor,"rule is_key");
        RewriteRuleSubtreeStream stream_relationalExpression=new RewriteRuleSubtreeStream(adaptor,"rule relationalExpression");
        RewriteRuleSubtreeStream stream_empty_key=new RewriteRuleSubtreeStream(adaptor,"rule empty_key");
        RewriteRuleSubtreeStream stream_not_key=new RewriteRuleSubtreeStream(adaptor,"rule not_key");
         boolean isNull = false; boolean isNegated = false;
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:568:2: ( ( relationalExpression -> relationalExpression ) ( is_key ( not_key )? ( NULL | empty_key ) -> {isNull && isNegated}? ^( IS_NOT_NULL[$not_key.start, \"is not null\"] $equalityExpression) -> {isNull && !isNegated}? ^( IS_NULL[$NULL, \"is null\"] $equalityExpression) -> {!isNull && isNegated}? ^( IS_NOT_EMPTY $equalityExpression) -> ^( IS_EMPTY $equalityExpression) | (op= EQUALS |op= NOT_EQUAL ) relationalExpression -> ^( $op $equalityExpression relationalExpression ) )* )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:568:4: ( relationalExpression -> relationalExpression ) ( is_key ( not_key )? ( NULL | empty_key ) -> {isNull && isNegated}? ^( IS_NOT_NULL[$not_key.start, \"is not null\"] $equalityExpression) -> {isNull && !isNegated}? ^( IS_NULL[$NULL, \"is null\"] $equalityExpression) -> {!isNull && isNegated}? ^( IS_NOT_EMPTY $equalityExpression) -> ^( IS_EMPTY $equalityExpression) | (op= EQUALS |op= NOT_EQUAL ) relationalExpression -> ^( $op $equalityExpression relationalExpression ) )*
            {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:568:4: ( relationalExpression -> relationalExpression )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:568:5: relationalExpression
            {
            pushFollow(FOLLOW_relationalExpression_in_equalityExpression1769);
            relationalExpression165=relationalExpression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_relationalExpression.add(relationalExpression165.getTree());

            // AST REWRITE
            // elements: relationalExpression
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 568:26: -> relationalExpression
            {
                adaptor.addChild(root_0, stream_relationalExpression.nextTree());

            }


            retval.tree = root_0;
            }

            }


            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:569:2: ( is_key ( not_key )? ( NULL | empty_key ) -> {isNull && isNegated}? ^( IS_NOT_NULL[$not_key.start, \"is not null\"] $equalityExpression) -> {isNull && !isNegated}? ^( IS_NULL[$NULL, \"is null\"] $equalityExpression) -> {!isNull && isNegated}? ^( IS_NOT_EMPTY $equalityExpression) -> ^( IS_EMPTY $equalityExpression) | (op= EQUALS |op= NOT_EQUAL ) relationalExpression -> ^( $op $equalityExpression relationalExpression ) )*
            loop53:
            do {
                int alt53=3;
                int LA53_0 = input.LA(1);

                if ( (LA53_0==IDENTIFIER) ) {
                    int LA53_1 = input.LA(2);

                    if ( (LA53_1==IDENTIFIER) ) {
                        int LA53_4 = input.LA(3);

                        if ( (((validateSoftKeyword("is")))) ) {
                            alt53=1;
                        }


                    }
                    else if ( (LA53_1==NULL) && ((((validateSoftKeyword("or")))||((validateSoftKeyword("is")))||((validateSoftKeyword("where")))||((validateSoftKeyword("then")))||((validateSoftKeyword("and")))))) {
                        int LA53_6 = input.LA(3);

                        if ( (((validateSoftKeyword("is")))) ) {
                            alt53=1;
                        }


                    }


                }
                else if ( (LA53_0==EQUALS||LA53_0==NOT_EQUAL) ) {
                    alt53=2;
                }


                switch (alt53) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:569:4: is_key ( not_key )? ( NULL | empty_key )
            	    {
            	    pushFollow(FOLLOW_is_key_in_equalityExpression1779);
            	    is_key166=is_key();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) stream_is_key.add(is_key166.getTree());

            	    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:569:11: ( not_key )?
            	    int alt50=2;
            	    int LA50_0 = input.LA(1);

            	    if ( (LA50_0==IDENTIFIER) && ((((validateSoftKeyword("not")))||((validateSoftKeyword("empty")))))) {
            	        int LA50_1 = input.LA(2);

            	        if ( (LA50_1==NULL) && (((validateSoftKeyword("not"))))) {
            	            alt50=1;
            	        }
            	        else if ( (LA50_1==IDENTIFIER) && ((((validateSoftKeyword("not")))||((validateSoftKeyword("empty")))))) {
            	            int LA50_4 = input.LA(3);

            	            if ( (((validateSoftKeyword("not")))) ) {
            	                alt50=1;
            	            }
            	        }
            	    }
            	    switch (alt50) {
            	        case 1 :
            	            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:569:12: not_key
            	            {
            	            pushFollow(FOLLOW_not_key_in_equalityExpression1782);
            	            not_key167=not_key();

            	            state._fsp--;
            	            if (state.failed) return retval;
            	            if ( state.backtracking==0 ) stream_not_key.add(not_key167.getTree());

            	            if ( state.backtracking==0 ) {isNegated = true;}

            	            }
            	            break;

            	    }


            	    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:569:42: ( NULL | empty_key )
            	    int alt51=2;
            	    int LA51_0 = input.LA(1);

            	    if ( (LA51_0==NULL) ) {
            	        alt51=1;
            	    }
            	    else if ( (LA51_0==IDENTIFIER) && (((validateSoftKeyword("empty"))))) {
            	        alt51=2;
            	    }
            	    else {
            	        if (state.backtracking>0) {state.failed=true; return retval;}
            	        NoViableAltException nvae =
            	            new NoViableAltException("", 51, 0, input);

            	        throw nvae;

            	    }
            	    switch (alt51) {
            	        case 1 :
            	            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:569:43: NULL
            	            {
            	            NULL168=(Token)match(input,NULL,FOLLOW_NULL_in_equalityExpression1789); if (state.failed) return retval; 
            	            if ( state.backtracking==0 ) stream_NULL.add(NULL168);


            	            if ( state.backtracking==0 ) {isNull = true;}

            	            }
            	            break;
            	        case 2 :
            	            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:569:65: empty_key
            	            {
            	            pushFollow(FOLLOW_empty_key_in_equalityExpression1793);
            	            empty_key169=empty_key();

            	            state._fsp--;
            	            if (state.failed) return retval;
            	            if ( state.backtracking==0 ) stream_empty_key.add(empty_key169.getTree());

            	            }
            	            break;

            	    }


            	    // AST REWRITE
            	    // elements: equalityExpression, equalityExpression, equalityExpression, equalityExpression
            	    // token labels: 
            	    // rule labels: retval
            	    // token list labels: 
            	    // rule list labels: 
            	    // wildcard labels: 
            	    if ( state.backtracking==0 ) {

            	    retval.tree = root_0;
            	    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            	    root_0 = (Object)adaptor.nil();
            	    // 570:3: -> {isNull && isNegated}? ^( IS_NOT_NULL[$not_key.start, \"is not null\"] $equalityExpression)
            	    if (isNull && isNegated) {
            	        // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:570:29: ^( IS_NOT_NULL[$not_key.start, \"is not null\"] $equalityExpression)
            	        {
            	        Object root_1 = (Object)adaptor.nil();
            	        root_1 = (Object)adaptor.becomeRoot(
            	        (Object)adaptor.create(IS_NOT_NULL, (not_key167!=null?((Token)not_key167.start):null), "is not null")
            	        , root_1);

            	        adaptor.addChild(root_1, stream_retval.nextTree());

            	        adaptor.addChild(root_0, root_1);
            	        }

            	    }

            	    else // 571:3: -> {isNull && !isNegated}? ^( IS_NULL[$NULL, \"is null\"] $equalityExpression)
            	    if (isNull && !isNegated) {
            	        // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:571:30: ^( IS_NULL[$NULL, \"is null\"] $equalityExpression)
            	        {
            	        Object root_1 = (Object)adaptor.nil();
            	        root_1 = (Object)adaptor.becomeRoot(
            	        (Object)adaptor.create(IS_NULL, NULL168, "is null")
            	        , root_1);

            	        adaptor.addChild(root_1, stream_retval.nextTree());

            	        adaptor.addChild(root_0, root_1);
            	        }

            	    }

            	    else // 572:3: -> {!isNull && isNegated}? ^( IS_NOT_EMPTY $equalityExpression)
            	    if (!isNull && isNegated) {
            	        // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:572:30: ^( IS_NOT_EMPTY $equalityExpression)
            	        {
            	        Object root_1 = (Object)adaptor.nil();
            	        root_1 = (Object)adaptor.becomeRoot(
            	        (Object)adaptor.create(IS_NOT_EMPTY, "IS_NOT_EMPTY")
            	        , root_1);

            	        adaptor.addChild(root_1, stream_retval.nextTree());

            	        adaptor.addChild(root_0, root_1);
            	        }

            	    }

            	    else // 573:3: -> ^( IS_EMPTY $equalityExpression)
            	    {
            	        // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:573:6: ^( IS_EMPTY $equalityExpression)
            	        {
            	        Object root_1 = (Object)adaptor.nil();
            	        root_1 = (Object)adaptor.becomeRoot(
            	        (Object)adaptor.create(IS_EMPTY, "IS_EMPTY")
            	        , root_1);

            	        adaptor.addChild(root_1, stream_retval.nextTree());

            	        adaptor.addChild(root_0, root_1);
            	        }

            	    }


            	    retval.tree = root_0;
            	    }

            	    }
            	    break;
            	case 2 :
            	    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:574:4: (op= EQUALS |op= NOT_EQUAL ) relationalExpression
            	    {
            	    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:574:4: (op= EQUALS |op= NOT_EQUAL )
            	    int alt52=2;
            	    int LA52_0 = input.LA(1);

            	    if ( (LA52_0==EQUALS) ) {
            	        alt52=1;
            	    }
            	    else if ( (LA52_0==NOT_EQUAL) ) {
            	        alt52=2;
            	    }
            	    else {
            	        if (state.backtracking>0) {state.failed=true; return retval;}
            	        NoViableAltException nvae =
            	            new NoViableAltException("", 52, 0, input);

            	        throw nvae;

            	    }
            	    switch (alt52) {
            	        case 1 :
            	            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:574:6: op= EQUALS
            	            {
            	            op=(Token)match(input,EQUALS,FOLLOW_EQUALS_in_equalityExpression1855); if (state.failed) return retval; 
            	            if ( state.backtracking==0 ) stream_EQUALS.add(op);


            	            }
            	            break;
            	        case 2 :
            	            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:574:18: op= NOT_EQUAL
            	            {
            	            op=(Token)match(input,NOT_EQUAL,FOLLOW_NOT_EQUAL_in_equalityExpression1861); if (state.failed) return retval; 
            	            if ( state.backtracking==0 ) stream_NOT_EQUAL.add(op);


            	            }
            	            break;

            	    }


            	    pushFollow(FOLLOW_relationalExpression_in_equalityExpression1865);
            	    relationalExpression170=relationalExpression();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) stream_relationalExpression.add(relationalExpression170.getTree());

            	    // AST REWRITE
            	    // elements: relationalExpression, op, equalityExpression
            	    // token labels: op
            	    // rule labels: retval
            	    // token list labels: 
            	    // rule list labels: 
            	    // wildcard labels: 
            	    if ( state.backtracking==0 ) {

            	    retval.tree = root_0;
            	    RewriteRuleTokenStream stream_op=new RewriteRuleTokenStream(adaptor,"token op",op);
            	    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            	    root_0 = (Object)adaptor.nil();
            	    // 575:3: -> ^( $op $equalityExpression relationalExpression )
            	    {
            	        // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:575:6: ^( $op $equalityExpression relationalExpression )
            	        {
            	        Object root_1 = (Object)adaptor.nil();
            	        root_1 = (Object)adaptor.becomeRoot(stream_op.nextNode(), root_1);

            	        adaptor.addChild(root_1, stream_retval.nextTree());

            	        adaptor.addChild(root_1, stream_relationalExpression.nextTree());

            	        adaptor.addChild(root_0, root_1);
            	        }

            	    }


            	    retval.tree = root_0;
            	    }

            	    }
            	    break;

            	default :
            	    break loop53;
                }
            } while (true);


            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "equalityExpression"


    public static class relationalExpression_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "relationalExpression"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:579:1: relationalExpression : ( concatenation -> concatenation ) ( ( (op= LESS |op= GREATER |op= LESS_EQUAL |op= GREATER_EQUAL ) additiveExpression -> ^( $op $relationalExpression additiveExpression ) )+ | ( not_key )? ( in_key inList -> {isNegated}? ^( NOT_IN[$not_key.start, \"not in\"] $relationalExpression inList ) -> ^( in_key $relationalExpression inList ) | between_key betweenList -> {isNegated}? ^( NOT_BETWEEN[$not_key.start, \"not between\"] $relationalExpression betweenList ) -> ^( between_key $relationalExpression betweenList ) | like_key concatenation ( likeEscape )? -> {isNegated}? ^( NOT_LIKE[$not_key.start, \"not like\"] $relationalExpression concatenation ( likeEscape )? ) -> ^( like_key $relationalExpression concatenation ( likeEscape )? ) | member_of_key path -> {isNegated}? ^( NOT_MEMBER_OF[$not_key.start, \"not member of\"] $relationalExpression ^( PATH path ) ) -> ^( member_of_key $relationalExpression ^( PATH path ) ) ) )? ;
    public final HQLParser.relationalExpression_return relationalExpression() throws RecognitionException {
        HQLParser.relationalExpression_return retval = new HQLParser.relationalExpression_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token op=null;
        HQLParser.concatenation_return concatenation171 =null;

        HQLParser.additiveExpression_return additiveExpression172 =null;

        HQLParser.not_key_return not_key173 =null;

        HQLParser.in_key_return in_key174 =null;

        HQLParser.inList_return inList175 =null;

        HQLParser.between_key_return between_key176 =null;

        HQLParser.betweenList_return betweenList177 =null;

        HQLParser.like_key_return like_key178 =null;

        HQLParser.concatenation_return concatenation179 =null;

        HQLParser.likeEscape_return likeEscape180 =null;

        HQLParser.member_of_key_return member_of_key181 =null;

        HQLParser.path_return path182 =null;


        Object op_tree=null;
        RewriteRuleTokenStream stream_GREATER=new RewriteRuleTokenStream(adaptor,"token GREATER");
        RewriteRuleTokenStream stream_LESS_EQUAL=new RewriteRuleTokenStream(adaptor,"token LESS_EQUAL");
        RewriteRuleTokenStream stream_GREATER_EQUAL=new RewriteRuleTokenStream(adaptor,"token GREATER_EQUAL");
        RewriteRuleTokenStream stream_LESS=new RewriteRuleTokenStream(adaptor,"token LESS");
        RewriteRuleSubtreeStream stream_member_of_key=new RewriteRuleSubtreeStream(adaptor,"rule member_of_key");
        RewriteRuleSubtreeStream stream_inList=new RewriteRuleSubtreeStream(adaptor,"rule inList");
        RewriteRuleSubtreeStream stream_between_key=new RewriteRuleSubtreeStream(adaptor,"rule between_key");
        RewriteRuleSubtreeStream stream_like_key=new RewriteRuleSubtreeStream(adaptor,"rule like_key");
        RewriteRuleSubtreeStream stream_path=new RewriteRuleSubtreeStream(adaptor,"rule path");
        RewriteRuleSubtreeStream stream_not_key=new RewriteRuleSubtreeStream(adaptor,"rule not_key");
        RewriteRuleSubtreeStream stream_additiveExpression=new RewriteRuleSubtreeStream(adaptor,"rule additiveExpression");
        RewriteRuleSubtreeStream stream_likeEscape=new RewriteRuleSubtreeStream(adaptor,"rule likeEscape");
        RewriteRuleSubtreeStream stream_concatenation=new RewriteRuleSubtreeStream(adaptor,"rule concatenation");
        RewriteRuleSubtreeStream stream_in_key=new RewriteRuleSubtreeStream(adaptor,"rule in_key");
        RewriteRuleSubtreeStream stream_betweenList=new RewriteRuleSubtreeStream(adaptor,"rule betweenList");
        boolean isNegated = false;
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:581:2: ( ( concatenation -> concatenation ) ( ( (op= LESS |op= GREATER |op= LESS_EQUAL |op= GREATER_EQUAL ) additiveExpression -> ^( $op $relationalExpression additiveExpression ) )+ | ( not_key )? ( in_key inList -> {isNegated}? ^( NOT_IN[$not_key.start, \"not in\"] $relationalExpression inList ) -> ^( in_key $relationalExpression inList ) | between_key betweenList -> {isNegated}? ^( NOT_BETWEEN[$not_key.start, \"not between\"] $relationalExpression betweenList ) -> ^( between_key $relationalExpression betweenList ) | like_key concatenation ( likeEscape )? -> {isNegated}? ^( NOT_LIKE[$not_key.start, \"not like\"] $relationalExpression concatenation ( likeEscape )? ) -> ^( like_key $relationalExpression concatenation ( likeEscape )? ) | member_of_key path -> {isNegated}? ^( NOT_MEMBER_OF[$not_key.start, \"not member of\"] $relationalExpression ^( PATH path ) ) -> ^( member_of_key $relationalExpression ^( PATH path ) ) ) )? )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:581:4: ( concatenation -> concatenation ) ( ( (op= LESS |op= GREATER |op= LESS_EQUAL |op= GREATER_EQUAL ) additiveExpression -> ^( $op $relationalExpression additiveExpression ) )+ | ( not_key )? ( in_key inList -> {isNegated}? ^( NOT_IN[$not_key.start, \"not in\"] $relationalExpression inList ) -> ^( in_key $relationalExpression inList ) | between_key betweenList -> {isNegated}? ^( NOT_BETWEEN[$not_key.start, \"not between\"] $relationalExpression betweenList ) -> ^( between_key $relationalExpression betweenList ) | like_key concatenation ( likeEscape )? -> {isNegated}? ^( NOT_LIKE[$not_key.start, \"not like\"] $relationalExpression concatenation ( likeEscape )? ) -> ^( like_key $relationalExpression concatenation ( likeEscape )? ) | member_of_key path -> {isNegated}? ^( NOT_MEMBER_OF[$not_key.start, \"not member of\"] $relationalExpression ^( PATH path ) ) -> ^( member_of_key $relationalExpression ^( PATH path ) ) ) )?
            {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:581:4: ( concatenation -> concatenation )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:581:5: concatenation
            {
            pushFollow(FOLLOW_concatenation_in_relationalExpression1900);
            concatenation171=concatenation();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_concatenation.add(concatenation171.getTree());

            // AST REWRITE
            // elements: concatenation
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 581:19: -> concatenation
            {
                adaptor.addChild(root_0, stream_concatenation.nextTree());

            }


            retval.tree = root_0;
            }

            }


            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:582:2: ( ( (op= LESS |op= GREATER |op= LESS_EQUAL |op= GREATER_EQUAL ) additiveExpression -> ^( $op $relationalExpression additiveExpression ) )+ | ( not_key )? ( in_key inList -> {isNegated}? ^( NOT_IN[$not_key.start, \"not in\"] $relationalExpression inList ) -> ^( in_key $relationalExpression inList ) | between_key betweenList -> {isNegated}? ^( NOT_BETWEEN[$not_key.start, \"not between\"] $relationalExpression betweenList ) -> ^( between_key $relationalExpression betweenList ) | like_key concatenation ( likeEscape )? -> {isNegated}? ^( NOT_LIKE[$not_key.start, \"not like\"] $relationalExpression concatenation ( likeEscape )? ) -> ^( like_key $relationalExpression concatenation ( likeEscape )? ) | member_of_key path -> {isNegated}? ^( NOT_MEMBER_OF[$not_key.start, \"not member of\"] $relationalExpression ^( PATH path ) ) -> ^( member_of_key $relationalExpression ^( PATH path ) ) ) )?
            int alt59=3;
            int LA59_0 = input.LA(1);

            if ( ((LA59_0 >= GREATER && LA59_0 <= GREATER_EQUAL)||(LA59_0 >= LESS && LA59_0 <= LESS_EQUAL)) ) {
                alt59=1;
            }
            else if ( (LA59_0==IDENTIFIER) ) {
                int LA59_5 = input.LA(2);

                if ( ((((validateSoftKeyword("like")))||((validateSoftKeyword("between")))||((validateSoftKeyword("not")))||((validateSoftKeyword("member") && validateLT(2, "of")))||((validateSoftKeyword("in"))))) ) {
                    alt59=2;
                }
            }
            switch (alt59) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:583:2: ( (op= LESS |op= GREATER |op= LESS_EQUAL |op= GREATER_EQUAL ) additiveExpression -> ^( $op $relationalExpression additiveExpression ) )+
                    {
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:583:2: ( (op= LESS |op= GREATER |op= LESS_EQUAL |op= GREATER_EQUAL ) additiveExpression -> ^( $op $relationalExpression additiveExpression ) )+
                    int cnt55=0;
                    loop55:
                    do {
                        int alt55=2;
                        int LA55_0 = input.LA(1);

                        if ( ((LA55_0 >= GREATER && LA55_0 <= GREATER_EQUAL)||(LA55_0 >= LESS && LA55_0 <= LESS_EQUAL)) ) {
                            alt55=1;
                        }


                        switch (alt55) {
                    	case 1 :
                    	    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:583:4: (op= LESS |op= GREATER |op= LESS_EQUAL |op= GREATER_EQUAL ) additiveExpression
                    	    {
                    	    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:583:4: (op= LESS |op= GREATER |op= LESS_EQUAL |op= GREATER_EQUAL )
                    	    int alt54=4;
                    	    switch ( input.LA(1) ) {
                    	    case LESS:
                    	        {
                    	        alt54=1;
                    	        }
                    	        break;
                    	    case GREATER:
                    	        {
                    	        alt54=2;
                    	        }
                    	        break;
                    	    case LESS_EQUAL:
                    	        {
                    	        alt54=3;
                    	        }
                    	        break;
                    	    case GREATER_EQUAL:
                    	        {
                    	        alt54=4;
                    	        }
                    	        break;
                    	    default:
                    	        if (state.backtracking>0) {state.failed=true; return retval;}
                    	        NoViableAltException nvae =
                    	            new NoViableAltException("", 54, 0, input);

                    	        throw nvae;

                    	    }

                    	    switch (alt54) {
                    	        case 1 :
                    	            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:583:6: op= LESS
                    	            {
                    	            op=(Token)match(input,LESS,FOLLOW_LESS_in_relationalExpression1917); if (state.failed) return retval; 
                    	            if ( state.backtracking==0 ) stream_LESS.add(op);


                    	            }
                    	            break;
                    	        case 2 :
                    	            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:583:16: op= GREATER
                    	            {
                    	            op=(Token)match(input,GREATER,FOLLOW_GREATER_in_relationalExpression1923); if (state.failed) return retval; 
                    	            if ( state.backtracking==0 ) stream_GREATER.add(op);


                    	            }
                    	            break;
                    	        case 3 :
                    	            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:583:29: op= LESS_EQUAL
                    	            {
                    	            op=(Token)match(input,LESS_EQUAL,FOLLOW_LESS_EQUAL_in_relationalExpression1929); if (state.failed) return retval; 
                    	            if ( state.backtracking==0 ) stream_LESS_EQUAL.add(op);


                    	            }
                    	            break;
                    	        case 4 :
                    	            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:583:45: op= GREATER_EQUAL
                    	            {
                    	            op=(Token)match(input,GREATER_EQUAL,FOLLOW_GREATER_EQUAL_in_relationalExpression1935); if (state.failed) return retval; 
                    	            if ( state.backtracking==0 ) stream_GREATER_EQUAL.add(op);


                    	            }
                    	            break;

                    	    }


                    	    pushFollow(FOLLOW_additiveExpression_in_relationalExpression1939);
                    	    additiveExpression172=additiveExpression();

                    	    state._fsp--;
                    	    if (state.failed) return retval;
                    	    if ( state.backtracking==0 ) stream_additiveExpression.add(additiveExpression172.getTree());

                    	    // AST REWRITE
                    	    // elements: op, relationalExpression, additiveExpression
                    	    // token labels: op
                    	    // rule labels: retval
                    	    // token list labels: 
                    	    // rule list labels: 
                    	    // wildcard labels: 
                    	    if ( state.backtracking==0 ) {

                    	    retval.tree = root_0;
                    	    RewriteRuleTokenStream stream_op=new RewriteRuleTokenStream(adaptor,"token op",op);
                    	    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    	    root_0 = (Object)adaptor.nil();
                    	    // 584:4: -> ^( $op $relationalExpression additiveExpression )
                    	    {
                    	        // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:584:7: ^( $op $relationalExpression additiveExpression )
                    	        {
                    	        Object root_1 = (Object)adaptor.nil();
                    	        root_1 = (Object)adaptor.becomeRoot(stream_op.nextNode(), root_1);

                    	        adaptor.addChild(root_1, stream_retval.nextTree());

                    	        adaptor.addChild(root_1, stream_additiveExpression.nextTree());

                    	        adaptor.addChild(root_0, root_1);
                    	        }

                    	    }


                    	    retval.tree = root_0;
                    	    }

                    	    }
                    	    break;

                    	default :
                    	    if ( cnt55 >= 1 ) break loop55;
                    	    if (state.backtracking>0) {state.failed=true; return retval;}
                                EarlyExitException eee =
                                    new EarlyExitException(55, input);
                                throw eee;
                        }
                        cnt55++;
                    } while (true);


                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:586:5: ( not_key )? ( in_key inList -> {isNegated}? ^( NOT_IN[$not_key.start, \"not in\"] $relationalExpression inList ) -> ^( in_key $relationalExpression inList ) | between_key betweenList -> {isNegated}? ^( NOT_BETWEEN[$not_key.start, \"not between\"] $relationalExpression betweenList ) -> ^( between_key $relationalExpression betweenList ) | like_key concatenation ( likeEscape )? -> {isNegated}? ^( NOT_LIKE[$not_key.start, \"not like\"] $relationalExpression concatenation ( likeEscape )? ) -> ^( like_key $relationalExpression concatenation ( likeEscape )? ) | member_of_key path -> {isNegated}? ^( NOT_MEMBER_OF[$not_key.start, \"not member of\"] $relationalExpression ^( PATH path ) ) -> ^( member_of_key $relationalExpression ^( PATH path ) ) )
                    {
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:586:5: ( not_key )?
                    int alt56=2;
                    int LA56_0 = input.LA(1);

                    if ( (LA56_0==IDENTIFIER) && ((((validateSoftKeyword("like")))||((validateSoftKeyword("not")))||((validateSoftKeyword("between")))||((validateSoftKeyword("member") && validateLT(2, "of")))||((validateSoftKeyword("in")))))) {
                        int LA56_1 = input.LA(2);

                        if ( (((validateSoftKeyword("not")))) ) {
                            alt56=1;
                        }
                    }
                    switch (alt56) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:586:6: not_key
                            {
                            pushFollow(FOLLOW_not_key_in_relationalExpression1966);
                            not_key173=not_key();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_not_key.add(not_key173.getTree());

                            if ( state.backtracking==0 ) {isNegated = true;}

                            }
                            break;

                    }


                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:587:3: ( in_key inList -> {isNegated}? ^( NOT_IN[$not_key.start, \"not in\"] $relationalExpression inList ) -> ^( in_key $relationalExpression inList ) | between_key betweenList -> {isNegated}? ^( NOT_BETWEEN[$not_key.start, \"not between\"] $relationalExpression betweenList ) -> ^( between_key $relationalExpression betweenList ) | like_key concatenation ( likeEscape )? -> {isNegated}? ^( NOT_LIKE[$not_key.start, \"not like\"] $relationalExpression concatenation ( likeEscape )? ) -> ^( like_key $relationalExpression concatenation ( likeEscape )? ) | member_of_key path -> {isNegated}? ^( NOT_MEMBER_OF[$not_key.start, \"not member of\"] $relationalExpression ^( PATH path ) ) -> ^( member_of_key $relationalExpression ^( PATH path ) ) )
                    int alt58=4;
                    int LA58_0 = input.LA(1);

                    if ( (LA58_0==IDENTIFIER) && ((((validateSoftKeyword("like")))||((validateSoftKeyword("between")))||((validateSoftKeyword("member") && validateLT(2, "of")))||((validateSoftKeyword("in")))))) {
                        int LA58_1 = input.LA(2);

                        if ( (((validateSoftKeyword("in")))) ) {
                            alt58=1;
                        }
                        else if ( (((validateSoftKeyword("between")))) ) {
                            alt58=2;
                        }
                        else if ( (((validateSoftKeyword("like")))) ) {
                            alt58=3;
                        }
                        else if ( (((validateSoftKeyword("member") && validateLT(2, "of")))) ) {
                            alt58=4;
                        }
                        else {
                            if (state.backtracking>0) {state.failed=true; return retval;}
                            NoViableAltException nvae =
                                new NoViableAltException("", 58, 1, input);

                            throw nvae;

                        }
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 58, 0, input);

                        throw nvae;

                    }
                    switch (alt58) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:587:5: in_key inList
                            {
                            pushFollow(FOLLOW_in_key_in_relationalExpression1977);
                            in_key174=in_key();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_in_key.add(in_key174.getTree());

                            pushFollow(FOLLOW_inList_in_relationalExpression1979);
                            inList175=inList();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_inList.add(inList175.getTree());

                            // AST REWRITE
                            // elements: inList, relationalExpression, in_key, relationalExpression, inList
                            // token labels: 
                            // rule labels: retval
                            // token list labels: 
                            // rule list labels: 
                            // wildcard labels: 
                            if ( state.backtracking==0 ) {

                            retval.tree = root_0;
                            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                            root_0 = (Object)adaptor.nil();
                            // 588:4: -> {isNegated}? ^( NOT_IN[$not_key.start, \"not in\"] $relationalExpression inList )
                            if (isNegated) {
                                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:588:20: ^( NOT_IN[$not_key.start, \"not in\"] $relationalExpression inList )
                                {
                                Object root_1 = (Object)adaptor.nil();
                                root_1 = (Object)adaptor.becomeRoot(
                                (Object)adaptor.create(NOT_IN, (not_key173!=null?((Token)not_key173.start):null), "not in")
                                , root_1);

                                adaptor.addChild(root_1, stream_retval.nextTree());

                                adaptor.addChild(root_1, stream_inList.nextTree());

                                adaptor.addChild(root_0, root_1);
                                }

                            }

                            else // 589:4: -> ^( in_key $relationalExpression inList )
                            {
                                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:589:7: ^( in_key $relationalExpression inList )
                                {
                                Object root_1 = (Object)adaptor.nil();
                                root_1 = (Object)adaptor.becomeRoot(stream_in_key.nextNode(), root_1);

                                adaptor.addChild(root_1, stream_retval.nextTree());

                                adaptor.addChild(root_1, stream_inList.nextTree());

                                adaptor.addChild(root_0, root_1);
                                }

                            }


                            retval.tree = root_0;
                            }

                            }
                            break;
                        case 2 :
                            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:590:5: between_key betweenList
                            {
                            pushFollow(FOLLOW_between_key_in_relationalExpression2016);
                            between_key176=between_key();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_between_key.add(between_key176.getTree());

                            pushFollow(FOLLOW_betweenList_in_relationalExpression2018);
                            betweenList177=betweenList();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_betweenList.add(betweenList177.getTree());

                            // AST REWRITE
                            // elements: betweenList, relationalExpression, relationalExpression, between_key, betweenList
                            // token labels: 
                            // rule labels: retval
                            // token list labels: 
                            // rule list labels: 
                            // wildcard labels: 
                            if ( state.backtracking==0 ) {

                            retval.tree = root_0;
                            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                            root_0 = (Object)adaptor.nil();
                            // 591:4: -> {isNegated}? ^( NOT_BETWEEN[$not_key.start, \"not between\"] $relationalExpression betweenList )
                            if (isNegated) {
                                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:591:20: ^( NOT_BETWEEN[$not_key.start, \"not between\"] $relationalExpression betweenList )
                                {
                                Object root_1 = (Object)adaptor.nil();
                                root_1 = (Object)adaptor.becomeRoot(
                                (Object)adaptor.create(NOT_BETWEEN, (not_key173!=null?((Token)not_key173.start):null), "not between")
                                , root_1);

                                adaptor.addChild(root_1, stream_retval.nextTree());

                                adaptor.addChild(root_1, stream_betweenList.nextTree());

                                adaptor.addChild(root_0, root_1);
                                }

                            }

                            else // 592:4: -> ^( between_key $relationalExpression betweenList )
                            {
                                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:592:7: ^( between_key $relationalExpression betweenList )
                                {
                                Object root_1 = (Object)adaptor.nil();
                                root_1 = (Object)adaptor.becomeRoot(stream_between_key.nextNode(), root_1);

                                adaptor.addChild(root_1, stream_retval.nextTree());

                                adaptor.addChild(root_1, stream_betweenList.nextTree());

                                adaptor.addChild(root_0, root_1);
                                }

                            }


                            retval.tree = root_0;
                            }

                            }
                            break;
                        case 3 :
                            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:593:5: like_key concatenation ( likeEscape )?
                            {
                            pushFollow(FOLLOW_like_key_in_relationalExpression2055);
                            like_key178=like_key();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_like_key.add(like_key178.getTree());

                            pushFollow(FOLLOW_concatenation_in_relationalExpression2057);
                            concatenation179=concatenation();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_concatenation.add(concatenation179.getTree());

                            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:593:28: ( likeEscape )?
                            int alt57=2;
                            int LA57_0 = input.LA(1);

                            if ( (LA57_0==IDENTIFIER) ) {
                                int LA57_1 = input.LA(2);

                                if ( (((validateSoftKeyword("escape")))) ) {
                                    alt57=1;
                                }
                            }
                            switch (alt57) {
                                case 1 :
                                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:593:28: likeEscape
                                    {
                                    pushFollow(FOLLOW_likeEscape_in_relationalExpression2059);
                                    likeEscape180=likeEscape();

                                    state._fsp--;
                                    if (state.failed) return retval;
                                    if ( state.backtracking==0 ) stream_likeEscape.add(likeEscape180.getTree());

                                    }
                                    break;

                            }


                            // AST REWRITE
                            // elements: like_key, concatenation, likeEscape, relationalExpression, relationalExpression, concatenation, likeEscape
                            // token labels: 
                            // rule labels: retval
                            // token list labels: 
                            // rule list labels: 
                            // wildcard labels: 
                            if ( state.backtracking==0 ) {

                            retval.tree = root_0;
                            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                            root_0 = (Object)adaptor.nil();
                            // 594:4: -> {isNegated}? ^( NOT_LIKE[$not_key.start, \"not like\"] $relationalExpression concatenation ( likeEscape )? )
                            if (isNegated) {
                                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:594:20: ^( NOT_LIKE[$not_key.start, \"not like\"] $relationalExpression concatenation ( likeEscape )? )
                                {
                                Object root_1 = (Object)adaptor.nil();
                                root_1 = (Object)adaptor.becomeRoot(
                                (Object)adaptor.create(NOT_LIKE, (not_key173!=null?((Token)not_key173.start):null), "not like")
                                , root_1);

                                adaptor.addChild(root_1, stream_retval.nextTree());

                                adaptor.addChild(root_1, stream_concatenation.nextTree());

                                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:594:95: ( likeEscape )?
                                if ( stream_likeEscape.hasNext() ) {
                                    adaptor.addChild(root_1, stream_likeEscape.nextTree());

                                }
                                stream_likeEscape.reset();

                                adaptor.addChild(root_0, root_1);
                                }

                            }

                            else // 595:4: -> ^( like_key $relationalExpression concatenation ( likeEscape )? )
                            {
                                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:595:7: ^( like_key $relationalExpression concatenation ( likeEscape )? )
                                {
                                Object root_1 = (Object)adaptor.nil();
                                root_1 = (Object)adaptor.becomeRoot(stream_like_key.nextNode(), root_1);

                                adaptor.addChild(root_1, stream_retval.nextTree());

                                adaptor.addChild(root_1, stream_concatenation.nextTree());

                                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:595:54: ( likeEscape )?
                                if ( stream_likeEscape.hasNext() ) {
                                    adaptor.addChild(root_1, stream_likeEscape.nextTree());

                                }
                                stream_likeEscape.reset();

                                adaptor.addChild(root_0, root_1);
                                }

                            }


                            retval.tree = root_0;
                            }

                            }
                            break;
                        case 4 :
                            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:596:5: member_of_key path
                            {
                            pushFollow(FOLLOW_member_of_key_in_relationalExpression2103);
                            member_of_key181=member_of_key();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_member_of_key.add(member_of_key181.getTree());

                            pushFollow(FOLLOW_path_in_relationalExpression2105);
                            path182=path();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_path.add(path182.getTree());

                            // AST REWRITE
                            // elements: relationalExpression, path, path, relationalExpression, member_of_key
                            // token labels: 
                            // rule labels: retval
                            // token list labels: 
                            // rule list labels: 
                            // wildcard labels: 
                            if ( state.backtracking==0 ) {

                            retval.tree = root_0;
                            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                            root_0 = (Object)adaptor.nil();
                            // 597:4: -> {isNegated}? ^( NOT_MEMBER_OF[$not_key.start, \"not member of\"] $relationalExpression ^( PATH path ) )
                            if (isNegated) {
                                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:597:20: ^( NOT_MEMBER_OF[$not_key.start, \"not member of\"] $relationalExpression ^( PATH path ) )
                                {
                                Object root_1 = (Object)adaptor.nil();
                                root_1 = (Object)adaptor.becomeRoot(
                                (Object)adaptor.create(NOT_MEMBER_OF, (not_key173!=null?((Token)not_key173.start):null), "not member of")
                                , root_1);

                                adaptor.addChild(root_1, stream_retval.nextTree());

                                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:597:91: ^( PATH path )
                                {
                                Object root_2 = (Object)adaptor.nil();
                                root_2 = (Object)adaptor.becomeRoot(
                                (Object)adaptor.create(PATH, "PATH")
                                , root_2);

                                adaptor.addChild(root_2, stream_path.nextTree());

                                adaptor.addChild(root_1, root_2);
                                }

                                adaptor.addChild(root_0, root_1);
                                }

                            }

                            else // 598:4: -> ^( member_of_key $relationalExpression ^( PATH path ) )
                            {
                                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:598:7: ^( member_of_key $relationalExpression ^( PATH path ) )
                                {
                                Object root_1 = (Object)adaptor.nil();
                                root_1 = (Object)adaptor.becomeRoot(stream_member_of_key.nextNode(), root_1);

                                adaptor.addChild(root_1, stream_retval.nextTree());

                                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:598:45: ^( PATH path )
                                {
                                Object root_2 = (Object)adaptor.nil();
                                root_2 = (Object)adaptor.becomeRoot(
                                (Object)adaptor.create(PATH, "PATH")
                                , root_2);

                                adaptor.addChild(root_2, stream_path.nextTree());

                                adaptor.addChild(root_1, root_2);
                                }

                                adaptor.addChild(root_0, root_1);
                                }

                            }


                            retval.tree = root_0;
                            }

                            }
                            break;

                    }


                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "relationalExpression"


    public static class likeEscape_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "likeEscape"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:603:1: likeEscape : escape_key ^ concatenation ;
    public final HQLParser.likeEscape_return likeEscape() throws RecognitionException {
        HQLParser.likeEscape_return retval = new HQLParser.likeEscape_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.escape_key_return escape_key183 =null;

        HQLParser.concatenation_return concatenation184 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:604:2: ( escape_key ^ concatenation )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:604:4: escape_key ^ concatenation
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_escape_key_in_likeEscape2163);
            escape_key183=escape_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(escape_key183.getTree(), root_0);

            pushFollow(FOLLOW_concatenation_in_likeEscape2166);
            concatenation184=concatenation();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, concatenation184.getTree());

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "likeEscape"


    public static class inList_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "inList"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:607:1: inList : ( collectionExpression -> ^( IN_LIST collectionExpression ) | LEFT_PAREN ({...}? => subQuery | concatenation ( COMMA concatenation )* ) RIGHT_PAREN -> ^( IN_LIST ( concatenation )* ( subQuery )? ) );
    public final HQLParser.inList_return inList() throws RecognitionException {
        HQLParser.inList_return retval = new HQLParser.inList_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token LEFT_PAREN186=null;
        Token COMMA189=null;
        Token RIGHT_PAREN191=null;
        HQLParser.collectionExpression_return collectionExpression185 =null;

        HQLParser.subQuery_return subQuery187 =null;

        HQLParser.concatenation_return concatenation188 =null;

        HQLParser.concatenation_return concatenation190 =null;


        Object LEFT_PAREN186_tree=null;
        Object COMMA189_tree=null;
        Object RIGHT_PAREN191_tree=null;
        RewriteRuleTokenStream stream_LEFT_PAREN=new RewriteRuleTokenStream(adaptor,"token LEFT_PAREN");
        RewriteRuleTokenStream stream_RIGHT_PAREN=new RewriteRuleTokenStream(adaptor,"token RIGHT_PAREN");
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleSubtreeStream stream_collectionExpression=new RewriteRuleSubtreeStream(adaptor,"rule collectionExpression");
        RewriteRuleSubtreeStream stream_subQuery=new RewriteRuleSubtreeStream(adaptor,"rule subQuery");
        RewriteRuleSubtreeStream stream_concatenation=new RewriteRuleSubtreeStream(adaptor,"rule concatenation");
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:608:2: ( collectionExpression -> ^( IN_LIST collectionExpression ) | LEFT_PAREN ({...}? => subQuery | concatenation ( COMMA concatenation )* ) RIGHT_PAREN -> ^( IN_LIST ( concatenation )* ( subQuery )? ) )
            int alt62=2;
            int LA62_0 = input.LA(1);

            if ( (LA62_0==IDENTIFIER) && ((((validateSoftKeyword("elements")))||((validateSoftKeyword("indices")))))) {
                alt62=1;
            }
            else if ( (LA62_0==LEFT_PAREN) ) {
                alt62=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 62, 0, input);

                throw nvae;

            }
            switch (alt62) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:608:4: collectionExpression
                    {
                    pushFollow(FOLLOW_collectionExpression_in_inList2177);
                    collectionExpression185=collectionExpression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_collectionExpression.add(collectionExpression185.getTree());

                    // AST REWRITE
                    // elements: collectionExpression
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (Object)adaptor.nil();
                    // 609:3: -> ^( IN_LIST collectionExpression )
                    {
                        // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:609:6: ^( IN_LIST collectionExpression )
                        {
                        Object root_1 = (Object)adaptor.nil();
                        root_1 = (Object)adaptor.becomeRoot(
                        (Object)adaptor.create(IN_LIST, "IN_LIST")
                        , root_1);

                        adaptor.addChild(root_1, stream_collectionExpression.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:610:4: LEFT_PAREN ({...}? => subQuery | concatenation ( COMMA concatenation )* ) RIGHT_PAREN
                    {
                    LEFT_PAREN186=(Token)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_inList2192); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_LEFT_PAREN.add(LEFT_PAREN186);


                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:610:15: ({...}? => subQuery | concatenation ( COMMA concatenation )* )
                    int alt61=2;
                    int LA61_0 = input.LA(1);

                    if ( (LA61_0==IDENTIFIER) ) {
                        int LA61_1 = input.LA(2);

                        if ( ((((((validateSoftKeyword("select")|validateSoftKeyword("from"))))&&(((validateSoftKeyword("select")|validateSoftKeyword("from")))))&&(((validateSoftKeyword("select")))||((validateSoftKeyword("from")))))) ) {
                            alt61=1;
                        }
                        else if ( (true) ) {
                            alt61=2;
                        }
                        else {
                            if (state.backtracking>0) {state.failed=true; return retval;}
                            NoViableAltException nvae =
                                new NoViableAltException("", 61, 1, input);

                            throw nvae;

                        }
                    }
                    else if ( (LA61_0==CHARACTER_LITERAL||LA61_0==COLON||LA61_0==DECIMAL_LITERAL||LA61_0==FALSE||LA61_0==FLOATING_POINT_LITERAL||LA61_0==HEX_LITERAL||LA61_0==INTEGER_LITERAL||LA61_0==LEFT_PAREN||LA61_0==MINUS||LA61_0==NULL||LA61_0==OCTAL_LITERAL||LA61_0==PARAM||LA61_0==PLUS||LA61_0==STRING_LITERAL||LA61_0==TRUE) ) {
                        alt61=2;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 61, 0, input);

                        throw nvae;

                    }
                    switch (alt61) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:610:17: {...}? => subQuery
                            {
                            if ( !((((validateSoftKeyword("select")|validateSoftKeyword("from"))))) ) {
                                if (state.backtracking>0) {state.failed=true; return retval;}
                                throw new FailedPredicateException(input, "inList", "((validateSoftKeyword(\"select\")|validateSoftKeyword(\"from\")))");
                            }

                            pushFollow(FOLLOW_subQuery_in_inList2199);
                            subQuery187=subQuery();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_subQuery.add(subQuery187.getTree());

                            }
                            break;
                        case 2 :
                            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:610:95: concatenation ( COMMA concatenation )*
                            {
                            pushFollow(FOLLOW_concatenation_in_inList2203);
                            concatenation188=concatenation();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_concatenation.add(concatenation188.getTree());

                            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:610:109: ( COMMA concatenation )*
                            loop60:
                            do {
                                int alt60=2;
                                int LA60_0 = input.LA(1);

                                if ( (LA60_0==COMMA) ) {
                                    alt60=1;
                                }


                                switch (alt60) {
                            	case 1 :
                            	    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:610:110: COMMA concatenation
                            	    {
                            	    COMMA189=(Token)match(input,COMMA,FOLLOW_COMMA_in_inList2206); if (state.failed) return retval; 
                            	    if ( state.backtracking==0 ) stream_COMMA.add(COMMA189);


                            	    pushFollow(FOLLOW_concatenation_in_inList2208);
                            	    concatenation190=concatenation();

                            	    state._fsp--;
                            	    if (state.failed) return retval;
                            	    if ( state.backtracking==0 ) stream_concatenation.add(concatenation190.getTree());

                            	    }
                            	    break;

                            	default :
                            	    break loop60;
                                }
                            } while (true);


                            }
                            break;

                    }


                    RIGHT_PAREN191=(Token)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_inList2214); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_RIGHT_PAREN.add(RIGHT_PAREN191);


                    // AST REWRITE
                    // elements: concatenation, subQuery
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (Object)adaptor.nil();
                    // 611:3: -> ^( IN_LIST ( concatenation )* ( subQuery )? )
                    {
                        // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:611:6: ^( IN_LIST ( concatenation )* ( subQuery )? )
                        {
                        Object root_1 = (Object)adaptor.nil();
                        root_1 = (Object)adaptor.becomeRoot(
                        (Object)adaptor.create(IN_LIST, "IN_LIST")
                        , root_1);

                        // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:611:16: ( concatenation )*
                        while ( stream_concatenation.hasNext() ) {
                            adaptor.addChild(root_1, stream_concatenation.nextTree());

                        }
                        stream_concatenation.reset();

                        // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:611:31: ( subQuery )?
                        if ( stream_subQuery.hasNext() ) {
                            adaptor.addChild(root_1, stream_subQuery.nextTree());

                        }
                        stream_subQuery.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "inList"


    public static class betweenList_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "betweenList"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:614:1: betweenList : concatenation and_key concatenation -> ^( BETWEEN_LIST ( concatenation )+ ) ;
    public final HQLParser.betweenList_return betweenList() throws RecognitionException {
        HQLParser.betweenList_return retval = new HQLParser.betweenList_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.concatenation_return concatenation192 =null;

        HQLParser.and_key_return and_key193 =null;

        HQLParser.concatenation_return concatenation194 =null;


        RewriteRuleSubtreeStream stream_and_key=new RewriteRuleSubtreeStream(adaptor,"rule and_key");
        RewriteRuleSubtreeStream stream_concatenation=new RewriteRuleSubtreeStream(adaptor,"rule concatenation");
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:615:2: ( concatenation and_key concatenation -> ^( BETWEEN_LIST ( concatenation )+ ) )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:615:4: concatenation and_key concatenation
            {
            pushFollow(FOLLOW_concatenation_in_betweenList2239);
            concatenation192=concatenation();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_concatenation.add(concatenation192.getTree());

            pushFollow(FOLLOW_and_key_in_betweenList2241);
            and_key193=and_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_and_key.add(and_key193.getTree());

            pushFollow(FOLLOW_concatenation_in_betweenList2243);
            concatenation194=concatenation();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_concatenation.add(concatenation194.getTree());

            // AST REWRITE
            // elements: concatenation
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 616:3: -> ^( BETWEEN_LIST ( concatenation )+ )
            {
                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:616:6: ^( BETWEEN_LIST ( concatenation )+ )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(BETWEEN_LIST, "BETWEEN_LIST")
                , root_1);

                if ( !(stream_concatenation.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_concatenation.hasNext() ) {
                    adaptor.addChild(root_1, stream_concatenation.nextTree());

                }
                stream_concatenation.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "betweenList"


    public static class concatenation_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "concatenation"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:619:1: concatenation : additiveExpression ( DOUBLE_PIPE ^ additiveExpression )* ;
    public final HQLParser.concatenation_return concatenation() throws RecognitionException {
        HQLParser.concatenation_return retval = new HQLParser.concatenation_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token DOUBLE_PIPE196=null;
        HQLParser.additiveExpression_return additiveExpression195 =null;

        HQLParser.additiveExpression_return additiveExpression197 =null;


        Object DOUBLE_PIPE196_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:620:2: ( additiveExpression ( DOUBLE_PIPE ^ additiveExpression )* )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:620:4: additiveExpression ( DOUBLE_PIPE ^ additiveExpression )*
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_additiveExpression_in_concatenation2265);
            additiveExpression195=additiveExpression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, additiveExpression195.getTree());

            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:620:23: ( DOUBLE_PIPE ^ additiveExpression )*
            loop63:
            do {
                int alt63=2;
                int LA63_0 = input.LA(1);

                if ( (LA63_0==DOUBLE_PIPE) ) {
                    alt63=1;
                }


                switch (alt63) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:620:24: DOUBLE_PIPE ^ additiveExpression
            	    {
            	    DOUBLE_PIPE196=(Token)match(input,DOUBLE_PIPE,FOLLOW_DOUBLE_PIPE_in_concatenation2268); if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {
            	    DOUBLE_PIPE196_tree = 
            	    (Object)adaptor.create(DOUBLE_PIPE196)
            	    ;
            	    root_0 = (Object)adaptor.becomeRoot(DOUBLE_PIPE196_tree, root_0);
            	    }

            	    if ( state.backtracking==0 ) {enableParameterUsage.push(Boolean.TRUE);}

            	    pushFollow(FOLLOW_additiveExpression_in_concatenation2273);
            	    additiveExpression197=additiveExpression();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) adaptor.addChild(root_0, additiveExpression197.getTree());

            	    if ( state.backtracking==0 ) { enableParameterUsage.pop(); }

            	    }
            	    break;

            	default :
            	    break loop63;
                }
            } while (true);


            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "concatenation"


    public static class additiveExpression_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "additiveExpression"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:623:1: additiveExpression : multiplyExpression ( ( PLUS ^| MINUS ^) multiplyExpression )* ;
    public final HQLParser.additiveExpression_return additiveExpression() throws RecognitionException {
        HQLParser.additiveExpression_return retval = new HQLParser.additiveExpression_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token PLUS199=null;
        Token MINUS200=null;
        HQLParser.multiplyExpression_return multiplyExpression198 =null;

        HQLParser.multiplyExpression_return multiplyExpression201 =null;


        Object PLUS199_tree=null;
        Object MINUS200_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:624:2: ( multiplyExpression ( ( PLUS ^| MINUS ^) multiplyExpression )* )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:624:4: multiplyExpression ( ( PLUS ^| MINUS ^) multiplyExpression )*
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_multiplyExpression_in_additiveExpression2288);
            multiplyExpression198=multiplyExpression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, multiplyExpression198.getTree());

            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:624:23: ( ( PLUS ^| MINUS ^) multiplyExpression )*
            loop65:
            do {
                int alt65=2;
                int LA65_0 = input.LA(1);

                if ( (LA65_0==MINUS||LA65_0==PLUS) ) {
                    alt65=1;
                }


                switch (alt65) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:624:25: ( PLUS ^| MINUS ^) multiplyExpression
            	    {
            	    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:624:25: ( PLUS ^| MINUS ^)
            	    int alt64=2;
            	    int LA64_0 = input.LA(1);

            	    if ( (LA64_0==PLUS) ) {
            	        alt64=1;
            	    }
            	    else if ( (LA64_0==MINUS) ) {
            	        alt64=2;
            	    }
            	    else {
            	        if (state.backtracking>0) {state.failed=true; return retval;}
            	        NoViableAltException nvae =
            	            new NoViableAltException("", 64, 0, input);

            	        throw nvae;

            	    }
            	    switch (alt64) {
            	        case 1 :
            	            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:624:27: PLUS ^
            	            {
            	            PLUS199=(Token)match(input,PLUS,FOLLOW_PLUS_in_additiveExpression2294); if (state.failed) return retval;
            	            if ( state.backtracking==0 ) {
            	            PLUS199_tree = 
            	            (Object)adaptor.create(PLUS199)
            	            ;
            	            root_0 = (Object)adaptor.becomeRoot(PLUS199_tree, root_0);
            	            }

            	            }
            	            break;
            	        case 2 :
            	            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:624:35: MINUS ^
            	            {
            	            MINUS200=(Token)match(input,MINUS,FOLLOW_MINUS_in_additiveExpression2299); if (state.failed) return retval;
            	            if ( state.backtracking==0 ) {
            	            MINUS200_tree = 
            	            (Object)adaptor.create(MINUS200)
            	            ;
            	            root_0 = (Object)adaptor.becomeRoot(MINUS200_tree, root_0);
            	            }

            	            }
            	            break;

            	    }


            	    if ( state.backtracking==0 ) {enableParameterUsage.push(Boolean.TRUE);}

            	    pushFollow(FOLLOW_multiplyExpression_in_additiveExpression2306);
            	    multiplyExpression201=multiplyExpression();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) adaptor.addChild(root_0, multiplyExpression201.getTree());

            	    if ( state.backtracking==0 ) { enableParameterUsage.pop(); }

            	    }
            	    break;

            	default :
            	    break loop65;
                }
            } while (true);


            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "additiveExpression"


    public static class multiplyExpression_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "multiplyExpression"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:627:1: multiplyExpression : unaryExpression ( ( ASTERISK ^| SOLIDUS ^) unaryExpression )* ;
    public final HQLParser.multiplyExpression_return multiplyExpression() throws RecognitionException {
        HQLParser.multiplyExpression_return retval = new HQLParser.multiplyExpression_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token ASTERISK203=null;
        Token SOLIDUS204=null;
        HQLParser.unaryExpression_return unaryExpression202 =null;

        HQLParser.unaryExpression_return unaryExpression205 =null;


        Object ASTERISK203_tree=null;
        Object SOLIDUS204_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:628:2: ( unaryExpression ( ( ASTERISK ^| SOLIDUS ^) unaryExpression )* )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:628:4: unaryExpression ( ( ASTERISK ^| SOLIDUS ^) unaryExpression )*
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_unaryExpression_in_multiplyExpression2321);
            unaryExpression202=unaryExpression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, unaryExpression202.getTree());

            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:628:20: ( ( ASTERISK ^| SOLIDUS ^) unaryExpression )*
            loop67:
            do {
                int alt67=2;
                int LA67_0 = input.LA(1);

                if ( (LA67_0==ASTERISK||LA67_0==SOLIDUS) ) {
                    alt67=1;
                }


                switch (alt67) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:628:22: ( ASTERISK ^| SOLIDUS ^) unaryExpression
            	    {
            	    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:628:22: ( ASTERISK ^| SOLIDUS ^)
            	    int alt66=2;
            	    int LA66_0 = input.LA(1);

            	    if ( (LA66_0==ASTERISK) ) {
            	        alt66=1;
            	    }
            	    else if ( (LA66_0==SOLIDUS) ) {
            	        alt66=2;
            	    }
            	    else {
            	        if (state.backtracking>0) {state.failed=true; return retval;}
            	        NoViableAltException nvae =
            	            new NoViableAltException("", 66, 0, input);

            	        throw nvae;

            	    }
            	    switch (alt66) {
            	        case 1 :
            	            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:628:24: ASTERISK ^
            	            {
            	            ASTERISK203=(Token)match(input,ASTERISK,FOLLOW_ASTERISK_in_multiplyExpression2327); if (state.failed) return retval;
            	            if ( state.backtracking==0 ) {
            	            ASTERISK203_tree = 
            	            (Object)adaptor.create(ASTERISK203)
            	            ;
            	            root_0 = (Object)adaptor.becomeRoot(ASTERISK203_tree, root_0);
            	            }

            	            }
            	            break;
            	        case 2 :
            	            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:628:36: SOLIDUS ^
            	            {
            	            SOLIDUS204=(Token)match(input,SOLIDUS,FOLLOW_SOLIDUS_in_multiplyExpression2332); if (state.failed) return retval;
            	            if ( state.backtracking==0 ) {
            	            SOLIDUS204_tree = 
            	            (Object)adaptor.create(SOLIDUS204)
            	            ;
            	            root_0 = (Object)adaptor.becomeRoot(SOLIDUS204_tree, root_0);
            	            }

            	            }
            	            break;

            	    }


            	    if ( state.backtracking==0 ) {enableParameterUsage.push(Boolean.TRUE);}

            	    pushFollow(FOLLOW_unaryExpression_in_multiplyExpression2339);
            	    unaryExpression205=unaryExpression();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) adaptor.addChild(root_0, unaryExpression205.getTree());

            	    if ( state.backtracking==0 ) { enableParameterUsage.pop(); }

            	    }
            	    break;

            	default :
            	    break loop67;
                }
            } while (true);


            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "multiplyExpression"


    public static class unaryExpression_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "unaryExpression"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:631:1: unaryExpression : ( MINUS unaryExpression -> ^( UNARY_MINUS[$MINUS] unaryExpression ) | PLUS unaryExpression -> ^( UNARY_PLUS[$PLUS] unaryExpression ) | caseExpression | quantifiedExpression | standardFunction | setFunction | collectionFunction | collectionExpression | atom );
    public final HQLParser.unaryExpression_return unaryExpression() throws RecognitionException {
        HQLParser.unaryExpression_return retval = new HQLParser.unaryExpression_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token MINUS206=null;
        Token PLUS208=null;
        HQLParser.unaryExpression_return unaryExpression207 =null;

        HQLParser.unaryExpression_return unaryExpression209 =null;

        HQLParser.caseExpression_return caseExpression210 =null;

        HQLParser.quantifiedExpression_return quantifiedExpression211 =null;

        HQLParser.standardFunction_return standardFunction212 =null;

        HQLParser.setFunction_return setFunction213 =null;

        HQLParser.collectionFunction_return collectionFunction214 =null;

        HQLParser.collectionExpression_return collectionExpression215 =null;

        HQLParser.atom_return atom216 =null;


        Object MINUS206_tree=null;
        Object PLUS208_tree=null;
        RewriteRuleTokenStream stream_PLUS=new RewriteRuleTokenStream(adaptor,"token PLUS");
        RewriteRuleTokenStream stream_MINUS=new RewriteRuleTokenStream(adaptor,"token MINUS");
        RewriteRuleSubtreeStream stream_unaryExpression=new RewriteRuleSubtreeStream(adaptor,"rule unaryExpression");
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:632:2: ( MINUS unaryExpression -> ^( UNARY_MINUS[$MINUS] unaryExpression ) | PLUS unaryExpression -> ^( UNARY_PLUS[$PLUS] unaryExpression ) | caseExpression | quantifiedExpression | standardFunction | setFunction | collectionFunction | collectionExpression | atom )
            int alt68=9;
            switch ( input.LA(1) ) {
            case MINUS:
                {
                alt68=1;
                }
                break;
            case PLUS:
                {
                alt68=2;
                }
                break;
            case IDENTIFIER:
                {
                int LA68_3 = input.LA(2);

                if ( ((((validateSoftKeyword("case")))||((validateSoftKeyword("coalesce")))||((validateSoftKeyword("nullif"))))) ) {
                    alt68=3;
                }
                else if ( ((((validateSoftKeyword("exists")))||((validateSoftKeyword("some")))||((validateSoftKeyword("all")))||((validateSoftKeyword("any"))))) ) {
                    alt68=4;
                }
                else if ( ((((validateSoftKeyword("substring")))||((validateSoftKeyword("current_time")))||((validateSoftKeyword("concat")))||((validateSoftKeyword("octet_length")))||((validateSoftKeyword("character_length") || validateSoftKeyword("char_length")))||((validateSoftKeyword("upper")))||((validateSoftKeyword("mod")))||((validateSoftKeyword("abs")))||((validateSoftKeyword("extract")))||((validateSoftKeyword("locate")))||((validateSoftKeyword("trim")))||((validateSoftKeyword("index")))||((validateSoftKeyword("size")))||((validateSoftKeyword("length")))||((validateSoftKeyword("cast")))||((validateSoftKeyword("position")))||((validateSoftKeyword("lower")))||((validateSoftKeyword("bit_length")))||((validateSoftKeyword("current_timestamp")))||((validateSoftKeyword("current_date")))||((validateSoftKeyword("sqrt"))))) ) {
                    alt68=5;
                }
                else if ( ((((validateSoftKeyword("min")))||((validateSoftKeyword("max")))||((validateSoftKeyword("sum")))||((validateSoftKeyword("count")))||((validateSoftKeyword("avg"))))) ) {
                    alt68=6;
                }
                else if ( ((((validateSoftKeyword("maxelement")))||((validateSoftKeyword("minelement")))||((validateSoftKeyword("maxindex")))||((validateSoftKeyword("minindex"))))) ) {
                    alt68=7;
                }
                else if ( ((((validateSoftKeyword("elements")))||((validateSoftKeyword("indices"))))) ) {
                    alt68=8;
                }
                else if ( (true) ) {
                    alt68=9;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 68, 3, input);

                    throw nvae;

                }
                }
                break;
            case CHARACTER_LITERAL:
            case COLON:
            case DECIMAL_LITERAL:
            case FALSE:
            case FLOATING_POINT_LITERAL:
            case HEX_LITERAL:
            case INTEGER_LITERAL:
            case LEFT_PAREN:
            case NULL:
            case OCTAL_LITERAL:
            case PARAM:
            case STRING_LITERAL:
            case TRUE:
                {
                alt68=9;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 68, 0, input);

                throw nvae;

            }

            switch (alt68) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:632:4: MINUS unaryExpression
                    {
                    MINUS206=(Token)match(input,MINUS,FOLLOW_MINUS_in_unaryExpression2354); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_MINUS.add(MINUS206);


                    pushFollow(FOLLOW_unaryExpression_in_unaryExpression2356);
                    unaryExpression207=unaryExpression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_unaryExpression.add(unaryExpression207.getTree());

                    // AST REWRITE
                    // elements: unaryExpression
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (Object)adaptor.nil();
                    // 632:26: -> ^( UNARY_MINUS[$MINUS] unaryExpression )
                    {
                        // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:632:29: ^( UNARY_MINUS[$MINUS] unaryExpression )
                        {
                        Object root_1 = (Object)adaptor.nil();
                        root_1 = (Object)adaptor.becomeRoot(
                        (Object)adaptor.create(UNARY_MINUS, MINUS206)
                        , root_1);

                        adaptor.addChild(root_1, stream_unaryExpression.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:633:4: PLUS unaryExpression
                    {
                    PLUS208=(Token)match(input,PLUS,FOLLOW_PLUS_in_unaryExpression2370); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_PLUS.add(PLUS208);


                    pushFollow(FOLLOW_unaryExpression_in_unaryExpression2372);
                    unaryExpression209=unaryExpression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_unaryExpression.add(unaryExpression209.getTree());

                    // AST REWRITE
                    // elements: unaryExpression
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (Object)adaptor.nil();
                    // 633:25: -> ^( UNARY_PLUS[$PLUS] unaryExpression )
                    {
                        // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:633:28: ^( UNARY_PLUS[$PLUS] unaryExpression )
                        {
                        Object root_1 = (Object)adaptor.nil();
                        root_1 = (Object)adaptor.becomeRoot(
                        (Object)adaptor.create(UNARY_PLUS, PLUS208)
                        , root_1);

                        adaptor.addChild(root_1, stream_unaryExpression.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:634:4: caseExpression
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_caseExpression_in_unaryExpression2386);
                    caseExpression210=caseExpression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, caseExpression210.getTree());

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:635:4: quantifiedExpression
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_quantifiedExpression_in_unaryExpression2391);
                    quantifiedExpression211=quantifiedExpression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, quantifiedExpression211.getTree());

                    }
                    break;
                case 5 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:636:4: standardFunction
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_standardFunction_in_unaryExpression2396);
                    standardFunction212=standardFunction();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, standardFunction212.getTree());

                    }
                    break;
                case 6 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:637:4: setFunction
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_setFunction_in_unaryExpression2401);
                    setFunction213=setFunction();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, setFunction213.getTree());

                    }
                    break;
                case 7 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:638:4: collectionFunction
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_collectionFunction_in_unaryExpression2406);
                    collectionFunction214=collectionFunction();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, collectionFunction214.getTree());

                    }
                    break;
                case 8 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:639:4: collectionExpression
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_collectionExpression_in_unaryExpression2411);
                    collectionExpression215=collectionExpression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, collectionExpression215.getTree());

                    }
                    break;
                case 9 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:640:4: atom
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_atom_in_unaryExpression2416);
                    atom216=atom();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, atom216.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "unaryExpression"


    public static class caseExpression_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "caseExpression"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:643:1: caseExpression : ( caseAbbreviation | caseSpecification );
    public final HQLParser.caseExpression_return caseExpression() throws RecognitionException {
        HQLParser.caseExpression_return retval = new HQLParser.caseExpression_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.caseAbbreviation_return caseAbbreviation217 =null;

        HQLParser.caseSpecification_return caseSpecification218 =null;



         if (state.backtracking == 0) enableParameterUsage.push(Boolean.TRUE); 
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:646:2: ( caseAbbreviation | caseSpecification )
            int alt69=2;
            int LA69_0 = input.LA(1);

            if ( (LA69_0==IDENTIFIER) && ((((validateSoftKeyword("case")))||((validateSoftKeyword("coalesce")))||((validateSoftKeyword("nullif")))))) {
                int LA69_1 = input.LA(2);

                if ( ((((validateSoftKeyword("coalesce")))||((validateSoftKeyword("nullif"))))) ) {
                    alt69=1;
                }
                else if ( (((validateSoftKeyword("case")))) ) {
                    alt69=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 69, 1, input);

                    throw nvae;

                }
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 69, 0, input);

                throw nvae;

            }
            switch (alt69) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:646:4: caseAbbreviation
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_caseAbbreviation_in_caseExpression2437);
                    caseAbbreviation217=caseAbbreviation();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, caseAbbreviation217.getTree());

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:647:4: caseSpecification
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_caseSpecification_in_caseExpression2442);
                    caseSpecification218=caseSpecification();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, caseSpecification218.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { enableParameterUsage.pop(); }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "caseExpression"


    public static class caseAbbreviation_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "caseAbbreviation"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:650:1: caseAbbreviation : ( nullif_key ^ LEFT_PAREN ! concatenation COMMA ! concatenation RIGHT_PAREN !| coalesce_key ^ LEFT_PAREN ! concatenation ( COMMA ! concatenation )* RIGHT_PAREN !);
    public final HQLParser.caseAbbreviation_return caseAbbreviation() throws RecognitionException {
        HQLParser.caseAbbreviation_return retval = new HQLParser.caseAbbreviation_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token LEFT_PAREN220=null;
        Token COMMA222=null;
        Token RIGHT_PAREN224=null;
        Token LEFT_PAREN226=null;
        Token COMMA228=null;
        Token RIGHT_PAREN230=null;
        HQLParser.nullif_key_return nullif_key219 =null;

        HQLParser.concatenation_return concatenation221 =null;

        HQLParser.concatenation_return concatenation223 =null;

        HQLParser.coalesce_key_return coalesce_key225 =null;

        HQLParser.concatenation_return concatenation227 =null;

        HQLParser.concatenation_return concatenation229 =null;


        Object LEFT_PAREN220_tree=null;
        Object COMMA222_tree=null;
        Object RIGHT_PAREN224_tree=null;
        Object LEFT_PAREN226_tree=null;
        Object COMMA228_tree=null;
        Object RIGHT_PAREN230_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:651:2: ( nullif_key ^ LEFT_PAREN ! concatenation COMMA ! concatenation RIGHT_PAREN !| coalesce_key ^ LEFT_PAREN ! concatenation ( COMMA ! concatenation )* RIGHT_PAREN !)
            int alt71=2;
            int LA71_0 = input.LA(1);

            if ( (LA71_0==IDENTIFIER) && ((((validateSoftKeyword("coalesce")))||((validateSoftKeyword("nullif")))))) {
                int LA71_1 = input.LA(2);

                if ( (((validateSoftKeyword("nullif")))) ) {
                    alt71=1;
                }
                else if ( (((validateSoftKeyword("coalesce")))) ) {
                    alt71=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 71, 1, input);

                    throw nvae;

                }
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 71, 0, input);

                throw nvae;

            }
            switch (alt71) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:651:4: nullif_key ^ LEFT_PAREN ! concatenation COMMA ! concatenation RIGHT_PAREN !
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_nullif_key_in_caseAbbreviation2453);
                    nullif_key219=nullif_key();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(nullif_key219.getTree(), root_0);

                    LEFT_PAREN220=(Token)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_caseAbbreviation2456); if (state.failed) return retval;

                    pushFollow(FOLLOW_concatenation_in_caseAbbreviation2459);
                    concatenation221=concatenation();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, concatenation221.getTree());

                    COMMA222=(Token)match(input,COMMA,FOLLOW_COMMA_in_caseAbbreviation2461); if (state.failed) return retval;

                    pushFollow(FOLLOW_concatenation_in_caseAbbreviation2464);
                    concatenation223=concatenation();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, concatenation223.getTree());

                    RIGHT_PAREN224=(Token)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_caseAbbreviation2466); if (state.failed) return retval;

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:652:4: coalesce_key ^ LEFT_PAREN ! concatenation ( COMMA ! concatenation )* RIGHT_PAREN !
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_coalesce_key_in_caseAbbreviation2472);
                    coalesce_key225=coalesce_key();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(coalesce_key225.getTree(), root_0);

                    LEFT_PAREN226=(Token)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_caseAbbreviation2475); if (state.failed) return retval;

                    pushFollow(FOLLOW_concatenation_in_caseAbbreviation2478);
                    concatenation227=concatenation();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, concatenation227.getTree());

                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:652:44: ( COMMA ! concatenation )*
                    loop70:
                    do {
                        int alt70=2;
                        int LA70_0 = input.LA(1);

                        if ( (LA70_0==COMMA) ) {
                            alt70=1;
                        }


                        switch (alt70) {
                    	case 1 :
                    	    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:652:45: COMMA ! concatenation
                    	    {
                    	    COMMA228=(Token)match(input,COMMA,FOLLOW_COMMA_in_caseAbbreviation2481); if (state.failed) return retval;

                    	    pushFollow(FOLLOW_concatenation_in_caseAbbreviation2484);
                    	    concatenation229=concatenation();

                    	    state._fsp--;
                    	    if (state.failed) return retval;
                    	    if ( state.backtracking==0 ) adaptor.addChild(root_0, concatenation229.getTree());

                    	    }
                    	    break;

                    	default :
                    	    break loop70;
                        }
                    } while (true);


                    RIGHT_PAREN230=(Token)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_caseAbbreviation2488); if (state.failed) return retval;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "caseAbbreviation"


    public static class caseSpecification_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "caseSpecification"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:655:1: caseSpecification options {backtrack=true; } : ( simpleCase | searchedCase );
    public final HQLParser.caseSpecification_return caseSpecification() throws RecognitionException {
        HQLParser.caseSpecification_return retval = new HQLParser.caseSpecification_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.simpleCase_return simpleCase231 =null;

        HQLParser.searchedCase_return searchedCase232 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:658:3: ( simpleCase | searchedCase )
            int alt72=2;
            int LA72_0 = input.LA(1);

            if ( (LA72_0==IDENTIFIER) && (((validateSoftKeyword("case"))))) {
                int LA72_1 = input.LA(2);

                if ( (((synpred3_HQLParser()&&synpred3_HQLParser())&&((validateSoftKeyword("case"))))) ) {
                    alt72=1;
                }
                else if ( (((validateSoftKeyword("case")))) ) {
                    alt72=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 72, 1, input);

                    throw nvae;

                }
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 72, 0, input);

                throw nvae;

            }
            switch (alt72) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:658:5: simpleCase
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_simpleCase_in_caseSpecification2508);
                    simpleCase231=simpleCase();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, simpleCase231.getTree());

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:659:4: searchedCase
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_searchedCase_in_caseSpecification2513);
                    searchedCase232=searchedCase();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, searchedCase232.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "caseSpecification"


    public static class simpleCase_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "simpleCase"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:662:1: simpleCase : case_key concatenation ( simpleCaseWhenClause )+ ( elseClause )? end_key -> ^( SIMPLE_CASE[$case_key.start, $case_key.text] concatenation ( simpleCaseWhenClause )+ ( elseClause )? ) ;
    public final HQLParser.simpleCase_return simpleCase() throws RecognitionException {
        HQLParser.simpleCase_return retval = new HQLParser.simpleCase_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.case_key_return case_key233 =null;

        HQLParser.concatenation_return concatenation234 =null;

        HQLParser.simpleCaseWhenClause_return simpleCaseWhenClause235 =null;

        HQLParser.elseClause_return elseClause236 =null;

        HQLParser.end_key_return end_key237 =null;


        RewriteRuleSubtreeStream stream_simpleCaseWhenClause=new RewriteRuleSubtreeStream(adaptor,"rule simpleCaseWhenClause");
        RewriteRuleSubtreeStream stream_case_key=new RewriteRuleSubtreeStream(adaptor,"rule case_key");
        RewriteRuleSubtreeStream stream_elseClause=new RewriteRuleSubtreeStream(adaptor,"rule elseClause");
        RewriteRuleSubtreeStream stream_end_key=new RewriteRuleSubtreeStream(adaptor,"rule end_key");
        RewriteRuleSubtreeStream stream_concatenation=new RewriteRuleSubtreeStream(adaptor,"rule concatenation");
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:663:2: ( case_key concatenation ( simpleCaseWhenClause )+ ( elseClause )? end_key -> ^( SIMPLE_CASE[$case_key.start, $case_key.text] concatenation ( simpleCaseWhenClause )+ ( elseClause )? ) )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:663:4: case_key concatenation ( simpleCaseWhenClause )+ ( elseClause )? end_key
            {
            pushFollow(FOLLOW_case_key_in_simpleCase2524);
            case_key233=case_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_case_key.add(case_key233.getTree());

            pushFollow(FOLLOW_concatenation_in_simpleCase2526);
            concatenation234=concatenation();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_concatenation.add(concatenation234.getTree());

            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:663:27: ( simpleCaseWhenClause )+
            int cnt73=0;
            loop73:
            do {
                int alt73=2;
                int LA73_0 = input.LA(1);

                if ( (LA73_0==IDENTIFIER) && ((((validateSoftKeyword("end")))||((validateSoftKeyword("when")))||((validateSoftKeyword("else")))))) {
                    int LA73_1 = input.LA(2);

                    if ( (((validateSoftKeyword("when")))) ) {
                        alt73=1;
                    }


                }


                switch (alt73) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:663:27: simpleCaseWhenClause
            	    {
            	    pushFollow(FOLLOW_simpleCaseWhenClause_in_simpleCase2528);
            	    simpleCaseWhenClause235=simpleCaseWhenClause();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) stream_simpleCaseWhenClause.add(simpleCaseWhenClause235.getTree());

            	    }
            	    break;

            	default :
            	    if ( cnt73 >= 1 ) break loop73;
            	    if (state.backtracking>0) {state.failed=true; return retval;}
                        EarlyExitException eee =
                            new EarlyExitException(73, input);
                        throw eee;
                }
                cnt73++;
            } while (true);


            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:663:49: ( elseClause )?
            int alt74=2;
            int LA74_0 = input.LA(1);

            if ( (LA74_0==IDENTIFIER) && ((((validateSoftKeyword("end")))||((validateSoftKeyword("else")))))) {
                int LA74_1 = input.LA(2);

                if ( (((validateSoftKeyword("else")))) ) {
                    alt74=1;
                }
            }
            switch (alt74) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:663:49: elseClause
                    {
                    pushFollow(FOLLOW_elseClause_in_simpleCase2531);
                    elseClause236=elseClause();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_elseClause.add(elseClause236.getTree());

                    }
                    break;

            }


            pushFollow(FOLLOW_end_key_in_simpleCase2534);
            end_key237=end_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_end_key.add(end_key237.getTree());

            // AST REWRITE
            // elements: elseClause, simpleCaseWhenClause, concatenation
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 664:2: -> ^( SIMPLE_CASE[$case_key.start, $case_key.text] concatenation ( simpleCaseWhenClause )+ ( elseClause )? )
            {
                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:664:5: ^( SIMPLE_CASE[$case_key.start, $case_key.text] concatenation ( simpleCaseWhenClause )+ ( elseClause )? )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(SIMPLE_CASE, (case_key233!=null?((Token)case_key233.start):null), (case_key233!=null?input.toString(case_key233.start,case_key233.stop):null))
                , root_1);

                adaptor.addChild(root_1, stream_concatenation.nextTree());

                if ( !(stream_simpleCaseWhenClause.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_simpleCaseWhenClause.hasNext() ) {
                    adaptor.addChild(root_1, stream_simpleCaseWhenClause.nextTree());

                }
                stream_simpleCaseWhenClause.reset();

                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:664:88: ( elseClause )?
                if ( stream_elseClause.hasNext() ) {
                    adaptor.addChild(root_1, stream_elseClause.nextTree());

                }
                stream_elseClause.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "simpleCase"


    public static class simpleCaseWhenClause_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "simpleCaseWhenClause"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:667:1: simpleCaseWhenClause : when_key ^ concatenation then_key ! concatenation ;
    public final HQLParser.simpleCaseWhenClause_return simpleCaseWhenClause() throws RecognitionException {
        HQLParser.simpleCaseWhenClause_return retval = new HQLParser.simpleCaseWhenClause_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.when_key_return when_key238 =null;

        HQLParser.concatenation_return concatenation239 =null;

        HQLParser.then_key_return then_key240 =null;

        HQLParser.concatenation_return concatenation241 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:668:2: ( when_key ^ concatenation then_key ! concatenation )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:668:4: when_key ^ concatenation then_key ! concatenation
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_when_key_in_simpleCaseWhenClause2561);
            when_key238=when_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(when_key238.getTree(), root_0);

            pushFollow(FOLLOW_concatenation_in_simpleCaseWhenClause2564);
            concatenation239=concatenation();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, concatenation239.getTree());

            pushFollow(FOLLOW_then_key_in_simpleCaseWhenClause2566);
            then_key240=then_key();

            state._fsp--;
            if (state.failed) return retval;

            pushFollow(FOLLOW_concatenation_in_simpleCaseWhenClause2569);
            concatenation241=concatenation();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, concatenation241.getTree());

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "simpleCaseWhenClause"


    public static class elseClause_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "elseClause"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:671:1: elseClause : else_key ^ concatenation ;
    public final HQLParser.elseClause_return elseClause() throws RecognitionException {
        HQLParser.elseClause_return retval = new HQLParser.elseClause_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.else_key_return else_key242 =null;

        HQLParser.concatenation_return concatenation243 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:672:2: ( else_key ^ concatenation )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:672:4: else_key ^ concatenation
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_else_key_in_elseClause2580);
            else_key242=else_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(else_key242.getTree(), root_0);

            pushFollow(FOLLOW_concatenation_in_elseClause2583);
            concatenation243=concatenation();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, concatenation243.getTree());

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "elseClause"


    public static class searchedCase_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "searchedCase"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:675:1: searchedCase : case_key ( searchedWhenClause )+ ( elseClause )? end_key -> ^( SEARCHED_CASE[$case_key.start, $case_key.text] ( searchedWhenClause )+ ( elseClause )? ) ;
    public final HQLParser.searchedCase_return searchedCase() throws RecognitionException {
        HQLParser.searchedCase_return retval = new HQLParser.searchedCase_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.case_key_return case_key244 =null;

        HQLParser.searchedWhenClause_return searchedWhenClause245 =null;

        HQLParser.elseClause_return elseClause246 =null;

        HQLParser.end_key_return end_key247 =null;


        RewriteRuleSubtreeStream stream_searchedWhenClause=new RewriteRuleSubtreeStream(adaptor,"rule searchedWhenClause");
        RewriteRuleSubtreeStream stream_case_key=new RewriteRuleSubtreeStream(adaptor,"rule case_key");
        RewriteRuleSubtreeStream stream_elseClause=new RewriteRuleSubtreeStream(adaptor,"rule elseClause");
        RewriteRuleSubtreeStream stream_end_key=new RewriteRuleSubtreeStream(adaptor,"rule end_key");
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:676:2: ( case_key ( searchedWhenClause )+ ( elseClause )? end_key -> ^( SEARCHED_CASE[$case_key.start, $case_key.text] ( searchedWhenClause )+ ( elseClause )? ) )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:676:4: case_key ( searchedWhenClause )+ ( elseClause )? end_key
            {
            pushFollow(FOLLOW_case_key_in_searchedCase2594);
            case_key244=case_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_case_key.add(case_key244.getTree());

            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:676:13: ( searchedWhenClause )+
            int cnt75=0;
            loop75:
            do {
                int alt75=2;
                int LA75_0 = input.LA(1);

                if ( (LA75_0==IDENTIFIER) && ((((validateSoftKeyword("end")))||((validateSoftKeyword("when")))||((validateSoftKeyword("else")))))) {
                    int LA75_1 = input.LA(2);

                    if ( (((validateSoftKeyword("when")))) ) {
                        alt75=1;
                    }


                }


                switch (alt75) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:676:13: searchedWhenClause
            	    {
            	    pushFollow(FOLLOW_searchedWhenClause_in_searchedCase2596);
            	    searchedWhenClause245=searchedWhenClause();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) stream_searchedWhenClause.add(searchedWhenClause245.getTree());

            	    }
            	    break;

            	default :
            	    if ( cnt75 >= 1 ) break loop75;
            	    if (state.backtracking>0) {state.failed=true; return retval;}
                        EarlyExitException eee =
                            new EarlyExitException(75, input);
                        throw eee;
                }
                cnt75++;
            } while (true);


            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:676:33: ( elseClause )?
            int alt76=2;
            int LA76_0 = input.LA(1);

            if ( (LA76_0==IDENTIFIER) && ((((validateSoftKeyword("end")))||((validateSoftKeyword("else")))))) {
                int LA76_1 = input.LA(2);

                if ( (((validateSoftKeyword("else")))) ) {
                    alt76=1;
                }
            }
            switch (alt76) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:676:33: elseClause
                    {
                    pushFollow(FOLLOW_elseClause_in_searchedCase2599);
                    elseClause246=elseClause();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_elseClause.add(elseClause246.getTree());

                    }
                    break;

            }


            pushFollow(FOLLOW_end_key_in_searchedCase2602);
            end_key247=end_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_end_key.add(end_key247.getTree());

            // AST REWRITE
            // elements: elseClause, searchedWhenClause
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 677:2: -> ^( SEARCHED_CASE[$case_key.start, $case_key.text] ( searchedWhenClause )+ ( elseClause )? )
            {
                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:677:5: ^( SEARCHED_CASE[$case_key.start, $case_key.text] ( searchedWhenClause )+ ( elseClause )? )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(SEARCHED_CASE, (case_key244!=null?((Token)case_key244.start):null), (case_key244!=null?input.toString(case_key244.start,case_key244.stop):null))
                , root_1);

                if ( !(stream_searchedWhenClause.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_searchedWhenClause.hasNext() ) {
                    adaptor.addChild(root_1, stream_searchedWhenClause.nextTree());

                }
                stream_searchedWhenClause.reset();

                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:677:74: ( elseClause )?
                if ( stream_elseClause.hasNext() ) {
                    adaptor.addChild(root_1, stream_elseClause.nextTree());

                }
                stream_elseClause.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "searchedCase"


    public static class searchedWhenClause_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "searchedWhenClause"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:680:1: searchedWhenClause : when_key ^ logicalExpression then_key ! concatenation ;
    public final HQLParser.searchedWhenClause_return searchedWhenClause() throws RecognitionException {
        HQLParser.searchedWhenClause_return retval = new HQLParser.searchedWhenClause_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.when_key_return when_key248 =null;

        HQLParser.logicalExpression_return logicalExpression249 =null;

        HQLParser.then_key_return then_key250 =null;

        HQLParser.concatenation_return concatenation251 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:681:2: ( when_key ^ logicalExpression then_key ! concatenation )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:681:4: when_key ^ logicalExpression then_key ! concatenation
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_when_key_in_searchedWhenClause2627);
            when_key248=when_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(when_key248.getTree(), root_0);

            pushFollow(FOLLOW_logicalExpression_in_searchedWhenClause2630);
            logicalExpression249=logicalExpression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, logicalExpression249.getTree());

            pushFollow(FOLLOW_then_key_in_searchedWhenClause2632);
            then_key250=then_key();

            state._fsp--;
            if (state.failed) return retval;

            pushFollow(FOLLOW_concatenation_in_searchedWhenClause2635);
            concatenation251=concatenation();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, concatenation251.getTree());

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "searchedWhenClause"


    public static class quantifiedExpression_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "quantifiedExpression"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:684:1: quantifiedExpression : ( some_key ^| exists_key ^| all_key ^| any_key ^) ( collectionExpression | aliasReference | LEFT_PAREN ! subQuery RIGHT_PAREN !) ;
    public final HQLParser.quantifiedExpression_return quantifiedExpression() throws RecognitionException {
        HQLParser.quantifiedExpression_return retval = new HQLParser.quantifiedExpression_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token LEFT_PAREN258=null;
        Token RIGHT_PAREN260=null;
        HQLParser.some_key_return some_key252 =null;

        HQLParser.exists_key_return exists_key253 =null;

        HQLParser.all_key_return all_key254 =null;

        HQLParser.any_key_return any_key255 =null;

        HQLParser.collectionExpression_return collectionExpression256 =null;

        HQLParser.aliasReference_return aliasReference257 =null;

        HQLParser.subQuery_return subQuery259 =null;


        Object LEFT_PAREN258_tree=null;
        Object RIGHT_PAREN260_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:685:2: ( ( some_key ^| exists_key ^| all_key ^| any_key ^) ( collectionExpression | aliasReference | LEFT_PAREN ! subQuery RIGHT_PAREN !) )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:685:4: ( some_key ^| exists_key ^| all_key ^| any_key ^) ( collectionExpression | aliasReference | LEFT_PAREN ! subQuery RIGHT_PAREN !)
            {
            root_0 = (Object)adaptor.nil();


            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:685:4: ( some_key ^| exists_key ^| all_key ^| any_key ^)
            int alt77=4;
            int LA77_0 = input.LA(1);

            if ( (LA77_0==IDENTIFIER) && ((((validateSoftKeyword("exists")))||((validateSoftKeyword("some")))||((validateSoftKeyword("all")))||((validateSoftKeyword("any")))))) {
                int LA77_1 = input.LA(2);

                if ( (((validateSoftKeyword("some")))) ) {
                    alt77=1;
                }
                else if ( (((validateSoftKeyword("exists")))) ) {
                    alt77=2;
                }
                else if ( (((validateSoftKeyword("all")))) ) {
                    alt77=3;
                }
                else if ( (((validateSoftKeyword("any")))) ) {
                    alt77=4;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 77, 1, input);

                    throw nvae;

                }
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 77, 0, input);

                throw nvae;

            }
            switch (alt77) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:685:6: some_key ^
                    {
                    pushFollow(FOLLOW_some_key_in_quantifiedExpression2648);
                    some_key252=some_key();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(some_key252.getTree(), root_0);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:685:18: exists_key ^
                    {
                    pushFollow(FOLLOW_exists_key_in_quantifiedExpression2653);
                    exists_key253=exists_key();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(exists_key253.getTree(), root_0);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:685:32: all_key ^
                    {
                    pushFollow(FOLLOW_all_key_in_quantifiedExpression2658);
                    all_key254=all_key();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(all_key254.getTree(), root_0);

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:685:43: any_key ^
                    {
                    pushFollow(FOLLOW_any_key_in_quantifiedExpression2663);
                    any_key255=any_key();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(any_key255.getTree(), root_0);

                    }
                    break;

            }


            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:686:2: ( collectionExpression | aliasReference | LEFT_PAREN ! subQuery RIGHT_PAREN !)
            int alt78=3;
            int LA78_0 = input.LA(1);

            if ( (LA78_0==IDENTIFIER) ) {
                int LA78_1 = input.LA(2);

                if ( (LA78_1==LEFT_PAREN) && ((((validateSoftKeyword("elements")))||((validateSoftKeyword("indices")))))) {
                    alt78=1;
                }
                else if ( (LA78_1==EOF||LA78_1==ASTERISK||LA78_1==COMMA||LA78_1==DOUBLE_PIPE||LA78_1==EQUALS||(LA78_1 >= GREATER && LA78_1 <= GREATER_EQUAL)||LA78_1==IDENTIFIER||(LA78_1 >= LESS && LA78_1 <= LESS_EQUAL)||LA78_1==MINUS||LA78_1==NOT_EQUAL||LA78_1==PLUS||(LA78_1 >= RIGHT_PAREN && LA78_1 <= RIGHT_SQUARE)||LA78_1==SOLIDUS) ) {
                    alt78=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 78, 1, input);

                    throw nvae;

                }
            }
            else if ( (LA78_0==LEFT_PAREN) ) {
                alt78=3;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 78, 0, input);

                throw nvae;

            }
            switch (alt78) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:686:4: collectionExpression
                    {
                    pushFollow(FOLLOW_collectionExpression_in_quantifiedExpression2671);
                    collectionExpression256=collectionExpression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, collectionExpression256.getTree());

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:687:4: aliasReference
                    {
                    pushFollow(FOLLOW_aliasReference_in_quantifiedExpression2676);
                    aliasReference257=aliasReference();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, aliasReference257.getTree());

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:688:4: LEFT_PAREN ! subQuery RIGHT_PAREN !
                    {
                    LEFT_PAREN258=(Token)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_quantifiedExpression2681); if (state.failed) return retval;

                    pushFollow(FOLLOW_subQuery_in_quantifiedExpression2684);
                    subQuery259=subQuery();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, subQuery259.getTree());

                    RIGHT_PAREN260=(Token)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_quantifiedExpression2686); if (state.failed) return retval;

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "quantifiedExpression"


    public static class standardFunction_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "standardFunction"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:692:1: standardFunction : ( castFunction | concatFunction | substringFunction | trimFunction | upperFunction | lowerFunction | lengthFunction | locateFunction | absFunction | sqrtFunction | modFunction | sizeFunction | indexFunction | currentDateFunction | currentTimeFunction | currentTimestampFunction | extractFunction | positionFunction | charLengthFunction | octetLengthFunction | bitLengthFunction );
    public final HQLParser.standardFunction_return standardFunction() throws RecognitionException {
        HQLParser.standardFunction_return retval = new HQLParser.standardFunction_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.castFunction_return castFunction261 =null;

        HQLParser.concatFunction_return concatFunction262 =null;

        HQLParser.substringFunction_return substringFunction263 =null;

        HQLParser.trimFunction_return trimFunction264 =null;

        HQLParser.upperFunction_return upperFunction265 =null;

        HQLParser.lowerFunction_return lowerFunction266 =null;

        HQLParser.lengthFunction_return lengthFunction267 =null;

        HQLParser.locateFunction_return locateFunction268 =null;

        HQLParser.absFunction_return absFunction269 =null;

        HQLParser.sqrtFunction_return sqrtFunction270 =null;

        HQLParser.modFunction_return modFunction271 =null;

        HQLParser.sizeFunction_return sizeFunction272 =null;

        HQLParser.indexFunction_return indexFunction273 =null;

        HQLParser.currentDateFunction_return currentDateFunction274 =null;

        HQLParser.currentTimeFunction_return currentTimeFunction275 =null;

        HQLParser.currentTimestampFunction_return currentTimestampFunction276 =null;

        HQLParser.extractFunction_return extractFunction277 =null;

        HQLParser.positionFunction_return positionFunction278 =null;

        HQLParser.charLengthFunction_return charLengthFunction279 =null;

        HQLParser.octetLengthFunction_return octetLengthFunction280 =null;

        HQLParser.bitLengthFunction_return bitLengthFunction281 =null;



         if (state.backtracking == 0) enableParameterUsage.push(Boolean.TRUE); 
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:695:2: ( castFunction | concatFunction | substringFunction | trimFunction | upperFunction | lowerFunction | lengthFunction | locateFunction | absFunction | sqrtFunction | modFunction | sizeFunction | indexFunction | currentDateFunction | currentTimeFunction | currentTimestampFunction | extractFunction | positionFunction | charLengthFunction | octetLengthFunction | bitLengthFunction )
            int alt79=21;
            int LA79_0 = input.LA(1);

            if ( (LA79_0==IDENTIFIER) && ((((validateSoftKeyword("substring")))||((validateSoftKeyword("current_time")))||((validateSoftKeyword("concat")))||((validateSoftKeyword("octet_length")))||((validateSoftKeyword("character_length") || validateSoftKeyword("char_length")))||((validateSoftKeyword("upper")))||((validateSoftKeyword("mod")))||((validateSoftKeyword("abs")))||((validateSoftKeyword("extract")))||((validateSoftKeyword("locate")))||((validateSoftKeyword("trim")))||((validateSoftKeyword("size")))||((validateSoftKeyword("index")))||((validateSoftKeyword("length")))||((validateSoftKeyword("cast")))||((validateSoftKeyword("bit_length")))||((validateSoftKeyword("lower")))||((validateSoftKeyword("position")))||((validateSoftKeyword("current_timestamp")))||((validateSoftKeyword("sqrt")))||((validateSoftKeyword("current_date")))))) {
                int LA79_1 = input.LA(2);

                if ( (((validateSoftKeyword("cast")))) ) {
                    alt79=1;
                }
                else if ( (((validateSoftKeyword("concat")))) ) {
                    alt79=2;
                }
                else if ( (((validateSoftKeyword("substring")))) ) {
                    alt79=3;
                }
                else if ( (((validateSoftKeyword("trim")))) ) {
                    alt79=4;
                }
                else if ( (((validateSoftKeyword("upper")))) ) {
                    alt79=5;
                }
                else if ( (((validateSoftKeyword("lower")))) ) {
                    alt79=6;
                }
                else if ( (((validateSoftKeyword("length")))) ) {
                    alt79=7;
                }
                else if ( (((validateSoftKeyword("locate")))) ) {
                    alt79=8;
                }
                else if ( (((validateSoftKeyword("abs")))) ) {
                    alt79=9;
                }
                else if ( (((validateSoftKeyword("sqrt")))) ) {
                    alt79=10;
                }
                else if ( (((validateSoftKeyword("mod")))) ) {
                    alt79=11;
                }
                else if ( (((validateSoftKeyword("size")))) ) {
                    alt79=12;
                }
                else if ( (((validateSoftKeyword("index")))) ) {
                    alt79=13;
                }
                else if ( (((validateSoftKeyword("current_date")))) ) {
                    alt79=14;
                }
                else if ( (((validateSoftKeyword("current_time")))) ) {
                    alt79=15;
                }
                else if ( (((validateSoftKeyword("current_timestamp")))) ) {
                    alt79=16;
                }
                else if ( (((validateSoftKeyword("extract")))) ) {
                    alt79=17;
                }
                else if ( (((validateSoftKeyword("position")))) ) {
                    alt79=18;
                }
                else if ( (((validateSoftKeyword("character_length") || validateSoftKeyword("char_length")))) ) {
                    alt79=19;
                }
                else if ( (((validateSoftKeyword("octet_length")))) ) {
                    alt79=20;
                }
                else if ( (((validateSoftKeyword("bit_length")))) ) {
                    alt79=21;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 79, 1, input);

                    throw nvae;

                }
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 79, 0, input);

                throw nvae;

            }
            switch (alt79) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:695:4: castFunction
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_castFunction_in_standardFunction2711);
                    castFunction261=castFunction();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, castFunction261.getTree());

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:696:4: concatFunction
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_concatFunction_in_standardFunction2716);
                    concatFunction262=concatFunction();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, concatFunction262.getTree());

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:697:4: substringFunction
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_substringFunction_in_standardFunction2721);
                    substringFunction263=substringFunction();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, substringFunction263.getTree());

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:698:4: trimFunction
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_trimFunction_in_standardFunction2726);
                    trimFunction264=trimFunction();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, trimFunction264.getTree());

                    }
                    break;
                case 5 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:699:4: upperFunction
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_upperFunction_in_standardFunction2731);
                    upperFunction265=upperFunction();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, upperFunction265.getTree());

                    }
                    break;
                case 6 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:700:4: lowerFunction
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_lowerFunction_in_standardFunction2736);
                    lowerFunction266=lowerFunction();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, lowerFunction266.getTree());

                    }
                    break;
                case 7 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:701:4: lengthFunction
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_lengthFunction_in_standardFunction2741);
                    lengthFunction267=lengthFunction();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, lengthFunction267.getTree());

                    }
                    break;
                case 8 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:702:4: locateFunction
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_locateFunction_in_standardFunction2746);
                    locateFunction268=locateFunction();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, locateFunction268.getTree());

                    }
                    break;
                case 9 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:703:4: absFunction
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_absFunction_in_standardFunction2751);
                    absFunction269=absFunction();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, absFunction269.getTree());

                    }
                    break;
                case 10 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:704:4: sqrtFunction
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_sqrtFunction_in_standardFunction2756);
                    sqrtFunction270=sqrtFunction();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, sqrtFunction270.getTree());

                    }
                    break;
                case 11 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:705:4: modFunction
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_modFunction_in_standardFunction2761);
                    modFunction271=modFunction();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, modFunction271.getTree());

                    }
                    break;
                case 12 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:706:4: sizeFunction
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_sizeFunction_in_standardFunction2766);
                    sizeFunction272=sizeFunction();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, sizeFunction272.getTree());

                    }
                    break;
                case 13 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:707:4: indexFunction
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_indexFunction_in_standardFunction2771);
                    indexFunction273=indexFunction();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, indexFunction273.getTree());

                    }
                    break;
                case 14 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:708:4: currentDateFunction
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_currentDateFunction_in_standardFunction2776);
                    currentDateFunction274=currentDateFunction();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, currentDateFunction274.getTree());

                    }
                    break;
                case 15 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:709:4: currentTimeFunction
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_currentTimeFunction_in_standardFunction2781);
                    currentTimeFunction275=currentTimeFunction();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, currentTimeFunction275.getTree());

                    }
                    break;
                case 16 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:710:4: currentTimestampFunction
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_currentTimestampFunction_in_standardFunction2786);
                    currentTimestampFunction276=currentTimestampFunction();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, currentTimestampFunction276.getTree());

                    }
                    break;
                case 17 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:711:4: extractFunction
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_extractFunction_in_standardFunction2791);
                    extractFunction277=extractFunction();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, extractFunction277.getTree());

                    }
                    break;
                case 18 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:712:4: positionFunction
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_positionFunction_in_standardFunction2796);
                    positionFunction278=positionFunction();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, positionFunction278.getTree());

                    }
                    break;
                case 19 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:713:4: charLengthFunction
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_charLengthFunction_in_standardFunction2801);
                    charLengthFunction279=charLengthFunction();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, charLengthFunction279.getTree());

                    }
                    break;
                case 20 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:714:4: octetLengthFunction
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_octetLengthFunction_in_standardFunction2806);
                    octetLengthFunction280=octetLengthFunction();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, octetLengthFunction280.getTree());

                    }
                    break;
                case 21 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:715:4: bitLengthFunction
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_bitLengthFunction_in_standardFunction2811);
                    bitLengthFunction281=bitLengthFunction();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, bitLengthFunction281.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { enableParameterUsage.pop(); }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "standardFunction"


    public static class castFunction_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "castFunction"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:718:1: castFunction : cast_key ^ LEFT_PAREN ! concatenation as_key ! dataType RIGHT_PAREN !;
    public final HQLParser.castFunction_return castFunction() throws RecognitionException {
        HQLParser.castFunction_return retval = new HQLParser.castFunction_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token LEFT_PAREN283=null;
        Token RIGHT_PAREN287=null;
        HQLParser.cast_key_return cast_key282 =null;

        HQLParser.concatenation_return concatenation284 =null;

        HQLParser.as_key_return as_key285 =null;

        HQLParser.dataType_return dataType286 =null;


        Object LEFT_PAREN283_tree=null;
        Object RIGHT_PAREN287_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:719:2: ( cast_key ^ LEFT_PAREN ! concatenation as_key ! dataType RIGHT_PAREN !)
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:719:4: cast_key ^ LEFT_PAREN ! concatenation as_key ! dataType RIGHT_PAREN !
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_cast_key_in_castFunction2822);
            cast_key282=cast_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(cast_key282.getTree(), root_0);

            LEFT_PAREN283=(Token)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_castFunction2825); if (state.failed) return retval;

            pushFollow(FOLLOW_concatenation_in_castFunction2828);
            concatenation284=concatenation();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, concatenation284.getTree());

            pushFollow(FOLLOW_as_key_in_castFunction2830);
            as_key285=as_key();

            state._fsp--;
            if (state.failed) return retval;

            pushFollow(FOLLOW_dataType_in_castFunction2833);
            dataType286=dataType();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, dataType286.getTree());

            RIGHT_PAREN287=(Token)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_castFunction2835); if (state.failed) return retval;

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "castFunction"


    public static class concatFunction_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "concatFunction"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:722:1: concatFunction : concat_key ^ LEFT_PAREN ! concatenation ( COMMA ! concatenation )+ RIGHT_PAREN !;
    public final HQLParser.concatFunction_return concatFunction() throws RecognitionException {
        HQLParser.concatFunction_return retval = new HQLParser.concatFunction_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token LEFT_PAREN289=null;
        Token COMMA291=null;
        Token RIGHT_PAREN293=null;
        HQLParser.concat_key_return concat_key288 =null;

        HQLParser.concatenation_return concatenation290 =null;

        HQLParser.concatenation_return concatenation292 =null;


        Object LEFT_PAREN289_tree=null;
        Object COMMA291_tree=null;
        Object RIGHT_PAREN293_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:723:2: ( concat_key ^ LEFT_PAREN ! concatenation ( COMMA ! concatenation )+ RIGHT_PAREN !)
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:723:4: concat_key ^ LEFT_PAREN ! concatenation ( COMMA ! concatenation )+ RIGHT_PAREN !
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_concat_key_in_concatFunction2847);
            concat_key288=concat_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(concat_key288.getTree(), root_0);

            LEFT_PAREN289=(Token)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_concatFunction2850); if (state.failed) return retval;

            pushFollow(FOLLOW_concatenation_in_concatFunction2853);
            concatenation290=concatenation();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, concatenation290.getTree());

            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:723:42: ( COMMA ! concatenation )+
            int cnt80=0;
            loop80:
            do {
                int alt80=2;
                int LA80_0 = input.LA(1);

                if ( (LA80_0==COMMA) ) {
                    alt80=1;
                }


                switch (alt80) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:723:44: COMMA ! concatenation
            	    {
            	    COMMA291=(Token)match(input,COMMA,FOLLOW_COMMA_in_concatFunction2857); if (state.failed) return retval;

            	    pushFollow(FOLLOW_concatenation_in_concatFunction2860);
            	    concatenation292=concatenation();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) adaptor.addChild(root_0, concatenation292.getTree());

            	    }
            	    break;

            	default :
            	    if ( cnt80 >= 1 ) break loop80;
            	    if (state.backtracking>0) {state.failed=true; return retval;}
                        EarlyExitException eee =
                            new EarlyExitException(80, input);
                        throw eee;
                }
                cnt80++;
            } while (true);


            RIGHT_PAREN293=(Token)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_concatFunction2865); if (state.failed) return retval;

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "concatFunction"


    public static class substringFunction_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "substringFunction"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:726:1: substringFunction : substring_key ^ LEFT_PAREN ! concatenation COMMA ! concatenation ( COMMA ! concatenation )? RIGHT_PAREN !;
    public final HQLParser.substringFunction_return substringFunction() throws RecognitionException {
        HQLParser.substringFunction_return retval = new HQLParser.substringFunction_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token LEFT_PAREN295=null;
        Token COMMA297=null;
        Token COMMA299=null;
        Token RIGHT_PAREN301=null;
        HQLParser.substring_key_return substring_key294 =null;

        HQLParser.concatenation_return concatenation296 =null;

        HQLParser.concatenation_return concatenation298 =null;

        HQLParser.concatenation_return concatenation300 =null;


        Object LEFT_PAREN295_tree=null;
        Object COMMA297_tree=null;
        Object COMMA299_tree=null;
        Object RIGHT_PAREN301_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:727:2: ( substring_key ^ LEFT_PAREN ! concatenation COMMA ! concatenation ( COMMA ! concatenation )? RIGHT_PAREN !)
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:727:4: substring_key ^ LEFT_PAREN ! concatenation COMMA ! concatenation ( COMMA ! concatenation )? RIGHT_PAREN !
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_substring_key_in_substringFunction2877);
            substring_key294=substring_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(substring_key294.getTree(), root_0);

            LEFT_PAREN295=(Token)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_substringFunction2880); if (state.failed) return retval;

            pushFollow(FOLLOW_concatenation_in_substringFunction2883);
            concatenation296=concatenation();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, concatenation296.getTree());

            COMMA297=(Token)match(input,COMMA,FOLLOW_COMMA_in_substringFunction2885); if (state.failed) return retval;

            pushFollow(FOLLOW_concatenation_in_substringFunction2888);
            concatenation298=concatenation();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, concatenation298.getTree());

            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:727:66: ( COMMA ! concatenation )?
            int alt81=2;
            int LA81_0 = input.LA(1);

            if ( (LA81_0==COMMA) ) {
                alt81=1;
            }
            switch (alt81) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:727:68: COMMA ! concatenation
                    {
                    COMMA299=(Token)match(input,COMMA,FOLLOW_COMMA_in_substringFunction2892); if (state.failed) return retval;

                    pushFollow(FOLLOW_concatenation_in_substringFunction2895);
                    concatenation300=concatenation();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, concatenation300.getTree());

                    }
                    break;

            }


            RIGHT_PAREN301=(Token)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_substringFunction2899); if (state.failed) return retval;

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "substringFunction"


    public static class trimFunction_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "trimFunction"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:730:1: trimFunction : trim_key LEFT_PAREN trimOperands RIGHT_PAREN -> ^( trim_key trimOperands ) ;
    public final HQLParser.trimFunction_return trimFunction() throws RecognitionException {
        HQLParser.trimFunction_return retval = new HQLParser.trimFunction_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token LEFT_PAREN303=null;
        Token RIGHT_PAREN305=null;
        HQLParser.trim_key_return trim_key302 =null;

        HQLParser.trimOperands_return trimOperands304 =null;


        Object LEFT_PAREN303_tree=null;
        Object RIGHT_PAREN305_tree=null;
        RewriteRuleTokenStream stream_LEFT_PAREN=new RewriteRuleTokenStream(adaptor,"token LEFT_PAREN");
        RewriteRuleTokenStream stream_RIGHT_PAREN=new RewriteRuleTokenStream(adaptor,"token RIGHT_PAREN");
        RewriteRuleSubtreeStream stream_trim_key=new RewriteRuleSubtreeStream(adaptor,"rule trim_key");
        RewriteRuleSubtreeStream stream_trimOperands=new RewriteRuleSubtreeStream(adaptor,"rule trimOperands");
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:731:2: ( trim_key LEFT_PAREN trimOperands RIGHT_PAREN -> ^( trim_key trimOperands ) )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:731:4: trim_key LEFT_PAREN trimOperands RIGHT_PAREN
            {
            pushFollow(FOLLOW_trim_key_in_trimFunction2911);
            trim_key302=trim_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_trim_key.add(trim_key302.getTree());

            LEFT_PAREN303=(Token)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_trimFunction2913); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_LEFT_PAREN.add(LEFT_PAREN303);


            pushFollow(FOLLOW_trimOperands_in_trimFunction2915);
            trimOperands304=trimOperands();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_trimOperands.add(trimOperands304.getTree());

            RIGHT_PAREN305=(Token)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_trimFunction2917); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_RIGHT_PAREN.add(RIGHT_PAREN305);


            // AST REWRITE
            // elements: trimOperands, trim_key
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 732:3: -> ^( trim_key trimOperands )
            {
                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:732:6: ^( trim_key trimOperands )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(stream_trim_key.nextNode(), root_1);

                adaptor.addChild(root_1, stream_trimOperands.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "trimFunction"


    public static class trimOperands_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "trimOperands"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:735:1: trimOperands options {k=2; } : ( trimSpecification from_key concatenation -> ^( trimSpecification STRING_LITERAL[\" \"] concatenation ) | trimSpecification concatenation from_key concatenation -> ^( trimSpecification ( concatenation )+ ) | from_key concatenation -> ^( BOTH STRING_LITERAL[\" \"] concatenation ) |cn= concatenation ( from_key concatenation )? -> {hasSecondExpression}? ^( BOTH ( concatenation )+ ) -> ^( BOTH STRING_LITERAL[\" \"] $cn) );
    public final HQLParser.trimOperands_return trimOperands() throws RecognitionException {
        HQLParser.trimOperands_return retval = new HQLParser.trimOperands_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.concatenation_return cn =null;

        HQLParser.trimSpecification_return trimSpecification306 =null;

        HQLParser.from_key_return from_key307 =null;

        HQLParser.concatenation_return concatenation308 =null;

        HQLParser.trimSpecification_return trimSpecification309 =null;

        HQLParser.concatenation_return concatenation310 =null;

        HQLParser.from_key_return from_key311 =null;

        HQLParser.concatenation_return concatenation312 =null;

        HQLParser.from_key_return from_key313 =null;

        HQLParser.concatenation_return concatenation314 =null;

        HQLParser.from_key_return from_key315 =null;

        HQLParser.concatenation_return concatenation316 =null;


        RewriteRuleSubtreeStream stream_trimSpecification=new RewriteRuleSubtreeStream(adaptor,"rule trimSpecification");
        RewriteRuleSubtreeStream stream_concatenation=new RewriteRuleSubtreeStream(adaptor,"rule concatenation");
        RewriteRuleSubtreeStream stream_from_key=new RewriteRuleSubtreeStream(adaptor,"rule from_key");
        boolean hasSecondExpression = false;
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:740:2: ( trimSpecification from_key concatenation -> ^( trimSpecification STRING_LITERAL[\" \"] concatenation ) | trimSpecification concatenation from_key concatenation -> ^( trimSpecification ( concatenation )+ ) | from_key concatenation -> ^( BOTH STRING_LITERAL[\" \"] concatenation ) |cn= concatenation ( from_key concatenation )? -> {hasSecondExpression}? ^( BOTH ( concatenation )+ ) -> ^( BOTH STRING_LITERAL[\" \"] $cn) )
            int alt83=4;
            int LA83_0 = input.LA(1);

            if ( (LA83_0==IDENTIFIER) ) {
                int LA83_1 = input.LA(2);

                if ( (LA83_1==IDENTIFIER) ) {
                    int LA83_15 = input.LA(3);

                    if ( ((((validateSoftKeyword("trailing")))||((validateSoftKeyword("both")))||((validateSoftKeyword("leading"))))) ) {
                        alt83=1;
                    }
                    else if ( ((((validateSoftKeyword("trailing")))||((validateSoftKeyword("both")))||((validateSoftKeyword("leading"))))) ) {
                        alt83=2;
                    }
                    else if ( (((validateSoftKeyword("from")))) ) {
                        alt83=3;
                    }
                    else if ( (true) ) {
                        alt83=4;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 83, 15, input);

                        throw nvae;

                    }
                }
                else if ( (LA83_1==MINUS) ) {
                    int LA83_16 = input.LA(3);

                    if ( ((((validateSoftKeyword("trailing")))||((validateSoftKeyword("both")))||((validateSoftKeyword("leading"))))) ) {
                        alt83=2;
                    }
                    else if ( (((validateSoftKeyword("from")))) ) {
                        alt83=3;
                    }
                    else if ( (true) ) {
                        alt83=4;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 83, 16, input);

                        throw nvae;

                    }
                }
                else if ( (LA83_1==PLUS) ) {
                    int LA83_17 = input.LA(3);

                    if ( ((((validateSoftKeyword("trailing")))||((validateSoftKeyword("both")))||((validateSoftKeyword("leading"))))) ) {
                        alt83=2;
                    }
                    else if ( (((validateSoftKeyword("from")))) ) {
                        alt83=3;
                    }
                    else if ( (true) ) {
                        alt83=4;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 83, 17, input);

                        throw nvae;

                    }
                }
                else if ( (LA83_1==DECIMAL_LITERAL||LA83_1==FLOATING_POINT_LITERAL||LA83_1==INTEGER_LITERAL) && ((((validateSoftKeyword("trailing")))||((validateSoftKeyword("case")))||((validateSoftKeyword("both")))||((validateSoftKeyword("from")))||((validateSoftKeyword("leading")))))) {
                    int LA83_18 = input.LA(3);

                    if ( ((((validateSoftKeyword("trailing")))||((validateSoftKeyword("both")))||((validateSoftKeyword("leading"))))) ) {
                        alt83=2;
                    }
                    else if ( (((validateSoftKeyword("from")))) ) {
                        alt83=3;
                    }
                    else if ( (((validateSoftKeyword("case")))) ) {
                        alt83=4;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 83, 18, input);

                        throw nvae;

                    }
                }
                else if ( (LA83_1==HEX_LITERAL) && ((((validateSoftKeyword("trailing")))||((validateSoftKeyword("case")))||((validateSoftKeyword("both")))||((validateSoftKeyword("from")))||((validateSoftKeyword("leading")))))) {
                    int LA83_19 = input.LA(3);

                    if ( ((((validateSoftKeyword("trailing")))||((validateSoftKeyword("both")))||((validateSoftKeyword("leading"))))) ) {
                        alt83=2;
                    }
                    else if ( (((validateSoftKeyword("from")))) ) {
                        alt83=3;
                    }
                    else if ( (((validateSoftKeyword("case")))) ) {
                        alt83=4;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 83, 19, input);

                        throw nvae;

                    }
                }
                else if ( (LA83_1==OCTAL_LITERAL) && ((((validateSoftKeyword("trailing")))||((validateSoftKeyword("case")))||((validateSoftKeyword("both")))||((validateSoftKeyword("from")))||((validateSoftKeyword("leading")))))) {
                    int LA83_20 = input.LA(3);

                    if ( ((((validateSoftKeyword("trailing")))||((validateSoftKeyword("both")))||((validateSoftKeyword("leading"))))) ) {
                        alt83=2;
                    }
                    else if ( (((validateSoftKeyword("from")))) ) {
                        alt83=3;
                    }
                    else if ( (((validateSoftKeyword("case")))) ) {
                        alt83=4;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 83, 20, input);

                        throw nvae;

                    }
                }
                else if ( (LA83_1==CHARACTER_LITERAL) && ((((validateSoftKeyword("trailing")))||((validateSoftKeyword("case")))||((validateSoftKeyword("both")))||((validateSoftKeyword("from")))||((validateSoftKeyword("leading")))))) {
                    int LA83_21 = input.LA(3);

                    if ( ((((validateSoftKeyword("trailing")))||((validateSoftKeyword("both")))||((validateSoftKeyword("leading"))))) ) {
                        alt83=2;
                    }
                    else if ( (((validateSoftKeyword("from")))) ) {
                        alt83=3;
                    }
                    else if ( (((validateSoftKeyword("case")))) ) {
                        alt83=4;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 83, 21, input);

                        throw nvae;

                    }
                }
                else if ( (LA83_1==STRING_LITERAL) && ((((validateSoftKeyword("trailing")))||((validateSoftKeyword("case")))||((validateSoftKeyword("both")))||((validateSoftKeyword("from")))||((validateSoftKeyword("leading")))))) {
                    int LA83_22 = input.LA(3);

                    if ( ((((validateSoftKeyword("trailing")))||((validateSoftKeyword("both")))||((validateSoftKeyword("leading"))))) ) {
                        alt83=2;
                    }
                    else if ( (((validateSoftKeyword("from")))) ) {
                        alt83=3;
                    }
                    else if ( (((validateSoftKeyword("case")))) ) {
                        alt83=4;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 83, 22, input);

                        throw nvae;

                    }
                }
                else if ( (LA83_1==NULL) && ((((validateSoftKeyword("trailing")))||((validateSoftKeyword("case")))||((validateSoftKeyword("both")))||((validateSoftKeyword("leading")))||((validateSoftKeyword("from")))))) {
                    int LA83_23 = input.LA(3);

                    if ( ((((validateSoftKeyword("trailing")))||((validateSoftKeyword("both")))||((validateSoftKeyword("leading"))))) ) {
                        alt83=2;
                    }
                    else if ( (((validateSoftKeyword("from")))) ) {
                        alt83=3;
                    }
                    else if ( (((validateSoftKeyword("case")))) ) {
                        alt83=4;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 83, 23, input);

                        throw nvae;

                    }
                }
                else if ( (LA83_1==TRUE) && ((((validateSoftKeyword("trailing")))||((validateSoftKeyword("case")))||((validateSoftKeyword("both")))||((validateSoftKeyword("leading")))||((validateSoftKeyword("from")))))) {
                    int LA83_24 = input.LA(3);

                    if ( ((((validateSoftKeyword("trailing")))||((validateSoftKeyword("both")))||((validateSoftKeyword("leading"))))) ) {
                        alt83=2;
                    }
                    else if ( (((validateSoftKeyword("from")))) ) {
                        alt83=3;
                    }
                    else if ( (((validateSoftKeyword("case")))) ) {
                        alt83=4;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 83, 24, input);

                        throw nvae;

                    }
                }
                else if ( (LA83_1==FALSE) && ((((validateSoftKeyword("trailing")))||((validateSoftKeyword("case")))||((validateSoftKeyword("both")))||((validateSoftKeyword("leading")))||((validateSoftKeyword("from")))))) {
                    int LA83_25 = input.LA(3);

                    if ( ((((validateSoftKeyword("trailing")))||((validateSoftKeyword("both")))||((validateSoftKeyword("leading"))))) ) {
                        alt83=2;
                    }
                    else if ( (((validateSoftKeyword("from")))) ) {
                        alt83=3;
                    }
                    else if ( (((validateSoftKeyword("case")))) ) {
                        alt83=4;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 83, 25, input);

                        throw nvae;

                    }
                }
                else if ( (LA83_1==COLON) && ((((validateSoftKeyword("trailing")))||((validateSoftKeyword("case")))||((validateSoftKeyword("both")))||((validateSoftKeyword("leading")))||((validateSoftKeyword("from")))))) {
                    int LA83_26 = input.LA(3);

                    if ( ((((validateSoftKeyword("trailing")))||((validateSoftKeyword("both")))||((validateSoftKeyword("leading"))))) ) {
                        alt83=2;
                    }
                    else if ( (((validateSoftKeyword("from")))) ) {
                        alt83=3;
                    }
                    else if ( (((validateSoftKeyword("case")))) ) {
                        alt83=4;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 83, 26, input);

                        throw nvae;

                    }
                }
                else if ( (LA83_1==PARAM) && ((((validateSoftKeyword("trailing")))||((validateSoftKeyword("case")))||((validateSoftKeyword("both")))||((validateSoftKeyword("from")))||((validateSoftKeyword("leading")))))) {
                    int LA83_27 = input.LA(3);

                    if ( ((((validateSoftKeyword("trailing")))||((validateSoftKeyword("both")))||((validateSoftKeyword("leading"))))) ) {
                        alt83=2;
                    }
                    else if ( (((validateSoftKeyword("from")))) ) {
                        alt83=3;
                    }
                    else if ( (((validateSoftKeyword("case")))) ) {
                        alt83=4;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 83, 27, input);

                        throw nvae;

                    }
                }
                else if ( (LA83_1==LEFT_PAREN) ) {
                    int LA83_28 = input.LA(3);

                    if ( ((((validateSoftKeyword("trailing")))||((validateSoftKeyword("both")))||((validateSoftKeyword("leading"))))) ) {
                        alt83=2;
                    }
                    else if ( (((validateSoftKeyword("from")))) ) {
                        alt83=3;
                    }
                    else if ( (true) ) {
                        alt83=4;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 83, 28, input);

                        throw nvae;

                    }
                }
                else if ( (LA83_1==ASTERISK||LA83_1==DOT||LA83_1==DOUBLE_PIPE||LA83_1==LEFT_SQUARE||LA83_1==RIGHT_PAREN||LA83_1==SOLIDUS) ) {
                    alt83=4;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 83, 1, input);

                    throw nvae;

                }
            }
            else if ( (LA83_0==CHARACTER_LITERAL||LA83_0==COLON||LA83_0==DECIMAL_LITERAL||LA83_0==FALSE||LA83_0==FLOATING_POINT_LITERAL||LA83_0==HEX_LITERAL||LA83_0==INTEGER_LITERAL||LA83_0==LEFT_PAREN||LA83_0==MINUS||LA83_0==NULL||LA83_0==OCTAL_LITERAL||LA83_0==PARAM||LA83_0==PLUS||LA83_0==STRING_LITERAL||LA83_0==TRUE) ) {
                alt83=4;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 83, 0, input);

                throw nvae;

            }
            switch (alt83) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:740:4: trimSpecification from_key concatenation
                    {
                    pushFollow(FOLLOW_trimSpecification_in_trimOperands2952);
                    trimSpecification306=trimSpecification();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_trimSpecification.add(trimSpecification306.getTree());

                    pushFollow(FOLLOW_from_key_in_trimOperands2954);
                    from_key307=from_key();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_from_key.add(from_key307.getTree());

                    pushFollow(FOLLOW_concatenation_in_trimOperands2956);
                    concatenation308=concatenation();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_concatenation.add(concatenation308.getTree());

                    // AST REWRITE
                    // elements: trimSpecification, concatenation
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (Object)adaptor.nil();
                    // 740:45: -> ^( trimSpecification STRING_LITERAL[\" \"] concatenation )
                    {
                        // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:740:48: ^( trimSpecification STRING_LITERAL[\" \"] concatenation )
                        {
                        Object root_1 = (Object)adaptor.nil();
                        root_1 = (Object)adaptor.becomeRoot(stream_trimSpecification.nextNode(), root_1);

                        adaptor.addChild(root_1, 
                        (Object)adaptor.create(STRING_LITERAL, " ")
                        );

                        adaptor.addChild(root_1, stream_concatenation.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:741:4: trimSpecification concatenation from_key concatenation
                    {
                    pushFollow(FOLLOW_trimSpecification_in_trimOperands2972);
                    trimSpecification309=trimSpecification();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_trimSpecification.add(trimSpecification309.getTree());

                    pushFollow(FOLLOW_concatenation_in_trimOperands2974);
                    concatenation310=concatenation();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_concatenation.add(concatenation310.getTree());

                    pushFollow(FOLLOW_from_key_in_trimOperands2976);
                    from_key311=from_key();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_from_key.add(from_key311.getTree());

                    pushFollow(FOLLOW_concatenation_in_trimOperands2978);
                    concatenation312=concatenation();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_concatenation.add(concatenation312.getTree());

                    // AST REWRITE
                    // elements: trimSpecification, concatenation
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (Object)adaptor.nil();
                    // 741:59: -> ^( trimSpecification ( concatenation )+ )
                    {
                        // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:741:62: ^( trimSpecification ( concatenation )+ )
                        {
                        Object root_1 = (Object)adaptor.nil();
                        root_1 = (Object)adaptor.becomeRoot(stream_trimSpecification.nextNode(), root_1);

                        if ( !(stream_concatenation.hasNext()) ) {
                            throw new RewriteEarlyExitException();
                        }
                        while ( stream_concatenation.hasNext() ) {
                            adaptor.addChild(root_1, stream_concatenation.nextTree());

                        }
                        stream_concatenation.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:742:4: from_key concatenation
                    {
                    pushFollow(FOLLOW_from_key_in_trimOperands2992);
                    from_key313=from_key();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_from_key.add(from_key313.getTree());

                    pushFollow(FOLLOW_concatenation_in_trimOperands2994);
                    concatenation314=concatenation();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_concatenation.add(concatenation314.getTree());

                    // AST REWRITE
                    // elements: concatenation
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (Object)adaptor.nil();
                    // 742:27: -> ^( BOTH STRING_LITERAL[\" \"] concatenation )
                    {
                        // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:742:30: ^( BOTH STRING_LITERAL[\" \"] concatenation )
                        {
                        Object root_1 = (Object)adaptor.nil();
                        root_1 = (Object)adaptor.becomeRoot(
                        (Object)adaptor.create(BOTH, "BOTH")
                        , root_1);

                        adaptor.addChild(root_1, 
                        (Object)adaptor.create(STRING_LITERAL, " ")
                        );

                        adaptor.addChild(root_1, stream_concatenation.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:743:4: cn= concatenation ( from_key concatenation )?
                    {
                    pushFollow(FOLLOW_concatenation_in_trimOperands3012);
                    cn=concatenation();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_concatenation.add(cn.getTree());

                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:743:21: ( from_key concatenation )?
                    int alt82=2;
                    int LA82_0 = input.LA(1);

                    if ( (LA82_0==IDENTIFIER) && (((validateSoftKeyword("from"))))) {
                        alt82=1;
                    }
                    switch (alt82) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:743:23: from_key concatenation
                            {
                            pushFollow(FOLLOW_from_key_in_trimOperands3016);
                            from_key315=from_key();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_from_key.add(from_key315.getTree());

                            pushFollow(FOLLOW_concatenation_in_trimOperands3018);
                            concatenation316=concatenation();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_concatenation.add(concatenation316.getTree());

                            if ( state.backtracking==0 ) {hasSecondExpression = true;}

                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: concatenation, cn
                    // token labels: 
                    // rule labels: retval, cn
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_cn=new RewriteRuleSubtreeStream(adaptor,"rule cn",cn!=null?cn.tree:null);

                    root_0 = (Object)adaptor.nil();
                    // 744:3: -> {hasSecondExpression}? ^( BOTH ( concatenation )+ )
                    if (hasSecondExpression) {
                        // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:744:29: ^( BOTH ( concatenation )+ )
                        {
                        Object root_1 = (Object)adaptor.nil();
                        root_1 = (Object)adaptor.becomeRoot(
                        (Object)adaptor.create(BOTH, "BOTH")
                        , root_1);

                        if ( !(stream_concatenation.hasNext()) ) {
                            throw new RewriteEarlyExitException();
                        }
                        while ( stream_concatenation.hasNext() ) {
                            adaptor.addChild(root_1, stream_concatenation.nextTree());

                        }
                        stream_concatenation.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }

                    else // 745:3: -> ^( BOTH STRING_LITERAL[\" \"] $cn)
                    {
                        // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:745:6: ^( BOTH STRING_LITERAL[\" \"] $cn)
                        {
                        Object root_1 = (Object)adaptor.nil();
                        root_1 = (Object)adaptor.becomeRoot(
                        (Object)adaptor.create(BOTH, "BOTH")
                        , root_1);

                        adaptor.addChild(root_1, 
                        (Object)adaptor.create(STRING_LITERAL, " ")
                        );

                        adaptor.addChild(root_1, stream_cn.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "trimOperands"


    public static class trimSpecification_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "trimSpecification"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:748:1: trimSpecification : ( leading_key | trailing_key | both_key );
    public final HQLParser.trimSpecification_return trimSpecification() throws RecognitionException {
        HQLParser.trimSpecification_return retval = new HQLParser.trimSpecification_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.leading_key_return leading_key317 =null;

        HQLParser.trailing_key_return trailing_key318 =null;

        HQLParser.both_key_return both_key319 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:749:2: ( leading_key | trailing_key | both_key )
            int alt84=3;
            int LA84_0 = input.LA(1);

            if ( (LA84_0==IDENTIFIER) && ((((validateSoftKeyword("trailing")))||((validateSoftKeyword("both")))||((validateSoftKeyword("leading")))))) {
                int LA84_1 = input.LA(2);

                if ( (((validateSoftKeyword("leading")))) ) {
                    alt84=1;
                }
                else if ( (((validateSoftKeyword("trailing")))) ) {
                    alt84=2;
                }
                else if ( (((validateSoftKeyword("both")))) ) {
                    alt84=3;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 84, 1, input);

                    throw nvae;

                }
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 84, 0, input);

                throw nvae;

            }
            switch (alt84) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:749:4: leading_key
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_leading_key_in_trimSpecification3061);
                    leading_key317=leading_key();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, leading_key317.getTree());

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:750:4: trailing_key
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_trailing_key_in_trimSpecification3066);
                    trailing_key318=trailing_key();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, trailing_key318.getTree());

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:751:4: both_key
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_both_key_in_trimSpecification3071);
                    both_key319=both_key();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, both_key319.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "trimSpecification"


    public static class upperFunction_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "upperFunction"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:754:1: upperFunction : upper_key ^ LEFT_PAREN ! concatenation RIGHT_PAREN !;
    public final HQLParser.upperFunction_return upperFunction() throws RecognitionException {
        HQLParser.upperFunction_return retval = new HQLParser.upperFunction_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token LEFT_PAREN321=null;
        Token RIGHT_PAREN323=null;
        HQLParser.upper_key_return upper_key320 =null;

        HQLParser.concatenation_return concatenation322 =null;


        Object LEFT_PAREN321_tree=null;
        Object RIGHT_PAREN323_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:755:2: ( upper_key ^ LEFT_PAREN ! concatenation RIGHT_PAREN !)
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:755:4: upper_key ^ LEFT_PAREN ! concatenation RIGHT_PAREN !
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_upper_key_in_upperFunction3082);
            upper_key320=upper_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(upper_key320.getTree(), root_0);

            LEFT_PAREN321=(Token)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_upperFunction3085); if (state.failed) return retval;

            pushFollow(FOLLOW_concatenation_in_upperFunction3088);
            concatenation322=concatenation();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, concatenation322.getTree());

            RIGHT_PAREN323=(Token)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_upperFunction3090); if (state.failed) return retval;

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "upperFunction"


    public static class lowerFunction_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "lowerFunction"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:758:1: lowerFunction : lower_key ^ LEFT_PAREN ! concatenation RIGHT_PAREN !;
    public final HQLParser.lowerFunction_return lowerFunction() throws RecognitionException {
        HQLParser.lowerFunction_return retval = new HQLParser.lowerFunction_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token LEFT_PAREN325=null;
        Token RIGHT_PAREN327=null;
        HQLParser.lower_key_return lower_key324 =null;

        HQLParser.concatenation_return concatenation326 =null;


        Object LEFT_PAREN325_tree=null;
        Object RIGHT_PAREN327_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:759:2: ( lower_key ^ LEFT_PAREN ! concatenation RIGHT_PAREN !)
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:759:4: lower_key ^ LEFT_PAREN ! concatenation RIGHT_PAREN !
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_lower_key_in_lowerFunction3102);
            lower_key324=lower_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(lower_key324.getTree(), root_0);

            LEFT_PAREN325=(Token)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_lowerFunction3105); if (state.failed) return retval;

            pushFollow(FOLLOW_concatenation_in_lowerFunction3108);
            concatenation326=concatenation();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, concatenation326.getTree());

            RIGHT_PAREN327=(Token)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_lowerFunction3110); if (state.failed) return retval;

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "lowerFunction"


    public static class lengthFunction_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "lengthFunction"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:762:1: lengthFunction : length_key ^ LEFT_PAREN ! concatenation RIGHT_PAREN !;
    public final HQLParser.lengthFunction_return lengthFunction() throws RecognitionException {
        HQLParser.lengthFunction_return retval = new HQLParser.lengthFunction_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token LEFT_PAREN329=null;
        Token RIGHT_PAREN331=null;
        HQLParser.length_key_return length_key328 =null;

        HQLParser.concatenation_return concatenation330 =null;


        Object LEFT_PAREN329_tree=null;
        Object RIGHT_PAREN331_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:763:2: ( length_key ^ LEFT_PAREN ! concatenation RIGHT_PAREN !)
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:763:4: length_key ^ LEFT_PAREN ! concatenation RIGHT_PAREN !
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_length_key_in_lengthFunction3122);
            length_key328=length_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(length_key328.getTree(), root_0);

            LEFT_PAREN329=(Token)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_lengthFunction3125); if (state.failed) return retval;

            pushFollow(FOLLOW_concatenation_in_lengthFunction3128);
            concatenation330=concatenation();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, concatenation330.getTree());

            RIGHT_PAREN331=(Token)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_lengthFunction3130); if (state.failed) return retval;

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "lengthFunction"


    public static class locateFunction_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "locateFunction"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:766:1: locateFunction : locate_key ^ LEFT_PAREN ! concatenation COMMA ! concatenation ( COMMA ! concatenation )? RIGHT_PAREN !;
    public final HQLParser.locateFunction_return locateFunction() throws RecognitionException {
        HQLParser.locateFunction_return retval = new HQLParser.locateFunction_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token LEFT_PAREN333=null;
        Token COMMA335=null;
        Token COMMA337=null;
        Token RIGHT_PAREN339=null;
        HQLParser.locate_key_return locate_key332 =null;

        HQLParser.concatenation_return concatenation334 =null;

        HQLParser.concatenation_return concatenation336 =null;

        HQLParser.concatenation_return concatenation338 =null;


        Object LEFT_PAREN333_tree=null;
        Object COMMA335_tree=null;
        Object COMMA337_tree=null;
        Object RIGHT_PAREN339_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:767:2: ( locate_key ^ LEFT_PAREN ! concatenation COMMA ! concatenation ( COMMA ! concatenation )? RIGHT_PAREN !)
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:767:4: locate_key ^ LEFT_PAREN ! concatenation COMMA ! concatenation ( COMMA ! concatenation )? RIGHT_PAREN !
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_locate_key_in_locateFunction3142);
            locate_key332=locate_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(locate_key332.getTree(), root_0);

            LEFT_PAREN333=(Token)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_locateFunction3145); if (state.failed) return retval;

            pushFollow(FOLLOW_concatenation_in_locateFunction3148);
            concatenation334=concatenation();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, concatenation334.getTree());

            COMMA335=(Token)match(input,COMMA,FOLLOW_COMMA_in_locateFunction3150); if (state.failed) return retval;

            pushFollow(FOLLOW_concatenation_in_locateFunction3153);
            concatenation336=concatenation();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, concatenation336.getTree());

            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:767:63: ( COMMA ! concatenation )?
            int alt85=2;
            int LA85_0 = input.LA(1);

            if ( (LA85_0==COMMA) ) {
                alt85=1;
            }
            switch (alt85) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:767:65: COMMA ! concatenation
                    {
                    COMMA337=(Token)match(input,COMMA,FOLLOW_COMMA_in_locateFunction3157); if (state.failed) return retval;

                    pushFollow(FOLLOW_concatenation_in_locateFunction3160);
                    concatenation338=concatenation();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, concatenation338.getTree());

                    }
                    break;

            }


            RIGHT_PAREN339=(Token)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_locateFunction3165); if (state.failed) return retval;

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "locateFunction"


    public static class absFunction_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "absFunction"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:770:1: absFunction : abs_key ^ LEFT_PAREN ! concatenation RIGHT_PAREN !;
    public final HQLParser.absFunction_return absFunction() throws RecognitionException {
        HQLParser.absFunction_return retval = new HQLParser.absFunction_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token LEFT_PAREN341=null;
        Token RIGHT_PAREN343=null;
        HQLParser.abs_key_return abs_key340 =null;

        HQLParser.concatenation_return concatenation342 =null;


        Object LEFT_PAREN341_tree=null;
        Object RIGHT_PAREN343_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:771:2: ( abs_key ^ LEFT_PAREN ! concatenation RIGHT_PAREN !)
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:771:4: abs_key ^ LEFT_PAREN ! concatenation RIGHT_PAREN !
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_abs_key_in_absFunction3177);
            abs_key340=abs_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(abs_key340.getTree(), root_0);

            LEFT_PAREN341=(Token)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_absFunction3180); if (state.failed) return retval;

            pushFollow(FOLLOW_concatenation_in_absFunction3183);
            concatenation342=concatenation();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, concatenation342.getTree());

            RIGHT_PAREN343=(Token)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_absFunction3185); if (state.failed) return retval;

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "absFunction"


    public static class sqrtFunction_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "sqrtFunction"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:774:1: sqrtFunction : sqrt_key ^ LEFT_PAREN ! concatenation RIGHT_PAREN !;
    public final HQLParser.sqrtFunction_return sqrtFunction() throws RecognitionException {
        HQLParser.sqrtFunction_return retval = new HQLParser.sqrtFunction_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token LEFT_PAREN345=null;
        Token RIGHT_PAREN347=null;
        HQLParser.sqrt_key_return sqrt_key344 =null;

        HQLParser.concatenation_return concatenation346 =null;


        Object LEFT_PAREN345_tree=null;
        Object RIGHT_PAREN347_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:775:2: ( sqrt_key ^ LEFT_PAREN ! concatenation RIGHT_PAREN !)
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:775:4: sqrt_key ^ LEFT_PAREN ! concatenation RIGHT_PAREN !
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_sqrt_key_in_sqrtFunction3197);
            sqrt_key344=sqrt_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(sqrt_key344.getTree(), root_0);

            LEFT_PAREN345=(Token)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_sqrtFunction3200); if (state.failed) return retval;

            pushFollow(FOLLOW_concatenation_in_sqrtFunction3203);
            concatenation346=concatenation();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, concatenation346.getTree());

            RIGHT_PAREN347=(Token)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_sqrtFunction3205); if (state.failed) return retval;

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "sqrtFunction"


    public static class modFunction_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "modFunction"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:778:1: modFunction : mod_key ^ LEFT_PAREN ! concatenation COMMA ! concatenation RIGHT_PAREN !;
    public final HQLParser.modFunction_return modFunction() throws RecognitionException {
        HQLParser.modFunction_return retval = new HQLParser.modFunction_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token LEFT_PAREN349=null;
        Token COMMA351=null;
        Token RIGHT_PAREN353=null;
        HQLParser.mod_key_return mod_key348 =null;

        HQLParser.concatenation_return concatenation350 =null;

        HQLParser.concatenation_return concatenation352 =null;


        Object LEFT_PAREN349_tree=null;
        Object COMMA351_tree=null;
        Object RIGHT_PAREN353_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:779:2: ( mod_key ^ LEFT_PAREN ! concatenation COMMA ! concatenation RIGHT_PAREN !)
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:779:4: mod_key ^ LEFT_PAREN ! concatenation COMMA ! concatenation RIGHT_PAREN !
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_mod_key_in_modFunction3217);
            mod_key348=mod_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(mod_key348.getTree(), root_0);

            LEFT_PAREN349=(Token)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_modFunction3220); if (state.failed) return retval;

            pushFollow(FOLLOW_concatenation_in_modFunction3223);
            concatenation350=concatenation();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, concatenation350.getTree());

            COMMA351=(Token)match(input,COMMA,FOLLOW_COMMA_in_modFunction3225); if (state.failed) return retval;

            pushFollow(FOLLOW_concatenation_in_modFunction3228);
            concatenation352=concatenation();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, concatenation352.getTree());

            RIGHT_PAREN353=(Token)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_modFunction3230); if (state.failed) return retval;

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "modFunction"


    public static class sizeFunction_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "sizeFunction"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:782:1: sizeFunction : size_key ^ LEFT_PAREN ! propertyReference RIGHT_PAREN !;
    public final HQLParser.sizeFunction_return sizeFunction() throws RecognitionException {
        HQLParser.sizeFunction_return retval = new HQLParser.sizeFunction_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token LEFT_PAREN355=null;
        Token RIGHT_PAREN357=null;
        HQLParser.size_key_return size_key354 =null;

        HQLParser.propertyReference_return propertyReference356 =null;


        Object LEFT_PAREN355_tree=null;
        Object RIGHT_PAREN357_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:783:2: ( size_key ^ LEFT_PAREN ! propertyReference RIGHT_PAREN !)
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:783:4: size_key ^ LEFT_PAREN ! propertyReference RIGHT_PAREN !
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_size_key_in_sizeFunction3242);
            size_key354=size_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(size_key354.getTree(), root_0);

            LEFT_PAREN355=(Token)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_sizeFunction3245); if (state.failed) return retval;

            pushFollow(FOLLOW_propertyReference_in_sizeFunction3248);
            propertyReference356=propertyReference();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, propertyReference356.getTree());

            RIGHT_PAREN357=(Token)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_sizeFunction3250); if (state.failed) return retval;

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "sizeFunction"


    public static class indexFunction_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "indexFunction"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:786:1: indexFunction : index_key ^ LEFT_PAREN ! aliasReference RIGHT_PAREN !;
    public final HQLParser.indexFunction_return indexFunction() throws RecognitionException {
        HQLParser.indexFunction_return retval = new HQLParser.indexFunction_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token LEFT_PAREN359=null;
        Token RIGHT_PAREN361=null;
        HQLParser.index_key_return index_key358 =null;

        HQLParser.aliasReference_return aliasReference360 =null;


        Object LEFT_PAREN359_tree=null;
        Object RIGHT_PAREN361_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:787:2: ( index_key ^ LEFT_PAREN ! aliasReference RIGHT_PAREN !)
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:787:4: index_key ^ LEFT_PAREN ! aliasReference RIGHT_PAREN !
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_index_key_in_indexFunction3262);
            index_key358=index_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(index_key358.getTree(), root_0);

            LEFT_PAREN359=(Token)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_indexFunction3265); if (state.failed) return retval;

            pushFollow(FOLLOW_aliasReference_in_indexFunction3268);
            aliasReference360=aliasReference();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, aliasReference360.getTree());

            RIGHT_PAREN361=(Token)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_indexFunction3270); if (state.failed) return retval;

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "indexFunction"


    public static class currentDateFunction_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "currentDateFunction"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:790:1: currentDateFunction : current_date_key ( LEFT_PAREN ! RIGHT_PAREN !)? ;
    public final HQLParser.currentDateFunction_return currentDateFunction() throws RecognitionException {
        HQLParser.currentDateFunction_return retval = new HQLParser.currentDateFunction_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token LEFT_PAREN363=null;
        Token RIGHT_PAREN364=null;
        HQLParser.current_date_key_return current_date_key362 =null;


        Object LEFT_PAREN363_tree=null;
        Object RIGHT_PAREN364_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:791:2: ( current_date_key ( LEFT_PAREN ! RIGHT_PAREN !)? )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:791:4: current_date_key ( LEFT_PAREN ! RIGHT_PAREN !)?
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_current_date_key_in_currentDateFunction3282);
            current_date_key362=current_date_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, current_date_key362.getTree());

            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:791:21: ( LEFT_PAREN ! RIGHT_PAREN !)?
            int alt86=2;
            int LA86_0 = input.LA(1);

            if ( (LA86_0==LEFT_PAREN) ) {
                alt86=1;
            }
            switch (alt86) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:791:23: LEFT_PAREN ! RIGHT_PAREN !
                    {
                    LEFT_PAREN363=(Token)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_currentDateFunction3286); if (state.failed) return retval;

                    RIGHT_PAREN364=(Token)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_currentDateFunction3289); if (state.failed) return retval;

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "currentDateFunction"


    public static class currentTimeFunction_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "currentTimeFunction"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:794:1: currentTimeFunction : current_time_key ( LEFT_PAREN ! RIGHT_PAREN !)? ;
    public final HQLParser.currentTimeFunction_return currentTimeFunction() throws RecognitionException {
        HQLParser.currentTimeFunction_return retval = new HQLParser.currentTimeFunction_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token LEFT_PAREN366=null;
        Token RIGHT_PAREN367=null;
        HQLParser.current_time_key_return current_time_key365 =null;


        Object LEFT_PAREN366_tree=null;
        Object RIGHT_PAREN367_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:795:2: ( current_time_key ( LEFT_PAREN ! RIGHT_PAREN !)? )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:795:4: current_time_key ( LEFT_PAREN ! RIGHT_PAREN !)?
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_current_time_key_in_currentTimeFunction3304);
            current_time_key365=current_time_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, current_time_key365.getTree());

            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:795:21: ( LEFT_PAREN ! RIGHT_PAREN !)?
            int alt87=2;
            int LA87_0 = input.LA(1);

            if ( (LA87_0==LEFT_PAREN) ) {
                alt87=1;
            }
            switch (alt87) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:795:23: LEFT_PAREN ! RIGHT_PAREN !
                    {
                    LEFT_PAREN366=(Token)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_currentTimeFunction3308); if (state.failed) return retval;

                    RIGHT_PAREN367=(Token)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_currentTimeFunction3311); if (state.failed) return retval;

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "currentTimeFunction"


    public static class currentTimestampFunction_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "currentTimestampFunction"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:798:1: currentTimestampFunction : current_timestamp_key ( LEFT_PAREN ! RIGHT_PAREN !)? ;
    public final HQLParser.currentTimestampFunction_return currentTimestampFunction() throws RecognitionException {
        HQLParser.currentTimestampFunction_return retval = new HQLParser.currentTimestampFunction_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token LEFT_PAREN369=null;
        Token RIGHT_PAREN370=null;
        HQLParser.current_timestamp_key_return current_timestamp_key368 =null;


        Object LEFT_PAREN369_tree=null;
        Object RIGHT_PAREN370_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:799:2: ( current_timestamp_key ( LEFT_PAREN ! RIGHT_PAREN !)? )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:799:4: current_timestamp_key ( LEFT_PAREN ! RIGHT_PAREN !)?
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_current_timestamp_key_in_currentTimestampFunction3326);
            current_timestamp_key368=current_timestamp_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, current_timestamp_key368.getTree());

            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:799:26: ( LEFT_PAREN ! RIGHT_PAREN !)?
            int alt88=2;
            int LA88_0 = input.LA(1);

            if ( (LA88_0==LEFT_PAREN) ) {
                alt88=1;
            }
            switch (alt88) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:799:28: LEFT_PAREN ! RIGHT_PAREN !
                    {
                    LEFT_PAREN369=(Token)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_currentTimestampFunction3330); if (state.failed) return retval;

                    RIGHT_PAREN370=(Token)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_currentTimestampFunction3333); if (state.failed) return retval;

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "currentTimestampFunction"


    public static class extractFunction_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "extractFunction"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:802:1: extractFunction : extract_key ^ LEFT_PAREN ! extractField from_key ! concatenation RIGHT_PAREN !;
    public final HQLParser.extractFunction_return extractFunction() throws RecognitionException {
        HQLParser.extractFunction_return retval = new HQLParser.extractFunction_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token LEFT_PAREN372=null;
        Token RIGHT_PAREN376=null;
        HQLParser.extract_key_return extract_key371 =null;

        HQLParser.extractField_return extractField373 =null;

        HQLParser.from_key_return from_key374 =null;

        HQLParser.concatenation_return concatenation375 =null;


        Object LEFT_PAREN372_tree=null;
        Object RIGHT_PAREN376_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:803:2: ( extract_key ^ LEFT_PAREN ! extractField from_key ! concatenation RIGHT_PAREN !)
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:803:4: extract_key ^ LEFT_PAREN ! extractField from_key ! concatenation RIGHT_PAREN !
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_extract_key_in_extractFunction3348);
            extract_key371=extract_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(extract_key371.getTree(), root_0);

            LEFT_PAREN372=(Token)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_extractFunction3351); if (state.failed) return retval;

            pushFollow(FOLLOW_extractField_in_extractFunction3354);
            extractField373=extractField();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, extractField373.getTree());

            pushFollow(FOLLOW_from_key_in_extractFunction3356);
            from_key374=from_key();

            state._fsp--;
            if (state.failed) return retval;

            pushFollow(FOLLOW_concatenation_in_extractFunction3359);
            concatenation375=concatenation();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, concatenation375.getTree());

            RIGHT_PAREN376=(Token)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_extractFunction3361); if (state.failed) return retval;

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "extractFunction"


    public static class extractField_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "extractField"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:806:1: extractField : ( datetimeField | timeZoneField );
    public final HQLParser.extractField_return extractField() throws RecognitionException {
        HQLParser.extractField_return retval = new HQLParser.extractField_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.datetimeField_return datetimeField377 =null;

        HQLParser.timeZoneField_return timeZoneField378 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:807:2: ( datetimeField | timeZoneField )
            int alt89=2;
            int LA89_0 = input.LA(1);

            if ( (LA89_0==IDENTIFIER) && ((((validateSoftKeyword("timezone_minute")))||((validateSoftKeyword("timezone_hour")))||((validateSoftKeyword("second")))||((validateSoftKeyword("year")))||((validateSoftKeyword("day")))||((validateSoftKeyword("minute")))||((validateSoftKeyword("hour")))||((validateSoftKeyword("month")))))) {
                int LA89_1 = input.LA(2);

                if ( ((((validateSoftKeyword("second")))||((validateSoftKeyword("year")))||((validateSoftKeyword("day")))||((validateSoftKeyword("hour")))||((validateSoftKeyword("month")))||((validateSoftKeyword("minute"))))) ) {
                    alt89=1;
                }
                else if ( ((((validateSoftKeyword("timezone_minute")))||((validateSoftKeyword("timezone_hour"))))) ) {
                    alt89=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 89, 1, input);

                    throw nvae;

                }
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 89, 0, input);

                throw nvae;

            }
            switch (alt89) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:807:4: datetimeField
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_datetimeField_in_extractField3373);
                    datetimeField377=datetimeField();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, datetimeField377.getTree());

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:808:4: timeZoneField
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_timeZoneField_in_extractField3378);
                    timeZoneField378=timeZoneField();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, timeZoneField378.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "extractField"


    public static class datetimeField_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "datetimeField"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:811:1: datetimeField : ( nonSecondDatetimeField | second_key );
    public final HQLParser.datetimeField_return datetimeField() throws RecognitionException {
        HQLParser.datetimeField_return retval = new HQLParser.datetimeField_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.nonSecondDatetimeField_return nonSecondDatetimeField379 =null;

        HQLParser.second_key_return second_key380 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:812:2: ( nonSecondDatetimeField | second_key )
            int alt90=2;
            int LA90_0 = input.LA(1);

            if ( (LA90_0==IDENTIFIER) && ((((validateSoftKeyword("second")))||((validateSoftKeyword("day")))||((validateSoftKeyword("year")))||((validateSoftKeyword("hour")))||((validateSoftKeyword("minute")))||((validateSoftKeyword("month")))))) {
                int LA90_1 = input.LA(2);

                if ( ((((validateSoftKeyword("day")))||((validateSoftKeyword("year")))||((validateSoftKeyword("minute")))||((validateSoftKeyword("month")))||((validateSoftKeyword("hour"))))) ) {
                    alt90=1;
                }
                else if ( (((validateSoftKeyword("second")))) ) {
                    alt90=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 90, 1, input);

                    throw nvae;

                }
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 90, 0, input);

                throw nvae;

            }
            switch (alt90) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:812:4: nonSecondDatetimeField
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_nonSecondDatetimeField_in_datetimeField3389);
                    nonSecondDatetimeField379=nonSecondDatetimeField();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, nonSecondDatetimeField379.getTree());

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:813:4: second_key
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_second_key_in_datetimeField3394);
                    second_key380=second_key();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, second_key380.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "datetimeField"


    public static class nonSecondDatetimeField_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "nonSecondDatetimeField"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:816:1: nonSecondDatetimeField : ( year_key | month_key | day_key | hour_key | minute_key );
    public final HQLParser.nonSecondDatetimeField_return nonSecondDatetimeField() throws RecognitionException {
        HQLParser.nonSecondDatetimeField_return retval = new HQLParser.nonSecondDatetimeField_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.year_key_return year_key381 =null;

        HQLParser.month_key_return month_key382 =null;

        HQLParser.day_key_return day_key383 =null;

        HQLParser.hour_key_return hour_key384 =null;

        HQLParser.minute_key_return minute_key385 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:817:2: ( year_key | month_key | day_key | hour_key | minute_key )
            int alt91=5;
            int LA91_0 = input.LA(1);

            if ( (LA91_0==IDENTIFIER) && ((((validateSoftKeyword("year")))||((validateSoftKeyword("day")))||((validateSoftKeyword("hour")))||((validateSoftKeyword("month")))||((validateSoftKeyword("minute")))))) {
                int LA91_1 = input.LA(2);

                if ( (((validateSoftKeyword("year")))) ) {
                    alt91=1;
                }
                else if ( (((validateSoftKeyword("month")))) ) {
                    alt91=2;
                }
                else if ( (((validateSoftKeyword("day")))) ) {
                    alt91=3;
                }
                else if ( (((validateSoftKeyword("hour")))) ) {
                    alt91=4;
                }
                else if ( (((validateSoftKeyword("minute")))) ) {
                    alt91=5;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 91, 1, input);

                    throw nvae;

                }
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 91, 0, input);

                throw nvae;

            }
            switch (alt91) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:817:4: year_key
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_year_key_in_nonSecondDatetimeField3405);
                    year_key381=year_key();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, year_key381.getTree());

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:818:4: month_key
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_month_key_in_nonSecondDatetimeField3410);
                    month_key382=month_key();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, month_key382.getTree());

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:819:4: day_key
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_day_key_in_nonSecondDatetimeField3415);
                    day_key383=day_key();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, day_key383.getTree());

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:820:4: hour_key
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_hour_key_in_nonSecondDatetimeField3420);
                    hour_key384=hour_key();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, hour_key384.getTree());

                    }
                    break;
                case 5 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:821:4: minute_key
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_minute_key_in_nonSecondDatetimeField3425);
                    minute_key385=minute_key();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, minute_key385.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "nonSecondDatetimeField"


    public static class timeZoneField_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "timeZoneField"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:824:1: timeZoneField : ( timezone_hour_key | timezone_minute_key );
    public final HQLParser.timeZoneField_return timeZoneField() throws RecognitionException {
        HQLParser.timeZoneField_return retval = new HQLParser.timeZoneField_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.timezone_hour_key_return timezone_hour_key386 =null;

        HQLParser.timezone_minute_key_return timezone_minute_key387 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:825:2: ( timezone_hour_key | timezone_minute_key )
            int alt92=2;
            int LA92_0 = input.LA(1);

            if ( (LA92_0==IDENTIFIER) && ((((validateSoftKeyword("timezone_minute")))||((validateSoftKeyword("timezone_hour")))))) {
                int LA92_1 = input.LA(2);

                if ( (((validateSoftKeyword("timezone_hour")))) ) {
                    alt92=1;
                }
                else if ( (((validateSoftKeyword("timezone_minute")))) ) {
                    alt92=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 92, 1, input);

                    throw nvae;

                }
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 92, 0, input);

                throw nvae;

            }
            switch (alt92) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:825:4: timezone_hour_key
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_timezone_hour_key_in_timeZoneField3436);
                    timezone_hour_key386=timezone_hour_key();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, timezone_hour_key386.getTree());

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:826:4: timezone_minute_key
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_timezone_minute_key_in_timeZoneField3441);
                    timezone_minute_key387=timezone_minute_key();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, timezone_minute_key387.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "timeZoneField"


    public static class positionFunction_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "positionFunction"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:829:1: positionFunction : position_key ^ LEFT_PAREN ! concatenation in_key ! concatenation RIGHT_PAREN !;
    public final HQLParser.positionFunction_return positionFunction() throws RecognitionException {
        HQLParser.positionFunction_return retval = new HQLParser.positionFunction_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token LEFT_PAREN389=null;
        Token RIGHT_PAREN393=null;
        HQLParser.position_key_return position_key388 =null;

        HQLParser.concatenation_return concatenation390 =null;

        HQLParser.in_key_return in_key391 =null;

        HQLParser.concatenation_return concatenation392 =null;


        Object LEFT_PAREN389_tree=null;
        Object RIGHT_PAREN393_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:830:2: ( position_key ^ LEFT_PAREN ! concatenation in_key ! concatenation RIGHT_PAREN !)
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:830:4: position_key ^ LEFT_PAREN ! concatenation in_key ! concatenation RIGHT_PAREN !
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_position_key_in_positionFunction3452);
            position_key388=position_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(position_key388.getTree(), root_0);

            LEFT_PAREN389=(Token)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_positionFunction3455); if (state.failed) return retval;

            pushFollow(FOLLOW_concatenation_in_positionFunction3458);
            concatenation390=concatenation();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, concatenation390.getTree());

            pushFollow(FOLLOW_in_key_in_positionFunction3460);
            in_key391=in_key();

            state._fsp--;
            if (state.failed) return retval;

            pushFollow(FOLLOW_concatenation_in_positionFunction3463);
            concatenation392=concatenation();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, concatenation392.getTree());

            RIGHT_PAREN393=(Token)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_positionFunction3465); if (state.failed) return retval;

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "positionFunction"


    public static class charLengthFunction_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "charLengthFunction"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:833:1: charLengthFunction : character_length_key ^ LEFT_PAREN ! concatenation RIGHT_PAREN !;
    public final HQLParser.charLengthFunction_return charLengthFunction() throws RecognitionException {
        HQLParser.charLengthFunction_return retval = new HQLParser.charLengthFunction_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token LEFT_PAREN395=null;
        Token RIGHT_PAREN397=null;
        HQLParser.character_length_key_return character_length_key394 =null;

        HQLParser.concatenation_return concatenation396 =null;


        Object LEFT_PAREN395_tree=null;
        Object RIGHT_PAREN397_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:834:2: ( character_length_key ^ LEFT_PAREN ! concatenation RIGHT_PAREN !)
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:834:4: character_length_key ^ LEFT_PAREN ! concatenation RIGHT_PAREN !
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_character_length_key_in_charLengthFunction3477);
            character_length_key394=character_length_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(character_length_key394.getTree(), root_0);

            LEFT_PAREN395=(Token)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_charLengthFunction3480); if (state.failed) return retval;

            pushFollow(FOLLOW_concatenation_in_charLengthFunction3483);
            concatenation396=concatenation();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, concatenation396.getTree());

            RIGHT_PAREN397=(Token)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_charLengthFunction3485); if (state.failed) return retval;

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "charLengthFunction"


    public static class octetLengthFunction_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "octetLengthFunction"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:837:1: octetLengthFunction : octet_length_key ^ LEFT_PAREN ! concatenation RIGHT_PAREN !;
    public final HQLParser.octetLengthFunction_return octetLengthFunction() throws RecognitionException {
        HQLParser.octetLengthFunction_return retval = new HQLParser.octetLengthFunction_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token LEFT_PAREN399=null;
        Token RIGHT_PAREN401=null;
        HQLParser.octet_length_key_return octet_length_key398 =null;

        HQLParser.concatenation_return concatenation400 =null;


        Object LEFT_PAREN399_tree=null;
        Object RIGHT_PAREN401_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:838:2: ( octet_length_key ^ LEFT_PAREN ! concatenation RIGHT_PAREN !)
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:838:4: octet_length_key ^ LEFT_PAREN ! concatenation RIGHT_PAREN !
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_octet_length_key_in_octetLengthFunction3497);
            octet_length_key398=octet_length_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(octet_length_key398.getTree(), root_0);

            LEFT_PAREN399=(Token)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_octetLengthFunction3500); if (state.failed) return retval;

            pushFollow(FOLLOW_concatenation_in_octetLengthFunction3503);
            concatenation400=concatenation();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, concatenation400.getTree());

            RIGHT_PAREN401=(Token)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_octetLengthFunction3505); if (state.failed) return retval;

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "octetLengthFunction"


    public static class bitLengthFunction_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "bitLengthFunction"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:841:1: bitLengthFunction : bit_length_key ^ LEFT_PAREN ! concatenation RIGHT_PAREN !;
    public final HQLParser.bitLengthFunction_return bitLengthFunction() throws RecognitionException {
        HQLParser.bitLengthFunction_return retval = new HQLParser.bitLengthFunction_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token LEFT_PAREN403=null;
        Token RIGHT_PAREN405=null;
        HQLParser.bit_length_key_return bit_length_key402 =null;

        HQLParser.concatenation_return concatenation404 =null;


        Object LEFT_PAREN403_tree=null;
        Object RIGHT_PAREN405_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:842:2: ( bit_length_key ^ LEFT_PAREN ! concatenation RIGHT_PAREN !)
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:842:4: bit_length_key ^ LEFT_PAREN ! concatenation RIGHT_PAREN !
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_bit_length_key_in_bitLengthFunction3517);
            bit_length_key402=bit_length_key();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(bit_length_key402.getTree(), root_0);

            LEFT_PAREN403=(Token)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_bitLengthFunction3520); if (state.failed) return retval;

            pushFollow(FOLLOW_concatenation_in_bitLengthFunction3523);
            concatenation404=concatenation();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, concatenation404.getTree());

            RIGHT_PAREN405=(Token)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_bitLengthFunction3525); if (state.failed) return retval;

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "bitLengthFunction"


    public static class setFunction_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "setFunction"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:845:1: setFunction : ( ( sum_key ^| avg_key ^| max_key ^| min_key ^) LEFT_PAREN ! additiveExpression RIGHT_PAREN !| count_key LEFT_PAREN ( ASTERISK | ( ( ( distinct_key | all_key ) )? countFunctionArguments ) ) RIGHT_PAREN -> {generateOmmitedElement}? ^( count_key ( ASTERISK )? ALL ( countFunctionArguments )? ) -> ^( count_key ( ASTERISK )? ( distinct_key )? ( all_key )? ( countFunctionArguments )? ) );
    public final HQLParser.setFunction_return setFunction() throws RecognitionException {
        HQLParser.setFunction_return retval = new HQLParser.setFunction_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token LEFT_PAREN410=null;
        Token RIGHT_PAREN412=null;
        Token LEFT_PAREN414=null;
        Token ASTERISK415=null;
        Token RIGHT_PAREN419=null;
        HQLParser.sum_key_return sum_key406 =null;

        HQLParser.avg_key_return avg_key407 =null;

        HQLParser.max_key_return max_key408 =null;

        HQLParser.min_key_return min_key409 =null;

        HQLParser.additiveExpression_return additiveExpression411 =null;

        HQLParser.count_key_return count_key413 =null;

        HQLParser.distinct_key_return distinct_key416 =null;

        HQLParser.all_key_return all_key417 =null;

        HQLParser.countFunctionArguments_return countFunctionArguments418 =null;


        Object LEFT_PAREN410_tree=null;
        Object RIGHT_PAREN412_tree=null;
        Object LEFT_PAREN414_tree=null;
        Object ASTERISK415_tree=null;
        Object RIGHT_PAREN419_tree=null;
        RewriteRuleTokenStream stream_LEFT_PAREN=new RewriteRuleTokenStream(adaptor,"token LEFT_PAREN");
        RewriteRuleTokenStream stream_RIGHT_PAREN=new RewriteRuleTokenStream(adaptor,"token RIGHT_PAREN");
        RewriteRuleTokenStream stream_ASTERISK=new RewriteRuleTokenStream(adaptor,"token ASTERISK");
        RewriteRuleSubtreeStream stream_all_key=new RewriteRuleSubtreeStream(adaptor,"rule all_key");
        RewriteRuleSubtreeStream stream_countFunctionArguments=new RewriteRuleSubtreeStream(adaptor,"rule countFunctionArguments");
        RewriteRuleSubtreeStream stream_distinct_key=new RewriteRuleSubtreeStream(adaptor,"rule distinct_key");
        RewriteRuleSubtreeStream stream_count_key=new RewriteRuleSubtreeStream(adaptor,"rule count_key");
         boolean generateOmmitedElement = true; if (state.backtracking == 0) enableParameterUsage.push(Boolean.TRUE); 
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:848:2: ( ( sum_key ^| avg_key ^| max_key ^| min_key ^) LEFT_PAREN ! additiveExpression RIGHT_PAREN !| count_key LEFT_PAREN ( ASTERISK | ( ( ( distinct_key | all_key ) )? countFunctionArguments ) ) RIGHT_PAREN -> {generateOmmitedElement}? ^( count_key ( ASTERISK )? ALL ( countFunctionArguments )? ) -> ^( count_key ( ASTERISK )? ( distinct_key )? ( all_key )? ( countFunctionArguments )? ) )
            int alt97=2;
            int LA97_0 = input.LA(1);

            if ( (LA97_0==IDENTIFIER) && ((((validateSoftKeyword("min")))||((validateSoftKeyword("max")))||((validateSoftKeyword("sum")))||((validateSoftKeyword("count")))||((validateSoftKeyword("avg")))))) {
                int LA97_1 = input.LA(2);

                if ( ((((validateSoftKeyword("min")))||((validateSoftKeyword("max")))||((validateSoftKeyword("sum")))||((validateSoftKeyword("avg"))))) ) {
                    alt97=1;
                }
                else if ( (((validateSoftKeyword("count")))) ) {
                    alt97=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 97, 1, input);

                    throw nvae;

                }
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 97, 0, input);

                throw nvae;

            }
            switch (alt97) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:848:4: ( sum_key ^| avg_key ^| max_key ^| min_key ^) LEFT_PAREN ! additiveExpression RIGHT_PAREN !
                    {
                    root_0 = (Object)adaptor.nil();


                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:848:4: ( sum_key ^| avg_key ^| max_key ^| min_key ^)
                    int alt93=4;
                    int LA93_0 = input.LA(1);

                    if ( (LA93_0==IDENTIFIER) && ((((validateSoftKeyword("min")))||((validateSoftKeyword("max")))||((validateSoftKeyword("sum")))||((validateSoftKeyword("avg")))))) {
                        int LA93_1 = input.LA(2);

                        if ( (((validateSoftKeyword("sum")))) ) {
                            alt93=1;
                        }
                        else if ( (((validateSoftKeyword("avg")))) ) {
                            alt93=2;
                        }
                        else if ( (((validateSoftKeyword("max")))) ) {
                            alt93=3;
                        }
                        else if ( (((validateSoftKeyword("min")))) ) {
                            alt93=4;
                        }
                        else {
                            if (state.backtracking>0) {state.failed=true; return retval;}
                            NoViableAltException nvae =
                                new NoViableAltException("", 93, 1, input);

                            throw nvae;

                        }
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 93, 0, input);

                        throw nvae;

                    }
                    switch (alt93) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:848:6: sum_key ^
                            {
                            pushFollow(FOLLOW_sum_key_in_setFunction3549);
                            sum_key406=sum_key();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(sum_key406.getTree(), root_0);

                            }
                            break;
                        case 2 :
                            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:848:17: avg_key ^
                            {
                            pushFollow(FOLLOW_avg_key_in_setFunction3554);
                            avg_key407=avg_key();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(avg_key407.getTree(), root_0);

                            }
                            break;
                        case 3 :
                            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:848:28: max_key ^
                            {
                            pushFollow(FOLLOW_max_key_in_setFunction3559);
                            max_key408=max_key();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(max_key408.getTree(), root_0);

                            }
                            break;
                        case 4 :
                            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:848:39: min_key ^
                            {
                            pushFollow(FOLLOW_min_key_in_setFunction3564);
                            min_key409=min_key();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(min_key409.getTree(), root_0);

                            }
                            break;

                    }


                    LEFT_PAREN410=(Token)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_setFunction3569); if (state.failed) return retval;

                    pushFollow(FOLLOW_additiveExpression_in_setFunction3572);
                    additiveExpression411=additiveExpression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, additiveExpression411.getTree());

                    RIGHT_PAREN412=(Token)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_setFunction3574); if (state.failed) return retval;

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:849:4: count_key LEFT_PAREN ( ASTERISK | ( ( ( distinct_key | all_key ) )? countFunctionArguments ) ) RIGHT_PAREN
                    {
                    pushFollow(FOLLOW_count_key_in_setFunction3580);
                    count_key413=count_key();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_count_key.add(count_key413.getTree());

                    LEFT_PAREN414=(Token)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_setFunction3582); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_LEFT_PAREN.add(LEFT_PAREN414);


                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:849:25: ( ASTERISK | ( ( ( distinct_key | all_key ) )? countFunctionArguments ) )
                    int alt96=2;
                    int LA96_0 = input.LA(1);

                    if ( (LA96_0==ASTERISK) ) {
                        alt96=1;
                    }
                    else if ( (LA96_0==DECIMAL_LITERAL||LA96_0==FLOATING_POINT_LITERAL||LA96_0==IDENTIFIER||LA96_0==INTEGER_LITERAL) ) {
                        alt96=2;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 96, 0, input);

                        throw nvae;

                    }
                    switch (alt96) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:849:27: ASTERISK
                            {
                            ASTERISK415=(Token)match(input,ASTERISK,FOLLOW_ASTERISK_in_setFunction3586); if (state.failed) return retval; 
                            if ( state.backtracking==0 ) stream_ASTERISK.add(ASTERISK415);


                            if ( state.backtracking==0 ) {generateOmmitedElement = false;}

                            }
                            break;
                        case 2 :
                            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:849:72: ( ( ( distinct_key | all_key ) )? countFunctionArguments )
                            {
                            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:849:72: ( ( ( distinct_key | all_key ) )? countFunctionArguments )
                            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:849:74: ( ( distinct_key | all_key ) )? countFunctionArguments
                            {
                            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:849:74: ( ( distinct_key | all_key ) )?
                            int alt95=2;
                            int LA95_0 = input.LA(1);

                            if ( (LA95_0==IDENTIFIER) ) {
                                int LA95_1 = input.LA(2);

                                if ( (LA95_1==DECIMAL_LITERAL||LA95_1==FLOATING_POINT_LITERAL||LA95_1==IDENTIFIER||LA95_1==INTEGER_LITERAL) && ((((validateSoftKeyword("distinct")))||((validateSoftKeyword("all")))))) {
                                    alt95=1;
                                }
                            }
                            switch (alt95) {
                                case 1 :
                                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:849:76: ( distinct_key | all_key )
                                    {
                                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:849:76: ( distinct_key | all_key )
                                    int alt94=2;
                                    int LA94_0 = input.LA(1);

                                    if ( (LA94_0==IDENTIFIER) && ((((validateSoftKeyword("distinct")))||((validateSoftKeyword("all")))))) {
                                        int LA94_1 = input.LA(2);

                                        if ( (((validateSoftKeyword("distinct")))) ) {
                                            alt94=1;
                                        }
                                        else if ( (((validateSoftKeyword("all")))) ) {
                                            alt94=2;
                                        }
                                        else {
                                            if (state.backtracking>0) {state.failed=true; return retval;}
                                            NoViableAltException nvae =
                                                new NoViableAltException("", 94, 1, input);

                                            throw nvae;

                                        }
                                    }
                                    else {
                                        if (state.backtracking>0) {state.failed=true; return retval;}
                                        NoViableAltException nvae =
                                            new NoViableAltException("", 94, 0, input);

                                        throw nvae;

                                    }
                                    switch (alt94) {
                                        case 1 :
                                            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:849:77: distinct_key
                                            {
                                            pushFollow(FOLLOW_distinct_key_in_setFunction3597);
                                            distinct_key416=distinct_key();

                                            state._fsp--;
                                            if (state.failed) return retval;
                                            if ( state.backtracking==0 ) stream_distinct_key.add(distinct_key416.getTree());

                                            }
                                            break;
                                        case 2 :
                                            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:849:92: all_key
                                            {
                                            pushFollow(FOLLOW_all_key_in_setFunction3601);
                                            all_key417=all_key();

                                            state._fsp--;
                                            if (state.failed) return retval;
                                            if ( state.backtracking==0 ) stream_all_key.add(all_key417.getTree());

                                            }
                                            break;

                                    }


                                    if ( state.backtracking==0 ) {generateOmmitedElement = false;}

                                    }
                                    break;

                            }


                            pushFollow(FOLLOW_countFunctionArguments_in_setFunction3609);
                            countFunctionArguments418=countFunctionArguments();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_countFunctionArguments.add(countFunctionArguments418.getTree());

                            }


                            }
                            break;

                    }


                    RIGHT_PAREN419=(Token)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_setFunction3615); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_RIGHT_PAREN.add(RIGHT_PAREN419);


                    // AST REWRITE
                    // elements: countFunctionArguments, distinct_key, ASTERISK, countFunctionArguments, all_key, ASTERISK, count_key, count_key
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (Object)adaptor.nil();
                    // 850:3: -> {generateOmmitedElement}? ^( count_key ( ASTERISK )? ALL ( countFunctionArguments )? )
                    if (generateOmmitedElement) {
                        // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:850:32: ^( count_key ( ASTERISK )? ALL ( countFunctionArguments )? )
                        {
                        Object root_1 = (Object)adaptor.nil();
                        root_1 = (Object)adaptor.becomeRoot(stream_count_key.nextNode(), root_1);

                        // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:850:44: ( ASTERISK )?
                        if ( stream_ASTERISK.hasNext() ) {
                            adaptor.addChild(root_1, 
                            stream_ASTERISK.nextNode()
                            );

                        }
                        stream_ASTERISK.reset();

                        adaptor.addChild(root_1, 
                        (Object)adaptor.create(ALL, "ALL")
                        );

                        // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:850:58: ( countFunctionArguments )?
                        if ( stream_countFunctionArguments.hasNext() ) {
                            adaptor.addChild(root_1, stream_countFunctionArguments.nextTree());

                        }
                        stream_countFunctionArguments.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }

                    else // 851:3: -> ^( count_key ( ASTERISK )? ( distinct_key )? ( all_key )? ( countFunctionArguments )? )
                    {
                        // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:851:6: ^( count_key ( ASTERISK )? ( distinct_key )? ( all_key )? ( countFunctionArguments )? )
                        {
                        Object root_1 = (Object)adaptor.nil();
                        root_1 = (Object)adaptor.becomeRoot(stream_count_key.nextNode(), root_1);

                        // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:851:18: ( ASTERISK )?
                        if ( stream_ASTERISK.hasNext() ) {
                            adaptor.addChild(root_1, 
                            stream_ASTERISK.nextNode()
                            );

                        }
                        stream_ASTERISK.reset();

                        // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:851:28: ( distinct_key )?
                        if ( stream_distinct_key.hasNext() ) {
                            adaptor.addChild(root_1, stream_distinct_key.nextTree());

                        }
                        stream_distinct_key.reset();

                        // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:851:42: ( all_key )?
                        if ( stream_all_key.hasNext() ) {
                            adaptor.addChild(root_1, stream_all_key.nextTree());

                        }
                        stream_all_key.reset();

                        // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:851:51: ( countFunctionArguments )?
                        if ( stream_countFunctionArguments.hasNext() ) {
                            adaptor.addChild(root_1, stream_countFunctionArguments.nextTree());

                        }
                        stream_countFunctionArguments.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { enableParameterUsage.pop(); }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "setFunction"


    public static class countFunctionArguments_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "countFunctionArguments"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:854:1: countFunctionArguments : ( propertyReference | collectionExpression | numeric_literal );
    public final HQLParser.countFunctionArguments_return countFunctionArguments() throws RecognitionException {
        HQLParser.countFunctionArguments_return retval = new HQLParser.countFunctionArguments_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.propertyReference_return propertyReference420 =null;

        HQLParser.collectionExpression_return collectionExpression421 =null;

        HQLParser.numeric_literal_return numeric_literal422 =null;



         int type = -1;
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:856:2: ( propertyReference | collectionExpression | numeric_literal )
            int alt98=3;
            int LA98_0 = input.LA(1);

            if ( (LA98_0==IDENTIFIER) ) {
                int LA98_1 = input.LA(2);

                if ( (LA98_1==DOT||LA98_1==LEFT_SQUARE||LA98_1==RIGHT_PAREN) ) {
                    alt98=1;
                }
                else if ( (LA98_1==LEFT_PAREN) && ((((validateSoftKeyword("elements")))||((validateSoftKeyword("indices")))))) {
                    alt98=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 98, 1, input);

                    throw nvae;

                }
            }
            else if ( (LA98_0==DECIMAL_LITERAL||LA98_0==FLOATING_POINT_LITERAL||LA98_0==INTEGER_LITERAL) ) {
                alt98=3;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 98, 0, input);

                throw nvae;

            }
            switch (alt98) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:856:4: propertyReference
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_propertyReference_in_countFunctionArguments3669);
                    propertyReference420=propertyReference();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, propertyReference420.getTree());

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:857:4: collectionExpression
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_collectionExpression_in_countFunctionArguments3674);
                    collectionExpression421=collectionExpression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, collectionExpression421.getTree());

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:858:4: numeric_literal
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_numeric_literal_in_countFunctionArguments3679);
                    numeric_literal422=numeric_literal();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, numeric_literal422.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "countFunctionArguments"


    public static class collectionFunction_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "collectionFunction"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:861:1: collectionFunction : ( maxelement_key ^| maxindex_key ^| minelement_key ^| minindex_key ^) LEFT_PAREN ! propertyReference RIGHT_PAREN !;
    public final HQLParser.collectionFunction_return collectionFunction() throws RecognitionException {
        HQLParser.collectionFunction_return retval = new HQLParser.collectionFunction_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token LEFT_PAREN427=null;
        Token RIGHT_PAREN429=null;
        HQLParser.maxelement_key_return maxelement_key423 =null;

        HQLParser.maxindex_key_return maxindex_key424 =null;

        HQLParser.minelement_key_return minelement_key425 =null;

        HQLParser.minindex_key_return minindex_key426 =null;

        HQLParser.propertyReference_return propertyReference428 =null;


        Object LEFT_PAREN427_tree=null;
        Object RIGHT_PAREN429_tree=null;

         if (state.backtracking == 0) enableParameterUsage.push(Boolean.TRUE); 
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:864:2: ( ( maxelement_key ^| maxindex_key ^| minelement_key ^| minindex_key ^) LEFT_PAREN ! propertyReference RIGHT_PAREN !)
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:864:4: ( maxelement_key ^| maxindex_key ^| minelement_key ^| minindex_key ^) LEFT_PAREN ! propertyReference RIGHT_PAREN !
            {
            root_0 = (Object)adaptor.nil();


            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:864:4: ( maxelement_key ^| maxindex_key ^| minelement_key ^| minindex_key ^)
            int alt99=4;
            int LA99_0 = input.LA(1);

            if ( (LA99_0==IDENTIFIER) && ((((validateSoftKeyword("maxelement")))||((validateSoftKeyword("minelement")))||((validateSoftKeyword("maxindex")))||((validateSoftKeyword("minindex")))))) {
                int LA99_1 = input.LA(2);

                if ( (((validateSoftKeyword("maxelement")))) ) {
                    alt99=1;
                }
                else if ( (((validateSoftKeyword("maxindex")))) ) {
                    alt99=2;
                }
                else if ( (((validateSoftKeyword("minelement")))) ) {
                    alt99=3;
                }
                else if ( (((validateSoftKeyword("minindex")))) ) {
                    alt99=4;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 99, 1, input);

                    throw nvae;

                }
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 99, 0, input);

                throw nvae;

            }
            switch (alt99) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:864:6: maxelement_key ^
                    {
                    pushFollow(FOLLOW_maxelement_key_in_collectionFunction3702);
                    maxelement_key423=maxelement_key();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(maxelement_key423.getTree(), root_0);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:864:24: maxindex_key ^
                    {
                    pushFollow(FOLLOW_maxindex_key_in_collectionFunction3707);
                    maxindex_key424=maxindex_key();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(maxindex_key424.getTree(), root_0);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:864:40: minelement_key ^
                    {
                    pushFollow(FOLLOW_minelement_key_in_collectionFunction3712);
                    minelement_key425=minelement_key();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(minelement_key425.getTree(), root_0);

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:864:58: minindex_key ^
                    {
                    pushFollow(FOLLOW_minindex_key_in_collectionFunction3717);
                    minindex_key426=minindex_key();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(minindex_key426.getTree(), root_0);

                    }
                    break;

            }


            LEFT_PAREN427=(Token)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_collectionFunction3722); if (state.failed) return retval;

            pushFollow(FOLLOW_propertyReference_in_collectionFunction3725);
            propertyReference428=propertyReference();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, propertyReference428.getTree());

            RIGHT_PAREN429=(Token)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_collectionFunction3727); if (state.failed) return retval;

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { enableParameterUsage.pop(); }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "collectionFunction"


    public static class collectionExpression_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "collectionExpression"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:867:1: collectionExpression : ( elements_key ^| indices_key ^) LEFT_PAREN ! propertyReference RIGHT_PAREN !;
    public final HQLParser.collectionExpression_return collectionExpression() throws RecognitionException {
        HQLParser.collectionExpression_return retval = new HQLParser.collectionExpression_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token LEFT_PAREN432=null;
        Token RIGHT_PAREN434=null;
        HQLParser.elements_key_return elements_key430 =null;

        HQLParser.indices_key_return indices_key431 =null;

        HQLParser.propertyReference_return propertyReference433 =null;


        Object LEFT_PAREN432_tree=null;
        Object RIGHT_PAREN434_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:868:2: ( ( elements_key ^| indices_key ^) LEFT_PAREN ! propertyReference RIGHT_PAREN !)
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:868:4: ( elements_key ^| indices_key ^) LEFT_PAREN ! propertyReference RIGHT_PAREN !
            {
            root_0 = (Object)adaptor.nil();


            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:868:4: ( elements_key ^| indices_key ^)
            int alt100=2;
            int LA100_0 = input.LA(1);

            if ( (LA100_0==IDENTIFIER) && ((((validateSoftKeyword("elements")))||((validateSoftKeyword("indices")))))) {
                int LA100_1 = input.LA(2);

                if ( (((validateSoftKeyword("elements")))) ) {
                    alt100=1;
                }
                else if ( (((validateSoftKeyword("indices")))) ) {
                    alt100=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 100, 1, input);

                    throw nvae;

                }
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 100, 0, input);

                throw nvae;

            }
            switch (alt100) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:868:5: elements_key ^
                    {
                    pushFollow(FOLLOW_elements_key_in_collectionExpression3740);
                    elements_key430=elements_key();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(elements_key430.getTree(), root_0);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:868:19: indices_key ^
                    {
                    pushFollow(FOLLOW_indices_key_in_collectionExpression3743);
                    indices_key431=indices_key();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) root_0 = (Object)adaptor.becomeRoot(indices_key431.getTree(), root_0);

                    }
                    break;

            }


            LEFT_PAREN432=(Token)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_collectionExpression3747); if (state.failed) return retval;

            pushFollow(FOLLOW_propertyReference_in_collectionExpression3750);
            propertyReference433=propertyReference();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, propertyReference433.getTree());

            RIGHT_PAREN434=(Token)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_collectionExpression3752); if (state.failed) return retval;

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "collectionExpression"


    public static class atom_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "atom"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:871:1: atom : ( identPrimary -> {type == 0}? ^( DOT_CLASS identPrimary ) -> {type == 3}? ^( FUNCTION[$identPrimary.start,$identPrimary.text] ) -> {type == 4}? ^( JAVA_CONSTANT identPrimary ) -> ^( PATH identPrimary ) | constant | parameterSpecification | LEFT_PAREN ! ({...}? => subQuery | expressionOrVector ) RIGHT_PAREN !);
    public final HQLParser.atom_return atom() throws RecognitionException {
        HQLParser.atom_return retval = new HQLParser.atom_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token LEFT_PAREN438=null;
        Token RIGHT_PAREN441=null;
        HQLParser.identPrimary_return identPrimary435 =null;

        HQLParser.constant_return constant436 =null;

        HQLParser.parameterSpecification_return parameterSpecification437 =null;

        HQLParser.subQuery_return subQuery439 =null;

        HQLParser.expressionOrVector_return expressionOrVector440 =null;


        Object LEFT_PAREN438_tree=null;
        Object RIGHT_PAREN441_tree=null;
        RewriteRuleSubtreeStream stream_identPrimary=new RewriteRuleSubtreeStream(adaptor,"rule identPrimary");
         int type = -1;
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:873:2: ( identPrimary -> {type == 0}? ^( DOT_CLASS identPrimary ) -> {type == 3}? ^( FUNCTION[$identPrimary.start,$identPrimary.text] ) -> {type == 4}? ^( JAVA_CONSTANT identPrimary ) -> ^( PATH identPrimary ) | constant | parameterSpecification | LEFT_PAREN ! ({...}? => subQuery | expressionOrVector ) RIGHT_PAREN !)
            int alt102=4;
            switch ( input.LA(1) ) {
            case IDENTIFIER:
                {
                alt102=1;
                }
                break;
            case CHARACTER_LITERAL:
            case DECIMAL_LITERAL:
            case FALSE:
            case FLOATING_POINT_LITERAL:
            case HEX_LITERAL:
            case INTEGER_LITERAL:
            case NULL:
            case OCTAL_LITERAL:
            case STRING_LITERAL:
            case TRUE:
                {
                alt102=2;
                }
                break;
            case COLON:
            case PARAM:
                {
                alt102=3;
                }
                break;
            case LEFT_PAREN:
                {
                alt102=4;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 102, 0, input);

                throw nvae;

            }

            switch (alt102) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:873:4: identPrimary
                    {
                    pushFollow(FOLLOW_identPrimary_in_atom3769);
                    identPrimary435=identPrimary();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_identPrimary.add(identPrimary435.getTree());

                    // AST REWRITE
                    // elements: identPrimary, identPrimary, identPrimary
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (Object)adaptor.nil();
                    // 879:6: -> {type == 0}? ^( DOT_CLASS identPrimary )
                    if (type == 0) {
                        // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:879:22: ^( DOT_CLASS identPrimary )
                        {
                        Object root_1 = (Object)adaptor.nil();
                        root_1 = (Object)adaptor.becomeRoot(
                        (Object)adaptor.create(DOT_CLASS, "DOT_CLASS")
                        , root_1);

                        adaptor.addChild(root_1, stream_identPrimary.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }

                    else // 880:6: -> {type == 3}? ^( FUNCTION[$identPrimary.start,$identPrimary.text] )
                    if (type == 3) {
                        // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:880:22: ^( FUNCTION[$identPrimary.start,$identPrimary.text] )
                        {
                        Object root_1 = (Object)adaptor.nil();
                        root_1 = (Object)adaptor.becomeRoot(
                        (Object)adaptor.create(FUNCTION, (identPrimary435!=null?((Token)identPrimary435.start):null), (identPrimary435!=null?input.toString(identPrimary435.start,identPrimary435.stop):null))
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }

                    else // 881:6: -> {type == 4}? ^( JAVA_CONSTANT identPrimary )
                    if (type == 4) {
                        // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:881:22: ^( JAVA_CONSTANT identPrimary )
                        {
                        Object root_1 = (Object)adaptor.nil();
                        root_1 = (Object)adaptor.becomeRoot(
                        (Object)adaptor.create(JAVA_CONSTANT, "JAVA_CONSTANT")
                        , root_1);

                        adaptor.addChild(root_1, stream_identPrimary.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }

                    else // 882:6: -> ^( PATH identPrimary )
                    {
                        // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:882:9: ^( PATH identPrimary )
                        {
                        Object root_1 = (Object)adaptor.nil();
                        root_1 = (Object)adaptor.becomeRoot(
                        (Object)adaptor.create(PATH, "PATH")
                        , root_1);

                        adaptor.addChild(root_1, stream_identPrimary.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:883:4: constant
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_constant_in_atom3862);
                    constant436=constant();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, constant436.getTree());

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:884:4: parameterSpecification
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_parameterSpecification_in_atom3867);
                    parameterSpecification437=parameterSpecification();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, parameterSpecification437.getTree());

                    if ( state.backtracking==0 ) { if (enableParameterUsage.peek().equals(Boolean.FALSE)) throw new RecognitionException( ); }

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:886:4: LEFT_PAREN ! ({...}? => subQuery | expressionOrVector ) RIGHT_PAREN !
                    {
                    root_0 = (Object)adaptor.nil();


                    LEFT_PAREN438=(Token)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_atom3876); if (state.failed) return retval;

                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:886:16: ({...}? => subQuery | expressionOrVector )
                    int alt101=2;
                    int LA101_0 = input.LA(1);

                    if ( (LA101_0==IDENTIFIER) ) {
                        int LA101_1 = input.LA(2);

                        if ( ((((((validateSoftKeyword("select")|validateSoftKeyword("from"))))&&(((validateSoftKeyword("select")|validateSoftKeyword("from")))))&&(((validateSoftKeyword("select")))||((validateSoftKeyword("from")))))) ) {
                            alt101=1;
                        }
                        else if ( (true) ) {
                            alt101=2;
                        }
                        else {
                            if (state.backtracking>0) {state.failed=true; return retval;}
                            NoViableAltException nvae =
                                new NoViableAltException("", 101, 1, input);

                            throw nvae;

                        }
                    }
                    else if ( (LA101_0==CHARACTER_LITERAL||LA101_0==COLON||LA101_0==DECIMAL_LITERAL||LA101_0==FALSE||LA101_0==FLOATING_POINT_LITERAL||LA101_0==HEX_LITERAL||LA101_0==INTEGER_LITERAL||LA101_0==LEFT_PAREN||LA101_0==MINUS||LA101_0==NULL||LA101_0==OCTAL_LITERAL||LA101_0==PARAM||LA101_0==PLUS||LA101_0==STRING_LITERAL||LA101_0==TRUE) ) {
                        alt101=2;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 101, 0, input);

                        throw nvae;

                    }
                    switch (alt101) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:886:17: {...}? => subQuery
                            {
                            if ( !((((validateSoftKeyword("select")|validateSoftKeyword("from"))))) ) {
                                if (state.backtracking>0) {state.failed=true; return retval;}
                                throw new FailedPredicateException(input, "atom", "((validateSoftKeyword(\"select\")|validateSoftKeyword(\"from\")))");
                            }

                            pushFollow(FOLLOW_subQuery_in_atom3883);
                            subQuery439=subQuery();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) adaptor.addChild(root_0, subQuery439.getTree());

                            }
                            break;
                        case 2 :
                            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:886:93: expressionOrVector
                            {
                            pushFollow(FOLLOW_expressionOrVector_in_atom3885);
                            expressionOrVector440=expressionOrVector();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) adaptor.addChild(root_0, expressionOrVector440.getTree());

                            }
                            break;

                    }


                    RIGHT_PAREN441=(Token)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_atom3888); if (state.failed) return retval;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "atom"


    public static class parameterSpecification_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "parameterSpecification"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:889:1: parameterSpecification : ( COLON IDENTIFIER -> NAMED_PARAM[$IDENTIFIER] | PARAM ( INTEGER_LITERAL )? -> {isJpaParam}? JPA_PARAM[$INTEGER_LITERAL] -> PARAM );
    public final HQLParser.parameterSpecification_return parameterSpecification() throws RecognitionException {
        HQLParser.parameterSpecification_return retval = new HQLParser.parameterSpecification_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token COLON442=null;
        Token IDENTIFIER443=null;
        Token PARAM444=null;
        Token INTEGER_LITERAL445=null;

        Object COLON442_tree=null;
        Object IDENTIFIER443_tree=null;
        Object PARAM444_tree=null;
        Object INTEGER_LITERAL445_tree=null;
        RewriteRuleTokenStream stream_COLON=new RewriteRuleTokenStream(adaptor,"token COLON");
        RewriteRuleTokenStream stream_PARAM=new RewriteRuleTokenStream(adaptor,"token PARAM");
        RewriteRuleTokenStream stream_INTEGER_LITERAL=new RewriteRuleTokenStream(adaptor,"token INTEGER_LITERAL");
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        boolean isJpaParam = false;
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:891:2: ( COLON IDENTIFIER -> NAMED_PARAM[$IDENTIFIER] | PARAM ( INTEGER_LITERAL )? -> {isJpaParam}? JPA_PARAM[$INTEGER_LITERAL] -> PARAM )
            int alt104=2;
            int LA104_0 = input.LA(1);

            if ( (LA104_0==COLON) ) {
                alt104=1;
            }
            else if ( (LA104_0==PARAM) ) {
                alt104=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 104, 0, input);

                throw nvae;

            }
            switch (alt104) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:891:4: COLON IDENTIFIER
                    {
                    COLON442=(Token)match(input,COLON,FOLLOW_COLON_in_parameterSpecification3905); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_COLON.add(COLON442);


                    IDENTIFIER443=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_parameterSpecification3907); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_IDENTIFIER.add(IDENTIFIER443);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (Object)adaptor.nil();
                    // 891:21: -> NAMED_PARAM[$IDENTIFIER]
                    {
                        adaptor.addChild(root_0, 
                        (Object)adaptor.create(NAMED_PARAM, IDENTIFIER443)
                        );

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:892:4: PARAM ( INTEGER_LITERAL )?
                    {
                    PARAM444=(Token)match(input,PARAM,FOLLOW_PARAM_in_parameterSpecification3917); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_PARAM.add(PARAM444);


                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:892:10: ( INTEGER_LITERAL )?
                    int alt103=2;
                    int LA103_0 = input.LA(1);

                    if ( (LA103_0==INTEGER_LITERAL) ) {
                        alt103=1;
                    }
                    switch (alt103) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:892:11: INTEGER_LITERAL
                            {
                            INTEGER_LITERAL445=(Token)match(input,INTEGER_LITERAL,FOLLOW_INTEGER_LITERAL_in_parameterSpecification3920); if (state.failed) return retval; 
                            if ( state.backtracking==0 ) stream_INTEGER_LITERAL.add(INTEGER_LITERAL445);


                            if ( state.backtracking==0 ) {isJpaParam = true;}

                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: PARAM
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (Object)adaptor.nil();
                    // 893:3: -> {isJpaParam}? JPA_PARAM[$INTEGER_LITERAL]
                    if (isJpaParam) {
                        adaptor.addChild(root_0, 
                        (Object)adaptor.create(JPA_PARAM, INTEGER_LITERAL445)
                        );

                    }

                    else // 894:3: -> PARAM
                    {
                        adaptor.addChild(root_0, 
                        stream_PARAM.nextNode()
                        );

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "parameterSpecification"


    public static class expressionOrVector_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "expressionOrVector"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:897:1: expressionOrVector : expression ( vectorExpr )? -> {isVectorExp}? ^( VECTOR_EXPR expression vectorExpr ) -> expression ;
    public final HQLParser.expressionOrVector_return expressionOrVector() throws RecognitionException {
        HQLParser.expressionOrVector_return retval = new HQLParser.expressionOrVector_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.expression_return expression446 =null;

        HQLParser.vectorExpr_return vectorExpr447 =null;


        RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");
        RewriteRuleSubtreeStream stream_vectorExpr=new RewriteRuleSubtreeStream(adaptor,"rule vectorExpr");
        boolean isVectorExp = false;
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:899:2: ( expression ( vectorExpr )? -> {isVectorExp}? ^( VECTOR_EXPR expression vectorExpr ) -> expression )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:899:4: expression ( vectorExpr )?
            {
            pushFollow(FOLLOW_expression_in_expressionOrVector3955);
            expression446=expression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_expression.add(expression446.getTree());

            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:899:15: ( vectorExpr )?
            int alt105=2;
            int LA105_0 = input.LA(1);

            if ( (LA105_0==COMMA) ) {
                alt105=1;
            }
            switch (alt105) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:899:16: vectorExpr
                    {
                    pushFollow(FOLLOW_vectorExpr_in_expressionOrVector3958);
                    vectorExpr447=vectorExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_vectorExpr.add(vectorExpr447.getTree());

                    if ( state.backtracking==0 ) {isVectorExp = true;}

                    }
                    break;

            }


            // AST REWRITE
            // elements: vectorExpr, expression, expression
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 900:3: -> {isVectorExp}? ^( VECTOR_EXPR expression vectorExpr )
            if (isVectorExp) {
                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:900:21: ^( VECTOR_EXPR expression vectorExpr )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(VECTOR_EXPR, "VECTOR_EXPR")
                , root_1);

                adaptor.addChild(root_1, stream_expression.nextTree());

                adaptor.addChild(root_1, stream_vectorExpr.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }

            else // 901:3: -> expression
            {
                adaptor.addChild(root_0, stream_expression.nextTree());

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "expressionOrVector"


    public static class vectorExpr_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "vectorExpr"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:904:1: vectorExpr : COMMA ! expression ( COMMA ! expression )* ;
    public final HQLParser.vectorExpr_return vectorExpr() throws RecognitionException {
        HQLParser.vectorExpr_return retval = new HQLParser.vectorExpr_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token COMMA448=null;
        Token COMMA450=null;
        HQLParser.expression_return expression449 =null;

        HQLParser.expression_return expression451 =null;


        Object COMMA448_tree=null;
        Object COMMA450_tree=null;

         if (state.backtracking == 0) enableParameterUsage.push(Boolean.TRUE); 
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:907:2: ( COMMA ! expression ( COMMA ! expression )* )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:907:4: COMMA ! expression ( COMMA ! expression )*
            {
            root_0 = (Object)adaptor.nil();


            COMMA448=(Token)match(input,COMMA,FOLLOW_COMMA_in_vectorExpr4003); if (state.failed) return retval;

            pushFollow(FOLLOW_expression_in_vectorExpr4006);
            expression449=expression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, expression449.getTree());

            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:907:22: ( COMMA ! expression )*
            loop106:
            do {
                int alt106=2;
                int LA106_0 = input.LA(1);

                if ( (LA106_0==COMMA) ) {
                    alt106=1;
                }


                switch (alt106) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:907:23: COMMA ! expression
            	    {
            	    COMMA450=(Token)match(input,COMMA,FOLLOW_COMMA_in_vectorExpr4009); if (state.failed) return retval;

            	    pushFollow(FOLLOW_expression_in_vectorExpr4012);
            	    expression451=expression();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) adaptor.addChild(root_0, expression451.getTree());

            	    }
            	    break;

            	default :
            	    break loop106;
                }
            } while (true);


            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { enableParameterUsage.pop(); }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "vectorExpr"


    public static class identPrimary_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "identPrimary"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:910:1: identPrimary : IDENTIFIER ( DOT ^ IDENTIFIER | LEFT_SQUARE ^ expression RIGHT_SQUARE !| LEFT_SQUARE ^ RIGHT_SQUARE !| LEFT_PAREN ^ exprList RIGHT_PAREN !)* ;
    public final HQLParser.identPrimary_return identPrimary() throws RecognitionException {
        HQLParser.identPrimary_return retval = new HQLParser.identPrimary_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token IDENTIFIER452=null;
        Token DOT453=null;
        Token IDENTIFIER454=null;
        Token LEFT_SQUARE455=null;
        Token RIGHT_SQUARE457=null;
        Token LEFT_SQUARE458=null;
        Token RIGHT_SQUARE459=null;
        Token LEFT_PAREN460=null;
        Token RIGHT_PAREN462=null;
        HQLParser.expression_return expression456 =null;

        HQLParser.exprList_return exprList461 =null;


        Object IDENTIFIER452_tree=null;
        Object DOT453_tree=null;
        Object IDENTIFIER454_tree=null;
        Object LEFT_SQUARE455_tree=null;
        Object RIGHT_SQUARE457_tree=null;
        Object LEFT_SQUARE458_tree=null;
        Object RIGHT_SQUARE459_tree=null;
        Object LEFT_PAREN460_tree=null;
        Object RIGHT_PAREN462_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:911:2: ( IDENTIFIER ( DOT ^ IDENTIFIER | LEFT_SQUARE ^ expression RIGHT_SQUARE !| LEFT_SQUARE ^ RIGHT_SQUARE !| LEFT_PAREN ^ exprList RIGHT_PAREN !)* )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:911:5: IDENTIFIER ( DOT ^ IDENTIFIER | LEFT_SQUARE ^ expression RIGHT_SQUARE !| LEFT_SQUARE ^ RIGHT_SQUARE !| LEFT_PAREN ^ exprList RIGHT_PAREN !)*
            {
            root_0 = (Object)adaptor.nil();


            IDENTIFIER452=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_identPrimary4026); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            IDENTIFIER452_tree = 
            (Object)adaptor.create(IDENTIFIER452)
            ;
            adaptor.addChild(root_0, IDENTIFIER452_tree);
            }

            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:912:3: ( DOT ^ IDENTIFIER | LEFT_SQUARE ^ expression RIGHT_SQUARE !| LEFT_SQUARE ^ RIGHT_SQUARE !| LEFT_PAREN ^ exprList RIGHT_PAREN !)*
            loop107:
            do {
                int alt107=5;
                switch ( input.LA(1) ) {
                case DOT:
                    {
                    alt107=1;
                    }
                    break;
                case LEFT_SQUARE:
                    {
                    int LA107_3 = input.LA(2);

                    if ( (LA107_3==RIGHT_SQUARE) ) {
                        alt107=3;
                    }
                    else if ( (LA107_3==CHARACTER_LITERAL||LA107_3==COLON||LA107_3==DECIMAL_LITERAL||LA107_3==FALSE||LA107_3==FLOATING_POINT_LITERAL||LA107_3==HEX_LITERAL||LA107_3==IDENTIFIER||LA107_3==INTEGER_LITERAL||LA107_3==LEFT_PAREN||LA107_3==MINUS||LA107_3==NULL||LA107_3==OCTAL_LITERAL||LA107_3==PARAM||LA107_3==PLUS||LA107_3==STRING_LITERAL||LA107_3==TRUE) ) {
                        alt107=2;
                    }


                    }
                    break;
                case LEFT_PAREN:
                    {
                    alt107=4;
                    }
                    break;

                }

                switch (alt107) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:912:5: DOT ^ IDENTIFIER
            	    {
            	    DOT453=(Token)match(input,DOT,FOLLOW_DOT_in_identPrimary4032); if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {
            	    DOT453_tree = 
            	    (Object)adaptor.create(DOT453)
            	    ;
            	    root_0 = (Object)adaptor.becomeRoot(DOT453_tree, root_0);
            	    }

            	    IDENTIFIER454=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_identPrimary4035); if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {
            	    IDENTIFIER454_tree = 
            	    (Object)adaptor.create(IDENTIFIER454)
            	    ;
            	    adaptor.addChild(root_0, IDENTIFIER454_tree);
            	    }

            	    }
            	    break;
            	case 2 :
            	    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:913:5: LEFT_SQUARE ^ expression RIGHT_SQUARE !
            	    {
            	    LEFT_SQUARE455=(Token)match(input,LEFT_SQUARE,FOLLOW_LEFT_SQUARE_in_identPrimary4041); if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {
            	    LEFT_SQUARE455_tree = 
            	    (Object)adaptor.create(LEFT_SQUARE455)
            	    ;
            	    root_0 = (Object)adaptor.becomeRoot(LEFT_SQUARE455_tree, root_0);
            	    }

            	    pushFollow(FOLLOW_expression_in_identPrimary4044);
            	    expression456=expression();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) adaptor.addChild(root_0, expression456.getTree());

            	    RIGHT_SQUARE457=(Token)match(input,RIGHT_SQUARE,FOLLOW_RIGHT_SQUARE_in_identPrimary4046); if (state.failed) return retval;

            	    }
            	    break;
            	case 3 :
            	    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:914:5: LEFT_SQUARE ^ RIGHT_SQUARE !
            	    {
            	    LEFT_SQUARE458=(Token)match(input,LEFT_SQUARE,FOLLOW_LEFT_SQUARE_in_identPrimary4053); if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {
            	    LEFT_SQUARE458_tree = 
            	    (Object)adaptor.create(LEFT_SQUARE458)
            	    ;
            	    root_0 = (Object)adaptor.becomeRoot(LEFT_SQUARE458_tree, root_0);
            	    }

            	    RIGHT_SQUARE459=(Token)match(input,RIGHT_SQUARE,FOLLOW_RIGHT_SQUARE_in_identPrimary4056); if (state.failed) return retval;

            	    }
            	    break;
            	case 4 :
            	    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:915:5: LEFT_PAREN ^ exprList RIGHT_PAREN !
            	    {
            	    LEFT_PAREN460=(Token)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_identPrimary4063); if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {
            	    LEFT_PAREN460_tree = 
            	    (Object)adaptor.create(LEFT_PAREN460)
            	    ;
            	    root_0 = (Object)adaptor.becomeRoot(LEFT_PAREN460_tree, root_0);
            	    }

            	    pushFollow(FOLLOW_exprList_in_identPrimary4066);
            	    exprList461=exprList();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) adaptor.addChild(root_0, exprList461.getTree());

            	    RIGHT_PAREN462=(Token)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_identPrimary4068); if (state.failed) return retval;

            	    }
            	    break;

            	default :
            	    break loop107;
                }
            } while (true);


            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "identPrimary"


    public static class exprList_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "exprList"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:919:1: exprList : ( expression )? ( COMMA ! expression )* ;
    public final HQLParser.exprList_return exprList() throws RecognitionException {
        HQLParser.exprList_return retval = new HQLParser.exprList_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token COMMA464=null;
        HQLParser.expression_return expression463 =null;

        HQLParser.expression_return expression465 =null;


        Object COMMA464_tree=null;

         if (state.backtracking == 0) enableParameterUsage.push(Boolean.TRUE); 
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:922:2: ( ( expression )? ( COMMA ! expression )* )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:922:4: ( expression )? ( COMMA ! expression )*
            {
            root_0 = (Object)adaptor.nil();


            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:922:4: ( expression )?
            int alt108=2;
            int LA108_0 = input.LA(1);

            if ( (LA108_0==CHARACTER_LITERAL||LA108_0==COLON||LA108_0==DECIMAL_LITERAL||LA108_0==FALSE||LA108_0==FLOATING_POINT_LITERAL||LA108_0==HEX_LITERAL||LA108_0==IDENTIFIER||LA108_0==INTEGER_LITERAL||LA108_0==LEFT_PAREN||LA108_0==MINUS||LA108_0==NULL||LA108_0==OCTAL_LITERAL||LA108_0==PARAM||LA108_0==PLUS||LA108_0==STRING_LITERAL||LA108_0==TRUE) ) {
                alt108=1;
            }
            switch (alt108) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:922:4: expression
                    {
                    pushFollow(FOLLOW_expression_in_exprList4095);
                    expression463=expression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, expression463.getTree());

                    }
                    break;

            }


            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:922:16: ( COMMA ! expression )*
            loop109:
            do {
                int alt109=2;
                int LA109_0 = input.LA(1);

                if ( (LA109_0==COMMA) ) {
                    alt109=1;
                }


                switch (alt109) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:922:17: COMMA ! expression
            	    {
            	    COMMA464=(Token)match(input,COMMA,FOLLOW_COMMA_in_exprList4099); if (state.failed) return retval;

            	    pushFollow(FOLLOW_expression_in_exprList4102);
            	    expression465=expression();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) adaptor.addChild(root_0, expression465.getTree());

            	    }
            	    break;

            	default :
            	    break loop109;
                }
            } while (true);


            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { enableParameterUsage.pop(); }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "exprList"


    public static class constant_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "constant"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:925:1: constant : ( literal | NULL | TRUE | FALSE );
    public final HQLParser.constant_return constant() throws RecognitionException {
        HQLParser.constant_return retval = new HQLParser.constant_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token NULL467=null;
        Token TRUE468=null;
        Token FALSE469=null;
        HQLParser.literal_return literal466 =null;


        Object NULL467_tree=null;
        Object TRUE468_tree=null;
        Object FALSE469_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:926:2: ( literal | NULL | TRUE | FALSE )
            int alt110=4;
            switch ( input.LA(1) ) {
            case CHARACTER_LITERAL:
            case DECIMAL_LITERAL:
            case FLOATING_POINT_LITERAL:
            case HEX_LITERAL:
            case INTEGER_LITERAL:
            case OCTAL_LITERAL:
            case STRING_LITERAL:
                {
                alt110=1;
                }
                break;
            case NULL:
                {
                alt110=2;
                }
                break;
            case TRUE:
                {
                alt110=3;
                }
                break;
            case FALSE:
                {
                alt110=4;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 110, 0, input);

                throw nvae;

            }

            switch (alt110) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:926:4: literal
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_literal_in_constant4115);
                    literal466=literal();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, literal466.getTree());

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:927:4: NULL
                    {
                    root_0 = (Object)adaptor.nil();


                    NULL467=(Token)match(input,NULL,FOLLOW_NULL_in_constant4120); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    NULL467_tree = 
                    (Object)adaptor.create(NULL467)
                    ;
                    adaptor.addChild(root_0, NULL467_tree);
                    }

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:928:4: TRUE
                    {
                    root_0 = (Object)adaptor.nil();


                    TRUE468=(Token)match(input,TRUE,FOLLOW_TRUE_in_constant4125); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    TRUE468_tree = 
                    (Object)adaptor.create(TRUE468)
                    ;
                    adaptor.addChild(root_0, TRUE468_tree);
                    }

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:929:4: FALSE
                    {
                    root_0 = (Object)adaptor.nil();


                    FALSE469=(Token)match(input,FALSE,FOLLOW_FALSE_in_constant4130); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    FALSE469_tree = 
                    (Object)adaptor.create(FALSE469)
                    ;
                    adaptor.addChild(root_0, FALSE469_tree);
                    }

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "constant"


    public static class literal_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "literal"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:932:1: literal : ( numeric_literal | HEX_LITERAL | OCTAL_LITERAL | CHARACTER_LITERAL -> ^( CONST_STRING_VALUE CHARACTER_LITERAL ) | STRING_LITERAL -> ^( CONST_STRING_VALUE STRING_LITERAL ) );
    public final HQLParser.literal_return literal() throws RecognitionException {
        HQLParser.literal_return retval = new HQLParser.literal_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token HEX_LITERAL471=null;
        Token OCTAL_LITERAL472=null;
        Token CHARACTER_LITERAL473=null;
        Token STRING_LITERAL474=null;
        HQLParser.numeric_literal_return numeric_literal470 =null;


        Object HEX_LITERAL471_tree=null;
        Object OCTAL_LITERAL472_tree=null;
        Object CHARACTER_LITERAL473_tree=null;
        Object STRING_LITERAL474_tree=null;
        RewriteRuleTokenStream stream_CHARACTER_LITERAL=new RewriteRuleTokenStream(adaptor,"token CHARACTER_LITERAL");
        RewriteRuleTokenStream stream_STRING_LITERAL=new RewriteRuleTokenStream(adaptor,"token STRING_LITERAL");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:933:2: ( numeric_literal | HEX_LITERAL | OCTAL_LITERAL | CHARACTER_LITERAL -> ^( CONST_STRING_VALUE CHARACTER_LITERAL ) | STRING_LITERAL -> ^( CONST_STRING_VALUE STRING_LITERAL ) )
            int alt111=5;
            switch ( input.LA(1) ) {
            case DECIMAL_LITERAL:
            case FLOATING_POINT_LITERAL:
            case INTEGER_LITERAL:
                {
                alt111=1;
                }
                break;
            case HEX_LITERAL:
                {
                alt111=2;
                }
                break;
            case OCTAL_LITERAL:
                {
                alt111=3;
                }
                break;
            case CHARACTER_LITERAL:
                {
                alt111=4;
                }
                break;
            case STRING_LITERAL:
                {
                alt111=5;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 111, 0, input);

                throw nvae;

            }

            switch (alt111) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:933:4: numeric_literal
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_numeric_literal_in_literal4141);
                    numeric_literal470=numeric_literal();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, numeric_literal470.getTree());

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:934:4: HEX_LITERAL
                    {
                    root_0 = (Object)adaptor.nil();


                    HEX_LITERAL471=(Token)match(input,HEX_LITERAL,FOLLOW_HEX_LITERAL_in_literal4146); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    HEX_LITERAL471_tree = 
                    (Object)adaptor.create(HEX_LITERAL471)
                    ;
                    adaptor.addChild(root_0, HEX_LITERAL471_tree);
                    }

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:935:4: OCTAL_LITERAL
                    {
                    root_0 = (Object)adaptor.nil();


                    OCTAL_LITERAL472=(Token)match(input,OCTAL_LITERAL,FOLLOW_OCTAL_LITERAL_in_literal4151); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    OCTAL_LITERAL472_tree = 
                    (Object)adaptor.create(OCTAL_LITERAL472)
                    ;
                    adaptor.addChild(root_0, OCTAL_LITERAL472_tree);
                    }

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:936:4: CHARACTER_LITERAL
                    {
                    CHARACTER_LITERAL473=(Token)match(input,CHARACTER_LITERAL,FOLLOW_CHARACTER_LITERAL_in_literal4156); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_CHARACTER_LITERAL.add(CHARACTER_LITERAL473);


                    // AST REWRITE
                    // elements: CHARACTER_LITERAL
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (Object)adaptor.nil();
                    // 936:22: -> ^( CONST_STRING_VALUE CHARACTER_LITERAL )
                    {
                        // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:936:25: ^( CONST_STRING_VALUE CHARACTER_LITERAL )
                        {
                        Object root_1 = (Object)adaptor.nil();
                        root_1 = (Object)adaptor.becomeRoot(
                        (Object)adaptor.create(CONST_STRING_VALUE, "CONST_STRING_VALUE")
                        , root_1);

                        adaptor.addChild(root_1, 
                        stream_CHARACTER_LITERAL.nextNode()
                        );

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 5 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:937:4: STRING_LITERAL
                    {
                    STRING_LITERAL474=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_literal4169); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_STRING_LITERAL.add(STRING_LITERAL474);


                    // AST REWRITE
                    // elements: STRING_LITERAL
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (Object)adaptor.nil();
                    // 937:19: -> ^( CONST_STRING_VALUE STRING_LITERAL )
                    {
                        // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:937:22: ^( CONST_STRING_VALUE STRING_LITERAL )
                        {
                        Object root_1 = (Object)adaptor.nil();
                        root_1 = (Object)adaptor.becomeRoot(
                        (Object)adaptor.create(CONST_STRING_VALUE, "CONST_STRING_VALUE")
                        , root_1);

                        adaptor.addChild(root_1, 
                        stream_STRING_LITERAL.nextNode()
                        );

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "literal"


    public static class numeric_literal_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "numeric_literal"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:940:1: numeric_literal : ( INTEGER_LITERAL | DECIMAL_LITERAL | FLOATING_POINT_LITERAL );
    public final HQLParser.numeric_literal_return numeric_literal() throws RecognitionException {
        HQLParser.numeric_literal_return retval = new HQLParser.numeric_literal_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token set475=null;

        Object set475_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:941:2: ( INTEGER_LITERAL | DECIMAL_LITERAL | FLOATING_POINT_LITERAL )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:
            {
            root_0 = (Object)adaptor.nil();


            set475=(Token)input.LT(1);

            if ( input.LA(1)==DECIMAL_LITERAL||input.LA(1)==FLOATING_POINT_LITERAL||input.LA(1)==INTEGER_LITERAL ) {
                input.consume();
                if ( state.backtracking==0 ) adaptor.addChild(root_0, 
                (Object)adaptor.create(set475)
                );
                state.errorRecovery=false;
                state.failed=false;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "numeric_literal"


    public static class entityName_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "entityName"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:946:1: entityName : dotIdentifierPath -> ENTITY_NAME[$dotIdentifierPath.start, $dotIdentifierPath.text, entityNames] ;
    public final HQLParser.entityName_return entityName() throws RecognitionException {
        HQLParser.entityName_return retval = new HQLParser.entityName_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.dotIdentifierPath_return dotIdentifierPath476 =null;


        RewriteRuleSubtreeStream stream_dotIdentifierPath=new RewriteRuleSubtreeStream(adaptor,"rule dotIdentifierPath");
         List entityNames = null; 
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:948:2: ( dotIdentifierPath -> ENTITY_NAME[$dotIdentifierPath.start, $dotIdentifierPath.text, entityNames] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:948:4: dotIdentifierPath
            {
            pushFollow(FOLLOW_dotIdentifierPath_in_entityName4214);
            dotIdentifierPath476=dotIdentifierPath();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_dotIdentifierPath.add(dotIdentifierPath476.getTree());

            if ( state.backtracking==0 ) {	entityNames = extractEntityNames((dotIdentifierPath476!=null?input.toString(dotIdentifierPath476.start,dotIdentifierPath476.stop):null));	}

            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 953:3: -> ENTITY_NAME[$dotIdentifierPath.start, $dotIdentifierPath.text, entityNames]
            {
                adaptor.addChild(root_0, 
                new EntityNameTree(ENTITY_NAME, (dotIdentifierPath476!=null?((Token)dotIdentifierPath476.start):null), (dotIdentifierPath476!=null?input.toString(dotIdentifierPath476.start,dotIdentifierPath476.stop):null), entityNames)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "entityName"


    public static class propertyReference_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "propertyReference"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:956:1: propertyReference : path -> ^( PROPERTY_REFERENCE path ) ;
    public final HQLParser.propertyReference_return propertyReference() throws RecognitionException {
        HQLParser.propertyReference_return retval = new HQLParser.propertyReference_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        HQLParser.path_return path477 =null;


        RewriteRuleSubtreeStream stream_path=new RewriteRuleSubtreeStream(adaptor,"rule path");
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:957:2: ( path -> ^( PROPERTY_REFERENCE path ) )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:957:4: path
            {
            pushFollow(FOLLOW_path_in_propertyReference4250);
            path477=path();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_path.add(path477.getTree());

            // AST REWRITE
            // elements: path
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 958:3: -> ^( PROPERTY_REFERENCE path )
            {
                // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:958:6: ^( PROPERTY_REFERENCE path )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(PROPERTY_REFERENCE, "PROPERTY_REFERENCE")
                , root_1);

                adaptor.addChild(root_1, stream_path.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "propertyReference"


    public static class dataType_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "dataType"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:961:1: dataType : IDENTIFIER ;
    public final HQLParser.dataType_return dataType() throws RecognitionException {
        HQLParser.dataType_return retval = new HQLParser.dataType_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token IDENTIFIER478=null;

        Object IDENTIFIER478_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:962:2: ( IDENTIFIER )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:962:4: IDENTIFIER
            {
            root_0 = (Object)adaptor.nil();


            IDENTIFIER478=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_dataType4271); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            IDENTIFIER478_tree = 
            (Object)adaptor.create(IDENTIFIER478)
            ;
            adaptor.addChild(root_0, IDENTIFIER478_tree);
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "dataType"


    public static class dotIdentifierPath_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "dotIdentifierPath"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:965:1: dotIdentifierPath : IDENTIFIER ( DOT ^ IDENTIFIER )* ;
    public final HQLParser.dotIdentifierPath_return dotIdentifierPath() throws RecognitionException {
        HQLParser.dotIdentifierPath_return retval = new HQLParser.dotIdentifierPath_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token IDENTIFIER479=null;
        Token DOT480=null;
        Token IDENTIFIER481=null;

        Object IDENTIFIER479_tree=null;
        Object DOT480_tree=null;
        Object IDENTIFIER481_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:966:2: ( IDENTIFIER ( DOT ^ IDENTIFIER )* )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:966:4: IDENTIFIER ( DOT ^ IDENTIFIER )*
            {
            root_0 = (Object)adaptor.nil();


            IDENTIFIER479=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_dotIdentifierPath4282); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            IDENTIFIER479_tree = 
            (Object)adaptor.create(IDENTIFIER479)
            ;
            adaptor.addChild(root_0, IDENTIFIER479_tree);
            }

            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:967:3: ( DOT ^ IDENTIFIER )*
            loop112:
            do {
                int alt112=2;
                int LA112_0 = input.LA(1);

                if ( (LA112_0==DOT) ) {
                    alt112=1;
                }


                switch (alt112) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:967:5: DOT ^ IDENTIFIER
            	    {
            	    DOT480=(Token)match(input,DOT,FOLLOW_DOT_in_dotIdentifierPath4288); if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {
            	    DOT480_tree = 
            	    (Object)adaptor.create(DOT480)
            	    ;
            	    root_0 = (Object)adaptor.becomeRoot(DOT480_tree, root_0);
            	    }

            	    IDENTIFIER481=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_dotIdentifierPath4291); if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {
            	    IDENTIFIER481_tree = 
            	    (Object)adaptor.create(IDENTIFIER481)
            	    ;
            	    adaptor.addChild(root_0, IDENTIFIER481_tree);
            	    }

            	    }
            	    break;

            	default :
            	    break loop112;
                }
            } while (true);


            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "dotIdentifierPath"


    public static class path_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "path"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:970:1: path : IDENTIFIER ( DOT ^ IDENTIFIER | LEFT_SQUARE ^ expression RIGHT_SQUARE !| LEFT_SQUARE ^ RIGHT_SQUARE !)* ;
    public final HQLParser.path_return path() throws RecognitionException {
        HQLParser.path_return retval = new HQLParser.path_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token IDENTIFIER482=null;
        Token DOT483=null;
        Token IDENTIFIER484=null;
        Token LEFT_SQUARE485=null;
        Token RIGHT_SQUARE487=null;
        Token LEFT_SQUARE488=null;
        Token RIGHT_SQUARE489=null;
        HQLParser.expression_return expression486 =null;


        Object IDENTIFIER482_tree=null;
        Object DOT483_tree=null;
        Object IDENTIFIER484_tree=null;
        Object LEFT_SQUARE485_tree=null;
        Object RIGHT_SQUARE487_tree=null;
        Object LEFT_SQUARE488_tree=null;
        Object RIGHT_SQUARE489_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:971:2: ( IDENTIFIER ( DOT ^ IDENTIFIER | LEFT_SQUARE ^ expression RIGHT_SQUARE !| LEFT_SQUARE ^ RIGHT_SQUARE !)* )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:971:4: IDENTIFIER ( DOT ^ IDENTIFIER | LEFT_SQUARE ^ expression RIGHT_SQUARE !| LEFT_SQUARE ^ RIGHT_SQUARE !)*
            {
            root_0 = (Object)adaptor.nil();


            IDENTIFIER482=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_path4306); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            IDENTIFIER482_tree = 
            (Object)adaptor.create(IDENTIFIER482)
            ;
            adaptor.addChild(root_0, IDENTIFIER482_tree);
            }

            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:972:3: ( DOT ^ IDENTIFIER | LEFT_SQUARE ^ expression RIGHT_SQUARE !| LEFT_SQUARE ^ RIGHT_SQUARE !)*
            loop113:
            do {
                int alt113=4;
                int LA113_0 = input.LA(1);

                if ( (LA113_0==DOT) ) {
                    alt113=1;
                }
                else if ( (LA113_0==LEFT_SQUARE) ) {
                    int LA113_3 = input.LA(2);

                    if ( (LA113_3==RIGHT_SQUARE) ) {
                        alt113=3;
                    }
                    else if ( (LA113_3==CHARACTER_LITERAL||LA113_3==COLON||LA113_3==DECIMAL_LITERAL||LA113_3==FALSE||LA113_3==FLOATING_POINT_LITERAL||LA113_3==HEX_LITERAL||LA113_3==IDENTIFIER||LA113_3==INTEGER_LITERAL||LA113_3==LEFT_PAREN||LA113_3==MINUS||LA113_3==NULL||LA113_3==OCTAL_LITERAL||LA113_3==PARAM||LA113_3==PLUS||LA113_3==STRING_LITERAL||LA113_3==TRUE) ) {
                        alt113=2;
                    }


                }


                switch (alt113) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:972:5: DOT ^ IDENTIFIER
            	    {
            	    DOT483=(Token)match(input,DOT,FOLLOW_DOT_in_path4312); if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {
            	    DOT483_tree = 
            	    (Object)adaptor.create(DOT483)
            	    ;
            	    root_0 = (Object)adaptor.becomeRoot(DOT483_tree, root_0);
            	    }

            	    IDENTIFIER484=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_path4315); if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {
            	    IDENTIFIER484_tree = 
            	    (Object)adaptor.create(IDENTIFIER484)
            	    ;
            	    adaptor.addChild(root_0, IDENTIFIER484_tree);
            	    }

            	    }
            	    break;
            	case 2 :
            	    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:973:5: LEFT_SQUARE ^ expression RIGHT_SQUARE !
            	    {
            	    LEFT_SQUARE485=(Token)match(input,LEFT_SQUARE,FOLLOW_LEFT_SQUARE_in_path4321); if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {
            	    LEFT_SQUARE485_tree = 
            	    (Object)adaptor.create(LEFT_SQUARE485)
            	    ;
            	    root_0 = (Object)adaptor.becomeRoot(LEFT_SQUARE485_tree, root_0);
            	    }

            	    pushFollow(FOLLOW_expression_in_path4324);
            	    expression486=expression();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) adaptor.addChild(root_0, expression486.getTree());

            	    RIGHT_SQUARE487=(Token)match(input,RIGHT_SQUARE,FOLLOW_RIGHT_SQUARE_in_path4326); if (state.failed) return retval;

            	    }
            	    break;
            	case 3 :
            	    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:974:5: LEFT_SQUARE ^ RIGHT_SQUARE !
            	    {
            	    LEFT_SQUARE488=(Token)match(input,LEFT_SQUARE,FOLLOW_LEFT_SQUARE_in_path4333); if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {
            	    LEFT_SQUARE488_tree = 
            	    (Object)adaptor.create(LEFT_SQUARE488)
            	    ;
            	    root_0 = (Object)adaptor.becomeRoot(LEFT_SQUARE488_tree, root_0);
            	    }

            	    RIGHT_SQUARE489=(Token)match(input,RIGHT_SQUARE,FOLLOW_RIGHT_SQUARE_in_path4336); if (state.failed) return retval;

            	    }
            	    break;

            	default :
            	    break loop113;
                }
            } while (true);


            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "path"


    public static class class_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "class_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:978:1: class_key :{...}? =>id= IDENTIFIER -> CLASS[$id] ;
    public final HQLParser.class_key_return class_key() throws RecognitionException {
        HQLParser.class_key_return retval = new HQLParser.class_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:979:2: ({...}? =>id= IDENTIFIER -> CLASS[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:979:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("class")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "class_key", "(validateSoftKeyword(\"class\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_class_key4359); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 980:3: -> CLASS[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(CLASS, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "class_key"


    public static class new_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "new_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:983:1: new_key :{...}? =>id= IDENTIFIER -> NEW[$id] ;
    public final HQLParser.new_key_return new_key() throws RecognitionException {
        HQLParser.new_key_return retval = new HQLParser.new_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:984:2: ({...}? =>id= IDENTIFIER -> NEW[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:984:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("new")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "new_key", "(validateSoftKeyword(\"new\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_new_key4383); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 985:3: -> NEW[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(NEW, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "new_key"


    public static class else_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "else_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:988:1: else_key :{...}? =>id= IDENTIFIER -> ELSE[$id] ;
    public final HQLParser.else_key_return else_key() throws RecognitionException {
        HQLParser.else_key_return retval = new HQLParser.else_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:989:2: ({...}? =>id= IDENTIFIER -> ELSE[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:989:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("else")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "else_key", "(validateSoftKeyword(\"else\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_else_key4407); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 990:3: -> ELSE[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(ELSE, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "else_key"


    public static class object_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "object_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:993:1: object_key :{...}? =>id= IDENTIFIER ;
    public final HQLParser.object_key_return object_key() throws RecognitionException {
        HQLParser.object_key_return retval = new HQLParser.object_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:994:2: ({...}? =>id= IDENTIFIER )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:994:4: {...}? =>id= IDENTIFIER
            {
            root_0 = (Object)adaptor.nil();


            if ( !(((validateSoftKeyword("object")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "object_key", "(validateSoftKeyword(\"object\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_object_key4431); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            id_tree = 
            (Object)adaptor.create(id)
            ;
            adaptor.addChild(root_0, id_tree);
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "object_key"


    public static class case_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "case_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:997:1: case_key :{...}? => IDENTIFIER ;
    public final HQLParser.case_key_return case_key() throws RecognitionException {
        HQLParser.case_key_return retval = new HQLParser.case_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token IDENTIFIER490=null;

        Object IDENTIFIER490_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:998:2: ({...}? => IDENTIFIER )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:998:4: {...}? => IDENTIFIER
            {
            root_0 = (Object)adaptor.nil();


            if ( !(((validateSoftKeyword("case")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "case_key", "(validateSoftKeyword(\"case\"))");
            }

            IDENTIFIER490=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_case_key4446); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            IDENTIFIER490_tree = 
            (Object)adaptor.create(IDENTIFIER490)
            ;
            adaptor.addChild(root_0, IDENTIFIER490_tree);
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "case_key"


    public static class current_date_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "current_date_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1001:1: current_date_key :{...}? =>id= IDENTIFIER -> CURRENT_DATE[$id] ;
    public final HQLParser.current_date_key_return current_date_key() throws RecognitionException {
        HQLParser.current_date_key_return retval = new HQLParser.current_date_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1002:2: ({...}? =>id= IDENTIFIER -> CURRENT_DATE[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1002:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("current_date")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "current_date_key", "(validateSoftKeyword(\"current_date\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_current_date_key4463); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1003:3: -> CURRENT_DATE[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(CURRENT_DATE, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "current_date_key"


    public static class current_time_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "current_time_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1006:1: current_time_key :{...}? =>id= IDENTIFIER -> CURRENT_TIME[$id] ;
    public final HQLParser.current_time_key_return current_time_key() throws RecognitionException {
        HQLParser.current_time_key_return retval = new HQLParser.current_time_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1007:2: ({...}? =>id= IDENTIFIER -> CURRENT_TIME[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1007:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("current_time")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "current_time_key", "(validateSoftKeyword(\"current_time\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_current_time_key4487); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1008:3: -> CURRENT_TIME[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(CURRENT_TIME, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "current_time_key"


    public static class current_timestamp_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "current_timestamp_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1011:1: current_timestamp_key :{...}? =>id= IDENTIFIER -> CURRENT_TIMESTAMP[$id] ;
    public final HQLParser.current_timestamp_key_return current_timestamp_key() throws RecognitionException {
        HQLParser.current_timestamp_key_return retval = new HQLParser.current_timestamp_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1012:2: ({...}? =>id= IDENTIFIER -> CURRENT_TIMESTAMP[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1012:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("current_timestamp")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "current_timestamp_key", "(validateSoftKeyword(\"current_timestamp\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_current_timestamp_key4511); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1013:3: -> CURRENT_TIMESTAMP[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(CURRENT_TIMESTAMP, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "current_timestamp_key"


    public static class timezone_hour_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "timezone_hour_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1016:1: timezone_hour_key :{...}? =>id= IDENTIFIER -> TIMEZONE_HOUR[$id] ;
    public final HQLParser.timezone_hour_key_return timezone_hour_key() throws RecognitionException {
        HQLParser.timezone_hour_key_return retval = new HQLParser.timezone_hour_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1017:2: ({...}? =>id= IDENTIFIER -> TIMEZONE_HOUR[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1017:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("timezone_hour")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "timezone_hour_key", "(validateSoftKeyword(\"timezone_hour\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_timezone_hour_key4535); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1018:3: -> TIMEZONE_HOUR[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(TIMEZONE_HOUR, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "timezone_hour_key"


    public static class timezone_minute_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "timezone_minute_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1021:1: timezone_minute_key :{...}? =>id= IDENTIFIER -> TIMEZONE_MINUTE[$id] ;
    public final HQLParser.timezone_minute_key_return timezone_minute_key() throws RecognitionException {
        HQLParser.timezone_minute_key_return retval = new HQLParser.timezone_minute_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1022:2: ({...}? =>id= IDENTIFIER -> TIMEZONE_MINUTE[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1022:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("timezone_minute")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "timezone_minute_key", "(validateSoftKeyword(\"timezone_minute\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_timezone_minute_key4559); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1023:3: -> TIMEZONE_MINUTE[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(TIMEZONE_MINUTE, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "timezone_minute_key"


    public static class character_length_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "character_length_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1026:1: character_length_key :{...}? =>id= IDENTIFIER -> CHARACTER_LENGTH[$id] ;
    public final HQLParser.character_length_key_return character_length_key() throws RecognitionException {
        HQLParser.character_length_key_return retval = new HQLParser.character_length_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1027:2: ({...}? =>id= IDENTIFIER -> CHARACTER_LENGTH[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1027:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("character_length") || validateSoftKeyword("char_length")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "character_length_key", "(validateSoftKeyword(\"character_length\") || validateSoftKeyword(\"char_length\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_character_length_key4583); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1028:3: -> CHARACTER_LENGTH[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(CHARACTER_LENGTH, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "character_length_key"


    public static class octet_length_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "octet_length_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1031:1: octet_length_key :{...}? =>id= IDENTIFIER -> OCTET_LENGTH[$id] ;
    public final HQLParser.octet_length_key_return octet_length_key() throws RecognitionException {
        HQLParser.octet_length_key_return retval = new HQLParser.octet_length_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1032:2: ({...}? =>id= IDENTIFIER -> OCTET_LENGTH[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1032:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("octet_length")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "octet_length_key", "(validateSoftKeyword(\"octet_length\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_octet_length_key4607); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1033:3: -> OCTET_LENGTH[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(OCTET_LENGTH, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "octet_length_key"


    public static class bit_length_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "bit_length_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1036:1: bit_length_key :{...}? =>id= IDENTIFIER -> BIT_LENGTH[$id] ;
    public final HQLParser.bit_length_key_return bit_length_key() throws RecognitionException {
        HQLParser.bit_length_key_return retval = new HQLParser.bit_length_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1037:2: ({...}? =>id= IDENTIFIER -> BIT_LENGTH[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1037:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("bit_length")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "bit_length_key", "(validateSoftKeyword(\"bit_length\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_bit_length_key4631); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1038:3: -> BIT_LENGTH[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(BIT_LENGTH, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "bit_length_key"


    public static class extract_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "extract_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1041:1: extract_key :{...}? =>id= IDENTIFIER -> EXTRACT[$id] ;
    public final HQLParser.extract_key_return extract_key() throws RecognitionException {
        HQLParser.extract_key_return retval = new HQLParser.extract_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1042:2: ({...}? =>id= IDENTIFIER -> EXTRACT[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1042:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("extract")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "extract_key", "(validateSoftKeyword(\"extract\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_extract_key4655); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1043:3: -> EXTRACT[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(EXTRACT, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "extract_key"


    public static class second_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "second_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1046:1: second_key :{...}? =>id= IDENTIFIER -> SECOND[$id] ;
    public final HQLParser.second_key_return second_key() throws RecognitionException {
        HQLParser.second_key_return retval = new HQLParser.second_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1047:2: ({...}? =>id= IDENTIFIER -> SECOND[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1047:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("second")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "second_key", "(validateSoftKeyword(\"second\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_second_key4679); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1048:3: -> SECOND[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(SECOND, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "second_key"


    public static class year_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "year_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1051:1: year_key :{...}? =>id= IDENTIFIER -> YEAR[$id] ;
    public final HQLParser.year_key_return year_key() throws RecognitionException {
        HQLParser.year_key_return retval = new HQLParser.year_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1052:2: ({...}? =>id= IDENTIFIER -> YEAR[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1052:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("year")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "year_key", "(validateSoftKeyword(\"year\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_year_key4703); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1053:3: -> YEAR[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(YEAR, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "year_key"


    public static class month_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "month_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1056:1: month_key :{...}? =>id= IDENTIFIER -> MONTH[$id] ;
    public final HQLParser.month_key_return month_key() throws RecognitionException {
        HQLParser.month_key_return retval = new HQLParser.month_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1057:2: ({...}? =>id= IDENTIFIER -> MONTH[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1057:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("month")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "month_key", "(validateSoftKeyword(\"month\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_month_key4727); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1058:3: -> MONTH[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(MONTH, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "month_key"


    public static class day_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "day_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1061:1: day_key :{...}? =>id= IDENTIFIER -> DAY[$id] ;
    public final HQLParser.day_key_return day_key() throws RecognitionException {
        HQLParser.day_key_return retval = new HQLParser.day_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1062:2: ({...}? =>id= IDENTIFIER -> DAY[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1062:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("day")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "day_key", "(validateSoftKeyword(\"day\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_day_key4751); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1063:3: -> DAY[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(DAY, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "day_key"


    public static class hour_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "hour_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1066:1: hour_key :{...}? =>id= IDENTIFIER -> HOUR[$id] ;
    public final HQLParser.hour_key_return hour_key() throws RecognitionException {
        HQLParser.hour_key_return retval = new HQLParser.hour_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1067:2: ({...}? =>id= IDENTIFIER -> HOUR[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1067:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("hour")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "hour_key", "(validateSoftKeyword(\"hour\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_hour_key4775); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1068:3: -> HOUR[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(HOUR, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "hour_key"


    public static class minute_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "minute_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1071:1: minute_key :{...}? =>id= IDENTIFIER -> MINUTE[$id] ;
    public final HQLParser.minute_key_return minute_key() throws RecognitionException {
        HQLParser.minute_key_return retval = new HQLParser.minute_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1072:2: ({...}? =>id= IDENTIFIER -> MINUTE[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1072:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("minute")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "minute_key", "(validateSoftKeyword(\"minute\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_minute_key4799); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1073:3: -> MINUTE[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(MINUTE, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "minute_key"


    public static class position_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "position_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1076:1: position_key :{...}? =>id= IDENTIFIER -> POSITION[$id] ;
    public final HQLParser.position_key_return position_key() throws RecognitionException {
        HQLParser.position_key_return retval = new HQLParser.position_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1077:2: ({...}? =>id= IDENTIFIER -> POSITION[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1077:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("position")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "position_key", "(validateSoftKeyword(\"position\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_position_key4823); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1078:3: -> POSITION[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(POSITION, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "position_key"


    public static class sum_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "sum_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1081:1: sum_key :{...}? =>id= IDENTIFIER -> SUM[$id] ;
    public final HQLParser.sum_key_return sum_key() throws RecognitionException {
        HQLParser.sum_key_return retval = new HQLParser.sum_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1082:2: ({...}? =>id= IDENTIFIER -> SUM[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1082:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("sum")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "sum_key", "(validateSoftKeyword(\"sum\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_sum_key4847); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1083:3: -> SUM[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(SUM, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "sum_key"


    public static class avg_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "avg_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1086:1: avg_key :{...}? =>id= IDENTIFIER -> AVG[$id] ;
    public final HQLParser.avg_key_return avg_key() throws RecognitionException {
        HQLParser.avg_key_return retval = new HQLParser.avg_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1087:2: ({...}? =>id= IDENTIFIER -> AVG[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1087:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("avg")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "avg_key", "(validateSoftKeyword(\"avg\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_avg_key4871); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1088:3: -> AVG[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(AVG, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "avg_key"


    public static class max_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "max_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1091:1: max_key :{...}? =>id= IDENTIFIER -> MAX[$id] ;
    public final HQLParser.max_key_return max_key() throws RecognitionException {
        HQLParser.max_key_return retval = new HQLParser.max_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1092:2: ({...}? =>id= IDENTIFIER -> MAX[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1092:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("max")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "max_key", "(validateSoftKeyword(\"max\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_max_key4895); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1093:3: -> MAX[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(MAX, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "max_key"


    public static class min_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "min_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1096:1: min_key :{...}? =>id= IDENTIFIER -> MIN[$id] ;
    public final HQLParser.min_key_return min_key() throws RecognitionException {
        HQLParser.min_key_return retval = new HQLParser.min_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1097:2: ({...}? =>id= IDENTIFIER -> MIN[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1097:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("min")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "min_key", "(validateSoftKeyword(\"min\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_min_key4919); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1098:3: -> MIN[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(MIN, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "min_key"


    public static class count_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "count_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1101:1: count_key :{...}? =>id= IDENTIFIER -> COUNT[$id] ;
    public final HQLParser.count_key_return count_key() throws RecognitionException {
        HQLParser.count_key_return retval = new HQLParser.count_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1102:2: ({...}? =>id= IDENTIFIER -> COUNT[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1102:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("count")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "count_key", "(validateSoftKeyword(\"count\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_count_key4943); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1103:3: -> COUNT[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(COUNT, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "count_key"


    public static class maxelement_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "maxelement_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1106:1: maxelement_key :{...}? =>id= IDENTIFIER -> MAXELEMENT[$id] ;
    public final HQLParser.maxelement_key_return maxelement_key() throws RecognitionException {
        HQLParser.maxelement_key_return retval = new HQLParser.maxelement_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1107:2: ({...}? =>id= IDENTIFIER -> MAXELEMENT[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1107:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("maxelement")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "maxelement_key", "(validateSoftKeyword(\"maxelement\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_maxelement_key4967); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1108:3: -> MAXELEMENT[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(MAXELEMENT, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "maxelement_key"


    public static class maxindex_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "maxindex_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1111:1: maxindex_key :{...}? =>id= IDENTIFIER -> MAXINDEX[$id] ;
    public final HQLParser.maxindex_key_return maxindex_key() throws RecognitionException {
        HQLParser.maxindex_key_return retval = new HQLParser.maxindex_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1112:2: ({...}? =>id= IDENTIFIER -> MAXINDEX[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1112:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("maxindex")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "maxindex_key", "(validateSoftKeyword(\"maxindex\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_maxindex_key4991); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1113:3: -> MAXINDEX[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(MAXINDEX, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "maxindex_key"


    public static class minelement_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "minelement_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1116:1: minelement_key :{...}? =>id= IDENTIFIER -> MINELEMENT[$id] ;
    public final HQLParser.minelement_key_return minelement_key() throws RecognitionException {
        HQLParser.minelement_key_return retval = new HQLParser.minelement_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1117:2: ({...}? =>id= IDENTIFIER -> MINELEMENT[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1117:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("minelement")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "minelement_key", "(validateSoftKeyword(\"minelement\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_minelement_key5015); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1118:3: -> MINELEMENT[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(MINELEMENT, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "minelement_key"


    public static class minindex_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "minindex_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1121:1: minindex_key :{...}? =>id= IDENTIFIER -> MININDEX[$id] ;
    public final HQLParser.minindex_key_return minindex_key() throws RecognitionException {
        HQLParser.minindex_key_return retval = new HQLParser.minindex_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1122:2: ({...}? =>id= IDENTIFIER -> MININDEX[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1122:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("minindex")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "minindex_key", "(validateSoftKeyword(\"minindex\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_minindex_key5039); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1123:3: -> MININDEX[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(MININDEX, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "minindex_key"


    public static class locate_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "locate_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1126:1: locate_key :{...}? =>id= IDENTIFIER -> LOCATE[$id] ;
    public final HQLParser.locate_key_return locate_key() throws RecognitionException {
        HQLParser.locate_key_return retval = new HQLParser.locate_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1127:2: ({...}? =>id= IDENTIFIER -> LOCATE[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1127:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("locate")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "locate_key", "(validateSoftKeyword(\"locate\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_locate_key5063); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1128:3: -> LOCATE[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(LOCATE, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "locate_key"


    public static class abs_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "abs_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1131:1: abs_key :{...}? =>id= IDENTIFIER -> ABS[$id] ;
    public final HQLParser.abs_key_return abs_key() throws RecognitionException {
        HQLParser.abs_key_return retval = new HQLParser.abs_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1132:2: ({...}? =>id= IDENTIFIER -> ABS[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1132:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("abs")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "abs_key", "(validateSoftKeyword(\"abs\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_abs_key5087); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1133:3: -> ABS[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(ABS, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "abs_key"


    public static class sqrt_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "sqrt_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1136:1: sqrt_key :{...}? =>id= IDENTIFIER -> SQRT[$id] ;
    public final HQLParser.sqrt_key_return sqrt_key() throws RecognitionException {
        HQLParser.sqrt_key_return retval = new HQLParser.sqrt_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1137:2: ({...}? =>id= IDENTIFIER -> SQRT[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1137:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("sqrt")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "sqrt_key", "(validateSoftKeyword(\"sqrt\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_sqrt_key5111); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1138:3: -> SQRT[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(SQRT, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "sqrt_key"


    public static class mod_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "mod_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1141:1: mod_key :{...}? =>id= IDENTIFIER -> MOD[$id] ;
    public final HQLParser.mod_key_return mod_key() throws RecognitionException {
        HQLParser.mod_key_return retval = new HQLParser.mod_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1142:2: ({...}? =>id= IDENTIFIER -> MOD[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1142:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("mod")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "mod_key", "(validateSoftKeyword(\"mod\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_mod_key5135); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1143:3: -> MOD[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(MOD, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "mod_key"


    public static class size_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "size_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1146:1: size_key :{...}? =>id= IDENTIFIER -> SIZE[$id] ;
    public final HQLParser.size_key_return size_key() throws RecognitionException {
        HQLParser.size_key_return retval = new HQLParser.size_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1147:2: ({...}? =>id= IDENTIFIER -> SIZE[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1147:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("size")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "size_key", "(validateSoftKeyword(\"size\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_size_key5159); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1148:3: -> SIZE[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(SIZE, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "size_key"


    public static class index_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "index_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1151:1: index_key :{...}? =>id= IDENTIFIER -> INDEX[$id] ;
    public final HQLParser.index_key_return index_key() throws RecognitionException {
        HQLParser.index_key_return retval = new HQLParser.index_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1152:2: ({...}? =>id= IDENTIFIER -> INDEX[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1152:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("index")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "index_key", "(validateSoftKeyword(\"index\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_index_key5183); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1153:3: -> INDEX[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(INDEX, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "index_key"


    public static class leading_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "leading_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1156:1: leading_key :{...}? =>id= IDENTIFIER -> LEADING[$id] ;
    public final HQLParser.leading_key_return leading_key() throws RecognitionException {
        HQLParser.leading_key_return retval = new HQLParser.leading_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1157:2: ({...}? =>id= IDENTIFIER -> LEADING[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1157:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("leading")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "leading_key", "(validateSoftKeyword(\"leading\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_leading_key5207); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1158:3: -> LEADING[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(LEADING, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "leading_key"


    public static class trailing_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "trailing_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1161:1: trailing_key :{...}? =>id= IDENTIFIER -> TRAILING[$id] ;
    public final HQLParser.trailing_key_return trailing_key() throws RecognitionException {
        HQLParser.trailing_key_return retval = new HQLParser.trailing_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1162:2: ({...}? =>id= IDENTIFIER -> TRAILING[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1162:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("trailing")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "trailing_key", "(validateSoftKeyword(\"trailing\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_trailing_key5231); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1163:3: -> TRAILING[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(TRAILING, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "trailing_key"


    public static class upper_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "upper_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1166:1: upper_key :{...}? =>id= IDENTIFIER -> UPPER[$id] ;
    public final HQLParser.upper_key_return upper_key() throws RecognitionException {
        HQLParser.upper_key_return retval = new HQLParser.upper_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1167:2: ({...}? =>id= IDENTIFIER -> UPPER[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1167:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("upper")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "upper_key", "(validateSoftKeyword(\"upper\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_upper_key5255); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1168:3: -> UPPER[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(UPPER, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "upper_key"


    public static class lower_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "lower_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1171:1: lower_key :{...}? =>id= IDENTIFIER -> LOWER[$id] ;
    public final HQLParser.lower_key_return lower_key() throws RecognitionException {
        HQLParser.lower_key_return retval = new HQLParser.lower_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1172:2: ({...}? =>id= IDENTIFIER -> LOWER[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1172:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("lower")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "lower_key", "(validateSoftKeyword(\"lower\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_lower_key5279); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1173:3: -> LOWER[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(LOWER, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "lower_key"


    public static class length_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "length_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1176:1: length_key :{...}? =>id= IDENTIFIER -> LENGTH[$id] ;
    public final HQLParser.length_key_return length_key() throws RecognitionException {
        HQLParser.length_key_return retval = new HQLParser.length_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1177:2: ({...}? =>id= IDENTIFIER -> LENGTH[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1177:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("length")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "length_key", "(validateSoftKeyword(\"length\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_length_key5303); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1178:3: -> LENGTH[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(LENGTH, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "length_key"


    public static class both_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "both_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1181:1: both_key :{...}? =>id= IDENTIFIER -> BOTH[$id] ;
    public final HQLParser.both_key_return both_key() throws RecognitionException {
        HQLParser.both_key_return retval = new HQLParser.both_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1182:2: ({...}? =>id= IDENTIFIER -> BOTH[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1182:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("both")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "both_key", "(validateSoftKeyword(\"both\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_both_key5327); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1183:3: -> BOTH[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(BOTH, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "both_key"


    public static class trim_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "trim_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1186:1: trim_key :{...}? =>id= IDENTIFIER -> TRIM[$id] ;
    public final HQLParser.trim_key_return trim_key() throws RecognitionException {
        HQLParser.trim_key_return retval = new HQLParser.trim_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1187:2: ({...}? =>id= IDENTIFIER -> TRIM[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1187:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("trim")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "trim_key", "(validateSoftKeyword(\"trim\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_trim_key5351); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1188:3: -> TRIM[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(TRIM, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "trim_key"


    public static class substring_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "substring_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1191:1: substring_key :{...}? =>id= IDENTIFIER -> SUBSTRING[$id] ;
    public final HQLParser.substring_key_return substring_key() throws RecognitionException {
        HQLParser.substring_key_return retval = new HQLParser.substring_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1192:2: ({...}? =>id= IDENTIFIER -> SUBSTRING[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1192:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("substring")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "substring_key", "(validateSoftKeyword(\"substring\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_substring_key5375); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1193:3: -> SUBSTRING[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(SUBSTRING, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "substring_key"


    public static class concat_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "concat_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1196:1: concat_key :{...}? =>id= IDENTIFIER -> CONCAT[$id] ;
    public final HQLParser.concat_key_return concat_key() throws RecognitionException {
        HQLParser.concat_key_return retval = new HQLParser.concat_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1197:2: ({...}? =>id= IDENTIFIER -> CONCAT[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1197:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("concat")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "concat_key", "(validateSoftKeyword(\"concat\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_concat_key5399); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1198:3: -> CONCAT[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(CONCAT, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "concat_key"


    public static class cast_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "cast_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1201:1: cast_key :{...}? =>id= IDENTIFIER -> CAST[$id] ;
    public final HQLParser.cast_key_return cast_key() throws RecognitionException {
        HQLParser.cast_key_return retval = new HQLParser.cast_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1202:2: ({...}? =>id= IDENTIFIER -> CAST[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1202:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("cast")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "cast_key", "(validateSoftKeyword(\"cast\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_cast_key5423); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1203:3: -> CAST[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(CAST, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "cast_key"


    public static class any_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "any_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1206:1: any_key :{...}? =>id= IDENTIFIER -> ANY[$id] ;
    public final HQLParser.any_key_return any_key() throws RecognitionException {
        HQLParser.any_key_return retval = new HQLParser.any_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1207:2: ({...}? =>id= IDENTIFIER -> ANY[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1207:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("any")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "any_key", "(validateSoftKeyword(\"any\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_any_key5447); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1208:3: -> ANY[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(ANY, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "any_key"


    public static class exists_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "exists_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1211:1: exists_key :{...}? =>id= IDENTIFIER -> EXISTS[$id] ;
    public final HQLParser.exists_key_return exists_key() throws RecognitionException {
        HQLParser.exists_key_return retval = new HQLParser.exists_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1212:2: ({...}? =>id= IDENTIFIER -> EXISTS[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1212:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("exists")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "exists_key", "(validateSoftKeyword(\"exists\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_exists_key5471); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1213:3: -> EXISTS[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(EXISTS, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "exists_key"


    public static class some_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "some_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1216:1: some_key :{...}? =>id= IDENTIFIER -> SOME[$id] ;
    public final HQLParser.some_key_return some_key() throws RecognitionException {
        HQLParser.some_key_return retval = new HQLParser.some_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1217:2: ({...}? =>id= IDENTIFIER -> SOME[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1217:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("some")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "some_key", "(validateSoftKeyword(\"some\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_some_key5495); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1218:3: -> SOME[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(SOME, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "some_key"


    public static class then_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "then_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1221:1: then_key :{...}? =>id= IDENTIFIER -> THEN[$id] ;
    public final HQLParser.then_key_return then_key() throws RecognitionException {
        HQLParser.then_key_return retval = new HQLParser.then_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1222:2: ({...}? =>id= IDENTIFIER -> THEN[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1222:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("then")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "then_key", "(validateSoftKeyword(\"then\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_then_key5519); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1223:3: -> THEN[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(THEN, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "then_key"


    public static class end_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "end_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1226:1: end_key :{...}? =>id= IDENTIFIER -> END[$id] ;
    public final HQLParser.end_key_return end_key() throws RecognitionException {
        HQLParser.end_key_return retval = new HQLParser.end_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1227:2: ({...}? =>id= IDENTIFIER -> END[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1227:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("end")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "end_key", "(validateSoftKeyword(\"end\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_end_key5543); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1228:3: -> END[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(END, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "end_key"


    public static class when_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "when_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1232:1: when_key :{...}? =>id= IDENTIFIER -> WHEN[$id] ;
    public final HQLParser.when_key_return when_key() throws RecognitionException {
        HQLParser.when_key_return retval = new HQLParser.when_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1233:2: ({...}? =>id= IDENTIFIER -> WHEN[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1233:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("when")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "when_key", "(validateSoftKeyword(\"when\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_when_key5568); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1234:3: -> WHEN[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(WHEN, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "when_key"


    public static class nullif_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "nullif_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1237:1: nullif_key :{...}? =>id= IDENTIFIER -> NULLIF[$id] ;
    public final HQLParser.nullif_key_return nullif_key() throws RecognitionException {
        HQLParser.nullif_key_return retval = new HQLParser.nullif_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1238:2: ({...}? =>id= IDENTIFIER -> NULLIF[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1238:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("nullif")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "nullif_key", "(validateSoftKeyword(\"nullif\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_nullif_key5592); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1239:3: -> NULLIF[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(NULLIF, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "nullif_key"


    public static class coalesce_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "coalesce_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1242:1: coalesce_key :{...}? =>id= IDENTIFIER -> COALESCE[$id] ;
    public final HQLParser.coalesce_key_return coalesce_key() throws RecognitionException {
        HQLParser.coalesce_key_return retval = new HQLParser.coalesce_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1243:2: ({...}? =>id= IDENTIFIER -> COALESCE[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1243:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("coalesce")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "coalesce_key", "(validateSoftKeyword(\"coalesce\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_coalesce_key5616); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1244:3: -> COALESCE[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(COALESCE, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "coalesce_key"


    public static class escape_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "escape_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1247:1: escape_key :{...}? =>id= IDENTIFIER -> ESCAPE[$id] ;
    public final HQLParser.escape_key_return escape_key() throws RecognitionException {
        HQLParser.escape_key_return retval = new HQLParser.escape_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1248:2: ({...}? =>id= IDENTIFIER -> ESCAPE[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1248:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("escape")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "escape_key", "(validateSoftKeyword(\"escape\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_escape_key5640); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1249:3: -> ESCAPE[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(ESCAPE, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "escape_key"


    public static class like_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "like_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1252:1: like_key :{...}? =>id= IDENTIFIER -> LIKE[$id] ;
    public final HQLParser.like_key_return like_key() throws RecognitionException {
        HQLParser.like_key_return retval = new HQLParser.like_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1253:2: ({...}? =>id= IDENTIFIER -> LIKE[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1253:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("like")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "like_key", "(validateSoftKeyword(\"like\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_like_key5664); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1254:3: -> LIKE[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(LIKE, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "like_key"


    public static class between_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "between_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1257:1: between_key :{...}? =>id= IDENTIFIER -> BETWEEN[$id] ;
    public final HQLParser.between_key_return between_key() throws RecognitionException {
        HQLParser.between_key_return retval = new HQLParser.between_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1258:2: ({...}? =>id= IDENTIFIER -> BETWEEN[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1258:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("between")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "between_key", "(validateSoftKeyword(\"between\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_between_key5688); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1259:3: -> BETWEEN[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(BETWEEN, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "between_key"


    public static class member_of_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "member_of_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1262:1: member_of_key :{...}? =>id= IDENTIFIER IDENTIFIER -> MEMBER_OF[$id] ;
    public final HQLParser.member_of_key_return member_of_key() throws RecognitionException {
        HQLParser.member_of_key_return retval = new HQLParser.member_of_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;
        Token IDENTIFIER491=null;

        Object id_tree=null;
        Object IDENTIFIER491_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");


        	String text = "";

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1265:3: ({...}? =>id= IDENTIFIER IDENTIFIER -> MEMBER_OF[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1265:5: {...}? =>id= IDENTIFIER IDENTIFIER
            {
            if ( !(((validateSoftKeyword("member") && validateLT(2, "of")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "member_of_key", "(validateSoftKeyword(\"member\") && validateLT(2, \"of\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_member_of_key5715); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            IDENTIFIER491=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_member_of_key5717); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(IDENTIFIER491);


            if ( state.backtracking==0 ) {text = input.toString(retval.start,input.LT(-1));}

            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1266:3: -> MEMBER_OF[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(MEMBER_OF, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "member_of_key"


    public static class empty_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "empty_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1269:1: empty_key :{...}? =>id= IDENTIFIER ;
    public final HQLParser.empty_key_return empty_key() throws RecognitionException {
        HQLParser.empty_key_return retval = new HQLParser.empty_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1270:2: ({...}? =>id= IDENTIFIER )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1270:4: {...}? =>id= IDENTIFIER
            {
            root_0 = (Object)adaptor.nil();


            if ( !(((validateSoftKeyword("empty")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "empty_key", "(validateSoftKeyword(\"empty\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_empty_key5743); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            id_tree = 
            (Object)adaptor.create(id)
            ;
            adaptor.addChild(root_0, id_tree);
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "empty_key"


    public static class is_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "is_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1273:1: is_key :{...}? =>id= IDENTIFIER -> IS[$id] ;
    public final HQLParser.is_key_return is_key() throws RecognitionException {
        HQLParser.is_key_return retval = new HQLParser.is_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1273:8: ({...}? =>id= IDENTIFIER -> IS[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1273:10: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("is")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "is_key", "(validateSoftKeyword(\"is\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_is_key5759); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1274:3: -> IS[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(IS, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "is_key"


    public static class or_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "or_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1277:1: or_key :{...}? =>id= IDENTIFIER -> OR[$id] ;
    public final HQLParser.or_key_return or_key() throws RecognitionException {
        HQLParser.or_key_return retval = new HQLParser.or_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1277:8: ({...}? =>id= IDENTIFIER -> OR[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1277:10: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("or")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "or_key", "(validateSoftKeyword(\"or\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_or_key5782); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1278:3: -> OR[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(OR, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "or_key"


    public static class and_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "and_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1281:1: and_key :{...}? =>id= IDENTIFIER -> AND[$id] ;
    public final HQLParser.and_key_return and_key() throws RecognitionException {
        HQLParser.and_key_return retval = new HQLParser.and_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1281:9: ({...}? =>id= IDENTIFIER -> AND[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1281:11: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("and")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "and_key", "(validateSoftKeyword(\"and\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_and_key5805); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1282:3: -> AND[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(AND, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "and_key"


    public static class not_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "not_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1285:1: not_key :{...}? =>id= IDENTIFIER -> NOT[$id] ;
    public final HQLParser.not_key_return not_key() throws RecognitionException {
        HQLParser.not_key_return retval = new HQLParser.not_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1285:9: ({...}? =>id= IDENTIFIER -> NOT[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1285:11: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("not")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "not_key", "(validateSoftKeyword(\"not\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_not_key5828); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1286:3: -> NOT[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(NOT, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "not_key"


    public static class set_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "set_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1289:1: set_key :{...}? =>id= IDENTIFIER -> SET[$id] ;
    public final HQLParser.set_key_return set_key() throws RecognitionException {
        HQLParser.set_key_return retval = new HQLParser.set_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1290:2: ({...}? =>id= IDENTIFIER -> SET[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1290:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("set")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "set_key", "(validateSoftKeyword(\"set\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_set_key5852); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1291:3: -> SET[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(SET, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "set_key"


    public static class versioned_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "versioned_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1294:1: versioned_key :{...}? =>id= IDENTIFIER -> VERSIONED[$id] ;
    public final HQLParser.versioned_key_return versioned_key() throws RecognitionException {
        HQLParser.versioned_key_return retval = new HQLParser.versioned_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1295:2: ({...}? =>id= IDENTIFIER -> VERSIONED[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1295:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("versioned")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "versioned_key", "(validateSoftKeyword(\"versioned\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_versioned_key5876); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1296:3: -> VERSIONED[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(VERSIONED, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "versioned_key"


    public static class update_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "update_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1299:1: update_key :{...}? =>id= IDENTIFIER -> UPDATE[$id] ;
    public final HQLParser.update_key_return update_key() throws RecognitionException {
        HQLParser.update_key_return retval = new HQLParser.update_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1300:2: ({...}? =>id= IDENTIFIER -> UPDATE[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1300:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("update")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "update_key", "(validateSoftKeyword(\"update\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_update_key5900); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1301:3: -> UPDATE[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(UPDATE, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "update_key"


    public static class delete_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "delete_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1304:1: delete_key :{...}? =>id= IDENTIFIER -> DELETE[$id] ;
    public final HQLParser.delete_key_return delete_key() throws RecognitionException {
        HQLParser.delete_key_return retval = new HQLParser.delete_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1305:2: ({...}? =>id= IDENTIFIER -> DELETE[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1305:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("delete")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "delete_key", "(validateSoftKeyword(\"delete\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_delete_key5924); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1306:3: -> DELETE[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(DELETE, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "delete_key"


    public static class insert_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "insert_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1309:1: insert_key :{...}? =>id= IDENTIFIER -> INSERT[$id] ;
    public final HQLParser.insert_key_return insert_key() throws RecognitionException {
        HQLParser.insert_key_return retval = new HQLParser.insert_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1310:2: ({...}? =>id= IDENTIFIER -> INSERT[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1310:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("insert")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "insert_key", "(validateSoftKeyword(\"insert\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_insert_key5948); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1311:3: -> INSERT[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(INSERT, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "insert_key"


    public static class into_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "into_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1314:1: into_key :{...}? =>id= IDENTIFIER -> INTO[$id] ;
    public final HQLParser.into_key_return into_key() throws RecognitionException {
        HQLParser.into_key_return retval = new HQLParser.into_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1315:2: ({...}? =>id= IDENTIFIER -> INTO[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1315:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("into")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "into_key", "(validateSoftKeyword(\"into\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_into_key5972); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1316:3: -> INTO[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(INTO, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "into_key"


    public static class having_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "having_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1319:1: having_key :{...}? =>id= IDENTIFIER -> HAVING[$id] ;
    public final HQLParser.having_key_return having_key() throws RecognitionException {
        HQLParser.having_key_return retval = new HQLParser.having_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1320:2: ({...}? =>id= IDENTIFIER -> HAVING[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1320:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("having")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "having_key", "(validateSoftKeyword(\"having\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_having_key5996); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1321:3: -> HAVING[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(HAVING, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "having_key"


    public static class with_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "with_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1324:1: with_key :{...}? =>id= IDENTIFIER -> WITH[$id] ;
    public final HQLParser.with_key_return with_key() throws RecognitionException {
        HQLParser.with_key_return retval = new HQLParser.with_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1325:2: ({...}? =>id= IDENTIFIER -> WITH[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1325:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("with")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "with_key", "(validateSoftKeyword(\"with\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_with_key6020); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1326:3: -> WITH[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(WITH, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "with_key"


    public static class on_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "on_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1329:1: on_key :{...}? =>id= IDENTIFIER -> ON[$id] ;
    public final HQLParser.on_key_return on_key() throws RecognitionException {
        HQLParser.on_key_return retval = new HQLParser.on_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1330:2: ({...}? =>id= IDENTIFIER -> ON[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1330:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("on")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "on_key", "(validateSoftKeyword(\"on\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_on_key6044); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1331:3: -> ON[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(ON, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "on_key"


    public static class indices_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "indices_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1334:1: indices_key :{...}? =>id= IDENTIFIER -> INDICES[$id] ;
    public final HQLParser.indices_key_return indices_key() throws RecognitionException {
        HQLParser.indices_key_return retval = new HQLParser.indices_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1335:2: ({...}? =>id= IDENTIFIER -> INDICES[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1335:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("indices")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "indices_key", "(validateSoftKeyword(\"indices\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_indices_key6068); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1336:3: -> INDICES[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(INDICES, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "indices_key"


    public static class cross_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "cross_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1339:1: cross_key :{...}? =>id= IDENTIFIER -> CROSS[$id] ;
    public final HQLParser.cross_key_return cross_key() throws RecognitionException {
        HQLParser.cross_key_return retval = new HQLParser.cross_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1340:2: ({...}? =>id= IDENTIFIER -> CROSS[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1340:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("cross")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "cross_key", "(validateSoftKeyword(\"cross\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_cross_key6092); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1341:3: -> CROSS[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(CROSS, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "cross_key"


    public static class join_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "join_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1344:1: join_key :{...}? =>id= IDENTIFIER -> JOIN[$id] ;
    public final HQLParser.join_key_return join_key() throws RecognitionException {
        HQLParser.join_key_return retval = new HQLParser.join_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1345:2: ({...}? =>id= IDENTIFIER -> JOIN[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1345:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("join")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "join_key", "(validateSoftKeyword(\"join\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_join_key6116); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1346:3: -> JOIN[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(JOIN, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "join_key"


    public static class inner_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "inner_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1349:1: inner_key :{...}? =>id= IDENTIFIER -> INNER[$id] ;
    public final HQLParser.inner_key_return inner_key() throws RecognitionException {
        HQLParser.inner_key_return retval = new HQLParser.inner_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1350:2: ({...}? =>id= IDENTIFIER -> INNER[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1350:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("inner")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "inner_key", "(validateSoftKeyword(\"inner\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_inner_key6140); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1351:3: -> INNER[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(INNER, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "inner_key"


    public static class outer_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "outer_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1354:1: outer_key :{...}? =>id= IDENTIFIER -> OUTER[$id] ;
    public final HQLParser.outer_key_return outer_key() throws RecognitionException {
        HQLParser.outer_key_return retval = new HQLParser.outer_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1355:2: ({...}? =>id= IDENTIFIER -> OUTER[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1355:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("outer")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "outer_key", "(validateSoftKeyword(\"outer\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_outer_key6164); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1356:3: -> OUTER[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(OUTER, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "outer_key"


    public static class left_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "left_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1359:1: left_key :{...}? =>id= IDENTIFIER -> LEFT[$id] ;
    public final HQLParser.left_key_return left_key() throws RecognitionException {
        HQLParser.left_key_return retval = new HQLParser.left_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1360:2: ({...}? =>id= IDENTIFIER -> LEFT[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1360:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("left")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "left_key", "(validateSoftKeyword(\"left\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_left_key6188); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1361:3: -> LEFT[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(LEFT, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "left_key"


    public static class right_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "right_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1364:1: right_key :{...}? =>id= IDENTIFIER -> RIGHT[$id] ;
    public final HQLParser.right_key_return right_key() throws RecognitionException {
        HQLParser.right_key_return retval = new HQLParser.right_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1365:2: ({...}? =>id= IDENTIFIER -> RIGHT[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1365:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("right")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "right_key", "(validateSoftKeyword(\"right\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_right_key6212); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1366:3: -> RIGHT[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(RIGHT, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "right_key"


    public static class full_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "full_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1369:1: full_key :{...}? =>id= IDENTIFIER -> FULL[$id] ;
    public final HQLParser.full_key_return full_key() throws RecognitionException {
        HQLParser.full_key_return retval = new HQLParser.full_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1370:2: ({...}? =>id= IDENTIFIER -> FULL[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1370:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("full")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "full_key", "(validateSoftKeyword(\"full\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_full_key6236); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1371:3: -> FULL[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(FULL, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "full_key"


    public static class elements_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "elements_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1374:1: elements_key :{...}? =>id= IDENTIFIER -> ELEMENTS[$id] ;
    public final HQLParser.elements_key_return elements_key() throws RecognitionException {
        HQLParser.elements_key_return retval = new HQLParser.elements_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1375:2: ({...}? =>id= IDENTIFIER -> ELEMENTS[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1375:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("elements")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "elements_key", "(validateSoftKeyword(\"elements\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_elements_key6260); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1376:3: -> ELEMENTS[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(ELEMENTS, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "elements_key"


    public static class properties_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "properties_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1379:1: properties_key :{...}? =>id= IDENTIFIER -> PROPERTIES[$id] ;
    public final HQLParser.properties_key_return properties_key() throws RecognitionException {
        HQLParser.properties_key_return retval = new HQLParser.properties_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1380:2: ({...}? =>id= IDENTIFIER -> PROPERTIES[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1380:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("properties")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "properties_key", "(validateSoftKeyword(\"properties\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_properties_key6284); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1381:3: -> PROPERTIES[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(PROPERTIES, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "properties_key"


    public static class fetch_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "fetch_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1384:1: fetch_key :{...}? =>id= IDENTIFIER -> FETCH[$id] ;
    public final HQLParser.fetch_key_return fetch_key() throws RecognitionException {
        HQLParser.fetch_key_return retval = new HQLParser.fetch_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1385:2: ({...}? =>id= IDENTIFIER -> FETCH[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1385:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("fetch")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "fetch_key", "(validateSoftKeyword(\"fetch\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_fetch_key6308); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1386:3: -> FETCH[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(FETCH, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "fetch_key"


    public static class in_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "in_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1389:1: in_key :{...}? =>id= IDENTIFIER -> IN[$id] ;
    public final HQLParser.in_key_return in_key() throws RecognitionException {
        HQLParser.in_key_return retval = new HQLParser.in_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1390:2: ({...}? =>id= IDENTIFIER -> IN[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1390:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("in")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "in_key", "(validateSoftKeyword(\"in\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_in_key6332); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1391:3: -> IN[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(IN, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "in_key"


    public static class as_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "as_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1394:1: as_key :{...}? =>id= IDENTIFIER -> AS[$id] ;
    public final HQLParser.as_key_return as_key() throws RecognitionException {
        HQLParser.as_key_return retval = new HQLParser.as_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1395:2: ({...}? =>id= IDENTIFIER -> AS[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1395:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("as")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "as_key", "(validateSoftKeyword(\"as\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_as_key6356); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1396:3: -> AS[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(AS, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "as_key"


    public static class where_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "where_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1399:1: where_key :{...}? =>id= IDENTIFIER -> WHERE[$id] ;
    public final HQLParser.where_key_return where_key() throws RecognitionException {
        HQLParser.where_key_return retval = new HQLParser.where_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1400:2: ({...}? =>id= IDENTIFIER -> WHERE[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1400:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("where")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "where_key", "(validateSoftKeyword(\"where\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_where_key6380); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1401:3: -> WHERE[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(WHERE, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "where_key"


    public static class select_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "select_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1404:1: select_key :{...}? =>id= IDENTIFIER -> SELECT[$id] ;
    public final HQLParser.select_key_return select_key() throws RecognitionException {
        HQLParser.select_key_return retval = new HQLParser.select_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1405:2: ({...}? =>id= IDENTIFIER -> SELECT[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1405:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("select")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "select_key", "(validateSoftKeyword(\"select\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_select_key6404); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1406:3: -> SELECT[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(SELECT, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "select_key"


    public static class distinct_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "distinct_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1409:1: distinct_key :{...}? =>id= IDENTIFIER -> DISTINCT[$id] ;
    public final HQLParser.distinct_key_return distinct_key() throws RecognitionException {
        HQLParser.distinct_key_return retval = new HQLParser.distinct_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1410:2: ({...}? =>id= IDENTIFIER -> DISTINCT[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1410:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("distinct")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "distinct_key", "(validateSoftKeyword(\"distinct\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_distinct_key6428); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1411:3: -> DISTINCT[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(DISTINCT, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "distinct_key"


    public static class union_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "union_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1414:1: union_key :{...}? =>id= IDENTIFIER -> UNION[$id] ;
    public final HQLParser.union_key_return union_key() throws RecognitionException {
        HQLParser.union_key_return retval = new HQLParser.union_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1415:2: ({...}? =>id= IDENTIFIER -> UNION[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1415:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("union")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "union_key", "(validateSoftKeyword(\"union\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_union_key6452); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1416:3: -> UNION[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(UNION, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "union_key"


    public static class intersect_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "intersect_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1419:1: intersect_key :{...}? =>id= IDENTIFIER -> INTERSECT[$id] ;
    public final HQLParser.intersect_key_return intersect_key() throws RecognitionException {
        HQLParser.intersect_key_return retval = new HQLParser.intersect_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1420:2: ({...}? =>id= IDENTIFIER -> INTERSECT[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1420:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("intersect")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "intersect_key", "(validateSoftKeyword(\"intersect\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_intersect_key6476); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1421:3: -> INTERSECT[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(INTERSECT, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "intersect_key"


    public static class except_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "except_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1424:1: except_key :{...}? =>id= IDENTIFIER -> EXCEPT[$id] ;
    public final HQLParser.except_key_return except_key() throws RecognitionException {
        HQLParser.except_key_return retval = new HQLParser.except_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1425:2: ({...}? =>id= IDENTIFIER -> EXCEPT[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1425:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("except")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "except_key", "(validateSoftKeyword(\"except\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_except_key6500); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1426:3: -> EXCEPT[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(EXCEPT, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "except_key"


    public static class all_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "all_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1429:1: all_key :{...}? =>id= IDENTIFIER -> ALL[$id] ;
    public final HQLParser.all_key_return all_key() throws RecognitionException {
        HQLParser.all_key_return retval = new HQLParser.all_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1430:2: ({...}? =>id= IDENTIFIER -> ALL[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1430:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("all")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "all_key", "(validateSoftKeyword(\"all\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_all_key6524); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1431:3: -> ALL[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(ALL, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "all_key"


    public static class ascending_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "ascending_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1434:1: ascending_key :{...}? => IDENTIFIER ;
    public final HQLParser.ascending_key_return ascending_key() throws RecognitionException {
        HQLParser.ascending_key_return retval = new HQLParser.ascending_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token IDENTIFIER492=null;

        Object IDENTIFIER492_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1435:2: ({...}? => IDENTIFIER )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1435:4: {...}? => IDENTIFIER
            {
            root_0 = (Object)adaptor.nil();


            if ( !(((validateSoftKeyword("ascending") || validateSoftKeyword("asc")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "ascending_key", "(validateSoftKeyword(\"ascending\") || validateSoftKeyword(\"asc\"))");
            }

            IDENTIFIER492=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_ascending_key6546); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            IDENTIFIER492_tree = 
            (Object)adaptor.create(IDENTIFIER492)
            ;
            adaptor.addChild(root_0, IDENTIFIER492_tree);
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "ascending_key"


    public static class descending_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "descending_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1438:1: descending_key :{...}? => IDENTIFIER ;
    public final HQLParser.descending_key_return descending_key() throws RecognitionException {
        HQLParser.descending_key_return retval = new HQLParser.descending_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token IDENTIFIER493=null;

        Object IDENTIFIER493_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1439:2: ({...}? => IDENTIFIER )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1439:4: {...}? => IDENTIFIER
            {
            root_0 = (Object)adaptor.nil();


            if ( !(((validateSoftKeyword("descending") || validateSoftKeyword("desc")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "descending_key", "(validateSoftKeyword(\"descending\") || validateSoftKeyword(\"desc\"))");
            }

            IDENTIFIER493=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_descending_key6561); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            IDENTIFIER493_tree = 
            (Object)adaptor.create(IDENTIFIER493)
            ;
            adaptor.addChild(root_0, IDENTIFIER493_tree);
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "descending_key"


    public static class collate_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "collate_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1442:1: collate_key :{...}? => IDENTIFIER ;
    public final HQLParser.collate_key_return collate_key() throws RecognitionException {
        HQLParser.collate_key_return retval = new HQLParser.collate_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token IDENTIFIER494=null;

        Object IDENTIFIER494_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1443:2: ({...}? => IDENTIFIER )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1443:4: {...}? => IDENTIFIER
            {
            root_0 = (Object)adaptor.nil();


            if ( !(((validateSoftKeyword("collate")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "collate_key", "(validateSoftKeyword(\"collate\"))");
            }

            IDENTIFIER494=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_collate_key6576); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            IDENTIFIER494_tree = 
            (Object)adaptor.create(IDENTIFIER494)
            ;
            adaptor.addChild(root_0, IDENTIFIER494_tree);
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "collate_key"


    public static class order_by_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "order_by_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1446:1: order_by_key :{...}? =>id= IDENTIFIER IDENTIFIER -> ORDER_BY[$id] ;
    public final HQLParser.order_by_key_return order_by_key() throws RecognitionException {
        HQLParser.order_by_key_return retval = new HQLParser.order_by_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;
        Token IDENTIFIER495=null;

        Object id_tree=null;
        Object IDENTIFIER495_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");


        	String text = "";

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1449:3: ({...}? =>id= IDENTIFIER IDENTIFIER -> ORDER_BY[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1449:5: {...}? =>id= IDENTIFIER IDENTIFIER
            {
            if ( !(((validateSoftKeyword("order") && validateLT(2, "by")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "order_by_key", "(validateSoftKeyword(\"order\") && validateLT(2, \"by\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_order_by_key6596); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            IDENTIFIER495=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_order_by_key6598); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(IDENTIFIER495);


            if ( state.backtracking==0 ) {text = input.toString(retval.start,input.LT(-1));}

            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1450:3: -> ORDER_BY[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(ORDER_BY, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "order_by_key"


    public static class group_by_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "group_by_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1453:1: group_by_key :{...}? =>id= IDENTIFIER IDENTIFIER -> GROUP_BY[$id] ;
    public final HQLParser.group_by_key_return group_by_key() throws RecognitionException {
        HQLParser.group_by_key_return retval = new HQLParser.group_by_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;
        Token IDENTIFIER496=null;

        Object id_tree=null;
        Object IDENTIFIER496_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");


        	String text = "";

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1456:3: ({...}? =>id= IDENTIFIER IDENTIFIER -> GROUP_BY[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1456:5: {...}? =>id= IDENTIFIER IDENTIFIER
            {
            if ( !(((validateSoftKeyword("group") && validateLT(2, "by")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "group_by_key", "(validateSoftKeyword(\"group\") && validateLT(2, \"by\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_group_by_key6627); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            IDENTIFIER496=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_group_by_key6629); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(IDENTIFIER496);


            if ( state.backtracking==0 ) {text = input.toString(retval.start,input.LT(-1));}

            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1457:3: -> GROUP_BY[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(GROUP_BY, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "group_by_key"


    public static class from_key_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "from_key"
    // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1460:1: from_key :{...}? =>id= IDENTIFIER -> FROM[$id] ;
    public final HQLParser.from_key_return from_key() throws RecognitionException {
        HQLParser.from_key_return retval = new HQLParser.from_key_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token id=null;

        Object id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1461:2: ({...}? =>id= IDENTIFIER -> FROM[$id] )
            // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:1461:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("from")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "from_key", "(validateSoftKeyword(\"from\"))");
            }

            id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_from_key6655); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 1462:3: -> FROM[$id]
            {
                adaptor.addChild(root_0, 
                (Object)adaptor.create(FROM, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "from_key"

    // $ANTLR start synpred1_HQLParser
    public final void synpred1_HQLParser_fragment() throws RecognitionException {
        // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:415:5: ( hibernateLegacySyntax )
        // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:415:5: hibernateLegacySyntax
        {
        pushFollow(FOLLOW_hibernateLegacySyntax_in_synpred1_HQLParser1004);
        hibernateLegacySyntax();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred1_HQLParser

    // $ANTLR start synpred2_HQLParser
    public final void synpred2_HQLParser_fragment() throws RecognitionException {
        // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:416:4: ( jpaCollectionReference )
        // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:416:4: jpaCollectionReference
        {
        pushFollow(FOLLOW_jpaCollectionReference_in_synpred2_HQLParser1009);
        jpaCollectionReference();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred2_HQLParser

    // $ANTLR start synpred3_HQLParser
    public final void synpred3_HQLParser_fragment() throws RecognitionException {
        // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:658:5: ( simpleCase )
        // org/hibernate/hql/ast/origin/hql/parse/HQLParser.g:658:5: simpleCase
        {
        pushFollow(FOLLOW_simpleCase_in_synpred3_HQLParser2508);
        simpleCase();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred3_HQLParser

    // Delegated rules

    public final boolean synpred3_HQLParser() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred3_HQLParser_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred1_HQLParser() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred1_HQLParser_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred2_HQLParser() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred2_HQLParser_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }


    protected DFA7 dfa7 = new DFA7(this);
    static final String DFA7_eotS =
        "\12\uffff";
    static final String DFA7_eofS =
        "\12\uffff";
    static final String DFA7_minS =
        "\1\113\1\25\1\51\1\uffff\1\51\2\uffff\1\113\1\uffff\1\51";
    static final String DFA7_maxS =
        "\1\113\1\u00b1\1\113\1\uffff\1\141\2\uffff\1\113\1\uffff\1\141";
    static final String DFA7_acceptS =
        "\3\uffff\1\4\1\uffff\1\1\1\2\1\uffff\1\3\1\uffff";
    static final String DFA7_specialS =
        "\1\3\1\0\1\2\1\uffff\1\5\2\uffff\1\4\1\uffff\1\1}>";
    static final String[] DFA7_transitionS = {
            "\1\1",
            "\1\3\4\uffff\1\3\13\uffff\1\3\24\uffff\1\3\2\uffff\1\3\12\uffff"+
            "\1\3\1\uffff\1\2\6\uffff\1\3\16\uffff\1\3\16\uffff\1\3\13\uffff"+
            "\1\3\2\uffff\1\3\6\uffff\1\3\5\uffff\1\3\32\uffff\1\3\11\uffff"+
            "\1\3",
            "\1\5\41\uffff\1\4",
            "",
            "\1\7\41\uffff\1\5\25\uffff\1\10",
            "",
            "",
            "\1\11",
            "",
            "\1\7\41\uffff\1\5\25\uffff\1\10"
    };

    static final short[] DFA7_eot = DFA.unpackEncodedString(DFA7_eotS);
    static final short[] DFA7_eof = DFA.unpackEncodedString(DFA7_eofS);
    static final char[] DFA7_min = DFA.unpackEncodedStringToUnsignedChars(DFA7_minS);
    static final char[] DFA7_max = DFA.unpackEncodedStringToUnsignedChars(DFA7_maxS);
    static final short[] DFA7_accept = DFA.unpackEncodedString(DFA7_acceptS);
    static final short[] DFA7_special = DFA.unpackEncodedString(DFA7_specialS);
    static final short[][] DFA7_transition;

    static {
        int numStates = DFA7_transitionS.length;
        DFA7_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA7_transition[i] = DFA.unpackEncodedString(DFA7_transitionS[i]);
        }
    }

    class DFA7 extends DFA {

        public DFA7(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 7;
            this.eot = DFA7_eot;
            this.eof = DFA7_eof;
            this.min = DFA7_min;
            this.max = DFA7_max;
            this.accept = DFA7_accept;
            this.special = DFA7_special;
            this.transition = DFA7_transition;
        }
        public String getDescription() {
            return "254:1: statementElement : ( updateStatement | deleteStatement | insertStatement | selectStatement );";
        }
        public int specialStateTransition(int s, IntStream _input) throws NoViableAltException {
            TokenStream input = (TokenStream)_input;
        	int _s = s;
            switch ( s ) {
                    case 0 : 
                        int LA7_1 = input.LA(1);

                         
                        int index7_1 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (LA7_1==IDENTIFIER) && ((((validateSoftKeyword("select")))||((validateSoftKeyword("update")))||((validateSoftKeyword("delete")))||((validateSoftKeyword("from")))||((validateSoftKeyword("insert")))))) {s = 2;}

                        else if ( (LA7_1==CHARACTER_LITERAL||LA7_1==COLON||LA7_1==DECIMAL_LITERAL||LA7_1==FALSE||LA7_1==FLOATING_POINT_LITERAL||LA7_1==HEX_LITERAL||LA7_1==INTEGER_LITERAL||LA7_1==LEFT_PAREN||LA7_1==MINUS||LA7_1==NULL||LA7_1==OCTAL_LITERAL||LA7_1==PARAM||LA7_1==PLUS||LA7_1==STRING_LITERAL||LA7_1==TRUE) && (((validateSoftKeyword("select"))))) {s = 3;}

                         
                        input.seek(index7_1);

                        if ( s>=0 ) return s;
                        break;
                    case 1 : 
                        int LA7_9 = input.LA(1);

                         
                        int index7_9 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (LA7_9==IDENTIFIER) && (((validateSoftKeyword("update"))))) {s = 5;}

                        else if ( (LA7_9==DOT) && ((((validateSoftKeyword("update")))||((validateSoftKeyword("insert")))))) {s = 7;}

                        else if ( (LA7_9==LEFT_PAREN) && (((validateSoftKeyword("insert"))))) {s = 8;}

                         
                        input.seek(index7_9);

                        if ( s>=0 ) return s;
                        break;
                    case 2 : 
                        int LA7_2 = input.LA(1);

                         
                        int index7_2 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (LA7_2==IDENTIFIER) && ((((validateSoftKeyword("update")))||((validateSoftKeyword("insert")))))) {s = 4;}

                        else if ( (LA7_2==DOT) && (((validateSoftKeyword("update"))))) {s = 5;}

                        else if ( (((validateSoftKeyword("delete")))) ) {s = 6;}

                        else if ( ((((validateSoftKeyword("select")))||((validateSoftKeyword("from"))))) ) {s = 3;}

                         
                        input.seek(index7_2);

                        if ( s>=0 ) return s;
                        break;
                    case 3 : 
                        int LA7_0 = input.LA(1);

                         
                        int index7_0 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (LA7_0==IDENTIFIER) && ((((validateSoftKeyword("select")))||((validateSoftKeyword("update")))||((validateSoftKeyword("delete")))||((validateSoftKeyword("from")))||((validateSoftKeyword("insert")))))) {s = 1;}

                         
                        input.seek(index7_0);

                        if ( s>=0 ) return s;
                        break;
                    case 4 : 
                        int LA7_7 = input.LA(1);

                         
                        int index7_7 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (LA7_7==IDENTIFIER) && ((((validateSoftKeyword("update")))||((validateSoftKeyword("insert")))))) {s = 9;}

                         
                        input.seek(index7_7);

                        if ( s>=0 ) return s;
                        break;
                    case 5 : 
                        int LA7_4 = input.LA(1);

                         
                        int index7_4 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (LA7_4==IDENTIFIER) && (((validateSoftKeyword("update"))))) {s = 5;}

                        else if ( (LA7_4==DOT) && ((((validateSoftKeyword("update")))||((validateSoftKeyword("insert")))))) {s = 7;}

                        else if ( (LA7_4==LEFT_PAREN) && (((validateSoftKeyword("insert"))))) {s = 8;}

                         
                        input.seek(index7_4);

                        if ( s>=0 ) return s;
                        break;
            }
            if (state.backtracking>0) {state.failed=true; return -1;}

            NoViableAltException nvae =
                new NoViableAltException(getDescription(), 7, _s, input);
            error(nvae);
            throw nvae;
        }

    }
 

    public static final BitSet FOLLOW_selectClause_in_filterStatement59 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000800L});
    public static final BitSet FOLLOW_from_key_in_filterStatement62 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000800L});
    public static final BitSet FOLLOW_whereClause_in_filterStatement65 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000800L});
    public static final BitSet FOLLOW_groupByClause_in_filterStatement70 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000800L});
    public static final BitSet FOLLOW_havingClause_in_filterStatement72 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000800L});
    public static final BitSet FOLLOW_orderByClause_in_filterStatement77 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_statementElement_in_statement142 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_updateStatement_in_statementElement153 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_deleteStatement_in_statementElement158 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_insertStatement_in_statementElement163 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_selectStatement_in_statementElement168 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_update_key_in_updateStatement181 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_versioned_key_in_updateStatement186 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_from_key_in_updateStatement195 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_entityName_in_updateStatement198 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_aliasClause_in_updateStatement200 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_setClause_in_updateStatement203 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000800L});
    public static final BitSet FOLLOW_whereClause_in_updateStatement205 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_key_in_setClause224 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_assignment_in_setClause226 = new BitSet(new long[]{0x0000000020000002L});
    public static final BitSet FOLLOW_COMMA_in_setClause229 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_assignment_in_setClause231 = new BitSet(new long[]{0x0000000020000002L});
    public static final BitSet FOLLOW_assignmentField_in_assignment276 = new BitSet(new long[]{0x0010000000000000L});
    public static final BitSet FOLLOW_EQUALS_in_assignment278 = new BitSet(new long[]{0x4800004004200000L,0x9001000200040A00L,0x0002008000001040L});
    public static final BitSet FOLLOW_concatenation_in_assignment281 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_dotIdentifierPath_in_assignmentField292 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_delete_key_in_deleteStatement311 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_from_key_in_deleteStatement313 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_entityName_in_deleteStatement316 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_aliasClause_in_deleteStatement318 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000800L});
    public static final BitSet FOLLOW_whereClause_in_deleteStatement321 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_insert_key_in_insertStatement339 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_intoClause_in_insertStatement344 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_selectStatement_in_insertStatement346 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_into_key_in_intoClause358 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_entityName_in_intoClause360 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
    public static final BitSet FOLLOW_insertabilitySpecification_in_intoClause362 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_LEFT_PAREN_in_insertabilitySpecification388 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_insertablePropertySpecification_in_insertabilitySpecification390 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0000000000800000L});
    public static final BitSet FOLLOW_COMMA_in_insertabilitySpecification394 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_insertablePropertySpecification_in_insertabilitySpecification396 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0000000000800000L});
    public static final BitSet FOLLOW_RIGHT_PAREN_in_insertabilitySpecification401 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_dotIdentifierPath_in_insertablePropertySpecification424 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_queryExpression_in_selectStatement443 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000800L});
    public static final BitSet FOLLOW_orderByClause_in_selectStatement445 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_querySpec_in_queryExpression471 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000800L});
    public static final BitSet FOLLOW_union_key_in_queryExpression477 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_intersect_key_in_queryExpression482 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_except_key_in_queryExpression487 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_all_key_in_queryExpression492 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_querySpec_in_queryExpression495 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000800L});
    public static final BitSet FOLLOW_selectFrom_in_querySpec509 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000800L});
    public static final BitSet FOLLOW_whereClause_in_querySpec511 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000800L});
    public static final BitSet FOLLOW_groupByClause_in_querySpec516 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000800L});
    public static final BitSet FOLLOW_havingClause_in_querySpec518 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_group_by_key_in_groupByClause552 = new BitSet(new long[]{0x4800004004200000L,0x9001000200040A00L,0x0002008000001040L});
    public static final BitSet FOLLOW_groupingSpecification_in_groupByClause555 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_having_key_in_havingClause566 = new BitSet(new long[]{0x4800004004200000L,0x9001000200040A00L,0x0002008000001040L});
    public static final BitSet FOLLOW_logicalExpression_in_havingClause569 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_groupingValue_in_groupingSpecification580 = new BitSet(new long[]{0x0000000020000002L});
    public static final BitSet FOLLOW_COMMA_in_groupingSpecification584 = new BitSet(new long[]{0x4800004004200000L,0x9001000200040A00L,0x0002008000001040L});
    public static final BitSet FOLLOW_groupingValue_in_groupingSpecification587 = new BitSet(new long[]{0x0000000020000002L});
    public static final BitSet FOLLOW_concatenation_in_groupingValue601 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000800L});
    public static final BitSet FOLLOW_collationSpecification_in_groupingValue603 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_where_key_in_whereClause628 = new BitSet(new long[]{0x4800004004200000L,0x9001000200040A00L,0x0002008000001040L});
    public static final BitSet FOLLOW_logicalExpression_in_whereClause631 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_selectClause_in_selectFrom644 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_fromClause_in_selectFrom649 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_queryExpression_in_subQuery676 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_from_key_in_fromClause718 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_persisterSpaces_in_fromClause724 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_persisterSpace_in_persisterSpaces737 = new BitSet(new long[]{0x0000000020000002L});
    public static final BitSet FOLLOW_COMMA_in_persisterSpaces741 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_persisterSpace_in_persisterSpaces745 = new BitSet(new long[]{0x0000000020000002L});
    public static final BitSet FOLLOW_persisterSpaceRoot_in_persisterSpace765 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000800L});
    public static final BitSet FOLLOW_qualifiedJoin_in_persisterSpace769 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000800L});
    public static final BitSet FOLLOW_crossJoin_in_persisterSpace773 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000800L});
    public static final BitSet FOLLOW_cross_key_in_crossJoin787 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_join_key_in_crossJoin789 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_mainEntityPersisterReference_in_crossJoin791 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_nonCrossJoinType_in_qualifiedJoin825 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_join_key_in_qualifiedJoin827 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_fetch_key_in_qualifiedJoin830 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_path_in_qualifiedJoin836 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_aliasClause_in_qualifiedJoin840 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000800L});
    public static final BitSet FOLLOW_on_key_in_qualifiedJoin846 = new BitSet(new long[]{0x4800004004200000L,0x9001000200040A00L,0x0002008000001040L});
    public static final BitSet FOLLOW_logicalExpression_in_qualifiedJoin853 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_propertyFetch_in_qualifiedJoin858 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000800L});
    public static final BitSet FOLLOW_withClause_in_qualifiedJoin861 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_with_key_in_withClause935 = new BitSet(new long[]{0x4800004004200000L,0x9001000200040A00L,0x0002008000001040L});
    public static final BitSet FOLLOW_logicalExpression_in_withClause938 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_inner_key_in_nonCrossJoinType949 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_outerJoinType_in_nonCrossJoinType954 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000800L});
    public static final BitSet FOLLOW_outer_key_in_nonCrossJoinType956 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_left_key_in_outerJoinType975 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_right_key_in_outerJoinType980 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_full_key_in_outerJoinType985 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_hibernateLegacySyntax_in_persisterSpaceRoot1004 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_jpaCollectionReference_in_persisterSpaceRoot1009 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_mainEntityPersisterReference_in_persisterSpaceRoot1014 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_entityName_in_mainEntityPersisterReference1030 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_aliasClause_in_mainEntityPersisterReference1034 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000800L});
    public static final BitSet FOLLOW_propertyFetch_in_mainEntityPersisterReference1037 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_fetch_key_in_propertyFetch1065 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_all_key_in_propertyFetch1067 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_properties_key_in_propertyFetch1069 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_aliasDeclaration_in_hibernateLegacySyntax1103 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_in_key_in_hibernateLegacySyntax1105 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_class_key_in_hibernateLegacySyntax1110 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_entityName_in_hibernateLegacySyntax1112 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_collectionExpression_in_hibernateLegacySyntax1127 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_in_key_in_jpaCollectionReference1161 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
    public static final BitSet FOLLOW_LEFT_PAREN_in_jpaCollectionReference1163 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_propertyReference_in_jpaCollectionReference1165 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000800000L});
    public static final BitSet FOLLOW_RIGHT_PAREN_in_jpaCollectionReference1167 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_aliasClause_in_jpaCollectionReference1171 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_select_key_in_selectClause1199 = new BitSet(new long[]{0x4800004004200000L,0x9001000200040A00L,0x0002008000001040L});
    public static final BitSet FOLLOW_distinct_key_in_selectClause1202 = new BitSet(new long[]{0x4800004004200000L,0x9001000200040A00L,0x0002008000001040L});
    public static final BitSet FOLLOW_rootSelectExpression_in_selectClause1205 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rootDynamicInstantiation_in_rootSelectExpression1216 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_jpaSelectObjectSyntax_in_rootSelectExpression1221 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_explicitSelectList_in_rootSelectExpression1226 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_explicitSelectItem_in_explicitSelectList1237 = new BitSet(new long[]{0x0000000020000002L});
    public static final BitSet FOLLOW_COMMA_in_explicitSelectList1241 = new BitSet(new long[]{0x4800004004200000L,0x9001000200040A00L,0x0002008000001040L});
    public static final BitSet FOLLOW_explicitSelectItem_in_explicitSelectList1243 = new BitSet(new long[]{0x0000000020000002L});
    public static final BitSet FOLLOW_selectExpression_in_explicitSelectItem1268 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_expression_in_selectExpression1290 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_aliasClause_in_selectExpression1292 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_aliasDeclaration_in_aliasClause1344 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_as_key_in_aliasClause1349 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_aliasDeclaration_in_aliasClause1352 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_aliasDeclaration1363 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_aliasReference1379 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_new_key_in_rootDynamicInstantiation1395 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_dynamicInstantiationTarget_in_rootDynamicInstantiation1397 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
    public static final BitSet FOLLOW_LEFT_PAREN_in_rootDynamicInstantiation1399 = new BitSet(new long[]{0x4800004004200000L,0x9001000200040A00L,0x0002008000001040L});
    public static final BitSet FOLLOW_dynamicInstantiationArgs_in_rootDynamicInstantiation1401 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000800000L});
    public static final BitSet FOLLOW_RIGHT_PAREN_in_rootDynamicInstantiation1403 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_dotIdentifierPath_in_dynamicInstantiationTarget1429 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_dynamicInstantiationArg_in_dynamicInstantiationArgs1440 = new BitSet(new long[]{0x0000000020000002L});
    public static final BitSet FOLLOW_COMMA_in_dynamicInstantiationArgs1444 = new BitSet(new long[]{0x4800004004200000L,0x9001000200040A00L,0x0002008000001040L});
    public static final BitSet FOLLOW_dynamicInstantiationArg_in_dynamicInstantiationArgs1447 = new BitSet(new long[]{0x0000000020000002L});
    public static final BitSet FOLLOW_selectExpression_in_dynamicInstantiationArg1461 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rootDynamicInstantiation_in_dynamicInstantiationArg1474 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_object_key_in_jpaSelectObjectSyntax1493 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
    public static final BitSet FOLLOW_LEFT_PAREN_in_jpaSelectObjectSyntax1495 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_aliasReference_in_jpaSelectObjectSyntax1497 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000800000L});
    public static final BitSet FOLLOW_RIGHT_PAREN_in_jpaSelectObjectSyntax1499 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_order_by_key_in_orderByClause1520 = new BitSet(new long[]{0x4800004004200000L,0x9001000200040A00L,0x0002008000001040L});
    public static final BitSet FOLLOW_sortSpecification_in_orderByClause1523 = new BitSet(new long[]{0x0000000020000002L});
    public static final BitSet FOLLOW_COMMA_in_orderByClause1527 = new BitSet(new long[]{0x4800004004200000L,0x9001000200040A00L,0x0002008000001040L});
    public static final BitSet FOLLOW_sortSpecification_in_orderByClause1530 = new BitSet(new long[]{0x0000000020000002L});
    public static final BitSet FOLLOW_sortKey_in_sortSpecification1548 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000800L});
    public static final BitSet FOLLOW_collationSpecification_in_sortSpecification1550 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000800L});
    public static final BitSet FOLLOW_orderingSpecification_in_sortSpecification1554 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_concatenation_in_sortKey1614 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_collate_key_in_collationSpecification1625 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_collateName_in_collationSpecification1627 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_dotIdentifierPath_in_collateName1644 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ascending_key_in_orderingSpecification1655 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_descending_key_in_orderingSpecification1665 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_expression_in_logicalExpression1681 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_logicalOrExpression_in_expression1692 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_logicalAndExpression_in_logicalOrExpression1703 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000800L});
    public static final BitSet FOLLOW_or_key_in_logicalOrExpression1707 = new BitSet(new long[]{0x4800004004200000L,0x9001000200040A00L,0x0002008000001040L});
    public static final BitSet FOLLOW_logicalAndExpression_in_logicalOrExpression1710 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000800L});
    public static final BitSet FOLLOW_negatedExpression_in_logicalAndExpression1724 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000800L});
    public static final BitSet FOLLOW_and_key_in_logicalAndExpression1728 = new BitSet(new long[]{0x4800004004200000L,0x9001000200040A00L,0x0002008000001040L});
    public static final BitSet FOLLOW_negatedExpression_in_logicalAndExpression1731 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000800L});
    public static final BitSet FOLLOW_not_key_in_negatedExpression1745 = new BitSet(new long[]{0x4800004004200000L,0x9001000200040A00L,0x0002008000001040L});
    public static final BitSet FOLLOW_negatedExpression_in_negatedExpression1748 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_equalityExpression_in_negatedExpression1753 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_relationalExpression_in_equalityExpression1769 = new BitSet(new long[]{0x0010000000000002L,0x0100000000000800L});
    public static final BitSet FOLLOW_is_key_in_equalityExpression1779 = new BitSet(new long[]{0x0000000000000000L,0x1000000000000800L});
    public static final BitSet FOLLOW_not_key_in_equalityExpression1782 = new BitSet(new long[]{0x0000000000000000L,0x1000000000000800L});
    public static final BitSet FOLLOW_NULL_in_equalityExpression1789 = new BitSet(new long[]{0x0010000000000002L,0x0100000000000800L});
    public static final BitSet FOLLOW_empty_key_in_equalityExpression1793 = new BitSet(new long[]{0x0010000000000002L,0x0100000000000800L});
    public static final BitSet FOLLOW_EQUALS_in_equalityExpression1855 = new BitSet(new long[]{0x4800004004200000L,0x9001000200040A00L,0x0002008000001040L});
    public static final BitSet FOLLOW_NOT_EQUAL_in_equalityExpression1861 = new BitSet(new long[]{0x4800004004200000L,0x9001000200040A00L,0x0002008000001040L});
    public static final BitSet FOLLOW_relationalExpression_in_equalityExpression1865 = new BitSet(new long[]{0x0010000000000002L,0x0100000000000800L});
    public static final BitSet FOLLOW_concatenation_in_relationalExpression1900 = new BitSet(new long[]{0x0000000000000002L,0x0000003000000818L});
    public static final BitSet FOLLOW_LESS_in_relationalExpression1917 = new BitSet(new long[]{0x4800004004200000L,0x9001000200040A00L,0x0002008000001040L});
    public static final BitSet FOLLOW_GREATER_in_relationalExpression1923 = new BitSet(new long[]{0x4800004004200000L,0x9001000200040A00L,0x0002008000001040L});
    public static final BitSet FOLLOW_LESS_EQUAL_in_relationalExpression1929 = new BitSet(new long[]{0x4800004004200000L,0x9001000200040A00L,0x0002008000001040L});
    public static final BitSet FOLLOW_GREATER_EQUAL_in_relationalExpression1935 = new BitSet(new long[]{0x4800004004200000L,0x9001000200040A00L,0x0002008000001040L});
    public static final BitSet FOLLOW_additiveExpression_in_relationalExpression1939 = new BitSet(new long[]{0x0000000000000002L,0x0000003000000018L});
    public static final BitSet FOLLOW_not_key_in_relationalExpression1966 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_in_key_in_relationalExpression1977 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000800L});
    public static final BitSet FOLLOW_inList_in_relationalExpression1979 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_between_key_in_relationalExpression2016 = new BitSet(new long[]{0x4800004004200000L,0x9001000200040A00L,0x0002008000001040L});
    public static final BitSet FOLLOW_betweenList_in_relationalExpression2018 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_like_key_in_relationalExpression2055 = new BitSet(new long[]{0x4800004004200000L,0x9001000200040A00L,0x0002008000001040L});
    public static final BitSet FOLLOW_concatenation_in_relationalExpression2057 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000800L});
    public static final BitSet FOLLOW_likeEscape_in_relationalExpression2059 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_member_of_key_in_relationalExpression2103 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_path_in_relationalExpression2105 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_escape_key_in_likeEscape2163 = new BitSet(new long[]{0x4800004004200000L,0x9001000200040A00L,0x0002008000001040L});
    public static final BitSet FOLLOW_concatenation_in_likeEscape2166 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_collectionExpression_in_inList2177 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_LEFT_PAREN_in_inList2192 = new BitSet(new long[]{0x4800004004200000L,0x9001000200040A00L,0x0002008000001040L});
    public static final BitSet FOLLOW_subQuery_in_inList2199 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000800000L});
    public static final BitSet FOLLOW_concatenation_in_inList2203 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0000000000800000L});
    public static final BitSet FOLLOW_COMMA_in_inList2206 = new BitSet(new long[]{0x4800004004200000L,0x9001000200040A00L,0x0002008000001040L});
    public static final BitSet FOLLOW_concatenation_in_inList2208 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0000000000800000L});
    public static final BitSet FOLLOW_RIGHT_PAREN_in_inList2214 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_concatenation_in_betweenList2239 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_and_key_in_betweenList2241 = new BitSet(new long[]{0x4800004004200000L,0x9001000200040A00L,0x0002008000001040L});
    public static final BitSet FOLLOW_concatenation_in_betweenList2243 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_additiveExpression_in_concatenation2265 = new BitSet(new long[]{0x0000080000000002L});
    public static final BitSet FOLLOW_DOUBLE_PIPE_in_concatenation2268 = new BitSet(new long[]{0x4800004004200000L,0x9001000200040A00L,0x0002008000001040L});
    public static final BitSet FOLLOW_additiveExpression_in_concatenation2273 = new BitSet(new long[]{0x0000080000000002L});
    public static final BitSet FOLLOW_multiplyExpression_in_additiveExpression2288 = new BitSet(new long[]{0x0000000000000002L,0x0001000000000000L,0x0000000000001000L});
    public static final BitSet FOLLOW_PLUS_in_additiveExpression2294 = new BitSet(new long[]{0x4800004004200000L,0x9001000200040A00L,0x0002008000001040L});
    public static final BitSet FOLLOW_MINUS_in_additiveExpression2299 = new BitSet(new long[]{0x4800004004200000L,0x9001000200040A00L,0x0002008000001040L});
    public static final BitSet FOLLOW_multiplyExpression_in_additiveExpression2306 = new BitSet(new long[]{0x0000000000000002L,0x0001000000000000L,0x0000000000001000L});
    public static final BitSet FOLLOW_unaryExpression_in_multiplyExpression2321 = new BitSet(new long[]{0x0000000000002002L,0x0000000000000000L,0x0000000800000000L});
    public static final BitSet FOLLOW_ASTERISK_in_multiplyExpression2327 = new BitSet(new long[]{0x4800004004200000L,0x9001000200040A00L,0x0002008000001040L});
    public static final BitSet FOLLOW_SOLIDUS_in_multiplyExpression2332 = new BitSet(new long[]{0x4800004004200000L,0x9001000200040A00L,0x0002008000001040L});
    public static final BitSet FOLLOW_unaryExpression_in_multiplyExpression2339 = new BitSet(new long[]{0x0000000000002002L,0x0000000000000000L,0x0000000800000000L});
    public static final BitSet FOLLOW_MINUS_in_unaryExpression2354 = new BitSet(new long[]{0x4800004004200000L,0x9001000200040