/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.tree.Tree;
import org.hibernate.hql.ast.common.JoinType;
import org.hibernate.hql.ast.origin.hql.resolve.path.PropertyPath;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.ast.spi.QueryRendererDelegate;
import org.hibernate.hql.ast.spi.SingleEntityQueryBuilder;
import org.hibernate.hql.ast.spi.predicate.ComparisonPredicate;
import org.hibernate.hql.internal.logging.Log;
import org.hibernate.hql.internal.logging.LoggerFactory;

public abstract class SingleEntityQueryRendererDelegate<Q, R>
implements QueryRendererDelegate<R> {
    protected static final String SORT_ASC_SPEC = "asc";
    private static final Log log = LoggerFactory.make();
    protected Status status;
    protected String targetTypeName;
    protected Class<?> targetType;
    protected PropertyPath propertyPath;
    protected final SingleEntityQueryBuilder<Q> builder;
    protected final List<String> projections = new ArrayList<String>();
    protected final Map<String, String> aliasToEntityType = new HashMap<String, String>();
    protected final Map<String, PropertyPath> aliasToPropertyPath = new HashMap<String, PropertyPath>();
    protected String alias;
    private final Map<String, Object> namedParameters;
    private final EntityNamesResolver entityNames;

    public SingleEntityQueryRendererDelegate(EntityNamesResolver entityNames, SingleEntityQueryBuilder<Q> builder, Map<String, Object> namedParameters) {
        this.entityNames = entityNames;
        this.namedParameters = namedParameters != null ? namedParameters : Collections.emptyMap();
        this.builder = builder;
    }

    @Override
    public void registerPersisterSpace(Tree entityName, Tree alias) {
        this.registerAlias(entityName.getText(), alias.getText());
        this.setTargetTypeName(entityName.getText());
        this.setTargetType(entityName.getText());
        this.builder.setEntityType(this.targetTypeName);
    }

    private void registerAlias(String entityName, String alias) {
        String put = this.aliasToEntityType.put(alias, entityName);
        if (put != null && !put.equalsIgnoreCase(entityName)) {
            throw new UnsupportedOperationException("Alias reuse currently not supported: alias " + alias + " already assigned to type " + put);
        }
    }

    public void registerEmbeddedAlias(String alias, PropertyPath propertyPath) {
        PropertyPath put = this.aliasToPropertyPath.put(alias, propertyPath);
        if (put != null) {
            throw new UnsupportedOperationException("Alias reuse currently not supported: alias " + alias + " already assigned to type " + put);
        }
    }

    private void setTargetType(String entityName) {
        Class<?> targetedType = this.entityNames.getClassFromName(entityName);
        if (targetedType == null) {
            throw new IllegalStateException("Unknown entity name " + entityName);
        }
        this.targetType = targetedType;
    }

    private void setTargetTypeName(String entityName) {
        if (this.targetTypeName != null) {
            throw new IllegalStateException("Can't target multiple types: " + this.targetTypeName + " already selected before " + entityName);
        }
        this.targetTypeName = entityName;
    }

    @Override
    public boolean isUnqualifiedPropertyReference() {
        return true;
    }

    @Override
    public boolean isPersisterReferenceAlias() {
        return this.aliasToEntityType.containsKey(this.alias);
    }

    @Override
    public void pushFromStrategy(JoinType joinType, Tree assosiationFetchTree, Tree propertyFetchTree, Tree alias) {
        this.status = Status.DEFINING_FROM;
        this.alias = alias.getText();
    }

    @Override
    public void pushSelectStrategy() {
        this.status = Status.DEFINING_SELECT;
    }

    @Override
    public void pushOrderByStrategy() {
        this.status = Status.DEFINING_ORDER_BY;
    }

    @Override
    public void popStrategy() {
        this.status = null;
        this.alias = null;
    }

    @Override
    public void activateOR() {
        this.builder.pushOrPredicate();
    }

    @Override
    public void activateAND() {
        this.builder.pushAndPredicate();
    }

    @Override
    public void activateNOT() {
        this.builder.pushNotPredicate();
    }

    @Override
    public void predicateLess(String comparativePredicate) {
        this.addComparisonPredicate(comparativePredicate, ComparisonPredicate.Type.LESS);
    }

    @Override
    public void predicateLessOrEqual(String comparativePredicate) {
        this.addComparisonPredicate(comparativePredicate, ComparisonPredicate.Type.LESS_OR_EQUAL);
    }

    @Override
    public void predicateEquals(String comparativePredicate) {
        this.addComparisonPredicate(comparativePredicate, ComparisonPredicate.Type.EQUALS);
    }

    @Override
    public void predicateNotEquals(String comparativePredicate) {
        this.builder.pushNotPredicate();
        this.addComparisonPredicate(comparativePredicate, ComparisonPredicate.Type.EQUALS);
        this.builder.popBooleanPredicate();
    }

    @Override
    public void predicateGreaterOrEqual(String comparativePredicate) {
        this.addComparisonPredicate(comparativePredicate, ComparisonPredicate.Type.GREATER_OR_EQUAL);
    }

    @Override
    public void predicateGreater(String comparativePredicate) {
        this.addComparisonPredicate(comparativePredicate, ComparisonPredicate.Type.GREATER);
    }

    private void addComparisonPredicate(String comparativePredicate, ComparisonPredicate.Type comparisonType) {
        Object comparisonValue = this.fromNamedQuery(comparativePredicate);
        List<String> property = this.resolveAlias(this.propertyPath);
        this.builder.addComparisonPredicate(property, comparisonType, comparisonValue);
    }

    @Override
    public void predicateIn(List<String> list) {
        List<Object> values = this.fromNamedQuery(list);
        List<String> property = this.resolveAlias(this.propertyPath);
        this.builder.addInPredicate(property, values);
    }

    @Override
    public void predicateBetween(String lower, String upper) {
        Object lowerComparisonValue = this.fromNamedQuery(lower);
        Object upperComparisonValue = this.fromNamedQuery(upper);
        List<String> property = this.resolveAlias(this.propertyPath);
        this.builder.addRangePredicate(property, lowerComparisonValue, upperComparisonValue);
    }

    @Override
    public void predicateLike(String patternValue, Character escapeCharacter) {
        Object pattern = this.fromNamedQuery(patternValue);
        List<String> property = this.resolveAlias(this.propertyPath);
        this.builder.addLikePredicate(property, (String)pattern, escapeCharacter);
    }

    @Override
    public void predicateIsNull() {
        List<String> property = this.resolveAlias(this.propertyPath);
        this.builder.addIsNullPredicate(property);
    }

    @Override
    public void sortSpecification(String collateName, String orderSpec) {
        this.addSortField(this.propertyPath, collateName, SORT_ASC_SPEC.equals(orderSpec));
    }

    protected abstract void addSortField(PropertyPath var1, String var2, boolean var3);

    private Object fromNamedQuery(String comparativePredicate) {
        if (comparativePredicate.startsWith(":")) {
            return this.namedParameters.get(comparativePredicate.substring(1));
        }
        return comparativePredicate;
    }

    private List<Object> fromNamedQuery(List<String> list) {
        ArrayList<Object> elements = new ArrayList<Object>(list.size());
        for (String string : list) {
            elements.add(this.fromNamedQuery(string));
        }
        return elements;
    }

    @Override
    public void deactivateBoolean() {
        this.builder.popBooleanPredicate();
    }

    @Override
    public abstract R getResult();

    protected List<String> resolveAlias(PropertyPath path) {
        if (path.getFirstNode().isAlias()) {
            String alias = path.getFirstNode().getName();
            if (this.aliasToEntityType.containsKey(alias)) {
                return path.getNodeNamesWithoutAlias();
            }
            if (this.aliasToPropertyPath.containsKey(alias)) {
                PropertyPath propertyPath = this.aliasToPropertyPath.get(alias);
                List<String> resolvedAlias = this.resolveAlias(propertyPath);
                resolvedAlias.addAll(path.getNodeNamesWithoutAlias());
                return resolvedAlias;
            }
            this.aliasNotFound(alias);
        }
        return path.getNodeNamesWithoutAlias();
    }

    @Override
    public void registerJoinAlias(Tree alias, PropertyPath path) {
        if (!this.aliasToPropertyPath.containsKey(alias)) {
            this.aliasToPropertyPath.put(alias.getText(), path);
        }
    }

    public void aliasNotFound(String alias) {
        throw log.getUnknownAliasException(alias);
    }

    protected static enum Status {
        DEFINING_SELECT,
        DEFINING_FROM,
        DEFINING_ORDER_BY;

    }
}

