/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.testing.internal.junit;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.hql.testing.internal.junit.GrammarRuleStatement;
import org.hibernate.hql.testing.internal.junit.GrammarRuleTest;
import org.hibernate.hql.testing.internal.model.GrammarRuleTestDescriptor;
import org.hibernate.hql.testing.internal.model.GrammarRuleTestGroupDescriptor;
import org.hibernate.hql.testing.internal.model.GrammarTestDescriptor;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class GrammarRuleStatements
extends ParentRunner<GrammarRuleTest>
implements GrammarRuleTest {
    private final List<GrammarRuleTest> children;
    private final String name;

    public GrammarRuleStatements(Class<?> testClass, GrammarTestDescriptor grammarTest, GrammarRuleTestGroupDescriptor group) throws InitializationError {
        this(testClass, grammarTest, group, group);
    }

    private GrammarRuleStatements(Class<?> testClass, GrammarTestDescriptor grammarTest, GrammarRuleTestGroupDescriptor group, GrammarRuleTestGroupDescriptor rootGroup) throws InitializationError {
        super(testClass);
        this.name = group.getName();
        this.children = new ArrayList<GrammarRuleTest>();
        for (GrammarRuleTestDescriptor test : group.getTests()) {
            this.children.add(new GrammarRuleStatement(this.getTestClass(), grammarTest, rootGroup, test));
        }
        for (GrammarRuleTestGroupDescriptor subGroup : group.getSubGroups()) {
            this.children.add(new GrammarRuleStatements(testClass, grammarTest, subGroup, rootGroup));
        }
    }

    protected List<GrammarRuleTest> getChildren() {
        return this.children;
    }

    protected Description describeChild(GrammarRuleTest child) {
        return child.getDescription();
    }

    protected void runChild(GrammarRuleTest child, RunNotifier notifier) {
        child.run(this, notifier);
    }

    @Override
    public void run(GrammarRuleStatements parent, RunNotifier notifier) {
        this.run(notifier);
    }

    public void runLeafNode(Statement statement, Description description, RunNotifier notifier) {
        this.runLeaf(statement, description, notifier);
    }

    protected String getName() {
        return this.name;
    }

    protected Statement classBlock(RunNotifier notifier) {
        return this.childrenInvoker(notifier);
    }
}

