/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.testing.junit;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.hql.testing.ForGrammar;
import org.hibernate.hql.testing.internal.junit.GrammarRuleStatements;
import org.hibernate.hql.testing.internal.model.GrammarRuleTestGroupDescriptor;
import org.hibernate.hql.testing.internal.model.GrammarTestDescriptor;
import org.hibernate.hql.testing.internal.parser.GrammarTestParser;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;

public class GrammarTestRunner
extends ParentRunner<Runner> {
    private final List<Runner> runners;

    public GrammarTestRunner(Class<?> testClass) throws InitializationError {
        super(testClass);
        String grammarFileName = this.getGrammarFileName(testClass);
        GrammarTestDescriptor grammarTest = new GrammarTestParser().getGrammarTest(testClass, grammarFileName);
        this.runners = this.getRunners(testClass, grammarTest);
    }

    private String getGrammarFileName(Class<?> testClass) throws InitializationError {
        ForGrammar forGrammar = testClass.getAnnotation(ForGrammar.class);
        if (forGrammar == null) {
            throw new InitializationError("A grammar test file must be specified via @" + ForGrammar.class.getSimpleName() + ".");
        }
        return forGrammar.value();
    }

    private List<Runner> getRunners(Class<?> testClass, GrammarTestDescriptor grammarTest) throws InitializationError {
        ArrayList<Runner> runners = new ArrayList<Runner>();
        for (GrammarRuleTestGroupDescriptor group : grammarTest.getTestGroups()) {
            runners.add((Runner)new GrammarRuleStatements(testClass, grammarTest, group));
        }
        return runners;
    }

    protected List<Runner> getChildren() {
        return this.runners;
    }

    protected Description describeChild(Runner child) {
        return child.getDescription();
    }

    protected void runChild(Runner child, RunNotifier notifier) {
        child.run(notifier);
    }
}

