/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.infra.asciidoctor.extensions.customnumbering;

import java.util.HashMap;
import java.util.Map;
import org.asciidoctor.ast.Document;
import org.asciidoctor.ast.Section;
import org.asciidoctor.ast.StructuralNode;
import org.asciidoctor.ast.Table;
import org.asciidoctor.extension.Treeprocessor;
import org.asciidoctor.internal.RubyObjectWrapper;
import org.jruby.Ruby;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.runtime.builtin.IRubyObject;

public class CustomNumberingProcessor
extends Treeprocessor {
    private static final String NOT_NUMBERED_SECTION_NUMBER = "-1";
    private final Map<String, SectionNumberingIndexes> sectionNumberingIndexesMap = new HashMap<String, SectionNumberingIndexes>();

    public CustomNumberingProcessor() {
    }

    public CustomNumberingProcessor(Map<String, Object> config) {
        super(config);
    }

    public Document process(Document document) {
        document.getBlocks().stream().filter(block -> block instanceof Section).forEach(block -> this.processSection((Section)block, this.getSectionNumberingIndexes(this.getSectionNumber((Section)block))));
        return document;
    }

    private void processSection(Section section, SectionNumberingIndexes indexes) {
        for (StructuralNode node : section.getBlocks()) {
            if ("example".equalsIgnoreCase(node.getNodeName())) {
                this.updateBlockCaption(node, "Example", indexes.getSectionNumber(), indexes.newExampleIndex());
                continue;
            }
            if (node instanceof Table) {
                this.updateBlockCaption(node, "Table", indexes.getSectionNumber(), indexes.newTableIndex());
                continue;
            }
            if (!(node instanceof Section)) continue;
            this.processSection((Section)node, indexes);
        }
    }

    private void updateBlockCaption(StructuralNode block, String title, String sectionNumber, int indexNumber) {
        if (!(block instanceof RubyObjectWrapper)) {
            throw new IllegalStateException(String.format("%s block is not extended from RubyObjectWrapper. Processor cannot proceed.", title));
        }
        RubyObject rubyObject = this.toRubyObject((RubyObjectWrapper)block);
        rubyObject.setInstanceVariable("@caption", (IRubyObject)RubyString.newString((Ruby)Ruby.getGlobalRuntime(), (String)(sectionNumber == NOT_NUMBERED_SECTION_NUMBER ? String.format("%s %d: ", title, indexNumber) : String.format("%s %s.%d: ", title, sectionNumber, indexNumber))));
    }

    private String getSectionNumber(Section section) {
        return section.isNumbered() ? this.toRubyObject((RubyObjectWrapper)section).getInstanceVariable("@number").toString() : NOT_NUMBERED_SECTION_NUMBER;
    }

    private RubyObject toRubyObject(RubyObjectWrapper block) {
        return (RubyObject)block.getRubyObject();
    }

    private SectionNumberingIndexes getSectionNumberingIndexes(String sectionNumber) {
        return this.sectionNumberingIndexesMap.computeIfAbsent(sectionNumber, sn -> new SectionNumberingIndexes((String)sn));
    }

    private static class SectionNumberingIndexes {
        private final String sectionNumber;
        private int exampleIndex;
        private int tableIndex;

        public SectionNumberingIndexes(String sectionNumber) {
            this.sectionNumber = sectionNumber;
            this.exampleIndex = 1;
            this.tableIndex = 1;
        }

        public String getSectionNumber() {
            return this.sectionNumber;
        }

        public int newExampleIndex() {
            return this.exampleIndex++;
        }

        public int newTableIndex() {
            return this.tableIndex++;
        }
    }
}

