/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.infra.asciidoctor.extensions.customroleblock;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.asciidoctor.ast.Document;
import org.asciidoctor.ast.StructuralNode;
import org.asciidoctor.extension.BlockProcessor;
import org.asciidoctor.extension.Reader;

public class DocBookCustomRoleBlockProcessor
extends BlockProcessor {
    public DocBookCustomRoleBlockProcessor(String name, Map<String, Object> config) {
        super(name, DocBookCustomRoleBlockProcessor.addConfiguration(config));
    }

    public Object process(StructuralNode parent, Reader reader, Map<String, Object> attributes) {
        List lines = reader.readLines();
        Document document = parent.getDocument();
        String backend = String.valueOf(document.getAttr((Object)"backend"));
        if (!backend.startsWith("docbook")) {
            throw new IllegalStateException(DocBookCustomRoleBlockProcessor.class.getSimpleName() + " may only be used with the docbook backend. Backend is " + backend + ".");
        }
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("content_model", ":compound");
        attributes.put("role", this.getName());
        return this.createBlock(parent, "paragraph", lines, attributes, options);
    }

    private static Map<String, Object> addConfiguration(Map<String, Object> config) {
        config.put("contexts", Arrays.asList(":open", ":compound", ":simple", ":verbatim", ":paragraph", ":role"));
        return config;
    }
}

