/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.infra.asciidoctor.extensions.savepreprocessed;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.asciidoctor.ast.Document;
import org.asciidoctor.extension.Preprocessor;
import org.asciidoctor.extension.PreprocessorReader;

public class SavePreprocessedOutputPreprocessor
extends Preprocessor {
    private static final String OUTPUT_FILE = "target/preprocessed/beanvalidation-specification-full.adoc";
    private static final List<String> FILTER_LICENSE_MARKERS = Arrays.asList("[preface]", "<<<");
    private static final String COMMENT_MARKER = "//";
    private static final String SOURCE_MARKER = "[source";
    private static final List<String> SECTION_MARKERS = Arrays.asList("----", "....");

    public SavePreprocessedOutputPreprocessor(Map<String, Object> config) {
        super(config);
    }

    public void process(Document document, PreprocessorReader reader) {
        try {
            Files.write(Paths.get(OUTPUT_FILE, new String[0]), this.filterLines(reader.readLines()), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write the preprocessed file target/preprocessed/beanvalidation-specification-full.adoc", e);
        }
    }

    private List<String> filterLines(List<String> lines) {
        ArrayList<String> filteredLines = new ArrayList<String>();
        ParsingState state = ParsingState.NORMAL;
        block6: for (String line : lines) {
            switch (state) {
                case NORMAL: {
                    if (FILTER_LICENSE_MARKERS.contains(line)) {
                        state = ParsingState.FILTER_LICENSE;
                        break;
                    }
                    if (!line.startsWith(SOURCE_MARKER)) break;
                    state = ParsingState.SOURCE;
                    break;
                }
                case SOURCE: {
                    if (SECTION_MARKERS.contains(line)) {
                        state = ParsingState.SOURCE_CONTENT;
                        break;
                    }
                    throw new IllegalStateException("[source] requires to be followed by a section marker");
                }
                case SOURCE_CONTENT: {
                    if (SECTION_MARKERS.contains(line)) {
                        state = ParsingState.NORMAL;
                        break;
                    }
                    filteredLines.add(line.replaceAll("\t", "    "));
                    continue block6;
                }
                case FILTER_LICENSE: {
                    if (line.startsWith(COMMENT_MARKER)) continue block6;
                    state = ParsingState.NORMAL;
                }
            }
            filteredLines.add(line);
        }
        return filteredLines;
    }

    private static enum ParsingState {
        NORMAL,
        FILTER_LICENSE,
        SOURCE,
        SOURCE_CONTENT;

    }
}

