/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.infra.asciidoctor.extensions.customnumbering;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.asciidoctor.ast.Document;
import org.asciidoctor.ast.Section;
import org.asciidoctor.ast.StructuralNode;
import org.asciidoctor.ast.Table;
import org.asciidoctor.extension.Treeprocessor;
import org.asciidoctor.internal.RubyObjectWrapper;
import org.jruby.Ruby;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.runtime.builtin.IRubyObject;

public class CustomNumberingProcessor
extends Treeprocessor {
    private static final String NOT_NUMBERED_SECTION_NUMBER = "-1";
    private static final List<String> LISTING_ROLES = Arrays.asList("listing", "api");
    private final Map<String, SectionNumberingIndexes> sectionNumberingIndexesMap = new HashMap<String, SectionNumberingIndexes>();

    public CustomNumberingProcessor() {
    }

    public CustomNumberingProcessor(Map<String, Object> config) {
        super(config);
    }

    public Document process(Document document) {
        document.getBlocks().stream().filter(block -> block instanceof Section).forEach(block -> this.processSection((Section)block, this.getSectionNumberingIndexes(this.getSectionNumber((Section)block))));
        return document;
    }

    private void processSection(Section section, SectionNumberingIndexes indexes) {
        for (StructuralNode node : section.getBlocks()) {
            if ("example".equalsIgnoreCase(node.getNodeName())) {
                if (this.isListing(node)) {
                    this.updateBlockCaption(node, "Listing", indexes.getSectionNumber(), indexes.newListingIndex());
                    continue;
                }
                this.updateBlockCaption(node, "Example", indexes.getSectionNumber(), indexes.newExampleIndex());
                continue;
            }
            if (node instanceof Table) {
                this.updateBlockCaption(node, "Table", indexes.getSectionNumber(), indexes.newTableIndex());
                continue;
            }
            if (!(node instanceof Section)) continue;
            this.processSection((Section)node, indexes);
        }
    }

    private void updateBlockCaption(StructuralNode block, String title, String sectionNumber, int indexNumber) {
        if (!(block instanceof RubyObjectWrapper)) {
            throw new IllegalStateException(String.format("%s block is not extended from RubyObjectWrapper. Processor cannot proceed.", title));
        }
        RubyObject rubyObject = this.toRubyObject((RubyObjectWrapper)block);
        String blockNumber = this.getBlockNumber(sectionNumber, indexNumber);
        rubyObject.setInstanceVariable("@caption", (IRubyObject)RubyString.newString((Ruby)Ruby.getGlobalRuntime(), (String)String.format("%s %s: ", title, blockNumber)));
        rubyObject.setInstanceVariable("@number", (IRubyObject)RubyString.newString((Ruby)Ruby.getGlobalRuntime(), (String)blockNumber));
    }

    private String getBlockNumber(String sectionNumber, int indexNumber) {
        return sectionNumber == NOT_NUMBERED_SECTION_NUMBER ? String.format("%d", indexNumber) : String.format("%s.%d", sectionNumber, indexNumber);
    }

    private String getSectionNumber(Section section) {
        return section.isNumbered() ? this.toRubyObject((RubyObjectWrapper)section).getInstanceVariable("@number").toString() : NOT_NUMBERED_SECTION_NUMBER;
    }

    private RubyObject toRubyObject(RubyObjectWrapper block) {
        return (RubyObject)block.getRubyObject();
    }

    private SectionNumberingIndexes getSectionNumberingIndexes(String sectionNumber) {
        return this.sectionNumberingIndexesMap.computeIfAbsent(sectionNumber, sn -> new SectionNumberingIndexes((String)sn));
    }

    private boolean isListing(StructuralNode block) {
        for (String listingRole : LISTING_ROLES) {
            if (!block.getRoles().contains(listingRole)) continue;
            return true;
        }
        return false;
    }

    private static class SectionNumberingIndexes {
        private final String sectionNumber;
        private int listingIndex;
        private int exampleIndex;
        private int tableIndex;

        public SectionNumberingIndexes(String sectionNumber) {
            this.sectionNumber = sectionNumber;
            this.listingIndex = 1;
            this.exampleIndex = 1;
            this.tableIndex = 1;
        }

        public String getSectionNumber() {
            return this.sectionNumber;
        }

        public int newListingIndex() {
            return this.listingIndex++;
        }

        public int newExampleIndex() {
            return this.exampleIndex++;
        }

        public int newTableIndex() {
            return this.tableIndex++;
        }
    }
}

