/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpql.lucene;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.antlr.runtime.tree.Tree;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.hibernate.jpql.lucene.LuceneQueryParsingResult;
import org.hibernate.query.ast.common.JoinType;
import org.hibernate.query.ast.origin.hql.resolve.path.PathedPropertyReference;
import org.hibernate.query.ast.origin.hql.resolve.path.PathedPropertyReferenceSource;
import org.hibernate.query.ast.spi.EntityNamesResolver;
import org.hibernate.query.ast.spi.QueryParserDelegate;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.query.dsl.impl.ConnectedQueryContextBuilder;

public class LuceneQueryBuilder
implements QueryParserDelegate<LuceneQueryParsingResult> {
    private final Map<String, String> aliasToEntityType = new HashMap<String, String>();
    private boolean definingSelectStrategy;
    private final SearchFactoryImplementor searchFactory;
    private final ConnectedQueryContextBuilder queryBuildContext;
    private final EntityNamesResolver entityNames;
    private Class<?> targetType = null;
    private BooleanQuery booleanQuery;
    private final Stack<BooleanQuery> booleanQueryStack = new Stack();
    private final Stack<BooleanClause.Occur> booleanQueryModeStack = new Stack();
    private BooleanClause.Occur booleanMode;
    private String propertyName;
    private Query rootQuery = new MatchAllDocsQuery();
    private final Map<String, Object> namedParameters;

    public LuceneQueryBuilder(SearchFactoryImplementor searchFactory, EntityNamesResolver entityNames) {
        this(searchFactory, entityNames, Collections.emptyMap());
    }

    public LuceneQueryBuilder(SearchFactoryImplementor searchFactory, EntityNamesResolver entityNames, Map<String, Object> namedParameters) {
        this.searchFactory = searchFactory;
        this.entityNames = entityNames;
        this.namedParameters = namedParameters;
        this.queryBuildContext = new ConnectedQueryContextBuilder(searchFactory);
    }

    public void registerPersisterSpace(Tree entityName, Tree alias) {
        String put = this.aliasToEntityType.put(alias.getText(), entityName.getText());
        if (put != null && !put.equalsIgnoreCase(entityName.getText())) {
            throw new UnsupportedOperationException("Alias reuse currently not supported: alias " + alias.getText() + " already assigned to type " + put);
        }
        Class targetedType = this.entityNames.getClassFromName(entityName.getText());
        if (targetedType == null) {
            throw new IllegalStateException("Unknown entity name " + entityName.getText());
        }
        if (this.targetType != null) {
            throw new IllegalStateException("Can't target multiple types: " + this.targetType + " already selected before " + targetedType);
        }
        this.targetType = targetedType;
    }

    public boolean isUnqualifiedPropertyReference() {
        return true;
    }

    public PathedPropertyReferenceSource normalizeUnqualifiedPropertyReference(Tree property) {
        this.propertyName = property.getText();
        return null;
    }

    public boolean isPersisterReferenceAlias() {
        if (this.aliasToEntityType.size() == 1) {
            return true;
        }
        throw new UnsupportedOperationException("Unexpected use case: not implemented yet?");
    }

    public PathedPropertyReferenceSource normalizeUnqualifiedRoot(Tree identifier382) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public PathedPropertyReferenceSource normalizeQualifiedRoot(Tree identifier381) {
        return new PathedPropertyReference(identifier381.getText(), this.aliasToEntityType);
    }

    public PathedPropertyReferenceSource normalizePropertyPathIntermediary(PathedPropertyReferenceSource source, Tree propertyName) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public PathedPropertyReferenceSource normalizeIntermediateIndexOperation(PathedPropertyReferenceSource propertyReferenceSource, Tree collectionProperty, Tree selector) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void normalizeTerminalIndexOperation(PathedPropertyReferenceSource propertyReferenceSource, Tree collectionProperty, Tree selector) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public PathedPropertyReferenceSource normalizeUnqualifiedPropertyReferenceSource(Tree identifier394) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public Tree normalizePropertyPathTerminus(PathedPropertyReferenceSource source, Tree propertyNameNode) {
        this.propertyName = propertyNameNode.toString();
        return null;
    }

    public void pushFromStrategy(JoinType joinType, Tree assosiationFetchTree, Tree propertyFetchTree, Tree alias) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void pushSelectStrategy() {
        this.definingSelectStrategy = true;
    }

    public void popStrategy() {
        this.definingSelectStrategy = false;
    }

    public void activateOR() {
        this.activateBoolean();
        this.booleanQuery = new BooleanQuery();
        this.booleanMode = BooleanClause.Occur.SHOULD;
    }

    public void activateAND() {
        this.activateBoolean();
        this.booleanQuery = new BooleanQuery();
        this.booleanMode = BooleanClause.Occur.MUST;
    }

    public void activateNOT() {
        this.activateBoolean();
        this.booleanQuery = new BooleanQuery();
        this.booleanMode = BooleanClause.Occur.MUST_NOT;
    }

    public void predicateEquals(String comparativePredicate) {
        String comparisonValue = this.valueToString(this.fromNamedQuery(comparativePredicate));
        TermQuery predicate = new TermQuery(new Term(this.propertyName, comparisonValue));
        this.setOrAppendQuery((Query)predicate);
    }

    public void predicateBetween(String lower, String upper) {
        String lowerComparisonValue = this.valueToString(this.fromNamedQuery(lower));
        String upperComparisonValue = this.valueToString(this.fromNamedQuery(upper));
        TermRangeQuery predicate = new TermRangeQuery(this.propertyName, lowerComparisonValue, upperComparisonValue, true, true);
        this.setOrAppendQuery((Query)predicate);
    }

    private void setOrAppendQuery(Query predicate) {
        if (this.booleanQuery != null) {
            this.booleanQuery.add(predicate, this.booleanMode);
        } else {
            this.rootQuery = predicate;
        }
    }

    private String valueToString(Object comparison) {
        return comparison.toString();
    }

    private Object fromNamedQuery(String comparativePredicate) {
        if (comparativePredicate.startsWith(":")) {
            return this.namedParameters.get(comparativePredicate.substring(1));
        }
        return comparativePredicate;
    }

    private void activateBoolean() {
        this.booleanQueryStack.push(this.booleanQuery);
        this.booleanQueryModeStack.push(this.booleanMode);
    }

    public void deactivateBoolean() {
        BooleanQuery currentBoolean = this.booleanQuery;
        this.booleanQuery = this.booleanQueryStack.pop();
        this.booleanMode = this.booleanQueryModeStack.pop();
        if (this.booleanQuery == null) {
            this.rootQuery = currentBoolean;
        } else {
            this.booleanQuery.add((Query)currentBoolean, this.booleanMode);
        }
    }

    public String toString() {
        return this.rootQuery.toString();
    }

    public LuceneQueryParsingResult getResult() {
        return new LuceneQueryParsingResult(this.rootQuery, this.targetType);
    }
}

