// $ANTLR 3.4.1-SNAPSHOT org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g 2012-09-26 15:50:58

/*
 * Hibernate, Relational Persistence for Idiomatic Java
 *
 * Copyright (c) 2008-2012, Red Hat Inc. or third-party contributors as
 * indicated by the @author tags or express copyright attribution
 * statements applied by the authors.  All third-party contributions are
 * distributed under license by Red Hat Inc.
 *
 * This copyrighted material is made available to anyone wishing to use, modify,
 * copy, or redistribute it subject to the terms and conditions of the GNU
 * Lesser General Public License, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this distribution; if not, write to:
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301  USA
 *
 * Portions of SQL grammar parsing copyright (C) 2003 by Lubos Vnuk.  All rights
 * reserved.  These portions are distributed under license by Red Hat Inc. and
 * are covered by the above LGPL notice.  If you redistribute this material,
 * with or without modification, you must preserve this copyright notice in its
 * entirety.
 */
package org.hibernate.sql.ast.origin.hql.resolve;

import org.antlr.runtime.tree.CommonTree;
import org.hibernate.sql.ast.common.JoinType;
import org.hibernate.sql.ast.origin.hql.resolve.path.PathedPropertyReferenceSource;


import org.antlr.runtime.*;
import org.antlr.runtime.tree.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;


@SuppressWarnings({"all", "warnings", "unchecked", "cast"})
public class GeneratedHQLResolver extends TreeParser {
	public static final String[] tokenNames = new String[] {
		"<invalid>", "<EOR>", "<DOWN>", "<UP>", "ABS", "ALIAS_NAME", "ALIAS_REF", "ALL", "AMPERSAND", "AND", "ANY", "ARROW", "AS", "ASTERISK", "AVG", "BETWEEN", "BETWEEN_LIST", "BIT_LENGTH", "BOTH", "CAST", "CHARACTER_LENGTH", "CHARACTER_LITERAL", "CLASS", "COALESCE", "COLLATE", "COLLECTION_EXPRESSION", "COLON", "COLUMN", "COLUMN_LIST", "COMMA", "CONCAT", "CONST_STRING_VALUE", "COUNT", "CROSS", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "DAY", "DECIMAL_LITERAL", "DELETE", "DISTINCT", "DOT", "DOT_CLASS", "DOUBLE_PIPE", "DYNAMIC_INSTANTIATION", "DYNAMIC_INSTANTIATION_ARG", "ELEMENTS", "ELSE", "END", "ENTITY_NAME", "ENTITY_PERSISTER_REF", "EOL", "EQUALS", "ESCAPE", "ESCAPE_SEQUENCE", "EXCEPT", "EXISTS", "EXPONENT", "EXTRACT", "FALSE", "FETCH", "FILTER", "FLOATING_POINT_LITERAL", "FLOAT_TYPE_SUFFIX", "FROM", "FULL", "FUNCTION", "GREATER", "GREATER_EQUAL", "GROUPING_VALUE", "GROUP_BY", "HAVING", "HEX_DIGIT", "HEX_LITERAL", "HOUR", "IDENTIFIER", "IN", "INDEX", "INDICES", "INNER", "INSERT", "INSERTABILITY_SPEC", "INTEGER_LITERAL", "INTEGER_TYPE_SUFFIX", "INTERSECT", "INTO", "IN_LIST", "IS", "IS_EMPTY", "IS_NOT_EMPTY", "IS_NOT_NULL", "IS_NULL", "JAVA_CONSTANT", "JOIN", "JPA_PARAM", "LEADING", "LEFT", "LEFT_PAREN", "LEFT_SQUARE", "LENGTH", "LESS", "LESS_EQUAL", "LIKE", "LOCATE", "LOWER", "MAX", "MAXELEMENT", "MAXINDEX", "MEMBER_OF", "MIN", "MINELEMENT", "MININDEX", "MINUS", "MINUTE", "MOD", "MONTH", "NAMED_PARAM", "NEW", "NOT", "NOT_BETWEEN", "NOT_EQUAL", "NOT_IN", "NOT_LIKE", "NOT_MEMBER_OF", "NULL", "NULLIF", "OCTAL_ESCAPE", "OCTAL_LITERAL", "OCTET_LENGTH", "ON", "OR", "ORDER_BY", "ORDER_SPEC", "OUTER", "PARAM", "PATH", "PERCENT", "PERSISTER_JOIN", "PERSISTER_SPACE", "PIPE", "PLUS", "POSITION", "PROPERTIES", "PROPERTY_JOIN", "PROPERTY_REFERENCE", "PROP_FETCH", "QUALIFIED_JOIN", "QUERY", "QUERY_SPEC", "QUOTED_IDENTIFIER", "RIGHT", "RIGHT_PAREN", "RIGHT_SQUARE", "SEARCHED_CASE", "SECOND", "SELECT", "SELECT_FROM", "SELECT_ITEM", "SELECT_LIST", "SEMICOLON", "SET", "SIMPLE_CASE", "SIZE", "SOLIDUS", "SOME", "SORT_SPEC", "SQRT", "STRING_LITERAL", "SUBSTRING", "SUB_QUERY", "SUM", "TABLE", "THEN", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TRAILING", "TRIM", "TRUE", "UNARY_MINUS", "UNARY_PLUS", "UNICODE_ESCAPE", "UNION", "UPDATE", "UPPER", "VECTOR_EXPR", "VERSIONED", "VERSIONED_VALUE", "WHEN", "WHERE", "WITH", "WS", "YEAR"
	};

	public static final int EOF=-1;
	public static final int ABS=4;
	public static final int ALIAS_NAME=5;
	public static final int ALIAS_REF=6;
	public static final int ALL=7;
	public static final int AMPERSAND=8;
	public static final int AND=9;
	public static final int ANY=10;
	public static final int ARROW=11;
	public static final int AS=12;
	public static final int ASTERISK=13;
	public static final int AVG=14;
	public static final int BETWEEN=15;
	public static final int BETWEEN_LIST=16;
	public static final int BIT_LENGTH=17;
	public static final int BOTH=18;
	public static final int CAST=19;
	public static final int CHARACTER_LENGTH=20;
	public static final int CHARACTER_LITERAL=21;
	public static final int CLASS=22;
	public static final int COALESCE=23;
	public static final int COLLATE=24;
	public static final int COLLECTION_EXPRESSION=25;
	public static final int COLON=26;
	public static final int COLUMN=27;
	public static final int COLUMN_LIST=28;
	public static final int COMMA=29;
	public static final int CONCAT=30;
	public static final int CONST_STRING_VALUE=31;
	public static final int COUNT=32;
	public static final int CROSS=33;
	public static final int CURRENT_DATE=34;
	public static final int CURRENT_TIME=35;
	public static final int CURRENT_TIMESTAMP=36;
	public static final int DAY=37;
	public static final int DECIMAL_LITERAL=38;
	public static final int DELETE=39;
	public static final int DISTINCT=40;
	public static final int DOT=41;
	public static final int DOT_CLASS=42;
	public static final int DOUBLE_PIPE=43;
	public static final int DYNAMIC_INSTANTIATION=44;
	public static final int DYNAMIC_INSTANTIATION_ARG=45;
	public static final int ELEMENTS=46;
	public static final int ELSE=47;
	public static final int END=48;
	public static final int ENTITY_NAME=49;
	public static final int ENTITY_PERSISTER_REF=50;
	public static final int EOL=51;
	public static final int EQUALS=52;
	public static final int ESCAPE=53;
	public static final int ESCAPE_SEQUENCE=54;
	public static final int EXCEPT=55;
	public static final int EXISTS=56;
	public static final int EXPONENT=57;
	public static final int EXTRACT=58;
	public static final int FALSE=59;
	public static final int FETCH=60;
	public static final int FILTER=61;
	public static final int FLOATING_POINT_LITERAL=62;
	public static final int FLOAT_TYPE_SUFFIX=63;
	public static final int FROM=64;
	public static final int FULL=65;
	public static final int FUNCTION=66;
	public static final int GREATER=67;
	public static final int GREATER_EQUAL=68;
	public static final int GROUPING_VALUE=69;
	public static final int GROUP_BY=70;
	public static final int HAVING=71;
	public static final int HEX_DIGIT=72;
	public static final int HEX_LITERAL=73;
	public static final int HOUR=74;
	public static final int IDENTIFIER=75;
	public static final int IN=76;
	public static final int INDEX=77;
	public static final int INDICES=78;
	public static final int INNER=79;
	public static final int INSERT=80;
	public static final int INSERTABILITY_SPEC=81;
	public static final int INTEGER_LITERAL=82;
	public static final int INTEGER_TYPE_SUFFIX=83;
	public static final int INTERSECT=84;
	public static final int INTO=85;
	public static final int IN_LIST=86;
	public static final int IS=87;
	public static final int IS_EMPTY=88;
	public static final int IS_NOT_EMPTY=89;
	public static final int IS_NOT_NULL=90;
	public static final int IS_NULL=91;
	public static final int JAVA_CONSTANT=92;
	public static final int JOIN=93;
	public static final int JPA_PARAM=94;
	public static final int LEADING=95;
	public static final int LEFT=96;
	public static final int LEFT_PAREN=97;
	public static final int LEFT_SQUARE=98;
	public static final int LENGTH=99;
	public static final int LESS=100;
	public static final int LESS_EQUAL=101;
	public static final int LIKE=102;
	public static final int LOCATE=103;
	public static final int LOWER=104;
	public static final int MAX=105;
	public static final int MAXELEMENT=106;
	public static final int MAXINDEX=107;
	public static final int MEMBER_OF=108;
	public static final int MIN=109;
	public static final int MINELEMENT=110;
	public static final int MININDEX=111;
	public static final int MINUS=112;
	public static final int MINUTE=113;
	public static final int MOD=114;
	public static final int MONTH=115;
	public static final int NAMED_PARAM=116;
	public static final int NEW=117;
	public static final int NOT=118;
	public static final int NOT_BETWEEN=119;
	public static final int NOT_EQUAL=120;
	public static final int NOT_IN=121;
	public static final int NOT_LIKE=122;
	public static final int NOT_MEMBER_OF=123;
	public static final int NULL=124;
	public static final int NULLIF=125;
	public static final int OCTAL_ESCAPE=126;
	public static final int OCTAL_LITERAL=127;
	public static final int OCTET_LENGTH=128;
	public static final int ON=129;
	public static final int OR=130;
	public static final int ORDER_BY=131;
	public static final int ORDER_SPEC=132;
	public static final int OUTER=133;
	public static final int PARAM=134;
	public static final int PATH=135;
	public static final int PERCENT=136;
	public static final int PERSISTER_JOIN=137;
	public static final int PERSISTER_SPACE=138;
	public static final int PIPE=139;
	public static final int PLUS=140;
	public static final int POSITION=141;
	public static final int PROPERTIES=142;
	public static final int PROPERTY_JOIN=143;
	public static final int PROPERTY_REFERENCE=144;
	public static final int PROP_FETCH=145;
	public static final int QUALIFIED_JOIN=146;
	public static final int QUERY=147;
	public static final int QUERY_SPEC=148;
	public static final int QUOTED_IDENTIFIER=149;
	public static final int RIGHT=150;
	public static final int RIGHT_PAREN=151;
	public static final int RIGHT_SQUARE=152;
	public static final int SEARCHED_CASE=153;
	public static final int SECOND=154;
	public static final int SELECT=155;
	public static final int SELECT_FROM=156;
	public static final int SELECT_ITEM=157;
	public static final int SELECT_LIST=158;
	public static final int SEMICOLON=159;
	public static final int SET=160;
	public static final int SIMPLE_CASE=161;
	public static final int SIZE=162;
	public static final int SOLIDUS=163;
	public static final int SOME=164;
	public static final int SORT_SPEC=165;
	public static final int SQRT=166;
	public static final int STRING_LITERAL=167;
	public static final int SUBSTRING=168;
	public static final int SUB_QUERY=169;
	public static final int SUM=170;
	public static final int TABLE=171;
	public static final int THEN=172;
	public static final int TIMEZONE_HOUR=173;
	public static final int TIMEZONE_MINUTE=174;
	public static final int TRAILING=175;
	public static final int TRIM=176;
	public static final int TRUE=177;
	public static final int UNARY_MINUS=178;
	public static final int UNARY_PLUS=179;
	public static final int UNICODE_ESCAPE=180;
	public static final int UNION=181;
	public static final int UPDATE=182;
	public static final int UPPER=183;
	public static final int VECTOR_EXPR=184;
	public static final int VERSIONED=185;
	public static final int VERSIONED_VALUE=186;
	public static final int WHEN=187;
	public static final int WHERE=188;
	public static final int WITH=189;
	public static final int WS=190;
	public static final int YEAR=191;

	// delegates
	public TreeParser[] getDelegates() {
		return new TreeParser[] {};
	}

	// delegators


	public GeneratedHQLResolver(TreeNodeStream input) {
		this(input, new RecognizerSharedState());
	}
	public GeneratedHQLResolver(TreeNodeStream input, RecognizerSharedState state) {
		super(input, state);
	}

protected TreeAdaptor adaptor = new CommonTreeAdaptor();

public void setTreeAdaptor(TreeAdaptor adaptor) {
	this.adaptor = adaptor;
}
public TreeAdaptor getTreeAdaptor() {
	return adaptor;
}
	public String[] getTokenNames() { return GeneratedHQLResolver.tokenNames; }
	public String getGrammarFileName() { return "org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g"; }


		protected void registerPersisterSpace(Tree entityName, Tree alias) {
			throw new UnsupportedOperationException( "must be overridden!" );
		}

		protected boolean isUnqualifiedPropertyReference() {
			throw new UnsupportedOperationException( "must be overridden!" );
		}

		protected PathedPropertyReferenceSource normalizeUnqualifiedPropertyReference(Tree property) {
			throw new UnsupportedOperationException( "must be overridden!" );
		}
		
		protected boolean isPersisterReferenceAlias() {
			throw new UnsupportedOperationException( "must be overridden!" );
		}

		protected PathedPropertyReferenceSource normalizeUnqualifiedRoot(Tree identifier382) {
			throw new UnsupportedOperationException( "must be overridden!" );
		}

		protected PathedPropertyReferenceSource normalizeQualifiedRoot(Tree identifier381) {
			throw new UnsupportedOperationException( "must be overridden!" );
		}

		protected PathedPropertyReferenceSource normalizePropertyPathIntermediary(
				PathedPropertyReferenceSource source, Tree propertyName) {
			throw new UnsupportedOperationException( "must be overridden!" );
		}

		protected PathedPropertyReferenceSource normalizeIntermediateIndexOperation(
				PathedPropertyReferenceSource propertyReferenceSource, Tree collectionProperty, Tree selector) {
			throw new UnsupportedOperationException( "must be overridden!" );
		}

		protected void normalizeTerminalIndexOperation(
				PathedPropertyReferenceSource propertyReferenceSource, Tree collectionProperty, Tree selector ) {
			throw new UnsupportedOperationException( "must be overridden!" );
		}

		protected PathedPropertyReferenceSource normalizeUnqualifiedPropertyReferenceSource(Tree identifier394) {
			throw new UnsupportedOperationException( "must be overridden!" );
		}

		protected Tree normalizePropertyPathTerminus(PathedPropertyReferenceSource source, Tree propertyNameNode) {
			throw new UnsupportedOperationException( "must be overridden!" );
		}

		protected void pushFromStrategy(
				JoinType joinType,
				Tree assosiationFetchTree,
				Tree propertyFetchTree,
				Tree alias) {
			throw new UnsupportedOperationException( "must be overridden!" );
		}
		
		protected void pushSelectStrategy() {
			throw new UnsupportedOperationException( "must be overridden!" );
		}

		protected void popStrategy(){
			throw new UnsupportedOperationException( "must be overridden!" );
		}

		protected void activateOR() {
		  //no-op by default: Hibernate ORM doesn't care
		}

	  protected void activateAND() {
	    //no-op by default: Hibernate ORM doesn't care
	  }

	  protected void activateNOT() {
	    //no-op by default: Hibernate ORM doesn't care
	  }

	  protected void deactivateBoolean() {
	    //no-op by default: Hibernate ORM doesn't care
	  }

	  protected void predicateEquals(String comparativePredicate) {
	    //no-op by default: Hibernate ORM doesn't care
	  }



	public static class filterStatement_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "filterStatement"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:134:1: filterStatement[String collectionRole] : ^( QUERY ^( QUERY_SPEC FILTER ( selectClause )? ( whereClause )? ( groupByClause ( havingClause )? )? ( orderByClause )? ) ) ;
	public final GeneratedHQLResolver.filterStatement_return filterStatement(String collectionRole) throws RecognitionException {
		GeneratedHQLResolver.filterStatement_return retval = new GeneratedHQLResolver.filterStatement_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree QUERY1=null;
		CommonTree QUERY_SPEC2=null;
		CommonTree FILTER3=null;
		TreeRuleReturnScope selectClause4 =null;
		TreeRuleReturnScope whereClause5 =null;
		TreeRuleReturnScope groupByClause6 =null;
		TreeRuleReturnScope havingClause7 =null;
		TreeRuleReturnScope orderByClause8 =null;

		CommonTree QUERY1_tree=null;
		CommonTree QUERY_SPEC2_tree=null;
		CommonTree FILTER3_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:135:2: ( ^( QUERY ^( QUERY_SPEC FILTER ( selectClause )? ( whereClause )? ( groupByClause ( havingClause )? )? ( orderByClause )? ) ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:135:4: ^( QUERY ^( QUERY_SPEC FILTER ( selectClause )? ( whereClause )? ( groupByClause ( havingClause )? )? ( orderByClause )? ) )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			QUERY1=(CommonTree)match(input,QUERY,FOLLOW_QUERY_in_filterStatement62); 

			if ( _first_0==null ) _first_0 = QUERY1;
			match(input, Token.DOWN, null); 
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_2 = _last;
			CommonTree _first_2 = null;
			_last = (CommonTree)input.LT(1);
			QUERY_SPEC2=(CommonTree)match(input,QUERY_SPEC,FOLLOW_QUERY_SPEC_in_filterStatement65); 

			if ( _first_1==null ) _first_1 = QUERY_SPEC2;
			match(input, Token.DOWN, null); 
			_last = (CommonTree)input.LT(1);
			FILTER3=(CommonTree)match(input,FILTER,FOLLOW_FILTER_in_filterStatement67); 
			 
			if ( _first_2==null ) _first_2 = FILTER3;

			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:136:5: ( selectClause )?
			int alt1=2;
			switch ( input.LA(1) ) {
				case SELECT:
					{
					alt1=1;
					}
					break;
			}
			switch (alt1) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:136:5: selectClause
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_selectClause_in_filterStatement74);
					selectClause4=selectClause();
					state._fsp--;

					 
					if ( _first_2==null ) _first_2 = (CommonTree)selectClause4.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

			}

			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:136:19: ( whereClause )?
			int alt2=2;
			switch ( input.LA(1) ) {
				case WHERE:
					{
					alt2=1;
					}
					break;
			}
			switch (alt2) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:136:19: whereClause
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_whereClause_in_filterStatement77);
					whereClause5=whereClause();
					state._fsp--;

					 
					if ( _first_2==null ) _first_2 = (CommonTree)whereClause5.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

			}

			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:136:32: ( groupByClause ( havingClause )? )?
			int alt4=2;
			switch ( input.LA(1) ) {
				case GROUP_BY:
					{
					alt4=1;
					}
					break;
			}
			switch (alt4) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:136:34: groupByClause ( havingClause )?
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_groupByClause_in_filterStatement82);
					groupByClause6=groupByClause();
					state._fsp--;

					 
					if ( _first_2==null ) _first_2 = (CommonTree)groupByClause6.getTree();

					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:136:48: ( havingClause )?
					int alt3=2;
					switch ( input.LA(1) ) {
						case HAVING:
							{
							alt3=1;
							}
							break;
					}
					switch (alt3) {
						case 1 :
							// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:136:48: havingClause
							{
							_last = (CommonTree)input.LT(1);
							pushFollow(FOLLOW_havingClause_in_filterStatement84);
							havingClause7=havingClause();
							state._fsp--;

							 
							if ( _first_2==null ) _first_2 = (CommonTree)havingClause7.getTree();

							retval.tree = (CommonTree)_first_0;
							if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
								retval.tree = (CommonTree)adaptor.getParent(retval.tree);

							}
							break;

					}

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

			}

			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:136:64: ( orderByClause )?
			int alt5=2;
			switch ( input.LA(1) ) {
				case ORDER_BY:
					{
					alt5=1;
					}
					break;
			}
			switch (alt5) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:136:64: orderByClause
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_orderByClause_in_filterStatement89);
					orderByClause8=orderByClause();
					state._fsp--;

					 
					if ( _first_2==null ) _first_2 = (CommonTree)orderByClause8.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

			}

			match(input, Token.UP, null); 
			_last = _save_last_2;
			}


			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "filterStatement"


	public static class statement_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "statement"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:139:1: statement : ( updateStatementSet | deleteStatementSet | insertStatementSet | queryStatementSet );
	public final GeneratedHQLResolver.statement_return statement() throws RecognitionException {
		GeneratedHQLResolver.statement_return retval = new GeneratedHQLResolver.statement_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		TreeRuleReturnScope updateStatementSet9 =null;
		TreeRuleReturnScope deleteStatementSet10 =null;
		TreeRuleReturnScope insertStatementSet11 =null;
		TreeRuleReturnScope queryStatementSet12 =null;


		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:140:2: ( updateStatementSet | deleteStatementSet | insertStatementSet | queryStatementSet )
			int alt6=4;
			switch ( input.LA(1) ) {
			case UPDATE:
				{
				alt6=1;
				}
				break;
			case DELETE:
				{
				alt6=2;
				}
				break;
			case INSERT:
				{
				alt6=3;
				}
				break;
			case QUERY:
				{
				alt6=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 6, 0, input);
				throw nvae;
			}
			switch (alt6) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:140:4: updateStatementSet
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_updateStatementSet_in_statement103);
					updateStatementSet9=updateStatementSet();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)updateStatementSet9.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 2 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:141:4: deleteStatementSet
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_deleteStatementSet_in_statement108);
					deleteStatementSet10=deleteStatementSet();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)deleteStatementSet10.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 3 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:142:4: insertStatementSet
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_insertStatementSet_in_statement113);
					insertStatementSet11=insertStatementSet();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)insertStatementSet11.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 4 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:143:4: queryStatementSet
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_queryStatementSet_in_statement118);
					queryStatementSet12=queryStatementSet();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)queryStatementSet12.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "statement"


	public static class updateStatementSet_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "updateStatementSet"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:146:1: updateStatementSet : ( updateStatement )+ ;
	public final GeneratedHQLResolver.updateStatementSet_return updateStatementSet() throws RecognitionException {
		GeneratedHQLResolver.updateStatementSet_return retval = new GeneratedHQLResolver.updateStatementSet_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		TreeRuleReturnScope updateStatement13 =null;


		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:147:2: ( ( updateStatement )+ )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:147:4: ( updateStatement )+
			{
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:147:4: ( updateStatement )+
			int cnt7=0;
			loop7:
			do {
				int alt7=2;
				switch ( input.LA(1) ) {
				case UPDATE:
					{
					alt7=1;
					}
					break;
				}
				switch (alt7) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:147:4: updateStatement
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_updateStatement_in_updateStatementSet129);
					updateStatement13=updateStatement();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)updateStatement13.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

				default :
					if ( cnt7 >= 1 ) break loop7;
						EarlyExitException eee =
							new EarlyExitException(7, input);
						throw eee;
				}
				cnt7++;
			} while (true);

			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "updateStatementSet"


	public static class updateStatement_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "updateStatement"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:150:1: updateStatement : ^( UPDATE entityName ^( SET ( assignment )+ ) ( whereClause )? ) ;
	public final GeneratedHQLResolver.updateStatement_return updateStatement() throws RecognitionException {
		GeneratedHQLResolver.updateStatement_return retval = new GeneratedHQLResolver.updateStatement_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree UPDATE14=null;
		CommonTree SET16=null;
		TreeRuleReturnScope entityName15 =null;
		TreeRuleReturnScope assignment17 =null;
		TreeRuleReturnScope whereClause18 =null;

		CommonTree UPDATE14_tree=null;
		CommonTree SET16_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:151:2: ( ^( UPDATE entityName ^( SET ( assignment )+ ) ( whereClause )? ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:151:4: ^( UPDATE entityName ^( SET ( assignment )+ ) ( whereClause )? )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			UPDATE14=(CommonTree)match(input,UPDATE,FOLLOW_UPDATE_in_updateStatement142); 

			if ( _first_0==null ) _first_0 = UPDATE14;
			match(input, Token.DOWN, null); 
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_entityName_in_updateStatement144);
			entityName15=entityName();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)entityName15.getTree();

			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_2 = _last;
			CommonTree _first_2 = null;
			_last = (CommonTree)input.LT(1);
			SET16=(CommonTree)match(input,SET,FOLLOW_SET_in_updateStatement147); 

			if ( _first_1==null ) _first_1 = SET16;
			match(input, Token.DOWN, null); 
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:151:30: ( assignment )+
			int cnt8=0;
			loop8:
			do {
				int alt8=2;
				switch ( input.LA(1) ) {
				case EQUALS:
					{
					alt8=1;
					}
					break;
				}
				switch (alt8) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:151:30: assignment
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_assignment_in_updateStatement149);
					assignment17=assignment();
					state._fsp--;

					 
					if ( _first_2==null ) _first_2 = (CommonTree)assignment17.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

				default :
					if ( cnt8 >= 1 ) break loop8;
						EarlyExitException eee =
							new EarlyExitException(8, input);
						throw eee;
				}
				cnt8++;
			} while (true);

			match(input, Token.UP, null); 
			_last = _save_last_2;
			}


			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:151:43: ( whereClause )?
			int alt9=2;
			switch ( input.LA(1) ) {
				case WHERE:
					{
					alt9=1;
					}
					break;
			}
			switch (alt9) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:151:43: whereClause
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_whereClause_in_updateStatement153);
					whereClause18=whereClause();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)whereClause18.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

			}

			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "updateStatement"


	public static class assignment_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "assignment"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:154:1: assignment : ( ^( EQUALS propertyReference valueExpression ) | ^( EQUALS VERSIONED_VALUE STRING_LITERAL ) );
	public final GeneratedHQLResolver.assignment_return assignment() throws RecognitionException {
		GeneratedHQLResolver.assignment_return retval = new GeneratedHQLResolver.assignment_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree EQUALS19=null;
		CommonTree EQUALS22=null;
		CommonTree VERSIONED_VALUE23=null;
		CommonTree STRING_LITERAL24=null;
		TreeRuleReturnScope propertyReference20 =null;
		TreeRuleReturnScope valueExpression21 =null;

		CommonTree EQUALS19_tree=null;
		CommonTree EQUALS22_tree=null;
		CommonTree VERSIONED_VALUE23_tree=null;
		CommonTree STRING_LITERAL24_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:155:2: ( ^( EQUALS propertyReference valueExpression ) | ^( EQUALS VERSIONED_VALUE STRING_LITERAL ) )
			int alt10=2;
			switch ( input.LA(1) ) {
			case EQUALS:
				{
				switch ( input.LA(2) ) {
				case DOWN:
					{
					switch ( input.LA(3) ) {
					case VERSIONED_VALUE:
						{
						alt10=2;
						}
						break;
					case PROPERTY_REFERENCE:
						{
						alt10=1;
						}
						break;
					default:
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++)
								input.consume();
							NoViableAltException nvae =
								new NoViableAltException("", 10, 2, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 10, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 10, 0, input);
				throw nvae;
			}
			switch (alt10) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:155:4: ^( EQUALS propertyReference valueExpression )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					EQUALS19=(CommonTree)match(input,EQUALS,FOLLOW_EQUALS_in_assignment167); 

					if ( _first_0==null ) _first_0 = EQUALS19;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_propertyReference_in_assignment169);
					propertyReference20=propertyReference();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)propertyReference20.getTree();

					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_valueExpression_in_assignment171);
					valueExpression21=valueExpression();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)valueExpression21.getTree();

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 2 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:156:4: ^( EQUALS VERSIONED_VALUE STRING_LITERAL )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					EQUALS22=(CommonTree)match(input,EQUALS,FOLLOW_EQUALS_in_assignment178); 

					if ( _first_0==null ) _first_0 = EQUALS22;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					VERSIONED_VALUE23=(CommonTree)match(input,VERSIONED_VALUE,FOLLOW_VERSIONED_VALUE_in_assignment180); 
					 
					if ( _first_1==null ) _first_1 = VERSIONED_VALUE23;

					_last = (CommonTree)input.LT(1);
					STRING_LITERAL24=(CommonTree)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_assignment182); 
					 
					if ( _first_1==null ) _first_1 = STRING_LITERAL24;

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "assignment"


	public static class deleteStatementSet_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "deleteStatementSet"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:159:1: deleteStatementSet : ( deleteStatement )+ ;
	public final GeneratedHQLResolver.deleteStatementSet_return deleteStatementSet() throws RecognitionException {
		GeneratedHQLResolver.deleteStatementSet_return retval = new GeneratedHQLResolver.deleteStatementSet_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		TreeRuleReturnScope deleteStatement25 =null;


		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:160:2: ( ( deleteStatement )+ )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:160:4: ( deleteStatement )+
			{
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:160:4: ( deleteStatement )+
			int cnt11=0;
			loop11:
			do {
				int alt11=2;
				switch ( input.LA(1) ) {
				case DELETE:
					{
					alt11=1;
					}
					break;
				}
				switch (alt11) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:160:4: deleteStatement
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_deleteStatement_in_deleteStatementSet194);
					deleteStatement25=deleteStatement();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)deleteStatement25.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

				default :
					if ( cnt11 >= 1 ) break loop11;
						EarlyExitException eee =
							new EarlyExitException(11, input);
						throw eee;
				}
				cnt11++;
			} while (true);

			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "deleteStatementSet"


	public static class deleteStatement_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "deleteStatement"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:163:1: deleteStatement : ^( DELETE entityName ( whereClause )? ) ;
	public final GeneratedHQLResolver.deleteStatement_return deleteStatement() throws RecognitionException {
		GeneratedHQLResolver.deleteStatement_return retval = new GeneratedHQLResolver.deleteStatement_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree DELETE26=null;
		TreeRuleReturnScope entityName27 =null;
		TreeRuleReturnScope whereClause28 =null;

		CommonTree DELETE26_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:164:2: ( ^( DELETE entityName ( whereClause )? ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:164:4: ^( DELETE entityName ( whereClause )? )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			DELETE26=(CommonTree)match(input,DELETE,FOLLOW_DELETE_in_deleteStatement207); 

			if ( _first_0==null ) _first_0 = DELETE26;
			match(input, Token.DOWN, null); 
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_entityName_in_deleteStatement209);
			entityName27=entityName();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)entityName27.getTree();

			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:164:24: ( whereClause )?
			int alt12=2;
			switch ( input.LA(1) ) {
				case WHERE:
					{
					alt12=1;
					}
					break;
			}
			switch (alt12) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:164:24: whereClause
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_whereClause_in_deleteStatement211);
					whereClause28=whereClause();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)whereClause28.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

			}

			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "deleteStatement"


	public static class insertStatementSet_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "insertStatementSet"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:167:1: insertStatementSet : ( insertStatement )+ ;
	public final GeneratedHQLResolver.insertStatementSet_return insertStatementSet() throws RecognitionException {
		GeneratedHQLResolver.insertStatementSet_return retval = new GeneratedHQLResolver.insertStatementSet_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		TreeRuleReturnScope insertStatement29 =null;


		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:168:2: ( ( insertStatement )+ )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:168:4: ( insertStatement )+
			{
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:168:4: ( insertStatement )+
			int cnt13=0;
			loop13:
			do {
				int alt13=2;
				switch ( input.LA(1) ) {
				case INSERT:
					{
					alt13=1;
					}
					break;
				}
				switch (alt13) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:168:4: insertStatement
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_insertStatement_in_insertStatementSet224);
					insertStatement29=insertStatement();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)insertStatement29.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

				default :
					if ( cnt13 >= 1 ) break loop13;
						EarlyExitException eee =
							new EarlyExitException(13, input);
						throw eee;
				}
				cnt13++;
			} while (true);

			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "insertStatementSet"


	public static class insertStatement_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "insertStatement"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:171:1: insertStatement : ^( INSERT intoClause queryStatementSet ) ;
	public final GeneratedHQLResolver.insertStatement_return insertStatement() throws RecognitionException {
		GeneratedHQLResolver.insertStatement_return retval = new GeneratedHQLResolver.insertStatement_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree INSERT30=null;
		TreeRuleReturnScope intoClause31 =null;
		TreeRuleReturnScope queryStatementSet32 =null;

		CommonTree INSERT30_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:172:2: ( ^( INSERT intoClause queryStatementSet ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:172:4: ^( INSERT intoClause queryStatementSet )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			INSERT30=(CommonTree)match(input,INSERT,FOLLOW_INSERT_in_insertStatement237); 

			if ( _first_0==null ) _first_0 = INSERT30;
			match(input, Token.DOWN, null); 
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_intoClause_in_insertStatement239);
			intoClause31=intoClause();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)intoClause31.getTree();

			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_queryStatementSet_in_insertStatement241);
			queryStatementSet32=queryStatementSet();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)queryStatementSet32.getTree();

			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "insertStatement"


	public static class intoClause_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "intoClause"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:175:1: intoClause : ^( INTO entityName ^( INSERTABILITY_SPEC ( propertyReference )+ ) ) ;
	public final GeneratedHQLResolver.intoClause_return intoClause() throws RecognitionException {
		GeneratedHQLResolver.intoClause_return retval = new GeneratedHQLResolver.intoClause_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree INTO33=null;
		CommonTree INSERTABILITY_SPEC35=null;
		TreeRuleReturnScope entityName34 =null;
		TreeRuleReturnScope propertyReference36 =null;

		CommonTree INTO33_tree=null;
		CommonTree INSERTABILITY_SPEC35_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:176:2: ( ^( INTO entityName ^( INSERTABILITY_SPEC ( propertyReference )+ ) ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:176:4: ^( INTO entityName ^( INSERTABILITY_SPEC ( propertyReference )+ ) )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			INTO33=(CommonTree)match(input,INTO,FOLLOW_INTO_in_intoClause254); 

			if ( _first_0==null ) _first_0 = INTO33;
			match(input, Token.DOWN, null); 
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_entityName_in_intoClause256);
			entityName34=entityName();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)entityName34.getTree();

			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_2 = _last;
			CommonTree _first_2 = null;
			_last = (CommonTree)input.LT(1);
			INSERTABILITY_SPEC35=(CommonTree)match(input,INSERTABILITY_SPEC,FOLLOW_INSERTABILITY_SPEC_in_intoClause259); 

			if ( _first_1==null ) _first_1 = INSERTABILITY_SPEC35;
			match(input, Token.DOWN, null); 
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:176:43: ( propertyReference )+
			int cnt14=0;
			loop14:
			do {
				int alt14=2;
				switch ( input.LA(1) ) {
				case PROPERTY_REFERENCE:
					{
					alt14=1;
					}
					break;
				}
				switch (alt14) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:176:43: propertyReference
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_propertyReference_in_intoClause261);
					propertyReference36=propertyReference();
					state._fsp--;

					 
					if ( _first_2==null ) _first_2 = (CommonTree)propertyReference36.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

				default :
					if ( cnt14 >= 1 ) break loop14;
						EarlyExitException eee =
							new EarlyExitException(14, input);
						throw eee;
				}
				cnt14++;
			} while (true);

			match(input, Token.UP, null); 
			_last = _save_last_2;
			}


			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "intoClause"


	public static class queryStatementSet_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "queryStatementSet"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:179:1: queryStatementSet : ( queryStatement )+ ;
	public final GeneratedHQLResolver.queryStatementSet_return queryStatementSet() throws RecognitionException {
		GeneratedHQLResolver.queryStatementSet_return retval = new GeneratedHQLResolver.queryStatementSet_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		TreeRuleReturnScope queryStatement37 =null;


		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:180:2: ( ( queryStatement )+ )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:180:4: ( queryStatement )+
			{
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:180:4: ( queryStatement )+
			int cnt15=0;
			loop15:
			do {
				int alt15=2;
				switch ( input.LA(1) ) {
				case QUERY:
					{
					alt15=1;
					}
					break;
				}
				switch (alt15) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:180:4: queryStatement
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_queryStatement_in_queryStatementSet277);
					queryStatement37=queryStatement();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)queryStatement37.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

				default :
					if ( cnt15 >= 1 ) break loop15;
						EarlyExitException eee =
							new EarlyExitException(15, input);
						throw eee;
				}
				cnt15++;
			} while (true);

			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "queryStatementSet"


	public static class queryStatement_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "queryStatement"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:183:1: queryStatement : ^( QUERY queryExpression ( orderByClause )? ) ;
	public final GeneratedHQLResolver.queryStatement_return queryStatement() throws RecognitionException {
		GeneratedHQLResolver.queryStatement_return retval = new GeneratedHQLResolver.queryStatement_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree QUERY38=null;
		TreeRuleReturnScope queryExpression39 =null;
		TreeRuleReturnScope orderByClause40 =null;

		CommonTree QUERY38_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:184:2: ( ^( QUERY queryExpression ( orderByClause )? ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:184:4: ^( QUERY queryExpression ( orderByClause )? )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			QUERY38=(CommonTree)match(input,QUERY,FOLLOW_QUERY_in_queryStatement290); 

			if ( _first_0==null ) _first_0 = QUERY38;
			match(input, Token.DOWN, null); 
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_queryExpression_in_queryStatement292);
			queryExpression39=queryExpression();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)queryExpression39.getTree();

			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:184:28: ( orderByClause )?
			int alt16=2;
			switch ( input.LA(1) ) {
				case ORDER_BY:
					{
					alt16=1;
					}
					break;
			}
			switch (alt16) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:184:28: orderByClause
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_orderByClause_in_queryStatement294);
					orderByClause40=orderByClause();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)orderByClause40.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

			}

			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "queryStatement"


	public static class queryExpression_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "queryExpression"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:187:1: queryExpression : ( ^( UNION ( ALL )? queryExpression queryExpression ) | ^( INTERSECT ( ALL )? queryExpression queryExpression ) | ^( EXCEPT ( ALL )? queryExpression queryExpression ) | querySpec );
	public final GeneratedHQLResolver.queryExpression_return queryExpression() throws RecognitionException {
		GeneratedHQLResolver.queryExpression_return retval = new GeneratedHQLResolver.queryExpression_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree UNION41=null;
		CommonTree ALL42=null;
		CommonTree INTERSECT45=null;
		CommonTree ALL46=null;
		CommonTree EXCEPT49=null;
		CommonTree ALL50=null;
		TreeRuleReturnScope queryExpression43 =null;
		TreeRuleReturnScope queryExpression44 =null;
		TreeRuleReturnScope queryExpression47 =null;
		TreeRuleReturnScope queryExpression48 =null;
		TreeRuleReturnScope queryExpression51 =null;
		TreeRuleReturnScope queryExpression52 =null;
		TreeRuleReturnScope querySpec53 =null;

		CommonTree UNION41_tree=null;
		CommonTree ALL42_tree=null;
		CommonTree INTERSECT45_tree=null;
		CommonTree ALL46_tree=null;
		CommonTree EXCEPT49_tree=null;
		CommonTree ALL50_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:188:2: ( ^( UNION ( ALL )? queryExpression queryExpression ) | ^( INTERSECT ( ALL )? queryExpression queryExpression ) | ^( EXCEPT ( ALL )? queryExpression queryExpression ) | querySpec )
			int alt20=4;
			switch ( input.LA(1) ) {
			case UNION:
				{
				alt20=1;
				}
				break;
			case INTERSECT:
				{
				alt20=2;
				}
				break;
			case EXCEPT:
				{
				alt20=3;
				}
				break;
			case QUERY_SPEC:
				{
				alt20=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 20, 0, input);
				throw nvae;
			}
			switch (alt20) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:188:4: ^( UNION ( ALL )? queryExpression queryExpression )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					UNION41=(CommonTree)match(input,UNION,FOLLOW_UNION_in_queryExpression308); 

					if ( _first_0==null ) _first_0 = UNION41;
					match(input, Token.DOWN, null); 
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:188:12: ( ALL )?
					int alt17=2;
					switch ( input.LA(1) ) {
						case ALL:
							{
							alt17=1;
							}
							break;
					}
					switch (alt17) {
						case 1 :
							// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:188:12: ALL
							{
							_last = (CommonTree)input.LT(1);
							ALL42=(CommonTree)match(input,ALL,FOLLOW_ALL_in_queryExpression310); 
							 
							if ( _first_1==null ) _first_1 = ALL42;

							retval.tree = (CommonTree)_first_0;
							if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
								retval.tree = (CommonTree)adaptor.getParent(retval.tree);

							}
							break;

					}

					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_queryExpression_in_queryExpression313);
					queryExpression43=queryExpression();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)queryExpression43.getTree();

					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_queryExpression_in_queryExpression315);
					queryExpression44=queryExpression();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)queryExpression44.getTree();

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 2 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:189:4: ^( INTERSECT ( ALL )? queryExpression queryExpression )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					INTERSECT45=(CommonTree)match(input,INTERSECT,FOLLOW_INTERSECT_in_queryExpression322); 

					if ( _first_0==null ) _first_0 = INTERSECT45;
					match(input, Token.DOWN, null); 
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:189:16: ( ALL )?
					int alt18=2;
					switch ( input.LA(1) ) {
						case ALL:
							{
							alt18=1;
							}
							break;
					}
					switch (alt18) {
						case 1 :
							// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:189:16: ALL
							{
							_last = (CommonTree)input.LT(1);
							ALL46=(CommonTree)match(input,ALL,FOLLOW_ALL_in_queryExpression324); 
							 
							if ( _first_1==null ) _first_1 = ALL46;

							retval.tree = (CommonTree)_first_0;
							if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
								retval.tree = (CommonTree)adaptor.getParent(retval.tree);

							}
							break;

					}

					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_queryExpression_in_queryExpression327);
					queryExpression47=queryExpression();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)queryExpression47.getTree();

					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_queryExpression_in_queryExpression329);
					queryExpression48=queryExpression();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)queryExpression48.getTree();

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 3 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:190:4: ^( EXCEPT ( ALL )? queryExpression queryExpression )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					EXCEPT49=(CommonTree)match(input,EXCEPT,FOLLOW_EXCEPT_in_queryExpression336); 

					if ( _first_0==null ) _first_0 = EXCEPT49;
					match(input, Token.DOWN, null); 
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:190:13: ( ALL )?
					int alt19=2;
					switch ( input.LA(1) ) {
						case ALL:
							{
							alt19=1;
							}
							break;
					}
					switch (alt19) {
						case 1 :
							// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:190:13: ALL
							{
							_last = (CommonTree)input.LT(1);
							ALL50=(CommonTree)match(input,ALL,FOLLOW_ALL_in_queryExpression338); 
							 
							if ( _first_1==null ) _first_1 = ALL50;

							retval.tree = (CommonTree)_first_0;
							if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
								retval.tree = (CommonTree)adaptor.getParent(retval.tree);

							}
							break;

					}

					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_queryExpression_in_queryExpression341);
					queryExpression51=queryExpression();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)queryExpression51.getTree();

					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_queryExpression_in_queryExpression343);
					queryExpression52=queryExpression();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)queryExpression52.getTree();

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 4 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:191:4: querySpec
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_querySpec_in_queryExpression349);
					querySpec53=querySpec();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)querySpec53.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "queryExpression"


	public static class querySpec_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "querySpec"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:194:1: querySpec : ^( QUERY_SPEC selectFrom ( whereClause )? ( groupByClause )? ( havingClause )? ) ;
	public final GeneratedHQLResolver.querySpec_return querySpec() throws RecognitionException {
		GeneratedHQLResolver.querySpec_return retval = new GeneratedHQLResolver.querySpec_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree QUERY_SPEC54=null;
		TreeRuleReturnScope selectFrom55 =null;
		TreeRuleReturnScope whereClause56 =null;
		TreeRuleReturnScope groupByClause57 =null;
		TreeRuleReturnScope havingClause58 =null;

		CommonTree QUERY_SPEC54_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:195:2: ( ^( QUERY_SPEC selectFrom ( whereClause )? ( groupByClause )? ( havingClause )? ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:195:4: ^( QUERY_SPEC selectFrom ( whereClause )? ( groupByClause )? ( havingClause )? )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			QUERY_SPEC54=(CommonTree)match(input,QUERY_SPEC,FOLLOW_QUERY_SPEC_in_querySpec362); 

			if ( _first_0==null ) _first_0 = QUERY_SPEC54;
			match(input, Token.DOWN, null); 
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_selectFrom_in_querySpec364);
			selectFrom55=selectFrom();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)selectFrom55.getTree();

			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:195:28: ( whereClause )?
			int alt21=2;
			switch ( input.LA(1) ) {
				case WHERE:
					{
					alt21=1;
					}
					break;
			}
			switch (alt21) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:195:28: whereClause
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_whereClause_in_querySpec366);
					whereClause56=whereClause();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)whereClause56.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

			}

			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:195:41: ( groupByClause )?
			int alt22=2;
			switch ( input.LA(1) ) {
				case GROUP_BY:
					{
					alt22=1;
					}
					break;
			}
			switch (alt22) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:195:41: groupByClause
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_groupByClause_in_querySpec369);
					groupByClause57=groupByClause();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)groupByClause57.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

			}

			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:195:56: ( havingClause )?
			int alt23=2;
			switch ( input.LA(1) ) {
				case HAVING:
					{
					alt23=1;
					}
					break;
			}
			switch (alt23) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:195:56: havingClause
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_havingClause_in_querySpec372);
					havingClause58=havingClause();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)havingClause58.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

			}

			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "querySpec"


	public static class whereClause_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "whereClause"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:198:1: whereClause : ^( WHERE searchCondition ) ;
	public final GeneratedHQLResolver.whereClause_return whereClause() throws RecognitionException {
		GeneratedHQLResolver.whereClause_return retval = new GeneratedHQLResolver.whereClause_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree WHERE59=null;
		TreeRuleReturnScope searchCondition60 =null;

		CommonTree WHERE59_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:199:2: ( ^( WHERE searchCondition ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:199:4: ^( WHERE searchCondition )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			WHERE59=(CommonTree)match(input,WHERE,FOLLOW_WHERE_in_whereClause386); 

			if ( _first_0==null ) _first_0 = WHERE59;
			match(input, Token.DOWN, null); 
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_searchCondition_in_whereClause388);
			searchCondition60=searchCondition();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)searchCondition60.getTree();

			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "whereClause"


	public static class groupByClause_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "groupByClause"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:202:1: groupByClause : ^( GROUP_BY ( groupingValue )+ ) ;
	public final GeneratedHQLResolver.groupByClause_return groupByClause() throws RecognitionException {
		GeneratedHQLResolver.groupByClause_return retval = new GeneratedHQLResolver.groupByClause_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree GROUP_BY61=null;
		TreeRuleReturnScope groupingValue62 =null;

		CommonTree GROUP_BY61_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:203:2: ( ^( GROUP_BY ( groupingValue )+ ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:203:4: ^( GROUP_BY ( groupingValue )+ )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			GROUP_BY61=(CommonTree)match(input,GROUP_BY,FOLLOW_GROUP_BY_in_groupByClause401); 

			if ( _first_0==null ) _first_0 = GROUP_BY61;
			match(input, Token.DOWN, null); 
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:203:15: ( groupingValue )+
			int cnt24=0;
			loop24:
			do {
				int alt24=2;
				switch ( input.LA(1) ) {
				case GROUPING_VALUE:
					{
					alt24=1;
					}
					break;
				}
				switch (alt24) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:203:15: groupingValue
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_groupingValue_in_groupByClause403);
					groupingValue62=groupingValue();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)groupingValue62.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

				default :
					if ( cnt24 >= 1 ) break loop24;
						EarlyExitException eee =
							new EarlyExitException(24, input);
						throw eee;
				}
				cnt24++;
			} while (true);

			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "groupByClause"


	public static class groupingValue_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "groupingValue"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:206:1: groupingValue : ^( GROUPING_VALUE valueExpression ( COLLATE )? ) ;
	public final GeneratedHQLResolver.groupingValue_return groupingValue() throws RecognitionException {
		GeneratedHQLResolver.groupingValue_return retval = new GeneratedHQLResolver.groupingValue_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree GROUPING_VALUE63=null;
		CommonTree COLLATE65=null;
		TreeRuleReturnScope valueExpression64 =null;

		CommonTree GROUPING_VALUE63_tree=null;
		CommonTree COLLATE65_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:207:2: ( ^( GROUPING_VALUE valueExpression ( COLLATE )? ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:207:4: ^( GROUPING_VALUE valueExpression ( COLLATE )? )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			GROUPING_VALUE63=(CommonTree)match(input,GROUPING_VALUE,FOLLOW_GROUPING_VALUE_in_groupingValue417); 

			if ( _first_0==null ) _first_0 = GROUPING_VALUE63;
			match(input, Token.DOWN, null); 
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_valueExpression_in_groupingValue419);
			valueExpression64=valueExpression();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)valueExpression64.getTree();

			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:207:37: ( COLLATE )?
			int alt25=2;
			switch ( input.LA(1) ) {
				case COLLATE:
					{
					alt25=1;
					}
					break;
			}
			switch (alt25) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:207:37: COLLATE
					{
					_last = (CommonTree)input.LT(1);
					COLLATE65=(CommonTree)match(input,COLLATE,FOLLOW_COLLATE_in_groupingValue421); 
					 
					if ( _first_1==null ) _first_1 = COLLATE65;

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

			}

			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "groupingValue"


	public static class havingClause_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "havingClause"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:210:1: havingClause : ^( HAVING searchCondition ) ;
	public final GeneratedHQLResolver.havingClause_return havingClause() throws RecognitionException {
		GeneratedHQLResolver.havingClause_return retval = new GeneratedHQLResolver.havingClause_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree HAVING66=null;
		TreeRuleReturnScope searchCondition67 =null;

		CommonTree HAVING66_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:211:2: ( ^( HAVING searchCondition ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:211:4: ^( HAVING searchCondition )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			HAVING66=(CommonTree)match(input,HAVING,FOLLOW_HAVING_in_havingClause435); 

			if ( _first_0==null ) _first_0 = HAVING66;
			match(input, Token.DOWN, null); 
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_searchCondition_in_havingClause437);
			searchCondition67=searchCondition();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)searchCondition67.getTree();

			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "havingClause"


	public static class selectFrom_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "selectFrom"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:214:1: selectFrom : ^( SELECT_FROM fromClause selectClause ) ;
	public final GeneratedHQLResolver.selectFrom_return selectFrom() throws RecognitionException {
		GeneratedHQLResolver.selectFrom_return retval = new GeneratedHQLResolver.selectFrom_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree SELECT_FROM68=null;
		TreeRuleReturnScope fromClause69 =null;
		TreeRuleReturnScope selectClause70 =null;

		CommonTree SELECT_FROM68_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:215:2: ( ^( SELECT_FROM fromClause selectClause ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:215:4: ^( SELECT_FROM fromClause selectClause )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			SELECT_FROM68=(CommonTree)match(input,SELECT_FROM,FOLLOW_SELECT_FROM_in_selectFrom450); 

			if ( _first_0==null ) _first_0 = SELECT_FROM68;
			match(input, Token.DOWN, null); 
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_fromClause_in_selectFrom452);
			fromClause69=fromClause();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)fromClause69.getTree();

			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_selectClause_in_selectFrom454);
			selectClause70=selectClause();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)selectClause70.getTree();

			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "selectFrom"


	public static class fromClause_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "fromClause"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:218:1: fromClause : ^( FROM ( persisterSpaces )+ ) ;
	public final GeneratedHQLResolver.fromClause_return fromClause() throws RecognitionException {
		GeneratedHQLResolver.fromClause_return retval = new GeneratedHQLResolver.fromClause_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree FROM71=null;
		TreeRuleReturnScope persisterSpaces72 =null;

		CommonTree FROM71_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:219:2: ( ^( FROM ( persisterSpaces )+ ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:219:4: ^( FROM ( persisterSpaces )+ )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			FROM71=(CommonTree)match(input,FROM,FOLLOW_FROM_in_fromClause467); 

			if ( _first_0==null ) _first_0 = FROM71;
			match(input, Token.DOWN, null); 
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:219:11: ( persisterSpaces )+
			int cnt26=0;
			loop26:
			do {
				int alt26=2;
				switch ( input.LA(1) ) {
				case PERSISTER_SPACE:
					{
					alt26=1;
					}
					break;
				}
				switch (alt26) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:219:11: persisterSpaces
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_persisterSpaces_in_fromClause469);
					persisterSpaces72=persisterSpaces();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)persisterSpaces72.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

				default :
					if ( cnt26 >= 1 ) break loop26;
						EarlyExitException eee =
							new EarlyExitException(26, input);
						throw eee;
				}
				cnt26++;
			} while (true);

			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "fromClause"


	public static class persisterSpaces_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "persisterSpaces"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:222:1: persisterSpaces : ^( PERSISTER_SPACE persisterSpace ) ;
	public final GeneratedHQLResolver.persisterSpaces_return persisterSpaces() throws RecognitionException {
		GeneratedHQLResolver.persisterSpaces_return retval = new GeneratedHQLResolver.persisterSpaces_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree PERSISTER_SPACE73=null;
		TreeRuleReturnScope persisterSpace74 =null;

		CommonTree PERSISTER_SPACE73_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:223:2: ( ^( PERSISTER_SPACE persisterSpace ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:223:4: ^( PERSISTER_SPACE persisterSpace )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			PERSISTER_SPACE73=(CommonTree)match(input,PERSISTER_SPACE,FOLLOW_PERSISTER_SPACE_in_persisterSpaces483); 

			if ( _first_0==null ) _first_0 = PERSISTER_SPACE73;
			match(input, Token.DOWN, null); 
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_persisterSpace_in_persisterSpaces485);
			persisterSpace74=persisterSpace();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)persisterSpace74.getTree();

			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "persisterSpaces"


	public static class persisterSpace_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "persisterSpace"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:226:1: persisterSpace : persisterSpaceRoot ( joins )* ;
	public final GeneratedHQLResolver.persisterSpace_return persisterSpace() throws RecognitionException {
		GeneratedHQLResolver.persisterSpace_return retval = new GeneratedHQLResolver.persisterSpace_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		TreeRuleReturnScope persisterSpaceRoot75 =null;
		TreeRuleReturnScope joins76 =null;


		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:227:2: ( persisterSpaceRoot ( joins )* )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:227:4: persisterSpaceRoot ( joins )*
			{
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_persisterSpaceRoot_in_persisterSpace497);
			persisterSpaceRoot75=persisterSpaceRoot();
			state._fsp--;

			 
			if ( _first_0==null ) _first_0 = (CommonTree)persisterSpaceRoot75.getTree();

			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:227:23: ( joins )*
			loop27:
			do {
				int alt27=2;
				switch ( input.LA(1) ) {
				case PERSISTER_JOIN:
				case PROPERTY_JOIN:
					{
					alt27=1;
					}
					break;
				}
				switch (alt27) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:227:23: joins
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_joins_in_persisterSpace499);
					joins76=joins();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)joins76.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

				default :
					break loop27;
				}
			} while (true);

			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "persisterSpace"


	public static class persisterSpaceRoot_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "persisterSpaceRoot"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:230:1: persisterSpaceRoot : ^( ENTITY_PERSISTER_REF entityName ( PROP_FETCH )? ) ;
	public final GeneratedHQLResolver.persisterSpaceRoot_return persisterSpaceRoot() throws RecognitionException {
		GeneratedHQLResolver.persisterSpaceRoot_return retval = new GeneratedHQLResolver.persisterSpaceRoot_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree ENTITY_PERSISTER_REF77=null;
		CommonTree PROP_FETCH79=null;
		TreeRuleReturnScope entityName78 =null;

		CommonTree ENTITY_PERSISTER_REF77_tree=null;
		CommonTree PROP_FETCH79_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:231:2: ( ^( ENTITY_PERSISTER_REF entityName ( PROP_FETCH )? ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:231:4: ^( ENTITY_PERSISTER_REF entityName ( PROP_FETCH )? )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			ENTITY_PERSISTER_REF77=(CommonTree)match(input,ENTITY_PERSISTER_REF,FOLLOW_ENTITY_PERSISTER_REF_in_persisterSpaceRoot512); 

			if ( _first_0==null ) _first_0 = ENTITY_PERSISTER_REF77;
			match(input, Token.DOWN, null); 
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_entityName_in_persisterSpaceRoot514);
			entityName78=entityName();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)entityName78.getTree();

			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:231:38: ( PROP_FETCH )?
			int alt28=2;
			switch ( input.LA(1) ) {
				case PROP_FETCH:
					{
					alt28=1;
					}
					break;
			}
			switch (alt28) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:231:38: PROP_FETCH
					{
					_last = (CommonTree)input.LT(1);
					PROP_FETCH79=(CommonTree)match(input,PROP_FETCH,FOLLOW_PROP_FETCH_in_persisterSpaceRoot516); 
					 
					if ( _first_1==null ) _first_1 = PROP_FETCH79;

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

			}

			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "persisterSpaceRoot"


	public static class joins_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "joins"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:234:1: joins : ( ^( PROPERTY_JOIN jt= joinType (ft= FETCH )? an= ALIAS_NAME (pf= PROP_FETCH )? ( collectionExpression | propertyReference ) ( withClause )? ) | ^( PERSISTER_JOIN joinType persisterSpaceRoot ( onClause )? ) );
	public final GeneratedHQLResolver.joins_return joins() throws RecognitionException {
		GeneratedHQLResolver.joins_return retval = new GeneratedHQLResolver.joins_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree ft=null;
		CommonTree an=null;
		CommonTree pf=null;
		CommonTree PROPERTY_JOIN80=null;
		CommonTree PERSISTER_JOIN84=null;
		TreeRuleReturnScope jt =null;
		TreeRuleReturnScope collectionExpression81 =null;
		TreeRuleReturnScope propertyReference82 =null;
		TreeRuleReturnScope withClause83 =null;
		TreeRuleReturnScope joinType85 =null;
		TreeRuleReturnScope persisterSpaceRoot86 =null;
		TreeRuleReturnScope onClause87 =null;

		CommonTree ft_tree=null;
		CommonTree an_tree=null;
		CommonTree pf_tree=null;
		CommonTree PROPERTY_JOIN80_tree=null;
		CommonTree PERSISTER_JOIN84_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:235:2: ( ^( PROPERTY_JOIN jt= joinType (ft= FETCH )? an= ALIAS_NAME (pf= PROP_FETCH )? ( collectionExpression | propertyReference ) ( withClause )? ) | ^( PERSISTER_JOIN joinType persisterSpaceRoot ( onClause )? ) )
			int alt34=2;
			switch ( input.LA(1) ) {
			case PROPERTY_JOIN:
				{
				alt34=1;
				}
				break;
			case PERSISTER_JOIN:
				{
				alt34=2;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 34, 0, input);
				throw nvae;
			}
			switch (alt34) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:235:4: ^( PROPERTY_JOIN jt= joinType (ft= FETCH )? an= ALIAS_NAME (pf= PROP_FETCH )? ( collectionExpression | propertyReference ) ( withClause )? )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					PROPERTY_JOIN80=(CommonTree)match(input,PROPERTY_JOIN,FOLLOW_PROPERTY_JOIN_in_joins530); 

					if ( _first_0==null ) _first_0 = PROPERTY_JOIN80;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_joinType_in_joins534);
					jt=joinType();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)jt.getTree();

					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:235:34: (ft= FETCH )?
					int alt29=2;
					switch ( input.LA(1) ) {
						case FETCH:
							{
							alt29=1;
							}
							break;
					}
					switch (alt29) {
						case 1 :
							// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:235:34: ft= FETCH
							{
							_last = (CommonTree)input.LT(1);
							ft=(CommonTree)match(input,FETCH,FOLLOW_FETCH_in_joins538); 
							 
							if ( _first_1==null ) _first_1 = ft;

							retval.tree = (CommonTree)_first_0;
							if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
								retval.tree = (CommonTree)adaptor.getParent(retval.tree);

							}
							break;

					}

					_last = (CommonTree)input.LT(1);
					an=(CommonTree)match(input,ALIAS_NAME,FOLLOW_ALIAS_NAME_in_joins543); 
					 
					if ( _first_1==null ) _first_1 = an;

					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:235:58: (pf= PROP_FETCH )?
					int alt30=2;
					switch ( input.LA(1) ) {
						case PROP_FETCH:
							{
							alt30=1;
							}
							break;
					}
					switch (alt30) {
						case 1 :
							// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:235:58: pf= PROP_FETCH
							{
							_last = (CommonTree)input.LT(1);
							pf=(CommonTree)match(input,PROP_FETCH,FOLLOW_PROP_FETCH_in_joins547); 
							 
							if ( _first_1==null ) _first_1 = pf;

							retval.tree = (CommonTree)_first_0;
							if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
								retval.tree = (CommonTree)adaptor.getParent(retval.tree);

							}
							break;

					}

						pushFromStrategy((jt!=null?((GeneratedHQLResolver.joinType_return)jt).joinType:null), ft, pf, an );	
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:237:3: ( collectionExpression | propertyReference )
					int alt31=2;
					switch ( input.LA(1) ) {
					case ELEMENTS:
					case INDICES:
						{
						alt31=1;
						}
						break;
					case PROPERTY_REFERENCE:
						{
						alt31=2;
						}
						break;
					default:
						NoViableAltException nvae =
							new NoViableAltException("", 31, 0, input);
						throw nvae;
					}
					switch (alt31) {
						case 1 :
							// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:237:4: collectionExpression
							{
							_last = (CommonTree)input.LT(1);
							pushFollow(FOLLOW_collectionExpression_in_joins557);
							collectionExpression81=collectionExpression();
							state._fsp--;

							 
							if ( _first_1==null ) _first_1 = (CommonTree)collectionExpression81.getTree();

							retval.tree = (CommonTree)_first_0;
							if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
								retval.tree = (CommonTree)adaptor.getParent(retval.tree);

							}
							break;
						case 2 :
							// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:237:25: propertyReference
							{
							_last = (CommonTree)input.LT(1);
							pushFollow(FOLLOW_propertyReference_in_joins559);
							propertyReference82=propertyReference();
							state._fsp--;

							 
							if ( _first_1==null ) _first_1 = (CommonTree)propertyReference82.getTree();

							retval.tree = (CommonTree)_first_0;
							if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
								retval.tree = (CommonTree)adaptor.getParent(retval.tree);

							}
							break;

					}

					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:237:44: ( withClause )?
					int alt32=2;
					switch ( input.LA(1) ) {
						case WITH:
							{
							alt32=1;
							}
							break;
					}
					switch (alt32) {
						case 1 :
							// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:237:44: withClause
							{
							_last = (CommonTree)input.LT(1);
							pushFollow(FOLLOW_withClause_in_joins562);
							withClause83=withClause();
							state._fsp--;

							 
							if ( _first_1==null ) _first_1 = (CommonTree)withClause83.getTree();

							retval.tree = (CommonTree)_first_0;
							if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
								retval.tree = (CommonTree)adaptor.getParent(retval.tree);

							}
							break;

					}

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


						popStrategy();	
					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 2 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:239:4: ^( PERSISTER_JOIN joinType persisterSpaceRoot ( onClause )? )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					PERSISTER_JOIN84=(CommonTree)match(input,PERSISTER_JOIN,FOLLOW_PERSISTER_JOIN_in_joins574); 

					if ( _first_0==null ) _first_0 = PERSISTER_JOIN84;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_joinType_in_joins576);
					joinType85=joinType();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)joinType85.getTree();

					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_persisterSpaceRoot_in_joins578);
					persisterSpaceRoot86=persisterSpaceRoot();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)persisterSpaceRoot86.getTree();

					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:239:49: ( onClause )?
					int alt33=2;
					switch ( input.LA(1) ) {
						case ON:
							{
							alt33=1;
							}
							break;
					}
					switch (alt33) {
						case 1 :
							// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:239:49: onClause
							{
							_last = (CommonTree)input.LT(1);
							pushFollow(FOLLOW_onClause_in_joins580);
							onClause87=onClause();
							state._fsp--;

							 
							if ( _first_1==null ) _first_1 = (CommonTree)onClause87.getTree();

							retval.tree = (CommonTree)_first_0;
							if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
								retval.tree = (CommonTree)adaptor.getParent(retval.tree);

							}
							break;

					}

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "joins"


	public static class withClause_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "withClause"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:242:1: withClause : ^( WITH searchCondition ) ;
	public final GeneratedHQLResolver.withClause_return withClause() throws RecognitionException {
		GeneratedHQLResolver.withClause_return retval = new GeneratedHQLResolver.withClause_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree WITH88=null;
		TreeRuleReturnScope searchCondition89 =null;

		CommonTree WITH88_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:243:2: ( ^( WITH searchCondition ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:243:4: ^( WITH searchCondition )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			WITH88=(CommonTree)match(input,WITH,FOLLOW_WITH_in_withClause594); 

			if ( _first_0==null ) _first_0 = WITH88;
			match(input, Token.DOWN, null); 
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_searchCondition_in_withClause596);
			searchCondition89=searchCondition();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)searchCondition89.getTree();

			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "withClause"


	public static class onClause_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "onClause"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:246:1: onClause : ^( ON searchCondition ) ;
	public final GeneratedHQLResolver.onClause_return onClause() throws RecognitionException {
		GeneratedHQLResolver.onClause_return retval = new GeneratedHQLResolver.onClause_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree ON90=null;
		TreeRuleReturnScope searchCondition91 =null;

		CommonTree ON90_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:247:2: ( ^( ON searchCondition ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:247:4: ^( ON searchCondition )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			ON90=(CommonTree)match(input,ON,FOLLOW_ON_in_onClause609); 

			if ( _first_0==null ) _first_0 = ON90;
			match(input, Token.DOWN, null); 
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_searchCondition_in_onClause611);
			searchCondition91=searchCondition();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)searchCondition91.getTree();

			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "onClause"


	public static class joinType_return extends TreeRuleReturnScope {
		public JoinType joinType;
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "joinType"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:250:1: joinType returns [JoinType joinType] : ( CROSS | INNER | ( LEFT | RIGHT | FULL ) ( OUTER )? );
	public final GeneratedHQLResolver.joinType_return joinType() throws RecognitionException {
		GeneratedHQLResolver.joinType_return retval = new GeneratedHQLResolver.joinType_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree CROSS92=null;
		CommonTree INNER93=null;
		CommonTree LEFT94=null;
		CommonTree RIGHT95=null;
		CommonTree FULL96=null;
		CommonTree OUTER97=null;

		CommonTree CROSS92_tree=null;
		CommonTree INNER93_tree=null;
		CommonTree LEFT94_tree=null;
		CommonTree RIGHT95_tree=null;
		CommonTree FULL96_tree=null;
		CommonTree OUTER97_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:251:2: ( CROSS | INNER | ( LEFT | RIGHT | FULL ) ( OUTER )? )
			int alt37=3;
			switch ( input.LA(1) ) {
			case CROSS:
				{
				alt37=1;
				}
				break;
			case INNER:
				{
				alt37=2;
				}
				break;
			case FULL:
			case LEFT:
			case RIGHT:
				{
				alt37=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 37, 0, input);
				throw nvae;
			}
			switch (alt37) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:251:4: CROSS
					{
					_last = (CommonTree)input.LT(1);
					CROSS92=(CommonTree)match(input,CROSS,FOLLOW_CROSS_in_joinType627); 
					 
					if ( _first_0==null ) _first_0 = CROSS92;

						retval.joinType = JoinType.CROSS;	
					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 2 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:252:4: INNER
					{
					_last = (CommonTree)input.LT(1);
					INNER93=(CommonTree)match(input,INNER,FOLLOW_INNER_in_joinType634); 
					 
					if ( _first_0==null ) _first_0 = INNER93;

						retval.joinType = JoinType.INNER;	
					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 3 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:253:4: ( LEFT | RIGHT | FULL ) ( OUTER )?
					{
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:253:4: ( LEFT | RIGHT | FULL )
					int alt35=3;
					switch ( input.LA(1) ) {
					case LEFT:
						{
						alt35=1;
						}
						break;
					case RIGHT:
						{
						alt35=2;
						}
						break;
					case FULL:
						{
						alt35=3;
						}
						break;
					default:
						NoViableAltException nvae =
							new NoViableAltException("", 35, 0, input);
						throw nvae;
					}
					switch (alt35) {
						case 1 :
							// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:253:5: LEFT
							{
							_last = (CommonTree)input.LT(1);
							LEFT94=(CommonTree)match(input,LEFT,FOLLOW_LEFT_in_joinType642); 
							 
							if ( _first_0==null ) _first_0 = LEFT94;

								retval.joinType = JoinType.LEFT;	
							retval.tree = (CommonTree)_first_0;
							if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
								retval.tree = (CommonTree)adaptor.getParent(retval.tree);

							}
							break;
						case 2 :
							// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:253:43: RIGHT
							{
							_last = (CommonTree)input.LT(1);
							RIGHT95=(CommonTree)match(input,RIGHT,FOLLOW_RIGHT_in_joinType648); 
							 
							if ( _first_0==null ) _first_0 = RIGHT95;

								retval.joinType = JoinType.RIGHT;	
							retval.tree = (CommonTree)_first_0;
							if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
								retval.tree = (CommonTree)adaptor.getParent(retval.tree);

							}
							break;
						case 3 :
							// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:253:83: FULL
							{
							_last = (CommonTree)input.LT(1);
							FULL96=(CommonTree)match(input,FULL,FOLLOW_FULL_in_joinType654); 
							 
							if ( _first_0==null ) _first_0 = FULL96;

								retval.joinType = JoinType.FULL;	
							retval.tree = (CommonTree)_first_0;
							if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
								retval.tree = (CommonTree)adaptor.getParent(retval.tree);

							}
							break;

					}

					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:253:120: ( OUTER )?
					int alt36=2;
					switch ( input.LA(1) ) {
						case OUTER:
							{
							alt36=1;
							}
							break;
					}
					switch (alt36) {
						case 1 :
							// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:253:120: OUTER
							{
							_last = (CommonTree)input.LT(1);
							OUTER97=(CommonTree)match(input,OUTER,FOLLOW_OUTER_in_joinType659); 
							 
							if ( _first_0==null ) _first_0 = OUTER97;

							retval.tree = (CommonTree)_first_0;
							if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
								retval.tree = (CommonTree)adaptor.getParent(retval.tree);

							}
							break;

					}

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "joinType"


	public static class selectClause_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "selectClause"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:256:1: selectClause : ^( SELECT ( DISTINCT )? rootSelectExpression ) ;
	public final GeneratedHQLResolver.selectClause_return selectClause() throws RecognitionException {
		GeneratedHQLResolver.selectClause_return retval = new GeneratedHQLResolver.selectClause_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree SELECT98=null;
		CommonTree DISTINCT99=null;
		TreeRuleReturnScope rootSelectExpression100 =null;

		CommonTree SELECT98_tree=null;
		CommonTree DISTINCT99_tree=null;

			if (state.backtracking == 0) pushSelectStrategy();	
		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:259:2: ( ^( SELECT ( DISTINCT )? rootSelectExpression ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:259:4: ^( SELECT ( DISTINCT )? rootSelectExpression )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			SELECT98=(CommonTree)match(input,SELECT,FOLLOW_SELECT_in_selectClause682); 

			if ( _first_0==null ) _first_0 = SELECT98;
			match(input, Token.DOWN, null); 
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:259:13: ( DISTINCT )?
			int alt38=2;
			switch ( input.LA(1) ) {
				case DISTINCT:
					{
					alt38=1;
					}
					break;
			}
			switch (alt38) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:259:13: DISTINCT
					{
					_last = (CommonTree)input.LT(1);
					DISTINCT99=(CommonTree)match(input,DISTINCT,FOLLOW_DISTINCT_in_selectClause684); 
					 
					if ( _first_1==null ) _first_1 = DISTINCT99;

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

			}

			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_rootSelectExpression_in_selectClause687);
			rootSelectExpression100=rootSelectExpression();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)rootSelectExpression100.getTree();

			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

				popStrategy();	
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "selectClause"


	public static class rootSelectExpression_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "rootSelectExpression"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:262:1: rootSelectExpression : ( ^( SELECT_LIST ( rootSelectExpression )+ ) | ^( SELECT_ITEM rootSelectExpression ) | ^( DYNAMIC_INSTANTIATION ( rootSelectExpression )+ ) | ^( DYNAMIC_INSTANTIATION_ARG rootSelectExpression ) | valueExpression ( ALIAS_NAME )? );
	public final GeneratedHQLResolver.rootSelectExpression_return rootSelectExpression() throws RecognitionException {
		GeneratedHQLResolver.rootSelectExpression_return retval = new GeneratedHQLResolver.rootSelectExpression_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree SELECT_LIST101=null;
		CommonTree SELECT_ITEM103=null;
		CommonTree DYNAMIC_INSTANTIATION105=null;
		CommonTree DYNAMIC_INSTANTIATION_ARG107=null;
		CommonTree ALIAS_NAME110=null;
		TreeRuleReturnScope rootSelectExpression102 =null;
		TreeRuleReturnScope rootSelectExpression104 =null;
		TreeRuleReturnScope rootSelectExpression106 =null;
		TreeRuleReturnScope rootSelectExpression108 =null;
		TreeRuleReturnScope valueExpression109 =null;

		CommonTree SELECT_LIST101_tree=null;
		CommonTree SELECT_ITEM103_tree=null;
		CommonTree DYNAMIC_INSTANTIATION105_tree=null;
		CommonTree DYNAMIC_INSTANTIATION_ARG107_tree=null;
		CommonTree ALIAS_NAME110_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:263:2: ( ^( SELECT_LIST ( rootSelectExpression )+ ) | ^( SELECT_ITEM rootSelectExpression ) | ^( DYNAMIC_INSTANTIATION ( rootSelectExpression )+ ) | ^( DYNAMIC_INSTANTIATION_ARG rootSelectExpression ) | valueExpression ( ALIAS_NAME )? )
			int alt42=5;
			switch ( input.LA(1) ) {
			case SELECT_LIST:
				{
				alt42=1;
				}
				break;
			case SELECT_ITEM:
				{
				alt42=2;
				}
				break;
			case DYNAMIC_INSTANTIATION:
				{
				alt42=3;
				}
				break;
			case DYNAMIC_INSTANTIATION_ARG:
				{
				alt42=4;
				}
				break;
			case ABS:
			case ALIAS_REF:
			case ALL:
			case ANY:
			case ASTERISK:
			case AVG:
			case BIT_LENGTH:
			case CAST:
			case CHARACTER_LENGTH:
			case CHARACTER_LITERAL:
			case COALESCE:
			case CONCAT:
			case CONST_STRING_VALUE:
			case COUNT:
			case CURRENT_DATE:
			case CURRENT_TIME:
			case CURRENT_TIMESTAMP:
			case DECIMAL_LITERAL:
			case DOT_CLASS:
			case DOUBLE_PIPE:
			case ELEMENTS:
			case EXISTS:
			case EXTRACT:
			case FALSE:
			case FLOATING_POINT_LITERAL:
			case FUNCTION:
			case HEX_LITERAL:
			case INDEX:
			case INDICES:
			case INTEGER_LITERAL:
			case JAVA_CONSTANT:
			case JPA_PARAM:
			case LENGTH:
			case LOCATE:
			case LOWER:
			case MAX:
			case MAXELEMENT:
			case MAXINDEX:
			case MIN:
			case MINELEMENT:
			case MININDEX:
			case MINUS:
			case MOD:
			case NAMED_PARAM:
			case NULL:
			case NULLIF:
			case OCTAL_LITERAL:
			case OCTET_LENGTH:
			case PARAM:
			case PATH:
			case PLUS:
			case POSITION:
			case PROPERTY_REFERENCE:
			case SEARCHED_CASE:
			case SIMPLE_CASE:
			case SIZE:
			case SOLIDUS:
			case SOME:
			case SQRT:
			case STRING_LITERAL:
			case SUBSTRING:
			case SUB_QUERY:
			case SUM:
			case TRIM:
			case TRUE:
			case UNARY_MINUS:
			case UNARY_PLUS:
			case UPPER:
			case VECTOR_EXPR:
				{
				alt42=5;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 42, 0, input);
				throw nvae;
			}
			switch (alt42) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:263:4: ^( SELECT_LIST ( rootSelectExpression )+ )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					SELECT_LIST101=(CommonTree)match(input,SELECT_LIST,FOLLOW_SELECT_LIST_in_rootSelectExpression701); 

					if ( _first_0==null ) _first_0 = SELECT_LIST101;
					match(input, Token.DOWN, null); 
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:263:18: ( rootSelectExpression )+
					int cnt39=0;
					loop39:
					do {
						int alt39=2;
						switch ( input.LA(1) ) {
						case ABS:
						case ALIAS_REF:
						case ALL:
						case ANY:
						case ASTERISK:
						case AVG:
						case BIT_LENGTH:
						case CAST:
						case CHARACTER_LENGTH:
						case CHARACTER_LITERAL:
						case COALESCE:
						case CONCAT:
						case CONST_STRING_VALUE:
						case COUNT:
						case CURRENT_DATE:
						case CURRENT_TIME:
						case CURRENT_TIMESTAMP:
						case DECIMAL_LITERAL:
						case DOT_CLASS:
						case DOUBLE_PIPE:
						case DYNAMIC_INSTANTIATION:
						case DYNAMIC_INSTANTIATION_ARG:
						case ELEMENTS:
						case EXISTS:
						case EXTRACT:
						case FALSE:
						case FLOATING_POINT_LITERAL:
						case FUNCTION:
						case HEX_LITERAL:
						case INDEX:
						case INDICES:
						case INTEGER_LITERAL:
						case JAVA_CONSTANT:
						case JPA_PARAM:
						case LENGTH:
						case LOCATE:
						case LOWER:
						case MAX:
						case MAXELEMENT:
						case MAXINDEX:
						case MIN:
						case MINELEMENT:
						case MININDEX:
						case MINUS:
						case MOD:
						case NAMED_PARAM:
						case NULL:
						case NULLIF:
						case OCTAL_LITERAL:
						case OCTET_LENGTH:
						case PARAM:
						case PATH:
						case PLUS:
						case POSITION:
						case PROPERTY_REFERENCE:
						case SEARCHED_CASE:
						case SELECT_ITEM:
						case SELECT_LIST:
						case SIMPLE_CASE:
						case SIZE:
						case SOLIDUS:
						case SOME:
						case SQRT:
						case STRING_LITERAL:
						case SUBSTRING:
						case SUB_QUERY:
						case SUM:
						case TRIM:
						case TRUE:
						case UNARY_MINUS:
						case UNARY_PLUS:
						case UPPER:
						case VECTOR_EXPR:
							{
							alt39=1;
							}
							break;
						}
						switch (alt39) {
						case 1 :
							// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:263:18: rootSelectExpression
							{
							_last = (CommonTree)input.LT(1);
							pushFollow(FOLLOW_rootSelectExpression_in_rootSelectExpression703);
							rootSelectExpression102=rootSelectExpression();
							state._fsp--;

							 
							if ( _first_1==null ) _first_1 = (CommonTree)rootSelectExpression102.getTree();

							retval.tree = (CommonTree)_first_0;
							if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
								retval.tree = (CommonTree)adaptor.getParent(retval.tree);

							}
							break;

						default :
							if ( cnt39 >= 1 ) break loop39;
								EarlyExitException eee =
									new EarlyExitException(39, input);
								throw eee;
						}
						cnt39++;
					} while (true);

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 2 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:264:4: ^( SELECT_ITEM rootSelectExpression )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					SELECT_ITEM103=(CommonTree)match(input,SELECT_ITEM,FOLLOW_SELECT_ITEM_in_rootSelectExpression711); 

					if ( _first_0==null ) _first_0 = SELECT_ITEM103;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_rootSelectExpression_in_rootSelectExpression713);
					rootSelectExpression104=rootSelectExpression();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)rootSelectExpression104.getTree();

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 3 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:265:4: ^( DYNAMIC_INSTANTIATION ( rootSelectExpression )+ )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					DYNAMIC_INSTANTIATION105=(CommonTree)match(input,DYNAMIC_INSTANTIATION,FOLLOW_DYNAMIC_INSTANTIATION_in_rootSelectExpression720); 

					if ( _first_0==null ) _first_0 = DYNAMIC_INSTANTIATION105;
					match(input, Token.DOWN, null); 
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:265:28: ( rootSelectExpression )+
					int cnt40=0;
					loop40:
					do {
						int alt40=2;
						switch ( input.LA(1) ) {
						case ABS:
						case ALIAS_REF:
						case ALL:
						case ANY:
						case ASTERISK:
						case AVG:
						case BIT_LENGTH:
						case CAST:
						case CHARACTER_LENGTH:
						case CHARACTER_LITERAL:
						case COALESCE:
						case CONCAT:
						case CONST_STRING_VALUE:
						case COUNT:
						case CURRENT_DATE:
						case CURRENT_TIME:
						case CURRENT_TIMESTAMP:
						case DECIMAL_LITERAL:
						case DOT_CLASS:
						case DOUBLE_PIPE:
						case DYNAMIC_INSTANTIATION:
						case DYNAMIC_INSTANTIATION_ARG:
						case ELEMENTS:
						case EXISTS:
						case EXTRACT:
						case FALSE:
						case FLOATING_POINT_LITERAL:
						case FUNCTION:
						case HEX_LITERAL:
						case INDEX:
						case INDICES:
						case INTEGER_LITERAL:
						case JAVA_CONSTANT:
						case JPA_PARAM:
						case LENGTH:
						case LOCATE:
						case LOWER:
						case MAX:
						case MAXELEMENT:
						case MAXINDEX:
						case MIN:
						case MINELEMENT:
						case MININDEX:
						case MINUS:
						case MOD:
						case NAMED_PARAM:
						case NULL:
						case NULLIF:
						case OCTAL_LITERAL:
						case OCTET_LENGTH:
						case PARAM:
						case PATH:
						case PLUS:
						case POSITION:
						case PROPERTY_REFERENCE:
						case SEARCHED_CASE:
						case SELECT_ITEM:
						case SELECT_LIST:
						case SIMPLE_CASE:
						case SIZE:
						case SOLIDUS:
						case SOME:
						case SQRT:
						case STRING_LITERAL:
						case SUBSTRING:
						case SUB_QUERY:
						case SUM:
						case TRIM:
						case TRUE:
						case UNARY_MINUS:
						case UNARY_PLUS:
						case UPPER:
						case VECTOR_EXPR:
							{
							alt40=1;
							}
							break;
						}
						switch (alt40) {
						case 1 :
							// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:265:28: rootSelectExpression
							{
							_last = (CommonTree)input.LT(1);
							pushFollow(FOLLOW_rootSelectExpression_in_rootSelectExpression722);
							rootSelectExpression106=rootSelectExpression();
							state._fsp--;

							 
							if ( _first_1==null ) _first_1 = (CommonTree)rootSelectExpression106.getTree();

							retval.tree = (CommonTree)_first_0;
							if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
								retval.tree = (CommonTree)adaptor.getParent(retval.tree);

							}
							break;

						default :
							if ( cnt40 >= 1 ) break loop40;
								EarlyExitException eee =
									new EarlyExitException(40, input);
								throw eee;
						}
						cnt40++;
					} while (true);

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 4 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:266:4: ^( DYNAMIC_INSTANTIATION_ARG rootSelectExpression )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					DYNAMIC_INSTANTIATION_ARG107=(CommonTree)match(input,DYNAMIC_INSTANTIATION_ARG,FOLLOW_DYNAMIC_INSTANTIATION_ARG_in_rootSelectExpression730); 

					if ( _first_0==null ) _first_0 = DYNAMIC_INSTANTIATION_ARG107;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_rootSelectExpression_in_rootSelectExpression732);
					rootSelectExpression108=rootSelectExpression();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)rootSelectExpression108.getTree();

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 5 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:267:4: valueExpression ( ALIAS_NAME )?
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_valueExpression_in_rootSelectExpression738);
					valueExpression109=valueExpression();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)valueExpression109.getTree();

					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:267:20: ( ALIAS_NAME )?
					int alt41=2;
					switch ( input.LA(1) ) {
						case ALIAS_NAME:
							{
							alt41=1;
							}
							break;
					}
					switch (alt41) {
						case 1 :
							// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:267:20: ALIAS_NAME
							{
							_last = (CommonTree)input.LT(1);
							ALIAS_NAME110=(CommonTree)match(input,ALIAS_NAME,FOLLOW_ALIAS_NAME_in_rootSelectExpression740); 
							 
							if ( _first_0==null ) _first_0 = ALIAS_NAME110;

							retval.tree = (CommonTree)_first_0;
							if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
								retval.tree = (CommonTree)adaptor.getParent(retval.tree);

							}
							break;

					}

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "rootSelectExpression"


	public static class orderByClause_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "orderByClause"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:270:1: orderByClause : ^( ORDER_BY ( sortSpecification )+ ) ;
	public final GeneratedHQLResolver.orderByClause_return orderByClause() throws RecognitionException {
		GeneratedHQLResolver.orderByClause_return retval = new GeneratedHQLResolver.orderByClause_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree ORDER_BY111=null;
		TreeRuleReturnScope sortSpecification112 =null;

		CommonTree ORDER_BY111_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:271:2: ( ^( ORDER_BY ( sortSpecification )+ ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:271:4: ^( ORDER_BY ( sortSpecification )+ )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			ORDER_BY111=(CommonTree)match(input,ORDER_BY,FOLLOW_ORDER_BY_in_orderByClause753); 

			if ( _first_0==null ) _first_0 = ORDER_BY111;
			match(input, Token.DOWN, null); 
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:271:15: ( sortSpecification )+
			int cnt43=0;
			loop43:
			do {
				int alt43=2;
				switch ( input.LA(1) ) {
				case SORT_SPEC:
					{
					alt43=1;
					}
					break;
				}
				switch (alt43) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:271:15: sortSpecification
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_sortSpecification_in_orderByClause755);
					sortSpecification112=sortSpecification();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)sortSpecification112.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

				default :
					if ( cnt43 >= 1 ) break loop43;
						EarlyExitException eee =
							new EarlyExitException(43, input);
						throw eee;
				}
				cnt43++;
			} while (true);

			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "orderByClause"


	public static class sortSpecification_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "sortSpecification"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:274:1: sortSpecification : ^( SORT_SPEC valueExpression ( COLLATE )? ORDER_SPEC ) ;
	public final GeneratedHQLResolver.sortSpecification_return sortSpecification() throws RecognitionException {
		GeneratedHQLResolver.sortSpecification_return retval = new GeneratedHQLResolver.sortSpecification_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree SORT_SPEC113=null;
		CommonTree COLLATE115=null;
		CommonTree ORDER_SPEC116=null;
		TreeRuleReturnScope valueExpression114 =null;

		CommonTree SORT_SPEC113_tree=null;
		CommonTree COLLATE115_tree=null;
		CommonTree ORDER_SPEC116_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:275:2: ( ^( SORT_SPEC valueExpression ( COLLATE )? ORDER_SPEC ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:275:4: ^( SORT_SPEC valueExpression ( COLLATE )? ORDER_SPEC )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			SORT_SPEC113=(CommonTree)match(input,SORT_SPEC,FOLLOW_SORT_SPEC_in_sortSpecification769); 

			if ( _first_0==null ) _first_0 = SORT_SPEC113;
			match(input, Token.DOWN, null); 
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_valueExpression_in_sortSpecification771);
			valueExpression114=valueExpression();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)valueExpression114.getTree();

			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:275:32: ( COLLATE )?
			int alt44=2;
			switch ( input.LA(1) ) {
				case COLLATE:
					{
					alt44=1;
					}
					break;
			}
			switch (alt44) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:275:32: COLLATE
					{
					_last = (CommonTree)input.LT(1);
					COLLATE115=(CommonTree)match(input,COLLATE,FOLLOW_COLLATE_in_sortSpecification773); 
					 
					if ( _first_1==null ) _first_1 = COLLATE115;

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

			}

			_last = (CommonTree)input.LT(1);
			ORDER_SPEC116=(CommonTree)match(input,ORDER_SPEC,FOLLOW_ORDER_SPEC_in_sortSpecification776); 
			 
			if ( _first_1==null ) _first_1 = ORDER_SPEC116;

			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "sortSpecification"


	public static class searchCondition_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "searchCondition"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:278:1: searchCondition : ( ^( OR searchCondition searchCondition ) | ^( AND searchCondition searchCondition ) | ^( NOT searchCondition ) | predicate );
	public final GeneratedHQLResolver.searchCondition_return searchCondition() throws RecognitionException {
		GeneratedHQLResolver.searchCondition_return retval = new GeneratedHQLResolver.searchCondition_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree OR117=null;
		CommonTree AND120=null;
		CommonTree NOT123=null;
		TreeRuleReturnScope searchCondition118 =null;
		TreeRuleReturnScope searchCondition119 =null;
		TreeRuleReturnScope searchCondition121 =null;
		TreeRuleReturnScope searchCondition122 =null;
		TreeRuleReturnScope searchCondition124 =null;
		TreeRuleReturnScope predicate125 =null;

		CommonTree OR117_tree=null;
		CommonTree AND120_tree=null;
		CommonTree NOT123_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:279:2: ( ^( OR searchCondition searchCondition ) | ^( AND searchCondition searchCondition ) | ^( NOT searchCondition ) | predicate )
			int alt45=4;
			switch ( input.LA(1) ) {
			case OR:
				{
				alt45=1;
				}
				break;
			case AND:
				{
				alt45=2;
				}
				break;
			case NOT:
				{
				alt45=3;
				}
				break;
			case ABS:
			case ALIAS_REF:
			case ALL:
			case ANY:
			case ASTERISK:
			case AVG:
			case BETWEEN:
			case BIT_LENGTH:
			case CAST:
			case CHARACTER_LENGTH:
			case CHARACTER_LITERAL:
			case COALESCE:
			case CONCAT:
			case CONST_STRING_VALUE:
			case COUNT:
			case CURRENT_DATE:
			case CURRENT_TIME:
			case CURRENT_TIMESTAMP:
			case DECIMAL_LITERAL:
			case DOT_CLASS:
			case DOUBLE_PIPE:
			case ELEMENTS:
			case EQUALS:
			case EXISTS:
			case EXTRACT:
			case FALSE:
			case FLOATING_POINT_LITERAL:
			case FUNCTION:
			case GREATER:
			case GREATER_EQUAL:
			case HEX_LITERAL:
			case IN:
			case INDEX:
			case INDICES:
			case INTEGER_LITERAL:
			case IS_EMPTY:
			case IS_NOT_EMPTY:
			case IS_NOT_NULL:
			case IS_NULL:
			case JAVA_CONSTANT:
			case JPA_PARAM:
			case LENGTH:
			case LESS:
			case LESS_EQUAL:
			case LIKE:
			case LOCATE:
			case LOWER:
			case MAX:
			case MAXELEMENT:
			case MAXINDEX:
			case MEMBER_OF:
			case MIN:
			case MINELEMENT:
			case MININDEX:
			case MINUS:
			case MOD:
			case NAMED_PARAM:
			case NOT_BETWEEN:
			case NOT_EQUAL:
			case NOT_IN:
			case NOT_LIKE:
			case NOT_MEMBER_OF:
			case NULL:
			case NULLIF:
			case OCTAL_LITERAL:
			case OCTET_LENGTH:
			case PARAM:
			case PATH:
			case PLUS:
			case POSITION:
			case PROPERTY_REFERENCE:
			case SEARCHED_CASE:
			case SIMPLE_CASE:
			case SIZE:
			case SOLIDUS:
			case SOME:
			case SQRT:
			case STRING_LITERAL:
			case SUBSTRING:
			case SUB_QUERY:
			case SUM:
			case TRIM:
			case TRUE:
			case UNARY_MINUS:
			case UNARY_PLUS:
			case UPPER:
			case VECTOR_EXPR:
				{
				alt45=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 45, 0, input);
				throw nvae;
			}
			switch (alt45) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:279:4: ^( OR searchCondition searchCondition )
					{
					 activateOR(); 
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					OR117=(CommonTree)match(input,OR,FOLLOW_OR_in_searchCondition792); 

					if ( _first_0==null ) _first_0 = OR117;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_searchCondition_in_searchCondition794);
					searchCondition118=searchCondition();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)searchCondition118.getTree();

					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_searchCondition_in_searchCondition796);
					searchCondition119=searchCondition();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)searchCondition119.getTree();

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					 deactivateBoolean(); 
					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 2 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:280:4: ^( AND searchCondition searchCondition )
					{
					 activateAND(); 
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					AND120=(CommonTree)match(input,AND,FOLLOW_AND_in_searchCondition809); 

					if ( _first_0==null ) _first_0 = AND120;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_searchCondition_in_searchCondition811);
					searchCondition121=searchCondition();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)searchCondition121.getTree();

					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_searchCondition_in_searchCondition813);
					searchCondition122=searchCondition();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)searchCondition122.getTree();

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					 deactivateBoolean(); 
					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 3 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:281:4: ^( NOT searchCondition )
					{
					 activateNOT(); 
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					NOT123=(CommonTree)match(input,NOT,FOLLOW_NOT_in_searchCondition826); 

					if ( _first_0==null ) _first_0 = NOT123;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_searchCondition_in_searchCondition828);
					searchCondition124=searchCondition();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)searchCondition124.getTree();

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					 deactivateBoolean(); 
					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 4 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:282:4: predicate
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_predicate_in_searchCondition837);
					predicate125=predicate();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)predicate125.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "searchCondition"


	public static class predicate_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "predicate"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:285:1: predicate : ( ^( EQUALS rowValueConstructor comparativePredicateValue ) | ^( NOT_EQUAL rowValueConstructor comparativePredicateValue ) | ^( LESS rowValueConstructor comparativePredicateValue ) | ^( LESS_EQUAL rowValueConstructor comparativePredicateValue ) | ^( GREATER rowValueConstructor comparativePredicateValue ) | ^( GREATER_EQUAL rowValueConstructor comparativePredicateValue ) | ^( IS_NULL rowValueConstructor ) | ^( IS_NOT_NULL rowValueConstructor ) | ^( LIKE valueExpression valueExpression ( escapeSpecification )? ) | ^( NOT_LIKE valueExpression valueExpression ( escapeSpecification )? ) | ^( BETWEEN rowValueConstructor betweenList ) | ^( NOT_BETWEEN rowValueConstructor betweenList ) | ^( IN rowValueConstructor inPredicateValue ) | ^( NOT_IN rowValueConstructor inPredicateValue ) | ^( MEMBER_OF rowValueConstructor rowValueConstructor ) | ^( NOT_MEMBER_OF rowValueConstructor rowValueConstructor ) | ^( IS_EMPTY rowValueConstructor ) | ^( IS_NOT_EMPTY rowValueConstructor ) | rowValueConstructor );
	public final GeneratedHQLResolver.predicate_return predicate() throws RecognitionException {
		GeneratedHQLResolver.predicate_return retval = new GeneratedHQLResolver.predicate_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree EQUALS126=null;
		CommonTree NOT_EQUAL129=null;
		CommonTree LESS132=null;
		CommonTree LESS_EQUAL135=null;
		CommonTree GREATER138=null;
		CommonTree GREATER_EQUAL141=null;
		CommonTree IS_NULL144=null;
		CommonTree IS_NOT_NULL146=null;
		CommonTree LIKE148=null;
		CommonTree NOT_LIKE152=null;
		CommonTree BETWEEN156=null;
		CommonTree NOT_BETWEEN159=null;
		CommonTree IN162=null;
		CommonTree NOT_IN165=null;
		CommonTree MEMBER_OF168=null;
		CommonTree NOT_MEMBER_OF171=null;
		CommonTree IS_EMPTY174=null;
		CommonTree IS_NOT_EMPTY176=null;
		TreeRuleReturnScope rowValueConstructor127 =null;
		TreeRuleReturnScope comparativePredicateValue128 =null;
		TreeRuleReturnScope rowValueConstructor130 =null;
		TreeRuleReturnScope comparativePredicateValue131 =null;
		TreeRuleReturnScope rowValueConstructor133 =null;
		TreeRuleReturnScope comparativePredicateValue134 =null;
		TreeRuleReturnScope rowValueConstructor136 =null;
		TreeRuleReturnScope comparativePredicateValue137 =null;
		TreeRuleReturnScope rowValueConstructor139 =null;
		TreeRuleReturnScope comparativePredicateValue140 =null;
		TreeRuleReturnScope rowValueConstructor142 =null;
		TreeRuleReturnScope comparativePredicateValue143 =null;
		TreeRuleReturnScope rowValueConstructor145 =null;
		TreeRuleReturnScope rowValueConstructor147 =null;
		TreeRuleReturnScope valueExpression149 =null;
		TreeRuleReturnScope valueExpression150 =null;
		TreeRuleReturnScope escapeSpecification151 =null;
		TreeRuleReturnScope valueExpression153 =null;
		TreeRuleReturnScope valueExpression154 =null;
		TreeRuleReturnScope escapeSpecification155 =null;
		TreeRuleReturnScope rowValueConstructor157 =null;
		TreeRuleReturnScope betweenList158 =null;
		TreeRuleReturnScope rowValueConstructor160 =null;
		TreeRuleReturnScope betweenList161 =null;
		TreeRuleReturnScope rowValueConstructor163 =null;
		TreeRuleReturnScope inPredicateValue164 =null;
		TreeRuleReturnScope rowValueConstructor166 =null;
		TreeRuleReturnScope inPredicateValue167 =null;
		TreeRuleReturnScope rowValueConstructor169 =null;
		TreeRuleReturnScope rowValueConstructor170 =null;
		TreeRuleReturnScope rowValueConstructor172 =null;
		TreeRuleReturnScope rowValueConstructor173 =null;
		TreeRuleReturnScope rowValueConstructor175 =null;
		TreeRuleReturnScope rowValueConstructor177 =null;
		TreeRuleReturnScope rowValueConstructor178 =null;

		CommonTree EQUALS126_tree=null;
		CommonTree NOT_EQUAL129_tree=null;
		CommonTree LESS132_tree=null;
		CommonTree LESS_EQUAL135_tree=null;
		CommonTree GREATER138_tree=null;
		CommonTree GREATER_EQUAL141_tree=null;
		CommonTree IS_NULL144_tree=null;
		CommonTree IS_NOT_NULL146_tree=null;
		CommonTree LIKE148_tree=null;
		CommonTree NOT_LIKE152_tree=null;
		CommonTree BETWEEN156_tree=null;
		CommonTree NOT_BETWEEN159_tree=null;
		CommonTree IN162_tree=null;
		CommonTree NOT_IN165_tree=null;
		CommonTree MEMBER_OF168_tree=null;
		CommonTree NOT_MEMBER_OF171_tree=null;
		CommonTree IS_EMPTY174_tree=null;
		CommonTree IS_NOT_EMPTY176_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:286:2: ( ^( EQUALS rowValueConstructor comparativePredicateValue ) | ^( NOT_EQUAL rowValueConstructor comparativePredicateValue ) | ^( LESS rowValueConstructor comparativePredicateValue ) | ^( LESS_EQUAL rowValueConstructor comparativePredicateValue ) | ^( GREATER rowValueConstructor comparativePredicateValue ) | ^( GREATER_EQUAL rowValueConstructor comparativePredicateValue ) | ^( IS_NULL rowValueConstructor ) | ^( IS_NOT_NULL rowValueConstructor ) | ^( LIKE valueExpression valueExpression ( escapeSpecification )? ) | ^( NOT_LIKE valueExpression valueExpression ( escapeSpecification )? ) | ^( BETWEEN rowValueConstructor betweenList ) | ^( NOT_BETWEEN rowValueConstructor betweenList ) | ^( IN rowValueConstructor inPredicateValue ) | ^( NOT_IN rowValueConstructor inPredicateValue ) | ^( MEMBER_OF rowValueConstructor rowValueConstructor ) | ^( NOT_MEMBER_OF rowValueConstructor rowValueConstructor ) | ^( IS_EMPTY rowValueConstructor ) | ^( IS_NOT_EMPTY rowValueConstructor ) | rowValueConstructor )
			int alt48=19;
			switch ( input.LA(1) ) {
			case EQUALS:
				{
				alt48=1;
				}
				break;
			case NOT_EQUAL:
				{
				alt48=2;
				}
				break;
			case LESS:
				{
				alt48=3;
				}
				break;
			case LESS_EQUAL:
				{
				alt48=4;
				}
				break;
			case GREATER:
				{
				alt48=5;
				}
				break;
			case GREATER_EQUAL:
				{
				alt48=6;
				}
				break;
			case IS_NULL:
				{
				alt48=7;
				}
				break;
			case IS_NOT_NULL:
				{
				alt48=8;
				}
				break;
			case LIKE:
				{
				alt48=9;
				}
				break;
			case NOT_LIKE:
				{
				alt48=10;
				}
				break;
			case BETWEEN:
				{
				alt48=11;
				}
				break;
			case NOT_BETWEEN:
				{
				alt48=12;
				}
				break;
			case IN:
				{
				alt48=13;
				}
				break;
			case NOT_IN:
				{
				alt48=14;
				}
				break;
			case MEMBER_OF:
				{
				alt48=15;
				}
				break;
			case NOT_MEMBER_OF:
				{
				alt48=16;
				}
				break;
			case IS_EMPTY:
				{
				alt48=17;
				}
				break;
			case IS_NOT_EMPTY:
				{
				alt48=18;
				}
				break;
			case ABS:
			case ALIAS_REF:
			case ALL:
			case ANY:
			case ASTERISK:
			case AVG:
			case BIT_LENGTH:
			case CAST:
			case CHARACTER_LENGTH:
			case CHARACTER_LITERAL:
			case COALESCE:
			case CONCAT:
			case CONST_STRING_VALUE:
			case COUNT:
			case CURRENT_DATE:
			case CURRENT_TIME:
			case CURRENT_TIMESTAMP:
			case DECIMAL_LITERAL:
			case DOT_CLASS:
			case DOUBLE_PIPE:
			case ELEMENTS:
			case EXISTS:
			case EXTRACT:
			case FALSE:
			case FLOATING_POINT_LITERAL:
			case FUNCTION:
			case HEX_LITERAL:
			case INDEX:
			case INDICES:
			case INTEGER_LITERAL:
			case JAVA_CONSTANT:
			case JPA_PARAM:
			case LENGTH:
			case LOCATE:
			case LOWER:
			case MAX:
			case MAXELEMENT:
			case MAXINDEX:
			case MIN:
			case MINELEMENT:
			case MININDEX:
			case MINUS:
			case MOD:
			case NAMED_PARAM:
			case NULL:
			case NULLIF:
			case OCTAL_LITERAL:
			case OCTET_LENGTH:
			case PARAM:
			case PATH:
			case PLUS:
			case POSITION:
			case PROPERTY_REFERENCE:
			case SEARCHED_CASE:
			case SIMPLE_CASE:
			case SIZE:
			case SOLIDUS:
			case SOME:
			case SQRT:
			case STRING_LITERAL:
			case SUBSTRING:
			case SUB_QUERY:
			case SUM:
			case TRIM:
			case TRUE:
			case UNARY_MINUS:
			case UNARY_PLUS:
			case UPPER:
			case VECTOR_EXPR:
				{
				alt48=19;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 48, 0, input);
				throw nvae;
			}
			switch (alt48) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:286:4: ^( EQUALS rowValueConstructor comparativePredicateValue )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					EQUALS126=(CommonTree)match(input,EQUALS,FOLLOW_EQUALS_in_predicate850); 

					if ( _first_0==null ) _first_0 = EQUALS126;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_rowValueConstructor_in_predicate852);
					rowValueConstructor127=rowValueConstructor();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)rowValueConstructor127.getTree();

					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_comparativePredicateValue_in_predicate854);
					comparativePredicateValue128=comparativePredicateValue();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)comparativePredicateValue128.getTree();

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					 predicateEquals( (comparativePredicateValue128!=null?(input.getTokenStream().toString(input.getTreeAdaptor().getTokenStartIndex(comparativePredicateValue128.start),input.getTreeAdaptor().getTokenStopIndex(comparativePredicateValue128.start))):null)); 
					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 2 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:287:4: ^( NOT_EQUAL rowValueConstructor comparativePredicateValue )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					NOT_EQUAL129=(CommonTree)match(input,NOT_EQUAL,FOLLOW_NOT_EQUAL_in_predicate865); 

					if ( _first_0==null ) _first_0 = NOT_EQUAL129;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_rowValueConstructor_in_predicate867);
					rowValueConstructor130=rowValueConstructor();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)rowValueConstructor130.getTree();

					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_comparativePredicateValue_in_predicate869);
					comparativePredicateValue131=comparativePredicateValue();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)comparativePredicateValue131.getTree();

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 3 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:288:4: ^( LESS rowValueConstructor comparativePredicateValue )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					LESS132=(CommonTree)match(input,LESS,FOLLOW_LESS_in_predicate878); 

					if ( _first_0==null ) _first_0 = LESS132;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_rowValueConstructor_in_predicate880);
					rowValueConstructor133=rowValueConstructor();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)rowValueConstructor133.getTree();

					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_comparativePredicateValue_in_predicate882);
					comparativePredicateValue134=comparativePredicateValue();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)comparativePredicateValue134.getTree();

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 4 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:289:4: ^( LESS_EQUAL rowValueConstructor comparativePredicateValue )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					LESS_EQUAL135=(CommonTree)match(input,LESS_EQUAL,FOLLOW_LESS_EQUAL_in_predicate891); 

					if ( _first_0==null ) _first_0 = LESS_EQUAL135;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_rowValueConstructor_in_predicate893);
					rowValueConstructor136=rowValueConstructor();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)rowValueConstructor136.getTree();

					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_comparativePredicateValue_in_predicate895);
					comparativePredicateValue137=comparativePredicateValue();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)comparativePredicateValue137.getTree();

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 5 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:290:4: ^( GREATER rowValueConstructor comparativePredicateValue )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					GREATER138=(CommonTree)match(input,GREATER,FOLLOW_GREATER_in_predicate904); 

					if ( _first_0==null ) _first_0 = GREATER138;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_rowValueConstructor_in_predicate906);
					rowValueConstructor139=rowValueConstructor();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)rowValueConstructor139.getTree();

					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_comparativePredicateValue_in_predicate908);
					comparativePredicateValue140=comparativePredicateValue();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)comparativePredicateValue140.getTree();

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 6 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:291:4: ^( GREATER_EQUAL rowValueConstructor comparativePredicateValue )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					GREATER_EQUAL141=(CommonTree)match(input,GREATER_EQUAL,FOLLOW_GREATER_EQUAL_in_predicate917); 

					if ( _first_0==null ) _first_0 = GREATER_EQUAL141;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_rowValueConstructor_in_predicate919);
					rowValueConstructor142=rowValueConstructor();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)rowValueConstructor142.getTree();

					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_comparativePredicateValue_in_predicate921);
					comparativePredicateValue143=comparativePredicateValue();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)comparativePredicateValue143.getTree();

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 7 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:292:4: ^( IS_NULL rowValueConstructor )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					IS_NULL144=(CommonTree)match(input,IS_NULL,FOLLOW_IS_NULL_in_predicate930); 

					if ( _first_0==null ) _first_0 = IS_NULL144;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_rowValueConstructor_in_predicate932);
					rowValueConstructor145=rowValueConstructor();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)rowValueConstructor145.getTree();

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 8 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:293:4: ^( IS_NOT_NULL rowValueConstructor )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					IS_NOT_NULL146=(CommonTree)match(input,IS_NOT_NULL,FOLLOW_IS_NOT_NULL_in_predicate941); 

					if ( _first_0==null ) _first_0 = IS_NOT_NULL146;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_rowValueConstructor_in_predicate943);
					rowValueConstructor147=rowValueConstructor();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)rowValueConstructor147.getTree();

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 9 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:294:4: ^( LIKE valueExpression valueExpression ( escapeSpecification )? )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					LIKE148=(CommonTree)match(input,LIKE,FOLLOW_LIKE_in_predicate952); 

					if ( _first_0==null ) _first_0 = LIKE148;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_valueExpression_in_predicate954);
					valueExpression149=valueExpression();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)valueExpression149.getTree();

					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_valueExpression_in_predicate956);
					valueExpression150=valueExpression();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)valueExpression150.getTree();

					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:294:44: ( escapeSpecification )?
					int alt46=2;
					switch ( input.LA(1) ) {
						case ESCAPE:
							{
							alt46=1;
							}
							break;
					}
					switch (alt46) {
						case 1 :
							// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:294:44: escapeSpecification
							{
							_last = (CommonTree)input.LT(1);
							pushFollow(FOLLOW_escapeSpecification_in_predicate958);
							escapeSpecification151=escapeSpecification();
							state._fsp--;

							 
							if ( _first_1==null ) _first_1 = (CommonTree)escapeSpecification151.getTree();

							retval.tree = (CommonTree)_first_0;
							if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
								retval.tree = (CommonTree)adaptor.getParent(retval.tree);

							}
							break;

					}

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 10 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:295:4: ^( NOT_LIKE valueExpression valueExpression ( escapeSpecification )? )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					NOT_LIKE152=(CommonTree)match(input,NOT_LIKE,FOLLOW_NOT_LIKE_in_predicate968); 

					if ( _first_0==null ) _first_0 = NOT_LIKE152;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_valueExpression_in_predicate970);
					valueExpression153=valueExpression();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)valueExpression153.getTree();

					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_valueExpression_in_predicate972);
					valueExpression154=valueExpression();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)valueExpression154.getTree();

					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:295:48: ( escapeSpecification )?
					int alt47=2;
					switch ( input.LA(1) ) {
						case ESCAPE:
							{
							alt47=1;
							}
							break;
					}
					switch (alt47) {
						case 1 :
							// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:295:48: escapeSpecification
							{
							_last = (CommonTree)input.LT(1);
							pushFollow(FOLLOW_escapeSpecification_in_predicate974);
							escapeSpecification155=escapeSpecification();
							state._fsp--;

							 
							if ( _first_1==null ) _first_1 = (CommonTree)escapeSpecification155.getTree();

							retval.tree = (CommonTree)_first_0;
							if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
								retval.tree = (CommonTree)adaptor.getParent(retval.tree);

							}
							break;

					}

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 11 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:296:4: ^( BETWEEN rowValueConstructor betweenList )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					BETWEEN156=(CommonTree)match(input,BETWEEN,FOLLOW_BETWEEN_in_predicate984); 

					if ( _first_0==null ) _first_0 = BETWEEN156;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_rowValueConstructor_in_predicate986);
					rowValueConstructor157=rowValueConstructor();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)rowValueConstructor157.getTree();

					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_betweenList_in_predicate988);
					betweenList158=betweenList();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)betweenList158.getTree();

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 12 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:297:4: ^( NOT_BETWEEN rowValueConstructor betweenList )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					NOT_BETWEEN159=(CommonTree)match(input,NOT_BETWEEN,FOLLOW_NOT_BETWEEN_in_predicate997); 

					if ( _first_0==null ) _first_0 = NOT_BETWEEN159;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_rowValueConstructor_in_predicate999);
					rowValueConstructor160=rowValueConstructor();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)rowValueConstructor160.getTree();

					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_betweenList_in_predicate1001);
					betweenList161=betweenList();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)betweenList161.getTree();

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 13 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:298:4: ^( IN rowValueConstructor inPredicateValue )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					IN162=(CommonTree)match(input,IN,FOLLOW_IN_in_predicate1010); 

					if ( _first_0==null ) _first_0 = IN162;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_rowValueConstructor_in_predicate1012);
					rowValueConstructor163=rowValueConstructor();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)rowValueConstructor163.getTree();

					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_inPredicateValue_in_predicate1014);
					inPredicateValue164=inPredicateValue();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)inPredicateValue164.getTree();

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 14 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:299:4: ^( NOT_IN rowValueConstructor inPredicateValue )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					NOT_IN165=(CommonTree)match(input,NOT_IN,FOLLOW_NOT_IN_in_predicate1023); 

					if ( _first_0==null ) _first_0 = NOT_IN165;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_rowValueConstructor_in_predicate1025);
					rowValueConstructor166=rowValueConstructor();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)rowValueConstructor166.getTree();

					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_inPredicateValue_in_predicate1027);
					inPredicateValue167=inPredicateValue();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)inPredicateValue167.getTree();

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 15 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:300:4: ^( MEMBER_OF rowValueConstructor rowValueConstructor )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					MEMBER_OF168=(CommonTree)match(input,MEMBER_OF,FOLLOW_MEMBER_OF_in_predicate1036); 

					if ( _first_0==null ) _first_0 = MEMBER_OF168;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_rowValueConstructor_in_predicate1038);
					rowValueConstructor169=rowValueConstructor();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)rowValueConstructor169.getTree();

					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_rowValueConstructor_in_predicate1040);
					rowValueConstructor170=rowValueConstructor();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)rowValueConstructor170.getTree();

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 16 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:301:4: ^( NOT_MEMBER_OF rowValueConstructor rowValueConstructor )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					NOT_MEMBER_OF171=(CommonTree)match(input,NOT_MEMBER_OF,FOLLOW_NOT_MEMBER_OF_in_predicate1049); 

					if ( _first_0==null ) _first_0 = NOT_MEMBER_OF171;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_rowValueConstructor_in_predicate1051);
					rowValueConstructor172=rowValueConstructor();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)rowValueConstructor172.getTree();

					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_rowValueConstructor_in_predicate1053);
					rowValueConstructor173=rowValueConstructor();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)rowValueConstructor173.getTree();

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 17 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:302:4: ^( IS_EMPTY rowValueConstructor )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					IS_EMPTY174=(CommonTree)match(input,IS_EMPTY,FOLLOW_IS_EMPTY_in_predicate1063); 

					if ( _first_0==null ) _first_0 = IS_EMPTY174;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_rowValueConstructor_in_predicate1065);
					rowValueConstructor175=rowValueConstructor();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)rowValueConstructor175.getTree();

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 18 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:303:4: ^( IS_NOT_EMPTY rowValueConstructor )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					IS_NOT_EMPTY176=(CommonTree)match(input,IS_NOT_EMPTY,FOLLOW_IS_NOT_EMPTY_in_predicate1074); 

					if ( _first_0==null ) _first_0 = IS_NOT_EMPTY176;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_rowValueConstructor_in_predicate1076);
					rowValueConstructor177=rowValueConstructor();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)rowValueConstructor177.getTree();

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 19 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:304:4: rowValueConstructor
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_rowValueConstructor_in_predicate1083);
					rowValueConstructor178=rowValueConstructor();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)rowValueConstructor178.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "predicate"


	public static class betweenList_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "betweenList"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:307:1: betweenList : ^( BETWEEN_LIST rowValueConstructor rowValueConstructor ) ;
	public final GeneratedHQLResolver.betweenList_return betweenList() throws RecognitionException {
		GeneratedHQLResolver.betweenList_return retval = new GeneratedHQLResolver.betweenList_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree BETWEEN_LIST179=null;
		TreeRuleReturnScope rowValueConstructor180 =null;
		TreeRuleReturnScope rowValueConstructor181 =null;

		CommonTree BETWEEN_LIST179_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:308:2: ( ^( BETWEEN_LIST rowValueConstructor rowValueConstructor ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:308:4: ^( BETWEEN_LIST rowValueConstructor rowValueConstructor )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			BETWEEN_LIST179=(CommonTree)match(input,BETWEEN_LIST,FOLLOW_BETWEEN_LIST_in_betweenList1096); 

			if ( _first_0==null ) _first_0 = BETWEEN_LIST179;
			match(input, Token.DOWN, null); 
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_rowValueConstructor_in_betweenList1098);
			rowValueConstructor180=rowValueConstructor();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)rowValueConstructor180.getTree();

			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_rowValueConstructor_in_betweenList1100);
			rowValueConstructor181=rowValueConstructor();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)rowValueConstructor181.getTree();

			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "betweenList"


	public static class comparativePredicateValue_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "comparativePredicateValue"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:311:1: comparativePredicateValue : rowValueConstructor ;
	public final GeneratedHQLResolver.comparativePredicateValue_return comparativePredicateValue() throws RecognitionException {
		GeneratedHQLResolver.comparativePredicateValue_return retval = new GeneratedHQLResolver.comparativePredicateValue_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		TreeRuleReturnScope rowValueConstructor182 =null;


		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:312:2: ( rowValueConstructor )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:312:4: rowValueConstructor
			{
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_rowValueConstructor_in_comparativePredicateValue1114);
			rowValueConstructor182=rowValueConstructor();
			state._fsp--;

			 
			if ( _first_0==null ) _first_0 = (CommonTree)rowValueConstructor182.getTree();

			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "comparativePredicateValue"


	public static class rowValueConstructor_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "rowValueConstructor"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:315:1: rowValueConstructor : valueExpression ;
	public final GeneratedHQLResolver.rowValueConstructor_return rowValueConstructor() throws RecognitionException {
		GeneratedHQLResolver.rowValueConstructor_return retval = new GeneratedHQLResolver.rowValueConstructor_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		TreeRuleReturnScope valueExpression183 =null;


		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:316:2: ( valueExpression )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:316:4: valueExpression
			{
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_valueExpression_in_rowValueConstructor1125);
			valueExpression183=valueExpression();
			state._fsp--;

			 
			if ( _first_0==null ) _first_0 = (CommonTree)valueExpression183.getTree();

			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "rowValueConstructor"


	public static class escapeSpecification_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "escapeSpecification"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:319:1: escapeSpecification : ^( ESCAPE characterValueExpression ) ;
	public final GeneratedHQLResolver.escapeSpecification_return escapeSpecification() throws RecognitionException {
		GeneratedHQLResolver.escapeSpecification_return retval = new GeneratedHQLResolver.escapeSpecification_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree ESCAPE184=null;
		TreeRuleReturnScope characterValueExpression185 =null;

		CommonTree ESCAPE184_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:320:2: ( ^( ESCAPE characterValueExpression ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:320:4: ^( ESCAPE characterValueExpression )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			ESCAPE184=(CommonTree)match(input,ESCAPE,FOLLOW_ESCAPE_in_escapeSpecification1137); 

			if ( _first_0==null ) _first_0 = ESCAPE184;
			match(input, Token.DOWN, null); 
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_characterValueExpression_in_escapeSpecification1139);
			characterValueExpression185=characterValueExpression();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)characterValueExpression185.getTree();

			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "escapeSpecification"


	public static class inPredicateValue_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "inPredicateValue"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:323:1: inPredicateValue : ^( IN_LIST ( valueExpression )+ ) ;
	public final GeneratedHQLResolver.inPredicateValue_return inPredicateValue() throws RecognitionException {
		GeneratedHQLResolver.inPredicateValue_return retval = new GeneratedHQLResolver.inPredicateValue_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree IN_LIST186=null;
		TreeRuleReturnScope valueExpression187 =null;

		CommonTree IN_LIST186_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:324:2: ( ^( IN_LIST ( valueExpression )+ ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:324:4: ^( IN_LIST ( valueExpression )+ )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			IN_LIST186=(CommonTree)match(input,IN_LIST,FOLLOW_IN_LIST_in_inPredicateValue1152); 

			if ( _first_0==null ) _first_0 = IN_LIST186;
			match(input, Token.DOWN, null); 
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:324:14: ( valueExpression )+
			int cnt49=0;
			loop49:
			do {
				int alt49=2;
				switch ( input.LA(1) ) {
				case ABS:
				case ALIAS_REF:
				case ALL:
				case ANY:
				case ASTERISK:
				case AVG:
				case BIT_LENGTH:
				case CAST:
				case CHARACTER_LENGTH:
				case CHARACTER_LITERAL:
				case COALESCE:
				case CONCAT:
				case CONST_STRING_VALUE:
				case COUNT:
				case CURRENT_DATE:
				case CURRENT_TIME:
				case CURRENT_TIMESTAMP:
				case DECIMAL_LITERAL:
				case DOT_CLASS:
				case DOUBLE_PIPE:
				case ELEMENTS:
				case EXISTS:
				case EXTRACT:
				case FALSE:
				case FLOATING_POINT_LITERAL:
				case FUNCTION:
				case HEX_LITERAL:
				case INDEX:
				case INDICES:
				case INTEGER_LITERAL:
				case JAVA_CONSTANT:
				case JPA_PARAM:
				case LENGTH:
				case LOCATE:
				case LOWER:
				case MAX:
				case MAXELEMENT:
				case MAXINDEX:
				case MIN:
				case MINELEMENT:
				case MININDEX:
				case MINUS:
				case MOD:
				case NAMED_PARAM:
				case NULL:
				case NULLIF:
				case OCTAL_LITERAL:
				case OCTET_LENGTH:
				case PARAM:
				case PATH:
				case PLUS:
				case POSITION:
				case PROPERTY_REFERENCE:
				case SEARCHED_CASE:
				case SIMPLE_CASE:
				case SIZE:
				case SOLIDUS:
				case SOME:
				case SQRT:
				case STRING_LITERAL:
				case SUBSTRING:
				case SUB_QUERY:
				case SUM:
				case TRIM:
				case TRUE:
				case UNARY_MINUS:
				case UNARY_PLUS:
				case UPPER:
				case VECTOR_EXPR:
					{
					alt49=1;
					}
					break;
				}
				switch (alt49) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:324:14: valueExpression
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_valueExpression_in_inPredicateValue1154);
					valueExpression187=valueExpression();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)valueExpression187.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

				default :
					if ( cnt49 >= 1 ) break loop49;
						EarlyExitException eee =
							new EarlyExitException(49, input);
						throw eee;
				}
				cnt49++;
			} while (true);

			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "inPredicateValue"


	public static class numericValueExpression_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "numericValueExpression"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:327:1: numericValueExpression : valueExpression ;
	public final GeneratedHQLResolver.numericValueExpression_return numericValueExpression() throws RecognitionException {
		GeneratedHQLResolver.numericValueExpression_return retval = new GeneratedHQLResolver.numericValueExpression_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		TreeRuleReturnScope valueExpression188 =null;


		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:328:2: ( valueExpression )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:328:4: valueExpression
			{
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_valueExpression_in_numericValueExpression1167);
			valueExpression188=valueExpression();
			state._fsp--;

			 
			if ( _first_0==null ) _first_0 = (CommonTree)valueExpression188.getTree();

			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "numericValueExpression"


	public static class characterValueExpression_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "characterValueExpression"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:331:1: characterValueExpression : valueExpression ;
	public final GeneratedHQLResolver.characterValueExpression_return characterValueExpression() throws RecognitionException {
		GeneratedHQLResolver.characterValueExpression_return retval = new GeneratedHQLResolver.characterValueExpression_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		TreeRuleReturnScope valueExpression189 =null;


		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:332:2: ( valueExpression )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:332:4: valueExpression
			{
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_valueExpression_in_characterValueExpression1178);
			valueExpression189=valueExpression();
			state._fsp--;

			 
			if ( _first_0==null ) _first_0 = (CommonTree)valueExpression189.getTree();

			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "characterValueExpression"


	public static class datetimeValueExpression_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "datetimeValueExpression"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:335:1: datetimeValueExpression : valueExpression ;
	public final GeneratedHQLResolver.datetimeValueExpression_return datetimeValueExpression() throws RecognitionException {
		GeneratedHQLResolver.datetimeValueExpression_return retval = new GeneratedHQLResolver.datetimeValueExpression_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		TreeRuleReturnScope valueExpression190 =null;


		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:336:2: ( valueExpression )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:336:4: valueExpression
			{
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_valueExpression_in_datetimeValueExpression1189);
			valueExpression190=valueExpression();
			state._fsp--;

			 
			if ( _first_0==null ) _first_0 = (CommonTree)valueExpression190.getTree();

			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "datetimeValueExpression"


	public static class valueExpression_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "valueExpression"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:339:1: valueExpression : ( ^( DOUBLE_PIPE ( characterValueExpression )+ ) | ^( UNARY_MINUS numericValueExpression ) | ^( UNARY_PLUS numericValueExpression ) | ^( PLUS valueExpression valueExpression ) | ^( MINUS valueExpression valueExpression ) | ^( ASTERISK numericValueExpression numericValueExpression ) | ^( SOLIDUS numericValueExpression numericValueExpression ) | ^( EXISTS rowValueConstructor ) | ^( SOME valueExpression ) | ^( ALL valueExpression ) | ^( ANY valueExpression ) | ^( VECTOR_EXPR ( valueExpression )+ ) | valueExpressionPrimary );
	public final GeneratedHQLResolver.valueExpression_return valueExpression() throws RecognitionException {
		GeneratedHQLResolver.valueExpression_return retval = new GeneratedHQLResolver.valueExpression_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree DOUBLE_PIPE191=null;
		CommonTree UNARY_MINUS193=null;
		CommonTree UNARY_PLUS195=null;
		CommonTree PLUS197=null;
		CommonTree MINUS200=null;
		CommonTree ASTERISK203=null;
		CommonTree SOLIDUS206=null;
		CommonTree EXISTS209=null;
		CommonTree SOME211=null;
		CommonTree ALL213=null;
		CommonTree ANY215=null;
		CommonTree VECTOR_EXPR217=null;
		TreeRuleReturnScope characterValueExpression192 =null;
		TreeRuleReturnScope numericValueExpression194 =null;
		TreeRuleReturnScope numericValueExpression196 =null;
		TreeRuleReturnScope valueExpression198 =null;
		TreeRuleReturnScope valueExpression199 =null;
		TreeRuleReturnScope valueExpression201 =null;
		TreeRuleReturnScope valueExpression202 =null;
		TreeRuleReturnScope numericValueExpression204 =null;
		TreeRuleReturnScope numericValueExpression205 =null;
		TreeRuleReturnScope numericValueExpression207 =null;
		TreeRuleReturnScope numericValueExpression208 =null;
		TreeRuleReturnScope rowValueConstructor210 =null;
		TreeRuleReturnScope valueExpression212 =null;
		TreeRuleReturnScope valueExpression214 =null;
		TreeRuleReturnScope valueExpression216 =null;
		TreeRuleReturnScope valueExpression218 =null;
		TreeRuleReturnScope valueExpressionPrimary219 =null;

		CommonTree DOUBLE_PIPE191_tree=null;
		CommonTree UNARY_MINUS193_tree=null;
		CommonTree UNARY_PLUS195_tree=null;
		CommonTree PLUS197_tree=null;
		CommonTree MINUS200_tree=null;
		CommonTree ASTERISK203_tree=null;
		CommonTree SOLIDUS206_tree=null;
		CommonTree EXISTS209_tree=null;
		CommonTree SOME211_tree=null;
		CommonTree ALL213_tree=null;
		CommonTree ANY215_tree=null;
		CommonTree VECTOR_EXPR217_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:340:2: ( ^( DOUBLE_PIPE ( characterValueExpression )+ ) | ^( UNARY_MINUS numericValueExpression ) | ^( UNARY_PLUS numericValueExpression ) | ^( PLUS valueExpression valueExpression ) | ^( MINUS valueExpression valueExpression ) | ^( ASTERISK numericValueExpression numericValueExpression ) | ^( SOLIDUS numericValueExpression numericValueExpression ) | ^( EXISTS rowValueConstructor ) | ^( SOME valueExpression ) | ^( ALL valueExpression ) | ^( ANY valueExpression ) | ^( VECTOR_EXPR ( valueExpression )+ ) | valueExpressionPrimary )
			int alt52=13;
			switch ( input.LA(1) ) {
			case DOUBLE_PIPE:
				{
				alt52=1;
				}
				break;
			case UNARY_MINUS:
				{
				alt52=2;
				}
				break;
			case UNARY_PLUS:
				{
				alt52=3;
				}
				break;
			case PLUS:
				{
				alt52=4;
				}
				break;
			case MINUS:
				{
				alt52=5;
				}
				break;
			case ASTERISK:
				{
				alt52=6;
				}
				break;
			case SOLIDUS:
				{
				alt52=7;
				}
				break;
			case EXISTS:
				{
				alt52=8;
				}
				break;
			case SOME:
				{
				alt52=9;
				}
				break;
			case ALL:
				{
				alt52=10;
				}
				break;
			case ANY:
				{
				alt52=11;
				}
				break;
			case VECTOR_EXPR:
				{
				alt52=12;
				}
				break;
			case ABS:
			case ALIAS_REF:
			case AVG:
			case BIT_LENGTH:
			case CAST:
			case CHARACTER_LENGTH:
			case CHARACTER_LITERAL:
			case COALESCE:
			case CONCAT:
			case CONST_STRING_VALUE:
			case COUNT:
			case CURRENT_DATE:
			case CURRENT_TIME:
			case CURRENT_TIMESTAMP:
			case DECIMAL_LITERAL:
			case DOT_CLASS:
			case ELEMENTS:
			case EXTRACT:
			case FALSE:
			case FLOATING_POINT_LITERAL:
			case FUNCTION:
			case HEX_LITERAL:
			case INDEX:
			case INDICES:
			case INTEGER_LITERAL:
			case JAVA_CONSTANT:
			case JPA_PARAM:
			case LENGTH:
			case LOCATE:
			case LOWER:
			case MAX:
			case MAXELEMENT:
			case MAXINDEX:
			case MIN:
			case MINELEMENT:
			case MININDEX:
			case MOD:
			case NAMED_PARAM:
			case NULL:
			case NULLIF:
			case OCTAL_LITERAL:
			case OCTET_LENGTH:
			case PARAM:
			case PATH:
			case POSITION:
			case PROPERTY_REFERENCE:
			case SEARCHED_CASE:
			case SIMPLE_CASE:
			case SIZE:
			case SQRT:
			case STRING_LITERAL:
			case SUBSTRING:
			case SUB_QUERY:
			case SUM:
			case TRIM:
			case TRUE:
			case UPPER:
				{
				alt52=13;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 52, 0, input);
				throw nvae;
			}
			switch (alt52) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:340:4: ^( DOUBLE_PIPE ( characterValueExpression )+ )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					DOUBLE_PIPE191=(CommonTree)match(input,DOUBLE_PIPE,FOLLOW_DOUBLE_PIPE_in_valueExpression1202); 

					if ( _first_0==null ) _first_0 = DOUBLE_PIPE191;
					match(input, Token.DOWN, null); 
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:340:19: ( characterValueExpression )+
					int cnt50=0;
					loop50:
					do {
						int alt50=2;
						switch ( input.LA(1) ) {
						case ABS:
						case ALIAS_REF:
						case ALL:
						case ANY:
						case ASTERISK:
						case AVG:
						case BIT_LENGTH:
						case CAST:
						case CHARACTER_LENGTH:
						case CHARACTER_LITERAL:
						case COALESCE:
						case CONCAT:
						case CONST_STRING_VALUE:
						case COUNT:
						case CURRENT_DATE:
						case CURRENT_TIME:
						case CURRENT_TIMESTAMP:
						case DECIMAL_LITERAL:
						case DOT_CLASS:
						case DOUBLE_PIPE:
						case ELEMENTS:
						case EXISTS:
						case EXTRACT:
						case FALSE:
						case FLOATING_POINT_LITERAL:
						case FUNCTION:
						case HEX_LITERAL:
						case INDEX:
						case INDICES:
						case INTEGER_LITERAL:
						case JAVA_CONSTANT:
						case JPA_PARAM:
						case LENGTH:
						case LOCATE:
						case LOWER:
						case MAX:
						case MAXELEMENT:
						case MAXINDEX:
						case MIN:
						case MINELEMENT:
						case MININDEX:
						case MINUS:
						case MOD:
						case NAMED_PARAM:
						case NULL:
						case NULLIF:
						case OCTAL_LITERAL:
						case OCTET_LENGTH:
						case PARAM:
						case PATH:
						case PLUS:
						case POSITION:
						case PROPERTY_REFERENCE:
						case SEARCHED_CASE:
						case SIMPLE_CASE:
						case SIZE:
						case SOLIDUS:
						case SOME:
						case SQRT:
						case STRING_LITERAL:
						case SUBSTRING:
						case SUB_QUERY:
						case SUM:
						case TRIM:
						case TRUE:
						case UNARY_MINUS:
						case UNARY_PLUS:
						case UPPER:
						case VECTOR_EXPR:
							{
							alt50=1;
							}
							break;
						}
						switch (alt50) {
						case 1 :
							// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:340:19: characterValueExpression
							{
							_last = (CommonTree)input.LT(1);
							pushFollow(FOLLOW_characterValueExpression_in_valueExpression1204);
							characterValueExpression192=characterValueExpression();
							state._fsp--;

							 
							if ( _first_1==null ) _first_1 = (CommonTree)characterValueExpression192.getTree();

							retval.tree = (CommonTree)_first_0;
							if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
								retval.tree = (CommonTree)adaptor.getParent(retval.tree);

							}
							break;

						default :
							if ( cnt50 >= 1 ) break loop50;
								EarlyExitException eee =
									new EarlyExitException(50, input);
								throw eee;
						}
						cnt50++;
					} while (true);

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 2 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:341:4: ^( UNARY_MINUS numericValueExpression )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					UNARY_MINUS193=(CommonTree)match(input,UNARY_MINUS,FOLLOW_UNARY_MINUS_in_valueExpression1214); 

					if ( _first_0==null ) _first_0 = UNARY_MINUS193;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_numericValueExpression_in_valueExpression1216);
					numericValueExpression194=numericValueExpression();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)numericValueExpression194.getTree();

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 3 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:342:4: ^( UNARY_PLUS numericValueExpression )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					UNARY_PLUS195=(CommonTree)match(input,UNARY_PLUS,FOLLOW_UNARY_PLUS_in_valueExpression1225); 

					if ( _first_0==null ) _first_0 = UNARY_PLUS195;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_numericValueExpression_in_valueExpression1227);
					numericValueExpression196=numericValueExpression();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)numericValueExpression196.getTree();

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 4 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:343:4: ^( PLUS valueExpression valueExpression )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					PLUS197=(CommonTree)match(input,PLUS,FOLLOW_PLUS_in_valueExpression1236); 

					if ( _first_0==null ) _first_0 = PLUS197;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_valueExpression_in_valueExpression1238);
					valueExpression198=valueExpression();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)valueExpression198.getTree();

					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_valueExpression_in_valueExpression1240);
					valueExpression199=valueExpression();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)valueExpression199.getTree();

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 5 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:344:4: ^( MINUS valueExpression valueExpression )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					MINUS200=(CommonTree)match(input,MINUS,FOLLOW_MINUS_in_valueExpression1249); 

					if ( _first_0==null ) _first_0 = MINUS200;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_valueExpression_in_valueExpression1251);
					valueExpression201=valueExpression();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)valueExpression201.getTree();

					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_valueExpression_in_valueExpression1253);
					valueExpression202=valueExpression();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)valueExpression202.getTree();

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 6 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:345:4: ^( ASTERISK numericValueExpression numericValueExpression )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					ASTERISK203=(CommonTree)match(input,ASTERISK,FOLLOW_ASTERISK_in_valueExpression1262); 

					if ( _first_0==null ) _first_0 = ASTERISK203;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_numericValueExpression_in_valueExpression1264);
					numericValueExpression204=numericValueExpression();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)numericValueExpression204.getTree();

					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_numericValueExpression_in_valueExpression1266);
					numericValueExpression205=numericValueExpression();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)numericValueExpression205.getTree();

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 7 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:346:4: ^( SOLIDUS numericValueExpression numericValueExpression )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					SOLIDUS206=(CommonTree)match(input,SOLIDUS,FOLLOW_SOLIDUS_in_valueExpression1275); 

					if ( _first_0==null ) _first_0 = SOLIDUS206;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_numericValueExpression_in_valueExpression1277);
					numericValueExpression207=numericValueExpression();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)numericValueExpression207.getTree();

					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_numericValueExpression_in_valueExpression1279);
					numericValueExpression208=numericValueExpression();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)numericValueExpression208.getTree();

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 8 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:347:4: ^( EXISTS rowValueConstructor )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					EXISTS209=(CommonTree)match(input,EXISTS,FOLLOW_EXISTS_in_valueExpression1288); 

					if ( _first_0==null ) _first_0 = EXISTS209;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_rowValueConstructor_in_valueExpression1290);
					rowValueConstructor210=rowValueConstructor();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)rowValueConstructor210.getTree();

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 9 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:348:4: ^( SOME valueExpression )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					SOME211=(CommonTree)match(input,SOME,FOLLOW_SOME_in_valueExpression1298); 

					if ( _first_0==null ) _first_0 = SOME211;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_valueExpression_in_valueExpression1300);
					valueExpression212=valueExpression();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)valueExpression212.getTree();

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 10 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:349:4: ^( ALL valueExpression )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					ALL213=(CommonTree)match(input,ALL,FOLLOW_ALL_in_valueExpression1309); 

					if ( _first_0==null ) _first_0 = ALL213;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_valueExpression_in_valueExpression1311);
					valueExpression214=valueExpression();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)valueExpression214.getTree();

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 11 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:350:4: ^( ANY valueExpression )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					ANY215=(CommonTree)match(input,ANY,FOLLOW_ANY_in_valueExpression1320); 

					if ( _first_0==null ) _first_0 = ANY215;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_valueExpression_in_valueExpression1322);
					valueExpression216=valueExpression();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)valueExpression216.getTree();

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 12 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:351:4: ^( VECTOR_EXPR ( valueExpression )+ )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					VECTOR_EXPR217=(CommonTree)match(input,VECTOR_EXPR,FOLLOW_VECTOR_EXPR_in_valueExpression1331); 

					if ( _first_0==null ) _first_0 = VECTOR_EXPR217;
					match(input, Token.DOWN, null); 
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:351:19: ( valueExpression )+
					int cnt51=0;
					loop51:
					do {
						int alt51=2;
						switch ( input.LA(1) ) {
						case ABS:
						case ALIAS_REF:
						case ALL:
						case ANY:
						case ASTERISK:
						case AVG:
						case BIT_LENGTH:
						case CAST:
						case CHARACTER_LENGTH:
						case CHARACTER_LITERAL:
						case COALESCE:
						case CONCAT:
						case CONST_STRING_VALUE:
						case COUNT:
						case CURRENT_DATE:
						case CURRENT_TIME:
						case CURRENT_TIMESTAMP:
						case DECIMAL_LITERAL:
						case DOT_CLASS:
						case DOUBLE_PIPE:
						case ELEMENTS:
						case EXISTS:
						case EXTRACT:
						case FALSE:
						case FLOATING_POINT_LITERAL:
						case FUNCTION:
						case HEX_LITERAL:
						case INDEX:
						case INDICES:
						case INTEGER_LITERAL:
						case JAVA_CONSTANT:
						case JPA_PARAM:
						case LENGTH:
						case LOCATE:
						case LOWER:
						case MAX:
						case MAXELEMENT:
						case MAXINDEX:
						case MIN:
						case MINELEMENT:
						case MININDEX:
						case MINUS:
						case MOD:
						case NAMED_PARAM:
						case NULL:
						case NULLIF:
						case OCTAL_LITERAL:
						case OCTET_LENGTH:
						case PARAM:
						case PATH:
						case PLUS:
						case POSITION:
						case PROPERTY_REFERENCE:
						case SEARCHED_CASE:
						case SIMPLE_CASE:
						case SIZE:
						case SOLIDUS:
						case SOME:
						case SQRT:
						case STRING_LITERAL:
						case SUBSTRING:
						case SUB_QUERY:
						case SUM:
						case TRIM:
						case TRUE:
						case UNARY_MINUS:
						case UNARY_PLUS:
						case UPPER:
						case VECTOR_EXPR:
							{
							alt51=1;
							}
							break;
						}
						switch (alt51) {
						case 1 :
							// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:351:19: valueExpression
							{
							_last = (CommonTree)input.LT(1);
							pushFollow(FOLLOW_valueExpression_in_valueExpression1333);
							valueExpression218=valueExpression();
							state._fsp--;

							 
							if ( _first_1==null ) _first_1 = (CommonTree)valueExpression218.getTree();

							retval.tree = (CommonTree)_first_0;
							if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
								retval.tree = (CommonTree)adaptor.getParent(retval.tree);

							}
							break;

						default :
							if ( cnt51 >= 1 ) break loop51;
								EarlyExitException eee =
									new EarlyExitException(51, input);
								throw eee;
						}
						cnt51++;
					} while (true);

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 13 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:352:4: valueExpressionPrimary
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_valueExpressionPrimary_in_valueExpression1341);
					valueExpressionPrimary219=valueExpressionPrimary();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)valueExpressionPrimary219.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "valueExpression"


	public static class valueExpressionPrimary_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "valueExpressionPrimary"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:355:1: valueExpressionPrimary : ( caseExpression | function | collectionFunction | collectionExpression | constant | parameter | propertyReference | ^( SUB_QUERY queryStatementSet ) | ALIAS_REF | ^( DOT_CLASS path ) | ^( JAVA_CONSTANT path ) | ^( PATH propertyReferencePath ) );
	public final GeneratedHQLResolver.valueExpressionPrimary_return valueExpressionPrimary() throws RecognitionException {
		GeneratedHQLResolver.valueExpressionPrimary_return retval = new GeneratedHQLResolver.valueExpressionPrimary_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree SUB_QUERY227=null;
		CommonTree ALIAS_REF229=null;
		CommonTree DOT_CLASS230=null;
		CommonTree JAVA_CONSTANT232=null;
		CommonTree PATH234=null;
		TreeRuleReturnScope caseExpression220 =null;
		TreeRuleReturnScope function221 =null;
		TreeRuleReturnScope collectionFunction222 =null;
		TreeRuleReturnScope collectionExpression223 =null;
		TreeRuleReturnScope constant224 =null;
		TreeRuleReturnScope parameter225 =null;
		TreeRuleReturnScope propertyReference226 =null;
		TreeRuleReturnScope queryStatementSet228 =null;
		TreeRuleReturnScope path231 =null;
		TreeRuleReturnScope path233 =null;
		TreeRuleReturnScope propertyReferencePath235 =null;

		CommonTree SUB_QUERY227_tree=null;
		CommonTree ALIAS_REF229_tree=null;
		CommonTree DOT_CLASS230_tree=null;
		CommonTree JAVA_CONSTANT232_tree=null;
		CommonTree PATH234_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:356:2: ( caseExpression | function | collectionFunction | collectionExpression | constant | parameter | propertyReference | ^( SUB_QUERY queryStatementSet ) | ALIAS_REF | ^( DOT_CLASS path ) | ^( JAVA_CONSTANT path ) | ^( PATH propertyReferencePath ) )
			int alt53=12;
			switch ( input.LA(1) ) {
			case COALESCE:
			case NULLIF:
			case SEARCHED_CASE:
			case SIMPLE_CASE:
				{
				alt53=1;
				}
				break;
			case ABS:
			case AVG:
			case BIT_LENGTH:
			case CAST:
			case CHARACTER_LENGTH:
			case CONCAT:
			case COUNT:
			case CURRENT_DATE:
			case CURRENT_TIME:
			case CURRENT_TIMESTAMP:
			case EXTRACT:
			case FUNCTION:
			case INDEX:
			case LENGTH:
			case LOCATE:
			case LOWER:
			case MAX:
			case MIN:
			case MOD:
			case OCTET_LENGTH:
			case POSITION:
			case SIZE:
			case SQRT:
			case SUBSTRING:
			case SUM:
			case TRIM:
			case UPPER:
				{
				alt53=2;
				}
				break;
			case MAXELEMENT:
			case MAXINDEX:
			case MINELEMENT:
			case MININDEX:
				{
				alt53=3;
				}
				break;
			case ELEMENTS:
			case INDICES:
				{
				alt53=4;
				}
				break;
			case CHARACTER_LITERAL:
			case CONST_STRING_VALUE:
			case DECIMAL_LITERAL:
			case FALSE:
			case FLOATING_POINT_LITERAL:
			case HEX_LITERAL:
			case INTEGER_LITERAL:
			case NULL:
			case OCTAL_LITERAL:
			case STRING_LITERAL:
			case TRUE:
				{
				alt53=5;
				}
				break;
			case JPA_PARAM:
			case NAMED_PARAM:
			case PARAM:
				{
				alt53=6;
				}
				break;
			case PROPERTY_REFERENCE:
				{
				alt53=7;
				}
				break;
			case SUB_QUERY:
				{
				alt53=8;
				}
				break;
			case ALIAS_REF:
				{
				alt53=9;
				}
				break;
			case DOT_CLASS:
				{
				alt53=10;
				}
				break;
			case JAVA_CONSTANT:
				{
				alt53=11;
				}
				break;
			case PATH:
				{
				alt53=12;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 53, 0, input);
				throw nvae;
			}
			switch (alt53) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:356:4: caseExpression
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_caseExpression_in_valueExpressionPrimary1352);
					caseExpression220=caseExpression();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)caseExpression220.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 2 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:357:4: function
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_function_in_valueExpressionPrimary1357);
					function221=function();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)function221.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 3 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:358:4: collectionFunction
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_collectionFunction_in_valueExpressionPrimary1362);
					collectionFunction222=collectionFunction();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)collectionFunction222.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 4 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:359:4: collectionExpression
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_collectionExpression_in_valueExpressionPrimary1367);
					collectionExpression223=collectionExpression();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)collectionExpression223.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 5 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:360:4: constant
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_constant_in_valueExpressionPrimary1372);
					constant224=constant();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)constant224.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 6 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:361:4: parameter
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_parameter_in_valueExpressionPrimary1377);
					parameter225=parameter();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)parameter225.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 7 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:362:4: propertyReference
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_propertyReference_in_valueExpressionPrimary1382);
					propertyReference226=propertyReference();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)propertyReference226.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 8 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:363:4: ^( SUB_QUERY queryStatementSet )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					SUB_QUERY227=(CommonTree)match(input,SUB_QUERY,FOLLOW_SUB_QUERY_in_valueExpressionPrimary1388); 

					if ( _first_0==null ) _first_0 = SUB_QUERY227;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_queryStatementSet_in_valueExpressionPrimary1390);
					queryStatementSet228=queryStatementSet();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)queryStatementSet228.getTree();

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 9 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:364:4: ALIAS_REF
					{
					_last = (CommonTree)input.LT(1);
					ALIAS_REF229=(CommonTree)match(input,ALIAS_REF,FOLLOW_ALIAS_REF_in_valueExpressionPrimary1396); 
					 
					if ( _first_0==null ) _first_0 = ALIAS_REF229;

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 10 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:365:4: ^( DOT_CLASS path )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					DOT_CLASS230=(CommonTree)match(input,DOT_CLASS,FOLLOW_DOT_CLASS_in_valueExpressionPrimary1403); 

					if ( _first_0==null ) _first_0 = DOT_CLASS230;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_path_in_valueExpressionPrimary1405);
					path231=path();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)path231.getTree();

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 11 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:366:4: ^( JAVA_CONSTANT path )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					JAVA_CONSTANT232=(CommonTree)match(input,JAVA_CONSTANT,FOLLOW_JAVA_CONSTANT_in_valueExpressionPrimary1413); 

					if ( _first_0==null ) _first_0 = JAVA_CONSTANT232;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_path_in_valueExpressionPrimary1415);
					path233=path();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)path233.getTree();

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 12 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:367:4: ^( PATH propertyReferencePath )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					PATH234=(CommonTree)match(input,PATH,FOLLOW_PATH_in_valueExpressionPrimary1423); 

					if ( _first_0==null ) _first_0 = PATH234;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_propertyReferencePath_in_valueExpressionPrimary1425);
					propertyReferencePath235=propertyReferencePath();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)propertyReferencePath235.getTree();

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "valueExpressionPrimary"


	public static class caseExpression_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "caseExpression"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:370:1: caseExpression : ( ^( NULLIF valueExpression valueExpression ) | ^( COALESCE valueExpression ( valueExpression )* ) | ^( SIMPLE_CASE valueExpression ( simpleCaseWhenClause )+ ( elseClause )? ) | ^( SEARCHED_CASE ( searchedWhenClause )+ ( elseClause )? ) );
	public final GeneratedHQLResolver.caseExpression_return caseExpression() throws RecognitionException {
		GeneratedHQLResolver.caseExpression_return retval = new GeneratedHQLResolver.caseExpression_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree NULLIF236=null;
		CommonTree COALESCE239=null;
		CommonTree SIMPLE_CASE242=null;
		CommonTree SEARCHED_CASE246=null;
		TreeRuleReturnScope valueExpression237 =null;
		TreeRuleReturnScope valueExpression238 =null;
		TreeRuleReturnScope valueExpression240 =null;
		TreeRuleReturnScope valueExpression241 =null;
		TreeRuleReturnScope valueExpression243 =null;
		TreeRuleReturnScope simpleCaseWhenClause244 =null;
		TreeRuleReturnScope elseClause245 =null;
		TreeRuleReturnScope searchedWhenClause247 =null;
		TreeRuleReturnScope elseClause248 =null;

		CommonTree NULLIF236_tree=null;
		CommonTree COALESCE239_tree=null;
		CommonTree SIMPLE_CASE242_tree=null;
		CommonTree SEARCHED_CASE246_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:371:2: ( ^( NULLIF valueExpression valueExpression ) | ^( COALESCE valueExpression ( valueExpression )* ) | ^( SIMPLE_CASE valueExpression ( simpleCaseWhenClause )+ ( elseClause )? ) | ^( SEARCHED_CASE ( searchedWhenClause )+ ( elseClause )? ) )
			int alt59=4;
			switch ( input.LA(1) ) {
			case NULLIF:
				{
				alt59=1;
				}
				break;
			case COALESCE:
				{
				alt59=2;
				}
				break;
			case SIMPLE_CASE:
				{
				alt59=3;
				}
				break;
			case SEARCHED_CASE:
				{
				alt59=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 59, 0, input);
				throw nvae;
			}
			switch (alt59) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:371:4: ^( NULLIF valueExpression valueExpression )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					NULLIF236=(CommonTree)match(input,NULLIF,FOLLOW_NULLIF_in_caseExpression1438); 

					if ( _first_0==null ) _first_0 = NULLIF236;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_valueExpression_in_caseExpression1440);
					valueExpression237=valueExpression();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)valueExpression237.getTree();

					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_valueExpression_in_caseExpression1442);
					valueExpression238=valueExpression();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)valueExpression238.getTree();

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 2 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:372:4: ^( COALESCE valueExpression ( valueExpression )* )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					COALESCE239=(CommonTree)match(input,COALESCE,FOLLOW_COALESCE_in_caseExpression1449); 

					if ( _first_0==null ) _first_0 = COALESCE239;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_valueExpression_in_caseExpression1451);
					valueExpression240=valueExpression();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)valueExpression240.getTree();

					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:372:31: ( valueExpression )*
					loop54:
					do {
						int alt54=2;
						switch ( input.LA(1) ) {
						case ABS:
						case ALIAS_REF:
						case ALL:
						case ANY:
						case ASTERISK:
						case AVG:
						case BIT_LENGTH:
						case CAST:
						case CHARACTER_LENGTH:
						case CHARACTER_LITERAL:
						case COALESCE:
						case CONCAT:
						case CONST_STRING_VALUE:
						case COUNT:
						case CURRENT_DATE:
						case CURRENT_TIME:
						case CURRENT_TIMESTAMP:
						case DECIMAL_LITERAL:
						case DOT_CLASS:
						case DOUBLE_PIPE:
						case ELEMENTS:
						case EXISTS:
						case EXTRACT:
						case FALSE:
						case FLOATING_POINT_LITERAL:
						case FUNCTION:
						case HEX_LITERAL:
						case INDEX:
						case INDICES:
						case INTEGER_LITERAL:
						case JAVA_CONSTANT:
						case JPA_PARAM:
						case LENGTH:
						case LOCATE:
						case LOWER:
						case MAX:
						case MAXELEMENT:
						case MAXINDEX:
						case MIN:
						case MINELEMENT:
						case MININDEX:
						case MINUS:
						case MOD:
						case NAMED_PARAM:
						case NULL:
						case NULLIF:
						case OCTAL_LITERAL:
						case OCTET_LENGTH:
						case PARAM:
						case PATH:
						case PLUS:
						case POSITION:
						case PROPERTY_REFERENCE:
						case SEARCHED_CASE:
						case SIMPLE_CASE:
						case SIZE:
						case SOLIDUS:
						case SOME:
						case SQRT:
						case STRING_LITERAL:
						case SUBSTRING:
						case SUB_QUERY:
						case SUM:
						case TRIM:
						case TRUE:
						case UNARY_MINUS:
						case UNARY_PLUS:
						case UPPER:
						case VECTOR_EXPR:
							{
							alt54=1;
							}
							break;
						}
						switch (alt54) {
						case 1 :
							// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:372:31: valueExpression
							{
							_last = (CommonTree)input.LT(1);
							pushFollow(FOLLOW_valueExpression_in_caseExpression1453);
							valueExpression241=valueExpression();
							state._fsp--;

							 
							if ( _first_1==null ) _first_1 = (CommonTree)valueExpression241.getTree();

							retval.tree = (CommonTree)_first_0;
							if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
								retval.tree = (CommonTree)adaptor.getParent(retval.tree);

							}
							break;

						default :
							break loop54;
						}
					} while (true);

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 3 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:373:4: ^( SIMPLE_CASE valueExpression ( simpleCaseWhenClause )+ ( elseClause )? )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					SIMPLE_CASE242=(CommonTree)match(input,SIMPLE_CASE,FOLLOW_SIMPLE_CASE_in_caseExpression1461); 

					if ( _first_0==null ) _first_0 = SIMPLE_CASE242;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_valueExpression_in_caseExpression1463);
					valueExpression243=valueExpression();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)valueExpression243.getTree();

					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:373:34: ( simpleCaseWhenClause )+
					int cnt55=0;
					loop55:
					do {
						int alt55=2;
						switch ( input.LA(1) ) {
						case WHEN:
							{
							alt55=1;
							}
							break;
						}
						switch (alt55) {
						case 1 :
							// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:373:34: simpleCaseWhenClause
							{
							_last = (CommonTree)input.LT(1);
							pushFollow(FOLLOW_simpleCaseWhenClause_in_caseExpression1465);
							simpleCaseWhenClause244=simpleCaseWhenClause();
							state._fsp--;

							 
							if ( _first_1==null ) _first_1 = (CommonTree)simpleCaseWhenClause244.getTree();

							retval.tree = (CommonTree)_first_0;
							if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
								retval.tree = (CommonTree)adaptor.getParent(retval.tree);

							}
							break;

						default :
							if ( cnt55 >= 1 ) break loop55;
								EarlyExitException eee =
									new EarlyExitException(55, input);
								throw eee;
						}
						cnt55++;
					} while (true);

					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:373:56: ( elseClause )?
					int alt56=2;
					switch ( input.LA(1) ) {
						case ELSE:
							{
							alt56=1;
							}
							break;
					}
					switch (alt56) {
						case 1 :
							// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:373:56: elseClause
							{
							_last = (CommonTree)input.LT(1);
							pushFollow(FOLLOW_elseClause_in_caseExpression1468);
							elseClause245=elseClause();
							state._fsp--;

							 
							if ( _first_1==null ) _first_1 = (CommonTree)elseClause245.getTree();

							retval.tree = (CommonTree)_first_0;
							if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
								retval.tree = (CommonTree)adaptor.getParent(retval.tree);

							}
							break;

					}

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 4 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:374:4: ^( SEARCHED_CASE ( searchedWhenClause )+ ( elseClause )? )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					SEARCHED_CASE246=(CommonTree)match(input,SEARCHED_CASE,FOLLOW_SEARCHED_CASE_in_caseExpression1476); 

					if ( _first_0==null ) _first_0 = SEARCHED_CASE246;
					match(input, Token.DOWN, null); 
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:374:20: ( searchedWhenClause )+
					int cnt57=0;
					loop57:
					do {
						int alt57=2;
						switch ( input.LA(1) ) {
						case WHEN:
							{
							alt57=1;
							}
							break;
						}
						switch (alt57) {
						case 1 :
							// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:374:20: searchedWhenClause
							{
							_last = (CommonTree)input.LT(1);
							pushFollow(FOLLOW_searchedWhenClause_in_caseExpression1478);
							searchedWhenClause247=searchedWhenClause();
							state._fsp--;

							 
							if ( _first_1==null ) _first_1 = (CommonTree)searchedWhenClause247.getTree();

							retval.tree = (CommonTree)_first_0;
							if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
								retval.tree = (CommonTree)adaptor.getParent(retval.tree);

							}
							break;

						default :
							if ( cnt57 >= 1 ) break loop57;
								EarlyExitException eee =
									new EarlyExitException(57, input);
								throw eee;
						}
						cnt57++;
					} while (true);

					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:374:40: ( elseClause )?
					int alt58=2;
					switch ( input.LA(1) ) {
						case ELSE:
							{
							alt58=1;
							}
							break;
					}
					switch (alt58) {
						case 1 :
							// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:374:40: elseClause
							{
							_last = (CommonTree)input.LT(1);
							pushFollow(FOLLOW_elseClause_in_caseExpression1481);
							elseClause248=elseClause();
							state._fsp--;

							 
							if ( _first_1==null ) _first_1 = (CommonTree)elseClause248.getTree();

							retval.tree = (CommonTree)_first_0;
							if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
								retval.tree = (CommonTree)adaptor.getParent(retval.tree);

							}
							break;

					}

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "caseExpression"


	public static class simpleCaseWhenClause_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "simpleCaseWhenClause"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:377:1: simpleCaseWhenClause : ^( WHEN valueExpression valueExpression ) ;
	public final GeneratedHQLResolver.simpleCaseWhenClause_return simpleCaseWhenClause() throws RecognitionException {
		GeneratedHQLResolver.simpleCaseWhenClause_return retval = new GeneratedHQLResolver.simpleCaseWhenClause_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree WHEN249=null;
		TreeRuleReturnScope valueExpression250 =null;
		TreeRuleReturnScope valueExpression251 =null;

		CommonTree WHEN249_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:378:2: ( ^( WHEN valueExpression valueExpression ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:378:4: ^( WHEN valueExpression valueExpression )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			WHEN249=(CommonTree)match(input,WHEN,FOLLOW_WHEN_in_simpleCaseWhenClause1495); 

			if ( _first_0==null ) _first_0 = WHEN249;
			match(input, Token.DOWN, null); 
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_valueExpression_in_simpleCaseWhenClause1497);
			valueExpression250=valueExpression();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)valueExpression250.getTree();

			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_valueExpression_in_simpleCaseWhenClause1499);
			valueExpression251=valueExpression();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)valueExpression251.getTree();

			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "simpleCaseWhenClause"


	public static class searchedWhenClause_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "searchedWhenClause"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:381:1: searchedWhenClause : ^( WHEN searchCondition valueExpression ) ;
	public final GeneratedHQLResolver.searchedWhenClause_return searchedWhenClause() throws RecognitionException {
		GeneratedHQLResolver.searchedWhenClause_return retval = new GeneratedHQLResolver.searchedWhenClause_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree WHEN252=null;
		TreeRuleReturnScope searchCondition253 =null;
		TreeRuleReturnScope valueExpression254 =null;

		CommonTree WHEN252_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:382:2: ( ^( WHEN searchCondition valueExpression ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:382:4: ^( WHEN searchCondition valueExpression )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			WHEN252=(CommonTree)match(input,WHEN,FOLLOW_WHEN_in_searchedWhenClause1512); 

			if ( _first_0==null ) _first_0 = WHEN252;
			match(input, Token.DOWN, null); 
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_searchCondition_in_searchedWhenClause1514);
			searchCondition253=searchCondition();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)searchCondition253.getTree();

			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_valueExpression_in_searchedWhenClause1516);
			valueExpression254=valueExpression();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)valueExpression254.getTree();

			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "searchedWhenClause"


	public static class elseClause_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "elseClause"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:385:1: elseClause : ^( ELSE valueExpression ) ;
	public final GeneratedHQLResolver.elseClause_return elseClause() throws RecognitionException {
		GeneratedHQLResolver.elseClause_return retval = new GeneratedHQLResolver.elseClause_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree ELSE255=null;
		TreeRuleReturnScope valueExpression256 =null;

		CommonTree ELSE255_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:386:2: ( ^( ELSE valueExpression ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:386:4: ^( ELSE valueExpression )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			ELSE255=(CommonTree)match(input,ELSE,FOLLOW_ELSE_in_elseClause1529); 

			if ( _first_0==null ) _first_0 = ELSE255;
			match(input, Token.DOWN, null); 
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_valueExpression_in_elseClause1531);
			valueExpression256=valueExpression();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)valueExpression256.getTree();

			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "elseClause"


	public static class function_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "function"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:389:1: function : ( setFunction | standardFunction );
	public final GeneratedHQLResolver.function_return function() throws RecognitionException {
		GeneratedHQLResolver.function_return retval = new GeneratedHQLResolver.function_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		TreeRuleReturnScope setFunction257 =null;
		TreeRuleReturnScope standardFunction258 =null;


		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:390:2: ( setFunction | standardFunction )
			int alt60=2;
			switch ( input.LA(1) ) {
			case AVG:
			case COUNT:
			case MAX:
			case MIN:
			case SUM:
				{
				alt60=1;
				}
				break;
			case ABS:
			case BIT_LENGTH:
			case CAST:
			case CHARACTER_LENGTH:
			case CONCAT:
			case CURRENT_DATE:
			case CURRENT_TIME:
			case CURRENT_TIMESTAMP:
			case EXTRACT:
			case FUNCTION:
			case INDEX:
			case LENGTH:
			case LOCATE:
			case LOWER:
			case MOD:
			case OCTET_LENGTH:
			case POSITION:
			case SIZE:
			case SQRT:
			case SUBSTRING:
			case TRIM:
			case UPPER:
				{
				alt60=2;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 60, 0, input);
				throw nvae;
			}
			switch (alt60) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:390:4: setFunction
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_setFunction_in_function1543);
					setFunction257=setFunction();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)setFunction257.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 2 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:391:4: standardFunction
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_standardFunction_in_function1548);
					standardFunction258=standardFunction();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)standardFunction258.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "function"


	public static class setFunction_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "setFunction"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:394:1: setFunction : ( ^( SUM numericValueExpression ) | ^( AVG numericValueExpression ) | ^( MAX numericValueExpression ) | ^( MIN numericValueExpression ) | ^( COUNT ( ASTERISK | ( DISTINCT | ALL ) countFunctionArguments ) ) );
	public final GeneratedHQLResolver.setFunction_return setFunction() throws RecognitionException {
		GeneratedHQLResolver.setFunction_return retval = new GeneratedHQLResolver.setFunction_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree SUM259=null;
		CommonTree AVG261=null;
		CommonTree MAX263=null;
		CommonTree MIN265=null;
		CommonTree COUNT267=null;
		CommonTree ASTERISK268=null;
		CommonTree set269=null;
		TreeRuleReturnScope numericValueExpression260 =null;
		TreeRuleReturnScope numericValueExpression262 =null;
		TreeRuleReturnScope numericValueExpression264 =null;
		TreeRuleReturnScope numericValueExpression266 =null;
		TreeRuleReturnScope countFunctionArguments270 =null;

		CommonTree SUM259_tree=null;
		CommonTree AVG261_tree=null;
		CommonTree MAX263_tree=null;
		CommonTree MIN265_tree=null;
		CommonTree COUNT267_tree=null;
		CommonTree ASTERISK268_tree=null;
		CommonTree set269_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:395:2: ( ^( SUM numericValueExpression ) | ^( AVG numericValueExpression ) | ^( MAX numericValueExpression ) | ^( MIN numericValueExpression ) | ^( COUNT ( ASTERISK | ( DISTINCT | ALL ) countFunctionArguments ) ) )
			int alt62=5;
			switch ( input.LA(1) ) {
			case SUM:
				{
				alt62=1;
				}
				break;
			case AVG:
				{
				alt62=2;
				}
				break;
			case MAX:
				{
				alt62=3;
				}
				break;
			case MIN:
				{
				alt62=4;
				}
				break;
			case COUNT:
				{
				alt62=5;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 62, 0, input);
				throw nvae;
			}
			switch (alt62) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:395:4: ^( SUM numericValueExpression )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					SUM259=(CommonTree)match(input,SUM,FOLLOW_SUM_in_setFunction1560); 

					if ( _first_0==null ) _first_0 = SUM259;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_numericValueExpression_in_setFunction1562);
					numericValueExpression260=numericValueExpression();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)numericValueExpression260.getTree();

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 2 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:396:4: ^( AVG numericValueExpression )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					AVG261=(CommonTree)match(input,AVG,FOLLOW_AVG_in_setFunction1569); 

					if ( _first_0==null ) _first_0 = AVG261;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_numericValueExpression_in_setFunction1571);
					numericValueExpression262=numericValueExpression();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)numericValueExpression262.getTree();

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 3 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:397:4: ^( MAX numericValueExpression )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					MAX263=(CommonTree)match(input,MAX,FOLLOW_MAX_in_setFunction1578); 

					if ( _first_0==null ) _first_0 = MAX263;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_numericValueExpression_in_setFunction1580);
					numericValueExpression264=numericValueExpression();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)numericValueExpression264.getTree();

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 4 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:398:4: ^( MIN numericValueExpression )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					MIN265=(CommonTree)match(input,MIN,FOLLOW_MIN_in_setFunction1587); 

					if ( _first_0==null ) _first_0 = MIN265;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_numericValueExpression_in_setFunction1589);
					numericValueExpression266=numericValueExpression();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)numericValueExpression266.getTree();

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 5 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:399:4: ^( COUNT ( ASTERISK | ( DISTINCT | ALL ) countFunctionArguments ) )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					COUNT267=(CommonTree)match(input,COUNT,FOLLOW_COUNT_in_setFunction1596); 

					if ( _first_0==null ) _first_0 = COUNT267;
					match(input, Token.DOWN, null); 
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:399:12: ( ASTERISK | ( DISTINCT | ALL ) countFunctionArguments )
					int alt61=2;
					switch ( input.LA(1) ) {
					case ASTERISK:
						{
						alt61=1;
						}
						break;
					case ALL:
					case DISTINCT:
						{
						alt61=2;
						}
						break;
					default:
						NoViableAltException nvae =
							new NoViableAltException("", 61, 0, input);
						throw nvae;
					}
					switch (alt61) {
						case 1 :
							// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:399:13: ASTERISK
							{
							_last = (CommonTree)input.LT(1);
							ASTERISK268=(CommonTree)match(input,ASTERISK,FOLLOW_ASTERISK_in_setFunction1599); 
							 
							if ( _first_1==null ) _first_1 = ASTERISK268;

							retval.tree = (CommonTree)_first_0;
							if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
								retval.tree = (CommonTree)adaptor.getParent(retval.tree);

							}
							break;
						case 2 :
							// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:399:24: ( DISTINCT | ALL ) countFunctionArguments
							{
							_last = (CommonTree)input.LT(1);
							set269=(CommonTree)input.LT(1);
							if ( input.LA(1)==ALL||input.LA(1)==DISTINCT ) {
								input.consume();
								state.errorRecovery=false;
							}
							else {
								MismatchedSetException mse = new MismatchedSetException(null,input);
								throw mse;
							}

							_last = (CommonTree)input.LT(1);
							pushFollow(FOLLOW_countFunctionArguments_in_setFunction1609);
							countFunctionArguments270=countFunctionArguments();
							state._fsp--;

							 
							if ( _first_1==null ) _first_1 = (CommonTree)countFunctionArguments270.getTree();

							retval.tree = (CommonTree)_first_0;
							if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
								retval.tree = (CommonTree)adaptor.getParent(retval.tree);

							}
							break;

					}

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "setFunction"


	public static class standardFunction_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "standardFunction"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:402:1: standardFunction : ( functionFunction | castFunction | concatFunction | substringFunction | trimFunction | upperFunction | lowerFunction | lengthFunction | locateFunction | absFunction | sqrtFunction | modFunction | sizeFunction | indexFunction | currentDateFunction | currentTimeFunction | currentTimestampFunction | extractFunction | positionFunction | charLengthFunction | octetLengthFunction | bitLengthFunction );
	public final GeneratedHQLResolver.standardFunction_return standardFunction() throws RecognitionException {
		GeneratedHQLResolver.standardFunction_return retval = new GeneratedHQLResolver.standardFunction_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		TreeRuleReturnScope functionFunction271 =null;
		TreeRuleReturnScope castFunction272 =null;
		TreeRuleReturnScope concatFunction273 =null;
		TreeRuleReturnScope substringFunction274 =null;
		TreeRuleReturnScope trimFunction275 =null;
		TreeRuleReturnScope upperFunction276 =null;
		TreeRuleReturnScope lowerFunction277 =null;
		TreeRuleReturnScope lengthFunction278 =null;
		TreeRuleReturnScope locateFunction279 =null;
		TreeRuleReturnScope absFunction280 =null;
		TreeRuleReturnScope sqrtFunction281 =null;
		TreeRuleReturnScope modFunction282 =null;
		TreeRuleReturnScope sizeFunction283 =null;
		TreeRuleReturnScope indexFunction284 =null;
		TreeRuleReturnScope currentDateFunction285 =null;
		TreeRuleReturnScope currentTimeFunction286 =null;
		TreeRuleReturnScope currentTimestampFunction287 =null;
		TreeRuleReturnScope extractFunction288 =null;
		TreeRuleReturnScope positionFunction289 =null;
		TreeRuleReturnScope charLengthFunction290 =null;
		TreeRuleReturnScope octetLengthFunction291 =null;
		TreeRuleReturnScope bitLengthFunction292 =null;


		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:403:2: ( functionFunction | castFunction | concatFunction | substringFunction | trimFunction | upperFunction | lowerFunction | lengthFunction | locateFunction | absFunction | sqrtFunction | modFunction | sizeFunction | indexFunction | currentDateFunction | currentTimeFunction | currentTimestampFunction | extractFunction | positionFunction | charLengthFunction | octetLengthFunction | bitLengthFunction )
			int alt63=22;
			switch ( input.LA(1) ) {
			case FUNCTION:
				{
				alt63=1;
				}
				break;
			case CAST:
				{
				alt63=2;
				}
				break;
			case CONCAT:
				{
				alt63=3;
				}
				break;
			case SUBSTRING:
				{
				alt63=4;
				}
				break;
			case TRIM:
				{
				alt63=5;
				}
				break;
			case UPPER:
				{
				alt63=6;
				}
				break;
			case LOWER:
				{
				alt63=7;
				}
				break;
			case LENGTH:
				{
				alt63=8;
				}
				break;
			case LOCATE:
				{
				alt63=9;
				}
				break;
			case ABS:
				{
				alt63=10;
				}
				break;
			case SQRT:
				{
				alt63=11;
				}
				break;
			case MOD:
				{
				alt63=12;
				}
				break;
			case SIZE:
				{
				alt63=13;
				}
				break;
			case INDEX:
				{
				alt63=14;
				}
				break;
			case CURRENT_DATE:
				{
				alt63=15;
				}
				break;
			case CURRENT_TIME:
				{
				alt63=16;
				}
				break;
			case CURRENT_TIMESTAMP:
				{
				alt63=17;
				}
				break;
			case EXTRACT:
				{
				alt63=18;
				}
				break;
			case POSITION:
				{
				alt63=19;
				}
				break;
			case CHARACTER_LENGTH:
				{
				alt63=20;
				}
				break;
			case OCTET_LENGTH:
				{
				alt63=21;
				}
				break;
			case BIT_LENGTH:
				{
				alt63=22;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 63, 0, input);
				throw nvae;
			}
			switch (alt63) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:403:4: functionFunction
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_functionFunction_in_standardFunction1622);
					functionFunction271=functionFunction();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)functionFunction271.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 2 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:404:4: castFunction
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_castFunction_in_standardFunction1627);
					castFunction272=castFunction();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)castFunction272.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 3 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:405:4: concatFunction
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_concatFunction_in_standardFunction1632);
					concatFunction273=concatFunction();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)concatFunction273.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 4 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:406:4: substringFunction
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_substringFunction_in_standardFunction1637);
					substringFunction274=substringFunction();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)substringFunction274.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 5 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:407:4: trimFunction
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_trimFunction_in_standardFunction1642);
					trimFunction275=trimFunction();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)trimFunction275.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 6 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:408:4: upperFunction
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_upperFunction_in_standardFunction1647);
					upperFunction276=upperFunction();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)upperFunction276.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 7 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:409:4: lowerFunction
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_lowerFunction_in_standardFunction1652);
					lowerFunction277=lowerFunction();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)lowerFunction277.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 8 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:410:4: lengthFunction
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_lengthFunction_in_standardFunction1657);
					lengthFunction278=lengthFunction();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)lengthFunction278.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 9 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:411:4: locateFunction
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_locateFunction_in_standardFunction1662);
					locateFunction279=locateFunction();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)locateFunction279.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 10 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:412:4: absFunction
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_absFunction_in_standardFunction1667);
					absFunction280=absFunction();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)absFunction280.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 11 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:413:4: sqrtFunction
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_sqrtFunction_in_standardFunction1672);
					sqrtFunction281=sqrtFunction();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)sqrtFunction281.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 12 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:414:4: modFunction
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_modFunction_in_standardFunction1677);
					modFunction282=modFunction();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)modFunction282.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 13 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:415:4: sizeFunction
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_sizeFunction_in_standardFunction1682);
					sizeFunction283=sizeFunction();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)sizeFunction283.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 14 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:416:4: indexFunction
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_indexFunction_in_standardFunction1687);
					indexFunction284=indexFunction();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)indexFunction284.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 15 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:417:4: currentDateFunction
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_currentDateFunction_in_standardFunction1692);
					currentDateFunction285=currentDateFunction();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)currentDateFunction285.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 16 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:418:4: currentTimeFunction
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_currentTimeFunction_in_standardFunction1697);
					currentTimeFunction286=currentTimeFunction();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)currentTimeFunction286.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 17 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:419:4: currentTimestampFunction
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_currentTimestampFunction_in_standardFunction1702);
					currentTimestampFunction287=currentTimestampFunction();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)currentTimestampFunction287.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 18 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:420:4: extractFunction
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_extractFunction_in_standardFunction1707);
					extractFunction288=extractFunction();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)extractFunction288.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 19 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:421:4: positionFunction
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_positionFunction_in_standardFunction1712);
					positionFunction289=positionFunction();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)positionFunction289.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 20 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:422:4: charLengthFunction
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_charLengthFunction_in_standardFunction1717);
					charLengthFunction290=charLengthFunction();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)charLengthFunction290.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 21 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:423:4: octetLengthFunction
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_octetLengthFunction_in_standardFunction1722);
					octetLengthFunction291=octetLengthFunction();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)octetLengthFunction291.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 22 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:424:4: bitLengthFunction
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_bitLengthFunction_in_standardFunction1727);
					bitLengthFunction292=bitLengthFunction();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)bitLengthFunction292.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "standardFunction"


	public static class functionFunction_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "functionFunction"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:427:1: functionFunction : ^( FUNCTION ( valueExpression )* ) ;
	public final GeneratedHQLResolver.functionFunction_return functionFunction() throws RecognitionException {
		GeneratedHQLResolver.functionFunction_return retval = new GeneratedHQLResolver.functionFunction_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree FUNCTION293=null;
		TreeRuleReturnScope valueExpression294 =null;

		CommonTree FUNCTION293_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:428:2: ( ^( FUNCTION ( valueExpression )* ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:428:4: ^( FUNCTION ( valueExpression )* )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			FUNCTION293=(CommonTree)match(input,FUNCTION,FOLLOW_FUNCTION_in_functionFunction1740); 

			if ( _first_0==null ) _first_0 = FUNCTION293;
			if ( input.LA(1)==Token.DOWN ) {
				match(input, Token.DOWN, null); 
				// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:428:16: ( valueExpression )*
				loop64:
				do {
					int alt64=2;
					switch ( input.LA(1) ) {
					case ABS:
					case ALIAS_REF:
					case ALL:
					case ANY:
					case ASTERISK:
					case AVG:
					case BIT_LENGTH:
					case CAST:
					case CHARACTER_LENGTH:
					case CHARACTER_LITERAL:
					case COALESCE:
					case CONCAT:
					case CONST_STRING_VALUE:
					case COUNT:
					case CURRENT_DATE:
					case CURRENT_TIME:
					case CURRENT_TIMESTAMP:
					case DECIMAL_LITERAL:
					case DOT_CLASS:
					case DOUBLE_PIPE:
					case ELEMENTS:
					case EXISTS:
					case EXTRACT:
					case FALSE:
					case FLOATING_POINT_LITERAL:
					case FUNCTION:
					case HEX_LITERAL:
					case INDEX:
					case INDICES:
					case INTEGER_LITERAL:
					case JAVA_CONSTANT:
					case JPA_PARAM:
					case LENGTH:
					case LOCATE:
					case LOWER:
					case MAX:
					case MAXELEMENT:
					case MAXINDEX:
					case MIN:
					case MINELEMENT:
					case MININDEX:
					case MINUS:
					case MOD:
					case NAMED_PARAM:
					case NULL:
					case NULLIF:
					case OCTAL_LITERAL:
					case OCTET_LENGTH:
					case PARAM:
					case PATH:
					case PLUS:
					case POSITION:
					case PROPERTY_REFERENCE:
					case SEARCHED_CASE:
					case SIMPLE_CASE:
					case SIZE:
					case SOLIDUS:
					case SOME:
					case SQRT:
					case STRING_LITERAL:
					case SUBSTRING:
					case SUB_QUERY:
					case SUM:
					case TRIM:
					case TRUE:
					case UNARY_MINUS:
					case UNARY_PLUS:
					case UPPER:
					case VECTOR_EXPR:
						{
						alt64=1;
						}
						break;
					}
					switch (alt64) {
					case 1 :
						// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:428:16: valueExpression
						{
						_last = (CommonTree)input.LT(1);
						pushFollow(FOLLOW_valueExpression_in_functionFunction1742);
						valueExpression294=valueExpression();
						state._fsp--;

						 
						if ( _first_1==null ) _first_1 = (CommonTree)valueExpression294.getTree();

						retval.tree = (CommonTree)_first_0;
						if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
							retval.tree = (CommonTree)adaptor.getParent(retval.tree);

						}
						break;

					default :
						break loop64;
					}
				} while (true);

				match(input, Token.UP, null); 
			}
			_last = _save_last_1;
			}


			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "functionFunction"


	public static class castFunction_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "castFunction"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:431:1: castFunction : ^( CAST valueExpression IDENTIFIER ) ;
	public final GeneratedHQLResolver.castFunction_return castFunction() throws RecognitionException {
		GeneratedHQLResolver.castFunction_return retval = new GeneratedHQLResolver.castFunction_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree CAST295=null;
		CommonTree IDENTIFIER297=null;
		TreeRuleReturnScope valueExpression296 =null;

		CommonTree CAST295_tree=null;
		CommonTree IDENTIFIER297_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:432:2: ( ^( CAST valueExpression IDENTIFIER ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:432:4: ^( CAST valueExpression IDENTIFIER )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			CAST295=(CommonTree)match(input,CAST,FOLLOW_CAST_in_castFunction1757); 

			if ( _first_0==null ) _first_0 = CAST295;
			match(input, Token.DOWN, null); 
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_valueExpression_in_castFunction1759);
			valueExpression296=valueExpression();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)valueExpression296.getTree();

			_last = (CommonTree)input.LT(1);
			IDENTIFIER297=(CommonTree)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_castFunction1761); 
			 
			if ( _first_1==null ) _first_1 = IDENTIFIER297;

			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "castFunction"


	public static class concatFunction_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "concatFunction"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:436:1: concatFunction : ^( CONCAT ( valueExpression )+ ) ;
	public final GeneratedHQLResolver.concatFunction_return concatFunction() throws RecognitionException {
		GeneratedHQLResolver.concatFunction_return retval = new GeneratedHQLResolver.concatFunction_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree CONCAT298=null;
		TreeRuleReturnScope valueExpression299 =null;

		CommonTree CONCAT298_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:437:2: ( ^( CONCAT ( valueExpression )+ ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:437:4: ^( CONCAT ( valueExpression )+ )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			CONCAT298=(CommonTree)match(input,CONCAT,FOLLOW_CONCAT_in_concatFunction1776); 

			if ( _first_0==null ) _first_0 = CONCAT298;
			match(input, Token.DOWN, null); 
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:437:13: ( valueExpression )+
			int cnt65=0;
			loop65:
			do {
				int alt65=2;
				switch ( input.LA(1) ) {
				case ABS:
				case ALIAS_REF:
				case ALL:
				case ANY:
				case ASTERISK:
				case AVG:
				case BIT_LENGTH:
				case CAST:
				case CHARACTER_LENGTH:
				case CHARACTER_LITERAL:
				case COALESCE:
				case CONCAT:
				case CONST_STRING_VALUE:
				case COUNT:
				case CURRENT_DATE:
				case CURRENT_TIME:
				case CURRENT_TIMESTAMP:
				case DECIMAL_LITERAL:
				case DOT_CLASS:
				case DOUBLE_PIPE:
				case ELEMENTS:
				case EXISTS:
				case EXTRACT:
				case FALSE:
				case FLOATING_POINT_LITERAL:
				case FUNCTION:
				case HEX_LITERAL:
				case INDEX:
				case INDICES:
				case INTEGER_LITERAL:
				case JAVA_CONSTANT:
				case JPA_PARAM:
				case LENGTH:
				case LOCATE:
				case LOWER:
				case MAX:
				case MAXELEMENT:
				case MAXINDEX:
				case MIN:
				case MINELEMENT:
				case MININDEX:
				case MINUS:
				case MOD:
				case NAMED_PARAM:
				case NULL:
				case NULLIF:
				case OCTAL_LITERAL:
				case OCTET_LENGTH:
				case PARAM:
				case PATH:
				case PLUS:
				case POSITION:
				case PROPERTY_REFERENCE:
				case SEARCHED_CASE:
				case SIMPLE_CASE:
				case SIZE:
				case SOLIDUS:
				case SOME:
				case SQRT:
				case STRING_LITERAL:
				case SUBSTRING:
				case SUB_QUERY:
				case SUM:
				case TRIM:
				case TRUE:
				case UNARY_MINUS:
				case UNARY_PLUS:
				case UPPER:
				case VECTOR_EXPR:
					{
					alt65=1;
					}
					break;
				}
				switch (alt65) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:437:13: valueExpression
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_valueExpression_in_concatFunction1778);
					valueExpression299=valueExpression();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)valueExpression299.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

				default :
					if ( cnt65 >= 1 ) break loop65;
						EarlyExitException eee =
							new EarlyExitException(65, input);
						throw eee;
				}
				cnt65++;
			} while (true);

			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "concatFunction"


	public static class substringFunction_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "substringFunction"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:440:1: substringFunction : ^( SUBSTRING characterValueExpression numericValueExpression ( numericValueExpression )? ) ;
	public final GeneratedHQLResolver.substringFunction_return substringFunction() throws RecognitionException {
		GeneratedHQLResolver.substringFunction_return retval = new GeneratedHQLResolver.substringFunction_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree SUBSTRING300=null;
		TreeRuleReturnScope characterValueExpression301 =null;
		TreeRuleReturnScope numericValueExpression302 =null;
		TreeRuleReturnScope numericValueExpression303 =null;

		CommonTree SUBSTRING300_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:441:2: ( ^( SUBSTRING characterValueExpression numericValueExpression ( numericValueExpression )? ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:441:4: ^( SUBSTRING characterValueExpression numericValueExpression ( numericValueExpression )? )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			SUBSTRING300=(CommonTree)match(input,SUBSTRING,FOLLOW_SUBSTRING_in_substringFunction1792); 

			if ( _first_0==null ) _first_0 = SUBSTRING300;
			match(input, Token.DOWN, null); 
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_characterValueExpression_in_substringFunction1794);
			characterValueExpression301=characterValueExpression();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)characterValueExpression301.getTree();

			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_numericValueExpression_in_substringFunction1796);
			numericValueExpression302=numericValueExpression();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)numericValueExpression302.getTree();

			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:441:64: ( numericValueExpression )?
			int alt66=2;
			switch ( input.LA(1) ) {
				case ABS:
				case ALIAS_REF:
				case ALL:
				case ANY:
				case ASTERISK:
				case AVG:
				case BIT_LENGTH:
				case CAST:
				case CHARACTER_LENGTH:
				case CHARACTER_LITERAL:
				case COALESCE:
				case CONCAT:
				case CONST_STRING_VALUE:
				case COUNT:
				case CURRENT_DATE:
				case CURRENT_TIME:
				case CURRENT_TIMESTAMP:
				case DECIMAL_LITERAL:
				case DOT_CLASS:
				case DOUBLE_PIPE:
				case ELEMENTS:
				case EXISTS:
				case EXTRACT:
				case FALSE:
				case FLOATING_POINT_LITERAL:
				case FUNCTION:
				case HEX_LITERAL:
				case INDEX:
				case INDICES:
				case INTEGER_LITERAL:
				case JAVA_CONSTANT:
				case JPA_PARAM:
				case LENGTH:
				case LOCATE:
				case LOWER:
				case MAX:
				case MAXELEMENT:
				case MAXINDEX:
				case MIN:
				case MINELEMENT:
				case MININDEX:
				case MINUS:
				case MOD:
				case NAMED_PARAM:
				case NULL:
				case NULLIF:
				case OCTAL_LITERAL:
				case OCTET_LENGTH:
				case PARAM:
				case PATH:
				case PLUS:
				case POSITION:
				case PROPERTY_REFERENCE:
				case SEARCHED_CASE:
				case SIMPLE_CASE:
				case SIZE:
				case SOLIDUS:
				case SOME:
				case SQRT:
				case STRING_LITERAL:
				case SUBSTRING:
				case SUB_QUERY:
				case SUM:
				case TRIM:
				case TRUE:
				case UNARY_MINUS:
				case UNARY_PLUS:
				case UPPER:
				case VECTOR_EXPR:
					{
					alt66=1;
					}
					break;
			}
			switch (alt66) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:441:64: numericValueExpression
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_numericValueExpression_in_substringFunction1798);
					numericValueExpression303=numericValueExpression();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)numericValueExpression303.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

			}

			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "substringFunction"


	public static class trimFunction_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "trimFunction"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:444:1: trimFunction : ^( TRIM trimOperands ) ;
	public final GeneratedHQLResolver.trimFunction_return trimFunction() throws RecognitionException {
		GeneratedHQLResolver.trimFunction_return retval = new GeneratedHQLResolver.trimFunction_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree TRIM304=null;
		TreeRuleReturnScope trimOperands305 =null;

		CommonTree TRIM304_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:445:2: ( ^( TRIM trimOperands ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:445:4: ^( TRIM trimOperands )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			TRIM304=(CommonTree)match(input,TRIM,FOLLOW_TRIM_in_trimFunction1812); 

			if ( _first_0==null ) _first_0 = TRIM304;
			match(input, Token.DOWN, null); 
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_trimOperands_in_trimFunction1814);
			trimOperands305=trimOperands();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)trimOperands305.getTree();

			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "trimFunction"


	public static class trimOperands_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "trimOperands"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:448:1: trimOperands : ^( ( LEADING | TRAILING | BOTH ) characterValueExpression characterValueExpression ) ;
	public final GeneratedHQLResolver.trimOperands_return trimOperands() throws RecognitionException {
		GeneratedHQLResolver.trimOperands_return retval = new GeneratedHQLResolver.trimOperands_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree set306=null;
		TreeRuleReturnScope characterValueExpression307 =null;
		TreeRuleReturnScope characterValueExpression308 =null;

		CommonTree set306_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:449:2: ( ^( ( LEADING | TRAILING | BOTH ) characterValueExpression characterValueExpression ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:449:4: ^( ( LEADING | TRAILING | BOTH ) characterValueExpression characterValueExpression )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			set306=(CommonTree)input.LT(1);
			if ( input.LA(1)==BOTH||input.LA(1)==LEADING||input.LA(1)==TRAILING ) {
				input.consume();
				state.errorRecovery=false;
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}

			if ( _first_0==null ) _first_0 = set306;
			match(input, Token.DOWN, null); 
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_characterValueExpression_in_trimOperands1835);
			characterValueExpression307=characterValueExpression();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)characterValueExpression307.getTree();

			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_characterValueExpression_in_trimOperands1837);
			characterValueExpression308=characterValueExpression();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)characterValueExpression308.getTree();

			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "trimOperands"


	public static class upperFunction_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "upperFunction"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:452:1: upperFunction : ^( UPPER characterValueExpression ) ;
	public final GeneratedHQLResolver.upperFunction_return upperFunction() throws RecognitionException {
		GeneratedHQLResolver.upperFunction_return retval = new GeneratedHQLResolver.upperFunction_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree UPPER309=null;
		TreeRuleReturnScope characterValueExpression310 =null;

		CommonTree UPPER309_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:453:2: ( ^( UPPER characterValueExpression ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:453:4: ^( UPPER characterValueExpression )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			UPPER309=(CommonTree)match(input,UPPER,FOLLOW_UPPER_in_upperFunction1850); 

			if ( _first_0==null ) _first_0 = UPPER309;
			match(input, Token.DOWN, null); 
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_characterValueExpression_in_upperFunction1852);
			characterValueExpression310=characterValueExpression();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)characterValueExpression310.getTree();

			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "upperFunction"


	public static class lowerFunction_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "lowerFunction"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:456:1: lowerFunction : ^( LOWER characterValueExpression ) ;
	public final GeneratedHQLResolver.lowerFunction_return lowerFunction() throws RecognitionException {
		GeneratedHQLResolver.lowerFunction_return retval = new GeneratedHQLResolver.lowerFunction_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree LOWER311=null;
		TreeRuleReturnScope characterValueExpression312 =null;

		CommonTree LOWER311_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:457:2: ( ^( LOWER characterValueExpression ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:457:4: ^( LOWER characterValueExpression )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			LOWER311=(CommonTree)match(input,LOWER,FOLLOW_LOWER_in_lowerFunction1865); 

			if ( _first_0==null ) _first_0 = LOWER311;
			match(input, Token.DOWN, null); 
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_characterValueExpression_in_lowerFunction1867);
			characterValueExpression312=characterValueExpression();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)characterValueExpression312.getTree();

			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "lowerFunction"


	public static class lengthFunction_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "lengthFunction"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:460:1: lengthFunction : ^( LENGTH characterValueExpression ) ;
	public final GeneratedHQLResolver.lengthFunction_return lengthFunction() throws RecognitionException {
		GeneratedHQLResolver.lengthFunction_return retval = new GeneratedHQLResolver.lengthFunction_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree LENGTH313=null;
		TreeRuleReturnScope characterValueExpression314 =null;

		CommonTree LENGTH313_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:461:2: ( ^( LENGTH characterValueExpression ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:461:4: ^( LENGTH characterValueExpression )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			LENGTH313=(CommonTree)match(input,LENGTH,FOLLOW_LENGTH_in_lengthFunction1880); 

			if ( _first_0==null ) _first_0 = LENGTH313;
			match(input, Token.DOWN, null); 
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_characterValueExpression_in_lengthFunction1882);
			characterValueExpression314=characterValueExpression();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)characterValueExpression314.getTree();

			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "lengthFunction"


	public static class locateFunction_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "locateFunction"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:464:1: locateFunction : ^( LOCATE characterValueExpression characterValueExpression ( numericValueExpression )? ) ;
	public final GeneratedHQLResolver.locateFunction_return locateFunction() throws RecognitionException {
		GeneratedHQLResolver.locateFunction_return retval = new GeneratedHQLResolver.locateFunction_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree LOCATE315=null;
		TreeRuleReturnScope characterValueExpression316 =null;
		TreeRuleReturnScope characterValueExpression317 =null;
		TreeRuleReturnScope numericValueExpression318 =null;

		CommonTree LOCATE315_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:465:2: ( ^( LOCATE characterValueExpression characterValueExpression ( numericValueExpression )? ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:465:4: ^( LOCATE characterValueExpression characterValueExpression ( numericValueExpression )? )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			LOCATE315=(CommonTree)match(input,LOCATE,FOLLOW_LOCATE_in_locateFunction1895); 

			if ( _first_0==null ) _first_0 = LOCATE315;
			match(input, Token.DOWN, null); 
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_characterValueExpression_in_locateFunction1897);
			characterValueExpression316=characterValueExpression();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)characterValueExpression316.getTree();

			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_characterValueExpression_in_locateFunction1899);
			characterValueExpression317=characterValueExpression();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)characterValueExpression317.getTree();

			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:465:63: ( numericValueExpression )?
			int alt67=2;
			switch ( input.LA(1) ) {
				case ABS:
				case ALIAS_REF:
				case ALL:
				case ANY:
				case ASTERISK:
				case AVG:
				case BIT_LENGTH:
				case CAST:
				case CHARACTER_LENGTH:
				case CHARACTER_LITERAL:
				case COALESCE:
				case CONCAT:
				case CONST_STRING_VALUE:
				case COUNT:
				case CURRENT_DATE:
				case CURRENT_TIME:
				case CURRENT_TIMESTAMP:
				case DECIMAL_LITERAL:
				case DOT_CLASS:
				case DOUBLE_PIPE:
				case ELEMENTS:
				case EXISTS:
				case EXTRACT:
				case FALSE:
				case FLOATING_POINT_LITERAL:
				case FUNCTION:
				case HEX_LITERAL:
				case INDEX:
				case INDICES:
				case INTEGER_LITERAL:
				case JAVA_CONSTANT:
				case JPA_PARAM:
				case LENGTH:
				case LOCATE:
				case LOWER:
				case MAX:
				case MAXELEMENT:
				case MAXINDEX:
				case MIN:
				case MINELEMENT:
				case MININDEX:
				case MINUS:
				case MOD:
				case NAMED_PARAM:
				case NULL:
				case NULLIF:
				case OCTAL_LITERAL:
				case OCTET_LENGTH:
				case PARAM:
				case PATH:
				case PLUS:
				case POSITION:
				case PROPERTY_REFERENCE:
				case SEARCHED_CASE:
				case SIMPLE_CASE:
				case SIZE:
				case SOLIDUS:
				case SOME:
				case SQRT:
				case STRING_LITERAL:
				case SUBSTRING:
				case SUB_QUERY:
				case SUM:
				case TRIM:
				case TRUE:
				case UNARY_MINUS:
				case UNARY_PLUS:
				case UPPER:
				case VECTOR_EXPR:
					{
					alt67=1;
					}
					break;
			}
			switch (alt67) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:465:63: numericValueExpression
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_numericValueExpression_in_locateFunction1901);
					numericValueExpression318=numericValueExpression();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)numericValueExpression318.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

			}

			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "locateFunction"


	public static class absFunction_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "absFunction"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:468:1: absFunction : ^( ABS numericValueExpression ) ;
	public final GeneratedHQLResolver.absFunction_return absFunction() throws RecognitionException {
		GeneratedHQLResolver.absFunction_return retval = new GeneratedHQLResolver.absFunction_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree ABS319=null;
		TreeRuleReturnScope numericValueExpression320 =null;

		CommonTree ABS319_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:469:2: ( ^( ABS numericValueExpression ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:469:4: ^( ABS numericValueExpression )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			ABS319=(CommonTree)match(input,ABS,FOLLOW_ABS_in_absFunction1915); 

			if ( _first_0==null ) _first_0 = ABS319;
			match(input, Token.DOWN, null); 
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_numericValueExpression_in_absFunction1917);
			numericValueExpression320=numericValueExpression();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)numericValueExpression320.getTree();

			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "absFunction"


	public static class sqrtFunction_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "sqrtFunction"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:472:1: sqrtFunction : ^( SQRT numericValueExpression ) ;
	public final GeneratedHQLResolver.sqrtFunction_return sqrtFunction() throws RecognitionException {
		GeneratedHQLResolver.sqrtFunction_return retval = new GeneratedHQLResolver.sqrtFunction_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree SQRT321=null;
		TreeRuleReturnScope numericValueExpression322 =null;

		CommonTree SQRT321_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:473:2: ( ^( SQRT numericValueExpression ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:473:4: ^( SQRT numericValueExpression )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			SQRT321=(CommonTree)match(input,SQRT,FOLLOW_SQRT_in_sqrtFunction1930); 

			if ( _first_0==null ) _first_0 = SQRT321;
			match(input, Token.DOWN, null); 
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_numericValueExpression_in_sqrtFunction1932);
			numericValueExpression322=numericValueExpression();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)numericValueExpression322.getTree();

			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "sqrtFunction"


	public static class modFunction_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "modFunction"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:476:1: modFunction : ^( MOD numericValueExpression numericValueExpression ) ;
	public final GeneratedHQLResolver.modFunction_return modFunction() throws RecognitionException {
		GeneratedHQLResolver.modFunction_return retval = new GeneratedHQLResolver.modFunction_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree MOD323=null;
		TreeRuleReturnScope numericValueExpression324 =null;
		TreeRuleReturnScope numericValueExpression325 =null;

		CommonTree MOD323_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:477:2: ( ^( MOD numericValueExpression numericValueExpression ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:477:4: ^( MOD numericValueExpression numericValueExpression )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			MOD323=(CommonTree)match(input,MOD,FOLLOW_MOD_in_modFunction1945); 

			if ( _first_0==null ) _first_0 = MOD323;
			match(input, Token.DOWN, null); 
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_numericValueExpression_in_modFunction1947);
			numericValueExpression324=numericValueExpression();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)numericValueExpression324.getTree();

			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_numericValueExpression_in_modFunction1949);
			numericValueExpression325=numericValueExpression();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)numericValueExpression325.getTree();

			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "modFunction"


	public static class sizeFunction_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "sizeFunction"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:480:1: sizeFunction : ^( SIZE propertyReference ) ;
	public final GeneratedHQLResolver.sizeFunction_return sizeFunction() throws RecognitionException {
		GeneratedHQLResolver.sizeFunction_return retval = new GeneratedHQLResolver.sizeFunction_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree SIZE326=null;
		TreeRuleReturnScope propertyReference327 =null;

		CommonTree SIZE326_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:481:2: ( ^( SIZE propertyReference ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:481:4: ^( SIZE propertyReference )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			SIZE326=(CommonTree)match(input,SIZE,FOLLOW_SIZE_in_sizeFunction1962); 

			if ( _first_0==null ) _first_0 = SIZE326;
			match(input, Token.DOWN, null); 
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_propertyReference_in_sizeFunction1964);
			propertyReference327=propertyReference();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)propertyReference327.getTree();

			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "sizeFunction"


	public static class indexFunction_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "indexFunction"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:484:1: indexFunction : ^( INDEX ALIAS_REF ) ;
	public final GeneratedHQLResolver.indexFunction_return indexFunction() throws RecognitionException {
		GeneratedHQLResolver.indexFunction_return retval = new GeneratedHQLResolver.indexFunction_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree INDEX328=null;
		CommonTree ALIAS_REF329=null;

		CommonTree INDEX328_tree=null;
		CommonTree ALIAS_REF329_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:485:2: ( ^( INDEX ALIAS_REF ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:485:4: ^( INDEX ALIAS_REF )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			INDEX328=(CommonTree)match(input,INDEX,FOLLOW_INDEX_in_indexFunction1977); 

			if ( _first_0==null ) _first_0 = INDEX328;
			match(input, Token.DOWN, null); 
			_last = (CommonTree)input.LT(1);
			ALIAS_REF329=(CommonTree)match(input,ALIAS_REF,FOLLOW_ALIAS_REF_in_indexFunction1979); 
			 
			if ( _first_1==null ) _first_1 = ALIAS_REF329;

			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "indexFunction"


	public static class currentDateFunction_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "currentDateFunction"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:488:1: currentDateFunction : CURRENT_DATE ;
	public final GeneratedHQLResolver.currentDateFunction_return currentDateFunction() throws RecognitionException {
		GeneratedHQLResolver.currentDateFunction_return retval = new GeneratedHQLResolver.currentDateFunction_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree CURRENT_DATE330=null;

		CommonTree CURRENT_DATE330_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:489:2: ( CURRENT_DATE )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:489:4: CURRENT_DATE
			{
			_last = (CommonTree)input.LT(1);
			CURRENT_DATE330=(CommonTree)match(input,CURRENT_DATE,FOLLOW_CURRENT_DATE_in_currentDateFunction1991); 
			 
			if ( _first_0==null ) _first_0 = CURRENT_DATE330;

			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "currentDateFunction"


	public static class currentTimeFunction_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "currentTimeFunction"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:492:1: currentTimeFunction : CURRENT_TIME ;
	public final GeneratedHQLResolver.currentTimeFunction_return currentTimeFunction() throws RecognitionException {
		GeneratedHQLResolver.currentTimeFunction_return retval = new GeneratedHQLResolver.currentTimeFunction_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree CURRENT_TIME331=null;

		CommonTree CURRENT_TIME331_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:493:2: ( CURRENT_TIME )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:493:4: CURRENT_TIME
			{
			_last = (CommonTree)input.LT(1);
			CURRENT_TIME331=(CommonTree)match(input,CURRENT_TIME,FOLLOW_CURRENT_TIME_in_currentTimeFunction2002); 
			 
			if ( _first_0==null ) _first_0 = CURRENT_TIME331;

			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "currentTimeFunction"


	public static class currentTimestampFunction_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "currentTimestampFunction"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:496:1: currentTimestampFunction : CURRENT_TIMESTAMP ;
	public final GeneratedHQLResolver.currentTimestampFunction_return currentTimestampFunction() throws RecognitionException {
		GeneratedHQLResolver.currentTimestampFunction_return retval = new GeneratedHQLResolver.currentTimestampFunction_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree CURRENT_TIMESTAMP332=null;

		CommonTree CURRENT_TIMESTAMP332_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:497:2: ( CURRENT_TIMESTAMP )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:497:4: CURRENT_TIMESTAMP
			{
			_last = (CommonTree)input.LT(1);
			CURRENT_TIMESTAMP332=(CommonTree)match(input,CURRENT_TIMESTAMP,FOLLOW_CURRENT_TIMESTAMP_in_currentTimestampFunction2013); 
			 
			if ( _first_0==null ) _first_0 = CURRENT_TIMESTAMP332;

			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "currentTimestampFunction"


	public static class extractFunction_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "extractFunction"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:500:1: extractFunction : ^( EXTRACT extractField datetimeValueExpression ) ;
	public final GeneratedHQLResolver.extractFunction_return extractFunction() throws RecognitionException {
		GeneratedHQLResolver.extractFunction_return retval = new GeneratedHQLResolver.extractFunction_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree EXTRACT333=null;
		TreeRuleReturnScope extractField334 =null;
		TreeRuleReturnScope datetimeValueExpression335 =null;

		CommonTree EXTRACT333_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:501:2: ( ^( EXTRACT extractField datetimeValueExpression ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:501:4: ^( EXTRACT extractField datetimeValueExpression )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			EXTRACT333=(CommonTree)match(input,EXTRACT,FOLLOW_EXTRACT_in_extractFunction2025); 

			if ( _first_0==null ) _first_0 = EXTRACT333;
			match(input, Token.DOWN, null); 
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_extractField_in_extractFunction2027);
			extractField334=extractField();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)extractField334.getTree();

			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_datetimeValueExpression_in_extractFunction2029);
			datetimeValueExpression335=datetimeValueExpression();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)datetimeValueExpression335.getTree();

			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "extractFunction"


	public static class extractField_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "extractField"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:504:1: extractField : ( datetimeField | timeZoneField );
	public final GeneratedHQLResolver.extractField_return extractField() throws RecognitionException {
		GeneratedHQLResolver.extractField_return retval = new GeneratedHQLResolver.extractField_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		TreeRuleReturnScope datetimeField336 =null;
		TreeRuleReturnScope timeZoneField337 =null;


		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:505:2: ( datetimeField | timeZoneField )
			int alt68=2;
			switch ( input.LA(1) ) {
			case DAY:
			case HOUR:
			case MINUTE:
			case MONTH:
			case SECOND:
			case YEAR:
				{
				alt68=1;
				}
				break;
			case TIMEZONE_HOUR:
			case TIMEZONE_MINUTE:
				{
				alt68=2;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 68, 0, input);
				throw nvae;
			}
			switch (alt68) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:505:4: datetimeField
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_datetimeField_in_extractField2041);
					datetimeField336=datetimeField();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)datetimeField336.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 2 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:506:4: timeZoneField
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_timeZoneField_in_extractField2046);
					timeZoneField337=timeZoneField();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)timeZoneField337.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "extractField"


	public static class datetimeField_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "datetimeField"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:509:1: datetimeField : ( YEAR | MONTH | DAY | HOUR | MINUTE | SECOND );
	public final GeneratedHQLResolver.datetimeField_return datetimeField() throws RecognitionException {
		GeneratedHQLResolver.datetimeField_return retval = new GeneratedHQLResolver.datetimeField_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree set338=null;

		CommonTree set338_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:510:2: ( YEAR | MONTH | DAY | HOUR | MINUTE | SECOND )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:
			{
			_last = (CommonTree)input.LT(1);
			set338=(CommonTree)input.LT(1);
			if ( input.LA(1)==DAY||input.LA(1)==HOUR||input.LA(1)==MINUTE||input.LA(1)==MONTH||input.LA(1)==SECOND||input.LA(1)==YEAR ) {
				input.consume();
				state.errorRecovery=false;
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}

			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);
			 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "datetimeField"


	public static class timeZoneField_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "timeZoneField"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:518:1: timeZoneField : ( TIMEZONE_HOUR | TIMEZONE_MINUTE );
	public final GeneratedHQLResolver.timeZoneField_return timeZoneField() throws RecognitionException {
		GeneratedHQLResolver.timeZoneField_return retval = new GeneratedHQLResolver.timeZoneField_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree set339=null;

		CommonTree set339_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:519:2: ( TIMEZONE_HOUR | TIMEZONE_MINUTE )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:
			{
			_last = (CommonTree)input.LT(1);
			set339=(CommonTree)input.LT(1);
			if ( (input.LA(1) >= TIMEZONE_HOUR && input.LA(1) <= TIMEZONE_MINUTE) ) {
				input.consume();
				state.errorRecovery=false;
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}

			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);
			 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "timeZoneField"


	public static class positionFunction_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "positionFunction"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:523:1: positionFunction : ^( POSITION characterValueExpression characterValueExpression ) ;
	public final GeneratedHQLResolver.positionFunction_return positionFunction() throws RecognitionException {
		GeneratedHQLResolver.positionFunction_return retval = new GeneratedHQLResolver.positionFunction_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree POSITION340=null;
		TreeRuleReturnScope characterValueExpression341 =null;
		TreeRuleReturnScope characterValueExpression342 =null;

		CommonTree POSITION340_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:524:2: ( ^( POSITION characterValueExpression characterValueExpression ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:524:4: ^( POSITION characterValueExpression characterValueExpression )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			POSITION340=(CommonTree)match(input,POSITION,FOLLOW_POSITION_in_positionFunction2110); 

			if ( _first_0==null ) _first_0 = POSITION340;
			match(input, Token.DOWN, null); 
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_characterValueExpression_in_positionFunction2112);
			characterValueExpression341=characterValueExpression();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)characterValueExpression341.getTree();

			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_characterValueExpression_in_positionFunction2114);
			characterValueExpression342=characterValueExpression();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)characterValueExpression342.getTree();

			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "positionFunction"


	public static class charLengthFunction_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "charLengthFunction"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:527:1: charLengthFunction : ^( CHARACTER_LENGTH characterValueExpression ) ;
	public final GeneratedHQLResolver.charLengthFunction_return charLengthFunction() throws RecognitionException {
		GeneratedHQLResolver.charLengthFunction_return retval = new GeneratedHQLResolver.charLengthFunction_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree CHARACTER_LENGTH343=null;
		TreeRuleReturnScope characterValueExpression344 =null;

		CommonTree CHARACTER_LENGTH343_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:528:2: ( ^( CHARACTER_LENGTH characterValueExpression ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:528:4: ^( CHARACTER_LENGTH characterValueExpression )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			CHARACTER_LENGTH343=(CommonTree)match(input,CHARACTER_LENGTH,FOLLOW_CHARACTER_LENGTH_in_charLengthFunction2127); 

			if ( _first_0==null ) _first_0 = CHARACTER_LENGTH343;
			match(input, Token.DOWN, null); 
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_characterValueExpression_in_charLengthFunction2129);
			characterValueExpression344=characterValueExpression();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)characterValueExpression344.getTree();

			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "charLengthFunction"


	public static class octetLengthFunction_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "octetLengthFunction"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:531:1: octetLengthFunction : ^( OCTET_LENGTH characterValueExpression ) ;
	public final GeneratedHQLResolver.octetLengthFunction_return octetLengthFunction() throws RecognitionException {
		GeneratedHQLResolver.octetLengthFunction_return retval = new GeneratedHQLResolver.octetLengthFunction_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree OCTET_LENGTH345=null;
		TreeRuleReturnScope characterValueExpression346 =null;

		CommonTree OCTET_LENGTH345_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:532:2: ( ^( OCTET_LENGTH characterValueExpression ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:532:4: ^( OCTET_LENGTH characterValueExpression )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			OCTET_LENGTH345=(CommonTree)match(input,OCTET_LENGTH,FOLLOW_OCTET_LENGTH_in_octetLengthFunction2142); 

			if ( _first_0==null ) _first_0 = OCTET_LENGTH345;
			match(input, Token.DOWN, null); 
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_characterValueExpression_in_octetLengthFunction2144);
			characterValueExpression346=characterValueExpression();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)characterValueExpression346.getTree();

			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "octetLengthFunction"


	public static class bitLengthFunction_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "bitLengthFunction"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:535:1: bitLengthFunction : ^( BIT_LENGTH characterValueExpression ) ;
	public final GeneratedHQLResolver.bitLengthFunction_return bitLengthFunction() throws RecognitionException {
		GeneratedHQLResolver.bitLengthFunction_return retval = new GeneratedHQLResolver.bitLengthFunction_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree BIT_LENGTH347=null;
		TreeRuleReturnScope characterValueExpression348 =null;

		CommonTree BIT_LENGTH347_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:536:2: ( ^( BIT_LENGTH characterValueExpression ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:536:4: ^( BIT_LENGTH characterValueExpression )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			BIT_LENGTH347=(CommonTree)match(input,BIT_LENGTH,FOLLOW_BIT_LENGTH_in_bitLengthFunction2158); 

			if ( _first_0==null ) _first_0 = BIT_LENGTH347;
			match(input, Token.DOWN, null); 
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_characterValueExpression_in_bitLengthFunction2160);
			characterValueExpression348=characterValueExpression();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)characterValueExpression348.getTree();

			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "bitLengthFunction"


	public static class countFunctionArguments_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "countFunctionArguments"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:540:1: countFunctionArguments : ( collectionExpression | propertyReference | numeric_literal );
	public final GeneratedHQLResolver.countFunctionArguments_return countFunctionArguments() throws RecognitionException {
		GeneratedHQLResolver.countFunctionArguments_return retval = new GeneratedHQLResolver.countFunctionArguments_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		TreeRuleReturnScope collectionExpression349 =null;
		TreeRuleReturnScope propertyReference350 =null;
		TreeRuleReturnScope numeric_literal351 =null;


		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:541:2: ( collectionExpression | propertyReference | numeric_literal )
			int alt69=3;
			switch ( input.LA(1) ) {
			case ELEMENTS:
			case INDICES:
				{
				alt69=1;
				}
				break;
			case PROPERTY_REFERENCE:
				{
				alt69=2;
				}
				break;
			case DECIMAL_LITERAL:
			case FLOATING_POINT_LITERAL:
			case INTEGER_LITERAL:
				{
				alt69=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 69, 0, input);
				throw nvae;
			}
			switch (alt69) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:541:4: collectionExpression
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_collectionExpression_in_countFunctionArguments2173);
					collectionExpression349=collectionExpression();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)collectionExpression349.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 2 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:542:4: propertyReference
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_propertyReference_in_countFunctionArguments2178);
					propertyReference350=propertyReference();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)propertyReference350.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 3 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:543:4: numeric_literal
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_numeric_literal_in_countFunctionArguments2183);
					numeric_literal351=numeric_literal();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)numeric_literal351.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "countFunctionArguments"


	public static class collectionFunction_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "collectionFunction"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:546:1: collectionFunction : ^( ( MAXELEMENT | MAXINDEX | MINELEMENT | MININDEX ) collectionPropertyReference ) ;
	public final GeneratedHQLResolver.collectionFunction_return collectionFunction() throws RecognitionException {
		GeneratedHQLResolver.collectionFunction_return retval = new GeneratedHQLResolver.collectionFunction_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree set352=null;
		TreeRuleReturnScope collectionPropertyReference353 =null;

		CommonTree set352_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:547:2: ( ^( ( MAXELEMENT | MAXINDEX | MINELEMENT | MININDEX ) collectionPropertyReference ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:547:4: ^( ( MAXELEMENT | MAXINDEX | MINELEMENT | MININDEX ) collectionPropertyReference )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			set352=(CommonTree)input.LT(1);
			if ( (input.LA(1) >= MAXELEMENT && input.LA(1) <= MAXINDEX)||(input.LA(1) >= MINELEMENT && input.LA(1) <= MININDEX) ) {
				input.consume();
				state.errorRecovery=false;
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}

			if ( _first_0==null ) _first_0 = set352;
			match(input, Token.DOWN, null); 
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_collectionPropertyReference_in_collectionFunction2205);
			collectionPropertyReference353=collectionPropertyReference();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)collectionPropertyReference353.getTree();

			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "collectionFunction"


	public static class collectionPropertyReference_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "collectionPropertyReference"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:551:1: collectionPropertyReference : propertyReference ;
	public final GeneratedHQLResolver.collectionPropertyReference_return collectionPropertyReference() throws RecognitionException {
		GeneratedHQLResolver.collectionPropertyReference_return retval = new GeneratedHQLResolver.collectionPropertyReference_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		TreeRuleReturnScope propertyReference354 =null;


		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:552:2: ( propertyReference )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:552:4: propertyReference
			{
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_propertyReference_in_collectionPropertyReference2220);
			propertyReference354=propertyReference();
			state._fsp--;

			 
			if ( _first_0==null ) _first_0 = (CommonTree)propertyReference354.getTree();

			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "collectionPropertyReference"


	public static class collectionExpression_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "collectionExpression"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:555:1: collectionExpression : ( ^( ELEMENTS propertyReference ) | ^( INDICES propertyReference ) );
	public final GeneratedHQLResolver.collectionExpression_return collectionExpression() throws RecognitionException {
		GeneratedHQLResolver.collectionExpression_return retval = new GeneratedHQLResolver.collectionExpression_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree ELEMENTS355=null;
		CommonTree INDICES357=null;
		TreeRuleReturnScope propertyReference356 =null;
		TreeRuleReturnScope propertyReference358 =null;

		CommonTree ELEMENTS355_tree=null;
		CommonTree INDICES357_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:556:2: ( ^( ELEMENTS propertyReference ) | ^( INDICES propertyReference ) )
			int alt70=2;
			switch ( input.LA(1) ) {
			case ELEMENTS:
				{
				alt70=1;
				}
				break;
			case INDICES:
				{
				alt70=2;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 70, 0, input);
				throw nvae;
			}
			switch (alt70) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:556:4: ^( ELEMENTS propertyReference )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					ELEMENTS355=(CommonTree)match(input,ELEMENTS,FOLLOW_ELEMENTS_in_collectionExpression2232); 

					if ( _first_0==null ) _first_0 = ELEMENTS355;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_propertyReference_in_collectionExpression2234);
					propertyReference356=propertyReference();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)propertyReference356.getTree();

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 2 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:557:4: ^( INDICES propertyReference )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					INDICES357=(CommonTree)match(input,INDICES,FOLLOW_INDICES_in_collectionExpression2242); 

					if ( _first_0==null ) _first_0 = INDICES357;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_propertyReference_in_collectionExpression2244);
					propertyReference358=propertyReference();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)propertyReference358.getTree();

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "collectionExpression"


	public static class parameter_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "parameter"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:560:1: parameter : ( NAMED_PARAM | JPA_PARAM | PARAM );
	public final GeneratedHQLResolver.parameter_return parameter() throws RecognitionException {
		GeneratedHQLResolver.parameter_return retval = new GeneratedHQLResolver.parameter_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree set359=null;

		CommonTree set359_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:561:2: ( NAMED_PARAM | JPA_PARAM | PARAM )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:
			{
			_last = (CommonTree)input.LT(1);
			set359=(CommonTree)input.LT(1);
			if ( input.LA(1)==JPA_PARAM||input.LA(1)==NAMED_PARAM||input.LA(1)==PARAM ) {
				input.consume();
				state.errorRecovery=false;
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}

			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);
			 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "parameter"


	public static class constant_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "constant"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:566:1: constant : ( literal | NULL | TRUE | FALSE );
	public final GeneratedHQLResolver.constant_return constant() throws RecognitionException {
		GeneratedHQLResolver.constant_return retval = new GeneratedHQLResolver.constant_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree NULL361=null;
		CommonTree TRUE362=null;
		CommonTree FALSE363=null;
		TreeRuleReturnScope literal360 =null;

		CommonTree NULL361_tree=null;
		CommonTree TRUE362_tree=null;
		CommonTree FALSE363_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:567:2: ( literal | NULL | TRUE | FALSE )
			int alt71=4;
			switch ( input.LA(1) ) {
			case CHARACTER_LITERAL:
			case CONST_STRING_VALUE:
			case DECIMAL_LITERAL:
			case FLOATING_POINT_LITERAL:
			case HEX_LITERAL:
			case INTEGER_LITERAL:
			case OCTAL_LITERAL:
			case STRING_LITERAL:
				{
				alt71=1;
				}
				break;
			case NULL:
				{
				alt71=2;
				}
				break;
			case TRUE:
				{
				alt71=3;
				}
				break;
			case FALSE:
				{
				alt71=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 71, 0, input);
				throw nvae;
			}
			switch (alt71) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:567:4: literal
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_literal_in_constant2277);
					literal360=literal();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)literal360.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 2 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:568:4: NULL
					{
					_last = (CommonTree)input.LT(1);
					NULL361=(CommonTree)match(input,NULL,FOLLOW_NULL_in_constant2282); 
					 
					if ( _first_0==null ) _first_0 = NULL361;

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 3 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:569:4: TRUE
					{
					_last = (CommonTree)input.LT(1);
					TRUE362=(CommonTree)match(input,TRUE,FOLLOW_TRUE_in_constant2287); 
					 
					if ( _first_0==null ) _first_0 = TRUE362;

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 4 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:570:4: FALSE
					{
					_last = (CommonTree)input.LT(1);
					FALSE363=(CommonTree)match(input,FALSE,FOLLOW_FALSE_in_constant2292); 
					 
					if ( _first_0==null ) _first_0 = FALSE363;

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "constant"


	public static class literal_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "literal"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:573:1: literal : ( numeric_literal | HEX_LITERAL | OCTAL_LITERAL | CHARACTER_LITERAL | STRING_LITERAL | ^( CONST_STRING_VALUE STRING_LITERAL ) );
	public final GeneratedHQLResolver.literal_return literal() throws RecognitionException {
		GeneratedHQLResolver.literal_return retval = new GeneratedHQLResolver.literal_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree HEX_LITERAL365=null;
		CommonTree OCTAL_LITERAL366=null;
		CommonTree CHARACTER_LITERAL367=null;
		CommonTree STRING_LITERAL368=null;
		CommonTree CONST_STRING_VALUE369=null;
		CommonTree STRING_LITERAL370=null;
		TreeRuleReturnScope numeric_literal364 =null;

		CommonTree HEX_LITERAL365_tree=null;
		CommonTree OCTAL_LITERAL366_tree=null;
		CommonTree CHARACTER_LITERAL367_tree=null;
		CommonTree STRING_LITERAL368_tree=null;
		CommonTree CONST_STRING_VALUE369_tree=null;
		CommonTree STRING_LITERAL370_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:574:2: ( numeric_literal | HEX_LITERAL | OCTAL_LITERAL | CHARACTER_LITERAL | STRING_LITERAL | ^( CONST_STRING_VALUE STRING_LITERAL ) )
			int alt72=6;
			switch ( input.LA(1) ) {
			case DECIMAL_LITERAL:
			case FLOATING_POINT_LITERAL:
			case INTEGER_LITERAL:
				{
				alt72=1;
				}
				break;
			case HEX_LITERAL:
				{
				alt72=2;
				}
				break;
			case OCTAL_LITERAL:
				{
				alt72=3;
				}
				break;
			case CHARACTER_LITERAL:
				{
				alt72=4;
				}
				break;
			case STRING_LITERAL:
				{
				alt72=5;
				}
				break;
			case CONST_STRING_VALUE:
				{
				alt72=6;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 72, 0, input);
				throw nvae;
			}
			switch (alt72) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:574:4: numeric_literal
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_numeric_literal_in_literal2303);
					numeric_literal364=numeric_literal();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)numeric_literal364.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 2 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:575:4: HEX_LITERAL
					{
					_last = (CommonTree)input.LT(1);
					HEX_LITERAL365=(CommonTree)match(input,HEX_LITERAL,FOLLOW_HEX_LITERAL_in_literal2308); 
					 
					if ( _first_0==null ) _first_0 = HEX_LITERAL365;

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 3 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:576:4: OCTAL_LITERAL
					{
					_last = (CommonTree)input.LT(1);
					OCTAL_LITERAL366=(CommonTree)match(input,OCTAL_LITERAL,FOLLOW_OCTAL_LITERAL_in_literal2313); 
					 
					if ( _first_0==null ) _first_0 = OCTAL_LITERAL366;

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 4 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:577:4: CHARACTER_LITERAL
					{
					_last = (CommonTree)input.LT(1);
					CHARACTER_LITERAL367=(CommonTree)match(input,CHARACTER_LITERAL,FOLLOW_CHARACTER_LITERAL_in_literal2318); 
					 
					if ( _first_0==null ) _first_0 = CHARACTER_LITERAL367;

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 5 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:578:4: STRING_LITERAL
					{
					_last = (CommonTree)input.LT(1);
					STRING_LITERAL368=(CommonTree)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_literal2323); 
					 
					if ( _first_0==null ) _first_0 = STRING_LITERAL368;

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 6 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:579:4: ^( CONST_STRING_VALUE STRING_LITERAL )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					CONST_STRING_VALUE369=(CommonTree)match(input,CONST_STRING_VALUE,FOLLOW_CONST_STRING_VALUE_in_literal2329); 

					if ( _first_0==null ) _first_0 = CONST_STRING_VALUE369;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					STRING_LITERAL370=(CommonTree)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_literal2331); 
					 
					if ( _first_1==null ) _first_1 = STRING_LITERAL370;

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "literal"


	public static class numeric_literal_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "numeric_literal"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:582:1: numeric_literal : ( INTEGER_LITERAL | DECIMAL_LITERAL | FLOATING_POINT_LITERAL );
	public final GeneratedHQLResolver.numeric_literal_return numeric_literal() throws RecognitionException {
		GeneratedHQLResolver.numeric_literal_return retval = new GeneratedHQLResolver.numeric_literal_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree set371=null;

		CommonTree set371_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:583:2: ( INTEGER_LITERAL | DECIMAL_LITERAL | FLOATING_POINT_LITERAL )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:
			{
			_last = (CommonTree)input.LT(1);
			set371=(CommonTree)input.LT(1);
			if ( input.LA(1)==DECIMAL_LITERAL||input.LA(1)==FLOATING_POINT_LITERAL||input.LA(1)==INTEGER_LITERAL ) {
				input.consume();
				state.errorRecovery=false;
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}

			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);
			 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "numeric_literal"


	public static class entityName_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "entityName"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:588:1: entityName : ENTITY_NAME ALIAS_NAME ;
	public final GeneratedHQLResolver.entityName_return entityName() throws RecognitionException {
		GeneratedHQLResolver.entityName_return retval = new GeneratedHQLResolver.entityName_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree ENTITY_NAME372=null;
		CommonTree ALIAS_NAME373=null;

		CommonTree ENTITY_NAME372_tree=null;
		CommonTree ALIAS_NAME373_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:589:2: ( ENTITY_NAME ALIAS_NAME )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:589:4: ENTITY_NAME ALIAS_NAME
			{
			_last = (CommonTree)input.LT(1);
			ENTITY_NAME372=(CommonTree)match(input,ENTITY_NAME,FOLLOW_ENTITY_NAME_in_entityName2364); 
			 
			if ( _first_0==null ) _first_0 = ENTITY_NAME372;

			_last = (CommonTree)input.LT(1);
			ALIAS_NAME373=(CommonTree)match(input,ALIAS_NAME,FOLLOW_ALIAS_NAME_in_entityName2366); 
			 
			if ( _first_0==null ) _first_0 = ALIAS_NAME373;

				registerPersisterSpace(ENTITY_NAME372, ALIAS_NAME373);	
			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "entityName"


	public static class propertyReference_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "propertyReference"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:593:1: propertyReference : ^( PROPERTY_REFERENCE propertyReferencePath ) ;
	public final GeneratedHQLResolver.propertyReference_return propertyReference() throws RecognitionException {
		GeneratedHQLResolver.propertyReference_return retval = new GeneratedHQLResolver.propertyReference_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree PROPERTY_REFERENCE374=null;
		TreeRuleReturnScope propertyReferencePath375 =null;

		CommonTree PROPERTY_REFERENCE374_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:594:2: ( ^( PROPERTY_REFERENCE propertyReferencePath ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:594:4: ^( PROPERTY_REFERENCE propertyReferencePath )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			PROPERTY_REFERENCE374=(CommonTree)match(input,PROPERTY_REFERENCE,FOLLOW_PROPERTY_REFERENCE_in_propertyReference2381); 

			if ( _first_0==null ) _first_0 = PROPERTY_REFERENCE374;
			match(input, Token.DOWN, null); 
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_propertyReferencePath_in_propertyReference2383);
			propertyReferencePath375=propertyReferencePath();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)propertyReferencePath375.getTree();

			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "propertyReference"


	public static class propertyReferencePath_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "propertyReferencePath"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:597:1: propertyReferencePath : ({...}? unqualifiedPropertyReference | pathedPropertyReference | terminalIndexOperation );
	public final GeneratedHQLResolver.propertyReferencePath_return propertyReferencePath() throws RecognitionException {
		GeneratedHQLResolver.propertyReferencePath_return retval = new GeneratedHQLResolver.propertyReferencePath_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		TreeRuleReturnScope unqualifiedPropertyReference376 =null;
		TreeRuleReturnScope pathedPropertyReference377 =null;
		TreeRuleReturnScope terminalIndexOperation378 =null;


		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:598:2: ({...}? unqualifiedPropertyReference | pathedPropertyReference | terminalIndexOperation )
			int alt73=3;
			switch ( input.LA(1) ) {
			case IDENTIFIER:
				{
				alt73=1;
				}
				break;
			case DOT:
				{
				alt73=2;
				}
				break;
			case LEFT_SQUARE:
				{
				alt73=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 73, 0, input);
				throw nvae;
			}
			switch (alt73) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:598:5: {...}? unqualifiedPropertyReference
					{
					if ( !((isUnqualifiedPropertyReference())) ) {
						throw new FailedPredicateException(input, "propertyReferencePath", "isUnqualifiedPropertyReference()");
					}
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_unqualifiedPropertyReference_in_propertyReferencePath2398);
					unqualifiedPropertyReference376=unqualifiedPropertyReference();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)unqualifiedPropertyReference376.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 2 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:599:4: pathedPropertyReference
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_pathedPropertyReference_in_propertyReferencePath2403);
					pathedPropertyReference377=pathedPropertyReference();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)pathedPropertyReference377.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 3 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:600:4: terminalIndexOperation
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_terminalIndexOperation_in_propertyReferencePath2408);
					terminalIndexOperation378=terminalIndexOperation();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)terminalIndexOperation378.getTree();

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "propertyReferencePath"


	public static class unqualifiedPropertyReference_return extends TreeRuleReturnScope {
		public PathedPropertyReferenceSource propertyReferenceSource;
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "unqualifiedPropertyReference"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:603:1: unqualifiedPropertyReference returns [PathedPropertyReferenceSource propertyReferenceSource] : IDENTIFIER ;
	public final GeneratedHQLResolver.unqualifiedPropertyReference_return unqualifiedPropertyReference() throws RecognitionException {
		GeneratedHQLResolver.unqualifiedPropertyReference_return retval = new GeneratedHQLResolver.unqualifiedPropertyReference_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree IDENTIFIER379=null;

		CommonTree IDENTIFIER379_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:604:2: ( IDENTIFIER )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:604:4: IDENTIFIER
			{
			_last = (CommonTree)input.LT(1);
			IDENTIFIER379=(CommonTree)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_unqualifiedPropertyReference2423); 
			 
			if ( _first_0==null ) _first_0 = IDENTIFIER379;

				retval.propertyReferenceSource = normalizeUnqualifiedPropertyReference( IDENTIFIER379 ); 
			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "unqualifiedPropertyReference"


	public static class pathedPropertyReference_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "pathedPropertyReference"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:608:1: pathedPropertyReference : ^( DOT pathedPropertyReferenceSource IDENTIFIER ) ;
	public final GeneratedHQLResolver.pathedPropertyReference_return pathedPropertyReference() throws RecognitionException {
		GeneratedHQLResolver.pathedPropertyReference_return retval = new GeneratedHQLResolver.pathedPropertyReference_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree DOT380=null;
		CommonTree IDENTIFIER382=null;
		TreeRuleReturnScope pathedPropertyReferenceSource381 =null;

		CommonTree DOT380_tree=null;
		CommonTree IDENTIFIER382_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:609:2: ( ^( DOT pathedPropertyReferenceSource IDENTIFIER ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:609:4: ^( DOT pathedPropertyReferenceSource IDENTIFIER )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			DOT380=(CommonTree)match(input,DOT,FOLLOW_DOT_in_pathedPropertyReference2438); 

			if ( _first_0==null ) _first_0 = DOT380;
			match(input, Token.DOWN, null); 
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_pathedPropertyReferenceSource_in_pathedPropertyReference2440);
			pathedPropertyReferenceSource381=pathedPropertyReferenceSource();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)pathedPropertyReferenceSource381.getTree();

			_last = (CommonTree)input.LT(1);
			IDENTIFIER382=(CommonTree)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_pathedPropertyReference2442); 
			 
			if ( _first_1==null ) _first_1 = IDENTIFIER382;

			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


				normalizePropertyPathTerminus( (pathedPropertyReferenceSource381!=null?((GeneratedHQLResolver.pathedPropertyReferenceSource_return)pathedPropertyReferenceSource381).propertyReferenceSource:null), IDENTIFIER382 );	
			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "pathedPropertyReference"


	public static class pathedPropertyReferenceSource_return extends TreeRuleReturnScope {
		public PathedPropertyReferenceSource propertyReferenceSource;
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "pathedPropertyReferenceSource"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:613:1: pathedPropertyReferenceSource returns [PathedPropertyReferenceSource propertyReferenceSource] : ({...}? => IDENTIFIER |{...}? => IDENTIFIER | intermediatePathedPropertyReference | intermediateIndexOperation );
	public final GeneratedHQLResolver.pathedPropertyReferenceSource_return pathedPropertyReferenceSource() throws RecognitionException {
		GeneratedHQLResolver.pathedPropertyReferenceSource_return retval = new GeneratedHQLResolver.pathedPropertyReferenceSource_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree IDENTIFIER383=null;
		CommonTree IDENTIFIER384=null;
		TreeRuleReturnScope intermediatePathedPropertyReference385 =null;
		TreeRuleReturnScope intermediateIndexOperation386 =null;

		CommonTree IDENTIFIER383_tree=null;
		CommonTree IDENTIFIER384_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:614:2: ({...}? => IDENTIFIER |{...}? => IDENTIFIER | intermediatePathedPropertyReference | intermediateIndexOperation )
			int alt74=4;
			int LA74_0 = input.LA(1);
			if ( (LA74_0==IDENTIFIER) && ((((isPersisterReferenceAlias()))||((isUnqualifiedPropertyReference()))))) {
				int LA74_1 = input.LA(2);
				if ( (((isPersisterReferenceAlias()))) ) {
					alt74=1;
				}
				else if ( (((isUnqualifiedPropertyReference()))) ) {
					alt74=2;
				}
				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 74, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
			}
			else if ( (LA74_0==DOT) ) {
				alt74=3;
			}
			else if ( (LA74_0==LEFT_SQUARE) ) {
				alt74=4;
			}
			else {
				NoViableAltException nvae =
					new NoViableAltException("", 74, 0, input);
				throw nvae;
			}
			switch (alt74) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:614:4: {...}? => IDENTIFIER
					{
					if ( !(((isPersisterReferenceAlias()))) ) {
						throw new FailedPredicateException(input, "pathedPropertyReferenceSource", "(isPersisterReferenceAlias())");
					}
					_last = (CommonTree)input.LT(1);
					IDENTIFIER383=(CommonTree)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_pathedPropertyReferenceSource2464); 
					 
					if ( _first_0==null ) _first_0 = IDENTIFIER383;

					 retval.propertyReferenceSource = normalizeQualifiedRoot( IDENTIFIER383 ); 
					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 2 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:615:4: {...}? => IDENTIFIER
					{
					if ( !(((isUnqualifiedPropertyReference()))) ) {
						throw new FailedPredicateException(input, "pathedPropertyReferenceSource", "(isUnqualifiedPropertyReference())");
					}
					_last = (CommonTree)input.LT(1);
					IDENTIFIER384=(CommonTree)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_pathedPropertyReferenceSource2474); 
					 
					if ( _first_0==null ) _first_0 = IDENTIFIER384;

					 retval.propertyReferenceSource = normalizeUnqualifiedRoot( IDENTIFIER384 ); 
					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 3 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:616:4: intermediatePathedPropertyReference
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_intermediatePathedPropertyReference_in_pathedPropertyReferenceSource2481);
					intermediatePathedPropertyReference385=intermediatePathedPropertyReference();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)intermediatePathedPropertyReference385.getTree();

					 retval.propertyReferenceSource = (intermediatePathedPropertyReference385!=null?((GeneratedHQLResolver.intermediatePathedPropertyReference_return)intermediatePathedPropertyReference385).propertyReferenceSource:null); 
					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 4 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:617:4: intermediateIndexOperation
					{
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_intermediateIndexOperation_in_pathedPropertyReferenceSource2488);
					intermediateIndexOperation386=intermediateIndexOperation();
					state._fsp--;

					 
					if ( _first_0==null ) _first_0 = (CommonTree)intermediateIndexOperation386.getTree();

					 retval.propertyReferenceSource = (intermediateIndexOperation386!=null?((GeneratedHQLResolver.intermediateIndexOperation_return)intermediateIndexOperation386).propertyReferenceSource:null); 
					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "pathedPropertyReferenceSource"


	public static class intermediatePathedPropertyReference_return extends TreeRuleReturnScope {
		public PathedPropertyReferenceSource propertyReferenceSource;
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "intermediatePathedPropertyReference"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:620:1: intermediatePathedPropertyReference returns [PathedPropertyReferenceSource propertyReferenceSource] : ^( DOT source= pathedPropertyReferenceSource IDENTIFIER ) ;
	public final GeneratedHQLResolver.intermediatePathedPropertyReference_return intermediatePathedPropertyReference() throws RecognitionException {
		GeneratedHQLResolver.intermediatePathedPropertyReference_return retval = new GeneratedHQLResolver.intermediatePathedPropertyReference_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree DOT387=null;
		CommonTree IDENTIFIER388=null;
		TreeRuleReturnScope source =null;

		CommonTree DOT387_tree=null;
		CommonTree IDENTIFIER388_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:621:2: ( ^( DOT source= pathedPropertyReferenceSource IDENTIFIER ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:621:4: ^( DOT source= pathedPropertyReferenceSource IDENTIFIER )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			DOT387=(CommonTree)match(input,DOT,FOLLOW_DOT_in_intermediatePathedPropertyReference2506); 

			if ( _first_0==null ) _first_0 = DOT387;
			match(input, Token.DOWN, null); 
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_pathedPropertyReferenceSource_in_intermediatePathedPropertyReference2510);
			source=pathedPropertyReferenceSource();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)source.getTree();

			_last = (CommonTree)input.LT(1);
			IDENTIFIER388=(CommonTree)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_intermediatePathedPropertyReference2512); 
			 
			if ( _first_1==null ) _first_1 = IDENTIFIER388;

			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


				retval.propertyReferenceSource = normalizePropertyPathIntermediary( (source!=null?((GeneratedHQLResolver.pathedPropertyReferenceSource_return)source).propertyReferenceSource:null), IDENTIFIER388 );	
			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "intermediatePathedPropertyReference"


	public static class intermediateIndexOperation_return extends TreeRuleReturnScope {
		public PathedPropertyReferenceSource propertyReferenceSource;
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "intermediateIndexOperation"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:625:1: intermediateIndexOperation returns [PathedPropertyReferenceSource propertyReferenceSource] : ^( LEFT_SQUARE indexOperationSource indexSelector ) ;
	public final GeneratedHQLResolver.intermediateIndexOperation_return intermediateIndexOperation() throws RecognitionException {
		GeneratedHQLResolver.intermediateIndexOperation_return retval = new GeneratedHQLResolver.intermediateIndexOperation_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree LEFT_SQUARE389=null;
		TreeRuleReturnScope indexOperationSource390 =null;
		TreeRuleReturnScope indexSelector391 =null;

		CommonTree LEFT_SQUARE389_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:626:2: ( ^( LEFT_SQUARE indexOperationSource indexSelector ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:626:4: ^( LEFT_SQUARE indexOperationSource indexSelector )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			LEFT_SQUARE389=(CommonTree)match(input,LEFT_SQUARE,FOLLOW_LEFT_SQUARE_in_intermediateIndexOperation2534); 

			if ( _first_0==null ) _first_0 = LEFT_SQUARE389;
			match(input, Token.DOWN, null); 
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_indexOperationSource_in_intermediateIndexOperation2536);
			indexOperationSource390=indexOperationSource();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)indexOperationSource390.getTree();

			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_indexSelector_in_intermediateIndexOperation2538);
			indexSelector391=indexSelector();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)indexSelector391.getTree();

			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


				retval.propertyReferenceSource = normalizeIntermediateIndexOperation( (indexOperationSource390!=null?((GeneratedHQLResolver.indexOperationSource_return)indexOperationSource390).propertyReferenceSource:null), (indexOperationSource390!=null?((GeneratedHQLResolver.indexOperationSource_return)indexOperationSource390).collectionProperty:null), (indexSelector391!=null?((CommonTree)indexSelector391.getTree()):null) );	
			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "intermediateIndexOperation"


	public static class terminalIndexOperation_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "terminalIndexOperation"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:630:1: terminalIndexOperation : ^( LEFT_SQUARE indexOperationSource indexSelector ) ;
	public final GeneratedHQLResolver.terminalIndexOperation_return terminalIndexOperation() throws RecognitionException {
		GeneratedHQLResolver.terminalIndexOperation_return retval = new GeneratedHQLResolver.terminalIndexOperation_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree LEFT_SQUARE392=null;
		TreeRuleReturnScope indexOperationSource393 =null;
		TreeRuleReturnScope indexSelector394 =null;

		CommonTree LEFT_SQUARE392_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:631:2: ( ^( LEFT_SQUARE indexOperationSource indexSelector ) )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:631:4: ^( LEFT_SQUARE indexOperationSource indexSelector )
			{
			_last = (CommonTree)input.LT(1);
			{
			CommonTree _save_last_1 = _last;
			CommonTree _first_1 = null;
			_last = (CommonTree)input.LT(1);
			LEFT_SQUARE392=(CommonTree)match(input,LEFT_SQUARE,FOLLOW_LEFT_SQUARE_in_terminalIndexOperation2557); 

			if ( _first_0==null ) _first_0 = LEFT_SQUARE392;
			match(input, Token.DOWN, null); 
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_indexOperationSource_in_terminalIndexOperation2559);
			indexOperationSource393=indexOperationSource();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)indexOperationSource393.getTree();

			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_indexSelector_in_terminalIndexOperation2561);
			indexSelector394=indexSelector();
			state._fsp--;

			 
			if ( _first_1==null ) _first_1 = (CommonTree)indexSelector394.getTree();

			match(input, Token.UP, null); 
			_last = _save_last_1;
			}


				normalizeTerminalIndexOperation( (indexOperationSource393!=null?((GeneratedHQLResolver.indexOperationSource_return)indexOperationSource393).propertyReferenceSource:null), (indexOperationSource393!=null?((GeneratedHQLResolver.indexOperationSource_return)indexOperationSource393).collectionProperty:null), (indexSelector394!=null?((CommonTree)indexSelector394.getTree()):null) );	
			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "terminalIndexOperation"


	public static class indexOperationSource_return extends TreeRuleReturnScope {
		public PathedPropertyReferenceSource propertyReferenceSource;
		public Tree collectionProperty;
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "indexOperationSource"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:635:1: indexOperationSource returns [PathedPropertyReferenceSource propertyReferenceSource, Tree collectionProperty] : ( ^( DOT pathedPropertyReferenceSource IDENTIFIER ) |{...}? => IDENTIFIER );
	public final GeneratedHQLResolver.indexOperationSource_return indexOperationSource() throws RecognitionException {
		GeneratedHQLResolver.indexOperationSource_return retval = new GeneratedHQLResolver.indexOperationSource_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree DOT395=null;
		CommonTree IDENTIFIER397=null;
		CommonTree IDENTIFIER398=null;
		TreeRuleReturnScope pathedPropertyReferenceSource396 =null;

		CommonTree DOT395_tree=null;
		CommonTree IDENTIFIER397_tree=null;
		CommonTree IDENTIFIER398_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:636:2: ( ^( DOT pathedPropertyReferenceSource IDENTIFIER ) |{...}? => IDENTIFIER )
			int alt75=2;
			int LA75_0 = input.LA(1);
			if ( (LA75_0==DOT) ) {
				alt75=1;
			}
			else if ( (LA75_0==IDENTIFIER) && (((isUnqualifiedPropertyReference())))) {
				alt75=2;
			}
			else {
				NoViableAltException nvae =
					new NoViableAltException("", 75, 0, input);
				throw nvae;
			}
			switch (alt75) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:636:4: ^( DOT pathedPropertyReferenceSource IDENTIFIER )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					DOT395=(CommonTree)match(input,DOT,FOLLOW_DOT_in_indexOperationSource2583); 

					if ( _first_0==null ) _first_0 = DOT395;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_pathedPropertyReferenceSource_in_indexOperationSource2585);
					pathedPropertyReferenceSource396=pathedPropertyReferenceSource();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)pathedPropertyReferenceSource396.getTree();

					_last = (CommonTree)input.LT(1);
					IDENTIFIER397=(CommonTree)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_indexOperationSource2587); 
					 
					if ( _first_1==null ) _first_1 = IDENTIFIER397;

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


						retval.propertyReferenceSource = (pathedPropertyReferenceSource396!=null?((GeneratedHQLResolver.pathedPropertyReferenceSource_return)pathedPropertyReferenceSource396).propertyReferenceSource:null);
							retval.collectionProperty = IDENTIFIER397;	
					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 2 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:639:5: {...}? => IDENTIFIER
					{
					if ( !(((isUnqualifiedPropertyReference()))) ) {
						throw new FailedPredicateException(input, "indexOperationSource", "(isUnqualifiedPropertyReference())");
					}
					_last = (CommonTree)input.LT(1);
					IDENTIFIER398=(CommonTree)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_indexOperationSource2601); 
					 
					if ( _first_0==null ) _first_0 = IDENTIFIER398;

						retval.propertyReferenceSource = normalizeUnqualifiedPropertyReferenceSource( IDENTIFIER398 );
								retval.collectionProperty = IDENTIFIER398;	
					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "indexOperationSource"


	public static class indexSelector_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "indexSelector"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:644:1: indexSelector : valueExpression ;
	public final GeneratedHQLResolver.indexSelector_return indexSelector() throws RecognitionException {
		GeneratedHQLResolver.indexSelector_return retval = new GeneratedHQLResolver.indexSelector_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		TreeRuleReturnScope valueExpression399 =null;


		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:645:2: ( valueExpression )
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:645:4: valueExpression
			{
			_last = (CommonTree)input.LT(1);
			pushFollow(FOLLOW_valueExpression_in_indexSelector2616);
			valueExpression399=valueExpression();
			state._fsp--;

			 
			if ( _first_0==null ) _first_0 = (CommonTree)valueExpression399.getTree();

			retval.tree = (CommonTree)_first_0;
			if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
				retval.tree = (CommonTree)adaptor.getParent(retval.tree);

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "indexSelector"


	public static class path_return extends TreeRuleReturnScope {
		CommonTree tree;
		public Object getTree() { return tree; }
	};


	// $ANTLR start "path"
	// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:648:1: path : ( IDENTIFIER | ^( DOT path path ) | ^( LEFT_SQUARE path ( valueExpression )* ) | ^( LEFT_PAREN path ( valueExpression )* ) );
	public final GeneratedHQLResolver.path_return path() throws RecognitionException {
		GeneratedHQLResolver.path_return retval = new GeneratedHQLResolver.path_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		CommonTree _first_0 = null;
		CommonTree _last = null;


		CommonTree IDENTIFIER400=null;
		CommonTree DOT401=null;
		CommonTree LEFT_SQUARE404=null;
		CommonTree LEFT_PAREN407=null;
		TreeRuleReturnScope path402 =null;
		TreeRuleReturnScope path403 =null;
		TreeRuleReturnScope path405 =null;
		TreeRuleReturnScope valueExpression406 =null;
		TreeRuleReturnScope path408 =null;
		TreeRuleReturnScope valueExpression409 =null;

		CommonTree IDENTIFIER400_tree=null;
		CommonTree DOT401_tree=null;
		CommonTree LEFT_SQUARE404_tree=null;
		CommonTree LEFT_PAREN407_tree=null;

		try {
			// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:649:2: ( IDENTIFIER | ^( DOT path path ) | ^( LEFT_SQUARE path ( valueExpression )* ) | ^( LEFT_PAREN path ( valueExpression )* ) )
			int alt78=4;
			switch ( input.LA(1) ) {
			case IDENTIFIER:
				{
				alt78=1;
				}
				break;
			case DOT:
				{
				alt78=2;
				}
				break;
			case LEFT_SQUARE:
				{
				alt78=3;
				}
				break;
			case LEFT_PAREN:
				{
				alt78=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 78, 0, input);
				throw nvae;
			}
			switch (alt78) {
				case 1 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:649:5: IDENTIFIER
					{
					_last = (CommonTree)input.LT(1);
					IDENTIFIER400=(CommonTree)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_path2628); 
					 
					if ( _first_0==null ) _first_0 = IDENTIFIER400;

					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 2 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:650:4: ^( DOT path path )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					DOT401=(CommonTree)match(input,DOT,FOLLOW_DOT_in_path2634); 

					if ( _first_0==null ) _first_0 = DOT401;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_path_in_path2636);
					path402=path();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)path402.getTree();

					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_path_in_path2638);
					path403=path();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)path403.getTree();

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 3 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:651:4: ^( LEFT_SQUARE path ( valueExpression )* )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					LEFT_SQUARE404=(CommonTree)match(input,LEFT_SQUARE,FOLLOW_LEFT_SQUARE_in_path2646); 

					if ( _first_0==null ) _first_0 = LEFT_SQUARE404;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_path_in_path2648);
					path405=path();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)path405.getTree();

					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:651:23: ( valueExpression )*
					loop76:
					do {
						int alt76=2;
						switch ( input.LA(1) ) {
						case ABS:
						case ALIAS_REF:
						case ALL:
						case ANY:
						case ASTERISK:
						case AVG:
						case BIT_LENGTH:
						case CAST:
						case CHARACTER_LENGTH:
						case CHARACTER_LITERAL:
						case COALESCE:
						case CONCAT:
						case CONST_STRING_VALUE:
						case COUNT:
						case CURRENT_DATE:
						case CURRENT_TIME:
						case CURRENT_TIMESTAMP:
						case DECIMAL_LITERAL:
						case DOT_CLASS:
						case DOUBLE_PIPE:
						case ELEMENTS:
						case EXISTS:
						case EXTRACT:
						case FALSE:
						case FLOATING_POINT_LITERAL:
						case FUNCTION:
						case HEX_LITERAL:
						case INDEX:
						case INDICES:
						case INTEGER_LITERAL:
						case JAVA_CONSTANT:
						case JPA_PARAM:
						case LENGTH:
						case LOCATE:
						case LOWER:
						case MAX:
						case MAXELEMENT:
						case MAXINDEX:
						case MIN:
						case MINELEMENT:
						case MININDEX:
						case MINUS:
						case MOD:
						case NAMED_PARAM:
						case NULL:
						case NULLIF:
						case OCTAL_LITERAL:
						case OCTET_LENGTH:
						case PARAM:
						case PATH:
						case PLUS:
						case POSITION:
						case PROPERTY_REFERENCE:
						case SEARCHED_CASE:
						case SIMPLE_CASE:
						case SIZE:
						case SOLIDUS:
						case SOME:
						case SQRT:
						case STRING_LITERAL:
						case SUBSTRING:
						case SUB_QUERY:
						case SUM:
						case TRIM:
						case TRUE:
						case UNARY_MINUS:
						case UNARY_PLUS:
						case UPPER:
						case VECTOR_EXPR:
							{
							alt76=1;
							}
							break;
						}
						switch (alt76) {
						case 1 :
							// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:651:23: valueExpression
							{
							_last = (CommonTree)input.LT(1);
							pushFollow(FOLLOW_valueExpression_in_path2650);
							valueExpression406=valueExpression();
							state._fsp--;

							 
							if ( _first_1==null ) _first_1 = (CommonTree)valueExpression406.getTree();

							retval.tree = (CommonTree)_first_0;
							if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
								retval.tree = (CommonTree)adaptor.getParent(retval.tree);

							}
							break;

						default :
							break loop76;
						}
					} while (true);

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;
				case 4 :
					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:652:4: ^( LEFT_PAREN path ( valueExpression )* )
					{
					_last = (CommonTree)input.LT(1);
					{
					CommonTree _save_last_1 = _last;
					CommonTree _first_1 = null;
					_last = (CommonTree)input.LT(1);
					LEFT_PAREN407=(CommonTree)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_path2659); 

					if ( _first_0==null ) _first_0 = LEFT_PAREN407;
					match(input, Token.DOWN, null); 
					_last = (CommonTree)input.LT(1);
					pushFollow(FOLLOW_path_in_path2661);
					path408=path();
					state._fsp--;

					 
					if ( _first_1==null ) _first_1 = (CommonTree)path408.getTree();

					// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:652:22: ( valueExpression )*
					loop77:
					do {
						int alt77=2;
						switch ( input.LA(1) ) {
						case ABS:
						case ALIAS_REF:
						case ALL:
						case ANY:
						case ASTERISK:
						case AVG:
						case BIT_LENGTH:
						case CAST:
						case CHARACTER_LENGTH:
						case CHARACTER_LITERAL:
						case COALESCE:
						case CONCAT:
						case CONST_STRING_VALUE:
						case COUNT:
						case CURRENT_DATE:
						case CURRENT_TIME:
						case CURRENT_TIMESTAMP:
						case DECIMAL_LITERAL:
						case DOT_CLASS:
						case DOUBLE_PIPE:
						case ELEMENTS:
						case EXISTS:
						case EXTRACT:
						case FALSE:
						case FLOATING_POINT_LITERAL:
						case FUNCTION:
						case HEX_LITERAL:
						case INDEX:
						case INDICES:
						case INTEGER_LITERAL:
						case JAVA_CONSTANT:
						case JPA_PARAM:
						case LENGTH:
						case LOCATE:
						case LOWER:
						case MAX:
						case MAXELEMENT:
						case MAXINDEX:
						case MIN:
						case MINELEMENT:
						case MININDEX:
						case MINUS:
						case MOD:
						case NAMED_PARAM:
						case NULL:
						case NULLIF:
						case OCTAL_LITERAL:
						case OCTET_LENGTH:
						case PARAM:
						case PATH:
						case PLUS:
						case POSITION:
						case PROPERTY_REFERENCE:
						case SEARCHED_CASE:
						case SIMPLE_CASE:
						case SIZE:
						case SOLIDUS:
						case SOME:
						case SQRT:
						case STRING_LITERAL:
						case SUBSTRING:
						case SUB_QUERY:
						case SUM:
						case TRIM:
						case TRUE:
						case UNARY_MINUS:
						case UNARY_PLUS:
						case UPPER:
						case VECTOR_EXPR:
							{
							alt77=1;
							}
							break;
						}
						switch (alt77) {
						case 1 :
							// org/hibernate/sql/ast/origin/hql/resolve/GeneratedHQLResolver.g:652:22: valueExpression
							{
							_last = (CommonTree)input.LT(1);
							pushFollow(FOLLOW_valueExpression_in_path2663);
							valueExpression409=valueExpression();
							state._fsp--;

							 
							if ( _first_1==null ) _first_1 = (CommonTree)valueExpression409.getTree();

							retval.tree = (CommonTree)_first_0;
							if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
								retval.tree = (CommonTree)adaptor.getParent(retval.tree);

							}
							break;

						default :
							break loop77;
						}
					} while (true);

					match(input, Token.UP, null); 
					_last = _save_last_1;
					}


					retval.tree = (CommonTree)_first_0;
					if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
						retval.tree = (CommonTree)adaptor.getParent(retval.tree);

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "path"

	// Delegated rules



	public static final BitSet FOLLOW_QUERY_in_filterStatement62 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_QUERY_SPEC_in_filterStatement65 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_FILTER_in_filterStatement67 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000040L,0x1000000008000008L});
	public static final BitSet FOLLOW_selectClause_in_filterStatement74 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000040L,0x1000000000000008L});
	public static final BitSet FOLLOW_whereClause_in_filterStatement77 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000040L,0x0000000000000008L});
	public static final BitSet FOLLOW_groupByClause_in_filterStatement82 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000080L,0x0000000000000008L});
	public static final BitSet FOLLOW_havingClause_in_filterStatement84 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000000008L});
	public static final BitSet FOLLOW_orderByClause_in_filterStatement89 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_updateStatementSet_in_statement103 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_deleteStatementSet_in_statement108 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_insertStatementSet_in_statement113 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_queryStatementSet_in_statement118 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_updateStatement_in_updateStatementSet129 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_UPDATE_in_updateStatement142 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_entityName_in_updateStatement144 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000100000000L});
	public static final BitSet FOLLOW_SET_in_updateStatement147 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_assignment_in_updateStatement149 = new BitSet(new long[]{0x0010000000000008L});
	public static final BitSet FOLLOW_whereClause_in_updateStatement153 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_EQUALS_in_assignment167 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_propertyReference_in_assignment169 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
	public static final BitSet FOLLOW_valueExpression_in_assignment171 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_EQUALS_in_assignment178 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_VERSIONED_VALUE_in_assignment180 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000008000000000L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_assignment182 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_deleteStatement_in_deleteStatementSet194 = new BitSet(new long[]{0x0000008000000002L});
	public static final BitSet FOLLOW_DELETE_in_deleteStatement207 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_entityName_in_deleteStatement209 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x1000000000000000L});
	public static final BitSet FOLLOW_whereClause_in_deleteStatement211 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_insertStatement_in_insertStatementSet224 = new BitSet(new long[]{0x0000000000000002L,0x0000000000010000L});
	public static final BitSet FOLLOW_INSERT_in_insertStatement237 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_intoClause_in_insertStatement239 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_queryStatementSet_in_insertStatement241 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_INTO_in_intoClause254 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_entityName_in_intoClause256 = new BitSet(new long[]{0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_INSERTABILITY_SPEC_in_intoClause259 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_propertyReference_in_intoClause261 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000010000L});
	public static final BitSet FOLLOW_queryStatement_in_queryStatementSet277 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_QUERY_in_queryStatement290 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_queryExpression_in_queryStatement292 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000000008L});
	public static final BitSet FOLLOW_orderByClause_in_queryStatement294 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_UNION_in_queryExpression308 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ALL_in_queryExpression310 = new BitSet(new long[]{0x0080000000000000L,0x0000000000100000L,0x0020000000100000L});
	public static final BitSet FOLLOW_queryExpression_in_queryExpression313 = new BitSet(new long[]{0x0080000000000000L,0x0000000000100000L,0x0020000000100000L});
	public static final BitSet FOLLOW_queryExpression_in_queryExpression315 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_INTERSECT_in_queryExpression322 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ALL_in_queryExpression324 = new BitSet(new long[]{0x0080000000000000L,0x0000000000100000L,0x0020000000100000L});
	public static final BitSet FOLLOW_queryExpression_in_queryExpression327 = new BitSet(new long[]{0x0080000000000000L,0x0000000000100000L,0x0020000000100000L});
	public static final BitSet FOLLOW_queryExpression_in_queryExpression329 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_EXCEPT_in_queryExpression336 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ALL_in_queryExpression338 = new BitSet(new long[]{0x0080000000000000L,0x0000000000100000L,0x0020000000100000L});
	public static final BitSet FOLLOW_queryExpression_in_queryExpression341 = new BitSet(new long[]{0x0080000000000000L,0x0000000000100000L,0x0020000000100000L});
	public static final BitSet FOLLOW_queryExpression_in_queryExpression343 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_querySpec_in_queryExpression349 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUERY_SPEC_in_querySpec362 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_selectFrom_in_querySpec364 = new BitSet(new long[]{0x0000000000000008L,0x00000000000000C0L,0x1000000000000000L});
	public static final BitSet FOLLOW_whereClause_in_querySpec366 = new BitSet(new long[]{0x0000000000000008L,0x00000000000000C0L});
	public static final BitSet FOLLOW_groupByClause_in_querySpec369 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000080L});
	public static final BitSet FOLLOW_havingClause_in_querySpec372 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_WHERE_in_whereClause386 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_searchCondition_in_whereClause388 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_GROUP_BY_in_groupByClause401 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_groupingValue_in_groupByClause403 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000020L});
	public static final BitSet FOLLOW_GROUPING_VALUE_in_groupingValue417 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_valueExpression_in_groupingValue419 = new BitSet(new long[]{0x0000000001000008L});
	public static final BitSet FOLLOW_COLLATE_in_groupingValue421 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_HAVING_in_havingClause435 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_searchCondition_in_havingClause437 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SELECT_FROM_in_selectFrom450 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_fromClause_in_selectFrom452 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_selectClause_in_selectFrom454 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_FROM_in_fromClause467 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_persisterSpaces_in_fromClause469 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_PERSISTER_SPACE_in_persisterSpaces483 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_persisterSpace_in_persisterSpaces485 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_persisterSpaceRoot_in_persisterSpace497 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000008200L});
	public static final BitSet FOLLOW_joins_in_persisterSpace499 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000008200L});
	public static final BitSet FOLLOW_ENTITY_PERSISTER_REF_in_persisterSpaceRoot512 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_entityName_in_persisterSpaceRoot514 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_PROP_FETCH_in_persisterSpaceRoot516 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PROPERTY_JOIN_in_joins530 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_joinType_in_joins534 = new BitSet(new long[]{0x1000000000000020L});
	public static final BitSet FOLLOW_FETCH_in_joins538 = new BitSet(new long[]{0x0000000000000020L});
	public static final BitSet FOLLOW_ALIAS_NAME_in_joins543 = new BitSet(new long[]{0x0000400000000000L,0x0000000000004000L,0x0000000000030000L});
	public static final BitSet FOLLOW_PROP_FETCH_in_joins547 = new BitSet(new long[]{0x0000400000000000L,0x0000000000004000L,0x0000000000010000L});
	public static final BitSet FOLLOW_collectionExpression_in_joins557 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x2000000000000000L});
	public static final BitSet FOLLOW_propertyReference_in_joins559 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x2000000000000000L});
	public static final BitSet FOLLOW_withClause_in_joins562 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PERSISTER_JOIN_in_joins574 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_joinType_in_joins576 = new BitSet(new long[]{0x0004000000000000L});
	public static final BitSet FOLLOW_persisterSpaceRoot_in_joins578 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_onClause_in_joins580 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_WITH_in_withClause594 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_searchCondition_in_withClause596 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ON_in_onClause609 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_searchCondition_in_onClause611 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_CROSS_in_joinType627 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INNER_in_joinType634 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LEFT_in_joinType642 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_RIGHT_in_joinType648 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_FULL_in_joinType654 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_OUTER_in_joinType659 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SELECT_in_selectClause682 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_DISTINCT_in_selectClause684 = new BitSet(new long[]{0x4D007C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE620130C1L});
	public static final BitSet FOLLOW_rootSelectExpression_in_selectClause687 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SELECT_LIST_in_rootSelectExpression701 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_rootSelectExpression_in_rootSelectExpression703 = new BitSet(new long[]{0x4D007C5DC0BA64D8L,0xB015EF8850046204L,0x018F07DE620130C1L});
	public static final BitSet FOLLOW_SELECT_ITEM_in_rootSelectExpression711 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_rootSelectExpression_in_rootSelectExpression713 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_DYNAMIC_INSTANTIATION_in_rootSelectExpression720 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_rootSelectExpression_in_rootSelectExpression722 = new BitSet(new long[]{0x4D007C5DC0BA64D8L,0xB015EF8850046204L,0x018F07DE620130C1L});
	public static final BitSet FOLLOW_DYNAMIC_INSTANTIATION_ARG_in_rootSelectExpression730 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_rootSelectExpression_in_rootSelectExpression732 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_valueExpression_in_rootSelectExpression738 = new BitSet(new long[]{0x0000000000000022L});
	public static final BitSet FOLLOW_ALIAS_NAME_in_rootSelectExpression740 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ORDER_BY_in_orderByClause753 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_sortSpecification_in_orderByClause755 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000002000000000L});
	public static final BitSet FOLLOW_SORT_SPEC_in_sortSpecification769 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_valueExpression_in_sortSpecification771 = new BitSet(new long[]{0x0000000001000000L,0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_COLLATE_in_sortSpecification773 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_ORDER_SPEC_in_sortSpecification776 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_OR_in_searchCondition792 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_searchCondition_in_searchCondition794 = new BitSet(new long[]{0x4D104C5DC0BAE6D0L,0xBFD5FFF85F04721CL,0x018F07DE020130C5L});
	public static final BitSet FOLLOW_searchCondition_in_searchCondition796 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_AND_in_searchCondition809 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_searchCondition_in_searchCondition811 = new BitSet(new long[]{0x4D104C5DC0BAE6D0L,0xBFD5FFF85F04721CL,0x018F07DE020130C5L});
	public static final BitSet FOLLOW_searchCondition_in_searchCondition813 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_NOT_in_searchCondition826 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_searchCondition_in_searchCondition828 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_predicate_in_searchCondition837 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EQUALS_in_predicate850 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_rowValueConstructor_in_predicate852 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
	public static final BitSet FOLLOW_comparativePredicateValue_in_predicate854 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_NOT_EQUAL_in_predicate865 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_rowValueConstructor_in_predicate867 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
	public static final BitSet FOLLOW_comparativePredicateValue_in_predicate869 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_LESS_in_predicate878 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_rowValueConstructor_in_predicate880 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
	public static final BitSet FOLLOW_comparativePredicateValue_in_predicate882 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_LESS_EQUAL_in_predicate891 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_rowValueConstructor_in_predicate893 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
	public static final BitSet FOLLOW_comparativePredicateValue_in_predicate895 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_GREATER_in_predicate904 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_rowValueConstructor_in_predicate906 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
	public static final BitSet FOLLOW_comparativePredicateValue_in_predicate908 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_GREATER_EQUAL_in_predicate917 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_rowValueConstructor_in_predicate919 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
	public static final BitSet FOLLOW_comparativePredicateValue_in_predicate921 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_IS_NULL_in_predicate930 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_rowValueConstructor_in_predicate932 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_IS_NOT_NULL_in_predicate941 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_rowValueConstructor_in_predicate943 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_LIKE_in_predicate952 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_valueExpression_in_predicate954 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
	public static final BitSet FOLLOW_valueExpression_in_predicate956 = new BitSet(new long[]{0x0020000000000008L});
	public static final BitSet FOLLOW_escapeSpecification_in_predicate958 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_NOT_LIKE_in_predicate968 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_valueExpression_in_predicate970 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
	public static final BitSet FOLLOW_valueExpression_in_predicate972 = new BitSet(new long[]{0x0020000000000008L});
	public static final BitSet FOLLOW_escapeSpecification_in_predicate974 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_BETWEEN_in_predicate984 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_rowValueConstructor_in_predicate986 = new BitSet(new long[]{0x0000000000010000L});
	public static final BitSet FOLLOW_betweenList_in_predicate988 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_NOT_BETWEEN_in_predicate997 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_rowValueConstructor_in_predicate999 = new BitSet(new long[]{0x0000000000010000L});
	public static final BitSet FOLLOW_betweenList_in_predicate1001 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_IN_in_predicate1010 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_rowValueConstructor_in_predicate1012 = new BitSet(new long[]{0x0000000000000000L,0x0000000000400000L});
	public static final BitSet FOLLOW_inPredicateValue_in_predicate1014 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_NOT_IN_in_predicate1023 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_rowValueConstructor_in_predicate1025 = new BitSet(new long[]{0x0000000000000000L,0x0000000000400000L});
	public static final BitSet FOLLOW_inPredicateValue_in_predicate1027 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_MEMBER_OF_in_predicate1036 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_rowValueConstructor_in_predicate1038 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
	public static final BitSet FOLLOW_rowValueConstructor_in_predicate1040 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_NOT_MEMBER_OF_in_predicate1049 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_rowValueConstructor_in_predicate1051 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
	public static final BitSet FOLLOW_rowValueConstructor_in_predicate1053 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_IS_EMPTY_in_predicate1063 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_rowValueConstructor_in_predicate1065 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_IS_NOT_EMPTY_in_predicate1074 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_rowValueConstructor_in_predicate1076 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_rowValueConstructor_in_predicate1083 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_BETWEEN_LIST_in_betweenList1096 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_rowValueConstructor_in_betweenList1098 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
	public static final BitSet FOLLOW_rowValueConstructor_in_betweenList1100 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_rowValueConstructor_in_comparativePredicateValue1114 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_valueExpression_in_rowValueConstructor1125 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ESCAPE_in_escapeSpecification1137 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_characterValueExpression_in_escapeSpecification1139 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_IN_LIST_in_inPredicateValue1152 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_valueExpression_in_inPredicateValue1154 = new BitSet(new long[]{0x4D004C5DC0BA64D8L,0xB015EF8850046204L,0x018F07DE020130C1L});
	public static final BitSet FOLLOW_valueExpression_in_numericValueExpression1167 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_valueExpression_in_characterValueExpression1178 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_valueExpression_in_datetimeValueExpression1189 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOUBLE_PIPE_in_valueExpression1202 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_characterValueExpression_in_valueExpression1204 = new BitSet(new long[]{0x4D004C5DC0BA64D8L,0xB015EF8850046204L,0x018F07DE020130C1L});
	public static final BitSet FOLLOW_UNARY_MINUS_in_valueExpression1214 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_numericValueExpression_in_valueExpression1216 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_UNARY_PLUS_in_valueExpression1225 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_numericValueExpression_in_valueExpression1227 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PLUS_in_valueExpression1236 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_valueExpression_in_valueExpression1238 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
	public static final BitSet FOLLOW_valueExpression_in_valueExpression1240 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_MINUS_in_valueExpression1249 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_valueExpression_in_valueExpression1251 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
	public static final BitSet FOLLOW_valueExpression_in_valueExpression1253 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ASTERISK_in_valueExpression1262 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_numericValueExpression_in_valueExpression1264 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
	public static final BitSet FOLLOW_numericValueExpression_in_valueExpression1266 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SOLIDUS_in_valueExpression1275 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_numericValueExpression_in_valueExpression1277 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
	public static final BitSet FOLLOW_numericValueExpression_in_valueExpression1279 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_EXISTS_in_valueExpression1288 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_rowValueConstructor_in_valueExpression1290 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SOME_in_valueExpression1298 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_valueExpression_in_valueExpression1300 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ALL_in_valueExpression1309 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_valueExpression_in_valueExpression1311 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ANY_in_valueExpression1320 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_valueExpression_in_valueExpression1322 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_VECTOR_EXPR_in_valueExpression1331 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_valueExpression_in_valueExpression1333 = new BitSet(new long[]{0x4D004C5DC0BA64D8L,0xB015EF8850046204L,0x018F07DE020130C1L});
	public static final BitSet FOLLOW_valueExpressionPrimary_in_valueExpression1341 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_caseExpression_in_valueExpressionPrimary1352 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_function_in_valueExpressionPrimary1357 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_collectionFunction_in_valueExpressionPrimary1362 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_collectionExpression_in_valueExpressionPrimary1367 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_constant_in_valueExpressionPrimary1372 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_parameter_in_valueExpressionPrimary1377 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_propertyReference_in_valueExpressionPrimary1382 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SUB_QUERY_in_valueExpressionPrimary1388 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_queryStatementSet_in_valueExpressionPrimary1390 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ALIAS_REF_in_valueExpressionPrimary1396 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOT_CLASS_in_valueExpressionPrimary1403 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_path_in_valueExpressionPrimary1405 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_JAVA_CONSTANT_in_valueExpressionPrimary1413 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_path_in_valueExpressionPrimary1415 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PATH_in_valueExpressionPrimary1423 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_propertyReferencePath_in_valueExpressionPrimary1425 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_NULLIF_in_caseExpression1438 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_valueExpression_in_caseExpression1440 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
	public static final BitSet FOLLOW_valueExpression_in_caseExpression1442 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_COALESCE_in_caseExpression1449 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_valueExpression_in_caseExpression1451 = new BitSet(new long[]{0x4D004C5DC0BA64D8L,0xB015EF8850046204L,0x018F07DE020130C1L});
	public static final BitSet FOLLOW_valueExpression_in_caseExpression1453 = new BitSet(new long[]{0x4D004C5DC0BA64D8L,0xB015EF8850046204L,0x018F07DE020130C1L});
	public static final BitSet FOLLOW_SIMPLE_CASE_in_caseExpression1461 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_valueExpression_in_caseExpression1463 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0800000000000000L});
	public static final BitSet FOLLOW_simpleCaseWhenClause_in_caseExpression1465 = new BitSet(new long[]{0x0000800000000008L,0x0000000000000000L,0x0800000000000000L});
	public static final BitSet FOLLOW_elseClause_in_caseExpression1468 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SEARCHED_CASE_in_caseExpression1476 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_searchedWhenClause_in_caseExpression1478 = new BitSet(new long[]{0x0000800000000008L,0x0000000000000000L,0x0800000000000000L});
	public static final BitSet FOLLOW_elseClause_in_caseExpression1481 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_WHEN_in_simpleCaseWhenClause1495 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_valueExpression_in_simpleCaseWhenClause1497 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
	public static final BitSet FOLLOW_valueExpression_in_simpleCaseWhenClause1499 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_WHEN_in_searchedWhenClause1512 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_searchCondition_in_searchedWhenClause1514 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
	public static final BitSet FOLLOW_valueExpression_in_searchedWhenClause1516 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ELSE_in_elseClause1529 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_valueExpression_in_elseClause1531 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_setFunction_in_function1543 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_standardFunction_in_function1548 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SUM_in_setFunction1560 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_numericValueExpression_in_setFunction1562 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_AVG_in_setFunction1569 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_numericValueExpression_in_setFunction1571 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_MAX_in_setFunction1578 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_numericValueExpression_in_setFunction1580 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_MIN_in_setFunction1587 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_numericValueExpression_in_setFunction1589 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_COUNT_in_setFunction1596 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ASTERISK_in_setFunction1599 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_set_in_setFunction1603 = new BitSet(new long[]{0x4000404000000000L,0x0000000000044000L,0x0000000000010000L});
	public static final BitSet FOLLOW_countFunctionArguments_in_setFunction1609 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_functionFunction_in_standardFunction1622 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_castFunction_in_standardFunction1627 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_concatFunction_in_standardFunction1632 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_substringFunction_in_standardFunction1637 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_trimFunction_in_standardFunction1642 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_upperFunction_in_standardFunction1647 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_lowerFunction_in_standardFunction1652 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_lengthFunction_in_standardFunction1657 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_locateFunction_in_standardFunction1662 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_absFunction_in_standardFunction1667 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_sqrtFunction_in_standardFunction1672 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_modFunction_in_standardFunction1677 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_sizeFunction_in_standardFunction1682 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_indexFunction_in_standardFunction1687 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_currentDateFunction_in_standardFunction1692 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_currentTimeFunction_in_standardFunction1697 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_currentTimestampFunction_in_standardFunction1702 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_extractFunction_in_standardFunction1707 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_positionFunction_in_standardFunction1712 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_charLengthFunction_in_standardFunction1717 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_octetLengthFunction_in_standardFunction1722 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bitLengthFunction_in_standardFunction1727 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FUNCTION_in_functionFunction1740 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_valueExpression_in_functionFunction1742 = new BitSet(new long[]{0x4D004C5DC0BA64D8L,0xB015EF8850046204L,0x018F07DE020130C1L});
	public static final BitSet FOLLOW_CAST_in_castFunction1757 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_valueExpression_in_castFunction1759 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_IDENTIFIER_in_castFunction1761 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_CONCAT_in_concatFunction1776 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_valueExpression_in_concatFunction1778 = new BitSet(new long[]{0x4D004C5DC0BA64D8L,0xB015EF8850046204L,0x018F07DE020130C1L});
	public static final BitSet FOLLOW_SUBSTRING_in_substringFunction1792 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_characterValueExpression_in_substringFunction1794 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
	public static final BitSet FOLLOW_numericValueExpression_in_substringFunction1796 = new BitSet(new long[]{0x4D004C5DC0BA64D8L,0xB015EF8850046204L,0x018F07DE020130C1L});
	public static final BitSet FOLLOW_numericValueExpression_in_substringFunction1798 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_TRIM_in_trimFunction1812 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_trimOperands_in_trimFunction1814 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_set_in_trimOperands1827 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_characterValueExpression_in_trimOperands1835 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
	public static final BitSet FOLLOW_characterValueExpression_in_trimOperands1837 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_UPPER_in_upperFunction1850 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_characterValueExpression_in_upperFunction1852 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_LOWER_in_lowerFunction1865 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_characterValueExpression_in_lowerFunction1867 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_LENGTH_in_lengthFunction1880 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_characterValueExpression_in_lengthFunction1882 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_LOCATE_in_locateFunction1895 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_characterValueExpression_in_locateFunction1897 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
	public static final BitSet FOLLOW_characterValueExpression_in_locateFunction1899 = new BitSet(new long[]{0x4D004C5DC0BA64D8L,0xB015EF8850046204L,0x018F07DE020130C1L});
	public static final BitSet FOLLOW_numericValueExpression_in_locateFunction1901 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ABS_in_absFunction1915 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_numericValueExpression_in_absFunction1917 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SQRT_in_sqrtFunction1930 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_numericValueExpression_in_sqrtFunction1932 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_MOD_in_modFunction1945 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_numericValueExpression_in_modFunction1947 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
	public static final BitSet FOLLOW_numericValueExpression_in_modFunction1949 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SIZE_in_sizeFunction1962 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_propertyReference_in_sizeFunction1964 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_INDEX_in_indexFunction1977 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ALIAS_REF_in_indexFunction1979 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_CURRENT_DATE_in_currentDateFunction1991 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CURRENT_TIME_in_currentTimeFunction2002 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CURRENT_TIMESTAMP_in_currentTimestampFunction2013 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EXTRACT_in_extractFunction2025 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_extractField_in_extractFunction2027 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
	public static final BitSet FOLLOW_datetimeValueExpression_in_extractFunction2029 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_datetimeField_in_extractField2041 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_timeZoneField_in_extractField2046 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_POSITION_in_positionFunction2110 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_characterValueExpression_in_positionFunction2112 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
	public static final BitSet FOLLOW_characterValueExpression_in_positionFunction2114 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_CHARACTER_LENGTH_in_charLengthFunction2127 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_characterValueExpression_in_charLengthFunction2129 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_OCTET_LENGTH_in_octetLengthFunction2142 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_characterValueExpression_in_octetLengthFunction2144 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_BIT_LENGTH_in_bitLengthFunction2158 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_characterValueExpression_in_bitLengthFunction2160 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_collectionExpression_in_countFunctionArguments2173 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_propertyReference_in_countFunctionArguments2178 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_numeric_literal_in_countFunctionArguments2183 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_set_in_collectionFunction2195 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_collectionPropertyReference_in_collectionFunction2205 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_propertyReference_in_collectionPropertyReference2220 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ELEMENTS_in_collectionExpression2232 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_propertyReference_in_collectionExpression2234 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_INDICES_in_collectionExpression2242 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_propertyReference_in_collectionExpression2244 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_literal_in_constant2277 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NULL_in_constant2282 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TRUE_in_constant2287 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FALSE_in_constant2292 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_numeric_literal_in_literal2303 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_HEX_LITERAL_in_literal2308 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OCTAL_LITERAL_in_literal2313 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CHARACTER_LITERAL_in_literal2318 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_literal2323 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CONST_STRING_VALUE_in_literal2329 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_literal2331 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ENTITY_NAME_in_entityName2364 = new BitSet(new long[]{0x0000000000000020L});
	public static final BitSet FOLLOW_ALIAS_NAME_in_entityName2366 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PROPERTY_REFERENCE_in_propertyReference2381 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_propertyReferencePath_in_propertyReference2383 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_unqualifiedPropertyReference_in_propertyReferencePath2398 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_pathedPropertyReference_in_propertyReferencePath2403 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_terminalIndexOperation_in_propertyReferencePath2408 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENTIFIER_in_unqualifiedPropertyReference2423 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOT_in_pathedPropertyReference2438 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_pathedPropertyReferenceSource_in_pathedPropertyReference2440 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_IDENTIFIER_in_pathedPropertyReference2442 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_IDENTIFIER_in_pathedPropertyReferenceSource2464 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENTIFIER_in_pathedPropertyReferenceSource2474 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_intermediatePathedPropertyReference_in_pathedPropertyReferenceSource2481 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_intermediateIndexOperation_in_pathedPropertyReferenceSource2488 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOT_in_intermediatePathedPropertyReference2506 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_pathedPropertyReferenceSource_in_intermediatePathedPropertyReference2510 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_IDENTIFIER_in_intermediatePathedPropertyReference2512 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_LEFT_SQUARE_in_intermediateIndexOperation2534 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_indexOperationSource_in_intermediateIndexOperation2536 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
	public static final BitSet FOLLOW_indexSelector_in_intermediateIndexOperation2538 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_LEFT_SQUARE_in_terminalIndexOperation2557 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_indexOperationSource_in_terminalIndexOperation2559 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
	public static final BitSet FOLLOW_indexSelector_in_terminalIndexOperation2561 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_DOT_in_indexOperationSource2583 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_pathedPropertyReferenceSource_in_indexOperationSource2585 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_IDENTIFIER_in_indexOperationSource2587 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_IDENTIFIER_in_indexOperationSource2601 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_valueExpression_in_indexSelector2616 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENTIFIER_in_path2628 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOT_in_path2634 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_path_in_path2636 = new BitSet(new long[]{0x0000020000000000L,0x0000000600000800L});
	public static final BitSet FOLLOW_path_in_path2638 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_LEFT_SQUARE_in_path2646 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_path_in_path2648 = new BitSet(new long[]{0x4D004C5DC0BA64D8L,0xB015EF8850046204L,0x018F07DE020130C1L});
	public static final BitSet FOLLOW_valueExpression_in_path2650 = new BitSet(new long[]{0x4D004C5DC0BA64D8L,0xB015EF8850046204L,0x018F07DE020130C1L});
	public static final BitSet FOLLOW_LEFT_PAREN_in_path2659 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_path_in_path2661 = new BitSet(new long[]{0x4D004C5DC0BA64D8L,0xB015EF8850046204L,0x018F07DE020130C1L});
	public static final BitSet FOLLOW_valueExpression_in_path2663 = new BitSet(new long[]{0x4D004C5DC0BA64D8L,0xB015EF8850046204L,0x018F07DE020130C1L});
}