/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpql.lucene;

import java.util.HashMap;
import junit.framework.Assert;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.TreeNodeStream;
import org.hibernate.jpql.lucene.BaseSearchFactoryImplementor;
import org.hibernate.jpql.lucene.IndexedEntity;
import org.hibernate.jpql.lucene.MapBasedEntityNamesResolver;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.sql.ast.common.ParserContext;
import org.hibernate.sql.ast.origin.hql.parse.HQLLexer;
import org.hibernate.sql.ast.origin.hql.parse.HQLParser;
import org.hibernate.sql.ast.origin.hql.resolve.EntityNamesResolver;
import org.hibernate.sql.ast.origin.hql.resolve.LuceneJPQLWalker;
import org.junit.Test;

public class TreeWalkTest {
    private static boolean USE_STDOUT = true;

    @Test
    public void walkTest1() {
        this.transformationAssert("from IndexedEntity", "*:*");
    }

    @Test
    public void walkTest2() {
        this.transformationAssert("from IndexedEntity e where e.name = 'same' or ( e.id = 4 and e.name = 'booh')", "name:same (+id:4 +name:booh)");
    }

    @Test
    public void walkTest3() {
        this.transformationAssert("select e from IndexedEntity e where e.name = 'same' or ( e.id = 4 and e.name = 'booh')", "name:same (+id:4 +name:booh)");
    }

    @Test
    public void walkTest4() {
        this.transformationAssert("select e from IndexedEntity e where e.name = 'same' and not e.id = 5", "+name:same +(-id:5)");
    }

    @Test
    public void walkTest5() {
    }

    private void transformationAssert(String jpaql, String expectedLuceneQuery) {
        if (USE_STDOUT) {
            System.out.println(jpaql);
        }
        SearchFactoryMock searchFactory = new SearchFactoryMock();
        HashMap<String, Class> entityNames = new HashMap<String, Class>();
        entityNames.put("com.acme.IndexedEntity", IndexedEntity.class);
        entityNames.put("IndexedEntity", IndexedEntity.class);
        LuceneJPQLWalker walker = this.assertTreeParsed(null, jpaql, searchFactory, entityNames);
        Assert.assertTrue((boolean)IndexedEntity.class.equals((Object)walker.getTargetEntity()));
        Assert.assertEquals((String)expectedLuceneQuery, (String)walker.getLuceneQuery().toString());
        if (USE_STDOUT) {
            System.out.println(expectedLuceneQuery);
            System.out.println();
        }
    }

    private LuceneJPQLWalker assertTreeParsed(ParserContext context, String input, SearchFactoryImplementor searchFactory, HashMap<String, Class> entityNames) {
        HQLLexer lexed = new HQLLexer((CharStream)new ANTLRStringStream(input));
        Assert.assertEquals((int)0, (int)lexed.getNumberOfSyntaxErrors());
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexed);
        CommonTree tree = null;
        HQLParser parser = new HQLParser((TokenStream)tokens);
        if (context != null) {
            parser.setParserContext(context);
        }
        try {
            HQLParser.statement_return r = parser.statement();
            Assert.assertEquals((int)0, (int)parser.getNumberOfSyntaxErrors());
            tree = (CommonTree)r.getTree();
        }
        catch (RecognitionException e) {
            Assert.fail((String)e.getMessage());
        }
        if (tree != null) {
            if (USE_STDOUT) {
                System.out.println(tree.toStringTree());
            }
            CommonTreeNodeStream treeStream = new CommonTreeNodeStream((Object)tree);
            treeStream.setTokenStream((TokenStream)tokens);
            MapBasedEntityNamesResolver nameResolver = new MapBasedEntityNamesResolver(entityNames);
            LuceneJPQLWalker walker = new LuceneJPQLWalker((TreeNodeStream)treeStream, searchFactory, (EntityNamesResolver)nameResolver);
            try {
                walker.statement();
                Assert.assertEquals((int)0, (int)walker.getNumberOfSyntaxErrors());
                return walker;
            }
            catch (RecognitionException e) {
                Assert.fail((String)e.getMessage());
            }
        }
        return null;
    }

    private class SearchFactoryMock
    extends BaseSearchFactoryImplementor {
        private SearchFactoryMock() {
        }
    }
}

