/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpql.testhelpers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.antlr.gunit.AbstractTest;
import org.antlr.gunit.GrammarInfo;
import org.antlr.gunit.ITestCase;
import org.antlr.gunit.Interp;
import org.antlr.gunit.gUnitTestInput;
import org.antlr.gunit.gUnitTestSuite;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.RecognitionException;
import org.hibernate.jpql.testhelpers.GUnitTest;
import org.hibernate.jpql.testhelpers.NotifiedTestExecuter;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;

public class GUnitTestRunner
extends Runner {
    static final Integer FORCE_LIMIT = Integer.getInteger("JUnitgUnitLimitNumberTests");
    private final Class<?> testClass;
    private String gunitSource;
    private GrammarInfo testInfo;
    private Description parentTestDescription;
    private Map<ITestCase, Description> testDescriptions = new HashMap<ITestCase, Description>();

    public GUnitTestRunner(Class<?> testClass) throws InitializationError {
        this.testClass = testClass;
        GUnitTest gUnitTestAnnotation = testClass.getAnnotation(GUnitTest.class);
        if (gUnitTestAnnotation == null) {
            throw new IllegalStateException("Tests using the GUnitTestRunner require annotation " + GUnitTest.class);
        }
        this.gunitSource = gUnitTestAnnotation.value();
        this.testInfo = this.loadTestGrammarInfo();
    }

    public Description getDescription() {
        if (this.parentTestDescription == null) {
            int totalTestsDefined = 0;
            String grammarName = this.testInfo.getGrammarName();
            this.parentTestDescription = Description.createSuiteDescription((String)(this.testClass + ":" + grammarName), (Annotation[])new Annotation[0]);
            for (gUnitTestSuite ruleTestSuite : this.testInfo.getRuleTestSuites()) {
                int suiteSubSection = 0;
                Description ruleSuiteDecription = this.defineSection(this.parentTestDescription, ruleTestSuite, suiteSubSection);
                for (Map.Entry<gUnitTestInput, AbstractTest> inputEntry : this.extractTestLines(ruleTestSuite)) {
                    gUnitTestInput input = inputEntry.getKey();
                    AbstractTest test = inputEntry.getValue();
                    String inputName = "Line " + input.line + ": \"" + input.input + "\"";
                    Description testDescription = Description.createTestDescription(this.testClass, (String)inputName);
                    ruleSuiteDecription.addChild(testDescription);
                    this.testDescriptions.put((ITestCase)test, testDescription);
                    if (FORCE_LIMIT == null || FORCE_LIMIT != ++totalTestsDefined) continue;
                    return this.parentTestDescription;
                }
            }
        }
        return this.parentTestDescription;
    }

    private Description defineSection(Description parentTestDescription, gUnitTestSuite ruleTestSuite, int suiteSubSection) {
        Description ruleSuiteDecription = Description.createSuiteDescription((String)(ruleTestSuite.getRuleName() + ":" + suiteSubSection), (Annotation[])new Annotation[0]);
        parentTestDescription.addChild(ruleSuiteDecription);
        return ruleSuiteDecription;
    }

    private Set<Map.Entry<gUnitTestInput, AbstractTest>> extractTestLines(gUnitTestSuite ruleTestSuite) {
        try {
            Field field = gUnitTestSuite.class.getDeclaredField("testSuites");
            field.setAccessible(true);
            Map testSuites = (Map)field.get(ruleTestSuite);
            return testSuites.entrySet();
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    private GrammarInfo loadTestGrammarInfo() throws InitializationError {
        ClassLoader classLoader = this.testClass.getClassLoader();
        InputStream resourceAsStream = classLoader.getResourceAsStream(this.gunitSource);
        if (resourceAsStream == null) {
            throw new InitializationError("Resource could not be opened: " + this.gunitSource);
        }
        try {
            ANTLRInputStream antlrStream = new ANTLRInputStream(resourceAsStream);
            GrammarInfo grammarInfo = Interp.parse((CharStream)antlrStream);
            return grammarInfo;
        }
        catch (IOException e) {
            throw new InitializationError((Throwable)e);
        }
        catch (RecognitionException e) {
            throw new InitializationError((Throwable)e);
        }
        finally {
            try {
                resourceAsStream.close();
            }
            catch (IOException e) {
                throw new InitializationError("Resource could not be closed: " + this.gunitSource);
            }
        }
    }

    public void run(RunNotifier notifier) {
        Description desc = this.getDescription();
        try {
            NotifiedTestExecuter gUnitTests = this.executeGUnitTests();
            this.recursiveTestRunner(desc, notifier, gUnitTests);
        }
        catch (IOException e) {
            notifier.fireTestStarted(desc);
            notifier.fireTestFailure(new Failure(desc, (Throwable)e));
        }
    }

    private NotifiedTestExecuter executeGUnitTests() throws IOException {
        ClassLoader classLoader = this.testClass.getClassLoader();
        URL resource = classLoader.getResource(this.gunitSource);
        NotifiedTestExecuter executor = new NotifiedTestExecuter(this.testInfo, this.testClass.getClassLoader(), new File(resource.getPath()).getAbsolutePath(), this.testDescriptions);
        executor.execTest();
        return executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void recursiveTestRunner(Description desc, RunNotifier notifier, NotifiedTestExecuter gUnitTests) {
        if (desc.getChildren().size() == 0) {
            notifier.fireTestStarted(desc);
            try {
                Failure testResult = gUnitTests.getTestResult(desc);
                if (testResult == null) return;
                notifier.fireTestFailure(testResult);
                return;
            }
            finally {
                notifier.fireTestFinished(desc);
            }
        } else {
            for (Description test : desc.getChildren()) {
                this.recursiveTestRunner(test, notifier, gUnitTests);
            }
        }
    }
}

