/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpql.testhelpers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import junit.framework.AssertionFailedError;
import org.antlr.gunit.BooleanTest;
import org.antlr.gunit.GrammarInfo;
import org.antlr.gunit.ITestCase;
import org.antlr.gunit.OutputTest;
import org.antlr.gunit.ReturnTest;
import org.antlr.gunit.gUnitExecutor;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.jpql.testhelpers.GUnitTestRunner;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;

public class NotifiedTestExecuter
extends gUnitExecutor {
    private final Map<ITestCase, Description> testDescriptions;
    private final Map<Description, Failure> testFailures = new HashMap<Description, Failure>();
    private final Set<Description> testSuccesses = new HashSet<Description>();

    public NotifiedTestExecuter(GrammarInfo grammarInfo, ClassLoader grammarClassLoader, String testsuiteDir, Map<ITestCase, Description> testDescriptions) {
        super(grammarInfo, grammarClassLoader, testsuiteDir);
        this.testDescriptions = testDescriptions;
    }

    public Failure getTestResult(Description testDescription) {
        if (this.testSuccesses.contains(testDescription)) {
            if (this.testFailures.containsKey(testDescription)) {
                throw new IllegalStateException("Test descriptor found registered both as failing and succeeding");
            }
            return null;
        }
        Failure failure = this.testFailures.get(testDescription);
        if (failure == null) {
            throw new IllegalStateException("Test Description not found for either failed or ok");
        }
        return failure;
    }

    public void onPass(ITestCase passTest) {
        Description testDescription = this.getTestDescription(passTest);
        boolean added = this.testSuccesses.add(testDescription);
        if (!added) {
            throw new IllegalStateException("Test passed but was already executed. Duplicate description?");
        }
    }

    private Description getTestDescription(ITestCase test) {
        Description description = this.testDescriptions.get(test);
        if (description == null && GUnitTestRunner.FORCE_LIMIT == null) {
            throw new IllegalStateException("Executing a test whose Description was not defined");
        }
        return description;
    }

    public void onFail(ITestCase failingTest) {
        Description description = this.getTestDescription(failingTest);
        Throwable error = null;
        if (failingTest instanceof BooleanTest) {
            error = this.failed((BooleanTest)failingTest, description);
        } else if (failingTest instanceof OutputTest) {
            error = this.failed((OutputTest)failingTest);
        } else if (failingTest instanceof ReturnTest) {
            error = this.failed((ReturnTest)failingTest);
        }
        if (error == null) {
            throw new AssertionFailedError("");
        }
        Failure f = new Failure(description, error);
        Failure existing = this.testFailures.put(description, f);
        if (existing != null) {
            throw new IllegalStateException("Test failed but was already executed. Duplicate description?");
        }
    }

    private Throwable format(String header, String expectedResult, String actualResult) {
        return new AntlrAssertionFailure("\n\t" + header + "\n\tExpected: '" + expectedResult + "'\n\tGot:      '" + actualResult + "'");
    }

    private Throwable failed(ReturnTest failingTest) {
        return this.format(failingTest.getHeader(), failingTest.getExpectedResult(), failingTest.getActualResult());
    }

    private Throwable failed(OutputTest failingTest) {
        return this.format(failingTest.getHeader(), failingTest.getExpectedResult(), failingTest.getActualResult());
    }

    private Throwable failed(BooleanTest failingTest, Description description) {
        return this.format(failingTest.getHeader(), failingTest.getExpectedResult(), failingTest.getActualResult());
    }

    protected void handleUnexpectedException(Exception e) {
        throw new AssertionFailure("Unexpected GUnit error", (Throwable)e);
    }

    private static class AntlrAssertionFailure
    extends Exception {
        public AntlrAssertionFailure(String message) {
            super(message);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

