/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpql.tree;

import junit.framework.Assert;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.hibernate.jpql.lucene.TestingParserContext;
import org.hibernate.sql.ast.common.ParserContext;
import org.hibernate.sql.ast.origin.hql.parse.HQLLexer;
import org.hibernate.sql.ast.origin.hql.parse.HQLParser;
import org.junit.Test;

public class ParsingTest {
    @Test
    public void testFromAnimal() {
        TestingParserContext context = new TestingParserContext("Animal");
        this.assertTreeParsed(context, "from Animal", "(QUERY (QUERY_SPEC (SELECT_FROM (from (PERSISTER_SPACE (ENTITY_PERSISTER_REF Animal <gen:0>))) (SELECT (SELECT_LIST (SELECT_ITEM <gen:0>))))))");
    }

    @Test
    public void testSuperSimpleQuery() {
        TestingParserContext context = new TestingParserContext("EntityName");
        this.assertTreeParsed(context, "from EntityName", "(QUERY (QUERY_SPEC (SELECT_FROM (from (PERSISTER_SPACE (ENTITY_PERSISTER_REF EntityName <gen:0>))) (SELECT (SELECT_LIST (SELECT_ITEM <gen:0>))))))");
    }

    @Test
    public void testSimpleQuery() {
        TestingParserContext context = new TestingParserContext("com.acme.EntityName");
        this.assertTreeParsed(context, "select e from com.acme.EntityName e", "(QUERY (QUERY_SPEC (SELECT_FROM (from (PERSISTER_SPACE (ENTITY_PERSISTER_REF com.acme.EntityName e))) (select (SELECT_LIST (SELECT_ITEM (PATH e)))))))");
    }

    @Test
    public void testSimpleFromQuery() {
        TestingParserContext context = new TestingParserContext("com.acme.EntityName");
        this.assertTreeParsed(context, "from com.acme.EntityName e", "(QUERY (QUERY_SPEC (SELECT_FROM (from (PERSISTER_SPACE (ENTITY_PERSISTER_REF com.acme.EntityName e))) (SELECT (SELECT_LIST (SELECT_ITEM e))))))");
    }

    @Test
    public void testSimpleQueryDefaultContext() {
        this.assertTreeParsed(null, "from com.acme.EntityName e", "(QUERY (QUERY_SPEC (SELECT_FROM (from (PERSISTER_SPACE (ENTITY_PERSISTER_REF com.acme.EntityName e))) (SELECT (SELECT_LIST (SELECT_ITEM e))))))");
    }

    @Test
    public void testOneCriteriaQuery() {
        this.assertTreeParsed(null, "from com.acme.EntityName e where e.name = 'same'", "(QUERY (QUERY_SPEC (SELECT_FROM (from (PERSISTER_SPACE (ENTITY_PERSISTER_REF com.acme.EntityName e))) (SELECT (SELECT_LIST (SELECT_ITEM e)))) (where (= (PATH (. e name)) (CONST_STRING_VALUE same)))))");
    }

    private void assertTreeParsed(ParserContext context, String input, String treeExpectation) {
        HQLLexer lexed = new HQLLexer((CharStream)new ANTLRStringStream(input));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexed);
        HQLParser parser = new HQLParser((TokenStream)tokens);
        if (context != null) {
            parser.setParserContext(context);
        }
        try {
            HQLParser.statement_return r = parser.statement();
            Assert.assertEquals((String)treeExpectation, (String)((CommonTree)r.getTree()).toStringTree());
        }
        catch (RecognitionException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

