/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpql.testing.internal.junit;

import java.util.Collection;
import java.util.List;
import org.hibernate.jpql.testing.internal.junit.GrammarRuleStatements;
import org.hibernate.jpql.testing.internal.junit.GrammarRuleTest;
import org.hibernate.jpql.testing.internal.model.GrammarRuleTestDescriptor;
import org.hibernate.jpql.testing.internal.model.GrammarRuleTestGroupDescriptor;
import org.hibernate.jpql.testing.internal.model.GrammarTestDescriptor;
import org.hibernate.jpql.testing.internal.model.ParsingResult;
import org.hibernate.jpql.testing.internal.parser.GrammarRuleTestRunner;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.internal.runners.model.ReflectiveCallable;
import org.junit.internal.runners.statements.Fail;
import org.junit.rules.RunRules;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

class GrammarRuleStatement
extends Statement
implements GrammarRuleTest {
    private final TestClass testClass;
    private final GrammarRuleTestDescriptor grammarRuleTest;
    private final Description description;
    private final GrammarRuleTestRunner grammarRuleTestRunner;

    public GrammarRuleStatement(TestClass testClass, GrammarTestDescriptor grammarTest, GrammarRuleTestGroupDescriptor grammarRuleTestGroup, GrammarRuleTestDescriptor grammarRuleTest) {
        this.testClass = testClass;
        this.grammarRuleTest = grammarRuleTest;
        this.description = this.createDescription(testClass, grammarRuleTest);
        this.grammarRuleTestRunner = new GrammarRuleTestRunner(grammarTest, grammarRuleTestGroup, grammarRuleTest);
    }

    private Description createDescription(TestClass testClass, GrammarRuleTestDescriptor test) {
        String name = null;
        name = test.getExpectedAst() != null ? "line " + test.getLineNumber() + ": " + this.withoutLineBreaks(test.getExpression()) + " -> " + test.getExpectedAst() : "line " + test.getLineNumber() + ": " + this.withoutLineBreaks(test.getExpression()) + " - " + (Object)((Object)test.getExpectedParsingResultStatus());
        return Description.createTestDescription((Class)testClass.getJavaClass(), (String)name);
    }

    @Override
    public Description getDescription() {
        return this.description;
    }

    public void evaluate() throws Throwable {
        ParsingResult parsingResult = this.grammarRuleTestRunner.run();
        if (this.grammarRuleTest.getExpectedParsingResultStatus() == ParsingResult.Status.OK) {
            Assert.assertEquals((String)("Unexpected parsing result (parser output: " + parsingResult.getDescription() + ")"), (Object)((Object)ParsingResult.Status.OK), (Object)((Object)parsingResult.getStatus()));
        } else {
            Assert.assertEquals((String)"Unexpected parsing result,", (Object)((Object)ParsingResult.Status.FAIL), (Object)((Object)parsingResult.getStatus()));
        }
        if (this.grammarRuleTest.getExpectedAst() != null) {
            Assert.assertEquals((String)"Unexpected AST: ", (Object)this.grammarRuleTest.getExpectedAst(), (Object)parsingResult.getAst());
        }
    }

    @Override
    public void run(GrammarRuleStatements parent, RunNotifier notifier) {
        parent.runLeafNode(this.getMethodBlock(this.testClass), this.getDescription(), notifier);
    }

    public Statement getMethodBlock(final TestClass testClass) {
        Object testInstance;
        try {
            testInstance = new ReflectiveCallable(){

                protected Object runReflectiveCall() throws Throwable {
                    return testClass.getOnlyConstructor().newInstance(new Object[0]);
                }
            }.run();
        }
        catch (Throwable e) {
            return new Fail(e);
        }
        List testRules = testClass.getAnnotatedFieldValues(testInstance, Rule.class, TestRule.class);
        return this.withTestRules(testRules);
    }

    private Statement withTestRules(Collection<TestRule> testRules) {
        return testRules.isEmpty() ? this : new RunRules((Statement)this, testRules, this.getDescription());
    }

    private String withoutLineBreaks(String string) {
        String withoutLineBreaks = string.replaceAll("\\s+", " ");
        if (!string.endsWith(" ") && withoutLineBreaks.endsWith(" ")) {
            withoutLineBreaks = withoutLineBreaks.substring(0, withoutLineBreaks.length() - 1);
        }
        return withoutLineBreaks;
    }
}

