/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpql.testing.internal.model;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.jpql.testing.internal.model.GrammarRuleTestDescriptor;
import org.hibernate.jpql.testing.internal.model.ParsingResult;
import org.hibernate.jpql.testing.internal.model.RuleType;

public class GrammarRuleTestGroupDescriptor {
    private final String name;
    private final RuleType ruleType;
    private final List<GrammarRuleTestDescriptor> tests;
    private final List<GrammarRuleTestGroupDescriptor> subGroups;

    private GrammarRuleTestGroupDescriptor(String name, RuleType ruleType, List<GrammarRuleTestDescriptor> tests, List<GrammarRuleTestGroupDescriptor> subGroups) {
        this.name = name;
        this.ruleType = ruleType;
        this.tests = tests;
        this.subGroups = subGroups;
    }

    public String getName() {
        return this.name;
    }

    public List<GrammarRuleTestDescriptor> getTests() {
        return this.tests;
    }

    public List<GrammarRuleTestGroupDescriptor> getSubGroups() {
        return this.subGroups;
    }

    public RuleType getRuleType() {
        return this.ruleType;
    }

    public static class Builder {
        private String name;
        private final boolean isSubGroup;
        private RuleType ruleType;
        private final List<Builder> subGroupBuilders;
        private final List<GrammarRuleTestDescriptor> tests;
        private Builder currentSubGroup;

        public Builder() {
            this(false);
        }

        private Builder(boolean isSubGroup) {
            this.isSubGroup = isSubGroup;
            this.subGroupBuilders = new ArrayList<Builder>();
            this.tests = new ArrayList<GrammarRuleTestDescriptor>();
        }

        public void addTest(int lineNumber, String expression, ParsingResult.Status expectedTestStatus) {
            if (this.currentSubGroup != null) {
                this.currentSubGroup.addTest(lineNumber, expression, expectedTestStatus);
            } else {
                this.tests.add(new GrammarRuleTestDescriptor(lineNumber, expression, expectedTestStatus));
            }
        }

        public void addAstTest(int lineNumber, String expression, String expectedAst) {
            if (this.currentSubGroup != null) {
                this.currentSubGroup.addAstTest(lineNumber, expression, expectedAst);
            } else {
                this.tests.add(new GrammarRuleTestDescriptor(lineNumber, expression, expectedAst));
            }
        }

        public void setName(String name) {
            this.name = name;
            if (!this.isSubGroup) {
                this.ruleType = this.startsLowerCase(name) ? RuleType.PARSER : RuleType.LEXER;
            }
        }

        public void setRuleType(RuleType ruleType) {
            this.ruleType = ruleType;
        }

        public void addSubGroup() {
            this.currentSubGroup = new Builder(true);
            this.subGroupBuilders.add(this.currentSubGroup);
        }

        public void setSubGroupName(String name) {
            this.currentSubGroup.setName(name);
        }

        public GrammarRuleTestGroupDescriptor build() {
            return new GrammarRuleTestGroupDescriptor(this.name, this.ruleType, this.tests, this.buildSubGroups());
        }

        private List<GrammarRuleTestGroupDescriptor> buildSubGroups() {
            ArrayList<GrammarRuleTestGroupDescriptor> subGroups = new ArrayList<GrammarRuleTestGroupDescriptor>();
            for (Builder builder : this.subGroupBuilders) {
                builder.setRuleType(this.ruleType);
                subGroups.add(builder.build());
            }
            return subGroups;
        }

        private boolean startsLowerCase(String string) {
            return string.startsWith(string.substring(0, 1).toLowerCase());
        }
    }
}

