/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpql.testing.internal.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.antlr.runtime.Lexer;
import org.antlr.runtime.Parser;
import org.hibernate.jpql.testing.internal.model.GrammarRuleTestGroupDescriptor;

public class GrammarTestDescriptor {
    private final String name;
    private final String packageName;
    private final List<GrammarRuleTestGroupDescriptor> testGroups;

    private GrammarTestDescriptor(String name, String packageName, List<GrammarRuleTestGroupDescriptor> testGroups) {
        this.name = name;
        this.packageName = packageName;
        this.testGroups = Collections.unmodifiableList(testGroups);
    }

    public String getName() {
        return this.name;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public List<GrammarRuleTestGroupDescriptor> getTestGroups() {
        return this.testGroups;
    }

    public Class<? extends Lexer> getLexerClass() {
        return this.loadClass(this.packageName + "." + this.name + "Lexer");
    }

    public Class<? extends Parser> getParserClass() {
        return this.loadClass(this.packageName + "." + this.name + "Parser");
    }

    private Class<?> loadClass(String fqn) {
        try {
            return GrammarTestDescriptor.class.getClassLoader().loadClass(fqn);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Builder {
        private String name;
        private String packageName;
        private final List<GrammarRuleTestGroupDescriptor.Builder> testGroupBuilders = new ArrayList<GrammarRuleTestGroupDescriptor.Builder>();

        public void setName(String name) {
            this.name = name;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public GrammarRuleTestGroupDescriptor.Builder addTestGroup() {
            GrammarRuleTestGroupDescriptor.Builder testGroup = new GrammarRuleTestGroupDescriptor.Builder();
            this.testGroupBuilders.add(testGroup);
            return testGroup;
        }

        public GrammarTestDescriptor build() {
            ArrayList<GrammarRuleTestGroupDescriptor> testGroups = new ArrayList<GrammarRuleTestGroupDescriptor>(this.testGroupBuilders.size());
            for (GrammarRuleTestGroupDescriptor.Builder builder : this.testGroupBuilders) {
                testGroups.add(builder.build());
            }
            return new GrammarTestDescriptor(this.name, this.packageName, testGroups);
        }
    }
}

