/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpql.testing.internal.parser;

import org.hibernate.jpql.testing.internal.GrammarTestBaseListener;
import org.hibernate.jpql.testing.internal.GrammarTestParser;
import org.hibernate.jpql.testing.internal.model.GrammarRuleTestGroupDescriptor;
import org.hibernate.jpql.testing.internal.model.GrammarTestDescriptor;
import org.hibernate.jpql.testing.internal.model.ParsingResult;

public class GrammarTestDescriptorBuildingListener
extends GrammarTestBaseListener {
    private final GrammarTestDescriptor.Builder testBuilder = new GrammarTestDescriptor.Builder();
    private GrammarRuleTestGroupDescriptor.Builder testGroupBuilder;

    @Override
    public void exitGrammarTest(GrammarTestParser.GrammarTestContext ctx) {
        this.testBuilder.setName(ctx.ID().getText());
    }

    @Override
    public void exitPakkage(GrammarTestParser.PakkageContext ctx) {
        this.testBuilder.setPackageName(ctx.PACKAGE_ID().getText());
    }

    @Override
    public void enterTestGroup(GrammarTestParser.TestGroupContext ctx) {
        this.testGroupBuilder = this.testBuilder.addTestGroup();
    }

    @Override
    public void exitTestGroup(GrammarTestParser.TestGroupContext ctx) {
        this.testGroupBuilder.setName(ctx.ID().getText());
    }

    @Override
    public void exitTestResult(GrammarTestParser.TestResultContext ctx) {
        String statement = ((GrammarTestParser.TestContext)ctx.getParent()).statement().getText();
        this.testGroupBuilder.addTest(ctx.getParent().getStart().getLine(), this.withoutLiteralDelimiters(statement), ParsingResult.Status.valueOf(ctx.getText()));
    }

    @Override
    public void exitExpectedAst(GrammarTestParser.ExpectedAstContext ctx) {
        String statement = ((GrammarTestParser.TestContext)ctx.getParent()).statement().getText();
        this.testGroupBuilder.addAstTest(ctx.getStart().getLine(), this.withoutLiteralDelimiters(statement), ctx.AST().getText());
    }

    @Override
    public void enterTestSubGroup(GrammarTestParser.TestSubGroupContext ctx) {
        this.testGroupBuilder.addSubGroup();
    }

    @Override
    public void exitTestSubGroup(GrammarTestParser.TestSubGroupContext ctx) {
        this.testGroupBuilder.setSubGroupName(ctx.TEST_GROUP_NAME().getText());
    }

    public GrammarTestDescriptor getGrammarTest() {
        return this.testBuilder.build();
    }

    private String withoutLiteralDelimiters(String statement) {
        if (statement.startsWith("\"")) {
            return statement.substring(1, statement.length() - 1);
        }
        return statement.substring(2, statement.length() - 2);
    }
}

