/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpql.testing.internal.parser;

import java.io.IOException;
import java.io.InputStream;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.Nullable;
import org.hibernate.jpql.testing.internal.GrammarTestLexer;
import org.hibernate.jpql.testing.internal.model.GrammarTestDescriptor;
import org.hibernate.jpql.testing.internal.parser.GrammarTestDescriptorBuildingListener;

public class GrammarTestParser {
    public GrammarTestDescriptor getGrammarTest(Class<?> clazz, String grammarFileName) {
        InputStream inputStream = null;
        try {
            inputStream = clazz.getResourceAsStream(grammarFileName);
            if (inputStream == null) {
                throw new IllegalArgumentException("The grammar test file " + grammarFileName + " couldn't be found.");
            }
            GrammarTestLexer lexer = new GrammarTestLexer((CharStream)new ANTLRInputStream(inputStream));
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            org.hibernate.jpql.testing.internal.GrammarTestParser parser = new org.hibernate.jpql.testing.internal.GrammarTestParser((TokenStream)tokens);
            parser.setBuildParseTree(true);
            GrammarTestDescriptorBuildingListener buildingListener = new GrammarTestDescriptorBuildingListener();
            parser.addParseListener(buildingListener);
            SimpleErrorListener errorListener = new SimpleErrorListener();
            parser.addErrorListener((ANTLRErrorListener)errorListener);
            parser.grammarTest();
            if (errorListener.isSyntaxErrorOccured()) {
                throw new IllegalArgumentException("The grammar test file " + grammarFileName + " contains syntax errors. See System.err.");
            }
            GrammarTestDescriptor grammarTestDescriptor = buildingListener.getGrammarTest();
            return grammarTestDescriptor;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static class SimpleErrorListener
    extends BaseErrorListener {
        private boolean syntaxErrorOccured = false;

        private SimpleErrorListener() {
        }

        public void syntaxError(Recognizer<?, ?> recognizer, @Nullable Object offendingSymbol, int line, int charPositionInLine, String msg, @Nullable RecognitionException e) {
            this.syntaxErrorOccured = true;
        }

        public boolean isSyntaxErrorOccured() {
            return this.syntaxErrorOccured;
        }
    }
}

