/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.ignite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.ignite.IgniteAtomicSequence;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.dialect.lock.OptimisticForceIncrementLockingStrategy;
import org.hibernate.dialect.lock.OptimisticLockingStrategy;
import org.hibernate.dialect.lock.PessimisticForceIncrementLockingStrategy;
import org.hibernate.loader.custom.Return;
import org.hibernate.loader.custom.ScalarReturn;
import org.hibernate.ogm.datastore.ignite.IgnitePessimisticReadLockingStrategy;
import org.hibernate.ogm.datastore.ignite.impl.IgniteAssociationRowSnapshot;
import org.hibernate.ogm.datastore.ignite.impl.IgniteAssociationSnapshot;
import org.hibernate.ogm.datastore.ignite.impl.IgniteDatastoreProvider;
import org.hibernate.ogm.datastore.ignite.impl.IgniteEmbeddedAssociationSnapshot;
import org.hibernate.ogm.datastore.ignite.impl.IgniteTupleSnapshot;
import org.hibernate.ogm.datastore.ignite.logging.impl.Log;
import org.hibernate.ogm.datastore.ignite.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.ignite.options.impl.CollocatedAssociationOption;
import org.hibernate.ogm.datastore.ignite.query.impl.IgniteParameterMetadataBuilder;
import org.hibernate.ogm.datastore.ignite.query.impl.IgniteQueryDescriptor;
import org.hibernate.ogm.datastore.ignite.query.impl.IgniteSqlQueryParser;
import org.hibernate.ogm.datastore.ignite.query.impl.QueryHints;
import org.hibernate.ogm.datastore.ignite.type.impl.IgniteGridTypeMapper;
import org.hibernate.ogm.datastore.ignite.util.StringHelper;
import org.hibernate.ogm.datastore.map.impl.MapTupleSnapshot;
import org.hibernate.ogm.dialect.multiget.spi.MultigetGridDialect;
import org.hibernate.ogm.dialect.query.spi.BackendQuery;
import org.hibernate.ogm.dialect.query.spi.ClosableIterator;
import org.hibernate.ogm.dialect.query.spi.ParameterMetadataBuilder;
import org.hibernate.ogm.dialect.query.spi.QueryParameters;
import org.hibernate.ogm.dialect.query.spi.QueryableGridDialect;
import org.hibernate.ogm.dialect.query.spi.RowSelection;
import org.hibernate.ogm.dialect.query.spi.TypedGridValue;
import org.hibernate.ogm.dialect.spi.AssociationContext;
import org.hibernate.ogm.dialect.spi.AssociationTypeContext;
import org.hibernate.ogm.dialect.spi.BaseGridDialect;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.ogm.dialect.spi.ModelConsumer;
import org.hibernate.ogm.dialect.spi.NextValueRequest;
import org.hibernate.ogm.dialect.spi.OperationContext;
import org.hibernate.ogm.dialect.spi.TupleAlreadyExistsException;
import org.hibernate.ogm.dialect.spi.TupleContext;
import org.hibernate.ogm.dialect.spi.TupleTypeContext;
import org.hibernate.ogm.entityentry.impl.TuplePointer;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.AssociationKind;
import org.hibernate.ogm.model.key.spi.AssociationType;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.RowKey;
import org.hibernate.ogm.model.spi.Association;
import org.hibernate.ogm.model.spi.AssociationOperation;
import org.hibernate.ogm.model.spi.AssociationOperationType;
import org.hibernate.ogm.model.spi.AssociationSnapshot;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.model.spi.TupleSnapshot;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.ogm.util.impl.Contracts;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.type.Type;

public class IgniteDialect
extends BaseGridDialect
implements GridDialect,
MultigetGridDialect,
QueryableGridDialect<IgniteQueryDescriptor> {
    private static final Log log = LoggerFactory.getLogger();
    private IgniteDatastoreProvider provider;

    public IgniteDialect(IgniteDatastoreProvider provider) {
        this.provider = provider;
    }

    public LockingStrategy getLockingStrategy(Lockable lockable, LockMode lockMode) {
        if (lockMode == LockMode.PESSIMISTIC_FORCE_INCREMENT) {
            return new PessimisticForceIncrementLockingStrategy(lockable, lockMode);
        }
        if (lockMode == LockMode.PESSIMISTIC_READ) {
            return new IgnitePessimisticReadLockingStrategy(lockable, lockMode, this.provider);
        }
        if (lockMode == LockMode.OPTIMISTIC) {
            return new OptimisticLockingStrategy(lockable, lockMode);
        }
        if (lockMode == LockMode.OPTIMISTIC_FORCE_INCREMENT) {
            return new OptimisticForceIncrementLockingStrategy(lockable, lockMode);
        }
        return null;
    }

    public Tuple getTuple(EntityKey key, OperationContext operationContext) {
        Object id;
        IgniteCache entityCache = this.provider.getEntityCache(key.getMetadata());
        BinaryObject bo = (BinaryObject)entityCache.get(id = this.provider.createKeyObject(key));
        if (bo != null) {
            return new Tuple((TupleSnapshot)new IgniteTupleSnapshot(id, bo, key.getMetadata()), Tuple.SnapshotType.UPDATE);
        }
        return null;
    }

    public List<Tuple> getTuples(EntityKey[] keys, TupleContext tupleContext) {
        ArrayList<Tuple> result = new ArrayList<Tuple>(keys.length);
        IgniteCache entityCache = this.provider.getEntityCache(keys[0].getMetadata());
        HashMap<EntityKey, Object> ids = new HashMap<EntityKey, Object>(keys.length);
        for (EntityKey key : keys) {
            ids.put(key, this.provider.createKeyObject(key));
        }
        Map objects = entityCache.getAll(new HashSet(ids.values()));
        for (EntityKey key : keys) {
            Object id = ids.get(key);
            BinaryObject bo = (BinaryObject)objects.get(id);
            result.add(bo != null ? new Tuple((TupleSnapshot)new IgniteTupleSnapshot(id, bo, key.getMetadata()), Tuple.SnapshotType.UPDATE) : null);
        }
        return result;
    }

    public Tuple createTuple(EntityKey key, OperationContext operationContext) {
        IgniteCache entityCache = this.provider.getEntityCache(key.getMetadata());
        if (entityCache == null) {
            throw log.cacheNotFound(key.getMetadata().getTable());
        }
        Object id = this.provider.createKeyObject(key);
        return new Tuple((TupleSnapshot)new IgniteTupleSnapshot(id, null, key.getMetadata()), Tuple.SnapshotType.INSERT);
    }

    public void insertOrUpdateTuple(EntityKey key, TuplePointer tuplePointer, TupleContext tupleContext) throws TupleAlreadyExistsException {
        IgniteCache entityCache = this.provider.getEntityCache(key.getMetadata());
        Tuple tuple = tuplePointer.getTuple();
        Object keyObject = null;
        BinaryObjectBuilder builder = null;
        IgniteTupleSnapshot tupleSnapshot = (IgniteTupleSnapshot)tuple.getSnapshot();
        keyObject = tupleSnapshot.getCacheKey();
        builder = tuple.getSnapshotType() == Tuple.SnapshotType.UPDATE ? this.provider.createBinaryObjectBuilder(tupleSnapshot.getCacheValue()) : this.provider.createBinaryObjectBuilder(this.provider.getEntityTypeName(key.getMetadata().getTable()));
        for (String columnName : tuple.getColumnNames()) {
            Object value = tuple.get(columnName);
            if (value != null) {
                builder.setField(StringHelper.realColumnName(columnName), value);
                continue;
            }
            builder.removeField(StringHelper.realColumnName(columnName));
        }
        BinaryObject valueObject = builder.build();
        entityCache.put(keyObject, (Object)valueObject);
        tuplePointer.setTuple(new Tuple((TupleSnapshot)new IgniteTupleSnapshot(keyObject, valueObject, key.getMetadata()), Tuple.SnapshotType.UPDATE));
    }

    public void removeTuple(EntityKey key, TupleContext tupleContext) {
        IgniteCache entityCache = this.provider.getEntityCache(key.getMetadata());
        entityCache.remove(this.provider.createKeyObject(key));
    }

    public Association getAssociation(AssociationKey key, AssociationContext associationContext) {
        Association result = null;
        IgniteCache<Object, BinaryObject> associationCache = this.provider.getAssociationCache(key.getMetadata());
        if (associationCache == null) {
            throw log.cacheNotFound(key.getMetadata().getTable());
        }
        if (key.getMetadata().getAssociationKind() == AssociationKind.ASSOCIATION) {
            QueryHints.Builder hintsBuilder = new QueryHints.Builder();
            Boolean isCollocated = (Boolean)associationContext.getAssociationTypeContext().getOptionsContext().getUnique(CollocatedAssociationOption.class);
            if (isCollocated.booleanValue()) {
                hintsBuilder.setAffinityRun(true);
                hintsBuilder.setAffinityKey(this.provider.createParentKeyObject(key));
            }
            QueryHints hints = hintsBuilder.build();
            SqlFieldsQuery sqlQuery = this.provider.createSqlFieldsQueryWithLog(this.createAssociationQuery(key, true), hints, key.getColumnValues());
            Iterable<List<?>> list = this.executeWithHints(associationCache, sqlQuery, hints);
            Iterator<List<?>> iterator = list.iterator();
            if (iterator.hasNext()) {
                HashMap<Object, BinaryObject> associationMap = new HashMap<Object, BinaryObject>();
                while (iterator.hasNext()) {
                    List<?> item = iterator.next();
                    Object id = item.get(0);
                    BinaryObject bo = (BinaryObject)item.get(1);
                    associationMap.put(id, bo);
                }
                result = new Association((AssociationSnapshot)new IgniteAssociationSnapshot(key, associationMap));
            }
        } else if (key.getMetadata().getAssociationKind() == AssociationKind.EMBEDDED_COLLECTION) {
            result = new Association((AssociationSnapshot)new IgniteEmbeddedAssociationSnapshot(key, associationContext.getEntityTuplePointer().getTuple()));
        } else {
            throw new UnsupportedOperationException("Unknown association kind " + key.getMetadata().getAssociationKind());
        }
        return result;
    }

    private String createAssociationQuery(AssociationKey key, boolean selectObjects) {
        StringBuilder sb = new StringBuilder();
        if (selectObjects) {
            sb.append("SELECT _KEY, _VAL FROM ");
        } else {
            sb.append("SELECT _KEY FROM ");
        }
        sb.append(key.getMetadata().getTable()).append(" WHERE ");
        boolean first = true;
        for (String columnName : key.getColumnNames()) {
            if (!first) {
                sb.append(" AND ");
            } else {
                first = false;
            }
            sb.append(StringHelper.realColumnName(columnName)).append("=?");
        }
        return sb.toString();
    }

    public Association createAssociation(AssociationKey key, AssociationContext associationContext) {
        if (key.getMetadata().getAssociationKind() == AssociationKind.ASSOCIATION) {
            return new Association((AssociationSnapshot)new IgniteAssociationSnapshot(key));
        }
        if (key.getMetadata().getAssociationKind() == AssociationKind.EMBEDDED_COLLECTION) {
            return new Association((AssociationSnapshot)new IgniteEmbeddedAssociationSnapshot(key, associationContext.getEntityTuplePointer().getTuple()));
        }
        throw new UnsupportedOperationException("Unknown association kind " + key.getMetadata().getAssociationKind());
    }

    public void insertOrUpdateAssociation(AssociationKey key, Association association, AssociationContext associationContext) {
        if (key.getMetadata().isInverse()) {
            return;
        }
        IgniteCache<Object, BinaryObject> associationCache = this.provider.getAssociationCache(key.getMetadata());
        if (key.getMetadata().getAssociationKind() == AssociationKind.ASSOCIATION) {
            HashMap<Object, BinaryObject> changedObjects = new HashMap<Object, BinaryObject>();
            HashSet<Object> removedObjects = new HashSet<Object>();
            boolean thirdTableAssociation = IgniteAssociationSnapshot.isThirdTableAssociation(key.getMetadata());
            for (AssociationOperation op : association.getOperations()) {
                Object previousId;
                AssociationSnapshot snapshot = association.getSnapshot();
                Tuple previousStateTuple = snapshot.get(op.getKey());
                Tuple currentStateTuple = op.getValue();
                Object object = previousId = previousStateTuple != null ? ((IgniteAssociationRowSnapshot)previousStateTuple.getSnapshot()).getCacheKey() : null;
                if (op.getType() == AssociationOperationType.CLEAR || op.getType() == AssociationOperationType.REMOVE && !thirdTableAssociation) {
                    BinaryObject clearBo = (BinaryObject)associationCache.get(previousId);
                    if (clearBo == null) continue;
                    BinaryObjectBuilder clearBoBuilder = this.provider.createBinaryObjectBuilder(clearBo);
                    for (String columnName : key.getColumnNames()) {
                        clearBoBuilder.removeField(columnName);
                    }
                    for (String columnName : key.getMetadata().getRowKeyIndexColumnNames()) {
                        clearBoBuilder.removeField(columnName);
                    }
                    changedObjects.put(previousId, clearBoBuilder.build());
                    continue;
                }
                if (op.getType() == AssociationOperationType.PUT) {
                    Object currentId = null;
                    currentId = currentStateTuple.getSnapshot().isEmpty() ? this.provider.createAssociationKeyObject(op.getKey(), key.getMetadata()) : ((IgniteAssociationRowSnapshot)currentStateTuple.getSnapshot()).getCacheKey();
                    BinaryObject putBo = previousId != null ? (BinaryObject)associationCache.get(previousId) : null;
                    BinaryObjectBuilder putBoBuilder = null;
                    if (putBo != null) {
                        boolean hasChanges = false;
                        for (String columnName : currentStateTuple.getColumnNames()) {
                            if (key.getMetadata().getAssociatedEntityKeyMetadata().getEntityKeyMetadata().isKeyColumn(columnName) || !(hasChanges = Objects.equals(currentStateTuple.get(columnName), putBo.field(columnName)))) continue;
                            break;
                        }
                        if (!hasChanges) continue;
                        putBoBuilder = this.provider.createBinaryObjectBuilder(putBo);
                    } else {
                        putBoBuilder = this.provider.createBinaryObjectBuilder(this.provider.getEntityTypeName(key.getMetadata().getTable()));
                    }
                    for (String columnName : currentStateTuple.getColumnNames()) {
                        if (key.getMetadata().getAssociatedEntityKeyMetadata().getEntityKeyMetadata().isKeyColumn(columnName)) continue;
                        Object value = currentStateTuple.get(columnName);
                        if (value != null) {
                            putBoBuilder.setField(StringHelper.realColumnName(columnName), value);
                            continue;
                        }
                        putBoBuilder.removeField(columnName);
                    }
                    if (previousId != null && !previousId.equals(currentId)) {
                        removedObjects.add(previousId);
                    }
                    changedObjects.put(currentId, putBoBuilder.build());
                    continue;
                }
                if (op.getType() == AssociationOperationType.REMOVE) {
                    removedObjects.add(previousId);
                    continue;
                }
                throw new UnsupportedOperationException("AssociationOperation not supported: " + op.getType());
            }
            if (!changedObjects.isEmpty()) {
                associationCache.putAll(changedObjects);
            }
            if (!removedObjects.isEmpty()) {
                associationCache.removeAll(removedObjects);
            }
        } else if (key.getMetadata().getAssociationKind() == AssociationKind.EMBEDDED_COLLECTION) {
            String indexColumnName = this.findIndexColumnName(key.getMetadata());
            boolean searchByValue = indexColumnName == null;
            Object id = ((IgniteTupleSnapshot)associationContext.getEntityTuplePointer().getTuple().getSnapshot()).getCacheKey();
            BinaryObject binaryObject = (BinaryObject)associationCache.get(id);
            Contracts.assertNotNull((Object)binaryObject, (String)"binaryObject");
            String column = StringHelper.realColumnName(key.getMetadata().getCollectionRole());
            Object[] binaryObjects = (Object[])binaryObject.field(column);
            ArrayList<BinaryObject> associationObjects = new ArrayList<BinaryObject>();
            if (binaryObjects != null) {
                for (int i = 0; i < binaryObjects.length; ++i) {
                    associationObjects.add((BinaryObject)binaryObjects[i]);
                }
            }
            EntityKeyMetadata itemMetadata = key.getMetadata().getAssociatedEntityKeyMetadata().getEntityKeyMetadata();
            block10: for (AssociationOperation op : association.getOperations()) {
                int index = this.findIndexByRowKey(associationObjects, op.getKey(), indexColumnName);
                switch (op.getType()) {
                    case PUT: {
                        Object value;
                        Tuple currentStateTuple = op.getValue();
                        BinaryObjectBuilder putBoBuilder = this.provider.createBinaryObjectBuilder(this.provider.getEntityTypeName(itemMetadata.getTable()));
                        for (String columnName : op.getKey().getColumnNames()) {
                            value = op.getKey().getColumnValue(columnName);
                            if (value == null) continue;
                            putBoBuilder.setField(StringHelper.stringAfterPoint(columnName), value);
                        }
                        for (String columnName : itemMetadata.getColumnNames()) {
                            value = currentStateTuple.get(columnName);
                            if (value == null) continue;
                            putBoBuilder.setField(StringHelper.stringAfterPoint(columnName), value);
                        }
                        BinaryObject itemObject = putBoBuilder.build();
                        if (index >= 0) {
                            associationObjects.set(index, itemObject);
                            continue block10;
                        }
                        associationObjects.add(itemObject);
                        continue block10;
                    }
                    case REMOVE: {
                        if (index < 0) continue block10;
                        associationObjects.remove(index);
                        continue block10;
                    }
                }
                throw new HibernateException("AssociationOperation not supported: " + op.getType());
            }
            BinaryObjectBuilder binaryObjectBuilder = this.provider.createBinaryObjectBuilder(binaryObject);
            binaryObjectBuilder.setField(column, (Object)associationObjects.toArray(new BinaryObject[associationObjects.size()]));
            binaryObject = binaryObjectBuilder.build();
            associationCache.put(id, (Object)binaryObject);
        }
    }

    private int findIndexByRowKey(List<BinaryObject> objects, RowKey rowKey, String indexColumnName) {
        int result = -1;
        if (!objects.isEmpty()) {
            int i;
            String[] stringArray;
            if (indexColumnName == null) {
                stringArray = rowKey.getColumnNames();
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = indexColumnName;
            }
            String[] columnNames = stringArray;
            String[] fieldNames = new String[columnNames.length];
            for (i = 0; i < columnNames.length; ++i) {
                fieldNames[i] = StringHelper.stringAfterPoint(columnNames[i]);
            }
            for (i = 0; i < objects.size() && result < 0; ++i) {
                BinaryObject bo = objects.get(i);
                boolean thisIsIt = true;
                for (int j = 0; j < columnNames.length; ++j) {
                    if (Objects.equals(rowKey.getColumnValue(columnNames[j]), bo.field(fieldNames[j]))) continue;
                    thisIsIt = false;
                    break;
                }
                if (!thisIsIt) continue;
                result = i;
            }
        }
        return result;
    }

    private String findIndexColumnName(AssociationKeyMetadata associationMetadata) {
        String indexColumnName = null;
        if (associationMetadata.getAssociationType() != AssociationType.SET && associationMetadata.getAssociationType() != AssociationType.BAG) {
            if (associationMetadata.getRowKeyIndexColumnNames().length > 1) {
                throw new UnsupportedOperationException("Multiple index columns not implemented yet");
            }
            indexColumnName = associationMetadata.getRowKeyIndexColumnNames()[0];
        }
        return indexColumnName;
    }

    public void removeAssociation(AssociationKey key, AssociationContext associationContext) {
        if (key.getMetadata().isInverse()) {
            return;
        }
        IgniteCache<Object, BinaryObject> associationCache = this.provider.getAssociationCache(key.getMetadata());
        if (key.getMetadata().getAssociationKind() == AssociationKind.ASSOCIATION) {
            QueryHints.Builder hintsBuilder = new QueryHints.Builder();
            Boolean isCollocated = (Boolean)associationContext.getAssociationTypeContext().getOptionsContext().getUnique(CollocatedAssociationOption.class);
            if (isCollocated.booleanValue()) {
                throw new NotYetImplementedException();
            }
            QueryHints hints = hintsBuilder.build();
            if (!IgniteAssociationSnapshot.isThirdTableAssociation(key.getMetadata())) {
                HashMap changedObjects = new HashMap();
                SqlFieldsQuery sqlQuery = this.provider.createSqlFieldsQueryWithLog(this.createAssociationQuery(key, true), hints, key.getColumnValues());
                Iterable<List<?>> list = this.executeWithHints(associationCache, sqlQuery, hints);
                for (List<?> item : list) {
                    Object id = item.get(0);
                    BinaryObject clearBo = (BinaryObject)item.get(1);
                    if (clearBo == null) continue;
                    BinaryObjectBuilder clearBoBuilder = this.provider.createBinaryObjectBuilder(clearBo);
                    for (String columnName : key.getMetadata().getRowKeyColumnNames()) {
                        clearBoBuilder.removeField(StringHelper.realColumnName(columnName));
                    }
                    changedObjects.put(id, clearBoBuilder.build());
                }
                if (!changedObjects.isEmpty()) {
                    associationCache.putAll(changedObjects);
                }
            } else {
                HashSet removedObjects = new HashSet();
                SqlFieldsQuery sqlQuery = this.provider.createSqlFieldsQueryWithLog(this.createAssociationQuery(key, false), hints, key.getColumnValues());
                Iterable<List<?>> list = this.executeWithHints(associationCache, sqlQuery, hints);
                for (List<?> item : list) {
                    removedObjects.add(item.get(0));
                }
                if (!removedObjects.isEmpty()) {
                    associationCache.removeAll(removedObjects);
                }
            }
        } else if (key.getMetadata().getAssociationKind() == AssociationKind.EMBEDDED_COLLECTION) {
            Object id = ((IgniteTupleSnapshot)associationContext.getEntityTuplePointer().getTuple().getSnapshot()).getCacheKey();
            BinaryObject binaryObject = (BinaryObject)associationCache.get(id);
            Contracts.assertNotNull((Object)binaryObject, (String)"binaryObject");
            BinaryObjectBuilder binaryObjectBuilder = this.provider.createBinaryObjectBuilder(binaryObject);
            binaryObjectBuilder.removeField(key.getMetadata().getCollectionRole());
            binaryObject = binaryObjectBuilder.build();
            associationCache.put(id, (Object)binaryObject);
        }
    }

    public boolean isStoredInEntityStructure(AssociationKeyMetadata associationKeyMetadata, AssociationTypeContext associationTypeContext) {
        return false;
    }

    public Number nextValue(NextValueRequest request) {
        Long result = null;
        switch (request.getKey().getMetadata().getType()) {
            case TABLE: {
                IgniteCache<String, Long> cache = this.provider.getIdSourceCache(request.getKey().getMetadata());
                String idSourceKey = request.getKey().getColumnValue();
                Long previousValue = (Long)cache.get((Object)idSourceKey);
                if (previousValue == null && !cache.putIfAbsent((Object)idSourceKey, (Object)(result = Long.valueOf(request.getInitialValue())))) {
                    previousValue = request.getInitialValue();
                }
                if (previousValue == null) break;
                while (!cache.replace((Object)idSourceKey, (Object)previousValue, (Object)(result = Long.valueOf(previousValue + (long)request.getIncrement())))) {
                    previousValue = (Long)cache.get((Object)idSourceKey);
                }
                break;
            }
            case SEQUENCE: {
                IgniteAtomicSequence seq = this.provider.atomicSequence(request.getKey().getMetadata().getName(), request.getInitialValue(), false);
                result = seq.getAndAdd((long)request.getIncrement());
            }
        }
        return result;
    }

    public boolean supportsSequences() {
        return true;
    }

    public void forEachTuple(ModelConsumer consumer, TupleTypeContext tupleTypeContext, EntityKeyMetadata entityKeyMetadata) {
        throw new UnsupportedOperationException("forEachTuple() is not implemented");
    }

    public int executeBackendUpdateQuery(BackendQuery<IgniteQueryDescriptor> query, QueryParameters queryParameters, TupleContext tupleContext) {
        throw new UnsupportedOperationException("executeBackendUpdateQuery() is not implemented");
    }

    public ClosableIterator<Tuple> executeBackendQuery(BackendQuery<IgniteQueryDescriptor> backendQuery, QueryParameters queryParameters, TupleContext tupleContext) {
        Integer firstRow = queryParameters.getRowSelection().getFirstRow();
        if (firstRow != null && firstRow < 0) {
            throw new IllegalArgumentException("Query argument firstResult cannot be negative");
        }
        if (backendQuery.getSingleEntityMetadataInformationOrNull() == null) {
            throw new UnsupportedOperationException("Not implemented. Can't find cache name");
        }
        IgniteCache cache = this.provider.getEntityCache(backendQuery.getSingleEntityMetadataInformationOrNull().getEntityKeyMetadata());
        ArrayList<Object> indexedParameters = null;
        if (!queryParameters.getNamedParameters().isEmpty()) {
            indexedParameters = new ArrayList<Object>(queryParameters.getNamedParameters().size());
            for (Map.Entry entry : queryParameters.getNamedParameters().entrySet()) {
                indexedParameters.add(((TypedGridValue)entry.getValue()).getValue());
            }
        } else if (!queryParameters.getPositionalParameters().isEmpty()) {
            indexedParameters = new ArrayList(queryParameters.getPositionalParameters().size());
            for (TypedGridValue typedGridValue : queryParameters.getPositionalParameters()) {
                indexedParameters.add(typedGridValue.getValue());
            }
        } else {
            indexedParameters = ((IgniteQueryDescriptor)backendQuery.getQuery()).getIndexedParameters() != null ? ((IgniteQueryDescriptor)backendQuery.getQuery()).getIndexedParameters() : null;
        }
        QueryHints hints = new QueryHints.Builder(null).build();
        SqlFieldsQuery sqlQuery = this.provider.createSqlFieldsQueryWithLog(((IgniteQueryDescriptor)backendQuery.getQuery()).getSql(), hints, indexedParameters != null ? indexedParameters.toArray() : null);
        Iterable<List<?>> result = this.executeWithHints(cache, sqlQuery, hints);
        if (backendQuery.getSingleEntityMetadataInformationOrNull() != null) {
            return new IgnitePortableFromProjectionResultCursor(result, queryParameters.getRowSelection(), backendQuery.getSingleEntityMetadataInformationOrNull().getEntityKeyMetadata());
        }
        if (((IgniteQueryDescriptor)backendQuery.getQuery()).isHasScalar()) {
            throw new NotYetImplementedException();
        }
        throw new UnsupportedOperationException("Not implemented yet");
    }

    private Iterable<List<?>> executeWithHints(IgniteCache<Object, BinaryObject> cache, SqlFieldsQuery sqlQuery, QueryHints hints) {
        if (hints.isLocal() && !this.provider.isClientMode()) {
            sqlQuery.setLocal(true);
        }
        Object result = hints.isAffinityRun() ? this.provider.affinityCall(cache.getName(), hints.getAffinityKey(), sqlQuery) : cache.query(sqlQuery);
        return result;
    }

    public ParameterMetadataBuilder getParameterMetadataBuilder() {
        return IgniteParameterMetadataBuilder.INSTANCE;
    }

    public IgniteQueryDescriptor parseNativeQuery(String nativeQuery) {
        IgniteSqlQueryParser parser = new IgniteSqlQueryParser(nativeQuery);
        return parser.buildQueryDescriptor();
    }

    public GridType overrideType(Type type) {
        return IgniteGridTypeMapper.INSTANCE.overrideType(type);
    }

    private class IgnitePortableFromProjectionResultCursor
    extends BaseResultCursor<List<?>> {
        private final EntityKeyMetadata keyMetadata;

        public IgnitePortableFromProjectionResultCursor(Iterable<List<?>> resultCursor, RowSelection rowSelection, EntityKeyMetadata keyMetadata) {
            super(resultCursor, rowSelection);
            this.keyMetadata = keyMetadata;
        }

        @Override
        TupleSnapshot createTupleSnapshot(List<?> value) {
            return new IgniteTupleSnapshot(value.get(0), (BinaryObject)value.get(1), this.keyMetadata);
        }
    }

    private class IgniteProjectionResultCursor
    extends BaseResultCursor<List<?>> {
        private final List<Return> queryReturns;

        public IgniteProjectionResultCursor(Iterable<List<?>> resultCursor, List<Return> queryReturns, RowSelection rowSelection) {
            super(resultCursor, rowSelection);
            this.queryReturns = queryReturns;
        }

        @Override
        TupleSnapshot createTupleSnapshot(List<?> value) {
            HashMap map = new HashMap();
            for (int i = 0; i < value.size(); ++i) {
                ScalarReturn ret = (ScalarReturn)this.queryReturns.get(i);
                map.put(ret.getColumnAlias(), value.get(i));
            }
            return new MapTupleSnapshot(map);
        }
    }

    private abstract class BaseResultCursor<T>
    implements ClosableIterator<Tuple> {
        private final Iterator<T> resultIterator;
        private final Integer maxRows;
        private int rowNum = 0;

        public BaseResultCursor(Iterable<T> resultCursor, RowSelection rowSelection) {
            this.resultIterator = resultCursor.iterator();
            this.maxRows = rowSelection.getMaxRows();
            this.iterateToFirst(rowSelection);
        }

        private void iterateToFirst(RowSelection rowSelection) {
            int firstRow = rowSelection.getFirstRow() != null ? rowSelection.getFirstRow() : 0;
            for (int i = 0; i < firstRow && this.resultIterator.hasNext(); ++i) {
                this.resultIterator.next();
            }
        }

        public boolean hasNext() {
            return (this.maxRows == null || this.rowNum < this.maxRows) && this.resultIterator.hasNext();
        }

        public Tuple next() {
            T value = this.resultIterator.next();
            ++this.rowNum;
            return new Tuple(this.createTupleSnapshot(value), Tuple.SnapshotType.UPDATE);
        }

        abstract TupleSnapshot createTupleSnapshot(T var1);

        public void remove() {
            this.resultIterator.remove();
        }

        public void close() {
        }
    }
}

