/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.ignite;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.apache.ignite.IgniteCache;
import org.hibernate.LockMode;
import org.hibernate.StaleObjectStateException;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.dialect.lock.LockingStrategyException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.ogm.datastore.ignite.IgniteLockingStrategyException;
import org.hibernate.ogm.datastore.ignite.impl.IgniteDatastoreProvider;
import org.hibernate.ogm.datastore.ignite.logging.impl.Log;
import org.hibernate.ogm.datastore.ignite.logging.impl.LoggerFactory;
import org.hibernate.ogm.model.impl.EntityKeyBuilder;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.persister.impl.OgmEntityPersister;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.ogm.type.spi.TypeTranslator;
import org.hibernate.persister.entity.Lockable;

public class IgnitePessimisticReadLockingStrategy
implements LockingStrategy {
    private static final Log log = LoggerFactory.getLogger();
    private final Lockable lockable;
    private final LockMode lockMode;
    private IgniteDatastoreProvider provider;

    public IgnitePessimisticReadLockingStrategy(Lockable lockable, LockMode lockMode, IgniteDatastoreProvider provider) {
        this.lockable = lockable;
        this.lockMode = lockMode;
        this.provider = provider;
    }

    public void lock(Serializable id, Object version, Object object, int timeout, SharedSessionContractImplementor session) throws StaleObjectStateException, LockingStrategyException {
        TypeTranslator typeTranslator = (TypeTranslator)this.lockable.getFactory().getServiceRegistry().getService(TypeTranslator.class);
        GridType idGridType = typeTranslator.getType(this.lockable.getIdentifierType());
        EntityKey key = EntityKeyBuilder.fromData((EntityKeyMetadata)((OgmEntityPersister)this.lockable).getRootEntityKeyMetadata(), (GridType)idGridType, (Serializable)id, (SharedSessionContractImplementor)session);
        IgniteCache cache = this.provider.getEntityCache(key.getMetadata());
        Lock lock = cache.lock(this.provider.createKeyObject(key));
        try {
            lock.tryLock(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new IgniteLockingStrategyException(object, e.getMessage(), e);
        }
    }
}

