/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.ignite.configuration.impl;

import java.net.URL;
import java.util.Map;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.ogm.datastore.ignite.IgniteConfigurationBuilder;
import org.hibernate.ogm.util.configurationreader.spi.ConfigurationPropertyReader;

public class IgniteProviderConfiguration {
    private static final String DEFAULT_CONFIG = "ignite-config.xml";
    private URL url;
    private String instanceName;
    private IgniteConfigurationBuilder configBuilder;

    public void initialize(Map configurationMap, ClassLoaderService classLoaderService) {
        ConfigurationPropertyReader configurationPropertyReader = new ConfigurationPropertyReader(configurationMap, classLoaderService);
        this.url = (URL)configurationPropertyReader.property("hibernate.ogm.ignite.configuration_resource_name", URL.class).withDefault((Object)IgniteProviderConfiguration.class.getClassLoader().getResource(DEFAULT_CONFIG)).getValue();
        String configBuilderClassName = (String)configurationPropertyReader.property("hibernate.ogm.ignite.configuration_class_name", String.class).getValue();
        if (configBuilderClassName != null) {
            this.configBuilder = (IgniteConfigurationBuilder)configurationPropertyReader.property("hibernate.ogm.ignite.configuration_class_name", IgniteConfigurationBuilder.class).instantiate().getValue();
        }
        this.instanceName = (String)configurationPropertyReader.property("hibernate.ogm.ignite.instance_name", String.class).getValue();
    }

    public URL getUrl() {
        return this.url;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public IgniteConfigurationBuilder getConfigBuilder() {
        return this.configBuilder;
    }
}

