/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.ignite.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.ignite.binary.BinaryObject;
import org.hibernate.ogm.datastore.ignite.impl.IgniteAssociationSnapshot;
import org.hibernate.ogm.datastore.ignite.util.StringHelper;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.spi.TupleSnapshot;
import org.hibernate.ogm.util.impl.CollectionHelper;

public class IgniteAssociationRowSnapshot
implements TupleSnapshot {
    private final AssociationKeyMetadata associationMetadata;
    private final Object id;
    private final BinaryObject binaryObject;
    private final boolean isSimpleId;
    private final boolean thirdTableLink;
    private final Set<String> columnNames;

    public IgniteAssociationRowSnapshot(Object id, BinaryObject binaryObject, AssociationKeyMetadata associationMetadata) {
        this.id = id;
        this.binaryObject = binaryObject;
        this.associationMetadata = associationMetadata;
        this.thirdTableLink = IgniteAssociationSnapshot.isThirdTableAssociation(associationMetadata);
        if (this.thirdTableLink) {
            HashSet cn = new HashSet();
            Collections.addAll(cn, associationMetadata.getRowKeyColumnNames());
            Collections.addAll(cn, associationMetadata.getAssociatedEntityKeyMetadata().getAssociationKeyColumns());
            this.columnNames = Collections.unmodifiableSet(cn);
            this.isSimpleId = true;
        } else {
            HashSet<String> idColumnNames = new HashSet<String>();
            EntityKeyMetadata entityKeyMetadata = associationMetadata.getAssociatedEntityKeyMetadata().getEntityKeyMetadata();
            for (String columnName : entityKeyMetadata.getColumnNames()) {
                if (!entityKeyMetadata.isKeyColumn(columnName)) continue;
                idColumnNames.add(columnName);
            }
            if (idColumnNames.isEmpty()) {
                throw new UnsupportedOperationException("There is no id column in entity " + entityKeyMetadata.getTable() + ". Hmm...");
            }
            this.columnNames = CollectionHelper.asSet((Object[])entityKeyMetadata.getColumnNames());
            this.isSimpleId = idColumnNames.size() == 1;
        }
    }

    public Object get(String column) {
        Object result = null;
        if (!this.isEmpty()) {
            result = !this.thirdTableLink && this.associationMetadata.getAssociatedEntityKeyMetadata().getEntityKeyMetadata().isKeyColumn(column) ? (this.isSimpleId ? this.id : ((BinaryObject)this.id).field(StringHelper.stringAfterPoint(column))) : this.binaryObject.field(StringHelper.realColumnName(column));
        }
        return result;
    }

    public boolean isEmpty() {
        return this.id == null && this.binaryObject == null;
    }

    public Set<String> getColumnNames() {
        return this.columnNames;
    }

    public Object getCacheKey() {
        return this.id;
    }

    public BinaryObject getCacheValue() {
        return this.binaryObject;
    }
}

