/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.ignite.impl;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.binary.BinaryObject;
import org.hibernate.ogm.datastore.ignite.impl.IgniteAssociationRowSnapshot;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.RowKey;
import org.hibernate.ogm.model.spi.AssociationSnapshot;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.model.spi.TupleSnapshot;
import org.hibernate.ogm.util.impl.CollectionHelper;

public class IgniteAssociationSnapshot
implements AssociationSnapshot {
    private final Map<RowKey, IgniteAssociationRowSnapshot> rows;

    public IgniteAssociationSnapshot(AssociationKey associationKey) {
        this.rows = Collections.emptyMap();
    }

    public IgniteAssociationSnapshot(AssociationKey associationKey, Map<Object, BinaryObject> associationMap) {
        this.rows = CollectionHelper.newHashMap((int)associationMap.size());
        for (Map.Entry<Object, BinaryObject> entry : associationMap.entrySet()) {
            IgniteAssociationRowSnapshot snapshot = new IgniteAssociationRowSnapshot(entry.getKey(), entry.getValue(), associationKey.getMetadata());
            String[] rowKeyColumnNames = associationKey.getMetadata().getRowKeyColumnNames();
            Object[] rowKeyColumnValues = new Object[rowKeyColumnNames.length];
            for (int i = 0; i < rowKeyColumnNames.length; ++i) {
                String columnName = rowKeyColumnNames[i];
                rowKeyColumnValues[i] = snapshot.get(columnName);
            }
            RowKey rowKey = new RowKey(rowKeyColumnNames, rowKeyColumnValues);
            this.rows.put(rowKey, snapshot);
        }
    }

    public Tuple get(RowKey rowKey) {
        TupleSnapshot row = this.rows.get(rowKey);
        return row != null ? new Tuple(row, Tuple.SnapshotType.UPDATE) : null;
    }

    public boolean containsKey(RowKey rowKey) {
        return this.rows.containsKey(rowKey);
    }

    public Set<RowKey> getRowKeys() {
        return this.rows.keySet();
    }

    public int size() {
        return this.rows.size();
    }

    public Object getCacheKey(RowKey rowKey) {
        IgniteAssociationRowSnapshot row = this.rows.get(rowKey);
        return row != null ? row.getCacheKey() : null;
    }

    public BinaryObject getCacheValue(RowKey rowKey) {
        IgniteAssociationRowSnapshot row = this.rows.get(rowKey);
        return row != null ? row.getCacheValue() : null;
    }

    public static boolean isThirdTableAssociation(AssociationKeyMetadata associationMetadata) {
        return !associationMetadata.getTable().equals(associationMetadata.getAssociatedEntityKeyMetadata().getEntityKeyMetadata().getTable());
    }
}

