/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.ignite.impl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Optional;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.configuration.CacheConfiguration;
import org.hibernate.HibernateException;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.boot.model.relational.Sequence;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.Table;
import org.hibernate.ogm.datastore.ignite.impl.IgniteAssociationSnapshot;
import org.hibernate.ogm.datastore.ignite.impl.IgniteDatastoreProvider;
import org.hibernate.ogm.datastore.ignite.logging.impl.Log;
import org.hibernate.ogm.datastore.ignite.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.spi.BaseSchemaDefiner;
import org.hibernate.ogm.datastore.spi.DatastoreProvider;
import org.hibernate.ogm.datastore.spi.SchemaDefiner;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.AssociationKind;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.IdSourceKeyMetadata;
import org.hibernate.ogm.type.impl.EnumType;
import org.hibernate.ogm.type.impl.NumericBooleanType;
import org.hibernate.ogm.type.impl.YesNoType;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.ogm.type.spi.TypeTranslator;
import org.hibernate.ogm.util.impl.StringHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.Type;

public class IgniteCacheInitializer
extends BaseSchemaDefiner {
    private static final Log log = LoggerFactory.getLogger();
    private static final String STRING_CLASS_NAME = String.class.getName();
    private static final String INTEGER_CLASS_NAME = Integer.class.getName();
    private ServiceRegistry serviceRegistry;

    public void initializeSchema(SchemaDefiner.SchemaDefinitionContext context) {
        this.serviceRegistry = context.getSessionFactory().getServiceRegistry();
        DatastoreProvider provider = (DatastoreProvider)this.serviceRegistry.getService(DatastoreProvider.class);
        if (!(provider instanceof IgniteDatastoreProvider)) {
            throw log.unexpectedDatastoreProvider(provider.getClass(), IgniteDatastoreProvider.class);
        }
        IgniteDatastoreProvider igniteDatastoreProvider = (IgniteDatastoreProvider)provider;
        this.initializeEntities(context, igniteDatastoreProvider);
        this.initializeAssociations(context, igniteDatastoreProvider);
        this.initializeIdSources(context, igniteDatastoreProvider);
    }

    private void initializeEntities(SchemaDefiner.SchemaDefinitionContext context, IgniteDatastoreProvider igniteDatastoreProvider) {
        for (EntityKeyMetadata entityKeyMetadata : context.getAllEntityKeyMetadata()) {
            try {
                try {
                    igniteDatastoreProvider.getEntityCache(entityKeyMetadata);
                }
                catch (HibernateException ex) {
                    CacheConfiguration<?, ?> config = this.createEntityCacheConfiguration(entityKeyMetadata, context);
                    igniteDatastoreProvider.initializeCache(config);
                }
            }
            catch (Exception ex) {
                throw log.unableToInitializeCache(entityKeyMetadata.getTable(), ex);
            }
        }
    }

    private void initializeAssociations(SchemaDefiner.SchemaDefinitionContext context, IgniteDatastoreProvider igniteDatastoreProvider) {
        for (AssociationKeyMetadata associationKeyMetadata : context.getAllAssociationKeyMetadata()) {
            log.debugf("initializeAssociations. associationKeyMetadata: %s", associationKeyMetadata);
            if (associationKeyMetadata.getAssociationKind() == AssociationKind.EMBEDDED_COLLECTION || !IgniteAssociationSnapshot.isThirdTableAssociation(associationKeyMetadata)) continue;
            try {
                try {
                    igniteDatastoreProvider.getAssociationCache(associationKeyMetadata);
                }
                catch (HibernateException ex) {
                    CacheConfiguration config = this.createCacheConfiguration(associationKeyMetadata, context);
                    if (config == null) continue;
                    igniteDatastoreProvider.initializeCache(config);
                }
            }
            catch (Exception ex) {
                throw log.unableToInitializeCache(associationKeyMetadata.getTable(), ex);
            }
        }
    }

    private void initializeIdSources(SchemaDefiner.SchemaDefinitionContext context, IgniteDatastoreProvider igniteDatastoreProvider) {
        for (IdSourceKeyMetadata idSourceKeyMetadata : context.getAllIdSourceKeyMetadata()) {
            if (idSourceKeyMetadata.getType() != IdSourceKeyMetadata.IdSourceType.TABLE) continue;
            try {
                try {
                    igniteDatastoreProvider.getIdSourceCache(idSourceKeyMetadata);
                }
                catch (HibernateException ex) {
                    CacheConfiguration config = this.createCacheConfiguration(idSourceKeyMetadata);
                    igniteDatastoreProvider.initializeCache(config);
                }
            }
            catch (Exception ex) {
                throw log.unableToInitializeCache(idSourceKeyMetadata.getName(), ex);
            }
        }
        HashSet<String> generatedSequences = new HashSet<String>();
        for (Namespace namespace : context.getDatabase().getNamespaces()) {
            for (Sequence sequence : namespace.getSequences()) {
                generatedSequences.add(sequence.getName().getSequenceName().getText());
                igniteDatastoreProvider.atomicSequence(sequence.getName().getSequenceName().getText(), sequence.getInitialValue(), true);
            }
        }
        for (IdSourceKeyMetadata idSourceKeyMetadata : context.getAllIdSourceKeyMetadata()) {
            if (idSourceKeyMetadata.getType() != IdSourceKeyMetadata.IdSourceType.SEQUENCE || idSourceKeyMetadata.getName() == null || generatedSequences.contains(idSourceKeyMetadata.getName())) continue;
            igniteDatastoreProvider.atomicSequence(idSourceKeyMetadata.getName(), 1, true);
        }
    }

    private CacheConfiguration createCacheConfiguration(IdSourceKeyMetadata idSourceKeyMetadata) {
        CacheConfiguration result = new CacheConfiguration();
        result.setName(org.hibernate.ogm.datastore.ignite.util.StringHelper.stringBeforePoint(idSourceKeyMetadata.getName()));
        return result;
    }

    private CacheConfiguration createCacheConfiguration(AssociationKeyMetadata associationKeyMetadata, SchemaDefiner.SchemaDefinitionContext context) {
        QueryEntity queryEntity = new QueryEntity();
        queryEntity.setTableName(associationKeyMetadata.getTable());
        queryEntity.setValueType(org.hibernate.ogm.datastore.ignite.util.StringHelper.stringAfterPoint(associationKeyMetadata.getTable()));
        this.appendIndex(queryEntity, associationKeyMetadata, context);
        CacheConfiguration result = new CacheConfiguration();
        result.setName(org.hibernate.ogm.datastore.ignite.util.StringHelper.stringBeforePoint(associationKeyMetadata.getTable()));
        result.setQueryEntities(Arrays.asList(queryEntity));
        return result;
    }

    private void appendIndex(QueryEntity queryEntity, AssociationKeyMetadata associationKeyMetadata, SchemaDefiner.SchemaDefinitionContext context) {
        QueryIndex queryIndex = new QueryIndex();
        queryIndex.setIndexType(QueryIndexType.SORTED);
        LinkedHashMap<String, Boolean> fields = new LinkedHashMap<String, Boolean>();
        for (String columnName : associationKeyMetadata.getRowKeyColumnNames()) {
            String realColumnName = org.hibernate.ogm.datastore.ignite.util.StringHelper.realColumnName(columnName);
            queryEntity.addQueryField(realColumnName, STRING_CLASS_NAME, null);
            fields.put(realColumnName, true);
        }
        queryIndex.setFields(fields);
        queryIndex.setName(queryEntity.getTableName() + '_' + StringHelper.join(fields.keySet(), (String)"_"));
        HashSet<QueryIndex> indexes = new HashSet<QueryIndex>(queryEntity.getIndexes());
        indexes.add(queryIndex);
        queryEntity.setIndexes(indexes);
    }

    private Class getEntityIdClassName(String table, SchemaDefiner.SchemaDefinitionContext context) {
        Class entityClass = (Class)context.getTableEntityTypeMapping().get(table);
        EntityPersister entityPersister = context.getSessionFactory().getEntityPersister(entityClass.getName());
        return entityPersister.getIdentifierType().getReturnedClass();
    }

    private CacheConfiguration<?, ?> createEntityCacheConfiguration(EntityKeyMetadata entityKeyMetadata, SchemaDefiner.SchemaDefinitionContext context) {
        CacheConfiguration cacheConfiguration = new CacheConfiguration();
        cacheConfiguration.setStoreKeepBinary(true);
        cacheConfiguration.setSqlSchema("PUBLIC");
        cacheConfiguration.setBackups(1);
        cacheConfiguration.setName(org.hibernate.ogm.datastore.ignite.util.StringHelper.stringBeforePoint(entityKeyMetadata.getTable()));
        cacheConfiguration.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        QueryEntity queryEntity = new QueryEntity();
        queryEntity.setTableName(entityKeyMetadata.getTable());
        queryEntity.setKeyType(this.getEntityIdClassName(entityKeyMetadata.getTable(), context).getSimpleName());
        queryEntity.setValueType(org.hibernate.ogm.datastore.ignite.util.StringHelper.stringAfterPoint(entityKeyMetadata.getTable()));
        this.addTableInfo(queryEntity, context, entityKeyMetadata.getTable());
        for (AssociationKeyMetadata associationKeyMetadata : context.getAllAssociationKeyMetadata()) {
            if (associationKeyMetadata.getAssociationKind() == AssociationKind.EMBEDDED_COLLECTION || !associationKeyMetadata.getTable().equals(entityKeyMetadata.getTable()) || IgniteAssociationSnapshot.isThirdTableAssociation(associationKeyMetadata)) continue;
            this.appendIndex(queryEntity, associationKeyMetadata, context);
        }
        this.addUserIndexes(queryEntity, context, entityKeyMetadata.getTable());
        log.debugf("queryEntity: %s", queryEntity);
        cacheConfiguration.setQueryEntities(Arrays.asList(queryEntity));
        return cacheConfiguration;
    }

    private void addUserIndexes(QueryEntity queryEntity, SchemaDefiner.SchemaDefinitionContext context, String tableName) {
        Namespace namespace = context.getDatabase().getDefaultNamespace();
        Optional<Table> tableOptional = namespace.getTables().stream().filter(currentTable -> currentTable.getName().equals(tableName)).findFirst();
        if (tableOptional.isPresent()) {
            Table table = tableOptional.get();
            Iterator indexIterator = table.getIndexIterator();
            while (indexIterator.hasNext()) {
                Index index = (Index)indexIterator.next();
                this.appendIndex(queryEntity, index, context);
            }
        }
    }

    private void appendIndex(QueryEntity queryEntity, Index index, SchemaDefiner.SchemaDefinitionContext context) {
        QueryIndex queryIndex = new QueryIndex();
        queryIndex.setName(index.getName());
        queryIndex.setIndexType(QueryIndexType.SORTED);
        LinkedHashMap<String, Boolean> fields = new LinkedHashMap<String, Boolean>();
        Iterator columnIterator = index.getColumnIterator();
        while (columnIterator.hasNext()) {
            Column currentColumn = (Column)columnIterator.next();
            fields.put(currentColumn.getName(), true);
        }
        queryIndex.setFields(fields);
        HashSet<QueryIndex> indexes = new HashSet<QueryIndex>(queryEntity.getIndexes());
        indexes.add(queryIndex);
        queryEntity.setIndexes(indexes);
    }

    private void addTableInfo(QueryEntity queryEntity, SchemaDefiner.SchemaDefinitionContext context, String tableName) {
        Namespace namespace = context.getDatabase().getDefaultNamespace();
        Optional<Table> tableOptional = namespace.getTables().stream().filter(currentTable -> currentTable.getName().equals(tableName)).findFirst();
        if (tableOptional.isPresent()) {
            Table table = tableOptional.get();
            Iterator columnIterator = table.getColumnIterator();
            while (columnIterator.hasNext()) {
                Column currentColumn = (Column)columnIterator.next();
                String fieldType = this.fieldType(currentColumn);
                queryEntity.addQueryField(currentColumn.getName(), fieldType, null);
            }
        }
    }

    private String fieldType(Column currentColumn) {
        Type valueType;
        TypeTranslator translator = (TypeTranslator)this.serviceRegistry.getService(TypeTranslator.class);
        GridType gridType = translator.getType(valueType = currentColumn.getValue().getType());
        if (gridType instanceof EnumType) {
            return this.enumFieldType((EnumType)gridType);
        }
        if (gridType instanceof YesNoType) {
            return STRING_CLASS_NAME;
        }
        if (gridType instanceof NumericBooleanType) {
            return INTEGER_CLASS_NAME;
        }
        Class returnedClass = valueType.getReturnedClass();
        if (Character.class.equals((Object)returnedClass)) {
            return STRING_CLASS_NAME;
        }
        return returnedClass.getName();
    }

    private String enumFieldType(EnumType enumType) {
        return enumType.isOrdinal() ? INTEGER_CLASS_NAME : STRING_CLASS_NAME;
    }
}

