/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.ignite.impl;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.cache.configuration.Factory;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteAtomicSequence;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteIllegalStateException;
import org.apache.ignite.IgniteState;
import org.apache.ignite.Ignition;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgnitionEx;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.thread.IgniteThread;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.transaction.jta.platform.internal.NoJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.ogm.datastore.ignite.IgniteDialect;
import org.hibernate.ogm.datastore.ignite.configuration.impl.IgniteProviderConfiguration;
import org.hibernate.ogm.datastore.ignite.impl.IgniteAssociationSnapshot;
import org.hibernate.ogm.datastore.ignite.impl.IgniteCacheInitializer;
import org.hibernate.ogm.datastore.ignite.logging.impl.Log;
import org.hibernate.ogm.datastore.ignite.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.ignite.query.impl.QueryHints;
import org.hibernate.ogm.datastore.ignite.query.parsing.impl.IgniteQueryParserService;
import org.hibernate.ogm.datastore.ignite.transaction.impl.IgniteTransactionManagerFactory;
import org.hibernate.ogm.datastore.ignite.util.StringHelper;
import org.hibernate.ogm.datastore.spi.BaseDatastoreProvider;
import org.hibernate.ogm.datastore.spi.SchemaDefiner;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.AssociationKind;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.IdSourceKeyMetadata;
import org.hibernate.ogm.model.key.spi.RowKey;
import org.hibernate.ogm.query.spi.QueryParserService;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.ServiceException;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.Startable;
import org.hibernate.service.spi.Stoppable;

public class IgniteDatastoreProvider
extends BaseDatastoreProvider
implements Startable,
Stoppable,
ServiceRegistryAwareService,
Configurable {
    private static final Log log = LoggerFactory.getLogger();
    private JtaPlatform jtaPlatform;
    private JdbcServices jdbcServices;
    private IgniteEx cacheManager;
    private IgniteProviderConfiguration configProvider;
    private String gridName;
    private boolean localNode = false;
    private boolean stopOnExit = false;
    private Map<String, String> compositeIdTypes = new HashMap<String, String>();
    private ClassLoaderService classLoaderService;

    public IgniteCache<Object, BinaryObject> getEntityCache(String entityName) {
        String entityCacheName = this.getEntityCacheName(entityName);
        return this.getCache(entityCacheName, true);
    }

    public <K> IgniteCache<K, BinaryObject> getEntityCache(EntityKeyMetadata keyMetadata) {
        String entityCacheName = this.getEntityCacheName(keyMetadata.getTable());
        return this.getCache(entityCacheName, true);
    }

    private <K, V> IgniteCache<K, V> getCache(String entityCacheName, boolean keepBinary) {
        IgniteCache cache = null;
        try {
            cache = this.cacheManager.cache(entityCacheName);
        }
        catch (IllegalStateException ex) {
            if (Ignition.state((String)this.gridName) == IgniteState.STOPPED) {
                log.stoppedIgnite();
                this.restart();
                cache = this.cacheManager.cache(entityCacheName);
            }
            throw ex;
        }
        if (cache == null) {
            throw log.cacheNotFound(entityCacheName);
        }
        if (keepBinary) {
            cache = cache.withKeepBinary();
        }
        return cache;
    }

    <K, T> IgniteCache<K, T> initializeCache(CacheConfiguration<K, T> config) {
        return this.cacheManager.getOrCreateCache(config);
    }

    private void restart() {
        if (this.cacheManager.isRestartEnabled()) {
            Ignition.restart((boolean)false);
        } else {
            this.start();
        }
    }

    public IgniteCache<Object, BinaryObject> getAssociationCache(AssociationKeyMetadata keyMetadata) {
        return keyMetadata.getAssociationKind() == AssociationKind.EMBEDDED_COLLECTION ? this.getEntityCache(keyMetadata.getEntityKeyMetadata()) : this.getEntityCache(keyMetadata.getTable());
    }

    public IgniteCache<String, Long> getIdSourceCache(IdSourceKeyMetadata keyMetadata) {
        String idSourceCacheName = this.getEntityCacheName(keyMetadata.getName());
        return this.getCache(idSourceCacheName, false);
    }

    public BinaryObjectBuilder createBinaryObjectBuilder(String type) {
        return this.cacheManager.binary().builder(type);
    }

    public BinaryObjectBuilder createBinaryObjectBuilder(BinaryObject binaryObject) {
        return this.cacheManager.binary().builder(binaryObject);
    }

    public void configure(Map map) {
        this.configProvider = new IgniteProviderConfiguration();
        this.configProvider.initialize(map, this.classLoaderService);
    }

    public void stop() {
        if (this.cacheManager != null && this.stopOnExit) {
            Ignition.stop((String)this.cacheManager.name(), (boolean)true);
        }
    }

    public void start() {
        try {
            this.localNode = Thread.currentThread() instanceof IgniteThread;
            if (this.localNode) {
                this.cacheManager = (IgniteEx)Ignition.localIgnite();
                this.gridName = this.cacheManager.name();
            } else {
                IgniteConfiguration conf = this.createIgniteConfiguration(this.configProvider);
                this.gridName = this.gridName(this.configProvider.getInstanceName(), this.configProvider.getUrl(), conf);
                this.startIgnite(conf);
            }
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw log.unableToStartDatastoreProvider(ex);
        }
    }

    private void startIgnite(IgniteConfiguration conf) {
        try {
            this.cacheManager = (IgniteEx)Ignition.ignite((String)this.gridName);
        }
        catch (IgniteIllegalStateException iise) {
            conf.setIgniteInstanceName(this.gridName);
            this.cacheManager = (IgniteEx)Ignition.start((IgniteConfiguration)conf);
            if (conf.getPersistentStoreConfiguration() != null && !conf.isClientMode().booleanValue()) {
                this.cacheManager.active(true);
            }
            this.stopOnExit = true;
        }
    }

    private String gridName(String instanceName, URL ingiteConfigUrl, IgniteConfiguration conf) {
        if (StringHelper.isNotEmpty(instanceName)) {
            return instanceName;
        }
        if (StringHelper.isNotEmpty(conf.getIgniteInstanceName())) {
            return conf.getIgniteInstanceName();
        }
        if (ingiteConfigUrl != null) {
            String name = ingiteConfigUrl.getPath();
            return name.replaceAll("[\\,\\\",:,\\*,\\/,\\\\]", "_");
        }
        return UUID.randomUUID().toString();
    }

    private IgniteConfiguration createIgniteConfiguration(IgniteProviderConfiguration configProvider) throws IgniteCheckedException {
        IgniteConfiguration conf = null;
        if (configProvider.getConfigBuilder() != null) {
            conf = configProvider.getConfigBuilder().build();
        }
        if (conf == null && configProvider.getUrl() != null) {
            conf = (IgniteConfiguration)IgnitionEx.loadConfiguration((URL)configProvider.getUrl()).get1();
        }
        if (conf == null) {
            throw log.configurationNotSet();
        }
        this.injectJtaPlatform(conf);
        return conf;
    }

    private void injectJtaPlatform(IgniteConfiguration conf) {
        if (!(this.jtaPlatform instanceof NoJtaPlatform) && conf.getTransactionConfiguration().getTxManagerFactory() == null) {
            conf.getTransactionConfiguration().setTxManagerFactory((Factory)new IgniteTransactionManagerFactory(this.jtaPlatform));
        }
    }

    public String getGridName() {
        return this.gridName;
    }

    public void injectServices(ServiceRegistryImplementor serviceRegistryImplementor) {
        this.classLoaderService = (ClassLoaderService)serviceRegistryImplementor.getService(ClassLoaderService.class);
        this.jtaPlatform = (JtaPlatform)serviceRegistryImplementor.getService(JtaPlatform.class);
        this.jdbcServices = (JdbcServices)serviceRegistryImplementor.getService(JdbcServices.class);
    }

    public Class<? extends SchemaDefiner> getSchemaDefinerType() {
        return IgniteCacheInitializer.class;
    }

    public IgniteAtomicSequence atomicSequence(String name, int initialValue, boolean create) {
        return this.cacheManager.atomicSequence(name, (long)initialValue, create);
    }

    public boolean isClientMode() {
        return this.cacheManager.configuration().isClientMode();
    }

    public Class<? extends QueryParserService> getDefaultQueryParserServiceType() {
        return IgniteQueryParserService.class;
    }

    public Class<? extends GridDialect> getDefaultDialect() {
        return IgniteDialect.class;
    }

    public <T> List<T> affinityCall(String cacheName, Object affinityKey, SqlFieldsQuery query) {
        ComputeForLocalQueries call = new ComputeForLocalQueries(cacheName, query);
        return (List)this.cacheManager.compute().affinityCall(cacheName, affinityKey, call);
    }

    public SqlFieldsQuery createSqlFieldsQueryWithLog(String sql, QueryHints hints, Object ... args) {
        String comment = hints != null ? hints.toComment() : "";
        this.jdbcServices.getSqlStatementLogger().logStatement(comment + sql);
        SqlFieldsQuery query = new SqlFieldsQuery(sql);
        if (args != null) {
            query.setArgs(args);
        }
        return query;
    }

    public Object createKeyObject(EntityKey key) {
        Object result = null;
        if (key.getColumnValues().length == 1) {
            IgniteCache entityCache = this.getEntityCache(key.getMetadata());
            CacheConfiguration cacheConfig = (CacheConfiguration)entityCache.getConfiguration(CacheConfiguration.class);
            result = this.toValidKeyObject(key.getColumnValues()[0], cacheConfig.getKeyType());
        } else {
            BinaryObjectBuilder builder = this.createBinaryObjectBuilder(this.findKeyType(key.getMetadata()));
            for (int i = 0; i < key.getColumnNames().length; ++i) {
                builder.setField(StringHelper.stringAfterPoint(key.getColumnNames()[i]), key.getColumnValues()[i]);
            }
            result = builder.build();
        }
        return result;
    }

    private Object toValidKeyObject(Object value, Class<?> keyType) {
        Object result = null;
        if (keyType == value.getClass() || keyType.isAssignableFrom(value.getClass())) {
            result = value;
        } else if (keyType == String.class) {
            result = value.toString();
        }
        if (result == null) {
            throw log.unableToCreateKeyObject(keyType.getName(), value.getClass().getName());
        }
        return result;
    }

    public Object createAssociationKeyObject(RowKey rowKey, AssociationKeyMetadata keyMetadata) {
        Object result = null;
        if (IgniteAssociationSnapshot.isThirdTableAssociation(keyMetadata)) {
            result = UUID.randomUUID().toString();
        } else {
            String[] associationKeyColumns = keyMetadata.getAssociatedEntityKeyMetadata().getAssociationKeyColumns();
            if (associationKeyColumns.length == 1) {
                result = rowKey.getColumnValue(associationKeyColumns[0]);
            } else {
                BinaryObjectBuilder builder = this.createBinaryObjectBuilder(this.findKeyType(keyMetadata.getAssociatedEntityKeyMetadata().getEntityKeyMetadata()));
                for (int i = 0; i < associationKeyColumns.length; ++i) {
                    builder.setField(StringHelper.stringAfterPoint(associationKeyColumns[i]), rowKey.getColumnValue(associationKeyColumns[i]));
                }
                result = builder.build();
            }
        }
        return result;
    }

    public Object createParentKeyObject(AssociationKey key) {
        Object result = null;
        if (key.getColumnValues().length != 1) {
            throw new UnsupportedOperationException("Not implemented yet");
        }
        result = key.getColumnValues()[0];
        return result;
    }

    private String findKeyType(EntityKeyMetadata keyMetadata) {
        String result = this.compositeIdTypes.get(keyMetadata.getTable());
        if (result == null) {
            String cacheType = this.getEntityTypeName(keyMetadata.getTable());
            IgniteCache cache = this.getEntityCache(keyMetadata);
            CacheConfiguration cacheConfig = (CacheConfiguration)cache.getConfiguration(CacheConfiguration.class);
            if (cacheConfig.getQueryEntities() != null) {
                for (QueryEntity qe : cacheConfig.getQueryEntities()) {
                    if (qe.getValueType() == null || !cacheType.equalsIgnoreCase(qe.getValueType())) continue;
                    result = qe.getKeyType();
                    break;
                }
            }
            if (result == null) {
                if (cacheConfig.getKeyType() != null) {
                    result = cacheConfig.getKeyType().getSimpleName();
                }
                if (result == null) {
                    result = StringHelper.stringBeforePoint(keyMetadata.getColumnNames()[0]);
                    result = this.capitalize(result);
                }
            }
            this.compositeIdTypes.put(keyMetadata.getTable(), result);
        }
        return result;
    }

    private String capitalize(String value) {
        if (StringHelper.isEmpty(value)) {
            return value;
        }
        char firstChar = Character.toTitleCase(value.charAt(0));
        StringBuilder builder = new StringBuilder(firstChar);
        if (value.length() > 1) {
            builder.append(value.substring(1));
        }
        return builder.toString();
    }

    public String getEntityTypeName(String entity) {
        return StringHelper.stringAfterPoint(entity);
    }

    private String getEntityCacheName(String entity) {
        return StringHelper.stringBeforePoint(entity);
    }

    private static class ComputeForLocalQueries<T>
    implements IgniteCallable<List<T>> {
        private final String cacheName;
        private final SqlFieldsQuery query;
        @IgniteInstanceResource
        private Ignite ignite;

        public ComputeForLocalQueries(String cacheName, SqlFieldsQuery query) {
            this.cacheName = cacheName;
            this.query = query.setLocal(true);
        }

        public List<T> call() throws Exception {
            IgniteCache cache = this.ignite.cache(this.cacheName);
            if (cache == null) {
                throw new IgniteException("Cache '" + this.cacheName + "' not found");
            }
            cache = cache.withKeepBinary();
            return cache.query(this.query).getAll();
        }
    }
}

