/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.ignite.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.binary.BinaryObject;
import org.hibernate.ogm.datastore.ignite.impl.IgniteTupleSnapshot;
import org.hibernate.ogm.datastore.ignite.util.StringHelper;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.RowKey;
import org.hibernate.ogm.model.spi.AssociationSnapshot;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.model.spi.TupleSnapshot;

public class IgniteEmbeddedAssociationSnapshot
implements AssociationSnapshot {
    private final Map<RowKey, TupleSnapshot> rows;
    private final AssociationKeyMetadata associationMetadata;
    private final Tuple tuple;

    public IgniteEmbeddedAssociationSnapshot(AssociationKey associationKey, Tuple tuple) {
        this.associationMetadata = associationKey.getMetadata();
        this.tuple = tuple;
        BinaryObject obj = ((IgniteTupleSnapshot)tuple.getSnapshot()).getCacheValue();
        Object[] objects = obj != null ? (Object[])obj.field(StringHelper.realColumnName(this.associationMetadata.getCollectionRole())) : null;
        this.rows = new HashMap<RowKey, TupleSnapshot>();
        if (objects != null) {
            int i;
            String[] rowKeyColumnNames = new String[this.associationMetadata.getRowKeyColumnNames().length];
            for (i = 0; i < rowKeyColumnNames.length; ++i) {
                rowKeyColumnNames[i] = StringHelper.stringAfterPoint(this.associationMetadata.getRowKeyColumnNames()[i]);
            }
            for (i = 0; i < objects.length; ++i) {
                BinaryObject itemObject = (BinaryObject)objects[i];
                Object[] rowKeyColumnValues = new Object[rowKeyColumnNames.length];
                for (int j = 0; j < rowKeyColumnNames.length; ++j) {
                    rowKeyColumnValues[j] = itemObject.field(rowKeyColumnNames[j]);
                }
                RowKey rowKey = new RowKey(this.associationMetadata.getRowKeyColumnNames(), rowKeyColumnValues);
                this.rows.put(rowKey, new IgniteTupleSnapshot(null, itemObject, this.associationMetadata.getAssociatedEntityKeyMetadata().getEntityKeyMetadata()));
            }
        }
    }

    public Tuple get(RowKey rowKey) {
        TupleSnapshot row = this.rows.get(rowKey);
        return row != null ? new Tuple(row, Tuple.SnapshotType.UPDATE) : null;
    }

    public boolean containsKey(RowKey rowKey) {
        return this.rows.containsKey(rowKey);
    }

    public Set<RowKey> getRowKeys() {
        return this.rows.keySet();
    }

    public int size() {
        return this.rows.size();
    }
}

