/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.ignite.impl;

import java.util.HashSet;
import java.util.Set;
import org.apache.ignite.binary.BinaryObject;
import org.hibernate.ogm.datastore.ignite.util.StringHelper;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.spi.TupleSnapshot;
import org.hibernate.ogm.util.impl.CollectionHelper;

public class IgniteTupleSnapshot
implements TupleSnapshot {
    private final EntityKeyMetadata keyMetadata;
    private final Object id;
    private final BinaryObject binaryObject;
    private final boolean isSimpleId;
    private final Set<String> columnNames;

    public IgniteTupleSnapshot(Object id, BinaryObject binaryObject, EntityKeyMetadata keyMetadata) {
        this.id = id;
        this.binaryObject = binaryObject;
        this.keyMetadata = keyMetadata;
        HashSet<String> idColumnNames = new HashSet<String>();
        for (String columnName : keyMetadata.getColumnNames()) {
            if (!keyMetadata.isKeyColumn(columnName)) continue;
            idColumnNames.add(columnName);
        }
        if (idColumnNames.isEmpty()) {
            throw new UnsupportedOperationException("There is no id column in entity " + keyMetadata.getTable() + ". Hmm...");
        }
        this.isSimpleId = idColumnNames.size() == 1;
        this.columnNames = CollectionHelper.asSet((Object[])keyMetadata.getColumnNames());
    }

    private boolean isEmbeddedItem() {
        return this.id == null;
    }

    public Object get(String column) {
        Object result = null;
        if (!this.isEmpty()) {
            if (!this.isEmbeddedItem() && this.keyMetadata.isKeyColumn(column)) {
                result = this.isSimpleId ? this.id : ((BinaryObject)this.id).field(StringHelper.stringAfterPoint(column));
            } else if (this.binaryObject != null) {
                result = this.binaryObject.field(this.isEmbeddedItem() ? StringHelper.stringAfterPoint(column) : StringHelper.realColumnName(column));
            }
        }
        return result;
    }

    public boolean isEmpty() {
        return this.id == null && this.binaryObject == null;
    }

    public Set<String> getColumnNames() {
        return this.columnNames;
    }

    public Object getCacheKey() {
        return this.id;
    }

    public BinaryObject getCacheValue() {
        return this.binaryObject;
    }
}

