/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.ignite.query.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.QueryException;
import org.hibernate.engine.query.spi.ParameterParser;
import org.hibernate.ogm.datastore.ignite.query.impl.IgniteQueryDescriptor;
import org.hibernate.persister.collection.SQLLoadableCollection;
import org.hibernate.persister.entity.SQLLoadable;

public class IgniteSqlQueryParser {
    private static final String HIBERNATE_PLACEHOLDER_PREFIX = "h-";
    private static final String DOMAIN_PLACEHOLDER = "h-domain";
    private static final String CATALOG_PLACEHOLDER = "h-catalog";
    private static final String SCHEMA_PLACEHOLDER = "h-schema";
    protected final String originalQuery;
    protected ParserContext context;
    private Map namedParameters = new HashMap();
    private long aliasesFound;

    public IgniteSqlQueryParser(String query, ParserContext context) {
        this.originalQuery = query;
        this.context = context;
    }

    public IgniteSqlQueryParser(String query) {
        this.originalQuery = query;
        this.context = new DefaultParserContext();
    }

    public Map getNamedParameters() {
        return this.namedParameters;
    }

    public boolean queryHasAliases() {
        return this.aliasesFound > 0L;
    }

    public String process() {
        String processedSql = this.substituteBrackets(this.originalQuery);
        processedSql = this.substituteParams(processedSql);
        return processedSql;
    }

    public IgniteQueryDescriptor buildQueryDescriptor() {
        return new IgniteQueryDescriptor(this.process(), null, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String substituteBrackets(String sqlQuery) throws QueryException {
        StringBuilder result = new StringBuilder(sqlQuery.length() + 20);
        int curr = 0;
        while (curr < sqlQuery.length()) {
            int left = sqlQuery.indexOf(123, curr);
            if (left < 0) {
                result.append(sqlQuery.substring(curr));
                return result.toString();
            }
            result.append(sqlQuery.substring(curr, left));
            int right = sqlQuery.indexOf(125, left + 1);
            if (right < 0) {
                throw new QueryException("Unmatched braces for alias path", sqlQuery);
            }
            String aliasPath = sqlQuery.substring(left + 1, right);
            boolean isPlaceholder = aliasPath.startsWith(HIBERNATE_PLACEHOLDER_PREFIX);
            if (isPlaceholder) {
                if (DOMAIN_PLACEHOLDER.equals(aliasPath)) {
                    String catalogName = "";
                    if ("" != null) {
                        result.append("");
                        result.append(".");
                    }
                    String schemaName = "";
                    if ("" != null) {
                        result.append("");
                        result.append(".");
                    }
                } else if (SCHEMA_PLACEHOLDER.equals(aliasPath)) {
                    String schemaName = "";
                    if ("" != null) {
                        result.append("");
                        result.append(".");
                    }
                } else {
                    if (!CATALOG_PLACEHOLDER.equals(aliasPath)) throw new QueryException("Unknown placeholder ", aliasPath);
                    String catalogName = "";
                    if ("" != null) {
                        result.append("");
                        result.append(".");
                    }
                }
            } else {
                int firstDot = aliasPath.indexOf(46);
                if (firstDot == -1) {
                    if (this.context.isEntityAlias(aliasPath)) {
                        result.append(aliasPath);
                        ++this.aliasesFound;
                    } else {
                        result.append('{').append(aliasPath).append('}');
                    }
                } else {
                    String propertyName;
                    String aliasName = aliasPath.substring(0, firstDot);
                    if (this.context.isCollectionAlias(aliasName)) {
                        propertyName = aliasPath.substring(firstDot + 1);
                        result.append(this.resolveCollectionProperties(aliasName, propertyName));
                        ++this.aliasesFound;
                    } else if (this.context.isEntityAlias(aliasName)) {
                        propertyName = aliasPath.substring(firstDot + 1);
                        result.append(this.resolveProperties(aliasName, propertyName));
                        ++this.aliasesFound;
                    } else {
                        result.append('{').append(aliasPath).append('}');
                    }
                }
            }
            curr = right + 1;
        }
        return result.toString();
    }

    private String resolveCollectionProperties(String aliasName, String propertyName) {
        Map fieldResults = this.context.getPropertyResultsMapByAlias(aliasName);
        SQLLoadableCollection collectionPersister = this.context.getCollectionPersisterByAlias(aliasName);
        String collectionSuffix = this.context.getCollectionSuffixByAlias(aliasName);
        if ("*".equals(propertyName)) {
            if (!fieldResults.isEmpty()) {
                throw new QueryException("Using return-propertys together with * syntax is not supported.");
            }
            String selectFragment = collectionPersister.selectFragment(aliasName, collectionSuffix);
            ++this.aliasesFound;
            return selectFragment + ", " + this.resolveProperties(aliasName, propertyName);
        }
        if ("element.*".equals(propertyName)) {
            return this.resolveProperties(aliasName, "*");
        }
        String[] columnAliases = (String[])fieldResults.get(propertyName);
        if (columnAliases == null) {
            columnAliases = collectionPersister.getCollectionPropertyColumnAliases(propertyName, collectionSuffix);
        }
        if (columnAliases == null || columnAliases.length == 0) {
            throw new QueryException("No column name found for property [" + propertyName + "] for alias [" + aliasName + "]", this.originalQuery);
        }
        if (columnAliases.length != 1) {
            throw new QueryException("SQL queries only support properties mapped to a single column - property [" + propertyName + "] is mapped to " + columnAliases.length + " columns.", this.originalQuery);
        }
        ++this.aliasesFound;
        return columnAliases[0];
    }

    private String resolveProperties(String aliasName, String propertyName) {
        Map fieldResults = this.context.getPropertyResultsMapByAlias(aliasName);
        SQLLoadable persister = this.context.getEntityPersisterByAlias(aliasName);
        String suffix = this.context.getEntitySuffixByAlias(aliasName);
        if ("*".equals(propertyName)) {
            if (!fieldResults.isEmpty()) {
                throw new QueryException("Using return-propertys together with * syntax is not supported.");
            }
            ++this.aliasesFound;
            return persister.selectFragment(aliasName, suffix);
        }
        String[] columnAliases = (String[])fieldResults.get(propertyName);
        if (columnAliases == null) {
            columnAliases = persister.getSubclassPropertyColumnAliases(propertyName, suffix);
        }
        if (columnAliases == null || columnAliases.length == 0) {
            throw new QueryException("No column name found for property [" + propertyName + "] for alias [" + aliasName + "]", this.originalQuery);
        }
        if (columnAliases.length != 1) {
            throw new QueryException("SQL queries only support properties mapped to a single column - property [" + propertyName + "] is mapped to " + columnAliases.length + " columns.", this.originalQuery);
        }
        ++this.aliasesFound;
        return columnAliases[0];
    }

    private String substituteParams(String sqlString) {
        ParameterSubstitutionRecognizer recognizer = new ParameterSubstitutionRecognizer();
        ParameterParser.parse((String)sqlString, (ParameterParser.Recognizer)recognizer);
        this.namedParameters.clear();
        this.namedParameters.putAll(recognizer.namedParameterBindPoints);
        return recognizer.result.toString();
    }

    public static class ParameterSubstitutionRecognizer
    implements ParameterParser.Recognizer {
        StringBuilder result = new StringBuilder();
        Map namedParameterBindPoints = new HashMap();
        int parameterCount;

        public void outParameter(int position) {
            this.result.append('?');
        }

        public void ordinalParameter(int position) {
            this.result.append('?');
        }

        public void namedParameter(String name, int position) {
            this.addNamedParameter(name);
            this.result.append('?');
        }

        public void jpaPositionalParameter(String name, int position) {
            this.namedParameter(name, position);
        }

        public void other(char character) {
            this.result.append(character);
        }

        private void addNamedParameter(String name) {
            Integer loc = this.parameterCount++;
            Object o = this.namedParameterBindPoints.get(name);
            if (o == null) {
                this.namedParameterBindPoints.put(name, loc);
            } else if (o instanceof Integer) {
                ArrayList<Object> list = new ArrayList<Object>(4);
                list.add(o);
                list.add(loc);
                this.namedParameterBindPoints.put(name, list);
            } else {
                ((List)o).add(loc);
            }
        }
    }

    private static class DefaultParserContext
    implements ParserContext {
        private DefaultParserContext() {
        }

        @Override
        public boolean isEntityAlias(String aliasName) {
            return false;
        }

        @Override
        public SQLLoadable getEntityPersisterByAlias(String alias) {
            return null;
        }

        @Override
        public String getEntitySuffixByAlias(String alias) {
            return null;
        }

        @Override
        public boolean isCollectionAlias(String aliasName) {
            return false;
        }

        @Override
        public SQLLoadableCollection getCollectionPersisterByAlias(String alias) {
            return null;
        }

        @Override
        public String getCollectionSuffixByAlias(String alias) {
            return null;
        }

        @Override
        public Map getPropertyResultsMapByAlias(String alias) {
            return null;
        }
    }

    protected static interface ParserContext {
        public boolean isEntityAlias(String var1);

        public SQLLoadable getEntityPersisterByAlias(String var1);

        public String getEntitySuffixByAlias(String var1);

        public boolean isCollectionAlias(String var1);

        public SQLLoadableCollection getCollectionPersisterByAlias(String var1);

        public String getCollectionSuffixByAlias(String var1);

        public Map getPropertyResultsMapByAlias(String var1);
    }
}

