/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.ignite.query.impl;

import java.util.List;
import org.hibernate.HibernateException;

public class QueryHints {
    public static final String HINT_LOCAL_QUERY = "local";
    public static final String HINT_AFFINITY_QUERY = "affinityKey";
    public static final String HINT_SEPARATOR = ",";
    private final boolean local;
    private final boolean affinityRun;
    private final Object affinityKey;

    private QueryHints(boolean local, boolean affinityRun, Object affinityKey) {
        this.local = local;
        this.affinityRun = affinityRun;
        this.affinityKey = affinityKey;
    }

    public boolean isLocal() {
        return this.local;
    }

    public boolean isAffinityRun() {
        return this.affinityRun;
    }

    public Object getAffinityKey() {
        return this.affinityKey;
    }

    public boolean isEmpty() {
        return !this.local && !this.affinityRun;
    }

    public String toComment() {
        if (this.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder("/* Hints: ");
        if (this.local) {
            sb.append("local ");
        }
        if (this.affinityRun) {
            sb.append("affinityRun( key: ").append(this.affinityKey).append(" ) ");
        }
        sb.append("*/ ");
        return sb.toString();
    }

    public static class Builder {
        private boolean local;
        private boolean affinityRun;
        private Object affinityKey;

        public Builder() {
        }

        public Builder(List<String> hints) {
            if (hints != null) {
                for (String h : hints) {
                    int index = h.indexOf(61);
                    String key = (index > 0 ? h.substring(0, index) : h).trim();
                    if (key.equalsIgnoreCase(QueryHints.HINT_LOCAL_QUERY)) {
                        this.local = true;
                        continue;
                    }
                    if (!key.equalsIgnoreCase(QueryHints.HINT_AFFINITY_QUERY)) continue;
                    this.affinityRun = true;
                    this.affinityKey = h.substring(index + 1).trim();
                }
            }
        }

        public boolean isLocal() {
            return this.local;
        }

        public Builder setLocal(boolean local) {
            this.local = local;
            return this;
        }

        public boolean isAffinityRun() {
            return this.affinityRun;
        }

        public Builder setAffinityRun(boolean affinityRun) {
            this.affinityRun = affinityRun;
            return this;
        }

        public Object getAffinityKey() {
            return this.affinityKey;
        }

        public Builder setAffinityKey(Object affinityKey) {
            this.affinityKey = affinityKey;
            return this;
        }

        public QueryHints build() {
            if (this.affinityRun && this.affinityKey == null) {
                throw new HibernateException("AffinityKey can't be null");
            }
            return new QueryHints(this.local, this.affinityRun, this.affinityKey);
        }
    }
}

