/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.ignite.query.parsing.impl;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.hql.ast.spi.AstProcessingChain;
import org.hibernate.hql.ast.spi.AstProcessor;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.ast.spi.QueryRendererDelegate;
import org.hibernate.hql.ast.spi.QueryRendererProcessor;
import org.hibernate.hql.ast.spi.QueryResolverDelegate;
import org.hibernate.hql.ast.spi.QueryResolverProcessor;
import org.hibernate.ogm.datastore.ignite.logging.impl.Log;
import org.hibernate.ogm.datastore.ignite.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.ignite.query.parsing.impl.IgnitePropertyHelper;
import org.hibernate.ogm.datastore.ignite.query.parsing.impl.IgniteQueryParsingResult;
import org.hibernate.ogm.datastore.ignite.query.parsing.impl.IgniteQueryRendererDelegate;
import org.hibernate.ogm.datastore.ignite.query.parsing.impl.IgniteQueryResolverDelegate;

public class IgniteProcessingChain
implements AstProcessingChain<IgniteQueryParsingResult> {
    private static final Log log = LoggerFactory.getLogger();
    private final QueryResolverProcessor resolverProcessor;
    private final QueryRendererProcessor rendererProcessor;
    private final IgniteQueryRendererDelegate rendererDelegate;

    public IgniteProcessingChain(SessionFactoryImplementor sessionFactory, EntityNamesResolver entityNamesResolver, Map<String, Object> namedParameters) {
        IgnitePropertyHelper propertyHelper = new IgnitePropertyHelper(sessionFactory, entityNamesResolver);
        this.resolverProcessor = new QueryResolverProcessor((QueryResolverDelegate)new IgniteQueryResolverDelegate(propertyHelper));
        this.rendererDelegate = new IgniteQueryRendererDelegate(sessionFactory, propertyHelper, entityNamesResolver, namedParameters);
        this.rendererProcessor = new QueryRendererProcessor((QueryRendererDelegate)this.rendererDelegate);
    }

    public Iterator<AstProcessor> iterator() {
        return Arrays.asList(this.resolverProcessor, this.rendererProcessor).iterator();
    }

    public IgniteQueryParsingResult getResult() {
        return this.rendererDelegate.getResult();
    }
}

