/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.ignite.query.parsing.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.ogm.datastore.ignite.logging.impl.Log;
import org.hibernate.ogm.datastore.ignite.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.ignite.query.parsing.impl.PropertyIdentifier;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.persister.impl.OgmCollectionPersister;
import org.hibernate.ogm.persister.impl.OgmEntityPersister;
import org.hibernate.ogm.query.parsing.impl.ParserPropertyHelper;
import org.hibernate.ogm.util.impl.ArrayHelper;
import org.hibernate.ogm.util.impl.StringHelper;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.type.AssociationType;
import org.hibernate.type.Type;

public class IgnitePropertyHelper
extends ParserPropertyHelper {
    private static final Log log = LoggerFactory.getLogger();
    private final Map<String, String> aliasByEntityName = new HashMap<String, String>();

    public IgnitePropertyHelper(SessionFactoryImplementor sessionFactory, EntityNamesResolver entityNames) {
        super(sessionFactory, entityNames);
    }

    public Object convertToBackendType(String entityType, List<String> propertyPath, Object value) {
        return value == PropertyIdentifier.PARAM_INSTANCE ? value : super.convertToBackendType(entityType, propertyPath, value);
    }

    public PropertyIdentifier getPropertyIdentifier(String entityType, List<String> propertyPath) {
        String entityAlias = this.findAliasForType(entityType);
        String propertyEntityType = entityType;
        String propertyAlias = entityAlias;
        ArrayList<String> currentPropertyPath = new ArrayList<String>();
        List lastAssociationPath = Collections.emptyList();
        OgmEntityPersister currentPersister = this.getPersister(entityType);
        int requiredDepth = propertyPath.size();
        boolean isLastElementAssociation = false;
        int depth = 1;
        for (String property : propertyPath) {
            boolean optionalMatch;
            currentPropertyPath.add(property);
            Type currentPropertyType = this.getPropertyType(entityType, currentPropertyPath);
            boolean bl = optionalMatch = depth > requiredDepth;
            if (currentPropertyType.isAssociationType()) {
                AssociationType associationPropertyType = (AssociationType)currentPropertyType;
                Joinable associatedJoinable = associationPropertyType.getAssociatedJoinable(this.getSessionFactory());
                if (associatedJoinable.isCollection() && ((OgmCollectionPersister)associatedJoinable).getType().isComponentType()) {
                    throw new NotYetImplementedException();
                }
                isLastElementAssociation = false;
            } else {
                if (currentPropertyType.isComponentType() && !this.isIdProperty(currentPersister, propertyPath.subList(lastAssociationPath.size(), propertyPath.size()))) {
                    throw new NotYetImplementedException();
                }
                isLastElementAssociation = false;
            }
            ++depth;
        }
        String propertyName = isLastElementAssociation ? this.getSessionFactory().getEntityPersister(propertyEntityType).getIdentifierPropertyName() : this.getColumnName(propertyEntityType, propertyPath.subList(lastAssociationPath.size(), propertyPath.size()));
        return new PropertyIdentifier(propertyAlias, propertyName);
    }

    public String getColumnName(String entityType, List<String> propertyPathWithoutAlias) {
        return this.getColumnName(this.getPersister(entityType), propertyPathWithoutAlias);
    }

    private String getColumnName(OgmEntityPersister persister, List<String> propertyPathWithoutAlias) {
        String columnName = this.getColumn(persister, propertyPathWithoutAlias);
        if (this.isNestedProperty(propertyPathWithoutAlias)) {
            columnName = columnName.substring(columnName.lastIndexOf(46) + 1, columnName.length());
        }
        return columnName;
    }

    public boolean isIdProperty(OgmEntityPersister persister, List<String> namesWithoutAlias) {
        String join = StringHelper.join(namesWithoutAlias, (String)".");
        Type propertyType = persister.getPropertyType(namesWithoutAlias.get(0));
        Object[] identifierColumnNames = persister.getIdentifierColumnNames();
        if (propertyType.isComponentType()) {
            String[] embeddedColumnNames;
            for (String embeddedColumn : embeddedColumnNames = persister.getPropertyColumnNames(join)) {
                if (ArrayHelper.contains((Object[])identifierColumnNames, (Object)embeddedColumn)) continue;
                return false;
            }
            return true;
        }
        return ArrayHelper.contains((Object[])identifierColumnNames, (Object)join);
    }

    public EntityKeyMetadata getKeyMetaData(String entityType) {
        OgmEntityPersister persister = (OgmEntityPersister)this.getSessionFactory().getEntityPersister(entityType);
        return persister.getEntityKeyMetadata();
    }

    private boolean isLetter(int c) {
        return this.isUpperCaseLetter(c) || this.isLowerCaseLetter(c);
    }

    private boolean isUpperCaseLetter(int c) {
        return c >= 65 && c <= 90;
    }

    private boolean isLowerCaseLetter(int c) {
        return c >= 97 && c <= 122;
    }

    private boolean isNumber(int c) {
        return c >= 48 && c <= 57;
    }

    public void registerEntityAlias(String entityName, String alias) {
        StringBuilder sb = new StringBuilder(alias);
        for (int i = 0; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            if (c == '_' || this.isLetter(c) || i > 0 && this.isNumber(c)) continue;
            sb.setCharAt(i, '_');
        }
        this.aliasByEntityName.put(entityName, sb.toString());
    }

    public String findAliasForType(String entityType) {
        return this.aliasByEntityName.get(entityType);
    }
}

