/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.ignite.query.parsing.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.hql.ast.origin.hql.resolve.path.PropertyPath;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.ast.spi.PropertyHelper;
import org.hibernate.hql.ast.spi.SingleEntityQueryBuilder;
import org.hibernate.hql.ast.spi.SingleEntityQueryRendererDelegate;
import org.hibernate.hql.ast.spi.predicate.PredicateFactory;
import org.hibernate.ogm.datastore.ignite.query.impl.IgniteQueryDescriptor;
import org.hibernate.ogm.datastore.ignite.query.parsing.impl.IgnitePropertyHelper;
import org.hibernate.ogm.datastore.ignite.query.parsing.impl.IgniteQueryParsingResult;
import org.hibernate.ogm.datastore.ignite.query.parsing.impl.OrderByClause;
import org.hibernate.ogm.datastore.ignite.query.parsing.impl.PropertyIdentifier;
import org.hibernate.ogm.datastore.ignite.query.parsing.predicate.impl.IgnitePredicateFactory;
import org.hibernate.ogm.persister.impl.OgmEntityPersister;

public class IgniteQueryRendererDelegate
extends SingleEntityQueryRendererDelegate<StringBuilder, IgniteQueryParsingResult> {
    private static final List<String> ENTITY_COLUMN_NAMES = Collections.unmodifiableList(Arrays.asList("_KEY", "_VALUE"));
    private final IgnitePropertyHelper propertyHelper;
    private final SessionFactoryImplementor sessionFactory;
    private final Map<String, Object> namedParamsWithValues;
    private List<Object> indexedParameters;
    private List<OrderByClause> orderByExpressions;

    public IgniteQueryRendererDelegate(SessionFactoryImplementor sessionFactory, IgnitePropertyHelper propertyHelper, EntityNamesResolver entityNamesResolver, Map<String, Object> namedParameters) {
        super((PropertyHelper)propertyHelper, entityNamesResolver, SingleEntityQueryBuilder.getInstance((PredicateFactory)new IgnitePredicateFactory(propertyHelper), (PropertyHelper)propertyHelper), (Map)(namedParameters != null ? NamedParametersMap.INSTANCE : null));
        this.propertyHelper = propertyHelper;
        this.sessionFactory = sessionFactory;
        this.namedParamsWithValues = namedParameters;
    }

    public void setPropertyPath(PropertyPath propertyPath) {
        this.propertyPath = propertyPath;
    }

    private void where(StringBuilder queryBuilder) {
        StringBuilder where = (StringBuilder)this.builder.build();
        if (where != null && where.length() > 0) {
            queryBuilder.append(" WHERE ").append((CharSequence)where);
        }
    }

    private void orderBy(StringBuilder queryBuilder) {
        if (this.orderByExpressions != null && !this.orderByExpressions.isEmpty()) {
            queryBuilder.append(" ORDER BY ");
            int counter = 1;
            for (OrderByClause orderBy : this.orderByExpressions) {
                orderBy.asString(queryBuilder);
                if (counter++ >= this.orderByExpressions.size()) continue;
                queryBuilder.append(", ");
            }
        }
    }

    private void select(StringBuilder queryBuilder) {
        String tableAlias = this.propertyHelper.findAliasForType(this.targetTypeName);
        if (tableAlias.trim().length() > 0) {
            tableAlias = tableAlias + ".";
        }
        queryBuilder.append(String.format("SELECT %s_KEY, %s_VAL ", tableAlias, tableAlias));
    }

    private void from(StringBuilder queryBuilder) {
        String tableAlias = this.propertyHelper.findAliasForType(this.targetTypeName);
        OgmEntityPersister persister = (OgmEntityPersister)this.sessionFactory.getEntityPersister(this.targetType.getName());
        String tableName = this.propertyHelper.getKeyMetaData(this.targetType.getName()).getTable();
        queryBuilder.append(" FROM ").append(tableName).append(' ').append(tableAlias).append(' ');
    }

    public IgniteQueryParsingResult getResult() {
        StringBuilder queryBuilder = new StringBuilder();
        this.select(queryBuilder);
        this.from(queryBuilder);
        this.where(queryBuilder);
        this.orderBy(queryBuilder);
        boolean hasScalar = false;
        IgniteQueryDescriptor queryDescriptor = new IgniteQueryDescriptor(queryBuilder.toString(), this.indexedParameters, hasScalar);
        return new IgniteQueryParsingResult(queryDescriptor, ENTITY_COLUMN_NAMES);
    }

    protected void addSortField(PropertyPath propertyPath, String collateName, boolean isAscending) {
        if (this.orderByExpressions == null) {
            this.orderByExpressions = new ArrayList<OrderByClause>();
        }
        List propertyPathWithoutAlias = this.resolveAlias(propertyPath);
        PropertyIdentifier identifier = this.propertyHelper.getPropertyIdentifier(this.targetTypeName, propertyPathWithoutAlias);
        OrderByClause order = new OrderByClause(identifier.getAlias(), identifier.getPropertyName(), isAscending);
        this.orderByExpressions.add(order);
    }

    private void fillIndexedParams(String param) {
        if (param.startsWith(":")) {
            Object paramValue;
            if (this.indexedParameters == null) {
                this.indexedParameters = new ArrayList<Object>();
            }
            if ((paramValue = this.namedParamsWithValues.get(param.substring(1))) != null && paramValue.getClass().isEnum()) {
                paramValue = ((Enum)paramValue).ordinal();
            }
            this.indexedParameters.add(paramValue);
        }
    }

    public void predicateLess(String comparativePredicate) {
        this.fillIndexedParams(comparativePredicate);
        super.predicateLess(comparativePredicate);
    }

    public void predicateLessOrEqual(String comparativePredicate) {
        this.fillIndexedParams(comparativePredicate);
        super.predicateLessOrEqual(comparativePredicate);
    }

    public void predicateEquals(String comparativePredicate) {
        this.fillIndexedParams(comparativePredicate);
        super.predicateEquals(comparativePredicate);
    }

    public void predicateNotEquals(String comparativePredicate) {
        this.fillIndexedParams(comparativePredicate);
        super.predicateNotEquals(comparativePredicate);
    }

    public void predicateGreaterOrEqual(String comparativePredicate) {
        this.fillIndexedParams(comparativePredicate);
        super.predicateGreaterOrEqual(comparativePredicate);
    }

    public void predicateGreater(String comparativePredicate) {
        this.fillIndexedParams(comparativePredicate);
        super.predicateGreater(comparativePredicate);
    }

    public void predicateBetween(String lower, String upper) {
        this.fillIndexedParams(lower);
        this.fillIndexedParams(upper);
        super.predicateBetween(lower, upper);
    }

    public void predicateLike(String patternValue, Character escapeCharacter) {
        this.fillIndexedParams(patternValue);
        super.predicateLike(patternValue, escapeCharacter);
    }

    public void predicateIn(List<String> list) {
        for (String s : list) {
            this.fillIndexedParams(s);
        }
        super.predicateIn(list);
    }

    private static class NamedParametersMap
    implements Map<String, Object> {
        public static final NamedParametersMap INSTANCE = new NamedParametersMap();

        private NamedParametersMap() {
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public boolean containsKey(Object key) {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public Object get(Object key) {
            return PropertyIdentifier.PARAM_INSTANCE;
        }

        @Override
        public Object put(String key, Object value) {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public Object remove(Object key) {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> m) {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public Set<String> keySet() {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public Collection<Object> values() {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            throw new UnsupportedOperationException("Not supported");
        }
    }
}

