/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.ignite.query.parsing.predicate.impl;

import org.hibernate.hql.ast.spi.predicate.ComparisonPredicate;
import org.hibernate.hql.ast.spi.predicate.NegatablePredicate;
import org.hibernate.ogm.datastore.ignite.query.parsing.predicate.impl.PredicateHelper;

public class IgniteComparisonPredicate
extends ComparisonPredicate<StringBuilder>
implements NegatablePredicate<StringBuilder> {
    private final String alias;
    private final StringBuilder builder;

    public IgniteComparisonPredicate(StringBuilder builder, String alias, String propertyName, ComparisonPredicate.Type comparisonType, Object value) {
        super(propertyName, comparisonType, value);
        this.builder = builder;
        this.alias = alias;
    }

    protected StringBuilder getStrictlyLessQuery() {
        return this.comparison(" < ");
    }

    protected StringBuilder getLessOrEqualsQuery() {
        return this.comparison(" <= ");
    }

    protected StringBuilder getEqualsQuery() {
        return this.comparison(" = ");
    }

    private StringBuilder getNotEqualsQuery() {
        return this.comparison(" <> ");
    }

    protected StringBuilder getGreaterOrEqualsQuery() {
        return this.comparison(" >= ");
    }

    protected StringBuilder getStrictlyGreaterQuery() {
        return this.comparison(" > ");
    }

    public StringBuilder getNegatedQuery() {
        switch (this.type) {
            case LESS: {
                return this.getGreaterOrEqualsQuery();
            }
            case LESS_OR_EQUAL: {
                return this.getStrictlyGreaterQuery();
            }
            case EQUALS: {
                return this.getNotEqualsQuery();
            }
            case GREATER_OR_EQUAL: {
                return this.getStrictlyLessQuery();
            }
            case GREATER: {
                return this.getLessOrEqualsQuery();
            }
        }
        throw new UnsupportedOperationException("Unsupported comparison type: " + this.type);
    }

    private StringBuilder comparison(String operator) {
        PredicateHelper.identifier(this.builder, this.alias, this.propertyName);
        this.builder.append(operator);
        PredicateHelper.literal(this.builder, this.value);
        return this.builder;
    }
}

