/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.ignite.query.parsing.predicate.impl;

import java.util.List;
import org.hibernate.hql.ast.spi.predicate.InPredicate;
import org.hibernate.hql.ast.spi.predicate.NegatablePredicate;
import org.hibernate.ogm.datastore.ignite.query.parsing.predicate.impl.PredicateHelper;

public class IgniteInPredicate
extends InPredicate<StringBuilder>
implements NegatablePredicate<StringBuilder> {
    private final StringBuilder builder;
    private final String alias;

    public IgniteInPredicate(StringBuilder builder, String alias, String propertyName, List<Object> values) {
        super(propertyName, values);
        this.builder = builder;
        this.alias = alias;
    }

    public StringBuilder getQuery() {
        this.query("IN");
        return this.builder;
    }

    private void query(String command) {
        PredicateHelper.identifier(this.builder, this.alias, this.propertyName);
        this.builder.append(' ').append(command).append(" (");
        for (int i = 0; i < this.values.size(); ++i) {
            PredicateHelper.literal(this.builder, this.values.get(i));
            if (i >= this.values.size() - 1) continue;
            this.builder.append(',');
        }
        this.builder.append(')');
    }

    public StringBuilder getNegatedQuery() {
        this.builder.append('(');
        PredicateHelper.identifier(this.builder, this.alias, this.propertyName);
        this.builder.append(" IS NULL OR ");
        this.query("NOT IN");
        this.builder.append(')');
        return this.builder;
    }
}

