/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.ignite.query.parsing.predicate.impl;

import java.util.List;
import org.hibernate.hql.ast.spi.predicate.ComparisonPredicate;
import org.hibernate.hql.ast.spi.predicate.ConjunctionPredicate;
import org.hibernate.hql.ast.spi.predicate.DisjunctionPredicate;
import org.hibernate.hql.ast.spi.predicate.InPredicate;
import org.hibernate.hql.ast.spi.predicate.IsNullPredicate;
import org.hibernate.hql.ast.spi.predicate.LikePredicate;
import org.hibernate.hql.ast.spi.predicate.NegationPredicate;
import org.hibernate.hql.ast.spi.predicate.PredicateFactory;
import org.hibernate.hql.ast.spi.predicate.RangePredicate;
import org.hibernate.hql.ast.spi.predicate.RootPredicate;
import org.hibernate.ogm.datastore.ignite.query.parsing.impl.IgnitePropertyHelper;
import org.hibernate.ogm.datastore.ignite.query.parsing.impl.PropertyIdentifier;
import org.hibernate.ogm.datastore.ignite.query.parsing.predicate.impl.IgniteComparisonPredicate;
import org.hibernate.ogm.datastore.ignite.query.parsing.predicate.impl.IgniteConjunctionPredicate;
import org.hibernate.ogm.datastore.ignite.query.parsing.predicate.impl.IgniteDisjunctionPredicate;
import org.hibernate.ogm.datastore.ignite.query.parsing.predicate.impl.IgniteInPredicate;
import org.hibernate.ogm.datastore.ignite.query.parsing.predicate.impl.IgniteIsNullPredicate;
import org.hibernate.ogm.datastore.ignite.query.parsing.predicate.impl.IgniteLikePredicate;
import org.hibernate.ogm.datastore.ignite.query.parsing.predicate.impl.IgniteNegationPredicate;
import org.hibernate.ogm.datastore.ignite.query.parsing.predicate.impl.IgniteRangePredicate;
import org.hibernate.ogm.datastore.ignite.query.parsing.predicate.impl.IgniteRootPredicate;

public class IgnitePredicateFactory
implements PredicateFactory<StringBuilder> {
    private final StringBuilder builder = new StringBuilder();
    private final IgnitePropertyHelper propertyHelper;

    public IgnitePredicateFactory(IgnitePropertyHelper propertyHelper) {
        this.propertyHelper = propertyHelper;
    }

    public RootPredicate<StringBuilder> getRootPredicate(String entityType) {
        return new IgniteRootPredicate();
    }

    public ComparisonPredicate<StringBuilder> getComparisonPredicate(String entityType, ComparisonPredicate.Type comparisonType, List<String> propertyPath, Object value) {
        PropertyIdentifier identifier = this.propertyHelper.getPropertyIdentifier(entityType, propertyPath);
        return new IgniteComparisonPredicate(this.builder, identifier.getAlias(), identifier.getPropertyName(), comparisonType, value);
    }

    public InPredicate<StringBuilder> getInPredicate(String entityType, List<String> propertyPath, List<Object> typedElements) {
        PropertyIdentifier identifier = this.propertyHelper.getPropertyIdentifier(entityType, propertyPath);
        return new IgniteInPredicate(this.builder, identifier.getAlias(), identifier.getPropertyName(), typedElements);
    }

    public RangePredicate<StringBuilder> getRangePredicate(String entityType, List<String> propertyPath, Object lowerValue, Object upperValue) {
        PropertyIdentifier identifier = this.propertyHelper.getPropertyIdentifier(entityType, propertyPath);
        return new IgniteRangePredicate(this.builder, identifier.getAlias(), identifier.getPropertyName(), lowerValue, upperValue);
    }

    public NegationPredicate<StringBuilder> getNegationPredicate() {
        return new IgniteNegationPredicate(this.builder);
    }

    public DisjunctionPredicate<StringBuilder> getDisjunctionPredicate() {
        return new IgniteDisjunctionPredicate(this.builder);
    }

    public ConjunctionPredicate<StringBuilder> getConjunctionPredicate() {
        return new IgniteConjunctionPredicate(this.builder);
    }

    public LikePredicate<StringBuilder> getLikePredicate(String entityType, List<String> propertyPath, String patternValue, Character escapeCharacter) {
        PropertyIdentifier identifier = this.propertyHelper.getPropertyIdentifier(entityType, propertyPath);
        return new IgniteLikePredicate(this.builder, identifier.getAlias(), identifier.getPropertyName(), patternValue, escapeCharacter);
    }

    public IsNullPredicate<StringBuilder> getIsNullPredicate(String entityType, List<String> propertyPath) {
        PropertyIdentifier identifier = this.propertyHelper.getPropertyIdentifier(entityType, propertyPath);
        return new IgniteIsNullPredicate(this.builder, identifier.getAlias(), identifier.getPropertyName());
    }
}

