/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.ignite.transaction.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.hibernate.HibernateException;
import org.hibernate.ogm.datastore.ignite.logging.impl.Log;
import org.hibernate.ogm.datastore.ignite.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.ignite.transaction.impl.ApplicationServer;
import org.hibernate.ogm.datastore.ignite.transaction.impl.WebSphereTransaction;

public class DelegatingTransactionManager
implements TransactionManager {
    private static final Log log = LoggerFactory.getLogger();
    private static final String WAS_TRANSACTION_MANAGER_CLASS_NAME = "com.ibm.tx.jta.impl.TranManagerSet";
    private static final String WAS_TRANSACTION_MANAGER_METHOD_NAME = "instance";
    private static final String JBOSS_TRANSACTION_MANAGER_JNDI_NAME = "java:jboss/TransactionManager";
    private static volatile TransactionManager INSTANCE;
    private final TransactionManager delegate;
    private final ApplicationServer selectedApplicationServer;

    public DelegatingTransactionManager(TransactionManager delegate, ApplicationServer applicationServer) {
        this.delegate = delegate;
        this.selectedApplicationServer = applicationServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TransactionManager transactionManager() {
        if (INSTANCE != null) return INSTANCE;
        Class<DelegatingTransactionManager> clazz = DelegatingTransactionManager.class;
        synchronized (DelegatingTransactionManager.class) {
            if (INSTANCE != null) return INSTANCE;
            try {
                TransactionManager delegate = null;
                ApplicationServer applicationServer = ApplicationServer.currentApplicationServer();
                switch (applicationServer) {
                    case WEBSPHERE: {
                        delegate = DelegatingTransactionManager.initWebSphereTransactionManager();
                        break;
                    }
                    case JBOSS: {
                        delegate = DelegatingTransactionManager.initJBossTransactionManager();
                        break;
                    }
                    default: {
                        throw log.unsupportedApplicationServer();
                    }
                }
                INSTANCE = new DelegatingTransactionManager(delegate, applicationServer);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException | NamingException e) {
                throw new HibernateException("Cannot instantiate TransactionManager", (Throwable)e);
            }
            return INSTANCE;
        }
    }

    public void begin() throws NotSupportedException, SystemException {
        this.delegate.begin();
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.delegate.commit();
    }

    public int getStatus() throws SystemException {
        return this.delegate.getStatus();
    }

    public Transaction getTransaction() throws SystemException {
        Transaction transaction = this.delegate.getTransaction();
        if (this.selectedApplicationServer == ApplicationServer.WEBSPHERE) {
            return transaction != null ? new WebSphereTransaction(transaction) : null;
        }
        return transaction;
    }

    public void resume(Transaction tobj) throws InvalidTransactionException, IllegalStateException, SystemException {
        this.delegate.resume(tobj);
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.delegate.rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.delegate.setRollbackOnly();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this.delegate.setTransactionTimeout(seconds);
    }

    public Transaction suspend() throws SystemException {
        return this.delegate.suspend();
    }

    private static TransactionManager initWebSphereTransactionManager() throws ClassNotFoundException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class<?> clazz = Class.forName(WAS_TRANSACTION_MANAGER_CLASS_NAME);
        Method m = clazz.getMethod(WAS_TRANSACTION_MANAGER_METHOD_NAME, null);
        TransactionManager transactionManager = (TransactionManager)m.invoke(null, (Object[])null);
        return transactionManager;
    }

    private static TransactionManager initJBossTransactionManager() throws NamingException {
        InitialContext initialContext = new InitialContext();
        TransactionManager transactionManager = (TransactionManager)initialContext.lookup(JBOSS_TRANSACTION_MANAGER_JNDI_NAME);
        return transactionManager;
    }
}

