/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.ignite.transaction.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.hibernate.ogm.datastore.ignite.transaction.impl.DelegatingInvocationHandler;

public class WebSphereTransaction
implements Transaction {
    private static final String ONE_PHASE_XA_RESOURCE_CLASS_NAME = "com.ibm.tx.jta.OnePhaseXAResource";
    private static volatile Class<?> onePhaseXAResourceClass;
    private final Transaction delegate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public WebSphereTransaction(Transaction delegate) {
        this.delegate = delegate;
        if (onePhaseXAResourceClass != null) return;
        Class<WebSphereTransaction> clazz = WebSphereTransaction.class;
        synchronized (WebSphereTransaction.class) {
            if (onePhaseXAResourceClass != null) return;
            try {
                onePhaseXAResourceClass = Class.forName(ONE_PHASE_XA_RESOURCE_CLASS_NAME);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Cannot instantiate Transaction");
            }
            return;
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.delegate.commit();
    }

    public boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
        return this.delegate.delistResource(xaRes, flag);
    }

    public boolean enlistResource(XAResource xaResource) throws RollbackException, IllegalStateException, SystemException {
        if (xaResource == null) {
            return false;
        }
        return this.delegate.enlistResource((XAResource)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{onePhaseXAResourceClass}, (InvocationHandler)new DelegatingInvocationHandler(xaResource)));
    }

    public int getStatus() throws SystemException {
        return this.delegate.getStatus();
    }

    public void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
        this.delegate.registerSynchronization(sync);
    }

    public void rollback() throws IllegalStateException, SystemException {
        this.delegate.rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.delegate.setRollbackOnly();
    }
}

