/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.cfg;

import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.ogm.OgmSessionFactory;
import org.hibernate.ogm.cfg.Configurable;
import org.hibernate.ogm.cfg.impl.ConfigurableImpl;
import org.hibernate.ogm.cfg.impl.OgmNamingStrategy;
import org.hibernate.ogm.datastore.spi.DatastoreConfiguration;
import org.hibernate.ogm.hibernatecore.impl.OgmSessionFactoryImpl;
import org.hibernate.ogm.options.navigation.GlobalContext;

public class OgmConfiguration
extends Configuration
implements Configurable {
    public OgmConfiguration() {
        this.resetOgm();
    }

    private void resetOgm() {
        super.setNamingStrategy(OgmNamingStrategy.INSTANCE);
        this.setProperty("hibernate.ogm._activate", "true");
        this.setProperty("hibernate.query.startup_check", "false");
        this.setProperty("hibernate.search.massindexer.factoryclass", "org.hibernate.ogm.massindex.OgmMassIndexerFactory");
    }

    @Deprecated
    public OgmSessionFactory buildSessionFactory() throws HibernateException {
        return new OgmSessionFactoryImpl((SessionFactoryImplementor)super.buildSessionFactory());
    }

    public Configuration setProperties(Properties properties) {
        super.setProperties(properties);
        if (!properties.containsKey("hibernate.ogm._activate")) {
            this.setProperty("hibernate.ogm._activate", "true");
        }
        if (!properties.containsKey("hibernate.query.startup_check")) {
            this.setProperty("hibernate.query.startup_check", "false");
        }
        if (!properties.containsKey("hibernate.search.massindexer.factoryclass")) {
            this.setProperty("hibernate.search.massindexer.factoryclass", "org.hibernate.ogm.massindex.OgmMassIndexerFactory");
        }
        return this;
    }

    @Override
    public <D extends DatastoreConfiguration<G>, G extends GlobalContext<?, ?>> G configureOptionsFor(Class<D> datastoreType) {
        ConfigurableImpl configurable = new ConfigurableImpl();
        this.getProperties().put("hibernate.ogm.options.context", configurable.getContext());
        return configurable.configureOptionsFor(datastoreType);
    }
}

