/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect.impl;

import java.lang.reflect.Constructor;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.DuplicationStrategy;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.ogm.datastore.spi.DatastoreProvider;
import org.hibernate.ogm.dialect.BatchOperationsDelegator;
import org.hibernate.ogm.dialect.BatchableGridDialect;
import org.hibernate.ogm.dialect.GridDialect;
import org.hibernate.ogm.dialect.GridDialectLogger;
import org.hibernate.ogm.service.impl.AutoFlushBatchManagerEventListener;
import org.hibernate.ogm.service.impl.FlushBatchManagerEventListener;
import org.hibernate.ogm.util.configurationreader.impl.ConfigurationPropertyReader;
import org.hibernate.ogm.util.configurationreader.impl.Instantiator;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.SessionFactoryServiceInitiator;

public class GridDialectInitiator
implements SessionFactoryServiceInitiator<GridDialect> {
    public static final SessionFactoryServiceInitiator<GridDialect> INSTANCE = new GridDialectInitiator();
    private static final Log log = LoggerFactory.make();

    public Class<GridDialect> getServiceInitiated() {
        return GridDialect.class;
    }

    public GridDialect initiateService(SessionFactoryImplementor sessionFactory, Configuration configuration, ServiceRegistryImplementor registry) {
        DatastoreProvider datastore = (DatastoreProvider)registry.getService(DatastoreProvider.class);
        ConfigurationPropertyReader propertyReader = new ConfigurationPropertyReader(configuration, (ClassLoaderService)registry.getService(ClassLoaderService.class));
        return (GridDialect)propertyReader.property("hibernate.ogm.datastore.grid_dialect", GridDialect.class).instantiate().withDefaultImplementation(((DatastoreProvider)registry.getService(DatastoreProvider.class)).getDefaultDialect()).withInstantiator(new GridDialectInstantiator(datastore, (EventListenerRegistry)registry.getService(EventListenerRegistry.class))).getValue();
    }

    public GridDialect initiateService(SessionFactoryImplementor sessionFactory, MetadataImplementor metadata, ServiceRegistryImplementor registry) {
        throw new UnsupportedOperationException("Cannot create " + GridDialect.class.getName() + " service using metadata");
    }

    private static class GridDialectInstantiator
    implements Instantiator<GridDialect> {
        private final DatastoreProvider datastore;
        private final EventListenerRegistry eventListenerRegistry;

        public GridDialectInstantiator(DatastoreProvider datastore, EventListenerRegistry eventListenerRegistry) {
            this.datastore = datastore;
            this.eventListenerRegistry = eventListenerRegistry;
        }

        @Override
        public GridDialect newInstance(Class<? extends GridDialect> clazz) {
            try {
                GridDialect gridDialect;
                Constructor<?> injector = null;
                for (Constructor<?> constructor : clazz.getConstructors()) {
                    Class<?>[] parameterTypes = constructor.getParameterTypes();
                    if (parameterTypes.length != 1 || !DatastoreProvider.class.isAssignableFrom(parameterTypes[0])) continue;
                    injector = constructor;
                    break;
                }
                if (injector == null) {
                    log.gridDialectHasNoProperConstructor(clazz);
                }
                if ((gridDialect = (GridDialect)injector.newInstance(this.datastore)) instanceof BatchableGridDialect) {
                    BatchOperationsDelegator delegator = new BatchOperationsDelegator((BatchableGridDialect)gridDialect);
                    this.addListeners(delegator);
                    gridDialect = delegator;
                }
                log.useGridDialect(gridDialect.getClass().getName());
                if (GridDialectLogger.activationNeeded()) {
                    gridDialect = new GridDialectLogger(gridDialect);
                    log.info("Grid dialect logs are active");
                } else {
                    log.info("Grid dialect logs are disabled");
                }
                return gridDialect;
            }
            catch (Exception e) {
                throw log.cannotInstantiateGridDialect(clazz, e);
            }
        }

        private void addListeners(BatchOperationsDelegator gridDialect) {
            this.eventListenerRegistry.addDuplicationStrategy((DuplicationStrategy)new FlushBatchManagerEventListener.FlushDuplicationStrategy());
            this.eventListenerRegistry.addDuplicationStrategy((DuplicationStrategy)new AutoFlushBatchManagerEventListener.AutoFlushDuplicationStrategy());
            this.eventListenerRegistry.getEventListenerGroup(EventType.FLUSH).appendListener((Object)new FlushBatchManagerEventListener(gridDialect));
            this.eventListenerRegistry.getEventListenerGroup(EventType.AUTO_FLUSH).appendListener((Object)new AutoFlushBatchManagerEventListener(gridDialect));
        }
    }
}

