/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.hibernatecore.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.Query;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.engine.query.spi.ParameterMetadata;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.AbstractQueryImpl;
import org.hibernate.ogm.exception.NotSupportedException;
import org.hibernate.ogm.hibernatecore.impl.OgmSession;
import org.hibernate.ogm.service.impl.QueryParserService;

public class OgmQuery
extends AbstractQueryImpl {
    private final OgmSession session;
    private final QueryParserService queryParserService;
    private final LockOptions lockOptions = new LockOptions();

    public OgmQuery(String queryString, FlushMode flushMode, OgmSession session, ParameterMetadata parameterMetadata, QueryParserService queryParserService) {
        super(queryString, flushMode, (SessionImplementor)session, parameterMetadata);
        this.session = session;
        this.queryParserService = queryParserService;
    }

    public Iterator iterate() throws HibernateException {
        return this.getExecutingQuery().iterate();
    }

    public ScrollableResults scroll() throws HibernateException {
        return this.getExecutingQuery().scroll();
    }

    public ScrollableResults scroll(ScrollMode scrollMode) throws HibernateException {
        return this.getExecutingQuery().scroll(scrollMode);
    }

    public List list() throws HibernateException {
        return this.getExecutingQuery().list();
    }

    private Query getExecutingQuery() {
        Map<String, Object> namedParameters = this.toUntypedParameters();
        return this.queryParserService.getParsedQueryExecutor(this.session, this.getQueryString(), namedParameters);
    }

    private Map<String, Object> toUntypedParameters() {
        return new HashMap<String, Object>(this.getNamedParams());
    }

    public int executeUpdate() throws HibernateException {
        throw new NotSupportedException("TBD", "QueryQuery#executeUpdate not implemented");
    }

    public Query setLockMode(String alias, LockMode lockMode) {
        this.lockOptions.setAliasSpecificLockMode(alias, lockMode);
        return this;
    }

    public Query setLockOptions(LockOptions lockOption) {
        this.lockOptions.setLockMode(lockOption.getLockMode());
        this.lockOptions.setScope(lockOption.getScope());
        this.lockOptions.setTimeOut(lockOption.getTimeOut());
        return this;
    }

    public LockOptions getLockOptions() {
        return this.lockOptions;
    }
}

