/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.hibernatecore.impl;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.hibernate.Cache;
import org.hibernate.CustomEntityDirtinessStrategy;
import org.hibernate.EntityNameResolver;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.MappingException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.StatelessSession;
import org.hibernate.StatelessSessionBuilder;
import org.hibernate.TypeHelper;
import org.hibernate.cache.spi.QueryCache;
import org.hibernate.cache.spi.Region;
import org.hibernate.cache.spi.UpdateTimestampsCache;
import org.hibernate.cfg.Settings;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.SQLFunctionRegistry;
import org.hibernate.engine.ResultSetMappingDefinition;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.profile.FetchProfile;
import org.hibernate.engine.query.spi.QueryPlanCache;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.engine.spi.NamedQueryDefinition;
import org.hibernate.engine.spi.NamedSQLQueryDefinition;
import org.hibernate.engine.spi.SessionBuilderImplementor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.exception.spi.SQLExceptionConverter;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.internal.NamedQueryRepository;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.metadata.CollectionMetadata;
import org.hibernate.ogm.OgmSessionFactory;
import org.hibernate.ogm.exception.NotSupportedException;
import org.hibernate.ogm.hibernatecore.impl.OgmSession;
import org.hibernate.ogm.hibernatecore.impl.OgmSessionBuilderDelegator;
import org.hibernate.ogm.hibernatecore.impl.OgmSessionFactoryObjectFactory;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.EntityNotFoundDelegate;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.stat.Statistics;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.type.Type;
import org.hibernate.type.TypeResolver;

public class OgmSessionFactoryImpl
implements SessionFactoryImplementor,
OgmSessionFactory {
    private final SessionFactoryImplementor delegate;

    public OgmSessionFactoryImpl(SessionFactoryImplementor delegate) {
        this.delegate = delegate;
    }

    public TypeResolver getTypeResolver() {
        return this.delegate.getTypeResolver();
    }

    public Properties getProperties() {
        return this.delegate.getProperties();
    }

    public EntityPersister getEntityPersister(String entityName) throws MappingException {
        return this.delegate.getEntityPersister(entityName);
    }

    public Map<String, EntityPersister> getEntityPersisters() {
        return this.delegate.getEntityPersisters();
    }

    public CollectionPersister getCollectionPersister(String role) throws MappingException {
        return this.delegate.getCollectionPersister(role);
    }

    public Map<String, CollectionPersister> getCollectionPersisters() {
        return this.delegate.getCollectionPersisters();
    }

    public JdbcServices getJdbcServices() {
        return this.delegate.getJdbcServices();
    }

    public Dialect getDialect() {
        return this.delegate.getDialect();
    }

    public Interceptor getInterceptor() {
        return this.delegate.getInterceptor();
    }

    public QueryPlanCache getQueryPlanCache() {
        return this.delegate.getQueryPlanCache();
    }

    public Type[] getReturnTypes(String queryString) throws HibernateException {
        return this.delegate.getReturnTypes(queryString);
    }

    public String[] getReturnAliases(String queryString) throws HibernateException {
        return this.delegate.getReturnAliases(queryString);
    }

    @Deprecated
    public ConnectionProvider getConnectionProvider() {
        return this.delegate.getConnectionProvider();
    }

    public String[] getImplementors(String className) throws MappingException {
        return this.delegate.getImplementors(className);
    }

    public String getImportedClassName(String name) {
        return this.delegate.getImportedClassName(name);
    }

    public QueryCache getQueryCache() {
        return this.delegate.getQueryCache();
    }

    public QueryCache getQueryCache(String regionName) throws HibernateException {
        return this.delegate.getQueryCache(regionName);
    }

    public UpdateTimestampsCache getUpdateTimestampsCache() {
        return this.delegate.getUpdateTimestampsCache();
    }

    public StatisticsImplementor getStatisticsImplementor() {
        return this.delegate.getStatisticsImplementor();
    }

    public NamedQueryDefinition getNamedQuery(String queryName) {
        return this.delegate.getNamedQuery(queryName);
    }

    public NamedSQLQueryDefinition getNamedSQLQuery(String queryName) {
        return this.delegate.getNamedSQLQuery(queryName);
    }

    public NamedQueryRepository getNamedQueryRepository() {
        return this.delegate.getNamedQueryRepository();
    }

    public void registerNamedQueryDefinition(String name, NamedQueryDefinition definition) {
        this.delegate.registerNamedQueryDefinition(name, definition);
    }

    public void registerNamedSQLQueryDefinition(String name, NamedSQLQueryDefinition definition) {
        this.delegate.registerNamedSQLQueryDefinition(name, definition);
    }

    public ResultSetMappingDefinition getResultSetMapping(String name) {
        return this.delegate.getResultSetMapping(name);
    }

    public IdentifierGenerator getIdentifierGenerator(String rootEntityName) {
        return this.delegate.getIdentifierGenerator(rootEntityName);
    }

    public Region getSecondLevelCacheRegion(String regionName) {
        return this.delegate.getSecondLevelCacheRegion(regionName);
    }

    public Map getAllSecondLevelCacheRegions() {
        return this.delegate.getAllSecondLevelCacheRegions();
    }

    public SQLExceptionConverter getSQLExceptionConverter() {
        return this.delegate.getSQLExceptionConverter();
    }

    public SqlExceptionHelper getSQLExceptionHelper() {
        return this.delegate.getSQLExceptionHelper();
    }

    public Settings getSettings() {
        return this.delegate.getSettings();
    }

    public Session openTemporarySession() throws HibernateException {
        return new OgmSession(this, (EventSource)this.delegate.openTemporarySession());
    }

    public Set<String> getCollectionRolesByEntityParticipant(String entityName) {
        return this.delegate.getCollectionRolesByEntityParticipant(entityName);
    }

    public EntityNotFoundDelegate getEntityNotFoundDelegate() {
        return this.delegate.getEntityNotFoundDelegate();
    }

    public SQLFunctionRegistry getSqlFunctionRegistry() {
        return this.delegate.getSqlFunctionRegistry();
    }

    public FetchProfile getFetchProfile(String name) {
        return this.delegate.getFetchProfile(name);
    }

    public ServiceRegistryImplementor getServiceRegistry() {
        return this.delegate.getServiceRegistry();
    }

    public void addObserver(SessionFactoryObserver observer) {
        this.delegate.addObserver(observer);
    }

    public IdentifierGeneratorFactory getIdentifierGeneratorFactory() {
        return this.delegate.getIdentifierGeneratorFactory();
    }

    public Type getIdentifierType(String className) throws MappingException {
        return this.delegate.getIdentifierType(className);
    }

    public String getIdentifierPropertyName(String className) throws MappingException {
        return this.delegate.getIdentifierPropertyName(className);
    }

    public Type getReferencedPropertyType(String className, String propertyName) throws MappingException {
        return this.delegate.getReferencedPropertyType(className, propertyName);
    }

    public SessionFactory.SessionFactoryOptions getSessionFactoryOptions() {
        return this.delegate.getSessionFactoryOptions();
    }

    public SessionBuilderImplementor withOptions() {
        return new OgmSessionBuilderDelegator(this.delegate.withOptions(), this);
    }

    public Session openSession() throws HibernateException {
        Session session = this.delegate.openSession();
        return new OgmSession(this, (EventSource)session);
    }

    public Session getCurrentSession() throws HibernateException {
        Session session = this.delegate.getCurrentSession();
        return new OgmSession(this, (EventSource)session);
    }

    public StatelessSessionBuilder withStatelessOptions() {
        throw new NotSupportedException("OGM-18", "Stateless session is not implemented in OGM");
    }

    public StatelessSession openStatelessSession() {
        throw new NotSupportedException("OGM-18", "Stateless session is not implemented in OGM");
    }

    public StatelessSession openStatelessSession(Connection connection) {
        throw new NotSupportedException("OGM-18", "Stateless session is not implemented in OGM");
    }

    public ClassMetadata getClassMetadata(Class entityClass) {
        return this.delegate.getClassMetadata(entityClass);
    }

    public ClassMetadata getClassMetadata(String entityName) {
        return this.delegate.getClassMetadata(entityName);
    }

    public CollectionMetadata getCollectionMetadata(String roleName) {
        return this.delegate.getCollectionMetadata(roleName);
    }

    public Map<String, ClassMetadata> getAllClassMetadata() {
        return this.delegate.getAllClassMetadata();
    }

    public Map getAllCollectionMetadata() {
        return this.delegate.getAllCollectionMetadata();
    }

    public Statistics getStatistics() {
        return this.delegate.getStatistics();
    }

    public void close() throws HibernateException {
        this.delegate.close();
    }

    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    public Cache getCache() {
        return this.delegate.getCache();
    }

    @Deprecated
    public void evict(Class persistentClass) throws HibernateException {
        this.delegate.evict(persistentClass);
    }

    @Deprecated
    public void evict(Class persistentClass, Serializable id) throws HibernateException {
        this.delegate.evict(persistentClass, id);
    }

    @Deprecated
    public void evictEntity(String entityName) throws HibernateException {
        this.delegate.evictEntity(entityName);
    }

    @Deprecated
    public void evictEntity(String entityName, Serializable id) throws HibernateException {
        this.delegate.evictEntity(entityName, id);
    }

    @Deprecated
    public void evictCollection(String roleName) throws HibernateException {
        this.delegate.evictCollection(roleName);
    }

    @Deprecated
    public void evictCollection(String roleName, Serializable id) throws HibernateException {
        this.delegate.evictCollection(roleName, id);
    }

    @Deprecated
    public void evictQueries(String cacheRegion) throws HibernateException {
        this.delegate.evictQueries(cacheRegion);
    }

    @Deprecated
    public void evictQueries() throws HibernateException {
        this.delegate.evictQueries();
    }

    public Set getDefinedFilterNames() {
        return this.delegate.getDefinedFilterNames();
    }

    public FilterDefinition getFilterDefinition(String filterName) throws HibernateException {
        return this.delegate.getFilterDefinition(filterName);
    }

    public boolean containsFetchProfileDefinition(String name) {
        return this.delegate.containsFetchProfileDefinition(name);
    }

    public TypeHelper getTypeHelper() {
        return this.delegate.getTypeHelper();
    }

    public CurrentTenantIdentifierResolver getCurrentTenantIdentifierResolver() {
        return this.delegate.getCurrentTenantIdentifierResolver();
    }

    public Region getNaturalIdCacheRegion(String regionName) {
        return this.delegate.getNaturalIdCacheRegion(regionName);
    }

    public CustomEntityDirtinessStrategy getCustomEntityDirtinessStrategy() {
        return this.delegate.getCustomEntityDirtinessStrategy();
    }

    public Reference getReference() throws NamingException {
        String uuid = String.valueOf(this.delegate.getReference().get(0).getContent());
        return new Reference(OgmSessionFactoryImpl.class.getName(), new StringRefAddr("uuid", uuid), OgmSessionFactoryObjectFactory.class.getName(), null);
    }

    public Iterable<EntityNameResolver> iterateEntityNameResolvers() {
        return this.delegate.iterateEntityNameResolvers();
    }
}

