/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.loader.nativeloader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.engine.query.spi.sql.NativeSQLQueryReturn;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.custom.CustomQuery;
import org.hibernate.loader.custom.sql.SQLQueryReturnProcessor;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;

public class BackendCustomQuery
implements CustomQuery {
    private static final Log LOG = LoggerFactory.make();
    private final String query;
    private final Set<Object> querySpaces = new HashSet<Object>();
    private final Map<Object, Object> namedParameterBindPoints = new HashMap<Object, Object>();
    private final List<Object> customQueryReturns = new ArrayList<Object>();

    public BackendCustomQuery(String nosqlQuery, NativeSQLQueryReturn[] queryReturns, Collection<?> additionalQuerySpaces, SessionFactoryImplementor factory) throws HibernateException {
        LOG.tracev("Starting processing of NoSQL query [{0}]", nosqlQuery);
        SQLQueryReturnProcessor processor = new SQLQueryReturnProcessor(queryReturns, factory);
        processor.process();
        List customReturns = processor.generateCustomReturns(false);
        this.customQueryReturns.addAll(customReturns);
        this.query = nosqlQuery;
        if (additionalQuerySpaces != null) {
            this.querySpaces.addAll(additionalQuerySpaces);
        }
    }

    public String getSQL() {
        return this.query;
    }

    public Set getQuerySpaces() {
        return this.querySpaces;
    }

    public Map getNamedParameterBindPoints() {
        return this.namedParameterBindPoints;
    }

    public List getCustomQueryReturns() {
        return this.customQueryReturns;
    }
}

